/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.CellStyle;
import jet.export.excel.api.ExcelCell;
import jet.export.excel.api.HyperLink;
import jet.export.excel.imp.xlsx.CellStyleImp;
import jet.export.excel.imp.xlsx.Link;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.Util;

public abstract class Cell
implements ExcelCell {
    private int add;
    private short append;
    private CellStyleImp colNumToStr;
    private int dump = -1;
    private int dumpValue = 1;
    private short load = 1;
    private Link loadValue;
    private boolean readBoolean = false;
    private Cell readInt;
    private Cell readShort;

    public Cell(int n, short s) {
        this.add = n;
        this.append = s;
    }

    void setNextCell(Cell cell) {
        this.readInt = cell;
    }

    Cell getNextCell() {
        return this.readInt;
    }

    void setPrevCell(Cell cell) {
        this.readShort = cell;
    }

    Cell getPrevCell() {
        return this.readShort;
    }

    public short getColSpan() {
        return this.load;
    }

    public int getRowSpan() {
        return this.dumpValue;
    }

    public void merge(int n, short s) {
        this.dumpValue = n;
        this.load = s;
    }

    public void setHyperLink(Link link) {
        this.loadValue = link;
    }

    @Override
    public HyperLink getHyperLink() {
        return this.loadValue;
    }

    public CellStyleImp getStyle() {
        return this.colNumToStr;
    }

    void setStyleIdx(int n) {
        this.dump = n;
        this.colNumToStr = null;
    }

    public int getRowNum() {
        return this.add;
    }

    public short getColNum() {
        return this.append;
    }

    void write(XMLStreamWriter xMLStreamWriter, Links links, Merges merges, boolean bl) throws XlsxDocumentException {
        try {
            if (this.dumpValue > 1 || this.load > 1) {
                merges.add(new Object[]{new int[]{this.add, this.add + this.dumpValue - 1}, new short[]{this.append, (short)(this.append + this.load - 1)}});
            }
            if (this.loadValue != null) {
                links.add(new Object[]{this.add, this.append, this.loadValue});
            }
            xMLStreamWriter.writeStartElement("c");
            if (bl) {
                xMLStreamWriter.writeAttribute("r", Util.colNumToStr(this.append) + (this.add + 1));
            }
            if (this.dump != -1) {
                xMLStreamWriter.writeAttribute("s", String.valueOf(this.dump));
            }
            this.writeValue(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    void dump(DataOutput dataOutput) throws IOException {
        this.dumpValue(dataOutput);
        dataOutput.writeInt(this.dump);
        dataOutput.writeInt(this.dumpValue);
        dataOutput.writeShort(this.load);
        if (this.loadValue != null) {
            dataOutput.writeBoolean(true);
            this.loadValue.dump(dataOutput);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    void load(DataInput dataInput) throws IOException {
        this.loadValue(dataInput);
        this.dump = dataInput.readInt();
        this.dumpValue = dataInput.readInt();
        this.load = dataInput.readShort();
        if (dataInput.readBoolean()) {
            this.loadValue = new Link();
            this.loadValue.load(dataInput);
        }
        this.readBoolean = true;
    }

    static void skip(DataInput dataInput) throws IOException {
        dataInput.readInt();
        dataInput.readInt();
        dataInput.readShort();
        if (dataInput.readBoolean()) {
            Link.skip(dataInput);
        }
    }

    boolean isFromTempFile() {
        return this.readBoolean;
    }

    @Override
    public void setCellStyle(CellStyle cellStyle) {
        this.colNumToStr = (CellStyleImp)cellStyle;
    }

    @Override
    public void setColSpan(int n) {
        this.load = (short)n;
    }

    @Override
    public void setHyperLink(HyperLink hyperLink) {
        this.loadValue = (Link)hyperLink;
    }

    @Override
    public void setRowSpan(int n) {
        this.dumpValue = n;
    }

    @Override
    public CellStyle getCellStyle() {
        return this.colNumToStr;
    }

    @Override
    public int getCol() {
        return this.append;
    }

    @Override
    public int getRow() {
        return this.add;
    }

    abstract void writeValue(XMLStreamWriter var1) throws XMLStreamException;

    abstract void dumpValue(DataOutput var1) throws IOException;

    abstract void loadValue(DataInput var1) throws IOException;
}

