/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

public class CellBorder {
    int topStyle = Integer.MAX_VALUE;
    int bottomStyle = Integer.MAX_VALUE;
    int leftStyle = Integer.MAX_VALUE;
    int rightStyle = Integer.MAX_VALUE;
    boolean isTopColorSet = false;
    boolean isBottomColorSet = false;
    boolean isLeftColorSet = false;
    boolean isRightColorSet = false;
    int topColor = -16777216;
    int bottomColor = -16777216;
    int leftColor = -16777216;
    int rightColor = -16777216;

    public void setTopStyle(int n) {
        this.topStyle = n;
    }

    public void setBottomStyle(int n) {
        this.bottomStyle = (byte)n;
    }

    public void setLeftStyle(int n) {
        this.leftStyle = n;
    }

    public void setRightStyle(int n) {
        this.rightStyle = n;
    }

    public void setTopColor(int n) {
        this.topColor = n;
        this.isTopColorSet = true;
    }

    public void setBottomColor(int n) {
        this.bottomColor = n;
        this.isBottomColorSet = true;
    }

    public void setLeftColor(int n) {
        this.leftColor = n;
        this.isLeftColorSet = true;
    }

    public void setRightColor(int n) {
        this.rightColor = n;
        this.isRightColorSet = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellBorder)) {
            return false;
        }
        CellBorder cellBorder = (CellBorder)object;
        if (cellBorder.topStyle != this.topStyle) {
            return false;
        }
        if (cellBorder.bottomStyle != this.bottomStyle) {
            return false;
        }
        if (cellBorder.leftStyle != this.leftStyle) {
            return false;
        }
        if (cellBorder.rightStyle != this.rightStyle) {
            return false;
        }
        if (cellBorder.isTopColorSet != this.isTopColorSet) {
            return false;
        }
        if (cellBorder.topColor != this.topColor) {
            return false;
        }
        if (cellBorder.isBottomColorSet != this.isBottomColorSet) {
            return false;
        }
        if (cellBorder.bottomColor != this.bottomColor) {
            return false;
        }
        if (cellBorder.isLeftColorSet != this.isLeftColorSet) {
            return false;
        }
        if (cellBorder.leftColor != this.leftColor) {
            return false;
        }
        if (cellBorder.isRightColorSet != this.isRightColorSet) {
            return false;
        }
        return cellBorder.rightColor == this.rightColor;
    }

    public int hashCode() {
        return this.topStyle + this.bottomStyle + this.leftStyle + this.rightStyle + (this.isTopColorSet ? 1 : 0) + this.topColor + (this.isBottomColorSet ? 1 : 0) + this.bottomColor + (this.isLeftColorSet ? 1 : 0) + this.leftColor + (this.isRightColorSet ? 1 : 0) + this.rightColor;
    }

    private void write(XMLStreamWriter xMLStreamWriter, int n, boolean bl, int n2) throws XlsxDocumentException {
        try {
            if (n != Integer.MAX_VALUE) {
                switch (n) {
                    case 0: {
                        xMLStreamWriter.writeAttribute("style", "none");
                        break;
                    }
                    case 1: {
                        xMLStreamWriter.writeAttribute("style", "thin");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("style", "medium");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("style", "dashed");
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeAttribute("style", "dotted");
                        break;
                    }
                    case 5: {
                        xMLStreamWriter.writeAttribute("style", "thick");
                        break;
                    }
                    case 6: {
                        xMLStreamWriter.writeAttribute("style", "double");
                        break;
                    }
                    case 7: {
                        xMLStreamWriter.writeAttribute("style", "hair");
                        break;
                    }
                    case 8: {
                        xMLStreamWriter.writeAttribute("style", "mediumDashed");
                        break;
                    }
                    case 9: {
                        xMLStreamWriter.writeAttribute("style", "dashDot");
                        break;
                    }
                    case 10: {
                        xMLStreamWriter.writeAttribute("style", "mediumDashDot");
                        break;
                    }
                    case 11: {
                        xMLStreamWriter.writeAttribute("style", "dashDotDot");
                        break;
                    }
                    case 12: {
                        xMLStreamWriter.writeAttribute("style", "mediumDashDotDot");
                        break;
                    }
                    case 13: {
                        xMLStreamWriter.writeAttribute("style", "slantDashDot");
                    }
                }
            }
            if (bl) {
                xMLStreamWriter.writeEmptyElement("color");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(n2));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    void write(XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("border");
            xMLStreamWriter.writeStartElement("left");
            this.write(xMLStreamWriter, this.leftStyle, this.isLeftColorSet, this.leftColor);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("right");
            this.write(xMLStreamWriter, this.rightStyle, this.isRightColorSet, this.rightColor);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("top");
            this.write(xMLStreamWriter, this.topStyle, this.isTopColorSet, this.topColor);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("bottom");
            this.write(xMLStreamWriter, this.bottomStyle, this.isBottomColorSet, this.bottomColor);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }
}

