/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.ExcelFont;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

public class CellFont
implements ExcelFont {
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    double size = 11.0;
    String name = "Arial";
    int color = -16777216;
    boolean isColorSet = false;
    boolean isBold = false;
    boolean isItalic = false;
    byte underline = (byte)-1;
    boolean strike = false;
    short superSubScript = 0;

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeDouble(this.size);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.isColorSet);
        dataOutputStream.writeBoolean(this.isBold);
        dataOutputStream.writeBoolean(this.isItalic);
        dataOutputStream.writeByte(this.underline);
        dataOutputStream.writeBoolean(this.strike);
        dataOutputStream.writeShort(this.superSubScript);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.size = dataInputStream.readDouble();
        this.name = dataInputStream.readUTF();
        this.color = dataInputStream.readInt();
        this.isColorSet = dataInputStream.readBoolean();
        this.isBold = dataInputStream.readBoolean();
        this.isItalic = dataInputStream.readBoolean();
        this.underline = dataInputStream.readByte();
        this.strike = dataInputStream.readBoolean();
        this.superSubScript = dataInputStream.readShort();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellFont)) {
            return false;
        }
        CellFont cellFont = (CellFont)object;
        if (cellFont.size != this.size) {
            return false;
        }
        if (!cellFont.name.equals(this.name)) {
            return false;
        }
        if (cellFont.isColorSet != this.isColorSet) {
            return false;
        }
        if (cellFont.color != this.color) {
            return false;
        }
        if (cellFont.isBold != this.isBold) {
            return false;
        }
        if (cellFont.isItalic != this.isItalic) {
            return false;
        }
        if (cellFont.underline != this.underline) {
            return false;
        }
        if (cellFont.strike != this.strike) {
            return false;
        }
        return cellFont.superSubScript == this.superSubScript;
    }

    public int hashCode() {
        return (int)this.size + this.name.hashCode() + (this.isColorSet ? 1 : 0) + this.color + (this.isBold ? 1 : 0) + (this.isItalic ? 1 : 0) + this.underline + (this.strike ? 1 : 0) + this.superSubScript;
    }

    void write(String string, String string2, XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement(string);
            xMLStreamWriter.writeEmptyElement("sz");
            xMLStreamWriter.writeAttribute("val", String.valueOf(this.size));
            if (this.name.length() > 0) {
                xMLStreamWriter.writeEmptyElement(string2);
                xMLStreamWriter.writeAttribute("val", this.name);
            }
            if (this.isColorSet) {
                xMLStreamWriter.writeEmptyElement("color");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(this.color));
            }
            if (this.isBold) {
                xMLStreamWriter.writeEmptyElement("b");
            }
            if (this.isItalic) {
                xMLStreamWriter.writeEmptyElement("i");
            }
            if (this.underline != -1) {
                switch (this.underline) {
                    case 2: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "double");
                        break;
                    }
                    case 34: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "doubleAccounting");
                        break;
                    }
                    case 0: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "none");
                        break;
                    }
                    case 1: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "single");
                        break;
                    }
                    case 33: {
                        xMLStreamWriter.writeEmptyElement("u");
                        xMLStreamWriter.writeAttribute("val", "singleAccounting");
                    }
                }
            }
            if (this.strike) {
                xMLStreamWriter.writeEmptyElement("strike");
            }
            if (this.superSubScript != 0) {
                switch (this.superSubScript) {
                    case 1: {
                        xMLStreamWriter.writeEmptyElement("vertAlign");
                        xMLStreamWriter.writeAttribute("val", "superscript");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeEmptyElement("vertAlign");
                        xMLStreamWriter.writeAttribute("val", "subscript");
                    }
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("The parameter name can not be null.");
        }
        this.name = string;
    }

    public void setColor(int n) {
        this.color = n;
        this.isColorSet = true;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    public void setIsBold(boolean bl) {
        this.isBold = bl;
    }

    @Override
    public void setIsItalic(boolean bl) {
        this.isItalic = bl;
    }

    @Override
    public void setUnderline(byte by) {
        this.underline = by;
    }

    @Override
    public void setIsStruckout(boolean bl) {
        this.strike = bl;
    }

    @Override
    public void setFontColor(Color color) {
        this.color = color.getRGB();
        this.isColorSet = true;
    }

    @Override
    public void setSuperSubScript(short s) {
        this.superSubScript = s;
    }

    @Override
    public void setIsOutline(boolean bl) {
    }

    @Override
    public void setIsShadow(boolean bl) {
    }
}

