/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.CellPattern;
import jet.export.excel.imp.xlsx.CellFillImp;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

public class CellPatternFill
extends CellFillImp
implements CellPattern {
    short pattern = Short.MAX_VALUE;
    boolean isFgColorSet = false;
    boolean isBgColorSet = false;
    int fgColor = -1;
    int bgColor = -16777216;

    public void setPattern(short s) {
        this.pattern = s;
    }

    public void setForegroundColor(int n) {
        this.fgColor = n;
        this.isFgColorSet = true;
    }

    public void setBackgroundColor(int n) {
        this.bgColor = n;
        this.isBgColorSet = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellPatternFill)) {
            return false;
        }
        CellPatternFill cellPatternFill = (CellPatternFill)object;
        if (cellPatternFill.pattern != this.pattern) {
            return false;
        }
        if (cellPatternFill.isFgColorSet != this.isFgColorSet) {
            return false;
        }
        if (cellPatternFill.fgColor != this.fgColor) {
            return false;
        }
        if (cellPatternFill.isBgColorSet != this.isBgColorSet) {
            return false;
        }
        return cellPatternFill.bgColor == this.bgColor;
    }

    public int hashCode() {
        return this.pattern + (this.isFgColorSet ? (short)1 : 0) + this.fgColor + (this.isBgColorSet ? 1 : 0) + this.bgColor;
    }

    @Override
    void write(XMLStreamWriter xMLStreamWriter) throws XlsxDocumentException {
        try {
            xMLStreamWriter.writeStartElement("fill");
            xMLStreamWriter.writeStartElement("patternFill");
            if (this.pattern != Short.MAX_VALUE) {
                switch (this.pattern) {
                    case 0: {
                        xMLStreamWriter.writeAttribute("patternType", "none");
                        break;
                    }
                    case 1: {
                        xMLStreamWriter.writeAttribute("patternType", "solid");
                        break;
                    }
                    case 2: {
                        xMLStreamWriter.writeAttribute("patternType", "mediumGray");
                        break;
                    }
                    case 3: {
                        xMLStreamWriter.writeAttribute("patternType", "darkGray");
                        break;
                    }
                    case 4: {
                        xMLStreamWriter.writeAttribute("patternType", "lightGray");
                        break;
                    }
                    case 5: {
                        xMLStreamWriter.writeAttribute("patternType", "darkHorizontal");
                        break;
                    }
                    case 6: {
                        xMLStreamWriter.writeAttribute("patternType", "darkVertical");
                        break;
                    }
                    case 7: {
                        xMLStreamWriter.writeAttribute("patternType", "darkDown");
                        break;
                    }
                    case 8: {
                        xMLStreamWriter.writeAttribute("patternType", "darkUp");
                        break;
                    }
                    case 9: {
                        xMLStreamWriter.writeAttribute("patternType", "darkGrid");
                        break;
                    }
                    case 10: {
                        xMLStreamWriter.writeAttribute("patternType", "darkTrellis");
                        break;
                    }
                    case 11: {
                        xMLStreamWriter.writeAttribute("patternType", "lightHorizontal");
                        break;
                    }
                    case 12: {
                        xMLStreamWriter.writeAttribute("patternType", "lightVertical");
                        break;
                    }
                    case 13: {
                        xMLStreamWriter.writeAttribute("patternType", "lightDown");
                        break;
                    }
                    case 14: {
                        xMLStreamWriter.writeAttribute("patternType", "lightUp");
                        break;
                    }
                    case 15: {
                        xMLStreamWriter.writeAttribute("patternType", "lightGrid");
                        break;
                    }
                    case 16: {
                        xMLStreamWriter.writeAttribute("patternType", "lightTrellis");
                        break;
                    }
                    case 17: {
                        xMLStreamWriter.writeAttribute("patternType", "gray125");
                        break;
                    }
                    case 18: {
                        xMLStreamWriter.writeAttribute("patternType", "gray0625");
                    }
                }
            }
            if (this.isFgColorSet) {
                xMLStreamWriter.writeEmptyElement("fgColor");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(this.fgColor));
            }
            if (this.isBgColorSet) {
                xMLStreamWriter.writeEmptyElement("bgColor");
                xMLStreamWriter.writeAttribute("rgb", Integer.toHexString(this.bgColor));
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }
}

