/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.Cell;
import jet.export.excel.imp.xlsx.InnerRow;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.RandomAccessFileWrapper;

class CellsBlock {
    private int SEDU;
    private int addCell;
    private int append;
    private InnerRow[][] close;
    private int currentTimeMillis = 0;
    private short dump = (short)-1;
    private short get = (short)-1;
    private int getColNum = -1;
    private int getNextRow = -1;
    private int getPrevRow = 0;
    private static final int getRaFile = 100;

    public CellsBlock(int n, int n2, int n3) {
        this.SEDU = n;
        this.addCell = n2;
        this.append = n3;
        int n4 = this.addCell - this.SEDU + 1;
        int n5 = n4 / 100 + (n4 % 100 == 0 ? 0 : 1);
        this.close = new InnerRow[n5][];
    }

    public int getSheetId() {
        return this.append;
    }

    public int getStartRow() {
        return this.SEDU;
    }

    public int addCell(Cell cell) {
        int n = cell.getRowNum();
        short s = cell.getColNum();
        if (this.dump < s) {
            this.dump = s;
        }
        if (this.get > s || this.get == -1) {
            this.get = s;
        }
        InnerRow innerRow = this.SEDU(n);
        int n2 = innerRow.addCell(cell);
        this.getPrevRow += n2;
        return n2;
    }

    private InnerRow SEDU(int n) {
        if (this.getNextRow < n) {
            this.getNextRow = n;
        }
        if (this.getColNum > n || this.getColNum == -1) {
            this.getColNum = n;
        }
        return this.addCell(n);
    }

    private InnerRow addCell(int n) {
        InnerRow innerRow = null;
        int n2 = (n - this.SEDU) / 100;
        InnerRow[] innerRowArray = this.close[n2];
        if (innerRowArray == null) {
            innerRow = new InnerRow(n);
            innerRowArray = new InnerRow[]{innerRow, innerRow};
            this.close[n2] = innerRowArray;
            return innerRow;
        }
        int n3 = innerRowArray[1].getRowNum();
        if (n3 == n) {
            return innerRowArray[1];
        }
        if (n3 < n) {
            InnerRow innerRow2 = null;
            while (n3 < n) {
                innerRow2 = innerRowArray[1].getNextRow();
                if (innerRow2 == null) {
                    innerRow = new InnerRow(n);
                    innerRow.setPrevRow(innerRowArray[1]);
                    innerRowArray[1].setNextRow(innerRow);
                    innerRowArray[1] = innerRow;
                    return innerRow;
                }
                n3 = innerRow2.getRowNum();
                innerRowArray[1] = innerRow2;
            }
            if (n3 == n) {
                return innerRowArray[1];
            }
            innerRow = new InnerRow(n);
            innerRow2 = innerRowArray[1].getPrevRow();
            innerRow2.setNextRow(innerRow);
            innerRow.setPrevRow(innerRow2);
            innerRow.setNextRow(innerRowArray[1]);
            innerRowArray[1].setPrevRow(innerRow);
            innerRowArray[1] = innerRow;
            return innerRow;
        }
        InnerRow innerRow3 = null;
        while (n3 > n) {
            innerRow3 = innerRowArray[1].getPrevRow();
            if (innerRow3 == null) {
                innerRow = new InnerRow(n);
                innerRow.setNextRow(innerRowArray[1]);
                innerRowArray[1].setPrevRow(innerRow);
                innerRowArray[0] = innerRow;
                innerRowArray[1] = innerRow;
                return innerRow;
            }
            n3 = innerRow3.getRowNum();
            innerRowArray[1] = innerRow3;
        }
        if (n3 == n) {
            return innerRowArray[1];
        }
        innerRow = new InnerRow(n);
        innerRow3 = innerRowArray[1].getNextRow();
        innerRow3.setPrevRow(innerRow);
        innerRow.setNextRow(innerRow3);
        innerRow.setPrevRow(innerRowArray[1]);
        innerRowArray[1].setNextRow(innerRow);
        innerRowArray[1] = innerRow;
        return innerRow;
    }

    public short getMinColNum() {
        return this.get;
    }

    public short getMaxColNum() {
        return this.dump;
    }

    public int getMinRowNum() {
        return this.getColNum;
    }

    public int getMaxRowNum() {
        return this.getNextRow;
    }

    public boolean inScope(int n) {
        return n >= this.SEDU && n <= this.addCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dump(RandomAccessFile randomAccessFile) throws IOException, XlsxDocumentException {
        long l = System.currentTimeMillis();
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n2;
            int n3 = n2 = 10000;
            for (int i = 0; i < this.close.length; ++i) {
                if (this.close[i] == null) continue;
                for (InnerRow innerRow = this.close[i][0]; innerRow != null; innerRow = innerRow.getNextRow()) {
                    dataOutputStream.writeInt(innerRow.getRowNum());
                    if ((n += innerRow.dump(dataOutputStream)) < n3) continue;
                    dataOutputStream.writeInt(-1);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    randomAccessFile.writeInt(byArray.length);
                    randomAccessFile.write(byArray);
                    byteArrayOutputStream.reset();
                    n3 = n + n2;
                }
                this.close[i] = null;
            }
            dataOutputStream.writeInt(-1);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            randomAccessFile.writeInt(byArray.length);
            randomAccessFile.write(byArray);
            randomAccessFile.writeInt(-1);
        }
        finally {
            dataOutputStream.close();
        }
        this.currentTimeMillis += n;
        this.getPrevRow -= n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: " + n + " cells are dumped in a cells block " + "whose sheet id is " + this.append + " and start row number is " + this.SEDU + ". " + "The time spent is " + (System.currentTimeMillis() - l) + " ms.");
        }
        return n;
    }

    public int clearCellsInMem() {
        int n = this.getPrevRow;
        for (int i = 0; i < this.close.length; ++i) {
            this.close[i] = null;
        }
        this.getPrevRow = 0;
        return n;
    }

    public int setRowHeight(int n, double d) {
        InnerRow innerRow = this.SEDU(n);
        int n2 = innerRow.setHeight(d);
        this.getPrevRow += n2;
        return n2;
    }

    public int getTotalDumped() {
        return this.currentTimeMillis;
    }

    public int getCellsCountInMem() {
        return this.getPrevRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(RandomAccessFileWrapper randomAccessFileWrapper, Vector vector, int n, int n2) throws IOException {
        long l = System.currentTimeMillis();
        RandomAccessFile randomAccessFile = null;
        if (randomAccessFileWrapper != null) {
            randomAccessFile = randomAccessFileWrapper.getRaFile();
        }
        if (randomAccessFile == null || vector == null) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            long l2 = (Long)vector.get(i);
            randomAccessFile.seek(l2);
            int n4 = randomAccessFile.readInt();
            while (n4 != -1) {
                byte[] byArray = new byte[n4];
                randomAccessFile.read(byArray);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                try {
                    int n5 = -1;
                    while ((n5 = dataInputStream.readInt()) != -1) {
                        if (n5 < n || n5 > n2) {
                            InnerRow.skip(dataInputStream);
                            continue;
                        }
                        n3 += this.addCell(n5).load(dataInputStream);
                    }
                }
                finally {
                    dataInputStream.close();
                }
                n4 = randomAccessFile.readInt();
            }
        }
        this.getPrevRow += n3;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: " + n3 + " cells are loaded in a cells block " + "whose sheet id is " + this.append + " from row " + n + " to row " + n2 + ". " + "The time spent is " + (System.currentTimeMillis() - l) + " ms.");
        }
        return n3;
    }

    void write(XMLStreamWriter xMLStreamWriter, Links links, Merges merges) throws IOException, XlsxDocumentException, XMLStreamException {
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.close.length; ++i) {
            if (this.close[i] == null) continue;
            for (InnerRow innerRow = this.close[i][0]; innerRow != null; innerRow = innerRow.getNextRow()) {
                innerRow.write(xMLStreamWriter, links, merges);
            }
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The cells block whose sheet id is " + this.append + " and start row number is " + this.SEDU + " is writen. " + "The time spent is " + (System.currentTimeMillis() - l) + " ms.");
        }
    }
}

