/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.Cell;
import jet.export.excel.imp.xlsx.CellsBlock;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.RandomAccessFileWrapper;
import jet.export.excel.imp.xlsx.util.TempFilesManager;
import jet.export.excel.imp.xlsx.util.Util;

class CellsBlockManager {
    private int SEDU = 0;
    private CellsBlock add;
    private Hashtable addCell = new Hashtable();
    private int append;
    private TempFilesManager clearCellsInMem;
    private int close;
    private Hashtable createTempRAF = new Hashtable();
    private Hashtable currentTimeMillis = new Hashtable();

    CellsBlockManager(TempFilesManager tempFilesManager, int n, int n2) {
        this.clearCellsInMem = tempFilesManager;
        this.append = n;
        this.close = n2;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The maximum count of cells of the entire workbook in memory is " + this.append);
            JRLog.trace(6, "Xlsx API: The row count of every block of cells is " + this.close);
        }
    }

    private int SEDU(int n) {
        return n / this.close * this.close;
    }

    private int add(CellsBlock cellsBlock, int n) throws IOException, XlsxDocumentException {
        int n2 = 0;
        Enumeration enumeration = this.addCell.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                CellsBlock cellsBlock2 = (CellsBlock)enumeration2.nextElement();
                if (cellsBlock2 == cellsBlock || (n2 += this.addCell(cellsBlock2)) < n) continue;
                return n2;
            }
        }
        return n2 += this.addCell(cellsBlock);
    }

    void writeCells(XMLStreamWriter xMLStreamWriter, Links links, Merges merges, int n) throws IOException, XMLStreamException, XlsxDocumentException {
        Object object;
        Object object2;
        Hashtable hashtable = (Hashtable)this.addCell.get(new Integer(n));
        if (hashtable != null) {
            object2 = hashtable.keySet().toArray();
            Arrays.sort((Object[])object2);
            object = object2;
            int n2 = ((Object)object).length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = object[i];
                CellsBlock cellsBlock = (CellsBlock)hashtable.get((Integer)object3);
                long l = 0L;
                if (JRLog.isTrace(6)) {
                    l = System.currentTimeMillis();
                    JRLog.trace(6, "Xlsx API: Start writing the cells block whose start row number is " + object3 + ".");
                    JRLog.trace(6, "Xlsx API: This cells block has " + cellsBlock.getCellsCountInMem() + " cells in memory, and " + cellsBlock.getTotalDumped() + " cells dumped. " + "The total count of cells is " + (cellsBlock.getCellsCountInMem() + cellsBlock.getTotalDumped()) + ".");
                    JRLog.trace(6, "Xlsx API: This cells block's minimum row number is " + cellsBlock.getMinRowNum() + ", maximum row number is " + cellsBlock.getMaxRowNum() + ", minimum column number is " + cellsBlock.getMinColNum() + ", and maximum column number is " + cellsBlock.getMaxColNum() + ".");
                    JRLog.trace(6, "Xlsx API: The count of cells in memory of all cells blocks is " + this.SEDU);
                }
                if (cellsBlock.getTotalDumped() + this.SEDU < this.append) {
                    this.SEDU += cellsBlock.load(this.createTempRAF(n, false), this.currentTimeMillis(n, (Integer)object3, false), cellsBlock.getMinRowNum(), cellsBlock.getMaxRowNum());
                    cellsBlock.write(xMLStreamWriter, links, merges);
                    this.SEDU -= cellsBlock.clearCellsInMem();
                } else {
                    if (this.SEDU > 0) {
                        this.SEDU -= this.add(cellsBlock, this.SEDU - (this.append - cellsBlock.getTotalDumped()));
                    }
                    if (cellsBlock.getTotalDumped() + this.SEDU < this.append) {
                        this.SEDU += cellsBlock.load(this.createTempRAF(n, false), this.currentTimeMillis(n, (Integer)object3, false), cellsBlock.getMinRowNum(), cellsBlock.getMaxRowNum());
                        cellsBlock.write(xMLStreamWriter, links, merges);
                        this.SEDU -= cellsBlock.clearCellsInMem();
                    } else {
                        int n3 = (this.append - this.SEDU) / (cellsBlock.getMaxColNum() - cellsBlock.getMinColNum() + 1);
                        if (n3 <= 0) {
                            n3 = 1;
                        }
                        for (int j = cellsBlock.getMinRowNum(); j <= cellsBlock.getMaxRowNum(); j += n3) {
                            this.SEDU += cellsBlock.load(this.createTempRAF(n, false), this.currentTimeMillis(n, (Integer)object3, false), j, j + n3 - 1);
                            cellsBlock.write(xMLStreamWriter, links, merges);
                            this.SEDU -= cellsBlock.clearCellsInMem();
                        }
                    }
                }
                if (!JRLog.isTrace(6)) continue;
                JRLog.trace(6, "Xlsx API: Finish writing the cells block whose start row number is " + object3 + ". " + "The time spent is " + (System.currentTimeMillis() - l) + " ms.");
            }
        }
        if ((object2 = this.createTempRAF(n, false)) != null && (object = ((RandomAccessFileWrapper)object2).getRaFile()) != null) {
            ((RandomAccessFile)object).close();
        }
    }

    private int addCell(CellsBlock cellsBlock) throws IOException, XlsxDocumentException {
        if (cellsBlock.getCellsCountInMem() == 0) {
            return 0;
        }
        int n = cellsBlock.getSheetId();
        RandomAccessFileWrapper randomAccessFileWrapper = this.createTempRAF(n, true);
        RandomAccessFile randomAccessFile = randomAccessFileWrapper.getRaFile();
        long l = randomAccessFile.length();
        randomAccessFile.seek(l);
        int n2 = cellsBlock.dump(randomAccessFile);
        long l2 = randomAccessFile.length();
        if (l2 > l) {
            this.currentTimeMillis(n, cellsBlock.getStartRow(), true).add(l);
            try {
                this.clearCellsInMem.getCache().fileUpdated(randomAccessFileWrapper.getFile());
            }
            catch (OutOfSpaceException outOfSpaceException) {
                throw new XlsxDocumentException(outOfSpaceException);
            }
        }
        return n2;
    }

    void addCell(Cell cell, int n) throws IOException, XlsxDocumentException {
        this.append(cell.getRowNum(), n);
        this.SEDU += this.add.addCell(cell);
        if (this.SEDU >= this.append) {
            this.SEDU -= this.add(this.add, (int)((double)this.append * 0.25));
        }
    }

    void setRowHeight(int n, double d, int n2) throws XlsxDocumentException, IOException {
        this.append(n, n2);
        this.SEDU += this.add.setRowHeight(n, d);
        if (this.SEDU >= this.append) {
            this.SEDU -= this.add(this.add, (int)((double)this.append * 0.25));
        }
    }

    private void append(int n, int n2) {
        if (this.add == null) {
            Hashtable<Integer, CellsBlock> hashtable = new Hashtable<Integer, CellsBlock>();
            this.addCell.put(new Integer(n2), hashtable);
            int n3 = this.SEDU(n);
            CellsBlock cellsBlock = this.clearCellsInMem(n3, n2);
            hashtable.put(new Integer(n3), cellsBlock);
            this.close(cellsBlock);
        } else if (this.add.getSheetId() != n2) {
            int n4;
            CellsBlock cellsBlock;
            Hashtable<Integer, CellsBlock> hashtable = (Hashtable<Integer, CellsBlock>)this.addCell.get(new Integer(n2));
            if (hashtable == null) {
                hashtable = new Hashtable<Integer, CellsBlock>();
                this.addCell.put(new Integer(n2), hashtable);
            }
            if ((cellsBlock = (CellsBlock)hashtable.get(new Integer(n4 = this.SEDU(n)))) == null) {
                cellsBlock = this.clearCellsInMem(n4, n2);
                hashtable.put(new Integer(n4), cellsBlock);
            }
            this.close(cellsBlock);
        } else if (!this.add.inScope(n)) {
            int n5;
            Hashtable hashtable = (Hashtable)this.addCell.get(new Integer(n2));
            CellsBlock cellsBlock = (CellsBlock)hashtable.get(new Integer(n5 = this.SEDU(n)));
            if (cellsBlock == null) {
                cellsBlock = this.clearCellsInMem(n5, n2);
                hashtable.put(new Integer(n5), cellsBlock);
            }
            this.close(cellsBlock);
        }
    }

    private CellsBlock clearCellsInMem(int n, int n2) {
        CellsBlock cellsBlock = new CellsBlock(n, n + this.close - 1, n2);
        this.close(cellsBlock);
        return cellsBlock;
    }

    private void close(CellsBlock cellsBlock) {
        this.add = cellsBlock;
    }

    private RandomAccessFileWrapper createTempRAF(int n, boolean bl) throws FileNotFoundException, XlsxDocumentException {
        RandomAccessFileWrapper randomAccessFileWrapper = (RandomAccessFileWrapper)this.createTempRAF.get(n);
        if (bl && randomAccessFileWrapper == null) {
            randomAccessFileWrapper = this.clearCellsInMem.createTempRAF();
            this.createTempRAF.put(n, randomAccessFileWrapper);
        }
        return randomAccessFileWrapper;
    }

    private Vector currentTimeMillis(int n, int n2, boolean bl) {
        long l = Util.makeLong(n, n2);
        Vector vector = (Vector)this.currentTimeMillis.get(l);
        if (bl && vector == null) {
            vector = new Vector();
            this.currentTimeMillis.put(l, vector);
        }
        return vector;
    }
}

