/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.IOException;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.DrawingPart;
import jet.export.excel.imp.xlsx.Link;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.PicturePart;
import jet.export.excel.imp.xlsx.PictureShape;
import jet.export.excel.imp.xlsx.RelsPart;
import jet.export.excel.imp.xlsx.SimpleShape;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.LineStyle;
import jet.export.excel.imp.xlsx.shapeprops.RelativeSizeAnchor;

public class ChartDrawingPart
extends DrawingPart {
    private Vector SEDU = new Vector();

    public ChartDrawingPart(OPCPackage oPCPackage, int n) {
        super(oPCPackage, n);
    }

    public void addSimpleShape(SimpleShape simpleShape, RelativeSizeAnchor relativeSizeAnchor) throws XlsxDocumentException {
        try {
            Link link = simpleShape.getLink();
            this.SEDU.add(new Object[]{(byte)2, relativeSizeAnchor, this.writeLink(link), link == null ? null : link.getToolTip(), simpleShape.getPresetType(), simpleShape.getFillStyle(), simpleShape.getBorder(), simpleShape.getShadow(), simpleShape.getTextBody()});
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    public void addPicture(PictureShape pictureShape, RelativeSizeAnchor relativeSizeAnchor) throws XlsxDocumentException {
        try {
            PicturePart picturePart = this.pack.getPicturePart(pictureShape.getPictureData());
            RelsPart relsPart = this.getRelsPart(true);
            String string = relsPart.addNoneRelsPart(picturePart);
            Link link = pictureShape.getLink();
            this.SEDU.add(new Object[]{(byte)1, string, relativeSizeAnchor, this.writeLink(link), link == null ? null : link.getToolTip(), pictureShape.getBorder(), pictureShape.getColorStyle()});
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void write() throws XlsxDocumentException {
        try {
            XMLStreamWriter xMLStreamWriter = this.pack.createXMLWriter();
            try {
                xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
                xMLStreamWriter.setPrefix("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.setPrefix("cdr", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                xMLStreamWriter.setPrefix("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
                xMLStreamWriter.setPrefix("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                xMLStreamWriter.writeStartElement("c", "userShapes", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeNamespace("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeNamespace("cdr", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                xMLStreamWriter.writeNamespace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
                xMLStreamWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
                int n = 0;
                for (Object[] objectArray : this.SEDU) {
                    byte by = (Byte)objectArray[0];
                    switch (by) {
                        case 1: {
                            String string = (String)objectArray[1];
                            xMLStreamWriter.writeStartElement("cdr", "relSizeAnchor", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                            ((RelativeSizeAnchor)objectArray[2]).write(xMLStreamWriter);
                            this.writePictureRef(xMLStreamWriter, n, string, (String)objectArray[3], (String)objectArray[4], (LineStyle)objectArray[5], (Short)objectArray[6], "cdr", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                            xMLStreamWriter.writeEndElement();
                            ++n;
                            break;
                        }
                        case 2: {
                            xMLStreamWriter.writeStartElement("cdr", "relSizeAnchor", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                            ((RelativeSizeAnchor)objectArray[1]).write(xMLStreamWriter);
                            this.writeSimpleShape(xMLStreamWriter, n, objectArray, false, "cdr", "http://schemas.openxmlformats.org/drawingml/2006/chartDrawing");
                            xMLStreamWriter.writeEndElement();
                            ++n;
                        }
                    }
                }
                xMLStreamWriter.writeEndElement();
                xMLStreamWriter.writeEndDocument();
            }
            finally {
                xMLStreamWriter.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chartUserShapes";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml";
    }
}

