/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.ChartArea;

public class ChartPart
extends NoneRelsPart {
    private int SEDU;

    ChartPart(OPCPackage oPCPackage, int n, ChartArea chartArea) throws IOException, XlsxDocumentException {
        super(oPCPackage, "chart" + n + ".xml");
        this.SEDU = this.SEDU(chartArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int SEDU(ChartArea chartArea) throws IOException, XlsxDocumentException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.pack.getEncoding());
            try {
                XMLStreamWriter xMLStreamWriter = this.pack.getXMLOutputFactory().createXMLStreamWriter(outputStreamWriter);
                try {
                    chartArea.write(this.pack, xMLStreamWriter, this);
                }
                finally {
                    xMLStreamWriter.close();
                }
            }
            finally {
                ((Writer)outputStreamWriter).close();
            }
            return this.pack.getDrawingsTempFile().write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public void write() throws XlsxDocumentException {
        try {
            byte[] byArray = this.pack.getDrawingsTempFile().read(this.SEDU);
            if (byArray != null) {
                this.pack.getZipOutputStream().write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    @Override
    String getPartName() {
        return "/xl/charts/" + this.partNameSuffix;
    }

    @Override
    String getZipItemName() {
        return "xl/charts/" + this.partNameSuffix;
    }

    @Override
    String getExtension() {
        return "xml";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.drawingml.chart+xml";
    }

    @Override
    public String getTargetName() {
        return "../charts/" + this.partNameSuffix;
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart";
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

