/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.BlankCellImp;
import jet.export.excel.imp.xlsx.BooleanCellImp;
import jet.export.excel.imp.xlsx.Cell;
import jet.export.excel.imp.xlsx.FormulaCellImp;
import jet.export.excel.imp.xlsx.LabelCellImp;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.NumberCellImp;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

class InnerRow {
    private int SEDU;
    private double dump = -1.0;
    private Cell error;
    private Cell getCellType;
    private boolean getCol = false;
    private InnerRow getColNum;
    private InnerRow getNextCell;

    public InnerRow(int n) {
        this.SEDU = n;
    }

    public int getRowNum() {
        return this.SEDU;
    }

    public void setNextRow(InnerRow innerRow) {
        this.getColNum = innerRow;
    }

    public InnerRow getNextRow() {
        return this.getColNum;
    }

    public void setPrevRow(InnerRow innerRow) {
        this.getNextCell = innerRow;
    }

    public InnerRow getPrevRow() {
        return this.getNextCell;
    }

    public int setHeight(double d) {
        if (d >= 0.0) {
            if (this.dump == -1.0) {
                this.dump = d;
                this.getCol = false;
                return 1;
            }
            this.dump = d;
            this.getCol = false;
            return 0;
        }
        return 0;
    }

    public double getHeight() {
        return this.dump;
    }

    private void SEDU(Cell cell) {
        if (!cell.isFromTempFile() || this.getCellType.isFromTempFile()) {
            Cell cell2 = this.getCellType.getPrevCell();
            Cell cell3 = this.getCellType.getNextCell();
            if (cell2 == null) {
                this.error = cell;
            } else {
                cell2.setNextCell(cell);
                cell.setPrevCell(cell2);
            }
            if (cell3 != null) {
                cell3.setPrevCell(cell);
                cell.setNextCell(cell3);
            }
            this.getCellType = cell;
        }
    }

    public int addCell(Cell cell) {
        short s = cell.getColNum();
        if (this.getCellType == null) {
            this.error = cell;
            this.getCellType = cell;
            return 1;
        }
        short s2 = this.getCellType.getColNum();
        if (s2 == s) {
            this.SEDU(cell);
            return 0;
        }
        if (s2 < s) {
            Cell cell2 = null;
            while (s2 < s) {
                cell2 = this.getCellType.getNextCell();
                if (cell2 == null) {
                    cell.setPrevCell(this.getCellType);
                    this.getCellType.setNextCell(cell);
                    this.getCellType = cell;
                    return 1;
                }
                s2 = cell2.getColNum();
                this.getCellType = cell2;
            }
            if (s2 == s) {
                this.SEDU(cell);
                return 0;
            }
            cell2 = this.getCellType.getPrevCell();
            cell2.setNextCell(cell);
            cell.setPrevCell(cell2);
            cell.setNextCell(this.getCellType);
            this.getCellType.setPrevCell(cell);
            this.getCellType = cell;
            return 1;
        }
        Cell cell3 = null;
        while (s2 > s) {
            cell3 = this.getCellType.getPrevCell();
            if (cell3 == null) {
                this.getCellType.setPrevCell(cell);
                cell.setNextCell(this.getCellType);
                this.error = cell;
                this.getCellType = cell;
                return 1;
            }
            s2 = cell3.getColNum();
            this.getCellType = cell3;
        }
        if (s2 == s) {
            this.SEDU(cell);
            return 0;
        }
        cell3 = this.getCellType.getNextCell();
        cell3.setPrevCell(cell);
        cell.setNextCell(cell3);
        cell.setPrevCell(this.getCellType);
        this.getCellType.setNextCell(cell);
        this.getCellType = cell;
        return 1;
    }

    public int dump(DataOutput dataOutput) throws IOException {
        int n = 0;
        if (this.dump != -1.0) {
            ++n;
        }
        dataOutput.writeDouble(this.dump);
        for (Cell cell = this.error; cell != null; cell = cell.getNextCell()) {
            dataOutput.write(cell.getCellType());
            dataOutput.writeShort(cell.getColNum());
            cell.dump(dataOutput);
            ++n;
        }
        dataOutput.write(255);
        return n;
    }

    public static void skip(DataInput dataInput) throws IOException {
        dataInput.readDouble();
        byte by = dataInput.readByte();
        while (by != -1) {
            dataInput.readShort();
            switch (by) {
                case 0: {
                    BlankCellImp.skip(dataInput);
                    break;
                }
                case 4: {
                    BooleanCellImp.skip(dataInput);
                    break;
                }
                case 3: {
                    FormulaCellImp.skip(dataInput);
                    break;
                }
                case 2: {
                    LabelCellImp.skip(dataInput);
                    break;
                }
                case 1: {
                    NumberCellImp.skip(dataInput);
                }
            }
            by = dataInput.readByte();
        }
    }

    public int load(DataInput dataInput) throws IOException {
        int n;
        block28: {
            Cell cell;
            block31: {
                Cell cell2;
                block30: {
                    Cell cell3;
                    int n2;
                    block29: {
                        block27: {
                            n = 0;
                            double d = dataInput.readDouble();
                            if (d != -1.0) {
                                if (this.getCol) {
                                    this.dump = d;
                                } else if (this.dump == -1.0) {
                                    this.dump = d;
                                    this.getCol = true;
                                    ++n;
                                }
                            }
                            n2 = 0;
                            cell2 = null;
                            cell3 = null;
                            byte by = dataInput.readByte();
                            while (by != -1) {
                                short s = dataInput.readShort();
                                cell = null;
                                switch (by) {
                                    case 0: {
                                        cell = new BlankCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 4: {
                                        cell = new BooleanCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 3: {
                                        cell = new FormulaCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 2: {
                                        cell = new LabelCellImp(this.SEDU, s);
                                        break;
                                    }
                                    case 1: {
                                        cell = new NumberCellImp(this.SEDU, s);
                                        break;
                                    }
                                    default: {
                                        RuntimeException runtimeException = new RuntimeException("Unknown cell type.");
                                        if (JRLog.isError(1)) {
                                            JRLog.error(1, runtimeException);
                                        }
                                        throw runtimeException;
                                    }
                                }
                                cell.load(dataInput);
                                if (cell2 == null) {
                                    cell2 = cell;
                                } else {
                                    cell3.setNextCell(cell);
                                    cell.setPrevCell(cell3);
                                }
                                cell3 = cell;
                                ++n2;
                                by = dataInput.readByte();
                            }
                            if (cell2 == null) {
                                return n;
                            }
                            if (this.getCellType != null) break block27;
                            this.error = cell2;
                            this.getCellType = cell3;
                            n += n2;
                            break block28;
                        }
                        if (this.getCellType.getNextCell() != null || this.getCellType.getColNum() >= cell2.getColNum()) break block29;
                        this.getCellType.setNextCell(cell2);
                        cell2.setPrevCell(this.getCellType);
                        this.getCellType = cell3;
                        n += n2;
                        break block28;
                    }
                    if (this.error.getColNum() <= cell3.getColNum()) break block30;
                    this.error.setPrevCell(cell3);
                    cell3.setNextCell(this.error);
                    this.error = cell2;
                    n += n2;
                    break block28;
                }
                Cell cell4 = this.error;
                cell = cell2;
                if (cell4.getColNum() < cell.getColNum()) {
                    this.error = cell4;
                    cell4 = cell4.getNextCell();
                } else if (cell4.getColNum() > cell.getColNum()) {
                    this.error = cell;
                    cell = cell.getNextCell();
                    ++n;
                } else {
                    this.error = cell4.isFromTempFile() ? cell : cell4;
                    cell4 = cell4.getNextCell();
                    cell = cell.getNextCell();
                }
                this.getCellType = this.error;
                while (cell4 != null && cell != null) {
                    if (cell4.getColNum() < cell.getColNum()) {
                        this.getCellType.setNextCell(cell4);
                        cell4.setPrevCell(this.getCellType);
                        this.getCellType = cell4;
                        cell4 = cell4.getNextCell();
                        continue;
                    }
                    if (cell4.getColNum() > cell.getColNum()) {
                        this.getCellType.setNextCell(cell);
                        cell.setPrevCell(this.getCellType);
                        this.getCellType = cell;
                        cell = cell.getNextCell();
                        ++n;
                        continue;
                    }
                    if (cell4.isFromTempFile()) {
                        this.getCellType.setNextCell(cell);
                        cell.setPrevCell(this.getCellType);
                        this.getCellType = cell;
                    } else {
                        this.getCellType.setNextCell(cell4);
                        cell4.setPrevCell(this.getCellType);
                        this.getCellType = cell4;
                    }
                    cell4 = cell4.getNextCell();
                    cell = cell.getNextCell();
                }
                if (cell4 == null) break block31;
                this.getCellType.setNextCell(cell4);
                cell4.setPrevCell(this.getCellType);
                this.getCellType = cell4;
                for (cell4 = cell4.getNextCell(); cell4 != null; cell4 = cell4.getNextCell()) {
                    this.getCellType = cell4;
                }
                break block28;
            }
            if (cell == null) break block28;
            this.getCellType.setNextCell(cell);
            cell.setPrevCell(this.getCellType);
            this.getCellType = cell;
            cell = cell.getNextCell();
            ++n;
            while (cell != null) {
                this.getCellType = cell;
                cell = cell.getNextCell();
                ++n;
            }
        }
        return n;
    }

    public void write(XMLStreamWriter xMLStreamWriter, Links links, Merges merges) throws IOException, XMLStreamException, XlsxDocumentException {
        xMLStreamWriter.writeStartElement("row");
        xMLStreamWriter.writeAttribute("r", String.valueOf(this.getRowNum() + 1));
        if (this.dump != -1.0) {
            xMLStreamWriter.writeAttribute("ht", String.valueOf(this.dump));
            xMLStreamWriter.writeAttribute("customHeight", "1");
        }
        int n = -2;
        int n2 = -1;
        for (Cell cell = this.error; cell != null; cell = cell.getNextCell()) {
            n2 = cell.getCol();
            cell.write(xMLStreamWriter, links, merges, n + 1 < n2);
            n = n2;
        }
        xMLStreamWriter.writeEndElement();
    }
}

