/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.CellFont;
import jet.export.excel.imp.xlsx.CellRichTextRun;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.TempFilesManager;

class SharedStringsPart
extends NoneRelsPart {
    private Hashtable SEDU;
    private Vector add = new Vector();
    private int append = 0;
    private int clear;
    private TempFilesManager close;
    private File createTempFile;
    private int createXMLWriter = 0;
    private static final String currentTimeMillis = new String(new byte[]{10});

    SharedStringsPart(OPCPackage oPCPackage, TempFilesManager tempFilesManager, boolean bl, int n) {
        super(oPCPackage, "sharedStrings.xml");
        this.close = tempFilesManager;
        if (bl) {
            this.SEDU = new Hashtable();
        }
        this.clear = n;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The maximum count of shared strings in memory is " + this.clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU() throws IOException, XlsxDocumentException {
        if (this.createXMLWriter >= this.clear) {
            if (this.createTempFile == null) {
                this.createTempFile = this.close.createTempFile();
            }
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.createTempFile, true)));
            try {
                if (this.SEDU != null) {
                    this.SEDU.clear();
                }
                for (Object e : this.add) {
                    if (e instanceof String) {
                        dataOutputStream.write(0);
                        dataOutputStream.writeUTF((String)e);
                        continue;
                    }
                    dataOutputStream.write(1);
                    Vector vector = (Vector)e;
                    dataOutputStream.writeInt(vector.size());
                    for (int i = 0; i < vector.size(); ++i) {
                        CellRichTextRun cellRichTextRun = (CellRichTextRun)vector.elementAt(i);
                        dataOutputStream.writeUTF(cellRichTextRun.getText());
                        if (cellRichTextRun.getFont() != null) {
                            dataOutputStream.writeBoolean(true);
                            cellRichTextRun.getFont().dump(dataOutputStream);
                            continue;
                        }
                        dataOutputStream.writeBoolean(false);
                    }
                }
                this.add.clear();
            }
            finally {
                dataOutputStream.close();
                try {
                    this.close.getCache().fileUpdated(this.createTempFile);
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    throw new XlsxDocumentException(outOfSpaceException);
                }
            }
            this.createXMLWriter = 0;
        }
    }

    int addObject(Object object) throws IOException, XlsxDocumentException {
        this.SEDU();
        if (this.SEDU != null) {
            Integer n = (Integer)this.SEDU.get(object);
            if (n != null) {
                return n;
            }
            this.SEDU.put(object, new Integer(this.append));
        }
        this.add.add(object);
        ++this.createXMLWriter;
        return this.append++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException, XMLStreamException, XlsxDocumentException {
        long l = System.currentTimeMillis();
        XMLStreamWriter xMLStreamWriter = this.pack.createXMLWriter();
        try {
            Object object;
            int n;
            Object object2;
            xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
            xMLStreamWriter.setDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            xMLStreamWriter.setPrefix("xml", "http://www.w3.org/XML/1998/namespace");
            xMLStreamWriter.writeStartElement("sst");
            xMLStreamWriter.writeDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            if (this.createTempFile != null) {
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.createTempFile)));
                try {
                    int n2 = 0;
                    while ((n2 = dataInputStream.read()) != -1) {
                        xMLStreamWriter.writeStartElement("si");
                        if (n2 == 0) {
                            object2 = dataInputStream.readUTF();
                            this.add(xMLStreamWriter, (String)object2);
                        } else {
                            int n3 = dataInputStream.readInt();
                            for (n = 0; n < n3; ++n) {
                                xMLStreamWriter.writeStartElement("r");
                                object = dataInputStream.readUTF();
                                boolean bl = dataInputStream.readBoolean();
                                if (bl) {
                                    CellFont cellFont = new CellFont();
                                    cellFont.load(dataInputStream);
                                    cellFont.write("rPr", "rFont", xMLStreamWriter);
                                }
                                this.add(xMLStreamWriter, (String)object);
                                xMLStreamWriter.writeEndElement();
                            }
                        }
                        xMLStreamWriter.writeEndElement();
                    }
                }
                finally {
                    dataInputStream.close();
                }
            }
            for (Object e : this.add) {
                xMLStreamWriter.writeStartElement("si");
                if (e instanceof String) {
                    this.add(xMLStreamWriter, (String)e);
                } else {
                    object2 = (Vector)e;
                    for (n = 0; n < ((Vector)object2).size(); ++n) {
                        xMLStreamWriter.writeStartElement("r");
                        object = (CellRichTextRun)((Vector)object2).elementAt(n);
                        if (((CellRichTextRun)object).getFont() != null) {
                            ((CellRichTextRun)object).getFont().write("rPr", "rFont", xMLStreamWriter);
                        }
                        this.add(xMLStreamWriter, ((CellRichTextRun)object).getText());
                        xMLStreamWriter.writeEndElement();
                    }
                }
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
        }
        finally {
            xMLStreamWriter.close();
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The shared strings part is writen. The time spent is " + (System.currentTimeMillis() - l) + " ms.");
        }
    }

    private void add(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("t");
        if (string.startsWith(" ") || string.endsWith(" ") || string.startsWith(currentTimeMillis) || string.endsWith(currentTimeMillis)) {
            xMLStreamWriter.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "space", "preserve");
        }
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
    }

    @Override
    public String getTargetName() {
        return this.partNameSuffix;
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings";
    }

    @Override
    String getPartName() {
        return "/xl/" + this.partNameSuffix;
    }

    @Override
    String getZipItemName() {
        return "xl/" + this.partNameSuffix;
    }

    @Override
    String getExtension() {
        return "xml";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

