/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.CellBorder;
import jet.export.excel.imp.xlsx.CellFillImp;
import jet.export.excel.imp.xlsx.CellFont;
import jet.export.excel.imp.xlsx.CellPatternFill;
import jet.export.excel.imp.xlsx.CellStyleImp;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.NumberFormat;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.Xf;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

class StylePart
extends NoneRelsPart {
    private Hashtable PREDEFINED_FMTS = new Hashtable();
    private Vector SEDU = new Vector();
    private Hashtable add = new Hashtable();
    private Vector addStyle = new Vector();
    private Hashtable append = new Hashtable();
    private Vector close = new Vector();
    private Hashtable createXMLWriter = new Hashtable();
    private Vector get = new Vector();
    private Hashtable getCellBorder = new Hashtable();
    private Vector getCellFill = new Vector();

    StylePart(OPCPackage oPCPackage) {
        super(oPCPackage, "styles.xml");
        CellFont cellFont = new CellFont();
        cellFont.setName("Arial");
        cellFont.setSize(10.0);
        this.add(this.close, this.append, cellFont);
        CellPatternFill cellPatternFill = new CellPatternFill();
        this.add(this.get, this.createXMLWriter, cellPatternFill);
        cellPatternFill = new CellPatternFill();
        cellPatternFill.setPattern((short)17);
        this.add(this.get, this.createXMLWriter, cellPatternFill);
        CellBorder cellBorder = new CellBorder();
        this.add(this.getCellFill, this.getCellBorder, cellBorder);
        this.addStyle(new CellStyleImp());
    }

    private int add(Vector vector, Hashtable hashtable, Object object) {
        Integer n = (Integer)hashtable.get(object);
        if (n != null) {
            return n;
        }
        int n2 = vector.size();
        vector.add(object);
        hashtable.put(object, n2);
        return n2;
    }

    public int addStyle(CellStyleImp cellStyleImp) {
        CellBorder cellBorder;
        CellFillImp cellFillImp;
        CellFont cellFont;
        Xf xf = new Xf();
        NumberFormat numberFormat = cellStyleImp.getNumFmt();
        if (numberFormat != null) {
            int n = numberFormat.getId();
            if (n == -1) {
                n = this.add(this.addStyle, this.add, numberFormat) + NumberFormat.PREDEFINED_FMTS.length;
                numberFormat.setId(n);
            }
            xf.setFmtId(n);
        }
        if ((cellFont = cellStyleImp.getCellFont()) != null) {
            xf.setFontIdx(this.add(this.close, this.append, cellFont));
        }
        if ((cellFillImp = cellStyleImp.getCellFill()) != null) {
            xf.setFillIdx(this.add(this.get, this.createXMLWriter, cellFillImp));
        }
        if ((cellBorder = cellStyleImp.getCellBorder()) != null) {
            xf.setBorderIdx(this.add(this.getCellFill, this.getCellBorder, cellBorder));
        }
        xf.setVAlign(cellStyleImp.getVAlign());
        xf.setHAlign(cellStyleImp.getHAlign());
        xf.setWrapText(cellStyleImp.getIsWordWrap());
        return this.add(this.SEDU, this.PREDEFINED_FMTS, xf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException, XMLStreamException, XlsxDocumentException {
        XMLStreamWriter xMLStreamWriter = this.pack.createXMLWriter();
        try {
            xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
            xMLStreamWriter.setDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            xMLStreamWriter.writeStartElement("styleSheet");
            xMLStreamWriter.writeDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            if (this.addStyle.size() > 0) {
                xMLStreamWriter.writeStartElement("numFmts");
                xMLStreamWriter.writeAttribute("count", String.valueOf(this.addStyle.size()));
                for (Object object : this.addStyle) {
                    ((NumberFormat)object).write(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            if (this.close.size() > 0) {
                xMLStreamWriter.writeStartElement("fonts");
                xMLStreamWriter.writeAttribute("count", String.valueOf(this.close.size()));
                for (Object object : this.close) {
                    ((CellFont)object).write("font", "name", xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            if (this.get.size() > 0) {
                xMLStreamWriter.writeStartElement("fills");
                xMLStreamWriter.writeAttribute("count", String.valueOf(this.get.size()));
                for (Object object : this.get) {
                    ((CellFillImp)object).write(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            if (this.getCellFill.size() > 0) {
                xMLStreamWriter.writeStartElement("borders");
                xMLStreamWriter.writeAttribute("count", String.valueOf(this.getCellFill.size()));
                for (Object object : this.getCellFill) {
                    ((CellBorder)object).write(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            if (this.SEDU.size() > 0) {
                xMLStreamWriter.writeStartElement("cellXfs");
                xMLStreamWriter.writeAttribute("count", String.valueOf(this.SEDU.size()));
                for (Object object : this.SEDU) {
                    ((Xf)object).write(xMLStreamWriter);
                }
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
        }
        finally {
            xMLStreamWriter.close();
        }
    }

    @Override
    public String getTargetName() {
        return this.partNameSuffix;
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles";
    }

    @Override
    String getPartName() {
        return "/xl/" + this.partNameSuffix;
    }

    @Override
    String getZipItemName() {
        return "xl/" + this.partNameSuffix;
    }

    @Override
    String getExtension() {
        return "xml";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml";
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

