/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import jet.export.excel.api.ExcelWorkBook;
import jet.export.excel.api.ExcelWorkSheet;
import jet.export.excel.api.PerformanceConfig;
import jet.export.excel.imp.xlsx.ContentTypes;
import jet.export.excel.imp.xlsx.CorePropertiesPart;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.Part;
import jet.export.excel.imp.xlsx.PicturePart;
import jet.export.excel.imp.xlsx.RelsPart;
import jet.export.excel.imp.xlsx.WorkbookPart;
import jet.export.excel.imp.xlsx.Worksheet;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.shapeprops.PictureFill;
import jet.export.util.Cache;

public class Workbook
implements ExcelWorkBook {
    private OPCPackage SEDU;
    private RelsPart addContentType;
    private CorePropertiesPart addNoneRelsPart;
    private WorkbookPart addSheet;

    public Workbook(Cache cache, PerformanceConfig performanceConfig) throws XlsxDocumentException {
        if (performanceConfig == null) {
            performanceConfig = new PerformanceConfig();
        }
        this.SEDU = new OPCPackage(cache, performanceConfig);
        this.addContentType = new RelsPart(this.SEDU, null);
        this.addSheet = new WorkbookPart(this.SEDU);
        this.addContentType.addNoneRelsPart(this.addSheet);
    }

    public Worksheet createSheet(String string) {
        Worksheet worksheet = this.addSheet.createSheetPart();
        worksheet.setSheetName(string);
        return worksheet;
    }

    public PictureFill createPictureFill(Image image, byte by) throws XlsxDocumentException {
        PicturePart picturePart = this.SEDU.getPicturePart(image);
        return new PictureFill(picturePart, by);
    }

    public void setSheetOrder(String string, int n) {
        this.addSheet.setSheetOrder(string, n);
    }

    @Override
    public Worksheet getSheet(String string) {
        return this.addSheet.getSheetPart(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(OutputStream outputStream) throws XlsxDocumentException {
        long l = 0L;
        if (JRLog.isTrace(6)) {
            l = System.currentTimeMillis();
            JRLog.trace(6, "Xlsx API: Start writing the entire workbook.");
        }
        if (this.addSheet.getSheetCount() == 0) {
            Worksheet worksheet = this.createSheet("Sheet1");
            this.addSheet(worksheet);
        }
        try {
            this.SEDU.initOutput(outputStream);
            try {
                this.write();
            }
            finally {
                this.SEDU.freeOutput();
            }
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: Finish writing the entire workbook.");
            JRLog.trace(6, "Xlsx API: The total time cost to write the entire workbook is " + (System.currentTimeMillis() - l) + " ms.");
        }
    }

    void write() throws IOException, XlsxDocumentException, XMLStreamException {
        ContentTypes contentTypes = new ContentTypes();
        this.SEDU(this.addContentType, contentTypes);
        contentTypes.write(this.SEDU);
        this.SEDU.getWriter().flush();
    }

    private void SEDU(Part part, ContentTypes contentTypes) throws IOException, XlsxDocumentException, XMLStreamException {
        RelsPart relsPart;
        if (part.getIsWriten()) {
            return;
        }
        contentTypes.addContentType(part);
        this.SEDU.getZipOutputStream().putNextEntry(new ZipEntry(part.getZipItemName()));
        part.write();
        this.SEDU.getWriter().flush();
        part.setIsWriten(true);
        if (part instanceof RelsPart) {
            Enumeration enumeration = ((RelsPart)part).getNoneRelsParts().elements();
            while (enumeration.hasMoreElements()) {
                NoneRelsPart noneRelsPart = (NoneRelsPart)enumeration.nextElement();
                this.SEDU(noneRelsPart, contentTypes);
            }
        } else if (part instanceof NoneRelsPart && (relsPart = ((NoneRelsPart)part).getRelsPart(false)) != null) {
            this.SEDU(relsPart, contentTypes);
        }
    }

    @Override
    public void free() throws XlsxDocumentException {
        this.addContentType(this.addContentType);
        this.SEDU.free();
        this.SEDU = null;
    }

    private void addContentType(Part part) {
        RelsPart relsPart;
        if (part.getIsFreed()) {
            return;
        }
        part.free();
        part.setIsFreed(true);
        if (part instanceof RelsPart) {
            Enumeration enumeration = ((RelsPart)part).getNoneRelsParts().elements();
            while (enumeration.hasMoreElements()) {
                NoneRelsPart noneRelsPart = (NoneRelsPart)enumeration.nextElement();
                this.addContentType(noneRelsPart);
            }
        } else if (part instanceof NoneRelsPart && (relsPart = ((NoneRelsPart)part).getRelsPart(false)) != null) {
            this.addContentType(relsPart);
        }
    }

    private CorePropertiesPart addNoneRelsPart() {
        if (this.addNoneRelsPart == null) {
            this.addNoneRelsPart = new CorePropertiesPart(this.SEDU);
            this.addContentType.addNoneRelsPart(this.addNoneRelsPart);
        }
        return this.addNoneRelsPart;
    }

    public void setCreator(String string) {
        this.addNoneRelsPart().setCreator(string);
    }

    public void setTitle(String string) {
        this.addNoneRelsPart().setTitle(string);
    }

    public void setSubject(String string) {
        this.addNoneRelsPart().setSubject(string);
    }

    public void setDescription(String string) {
        this.addNoneRelsPart().setDescription(string);
    }

    @Override
    public int getSheetSize() {
        return this.addSheet.getSheetCount();
    }

    public void registerColor(Color color) {
    }

    @Override
    public ExcelWorkSheet getSheet(int n) {
        return this.addSheet.getSheet(n);
    }

    @Override
    public void addSheet(ExcelWorkSheet excelWorkSheet) throws XlsxDocumentException {
        this.addSheet.addSheetPart((Worksheet)excelWorkSheet);
    }

    public void registerFinished() {
    }
}

