/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.CellsBlockManager;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.RelsPart;
import jet.export.excel.imp.xlsx.SharedStringsPart;
import jet.export.excel.imp.xlsx.StylePart;
import jet.export.excel.imp.xlsx.Worksheet;
import jet.export.excel.imp.xlsx.XlsxDocumentException;

class WorkbookPart
extends NoneRelsPart {
    private Vector SEDU = new Vector();
    private SharedStringsPart add;
    private StylePart addNoneRelsPart;
    private CellsBlockManager append;

    WorkbookPart(OPCPackage oPCPackage) {
        super(oPCPackage, "workbook.xml");
        this.append = new CellsBlockManager(oPCPackage.getTempFilesManager(), oPCPackage.getPerformanceConfig().getMaxCellsInMem(), oPCPackage.getPerformanceConfig().getCellsBlockRowCount());
    }

    public int getSheetCount() {
        return this.SEDU.size();
    }

    public SharedStringsPart getSSPart() {
        if (this.add == null) {
            this.add = new SharedStringsPart(this.pack, this.pack.getTempFilesManager(), true, this.pack.getPerformanceConfig().getMaxStringsInMem());
            this.getRelsPart(true).addNoneRelsPart(this.add);
        }
        return this.add;
    }

    public StylePart getStylePart() {
        if (this.addNoneRelsPart == null) {
            this.addNoneRelsPart = new StylePart(this.pack);
            this.getRelsPart(true).addNoneRelsPart(this.addNoneRelsPart);
        }
        return this.addNoneRelsPart;
    }

    public Worksheet createSheetPart() {
        int n = this.pack.getSheetCount() + 1;
        this.pack.setSheetCount(n);
        Worksheet worksheet = new Worksheet(this.pack, n);
        worksheet.setCellsBlockManager(this.append);
        worksheet.setSharedStringsPart(this.getSSPart());
        worksheet.setStylePart(this.getStylePart());
        return worksheet;
    }

    public void addSheetPart(Worksheet worksheet) {
        String string = this.getRelsPart(true).addNoneRelsPart(worksheet);
        this.SEDU.add(string);
    }

    public Worksheet getSheetPart(String string) {
        Enumeration enumeration = this.getRelsPart(true).getNoneRelsParts().elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            NoneRelsPart noneRelsPart = (NoneRelsPart)enumeration.nextElement();
            if (!(noneRelsPart instanceof Worksheet) || (string2 = ((Worksheet)noneRelsPart).getSheetName()) == null || !string2.equalsIgnoreCase(string)) continue;
            return (Worksheet)noneRelsPart;
        }
        return null;
    }

    public void setSheetOrder(String string, int n) {
        RelsPart relsPart = this.getRelsPart(false);
        if (relsPart == null) {
            return;
        }
        String string2 = null;
        Hashtable hashtable = relsPart.getNoneRelsParts();
        for (String string3 : this.SEDU) {
            String string4 = ((Worksheet)hashtable.get(string3)).getSheetName();
            if (string4 == null || !string4.equalsIgnoreCase(string)) continue;
            string2 = string3;
            break;
        }
        if (string2 != null) {
            if (n < 0) {
                n = 0;
            } else if (n >= this.SEDU.size()) {
                n = this.SEDU.size() - 1;
            }
            this.SEDU.remove(string2);
            this.SEDU.insertElementAt(string2, n);
        }
    }

    public Worksheet getSheet(int n) {
        if (n < 0 || n > this.SEDU.size() - 1) {
            return null;
        }
        String string = (String)this.SEDU.get(n);
        RelsPart relsPart = this.getRelsPart(false);
        if (relsPart == null) {
            return null;
        }
        return (Worksheet)relsPart.getNoneRelsParts().get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException, XMLStreamException, XlsxDocumentException {
        if (this.addNoneRelsPart == null) {
            this.addNoneRelsPart = new StylePart(this.pack);
            this.getRelsPart(true).addNoneRelsPart(this.addNoneRelsPart);
        }
        XMLStreamWriter xMLStreamWriter = this.pack.createXMLWriter();
        try {
            xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
            xMLStreamWriter.setDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            xMLStreamWriter.setPrefix("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            xMLStreamWriter.writeStartElement("workbook");
            xMLStreamWriter.writeDefaultNamespace("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            xMLStreamWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            xMLStreamWriter.writeEmptyElement("fileVersion");
            xMLStreamWriter.writeAttribute("appName", "xl");
            xMLStreamWriter.writeAttribute("lastEdited", "4");
            xMLStreamWriter.writeAttribute("lowestEdited", "4");
            xMLStreamWriter.writeAttribute("rupBuild", "4506");
            xMLStreamWriter.writeStartElement("sheets");
            Hashtable hashtable = this.getRelsPart(true).getNoneRelsParts();
            int n = 1;
            for (String string : this.SEDU) {
                Worksheet worksheet = (Worksheet)hashtable.get(string);
                xMLStreamWriter.writeEmptyElement("sheet");
                xMLStreamWriter.writeAttribute("sheetId", String.valueOf(worksheet.getId()));
                String string2 = worksheet.getSheetName();
                if (string2 == null) {
                    string2 = "Sheet" + n;
                    ++n;
                    while (this.SEDU(string2)) {
                        string2 = "Sheet" + n;
                        ++n;
                    }
                }
                xMLStreamWriter.writeAttribute("name", string2);
                xMLStreamWriter.writeAttribute("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id", string);
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
        }
        finally {
            xMLStreamWriter.close();
        }
    }

    private boolean SEDU(String string) {
        RelsPart relsPart = this.getRelsPart(false);
        if (relsPart != null) {
            Hashtable hashtable = relsPart.getNoneRelsParts();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string2;
                NoneRelsPart noneRelsPart = (NoneRelsPart)enumeration.nextElement();
                if (!(noneRelsPart instanceof Worksheet) || (string2 = ((Worksheet)noneRelsPart).getSheetName()) == null || !string.equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getTargetName() {
        return "xl/" + this.partNameSuffix;
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    }

    @Override
    String getPartName() {
        return "/xl/" + this.partNameSuffix;
    }

    @Override
    String getZipItemName() {
        return "xl/" + this.partNameSuffix;
    }

    @Override
    String getExtension() {
        return "xml";
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

