/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.IOException;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.ChartPart;
import jet.export.excel.imp.xlsx.DrawingPart;
import jet.export.excel.imp.xlsx.Link;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.PicturePart;
import jet.export.excel.imp.xlsx.PictureShape;
import jet.export.excel.imp.xlsx.RelsPart;
import jet.export.excel.imp.xlsx.SimpleShape;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.ChartArea;
import jet.export.excel.imp.xlsx.shapeprops.LineStyle;
import jet.export.excel.imp.xlsx.shapeprops.TwoCellAnchor;
import jet.export.excel.imp.xlsx.util.Util;

class WorksheetDrawingPart
extends DrawingPart {
    private Vector SEDU = new Vector();

    WorksheetDrawingPart(OPCPackage oPCPackage, int n) {
        super(oPCPackage, n);
    }

    void addChart(ChartArea chartArea, TwoCellAnchor twoCellAnchor) throws IOException, XlsxDocumentException {
        int n = this.pack.getChartCount() + 1;
        this.pack.setChartCount(n);
        ChartPart chartPart = new ChartPart(this.pack, n, chartArea);
        String string = this.getRelsPart(true).addNoneRelsPart(chartPart);
        this.SEDU.add(new Object[]{(byte)0, string, twoCellAnchor});
    }

    void addPicture(PictureShape pictureShape, TwoCellAnchor twoCellAnchor) throws IOException, XlsxDocumentException {
        PicturePart picturePart = this.pack.getPicturePart(pictureShape.getPictureData());
        RelsPart relsPart = this.getRelsPart(true);
        String string = relsPart.addNoneRelsPart(picturePart);
        Link link = pictureShape.getLink();
        this.SEDU.add(new Object[]{(byte)1, string, twoCellAnchor, this.writeLink(link), link == null ? null : link.getToolTip(), pictureShape.getBorder(), pictureShape.getColorStyle()});
    }

    void addSimpleShape(SimpleShape simpleShape, TwoCellAnchor twoCellAnchor) throws IOException, XlsxDocumentException {
        Link link = simpleShape.getLink();
        this.SEDU.add(new Object[]{(byte)2, twoCellAnchor, this.writeLink(link), link == null ? null : link.getToolTip(), simpleShape.getPresetType(), simpleShape.getFillStyle(), simpleShape.getBorder(), simpleShape.getShadow(), simpleShape.getTextBody()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException, XMLStreamException, XlsxDocumentException {
        XMLStreamWriter xMLStreamWriter = this.pack.createXMLWriter();
        try {
            xMLStreamWriter.writeStartDocument(this.pack.getEncoding(), "1.0");
            xMLStreamWriter.setPrefix("xdr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
            xMLStreamWriter.setPrefix("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.setPrefix("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            xMLStreamWriter.writeStartElement("xdr", "wsDr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
            xMLStreamWriter.writeNamespace("xdr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
            xMLStreamWriter.writeNamespace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            int n = 0;
            for (Object[] objectArray : this.SEDU) {
                byte by = (Byte)objectArray[0];
                switch (by) {
                    case 0: {
                        String string = (String)objectArray[1];
                        TwoCellAnchor twoCellAnchor = (TwoCellAnchor)objectArray[2];
                        xMLStreamWriter.writeStartElement("xdr", "twoCellAnchor", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        twoCellAnchor.write(xMLStreamWriter);
                        this.SEDU(xMLStreamWriter, n, string);
                        xMLStreamWriter.writeEmptyElement("xdr", "clientData", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        xMLStreamWriter.writeEndElement();
                        ++n;
                        break;
                    }
                    case 1: {
                        String string = (String)objectArray[1];
                        xMLStreamWriter.writeStartElement("xdr", "twoCellAnchor", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        ((TwoCellAnchor)objectArray[2]).write(xMLStreamWriter);
                        this.writePictureRef(xMLStreamWriter, n, string, (String)objectArray[3], (String)objectArray[5], (LineStyle)objectArray[5], (Short)objectArray[6], "xdr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        xMLStreamWriter.writeEmptyElement("xdr", "clientData", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        xMLStreamWriter.writeEndElement();
                        ++n;
                        break;
                    }
                    case 2: {
                        TwoCellAnchor twoCellAnchor = (TwoCellAnchor)objectArray[1];
                        boolean bl = false;
                        if ((Integer)objectArray[4] == 1) {
                            Object[] objectArray2 = Util.convertLineEnds(twoCellAnchor.getLeft(), twoCellAnchor.getLeftOffset(), twoCellAnchor.getTop(), twoCellAnchor.getTopOffset(), twoCellAnchor.getRight(), twoCellAnchor.getRightOffset(), twoCellAnchor.getBottom(), twoCellAnchor.getBottomOffset());
                            twoCellAnchor.setLeft((Integer)objectArray2[0]);
                            twoCellAnchor.setLeftOffset((Integer)objectArray2[1]);
                            twoCellAnchor.setTop((Integer)objectArray2[2]);
                            twoCellAnchor.setTopOffset((Integer)objectArray2[3]);
                            twoCellAnchor.setRight((Integer)objectArray2[4]);
                            twoCellAnchor.setRightOffset((Integer)objectArray2[5]);
                            twoCellAnchor.setBottom((Integer)objectArray2[6]);
                            twoCellAnchor.setBottomOffset((Integer)objectArray2[7]);
                            bl = (Boolean)objectArray2[8];
                        }
                        xMLStreamWriter.writeStartElement("xdr", "twoCellAnchor", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        twoCellAnchor.write(xMLStreamWriter);
                        this.writeSimpleShape(xMLStreamWriter, n, objectArray, bl, "xdr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        xMLStreamWriter.writeEmptyElement("xdr", "clientData", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
                        xMLStreamWriter.writeEndElement();
                        ++n;
                    }
                }
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
        }
        finally {
            xMLStreamWriter.close();
        }
    }

    private void SEDU(XMLStreamWriter xMLStreamWriter, int n, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("xdr", "graphicFrame", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        xMLStreamWriter.writeAttribute("macro", "");
        xMLStreamWriter.writeStartElement("xdr", "nvGraphicFramePr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        xMLStreamWriter.writeEmptyElement("xdr", "cNvPr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        xMLStreamWriter.writeAttribute("id", String.valueOf(n));
        xMLStreamWriter.writeAttribute("name", "chart " + n);
        xMLStreamWriter.writeEmptyElement("xdr", "cNvGraphicFramePr", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEmptyElement("xdr", "xfrm", "http://schemas.openxmlformats.org/drawingml/2006/spreadsheetDrawing");
        xMLStreamWriter.writeStartElement("a", "graphic", "http://schemas.openxmlformats.org/drawingml/2006/main");
        xMLStreamWriter.writeStartElement("a", "graphicData", "http://schemas.openxmlformats.org/drawingml/2006/main");
        xMLStreamWriter.writeAttribute("uri", "http://schemas.openxmlformats.org/drawingml/2006/chart");
        xMLStreamWriter.setPrefix("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
        xMLStreamWriter.writeEmptyElement("c", "chart", "http://schemas.openxmlformats.org/drawingml/2006/chart");
        xMLStreamWriter.writeNamespace("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
        xMLStreamWriter.writeAttribute("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id", string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    @Override
    String getContentType() {
        return "application/vnd.openxmlformats-officedocument.drawing+xml";
    }

    @Override
    public String getTargetType() {
        return "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing";
    }
}

