/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.LineStyle;
import jet.export.excel.api.chart.TypeInfo;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.ChartType;
import jet.export.excel.imp.xlsx.chart.DataLabelGroupProps;
import jet.export.excel.imp.xlsx.chart.Series;

public abstract class CommonChartType
implements ChartType,
TypeInfo {
    public static final byte BAR_DIR_BAR = 1;
    public static final byte BAR_DIR_COL = 2;
    protected Vector seriesContainer = new Vector();
    private String get;
    protected DataLabelGroupProps chartDataLabelProps;
    protected boolean hasDataLabelProps = true;
    private int[] isVaryColors;
    private boolean prepareSeries = false;
    private boolean prepareWriting = false;
    private jet.export.excel.imp.xlsx.shapeprops.LineStyle setLeaderLinesStyle = null;
    protected boolean hasVaryColorsProp = true;
    protected byte[] supportedDataLabelPos = new byte[]{0};

    protected CommonChartType(String string) {
        this.get = string;
    }

    public void setShowLeaderLine(boolean bl) {
        this.prepareSeries = bl;
        this.prepareWriting = true;
    }

    public void setLeaderLineStyle(LineStyle lineStyle) {
        this.setLeaderLinesStyle = (jet.export.excel.imp.xlsx.shapeprops.LineStyle)lineStyle;
    }

    public void setAxisIds(int[] nArray) {
        this.isVaryColors = nArray;
    }

    public Series getSeriesByIndex(int n) {
        if (n < 0 || n >= this.seriesContainer.size()) {
            return null;
        }
        return (Series)this.seriesContainer.get(n);
    }

    abstract void prepareWriting();

    abstract void write1stSpecificProps(XMLStreamWriter var1, NoneRelsPart var2) throws XlsxDocumentException;

    abstract void write2ndSpecificProps(XMLStreamWriter var1, NoneRelsPart var2) throws XlsxDocumentException;

    protected void prepareSeries(Series series) {
        if (this.prepareWriting) {
            series.setShowLeaderLines(this.prepareSeries);
            if (this.setLeaderLinesStyle != null) {
                series.setLeaderLinesStyle(this.setLeaderLinesStyle);
            }
        }
    }

    @Override
    public void write(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart, int n) throws XlsxDocumentException {
        this.prepareWriting();
        try {
            int n2;
            xMLStreamWriter.writeStartElement("c", this.get, "http://schemas.openxmlformats.org/drawingml/2006/chart");
            this.write1stSpecificProps(xMLStreamWriter, noneRelsPart);
            if (this.hasVaryColorsProp) {
                for (n2 = 0; n2 < this.seriesContainer.size(); ++n2) {
                    if (!((Series)this.seriesContainer.get(n2)).isVaryColors()) continue;
                    xMLStreamWriter.writeEmptyElement("c", "varyColors", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                    xMLStreamWriter.writeAttribute("val", "1");
                    break;
                }
            }
            for (n2 = 0; n2 < this.seriesContainer.size(); ++n2) {
                Series series = (Series)this.seriesContainer.get(n2);
                this.prepareSeries(series);
                series.write(xMLStreamWriter, noneRelsPart, n + n2, this.supportedDataLabelPos);
            }
            if (this.chartDataLabelProps != null && this.hasDataLabelProps) {
                this.chartDataLabelProps.write(xMLStreamWriter, noneRelsPart, null, this.supportedDataLabelPos);
            }
            this.write2ndSpecificProps(xMLStreamWriter, noneRelsPart);
            if (this.isVaryColors != null) {
                for (n2 = 0; n2 < this.isVaryColors.length; ++n2) {
                    xMLStreamWriter.writeEmptyElement("c", "axId", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                    xMLStreamWriter.writeAttribute("val", String.valueOf(this.isVaryColors[n2]));
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    @Override
    public int getSeriesNum() {
        return this.seriesContainer.size();
    }
}

