/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.v7x;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.connect.DbBinary;
import jet.datastream.Communicator;
import jet.datastream.DSCTField;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSGroup;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSPicture;
import jet.datastream.DSReference;
import jet.datastream.DSShape;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.ReportHeaderInfo;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.ExpException;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelFormular;
import jet.export.excel.ExcelFormularImp;
import jet.export.excel.ExcelFormularInfo;
import jet.export.excel.api.ColorFillInfo;
import jet.export.excel.api.DocumentException;
import jet.export.excel.api.ExcelCell;
import jet.export.excel.api.ExcelFactory;
import jet.export.excel.api.ExcelImageInfo;
import jet.export.excel.api.ExcelShapeInfo;
import jet.export.excel.api.ExcelWorkBook;
import jet.export.excel.api.ExcelWorkSheet;
import jet.export.excel.api.HyperLink;
import jet.export.excel.api.LineStyle;
import jet.export.excel.api.LocInfo;
import jet.export.excel.api.PageInfoSetup;
import jet.export.excel.api.WindowsOptions;
import jet.export.excel.v7x.ColumnFormatCache;
import jet.export.excel.v7x.CrossTabExpCellInfo;
import jet.export.excel.v7x.ExcelExporter;
import jet.export.excel.v7x.NormalCrossTab;
import jet.export.excel.v7x.SizeInfo;
import jet.export.excel.v7x.xlsAffix.Column;
import jet.export.excel.v7x.xlsAffix.ImageLink;
import jet.export.excel.v7x.xlsAffix.PictureInfo;
import jet.export.util.CCUtil;
import jet.export.util.ImageEngine;
import jet.export.util.URLEncoder;
import jet.util.BitmapReader;
import jet.util.PictureFileFormatDetector;
import jet.util.image.ImageResource;

abstract class ExportToXls1
implements ExcelExporter {
    private boolean BORDERLINENAME = false;
    protected int debugBreakV = Integer.MAX_VALUE;
    protected int debugContinueV = -1;
    protected static final byte ANOTHER = -1;
    protected static final byte HEADER = 0;
    protected static final byte FOOTER = 1;
    protected boolean hasSum = false;
    protected boolean isErrorLog;
    protected boolean isFirstOutPage = true;
    protected boolean isInfoLine;
    protected boolean isOneHeaderFooter = true;
    protected int argumentsLimit;
    protected int comNum;
    protected int crossTabNum = 0;
    protected int currentSheetRow = 0;
    protected int maxRows;
    protected int maxRowNum;
    protected int maxColNum;
    protected int pageNum = 1;
    protected int pageHeight;
    protected int pageWidth;
    protected long getDB = 0L;
    protected long layoutTime = 0L;
    protected long toString = 0L;
    protected String sheetName;
    protected Hashtable bookmarks;
    protected Hashtable crossTabInfo;
    protected Hashtable imageLinks;
    protected Hashtable links;
    protected List pageFooter = new ArrayList();
    protected Locale locale;
    protected Vector pageShapes = new Vector();
    protected Communicator commu;
    protected Communicator curCom;
    protected ColumnFormatCache excelCache;
    protected ExcelFactory factory;
    protected ExcelFormular excelFormular;
    protected ExcelParameter excelParameter;
    protected ExcelWorkBook workbook;
    protected ExcelWorkSheet worksheet;
    protected ImageEngine imageEngine;
    protected Stack commuInfos;
    protected WindowsOptions windowsOptions;
    private int booleanValue;
    private Toolkit clear;

    public ExportToXls1(Communicator communicator, ExcelParameter excelParameter) {
        this.commu = communicator;
        this.excelParameter = excelParameter;
    }

    @Override
    public void setFactory(ExcelFactory excelFactory) {
        this.factory = excelFactory;
    }

    @Override
    public void setWorkBook(ExcelWorkBook excelWorkBook) {
        this.workbook = excelWorkBook;
    }

    @Override
    public void setExcelCache(ColumnFormatCache columnFormatCache) {
        this.excelCache = columnFormatCache;
        columnFormatCache.reInitial();
    }

    protected void free() throws IOException, DocumentException {
        this.imageEngine = null;
        if (this.commuInfos != null) {
            this.commuInfos.removeAllElements();
            this.commuInfos = null;
        }
        if (this.bookmarks != null) {
            this.bookmarks.clear();
            this.bookmarks = null;
        }
        if (this.links != null) {
            this.links.clear();
            this.links = null;
        }
        if (this.imageLinks != null) {
            this.imageLinks.clear();
            this.imageLinks = null;
        }
        if (this.crossTabInfo != null) {
            this.crossTabInfo.clear();
            this.crossTabInfo = null;
        }
    }

    protected void initial() throws ExpException, DocumentException {
        this.isErrorLog = JRLog.isError(2);
        this.isInfoLine = JRLog.isTrace(5);
        this.imageEngine = new ImageEngine();
        this.imageEngine.setResolusion(Unit.getResolution());
        this.getSomeInfo();
        this.bookmarks = new Hashtable();
        this.links = new Hashtable();
        this.imageLinks = new Hashtable();
        this.locale = this.commu.getLocale();
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.BORDERLINENAME();
    }

    private void BORDERLINENAME() {
        this.excelFormular = new ExcelFormularImp(this.locale, this.imageEngine, this.excelCache, this.factory, this.getIsNotGetColor(), this.argumentsLimit);
    }

    protected abstract boolean getIsNotGetColor();

    protected void writeFormulars() throws IOException, DocumentException {
        Hashtable hashtable = this.excelFormular.getFormulars();
        Enumeration enumeration = hashtable.keys();
        long l = System.currentTimeMillis();
        while (enumeration.hasMoreElements()) {
            Object object;
            ExcelWorkSheet excelWorkSheet;
            Integer n = (Integer)enumeration.nextElement();
            int n2 = n;
            if (this.getCurrentSheetNum() == n2 && this.worksheet != null) {
                excelWorkSheet = this.worksheet;
            } else {
                object = this.excelCache.getSheetName(n2);
                excelWorkSheet = this.workbook.getSheet((String)object);
            }
            object = (List)hashtable.get(n);
            for (int i = 0; i < object.size(); ++i) {
                ExcelFormularInfo excelFormularInfo = (ExcelFormularInfo)object.get(i);
                if (excelFormularInfo.isImage()) {
                    ImageLink imageLink = (ImageLink)((Object)excelFormularInfo);
                    LocInfo locInfo = imageLink.getLoc();
                    Image image = imageLink.img;
                    this.addImageToSheet(excelWorkSheet, image, locInfo, imageLink.getLink());
                    continue;
                }
                this.addCellToSheet(excelWorkSheet, excelFormularInfo.getCell());
            }
        }
        long l2 = System.currentTimeMillis();
        boolean bl = JRLog.isTrace(5);
        if (bl) {
            JRLog.trace(5, "Excel handle the formular times(" + (l2 - l) + ")");
        }
    }

    protected final void addReportLink() throws IOException, DocumentException {
        String string;
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration;
        if (this.links.size() != 0) {
            enumeration = this.links.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (ExcelCell)enumeration.nextElement();
                int n = (Integer)this.links.get(object3);
                ExcelWorkSheet excelWorkSheet = this.getCurrentSheetNum() == n && this.worksheet != null ? this.worksheet : this.workbook.getSheet(n - 1);
                object2 = object3.getHyperLink();
                object = Integer.valueOf(object2.getLinkString());
                int[] nArray = (int[])this.bookmarks.get(object);
                int n2 = nArray[0];
                string = this.excelCache.getSheetName(n2);
                int n3 = nArray[1];
                if (n3 == 0) {
                    n3 = 1;
                }
                String string2 = string + "!" + n3 + ':' + nArray[2];
                object2 = this.factory.createHyperLink(string2, null, object2.getType());
                object3.setHyperLink((HyperLink)object2);
                excelWorkSheet.addCell((ExcelCell)object3);
            }
            this.links.clear();
        }
        if (this.imageLinks.size() != 0) {
            enumeration = this.imageLinks.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (PictureInfo)enumeration.nextElement();
                HyperLink hyperLink = ((PictureInfo)object3).getLink();
                int n = (Integer)this.imageLinks.get(object3);
                object2 = Integer.valueOf(hyperLink.getLinkString());
                object = (int[])this.bookmarks.get(object2);
                Object object4 = object[0];
                String string3 = this.excelCache.getSheetName((int)object4);
                string = string3 + "!" + (int)object[1] + ':' + (int)object[2];
                hyperLink = this.factory.createHyperLink(string, null, hyperLink.getType());
                ExcelWorkSheet excelWorkSheet = this.getCurrentSheetNum() == n ? this.worksheet : this.workbook.getSheet(n - 1);
                this.addCell(excelWorkSheet, ((PictureInfo)object3).getImage(), ((PictureInfo)object3).getLoc(), hyperLink);
            }
            this.imageLinks.clear();
        }
    }

    protected void writePartCrosstab(ExcelWorkSheet excelWorkSheet, DSCrossTab dSCrossTab, Offset offset, CrossTabExpCellInfo crossTabExpCellInfo, int n, int n2) throws JRStopEngineException, DocumentException, IOException {
        Vector vector = dSCrossTab.getChildren();
        if (vector == null || vector.size() == 0) {
            return;
        }
        Offset offset2 = new Offset(offset, dSCrossTab.getX(), dSCrossTab.getY());
        crossTabExpCellInfo.setCurOffset(offset2);
        for (int i = 0; i < vector.size(); ++i) {
            DSCTField dSCTField = (DSCTField)vector.get(i);
            if (!this.isExport(dSCTField)) continue;
            try {
                Object object;
                SizeInfo sizeInfo2 = crossTabExpCellInfo.getDimension(dSCTField);
                if (sizeInfo2 == null) continue;
                int n3 = sizeInfo2.getRowIndx();
                int n4 = sizeInfo2.getColIndex();
                int n5 = sizeInfo2.getRowSpan();
                int n6 = sizeInfo2.getColSpan();
                Color[] colorArray = this.excelCache.getFieldColor(dSCTField);
                Column column = new Column(n4 += n2, dSCTField.toString(), colorArray, dSCTField, this.commu, this.curCom, this.imageEngine, false, this.excelCache);
                Object object2 = column.getField(n3 += n, this.factory);
                if (object2 instanceof ExcelCell) {
                    object = (ExcelCell)object2;
                    object.setColSpan(n6);
                    object.setRowSpan(n5);
                    this.addCellToSheet(excelWorkSheet, (ExcelCell)object);
                    continue;
                }
                object = (ImageLink)object2;
                if (object == null) continue;
                int n7 = n4;
                int n8 = n3;
                int n9 = n7 + n6;
                int n10 = n8 + n5;
                LocInfo locInfo = this.factory.createLocInfo(n7, n8, n9, n10);
                HyperLink hyperLink = ((ImageLink)object).getLink();
                this.addImageToSheet(excelWorkSheet, ((ImageLink)object).img, locInfo, hyperLink);
                continue;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) continue;
                JRLog.error(2, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExcelImageInfo getMediaField(DSPicture dSPicture) {
        ExcelImageInfo excelImageInfo;
        Object object;
        int n;
        Object object2;
        int n2 = 0;
        int n3 = (int)(Unit.convertUnitToInch(this.getIntPropertyByName(dSPicture, "BorderWidth")) * 72.0);
        int[] nArray = new int[ExcelCache.BORDERLINENAME.length];
        int n4 = 0;
        int n5 = ExcelCache.BORDERLINENAME.length;
        while (--n5 >= 0) {
            String string = ExcelCache.BORDERLINENAME[n5];
            nArray[n5] = this.getIntPropertyByName(dSPicture, string);
            n4 += nArray[n5];
        }
        DbBinary dbBinary = (DbBinary)dSPicture.getRecord().getCell(this.getStringPropertyByName(dSPicture, "ColumnName"));
        Image image = null;
        if (!dbBinary.isNull()) {
            object2 = dbBinary.get();
            n = (Integer)dSPicture.getPropertyByName("MediaType").getObject();
            if (object2 != null) {
                if (n == 2) {
                    n = PictureFileFormatDetector.getPictureFileType(object2);
                }
                if (this.clear == null) {
                    this.clear = Toolkit.getDefaultToolkit();
                }
                if (n == 4 || n == 0) {
                    image = this.clear.createImage((byte[])object2);
                } else if (n == 1) {
                    object = new DataInputStream(new ByteArrayInputStream((byte[])object2));
                    try {
                        BitmapReader bitmapReader = BitmapReader.loadFromBMP((DataInput)object);
                        if (bitmapReader != null) {
                            image = this.clear.createImage(bitmapReader.getMemImgSrc());
                        }
                    }
                    finally {
                        try {
                            ((FilterInputStream)object).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (image != null) {
            object2 = null;
            if (n4 > 0) {
                object2 = this.getColorPropertyByName(dSPicture, "BorderColor");
            }
            n = nArray[2] != 0 ? nArray[2] : (nArray[1] != 0 ? nArray[1] : (nArray[0] != 0 ? nArray[0] : (nArray[3] != 0 ? nArray[3] : 0)));
            switch (n) {
                case 0: {
                    object2 = null;
                    break;
                }
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 7;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 9;
                }
            }
            object = this.factory.createLineStyle(n2);
            object.setColor((Color)object2);
            object.setWidth(n3);
            excelImageInfo = this.factory.createImageInfo(image);
            excelImageInfo.setBorderStyle((LineStyle)object);
        } else {
            excelImageInfo = null;
        }
        return excelImageInfo;
    }

    protected HyperLink getLinkInfo(JRObjectResult jRObjectResult) throws JRStopEngineException {
        HyperLink hyperLink;
        block6: {
            int n = -1;
            hyperLink = null;
            n = this.curCom != null ? this.SEDU(this.curCom, jRObjectResult) : -1;
            if (n != -1) {
                hyperLink = this.factory.createHyperLink(Integer.toString(n), null, 8);
            } else if (jRObjectResult.getLinkComm() == -1) {
                String string;
                String string2 = string = this.curCom == null ? null : this.curCom.getLinkedInfo(jRObjectResult.getLinkCondition());
                if (string != null && string.trim().length() > 0) {
                    try {
                        string = URLEncoder.encode(string, URLEncoder.getSystemURLEncoding());
                        hyperLink = this.factory.createHyperLink(string, null, 3);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!JRLog.isError(2)) break block6;
                        JRLog.error(2, unsupportedEncodingException);
                    }
                }
            }
        }
        return hyperLink;
    }

    private int SEDU(Communicator communicator, JRObjectResult jRObjectResult) throws JRStopEngineException {
        int n;
        Communicator communicator2;
        int n2 = jRObjectResult.getLinkComm();
        int n3 = -1;
        if (n2 != -1 && (communicator2 = communicator.getLinkedComm(n2)) != null && (n = communicator2.getLinkedPage(jRObjectResult.getLinkCondition())) >= 0) {
            n3 = this.add(communicator, n2, n);
        }
        return n3;
    }

    private int add(Communicator communicator, int n, int n2) {
        return -1;
    }

    protected void getPageSize(DSPage dSPage) {
        this.pageHeight = dSPage.getPrintableArea().height;
        this.pageWidth = dSPage.getPrintableArea().width;
    }

    protected void initialNewSheet() throws DocumentException {
        int n = this.excelCache.getNextSheetIndex(this.sheetName);
        String string = this.excelCache.getSheetName(this.sheetName, n);
        this.worksheet = this.factory.createSheet(string);
        this.excelCache.addSheet(this.sheetName);
        this.booleanValue = this.excelCache.getCurrentSheetIndex();
        this.excelCache.storeSheetInfo(this.booleanValue, string);
        PageInfoSetup pageInfoSetup = this.createPaperInfo();
        this.worksheet.setPageInfo(pageInfoSetup);
        this.windowsOptions = this.factory.createWindowsOptions();
    }

    protected String getCurSheetName() {
        return this.worksheet.getSheetName();
    }

    protected PageInfoSetup createPaperInfo() {
        PageInfoSetup pageInfoSetup = this.factory.creatPageInfoSetup();
        pageInfoSetup.setIsPrintGridlines(this.excelParameter.isPrintGridlines());
        pageInfoSetup.setPrinterHeader(this.excelParameter.getPrintPageHeader());
        pageInfoSetup.setPrinterFooter(this.excelParameter.getPrintPageFooter());
        return pageInfoSetup;
    }

    protected ExcelShapeInfo getShapeProp(DSShape dSShape, LocInfo locInfo) {
        ExcelShapeInfo excelShapeInfo = null;
        int n = dSShape.getObjectType();
        int n2 = 1;
        int n3 = 0;
        Color color = null;
        Color color2 = null;
        double d = 0.0;
        int n4 = 0;
        if (n != 22) {
            color = this.getColorPropertyByName(dSShape, "BorderColor");
            color2 = this.getColorPropertyByName(dSShape, "Background");
            d = this.unitToPoint(this.getIntPropertyByName(dSShape, "BorderWidth"));
            n4 = this.getIntPropertyByName(dSShape, "BorderStyle");
        } else {
            color = this.getColorPropertyByName(dSShape, "LineColor");
            d = this.unitToPoint(this.getIntPropertyByName(dSShape, "LineWidth"));
            n4 = this.getIntPropertyByName(dSShape, "LineStyle");
        }
        switch (n) {
            case 22: {
                break;
            }
            case 23: {
                n2 = 2;
                break;
            }
            case 20: {
                n2 = 30;
                break;
            }
            case 19: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 4;
            }
        }
        switch (n4) {
            case 0: {
                n3 = 0;
                color = null;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                n3 = 6;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 8;
            }
        }
        if (n != 22) {
            if (locInfo.getLeft() == locInfo.getRight()) {
                locInfo.setRight((short)(locInfo.getRight() + 1));
            }
            if (locInfo.getTop() == locInfo.getBottom()) {
                locInfo.setBottom((short)(locInfo.getBottom() + 1));
            }
        }
        LineStyle lineStyle = this.factory.createLineStyle(n3);
        lineStyle.setColor(color);
        lineStyle.setWidth(d);
        excelShapeInfo = this.factory.createShapeInfo(n2, lineStyle);
        ColorFillInfo colorFillInfo = this.factory.createColorFill(color2);
        excelShapeInfo.setFill(colorFillInfo);
        if (n == 20) {
            double d2 = Unit.convertUnitToInch(this.getIntPropertyByName(dSShape, "CornerFactor"));
            excelShapeInfo.setRoundBoxCorner(d2);
        } else if (n == 18 && JRLog.isError(2)) {
            JRLog.error(2, 2405112);
        }
        return excelShapeInfo;
    }

    protected int getCurrentSheetNum() {
        return this.booleanValue;
    }

    protected void showingWaitMessage(String string) {
        if (this.BORDERLINENAME) {
            try {
                System.out.println(string + ", please press OK to continue.....");
                int n = System.in.read();
                while (n != 79) {
                    n = System.in.read();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void getSomeInfo() {
        ReportHeaderInfo reportHeaderInfo = this.commu.getHeaderInfo(0);
        this.maxRows = reportHeaderInfo.getRowsPerSheet();
        this.isOneHeaderFooter = reportHeaderInfo.isNoPageBreakForExcel();
        this.excelCache.setIsOneHeaderFooter(this.isOneHeaderFooter);
        this.excelCache.setWordWrap(this.excelParameter.getWordWrapType());
        this.sheetName = reportHeaderInfo.getExcelSheetName();
        if (this.excelParameter.isXlsFormat()) {
            if (this.maxRows <= 0 || this.maxRows > 65000) {
                this.maxRows = 65000;
            }
            this.maxRowNum = 65535;
            this.maxColNum = 255;
            this.argumentsLimit = 30;
        } else {
            if (this.maxRows <= 0 || this.maxRows > 1048000) {
                this.maxRows = 1048000;
            }
            this.maxRowNum = 1048575;
            this.maxColNum = 16383;
            this.argumentsLimit = 255;
        }
    }

    protected void getSummary(DSGroup dSGroup) throws IOException {
        this.excelFormular.getSummary(dSGroup, this.getCurrentSheetNum());
    }

    protected void registerPartCrosstab(DSCrossTab dSCrossTab, Offset offset, CrossTabExpCellInfo crossTabExpCellInfo) throws IOException {
        Vector vector = dSCrossTab.getChildren();
        if (vector == null || vector.size() == 0) {
            return;
        }
        Offset offset2 = new Offset(offset, dSCrossTab.getX(), dSCrossTab.getY());
        crossTabExpCellInfo.setCurOffset(offset2);
        for (int i = 0; i < vector.size(); ++i) {
            DSCTField dSCTField = (DSCTField)vector.get(i);
            if (!this.isExport(dSCTField)) continue;
            int n = offset2.dx + dSCTField.getX();
            int n2 = offset2.dy + dSCTField.getY();
            crossTabExpCellInfo.register(dSCTField);
        }
    }

    protected void putToTable(DSCrossTab dSCrossTab, NormalCrossTab normalCrossTab) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dSCrossTab.getTemplateIndex()).append("_").append(dSCrossTab.getX()).append("_").append(dSCrossTab.getY()).append("_").append(dSCrossTab.getWidth()).append("_").append(dSCrossTab.getHeight());
        String string = stringBuffer.toString();
        if (this.crossTabInfo == null) {
            this.crossTabInfo = new Hashtable();
        }
        while (this.crossTabInfo.containsKey(string)) {
            string = string + "_O";
        }
        this.crossTabInfo.put(string, normalCrossTab);
    }

    protected NormalCrossTab poll(DSCrossTab dSCrossTab) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dSCrossTab.getTemplateIndex()).append("_").append(dSCrossTab.getX()).append("_").append(dSCrossTab.getY()).append("_").append(dSCrossTab.getWidth()).append("_").append(dSCrossTab.getHeight());
        String string = stringBuffer.toString();
        NormalCrossTab normalCrossTab = (NormalCrossTab)this.crossTabInfo.remove(string);
        while (normalCrossTab == null) {
            string = string + "_O";
            normalCrossTab = (NormalCrossTab)this.crossTabInfo.remove(string);
        }
        return normalCrossTab;
    }

    protected void addImageToSheet(ExcelWorkSheet excelWorkSheet, ExcelImageInfo excelImageInfo, LocInfo locInfo, HyperLink hyperLink) throws DocumentException {
        if (excelImageInfo != null) {
            boolean bl = true;
            if (hyperLink != null && hyperLink.getType() == 8) {
                bl = false;
            }
            if (bl) {
                this.addCell(excelWorkSheet, excelImageInfo, locInfo, hyperLink);
            } else {
                PictureInfo pictureInfo = new PictureInfo(excelImageInfo);
                pictureInfo.setLink(hyperLink);
                pictureInfo.setLoc(locInfo);
                this.imageLinks.put(pictureInfo, this.getCurrentSheetNum());
            }
        }
    }

    protected void addImageToSheet(ExcelWorkSheet excelWorkSheet, Image image, LocInfo locInfo, HyperLink hyperLink) throws DocumentException {
        if (image != null) {
            ExcelImageInfo excelImageInfo = this.factory.createImageInfo(image);
            this.addImageToSheet(excelWorkSheet, excelImageInfo, locInfo, hyperLink);
        }
    }

    private void addCell(ExcelWorkSheet excelWorkSheet, ExcelImageInfo excelImageInfo, LocInfo locInfo, HyperLink hyperLink) throws DocumentException {
        excelImageInfo.setLink(hyperLink);
        excelWorkSheet.addImage(excelImageInfo, locInfo);
    }

    protected void addCellToSheet(ExcelWorkSheet excelWorkSheet, ExcelCell excelCell) throws DocumentException {
        HyperLink hyperLink;
        boolean bl = true;
        if (excelCell.getHyperLink() != null && (hyperLink = excelCell.getHyperLink()).getType() == 8) {
            bl = false;
        }
        if (bl) {
            excelWorkSheet.addCell(excelCell);
        } else {
            this.links.put(excelCell, this.getCurrentSheetNum());
        }
    }

    protected String getRenderValue(Render render, Object object) {
        if (render instanceof RenderList) {
            RenderList renderList = (RenderList)render;
            Vector vector = renderList.getSelectedText();
            Vector vector2 = renderList.getTexts();
            AbstractList abstractList = null;
            if (vector == null || vector.size() == 0) {
                abstractList = vector2;
            } else {
                abstractList = new ArrayList(vector.size());
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    if (!vector2.contains(vector.get(i))) continue;
                    bl = true;
                    abstractList.add(vector.get(i));
                }
                if (!bl) {
                    abstractList = vector2;
                }
            }
            String string = null;
            if (abstractList != null && abstractList.size() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((String)abstractList.get(0));
                for (int i = 1; i < abstractList.size(); ++i) {
                    stringBuffer.append("\n").append((String)abstractList.get(i));
                }
                string = stringBuffer.toString();
            }
            return string;
        }
        if (render instanceof RenderDropDownList) {
            String string = null;
            RenderDropDownList renderDropDownList = (RenderDropDownList)render;
            String string2 = renderDropDownList.getSelectedTexts();
            Vector vector = renderDropDownList.getTexts();
            if (string2 != null && vector != null && vector.size() != 0) {
                string = vector.contains(string2) ? string2 : (String)vector.get(0);
            }
            return string;
        }
        if (render instanceof RenderText && object != null && object instanceof DSField) {
            return ((DSField)object).toString();
        }
        return null;
    }

    protected JRObjectResult getRealObject(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult2.getObjectType();
        while (n == 8192 && !(((DSReference)jRObjectResult2).getRefData() instanceof DSChartPlatform)) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    protected boolean asNotOneObject(DSParagraph dSParagraph) {
        if (this.excelCache.hasContainer(dSParagraph)) {
            return true;
        }
        List list = this.zOrder(dSParagraph.getChildren());
        int n = list.size();
        if (n > 0) {
            if (n == 1) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(0);
                return true;
            }
            for (int i = 0; i < n; ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.isExport(jRObjectResult) || jRObjectResult instanceof DSParagraphText) continue;
                if (jRObjectResult instanceof DSField) {
                    DSField dSField = (DSField)jRObjectResult;
                    if (CCUtil.getIntPropertyByName(dSField, "position") == 2) {
                        return true;
                    }
                    if (this.isTextField(dSField)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    protected boolean isExport(JRObjectResult jRObjectResult) {
        return this.excelCache.isExport(jRObjectResult);
    }

    protected boolean isTextField(DSField dSField) {
        return this.excelCache.isTextField(dSField);
    }

    protected List zOrder(Vector vector) {
        return vector;
    }

    protected double unitToPoint(int n) {
        return Unit.convertUnitToInch(n) * 72.0;
    }

    protected int convertUnitToPoint(int n) {
        return Unit.convertUnitToPixel(n, 72);
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getInvisible(JRObjectResult jRObjectResult) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected Image getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        ImageResource imageResource = CCUtil.getImagePropertyByName(jRObjectResult, string);
        if (imageResource == null) {
            return null;
        }
        return imageResource.getImage();
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    protected int calculateColor(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    protected int getNewIntProperty(JRVisiableResult jRVisiableResult, String string) {
        return ((Number)jRVisiableResult.getPropertyByName(string).getObject()).intValue();
    }

    protected boolean getNewBoolean(JRObjectResult jRObjectResult, String string) {
        return (Boolean)jRObjectResult.getPropertyByName(string).getObject();
    }

    protected Color getNewColorProperty(JRVisiableResult jRVisiableResult, String string) {
        return (Color)jRVisiableResult.getPropertyByName(string).getObject();
    }

    protected String getNewStringProperty(JRVisiableResult jRVisiableResult, String string) {
        return (String)jRVisiableResult.getPropertyByName(string).getObject();
    }
}

