/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.v7x;

import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.Painter;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jet.JRStopEngineException;
import jet.bean.ExcelParameter;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterField;
import jet.datastream.DSParameterForm;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextObj;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.ReportHeaderInfo;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.excel.ExcelFontInfo;
import jet.export.excel.FldBorderInfo;
import jet.export.excel.tool.PD;
import jet.export.excel.tool.PDTable;
import jet.export.excel.v7x.Biff8Font;
import jet.export.excel.v7x.Biff8SheetWrap;
import jet.export.excel.v7x.Biff8Style;
import jet.export.excel.v7x.Biff8WorkBookWrap;
import jet.export.excel.v7x.DataFormatCache;
import jet.export.relayout.table.LogicObj;
import jet.export.relayout.table.LogicRow;
import jet.export.relayout.table.TableCellWrap;
import jet.export.relayout.table.VisibleRowTable;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.export.util.FontInfo;
import jet.udo.JRObjectRender;
import jet.udos.JHyperLinkRslt;
import jet.util.Containable;
import jet.util.JRInterruptedException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class ExportToXlsBiff8
extends AbstractExporter {
    public static final String EXP = ".xls";
    public static final int ALIGNLEFT = 0;
    public static final int ALIGNCENTER = 1;
    public static final int ALIGNRIGHT = 2;
    public static final int ALIGNJUSTIFY = 3;
    private Stack BLACK;
    private Vector S;
    private Hashtable SEDU;
    private Hashtable TRUE;
    private boolean add;
    private boolean addElement = true;
    private int adjustString;
    private DataFormatCache append;
    private boolean arraycopy = false;
    private boolean asNotOneObject = false;
    private boolean black = true;
    private String booleanValue;
    private String canCacheWordWrap;
    private boolean checkFilePathExist = true;
    private ExportAuxInfo checkOutputStream;
    private int checkStop;
    private Biff8WorkBookWrap clear;
    private Biff8SheetWrap close;
    private boolean contains = false;
    private Hashtable containsKey = new Hashtable();
    private PDTable convertPixelToInch = new PDTable(256);
    private Hashtable convertUnitToInch = new Hashtable();
    private Hashtable createCell = new Hashtable();
    private int createFont = 0;
    private short[] createSheet;
    private PDTable createStyle = new PDTable(256);

    public ExportToXlsBiff8(Communicator[] communicatorArray, ExcelParameter excelParameter) {
        this._commuList = communicatorArray;
        this.checkStop = excelParameter.getWordWrapType();
        if (this.checkStop == 0) {
            this.arraycopy = true;
        } else if (this.checkStop == 2) {
            this.asNotOneObject = true;
        }
        this.add = JRLog.isError(2);
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.checkOutputStream = exportAuxInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        ArrayList<String> arrayList = null;
        OutputStream outputStream = this.getOutputStream(string);
        try {
            this.exportToStream(outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                this.treatIOException(iOException, this.canCacheWordWrap, true);
            }
        }
        arrayList = new ArrayList<String>(1);
        arrayList.add(this.canCacheWordWrap);
        return arrayList;
    }

    private OutputStream getOutputStream(String string) throws ExpException {
        this.canCacheWordWrap = this.checkFilePathExist ? (string.endsWith(EXP) ? string : string + EXP) : (string.endsWith(".zip") ? string : string + ".zip");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.canCacheWordWrap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, this.canCacheWordWrap, true);
        }
        if (this.checkFilePathExist) {
            return fileOutputStream;
        }
        String string2 = this.canCacheWordWrap.substring(0, this.canCacheWordWrap.lastIndexOf(".zip"));
        string2 = string2.endsWith(EXP) ? string2 : string2 + EXP;
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(string2);
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, this.canCacheWordWrap, true);
        }
        return zipOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.append = new DataFormatCache(this.checkOutputStream, this._commuList.length);
        this.append.setWordWrap(this.checkStop);
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.publish(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
        finally {
            this.clear();
        }
    }

    private void clear() {
        if (this.clear != null) {
            this.clear.clear();
            this.clear = null;
        }
        if (this.append != null) {
            this.append.clear();
            this.append = null;
        }
        if (this.convertUnitToInch != null) {
            this.convertUnitToInch.clear();
            this.convertUnitToInch = null;
        }
        if (this.convertPixelToInch != null) {
            this.convertPixelToInch.clear();
            this.convertPixelToInch = null;
        }
        if (this.containsKey != null) {
            this.containsKey.clear();
            this.containsKey = null;
        }
        this.createSheet = null;
        if (this.createCell != null) {
            this.createCell.clear();
            this.createCell = null;
        }
        if (this.S != null) {
            this.S.clear();
            this.S = null;
        }
        if (this.TRUE != null) {
            this.TRUE.clear();
            this.TRUE = null;
        }
        if (this.createStyle != null) {
            this.createStyle.clear();
            this.createStyle = null;
        }
        if (this.SEDU != null) {
            this.SEDU.clear();
            this.SEDU = null;
        }
    }

    private String BLACK() {
        if (this.booleanValue == null) {
            this.booleanValue = "";
        }
        int n = this.append.getNextSheetIndex(this.booleanValue);
        if (this.booleanValue == null || this.booleanValue.length() == 0) {
            return "" + n;
        }
        String string = this.append.getSheetName(this.booleanValue, n);
        return string;
    }

    private void S(Communicator communicator) {
        ReportHeaderInfo reportHeaderInfo = this._commu.getHeaderInfo(0);
        this.adjustString = reportHeaderInfo.getRowsPerSheet();
        this.booleanValue = reportHeaderInfo.getExcelSheetName();
        this.append.setPJFVersion(reportHeaderInfo.getPJFVersion());
        if (this.adjustString <= 0 || this.adjustString > 65000) {
            this.adjustString = 65000;
        }
    }

    private void publish(BufferedOutputStream bufferedOutputStream) throws IOException, ExpException, JRStopEngineException {
        DSPage dSPage;
        long l;
        CommEnumeration commEnumeration;
        int n;
        this._commu = this._commuList[0];
        this.waitCommunicator();
        this.S(this._commu);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        boolean bl = JRLog.isTrace(5);
        if (bl) {
            JRLog.indent("Export to excel 2000");
            l2 = System.currentTimeMillis();
            JRLog.trace(5, 4402201, new Timestamp(l2));
        }
        if (this.add) {
            JRLog.indent("Export to excel 2000 error element");
        }
        this.S = new Vector();
        this.BLACK = new Stack();
        this.SEDU = new Hashtable();
        this.TRUE = new Hashtable();
        this.clear = new Biff8WorkBookWrap();
        this.BLACK.push(new Offset(0, 0));
        for (n = 0; n < this._commuList.length; ++n) {
            this.append.reset(n);
            this._commu = this._commuList[n];
            if (this._commu == null) {
                this.logCommunicatorNullInfo(n);
                continue;
            }
            this.waitCommunicator();
            commEnumeration = new CommEnumeration(this._commu);
            this.S(this._commu);
            while (commEnumeration.hasMoreElements()) {
                ExportUtil.checkStop(this._commu);
                l = System.currentTimeMillis();
                dSPage = (DSPage)commEnumeration.nextElement();
                l3 = System.currentTimeMillis();
                l4 = l4 + l3 - l;
                this._commuList(dSPage);
            }
        }
        if (bl) {
            JRLog.trace(6, "After make the column table");
        }
        this.clear.regiseterFinished();
        this._commu();
        this.black = false;
        for (n = 0; n < this._commuList.length; ++n) {
            this.append.reset(n);
            this._commu = this._commuList[n];
            if (this._commu == null) {
                this.logCommunicatorNullInfo(n);
                continue;
            }
            this.TRUE();
            commEnumeration = new CommEnumeration(this._commu);
            this.S(this._commu);
            while (commEnumeration.hasMoreElements()) {
                ExportUtil.checkStop(this._commu);
                l = System.currentTimeMillis();
                dSPage = (DSPage)commEnumeration.nextElement();
                l3 = System.currentTimeMillis();
                l4 = l4 + l3 - l;
                this._commuList(dSPage);
                this.exportToStream();
            }
            this.flush();
        }
        this.clear.output(bufferedOutputStream);
        if (this.add) {
            JRLog.deIndent("Export to excel 2000 error element");
        }
        if (bl) {
            long l5 = System.currentTimeMillis();
            JRLog.trace(5, 4402202, new Timestamp(l5));
            JRLog.trace(5, 4402203, l5 - l2 - l4);
            JRLog.deIndent("Export to excel 2000");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the excel 2000");
        }
    }

    private void TRUE() {
        if (this.createFont > 0) {
            this.contains = true;
        }
    }

    private void _commu() {
        int n;
        int n2;
        int n3 = this.convertPixelToInch.size();
        if (n3 == 0) {
            return;
        }
        PD[] pDArray = new PD[n3];
        int n4 = 0;
        short s = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            PD pD = this.convertPixelToInch.get(n2);
            for (n = 0; n < n4 && pD.getPoint() >= pDArray[n].getPoint() && (pD.getPoint() != pDArray[n].getPoint() || pD.getDimension() >= pDArray[n].getDimension()); ++n) {
            }
            System.arraycopy(pDArray, n, pDArray, n + 1, n4 - n);
            pDArray[n] = pD;
            ++n4;
        }
        n2 = pDArray[0].getPoint() + pDArray[0].getDimension() / 3;
        n = pDArray[0].getDimension();
        this.containsKey.put(pDArray[0], s);
        for (int i = 0; i < n4; ++i) {
            if (pDArray[i].getPoint() < n2) {
                this.containsKey.put(pDArray[i], s);
                if (pDArray[i].getDimension() >= n) continue;
                n2 = pDArray[i].getPoint() + pDArray[i].getDimension() / 3;
                n = pDArray[i].getDimension();
                continue;
            }
            s = (short)(s + 1);
            this.containsKey.put(pDArray[i], s);
            n2 = pDArray[i].getPoint() + pDArray[i].getDimension() / 3;
            n = pDArray[i].getDimension();
        }
        this.createSheet = new short[s + 1];
    }

    private void _commuList(DSPage dSPage) {
        int n = dSPage.size();
        for (int i = 0; i < n; ++i) {
            this.append(dSPage.getObject(i), 0, true);
        }
    }

    private void add(DSSection dSSection, int n) {
        this.adjustString(dSSection, n);
    }

    private void addElement(DSSubReport dSSubReport, int n) {
        this.adjustString(dSSubReport, n);
    }

    private void adjustString(DSContainer dSContainer, int n) {
        int n2;
        Object object;
        this.BLACK.push(new Offset((Offset)this.BLACK.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        if (dSContainer instanceof DSParameterForm) {
            DSParameterForm dSParameterForm = (DSParameterForm)dSContainer;
            object = (Offset)this.BLACK.peek();
            Rectangle rectangle = dSParameterForm.getTitleRec();
            int n3 = rectangle.x + ((Offset)object).dx;
            n2 = rectangle.width;
            Color color = this.getDisplayValue(dSParameterForm, "TitleBackground");
            Color color2 = this.getDisplayValue(dSParameterForm, "TitleForeground");
            if (this.black) {
                this.convertPixelToInch.put(n3, n2);
                if (color2 != null) {
                    this.clear.registerColor(color2);
                }
                if (color != null) {
                    this.clear.registerColor(color);
                }
            } else {
                String string = this.getFieldColor(dSParameterForm, "TitleText");
                if (string != null) {
                    int n4 = rectangle.height;
                    int n5 = rectangle.y + ((Offset)object).dy;
                    Font font = dSParameterForm.getTitleFont();
                    Biff8Font biff8Font = this.clear.createFont(font.getFamily());
                    short s = (short)(Unit.convertPixelToInch(font.getSize()) * 72.0);
                    biff8Font.setFontHeightInPoints(s);
                    biff8Font.setBold(font.isBold());
                    biff8Font.setItalic(font.isItalic());
                    if (color2 == null) {
                        color2 = Color.BLACK;
                    }
                    biff8Font.setColorIndex(this.getBottomBorder(color2));
                    HSSFFont hSSFFont = this.clear.getFont(biff8Font);
                    Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
                    if (color != null) {
                        biff8Style.setFillForegroundColor(this.getBottomBorder(color));
                        biff8Style.setFillPattern((short)1);
                    }
                    biff8Style.setWrap(false);
                    int n6 = this.getExcelSheetName(dSParameterForm, "TitleHorizontalAlignment");
                    this.dx(biff8Style, n6);
                    int n7 = 1111;
                    n7 = this.error(n7);
                    HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
                    TxtBlock txtBlock = new TxtBlock(n3, n5, n2, n4, string, hSSFCellStyle, (short)font.getSize());
                    this.S.add(txtBlock);
                    Object object2 = this.getColorPropertyByName(txtBlock);
                    if (this.SEDU.get(object2) == null) {
                        this.SEDU.put(object2, txtBlock);
                    }
                }
            }
        }
        int n8 = dSContainer.getStartYPos();
        object = this.getColorIndex(dSContainer.getChildren());
        int n9 = object.size();
        for (n2 = 0; n2 < n9; ++n2) {
            JRObjectResult jRObjectResult = (JRObjectResult)object.get(n2);
            this.append(jRObjectResult, n8, true);
        }
        this.BLACK.pop();
    }

    private void append(JRObjectResult jRObjectResult, int n, boolean bl) {
        if (this.createCell(jRObjectResult = this.getClass(jRObjectResult))) {
            int n2 = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSContainer) {
                if (jRObjectResult instanceof DSSection) {
                    this.add((DSSection)jRObjectResult, n);
                } else {
                    switch (n2) {
                        case 33: 
                        case 37: 
                        case 45: {
                            this.append.handleContainerBegin((DSSubReport)jRObjectResult);
                            this.addElement((DSSubReport)jRObjectResult, n);
                            this.append.handleContainerEnd((DSSubReport)jRObjectResult);
                            break;
                        }
                        case 34: {
                            this.arraycopy((DSCrossTab)jRObjectResult, n);
                            break;
                        }
                        case 36: {
                            this.convertPixelToInch((DSTextObj)jRObjectResult, n);
                            break;
                        }
                        case 262179: {
                            this.containsKey((DSTableObject)jRObjectResult, n);
                            break;
                        }
                        case 262178: {
                            this.clear((DSParagraph)jRObjectResult, n);
                            break;
                        }
                        case 262183: {
                            this.black((DSMultiValueContainer)jRObjectResult);
                            break;
                        }
                        case 40: 
                        case 71: 
                        case 0x2000021: 
                        case 67108897: {
                            break;
                        }
                        default: {
                            this.append.handleContainerBegin((DSContainer)jRObjectResult);
                            this.adjustString((DSContainer)jRObjectResult, n);
                            this.append.handleContainerEnd((DSContainer)jRObjectResult);
                            break;
                        }
                    }
                }
            } else if (n2 == 261 && ((DSField)jRObjectResult).getStartLine() == 0) {
                this.checkFilePathExist((DSParameterField)jRObjectResult);
            } else if (jRObjectResult instanceof DSField && ((DSField)jRObjectResult).getStartLine() != -1) {
                this.convertUnitToInch((DSField)jRObjectResult, n, bl);
            } else if (n2 == 4096) {
                this.asNotOneObject((JRVisiableResult)jRObjectResult, n);
            } else if (JRLog.isAd()) {
                JRLog.print("Now, can not treat this DSObject, it is not a container! " + jRObjectResult + " type is : " + n2);
            }
        }
    }

    private void arraycopy(DSCrossTab dSCrossTab, int n) {
        this.adjustString(dSCrossTab, n);
    }

    private void asNotOneObject(JRVisiableResult jRVisiableResult, int n) {
        try {
            JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
            if (jRObjectRender != null) {
                jRObjectRender.setProperty(jRVisiableResult);
                if (jRVisiableResult instanceof JHyperLinkRslt) {
                    if (this.black) {
                        Offset offset = (Offset)this.BLACK.peek();
                        int n2 = jRVisiableResult.getX() + offset.dx;
                        this.convertPixelToInch.put(n2, jRVisiableResult.getWidth());
                        Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
                        Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
                        if (color != null) {
                            this.clear.registerColor(color);
                        }
                        if (color2 != null) {
                            this.clear.registerColor(color2);
                        }
                    } else {
                        Offset offset = (Offset)this.BLACK.peek();
                        int n3 = jRVisiableResult.getX() + offset.dx;
                        int n4 = this.getY(jRVisiableResult, n) + offset.dy;
                        int n5 = jRVisiableResult.getWidth();
                        int n6 = jRVisiableResult.getHeight();
                        String string = ((JHyperLinkRslt)jRVisiableResult).getDisplayValue();
                        if (string == null) {
                            string = "";
                        }
                        HSSFCellStyle hSSFCellStyle = this.createStyle(jRVisiableResult);
                        short s = (short)(Unit.convertUnitToInch((Integer)jRVisiableResult.getPropertyByName("fontSize").getObject()) * 72.0);
                        TxtBlock txtBlock = new TxtBlock(n3, n4, n5, n6, string, hSSFCellStyle, s);
                        this.S.addElement(txtBlock);
                        Object object = this.getColorPropertyByName(txtBlock);
                        if (this.SEDU.get(object) == null) {
                            this.SEDU.put(object, txtBlock);
                        }
                    }
                }
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            JRLog.error(2, exception);
        }
    }

    private void black(DSMultiValueContainer dSMultiValueContainer) {
        Render render = dSMultiValueContainer.getRender();
        if (render instanceof RenderList) {
            String string = this.canCacheWordWrap((RenderList)render);
            if (string != null) {
                this.checkStop(string, dSMultiValueContainer, true);
            }
        } else {
            String string = null;
            if (render instanceof RenderDropDownList) {
                string = this.booleanValue((RenderDropDownList)render);
            } else if (render instanceof RenderText) {
                string = render.getText();
            }
            if (string != null && string.length() != 0) {
                this.checkStop(string, dSMultiValueContainer, false);
            }
        }
    }

    private String booleanValue(RenderDropDownList renderDropDownList) {
        String string = null;
        String string2 = renderDropDownList.getSelectedTexts();
        Vector vector = renderDropDownList.getTexts();
        if (string2 != null && vector != null && vector.size() != 0) {
            string = vector.contains(string2) ? string2 : (String)vector.get(0);
        }
        return string;
    }

    private String canCacheWordWrap(RenderList renderList) {
        Vector vector = renderList.getSelectedText();
        Vector vector2 = renderList.getTexts();
        AbstractList abstractList = null;
        if (vector == null || vector.size() == 0) {
            abstractList = vector2;
        } else {
            abstractList = new ArrayList(vector.size());
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!vector2.contains(vector.get(i))) continue;
                bl = true;
                abstractList.add(vector.get(i));
            }
            if (!bl) {
                abstractList = vector2;
            }
        }
        String string = null;
        if (abstractList != null && abstractList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((String)abstractList.get(0));
            for (int i = 1; i < abstractList.size(); ++i) {
                stringBuffer.append("\n").append((String)abstractList.get(i));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void checkFilePathExist(DSParameterField dSParameterField) {
        Render render = dSParameterField.getRender();
        if (render != null) {
            if (this.black) {
                if (render instanceof RenderList || render instanceof RenderDropDownList || render instanceof RenderText) {
                    Offset offset = (Offset)this.BLACK.peek();
                    int n = dSParameterField.getX() + offset.dx;
                    this.convertPixelToInch.put(n, dSParameterField.getWidth());
                    Color[] colorArray = this.append.getFieldColor(dSParameterField);
                    for (int i = 0; i < colorArray.length; ++i) {
                        Color color = colorArray[i];
                        if (color == null) continue;
                        this.clear.registerColor(color);
                    }
                }
            } else if (render instanceof RenderList) {
                String string = this.canCacheWordWrap((RenderList)render);
                if (string != null) {
                    this.checkOutputStream(string, dSParameterField, true);
                }
            } else {
                String string = null;
                if (render instanceof RenderDropDownList) {
                    string = this.booleanValue((RenderDropDownList)render);
                } else if (render instanceof RenderText) {
                    string = dSParameterField.toString();
                }
                if (string != null && string.length() > 0) {
                    this.checkOutputStream(string, dSParameterField, false);
                }
            }
        }
    }

    private void checkOutputStream(String string, DSParameterField dSParameterField, boolean bl) {
        Offset offset = (Offset)this.BLACK.peek();
        int n = dSParameterField.getX() + offset.dx;
        int n2 = dSParameterField.getY() + offset.dy;
        int n3 = dSParameterField.getWidth();
        int n4 = dSParameterField.getHeight();
        FontInfo fontInfo = this.append.getFontInfo(dSParameterField);
        String string2 = fontInfo.getFontName();
        short s = (short)(Unit.convertUnitToInch(fontInfo.getFontSize()) * 72.0);
        boolean bl2 = this.getExcelBorderStyle(dSParameterField, "Bold");
        boolean bl3 = this.getExcelBorderStyle(dSParameterField, "Italic");
        ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string2, bl2, bl3);
        string2 = excelFontInfo.getFontFamily();
        bl2 = excelFontInfo.isBold();
        bl3 = excelFontInfo.isItalic();
        Color color = this.getDisplayValue(dSParameterField, "Foreground");
        Color color2 = this.dy(dSParameterField);
        short s2 = this.getBottomBorder(color);
        short s3 = color2 == null ? (short)-1 : (short)this.getBottomBorder(color2);
        Biff8Font biff8Font = this.clear.createFont(string2);
        biff8Font.setFontHeightInPoints(s);
        biff8Font.setBold(bl2);
        biff8Font.setItalic(bl3);
        biff8Font.setColorIndex(s2);
        HSSFFont hSSFFont = this.clear.getFont(biff8Font);
        Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
        if (color2 != null) {
            biff8Style.setFillForegroundColor(s3);
            biff8Style.setFillPattern((short)1);
        }
        if (bl) {
            biff8Style.setWrap(this.getChildren(true));
        }
        HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
        TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
        this.S.addElement(txtBlock);
        Object object = this.getColorPropertyByName(txtBlock);
        if (this.SEDU.get(object) == null) {
            this.SEDU.put(object, txtBlock);
        }
    }

    private void checkStop(String string, DSMultiValueContainer dSMultiValueContainer, boolean bl) {
        Color color = this.getDisplayValue(dSMultiValueContainer, "Background");
        if (this.black) {
            Offset offset = (Offset)this.BLACK.peek();
            int n = dSMultiValueContainer.getX() + offset.dx;
            this.convertPixelToInch.put(n, dSMultiValueContainer.getWidth());
            if (color != null) {
                this.clear.registerColor(color);
            }
        } else {
            Offset offset = (Offset)this.BLACK.peek();
            int n = dSMultiValueContainer.getX() + offset.dx;
            int n2 = dSMultiValueContainer.getY() + offset.dy;
            int n3 = dSMultiValueContainer.getWidth();
            int n4 = dSMultiValueContainer.getHeight();
            FontInfo fontInfo = this.append.getFontInfo(dSMultiValueContainer);
            String string2 = fontInfo.getFontName();
            short s = (short)(Unit.convertUnitToInch(fontInfo.getFontSize()) * 72.0);
            boolean bl2 = this.getExcelBorderStyle(dSMultiValueContainer, "Bold");
            boolean bl3 = this.getExcelBorderStyle(dSMultiValueContainer, "Italic");
            ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string2, bl2, bl3);
            string2 = excelFontInfo.getFontFamily();
            bl2 = excelFontInfo.isBold();
            bl3 = excelFontInfo.isItalic();
            Color color2 = Color.black;
            short s2 = this.getBottomBorder(color2);
            short s3 = color == null ? (short)-1 : (short)this.getBottomBorder(color);
            Biff8Font biff8Font = this.clear.createFont(string2);
            biff8Font.setBold(bl2);
            biff8Font.setItalic(bl3);
            biff8Font.setColorIndex(s2);
            biff8Font.setFontHeightInPoints(s);
            HSSFFont hSSFFont = this.clear.getFont(biff8Font);
            Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
            if (color != null) {
                biff8Style.setFillForegroundColor(s3);
                biff8Style.setFillPattern((short)1);
            }
            if (bl) {
                biff8Style.setWrap(this.getChildren(true));
            }
            HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
            TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
            this.S.addElement(txtBlock);
            Object object = this.getColorPropertyByName(txtBlock);
            if (this.SEDU.get(object) == null) {
                this.SEDU.put(object, txtBlock);
            }
        }
    }

    protected boolean asNotOneObject(DSParagraph dSParagraph) {
        if (this.append.hasContainer(dSParagraph)) {
            return true;
        }
        List list = this.getColorIndex(dSParagraph.getChildren());
        int n = list.size();
        if (n > 0) {
            if (n == 1) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(0);
                return jRObjectResult instanceof DSField;
            }
            for (int i = 0; i < n; ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.createCell(jRObjectResult) || jRObjectResult instanceof DSParagraphText) continue;
                if (jRObjectResult instanceof DSField) {
                    DSField dSField = (DSField)jRObjectResult;
                    if (CCUtil.getIntPropertyByName(dSField, "position") != 2) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private void clear(DSParagraph dSParagraph, int n) {
        boolean bl;
        boolean bl2 = bl = !this.asNotOneObject(dSParagraph);
        if (bl) {
            int n2;
            Object object;
            List list = this.getColorIndex(dSParagraph.getChildren());
            int n3 = list.size();
            String string = "";
            JRVisiableResult jRVisiableResult = null;
            boolean bl3 = true;
            ArrayList<JRVisiableResult> arrayList = new ArrayList<JRVisiableResult>(2);
            if (n3 > 0) {
                object = new ArrayList();
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < n3; ++n2) {
                    Object object2;
                    JRVisiableResult jRVisiableResult2;
                    JRObjectResult jRObjectResult = (JRObjectResult)list.get(n2);
                    if (!this.createCell(jRObjectResult)) continue;
                    if (jRObjectResult instanceof DSParagraphText) {
                        jRVisiableResult2 = (DSParagraphText)jRObjectResult;
                        object2 = ((DSParagraphText)jRVisiableResult2).getText();
                        if (object2 != null) {
                            stringBuffer.append((String)object2);
                        }
                        bl3 = false;
                        continue;
                    }
                    if (!(jRObjectResult instanceof DSField)) continue;
                    jRVisiableResult2 = (DSField)jRObjectResult;
                    if (this.getExcelFontInfo(jRVisiableResult2, "position") == 3) {
                        arrayList.add(jRVisiableResult2);
                        bl3 = false;
                        continue;
                    }
                    object2 = jRVisiableResult2.getTemplate();
                    jRVisiableResult = jRVisiableResult2;
                    if (object.contains(object2)) continue;
                    object.add(object2);
                    if (!(((DSField)jRObjectResult).getRender() instanceof RenderText)) continue;
                    String string2 = jRObjectResult.toString();
                    if (object.size() > 1) {
                        bl3 = false;
                    }
                    if (string2 == null) continue;
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            if (string.length() != 0) {
                if (this.black) {
                    Object object3;
                    object = (Offset)this.BLACK.peek();
                    int n4 = dSParagraph.getX() + ((Offset)object).dx;
                    this.convertPixelToInch.put(n4, dSParagraph.getWidth());
                    if (bl3) {
                        object3 = this.append.getFieldColor((DSField)jRVisiableResult);
                        this.clear.registerColor(object3[0]);
                        this.clear.registerColor(object3[2]);
                        if (object3[1] != null) {
                            this.clear.registerColor(object3[1]);
                        }
                    } else {
                        object3 = this.getDisplayValue(dSParagraph, "Foreground");
                        this.clear.registerColor((Color)object3);
                    }
                } else {
                    object = (Offset)this.BLACK.peek();
                    int n5 = dSParagraph.getX() + ((Offset)object).dx;
                    n2 = this.getY(dSParagraph, n) + ((Offset)object).dy;
                    int n6 = dSParagraph.getWidth();
                    int n7 = dSParagraph.getHeight();
                    if (bl3) {
                        this.close(n5, n2, n6, n7, string, (DSField)jRVisiableResult);
                    } else {
                        this.contains(n5, n2, n6, n7, string, dSParagraph);
                    }
                }
            }
            if (arrayList.size() != 0) {
                this.BLACK.push(new Offset((Offset)this.BLACK.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                int n8 = dSParagraph.getStartYPos();
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.append((DSField)arrayList.get(i), n8, true);
                }
                this.BLACK.pop();
            }
        } else {
            this.BLACK.push(new Offset((Offset)this.BLACK.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
            List list = this.getColorIndex(dSParagraph.getChildren());
            int n9 = dSParagraph.getStartYPos();
            int n10 = list.size();
            for (int i = 0; i < n10; ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.createCell(jRObjectResult)) continue;
                if (jRObjectResult instanceof DSParagraphText) {
                    DSParagraphText dSParagraphText = (DSParagraphText)jRObjectResult;
                    String string = dSParagraphText.getText();
                    if (string == null || string.length() <= 0) continue;
                    Offset offset = (Offset)this.BLACK.peek();
                    int n11 = dSParagraphText.getX() + offset.dx;
                    int n12 = this.getY(dSParagraphText, n9) + offset.dy;
                    int n13 = dSParagraphText.getWidth();
                    int n14 = dSParagraphText.getHeight();
                    this.createFont(n11, n12, n13, n14, string, dSParagraphText);
                    continue;
                }
                this.append(jRObjectResult, n9, true);
            }
            this.BLACK.pop();
        }
    }

    private void close(int n, int n2, int n3, int n4, String string, DSField dSField) {
        FontInfo fontInfo = this.append.getFontInfo(dSField);
        String string2 = fontInfo.getFontName();
        boolean bl = this.getEndLine(dSField, "Bold");
        boolean bl2 = this.getEndLine(dSField, "Italic");
        ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string2, bl, bl2);
        String string3 = excelFontInfo.getFontFamily();
        short s = (short)(Unit.convertUnitToInch(fontInfo.getFontSize()) * 72.0);
        Color color = this.getDimension(dSField, "Foreground");
        bl = excelFontInfo.isBold();
        bl2 = excelFontInfo.isItalic();
        short s2 = this.getBottomBorder(color);
        Biff8Font biff8Font = this.clear.createFont(string3);
        biff8Font.setBold(bl);
        biff8Font.setItalic(bl2);
        biff8Font.setColorIndex(s2);
        biff8Font.setFontHeightInPoints(s);
        HSSFFont hSSFFont = this.clear.getFont(biff8Font);
        Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
        biff8Style.setWrap(this.getChildren(true));
        HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
        TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
        this.S.addElement(txtBlock);
        Object object = this.getColorPropertyByName(txtBlock);
        if (this.SEDU.get(object) == null) {
            this.SEDU.put(object, txtBlock);
        }
    }

    private void contains(int n, int n2, int n3, int n4, String string, DSParagraph dSParagraph) {
        FontInfo fontInfo = this.append.getFontInfo(dSParagraph);
        String string2 = fontInfo.getFontName();
        short s = (short)(Unit.convertUnitToInch(fontInfo.getFontSize()) * 72.0);
        boolean bl = this.getExcelBorderStyle(dSParagraph, "Bold");
        boolean bl2 = this.getExcelBorderStyle(dSParagraph, "Italic");
        ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string2, bl, bl2);
        string2 = excelFontInfo.getFontFamily();
        bl = excelFontInfo.isBold();
        bl2 = excelFontInfo.isItalic();
        Color color = this.getDisplayValue(dSParagraph, "Foreground");
        short s2 = this.getBottomBorder(color);
        Biff8Font biff8Font = this.clear.createFont(string2);
        biff8Font.setBold(bl);
        biff8Font.setItalic(bl2);
        biff8Font.setColorIndex(s2);
        biff8Font.setFontHeightInPoints(s);
        HSSFFont hSSFFont = this.clear.getFont(biff8Font);
        Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
        biff8Style.setWrap(this.getChildren(true));
        HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
        TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
        this.S.addElement(txtBlock);
        Object object = this.getColorPropertyByName(txtBlock);
        if (this.SEDU.get(object) == null) {
            this.SEDU.put(object, txtBlock);
        }
    }

    private void containsKey(DSTableObject dSTableObject, int n) {
        VisibleRowTable visibleRowTable = VisibleRowTable.getInstance(dSTableObject, this.append, (byte)1);
        this.BLACK.push(new Offset((Offset)this.BLACK.peek(), dSTableObject.getX(), this.getY(dSTableObject, n)));
        while (visibleRowTable.hasMoreChild()) {
            LogicObj logicObj = visibleRowTable.nextChild();
            if (logicObj.getType() == 0) {
                LogicRow logicRow = (LogicRow)logicObj;
                this.BLACK.push(new Offset((Offset)this.BLACK.peek(), logicRow.getX(), logicRow.getY()));
                while (logicRow.hasMoreChild()) {
                    TableCellWrap tableCellWrap = logicRow.nextChild();
                    this.BLACK.push(new Offset((Offset)this.BLACK.peek(), tableCellWrap.getX(), tableCellWrap.getY()));
                    List list = tableCellWrap.getChildren();
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        this.append((JRObjectResult)list.get(i), n, false);
                    }
                    this.BLACK.pop();
                }
                this.BLACK.pop();
                continue;
            }
            if (logicObj.getType() != 1) continue;
        }
        this.BLACK.pop();
    }

    private void convertPixelToInch(DSTextObj dSTextObj, int n) {
        if (this.addElement) {
            DSField dSField = null;
            Vector vector = dSTextObj.getChildren();
            int n2 = vector.size();
            if (n2 > 0) {
                if (this.black) {
                    Offset offset = (Offset)this.BLACK.peek();
                    int n3 = dSTextObj.getX() + offset.dx;
                    this.convertPixelToInch.put(n3, dSTextObj.getWidth());
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n2; ++i) {
                        boolean bl;
                        JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                        int n4 = jRObjectResult.getObjectType();
                        boolean bl2 = bl = !this.getEndLine(jRObjectResult, "Invisible");
                        if (!bl || !(jRObjectResult instanceof DSField)) continue;
                        DSField dSField2 = (DSField)jRObjectResult;
                        if (dSField == null || dSField instanceof DSDBField) {
                            dSField = dSField2;
                        }
                        stringBuffer.append(dSField2.toString());
                    }
                    String string = stringBuffer.toString();
                    if (string.length() > 0) {
                        Offset offset = (Offset)this.BLACK.peek();
                        int n5 = dSTextObj.getX() + offset.dx;
                        int n6 = this.getY(dSTextObj, n) + offset.dy;
                        int n7 = dSTextObj.getWidth();
                        int n8 = dSTextObj.getHeight();
                        this.currentTimeMillis(n5, n6, n7, n8, string, dSField);
                    }
                }
            }
        } else {
            this.adjustString(dSTextObj, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void convertUnitToInch(DSField dSField, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        if (!this.append.isTextField(dSField)) return;
        if (this.black) {
            Offset offset = (Offset)this.BLACK.peek();
            int n5 = dSField.getX() + offset.dx;
            this.convertPixelToInch.put(n5, dSField.getWidth());
            Color[] colorArray = this.append.getFieldColor(dSField);
            this.clear.registerColor(colorArray[0]);
            this.clear.registerColor(colorArray[2]);
            if (colorArray[1] == null) return;
            this.clear.registerColor(colorArray[1]);
            return;
        }
        String string = this.append.getFieldValue(dSField);
        if (string == null) return;
        int[][] nArray = dSField.getLineBreakPos();
        if (nArray != null) {
            string = Painter.adjustString(string);
            n4 = dSField.getObjectType();
            if (n4 == 257) {
                n3 = dSField.getStartLine();
                if (n3 < 0) return;
                if (n3 >= nArray.length) return;
                n2 = dSField.getEndLine();
                if (n2 >= 0) {
                    n2 = Math.min(nArray.length - 1, n2) < 0 ? 0 : Math.min(nArray.length - 1, n2);
                    string = string.substring(nArray[n3][0], nArray[n2][0] + nArray[n2][1]);
                }
            } else if (bl) {
                if (string.length() > 50) {
                    n3 = dSField.getStartLine();
                    n2 = dSField.getEndLine();
                    if (n2 < 0) {
                        JRLog.error(2, 2405109, new Object[]{string.length(), n2});
                        return;
                    }
                    n2 = Math.min(nArray.length - 1, n2) < 0 ? 0 : Math.min(nArray.length - 1, n2);
                    string = string.substring(nArray[n3][0], nArray[n2][0] + nArray[n2][1]);
                } else if (dSField.getStartLine() > 0) {
                    return;
                }
            }
        }
        Offset offset = (Offset)this.BLACK.peek();
        n4 = dSField.getX() + offset.dx;
        n3 = this.getY(dSField, n) + offset.dy;
        n2 = dSField.getWidth();
        int n6 = dSField.getHeight();
        this.currentTimeMillis(n4, n3, n2, n6, string, dSField);
    }

    private boolean createCell(JRObjectResult jRObjectResult) {
        boolean bl = this.append.isExport(jRObjectResult);
        if (bl) {
            switch (jRObjectResult.getObjectType()) {
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 71: 
                case 128: 
                case 129: 
                case 65540: 
                case 65541: 
                case 65542: 
                case 0x2000021: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private void createFont(int n, int n2, int n3, int n4, String string, DSParagraphText dSParagraphText) {
        Color color = this.getDisplayValue(dSParagraphText, "Foreground");
        Color color2 = this.getDisplayValue(dSParagraphText, "Background");
        if (this.black) {
            this.clear.registerColor(color);
            if (color2 != null) {
                this.clear.registerColor(color2);
            }
            this.convertPixelToInch.put(n, n3);
            return;
        }
        FontInfo fontInfo = this.append.getFontInfo(dSParagraphText);
        String string2 = fontInfo.getFontName();
        short s = (short)(Unit.convertUnitToInch(fontInfo.getFontSize()) * 72.0);
        boolean bl = this.getExcelBorderStyle(dSParagraphText, "Bold");
        boolean bl2 = this.getExcelBorderStyle(dSParagraphText, "Italic");
        ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string2, bl, bl2);
        string2 = excelFontInfo.getFontFamily();
        bl = excelFontInfo.isBold();
        bl2 = excelFontInfo.isItalic();
        short s2 = this.getBottomBorder(color);
        short s3 = color2 == null ? (short)-1 : (short)this.getBottomBorder(color2);
        Biff8Font biff8Font = this.clear.createFont(string2);
        biff8Font.setBold(bl);
        biff8Font.setItalic(bl2);
        biff8Font.setColorIndex(s2);
        biff8Font.setFontHeightInPoints(s);
        HSSFFont hSSFFont = this.clear.getFont(biff8Font);
        Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
        if (s3 != -1) {
            biff8Style.setFillForegroundColor(s3);
            biff8Style.setFillPattern((short)1);
        }
        HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
        TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
        this.S.addElement(txtBlock);
        Object object = this.getColorPropertyByName(txtBlock);
        if (this.SEDU.get(object) == null) {
            this.SEDU.put(object, txtBlock);
        }
    }

    private HSSFCellStyle createSheet(DSField dSField) {
        FldBorderInfo fldBorderInfo;
        Object object;
        Color color;
        Object object2;
        int n;
        int n2;
        Object object3;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)this.TRUE.get(dSTemplatible);
        if (hSSFCellStyle != null) {
            return hSSFCellStyle;
        }
        HSSFFont hSSFFont = (HSSFFont)this.createCell.get(dSTemplatible);
        boolean bl = true;
        if (hSSFFont == null) {
            if (this.convertUnitToInch.containsKey(dSTemplatible)) {
                bl = false;
            }
            object3 = this.append.getFontInfo(dSField);
            String string = ((FontInfo)object3).getFontName();
            n2 = this.getEndLine(dSField, "Bold");
            n = this.getEndLine(dSField, "Italic");
            if (bl) {
                bl = ((FontInfo)object3).isCanBeCache();
            }
            if (bl) {
                boolean bl2 = bl = !CCUtil.isChangeByFormularProperty(dSField, "Bold");
                if (bl) {
                    bl = !CCUtil.isChangeByFormularProperty(dSField, "Italic");
                }
            }
            ExcelFontInfo excelFontInfo = this.append.getExcelFontInfo(string, n2 != 0, n != 0);
            object2 = excelFontInfo.getFontFamily();
            short s = (short)(Unit.convertUnitToInch(((FontInfo)object3).getFontSize()) * 72.0);
            color = this.getDimension(dSField, "Foreground");
            object = this.clear.createFont((String)object2);
            ((Biff8Font)object).setFontHeightInPoints(s);
            ((Biff8Font)object).setItalic(excelFontInfo.isItalic());
            ((Biff8Font)object).setBold(excelFontInfo.isBold());
            ((Biff8Font)object).setColorIndex(this.getBottomBorder(color));
            hSSFFont = this.clear.getFont((Biff8Font)object);
            if (bl) {
                boolean bl3 = bl = !CCUtil.isChangeByFormularProperty(dSField, "Foreground");
            }
            if (bl) {
                this.createCell.put(dSTemplatible, hSSFFont);
            } else {
                this.convertUnitToInch.put(dSTemplatible, Boolean.TRUE);
            }
        } else {
            bl = false;
        }
        object3 = this.getDimension(dSField, "Background");
        if (object3 == null) {
            object3 = this.elements(dSField);
            bl = false;
        } else if (bl) {
            bl = !CCUtil.isChangeByFormularProperty(dSField, "Background");
        }
        short s = object3 == null ? (short)-1 : (short)this.getBottomBorder((Color)object3);
        n2 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        n = CCUtil.getIntPropertyByName(dSField, "VerticalAlignment");
        boolean bl4 = this.append.getWordWrap(dSField);
        object2 = this.getDimension(dSField, "BorderColor");
        try {
            fldBorderInfo = this.append.getExcelBorderStyle(dSField);
        }
        catch (IOException iOException) {
            fldBorderInfo = new FldBorderInfo();
        }
        object = this.clear.createStyle(hSSFFont);
        if (object3 != null) {
            ((Biff8Style)object).setFillForegroundColor(s);
            ((Biff8Style)object).setFillPattern((short)1);
        }
        ((Biff8Style)object).setWrap(bl4);
        if (bl) {
            bl = this.append.canCacheWordWrap(dSField);
        }
        this.dx((Biff8Style)object, n2);
        this.deIndent((Biff8Style)object, n);
        short s2 = this.getBottomBorder((Color)object2);
        ((Biff8Style)object).setTopBorderColor(s2);
        ((Biff8Style)object).setBottomBorderColor(s2);
        ((Biff8Style)object).setLeftBorderColor(s2);
        ((Biff8Style)object).setRightBorderColor(s2);
        if (bl) {
            bl = !CCUtil.isChangeByFormularProperty(dSField, "BorderColor");
        }
        ((Biff8Style)object).setBorderTop(fldBorderInfo.getTopBorder());
        ((Biff8Style)object).setBorderBottom(fldBorderInfo.getBottomBorder());
        ((Biff8Style)object).setBorderLeft(fldBorderInfo.getLeftBorder());
        ((Biff8Style)object).setBorderRight(fldBorderInfo.getRightBorder());
        color = this.clear.getStyle((Biff8Style)object);
        if (bl) {
            this.TRUE.put(dSTemplatible, color);
        }
        return color;
    }

    private HSSFCellStyle createStyle(JRVisiableResult jRVisiableResult) {
        FontInfo fontInfo = this.append.getUdoFontInfo(jRVisiableResult);
        String string = fontInfo.getFontName();
        Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
        short s = this.getBottomBorder(color);
        boolean bl = (Boolean)jRVisiableResult.getPropertyByName("fontBold").getObject();
        boolean bl2 = (Boolean)jRVisiableResult.getPropertyByName("fontItalic").getObject();
        short s2 = (short)Unit.convertUnitToInch(fontInfo.getFontSize() * 72);
        Biff8Font biff8Font = this.clear.createFont(string);
        biff8Font.setBold(bl);
        biff8Font.setColorIndex(s);
        biff8Font.setItalic(bl2);
        HSSFFont hSSFFont = this.clear.getFont(biff8Font);
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        int n2 = CCUtil.getIntPropertyByName(jRVisiableResult, "VerticalAlignment");
        Color color2 = (Color)jRVisiableResult.getPropertyByName("background").getObject();
        short s3 = color2 == null ? (short)-1 : (short)this.getBottomBorder(color2);
        boolean bl3 = this.getEndLine(jRVisiableResult, "wordWrap");
        Biff8Style biff8Style = this.clear.createStyle(hSSFFont);
        if (color2 != null) {
            biff8Style.setFillForegroundColor(s3);
            biff8Style.setFillPattern((short)1);
        }
        biff8Style.setWrap(this.getChildren(bl3));
        this.dx(biff8Style, n);
        this.deIndent(biff8Style, n);
        HSSFCellStyle hSSFCellStyle = this.clear.getStyle(biff8Style);
        return hSSFCellStyle;
    }

    private void currentTimeMillis(int n, int n2, int n3, int n4, String string, DSField dSField) {
        HSSFCellStyle hSSFCellStyle = this.createSheet(dSField);
        short s = (short)(Unit.convertUnitToInch(this.getExcelFontInfo(dSField, "FontSize")) * 72.0);
        int n5 = 1111;
        n5 = this.error(n5);
        TxtBlock txtBlock = new TxtBlock(n, n2, n3, n4, string, hSSFCellStyle, s);
        this.S.add(txtBlock);
        Object object = this.getColorPropertyByName(txtBlock);
        if (this.SEDU.get(object) == null) {
            this.SEDU.put(object, txtBlock);
        }
    }

    private void deIndent(Biff8Style biff8Style, int n) {
        switch (n) {
            case 1: {
                biff8Style.setVerAlignment((short)0);
                break;
            }
            case 2: {
                biff8Style.setVerAlignment((short)2);
                break;
            }
            case 0: {
                biff8Style.setVerAlignment((short)1);
                break;
            }
            default: {
                biff8Style.setVerAlignment((short)3);
            }
        }
    }

    private void dx(Biff8Style biff8Style, int n) {
        switch (n) {
            case 0: {
                biff8Style.setAlignment((short)1);
                break;
            }
            case 1: {
                biff8Style.setAlignment((short)3);
                break;
            }
            case 2: {
                biff8Style.setAlignment((short)2);
                break;
            }
            default: {
                biff8Style.setAlignment((short)5);
            }
        }
    }

    private Color dy(DSField dSField) {
        Color color = null;
        color = this.getDimension(dSField, "Background");
        if (color == null) {
            color = this.elements(dSField);
        }
        return color;
    }

    private Color elements(DSField dSField) {
        Color color = null;
        if (((JRObjectResult)((Object)dSField.getParent())).getObjectType() == 34) {
            CTGridInfo cTGridInfo = ((DSCTField)dSField).getParentGridInfo();
            color = cTGridInfo.fillColor;
            if (color == null) {
                color = this.endsWith(dSField);
            }
        } else {
            color = this.endsWith(dSField);
        }
        return color;
    }

    private Color endsWith(JRVisiableResult jRVisiableResult) {
        Containable containable;
        Color color = null;
        if (jRVisiableResult.getParent() != null && (containable = jRVisiableResult.getParent()) instanceof DSContainer) {
            DSContainer dSContainer = (DSContainer)containable;
            if (dSContainer.getObjectType() == 262178) {
                color = this.endsWith(dSContainer);
            } else {
                Containable containable2;
                int n;
                if ((dSContainer instanceof DSSection || dSContainer instanceof DSTableRow || dSContainer instanceof DSBody) && (n = CCUtil.getIntPropertyByName(dSContainer, "BackgroundType")) != 0) {
                    return color;
                }
                color = this.getDimension(dSContainer, "Background");
                if (color == null && dSContainer.getParent() != null && (containable2 = dSContainer.getParent()) instanceof DSContainer) {
                    int n2;
                    if ((containable2 instanceof DSSection || containable2 instanceof DSTableRow || containable2 instanceof DSBody) && (n2 = CCUtil.getIntPropertyByName((JRObjectResult)((Object)containable2), "BackgroundType")) != 0) {
                        return color;
                    }
                    color = this.getDimension((JRObjectResult)((Object)containable2), "Background");
                }
            }
        }
        return color;
    }

    private int error(int n) {
        int n2 = 1;
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 0;
                break;
            }
            case -7: {
                n2 = 4;
                break;
            }
        }
        return n2;
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private void exportToStream() {
        List list;
        int n;
        int n2;
        int n3 = this.SEDU.size();
        if (n3 == 0) {
            return;
        }
        TxtBlock[] txtBlockArray = new TxtBlock[n3];
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.SEDU.elements();
        while (enumeration.hasMoreElements()) {
            TxtBlock txtBlock = (TxtBlock)enumeration.nextElement();
            for (n2 = 0; n2 < n4 && txtBlock.y >= txtBlockArray[n2].y && (txtBlock.y != txtBlockArray[n2].y || txtBlock.height >= txtBlockArray[n2].height); ++n2) {
            }
            System.arraycopy(txtBlockArray, n2, txtBlockArray, n2 + 1, n4 - n2);
            txtBlockArray[n2] = txtBlock;
            ++n4;
        }
        n2 = txtBlockArray[0].y + txtBlockArray[0].height / 2;
        int n6 = txtBlockArray[0].height;
        this.SEDU.put(this.getColorPropertyByName(txtBlockArray[0]), n5);
        for (int i = 0; i < n4; ++i) {
            if (txtBlockArray[i].y < n2) {
                this.SEDU.put(this.getColorPropertyByName(txtBlockArray[i]), n5);
                if (txtBlockArray[i].height >= n6) continue;
                n2 = txtBlockArray[i].y + txtBlockArray[i].height / 2;
                n6 = txtBlockArray[i].height;
                continue;
            }
            this.SEDU.put(this.getColorPropertyByName(txtBlockArray[i]), ++n5);
            n2 = txtBlockArray[i].y + txtBlockArray[i].height / 2;
            n6 = txtBlockArray[i].height;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i <= n5; ++i) {
            arrayList.add(new Vector());
        }
        n4 = this.S.size();
        TxtBlock txtBlock = null;
        for (n = 0; n < n4; ++n) {
            txtBlock = (TxtBlock)this.S.get(n);
            n5 = (Integer)this.SEDU.get(this.getColorPropertyByName(txtBlock));
            list = (Vector)arrayList.get(n5);
            list.add(txtBlock);
        }
        this.SEDU.clear();
        n = arrayList.size();
        if (this.close == null || this.contains) {
            this.fillColor();
        } else if (this.createFont + n + 1 >= this.adjustString) {
            this.flush();
            this.fillColor();
        }
        for (int i = 0; i < n; ++i) {
            list = (List)arrayList.get(i);
            if (list.isEmpty()) continue;
            int n7 = i + this.createFont;
            if (n7 > 65535) {
                if (!JRLog.isError(2)) break;
                JRLog.error(2, 2402207);
                break;
            }
            HSSFRow hSSFRow = this.close.getRow(i + this.createFont);
            for (int j = 0; j < list.size(); ++j) {
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                TxtBlock txtBlock2 = (TxtBlock)list.get(j);
                short s = (Short)this.containsKey.get(this.convertPixelToInch.getPD(txtBlock2.x, txtBlock2.width));
                if (s > 255) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, 2402208, new Object[]{n7, (int)s, txtBlock2.text});
                    continue;
                }
                HSSFCell hSSFCell = hSSFRow.createCell(s);
                this.get(hSSFCell, txtBlock2);
                hSSFCell.setCellStyle(txtBlock2.sty);
                if (txtBlock2.text.indexOf("\n") == -1) {
                    n12 = txtBlock2.text.length();
                } else {
                    String string = txtBlock2.text;
                    n11 = 0;
                    n12 = 0;
                    while ((n10 = string.indexOf("\n", n11)) != -1) {
                        if (n10 - n11 > n12) {
                            n12 = n10 - n11;
                        }
                        n11 = n10 + 1;
                    }
                }
                if (n12 <= 3) {
                    n12 = 4;
                }
                if ((n9 = (int)((double)(n12 * txtBlock2.fontsize) * 1.38 * 21.0)) > Short.MAX_VALUE) {
                    n9 = Short.MAX_VALUE;
                }
                n11 = (short)n9;
                n9 = (int)((double)txtBlock2.width / 1.62);
                if (n9 > Short.MAX_VALUE) {
                    n9 = Short.MAX_VALUE;
                }
                int n13 = n8 = n11 > (n10 = (int)((short)n9)) ? n10 : n11;
                if (n8 <= this.createSheet[s]) continue;
                this.createSheet[s] = n8;
            }
        }
        this.createFont += n;
        this.S.removeAllElements();
    }

    private void fillColor() {
        HSSFSheet hSSFSheet = this.clear.createSheet(this.BLACK());
        if (this.close == null) {
            this.close = new Biff8SheetWrap(hSSFSheet);
        } else {
            this.close.setCurrentSheet(hSSFSheet);
        }
        this.fontsize();
        this.createFont = 0;
        this.contains = false;
    }

    private void flush() {
        if (this.createSheet != null) {
            this.close.setColumnWidth(this.createSheet);
        }
    }

    private void fontsize() {
        for (int i = 0; i < this.createSheet.length; ++i) {
            this.createSheet[i] = -1;
        }
    }

    private void get(HSSFCell hSSFCell, TxtBlock txtBlock) {
        this.getBooleanPropertyByName(hSSFCell, txtBlock);
    }

    private void getBooleanPropertyByName(HSSFCell hSSFCell, TxtBlock txtBlock) {
        String string = txtBlock.text;
        if (string.length() > Short.MAX_VALUE) {
            string = string.substring(0, Short.MAX_VALUE);
        }
        hSSFCell.setCellValue(string);
        hSSFCell.setCellType(1);
    }

    private short getBottomBorder(Color color) {
        return this.clear.getColorIndex(color);
    }

    private boolean getChildren(boolean bl) {
        if (this.arraycopy) {
            return bl;
        }
        return this.asNotOneObject;
    }

    private JRObjectResult getClass(JRObjectResult jRObjectResult) {
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
            n = jRObjectResult.getObjectType();
        }
        return jRObjectResult;
    }

    private List getColorIndex(List list) {
        return list;
    }

    private Object getColorPropertyByName(TxtBlock txtBlock) {
        return this.createStyle.getPD(txtBlock.y, txtBlock.height);
    }

    private Color getDimension(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    private Color getDisplayValue(JRObjectResult jRObjectResult, String string) {
        return (Color)jRObjectResult.getPropertyByName(string).getObject();
    }

    private boolean getEndLine(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    private boolean getExcelBorderStyle(JRObjectResult jRObjectResult, String string) {
        return (Boolean)jRObjectResult.getPropertyByName(string).getObject();
    }

    private int getExcelFontInfo(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    private int getExcelSheetName(JRObjectResult jRObjectResult, String string) {
        return ((Number)jRObjectResult.getPropertyByName(string).getObject()).intValue();
    }

    private String getFamily(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    private String getFieldColor(JRObjectResult jRObjectResult, String string) {
        return ((String)jRObjectResult.getPropertyByName(string).getObject()).trim();
    }

    class TxtBlock {
        int x;
        int y;
        int width;
        int height;
        String text;
        short fontsize;
        HSSFCellStyle sty;

        public TxtBlock(int n, int n2, int n3, int n4, String string, HSSFCellStyle hSSFCellStyle, short s) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.text = string;
            this.sty = hSSFCellStyle;
            this.fontsize = s;
        }
    }
}

