/*
 * Decompiled with CFR 0.152.
 */
package jet.export.html;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.ReportEnv;
import jet.bean.Filenames;
import jet.bean.HtmlParameter;
import jet.bean.StopExportListener;
import jet.datastream.Communicator;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSPage;
import jet.export.ExpException;
import jet.export.html.HtmlDrillPageExporter;
import jet.export.html.HtmlExporter;
import jet.export.util.ExportUtil;
import jet.rptengine.EngineRefreshListener;
import jet.rptengine.ExportFinishListener;
import jet.rptengine.JCommunicator;
import jet.util.JRInterruptedException;
import jet.util.TempFile;

public class HtmlPipeExporter
extends HtmlExporter
implements Runnable,
StopExportListener,
EngineRefreshListener {
    int stop;
    Filenames fn;
    boolean isPipeLineExport = false;
    boolean finish = false;
    boolean dirty = false;
    private Vector SEDU = new Vector();
    boolean isAllComms = false;
    ArrayList _communicators = new ArrayList();
    int _lastPgIndexInFn = 0;
    private Iterator add;
    boolean isRefresh = false;
    Set refreshPages = new HashSet();
    boolean olap;

    public HtmlPipeExporter(Communicator communicator, HtmlParameter htmlParameter) {
        super(communicator, htmlParameter);
    }

    public Filenames start() {
        this.fn = new Filenames();
        this.fn.addStopListener(this);
        this.fn.setRstFiles(this._rstFileList);
        new Thread(this).start();
        return this.fn;
    }

    @Override
    void exportDSChart(DSChartPlatform dSChartPlatform) throws IOException, JRStopEngineException, OutOfSpaceException {
        if (this.isPipeLineExport && !this._params.isIncludeDrillDownFile()) {
            this.refresh(this._currentProcessPageCount);
        }
        if (dSChartPlatform.isDirty(this._pageNum) && !this._params.isIncludeDrillDownFile()) {
            return;
        }
        super.exportDSChart(dSChartPlatform);
    }

    public void appendComms(Communicator communicator, boolean bl) {
        this.isAllComms = bl;
        this._communicators.add(communicator);
    }

    @Override
    protected void exportDrillPage(int n) throws ExpException, IOException, JRStopEngineException, OutOfSpaceException {
        super.exportDrillPage(n);
        if (this.isPipeLineExport) {
            this.fn.add(((HtmlExporter.DrillDownPage)this._drillDownPagesOfCurrentPage.get((int)n)).drillDownName);
        }
    }

    protected void getBackUrl() throws IOException {
        this.writeHtmlTag(this._params.getUrl() + ((int[])this.pageNumToPipeIndexMap.get(new Integer(this._pageNum)))[0]);
    }

    @Override
    protected String getDrillDetailUrl(HtmlExporter.DrillDownPage drillDownPage) {
        int n = 0;
        if (this._pageNum != 1) {
            int[] nArray = (int[])this.pageNumToPipeIndexMap.get(new Integer(this._pageNum - 1));
            n = nArray[0] + nArray[1] + 1;
        }
        int n2 = n + this._drillDownPagesOfCurrentPage.size() + 1;
        return this._params.getUrl() + n2;
    }

    @Override
    protected void drawNavigatorButton(int n, String string) throws IOException {
        this.FIRST();
        if (this._params.isSect508Html()) {
            this.writeHtmlTag("<a href=\"#mainContentID\" accesskey=\"s\" title=\"skip to main content\">Skip</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (n > 1) {
            this.drawFirstButton();
            this.writeHtmlTag(string);
            this.drawPriorButton(n);
            this.writeHtmlTag(string);
        }
        if (this.dirty) {
            this.writeHtmlTag("<a href=\"" + this._params.getUrl() + (n - 1) + "\" title=\"" + this.REFRESH + "\">" + this.REFRESH + "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeHtmlTag(string);
        }
        if (!this.finish || this.isRefresh && n < this._lastPgIndexInFn + 1) {
            this.drawNextButton(n);
            this.writeHtmlTag(string);
            if (this._params.getLastPageURL() != null) {
                this.drawLastButton();
            }
        }
        if (this._params.isSect508Html()) {
            this.writeHtmlTag("<a id=\"mainContent\" name=\"mainContent\" style=\"width:25px;\"></a>");
        }
    }

    @Override
    protected void drawPriorButton(int n) throws IOException {
        int[] nArray = (int[])this.pageNumToPipeIndexMap.get(new Integer(this._pageNum - 1));
        int n2 = nArray[0];
        this.drawNavigationHrefTag(this.PREV, this._params.getUrl() + n2, false);
    }

    @Override
    protected void drawLastButton() throws IOException {
        this.drawNavigationHrefTag(this.LAST, this._params.getLastPageURL(), false);
    }

    @Override
    protected void drawNextButton(int n) throws IOException {
        int[] nArray = (int[])this.pageNumToPipeIndexMap.get(new Integer(this._pageNum));
        int n2 = nArray[0] + nArray[1] + 1;
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        this.drawNavigationHrefTag(this.NEXT, this._params.getUrl() + n2, bl);
    }

    @Override
    protected void drawFirstButton() throws IOException {
        this.drawNavigationHrefTag(this.FIRST, this._params.getUrl() + 0, true);
    }

    public Filenames start(JCommunicator jCommunicator, HtmlParameter htmlParameter, String string) {
        this._commu = jCommunicator;
        this._params = htmlParameter;
        this._filename = string;
        return this.start();
    }

    @Override
    protected int exportPage(DSPage dSPage, int n) throws IOException, JRStopEngineException, OutOfSpaceException {
        this._pageNum = dSPage.getPageNum();
        super.exportPage(dSPage, n);
        return 0;
    }

    private void FIRST() {
        if (this.isRefresh) {
            return;
        }
        this.pageNumToPipeIndexMap.put(new Integer(this._pageNum), new int[]{this.fn.size(), this._drillDownPagesOfCurrentPage.size()});
    }

    @Override
    protected void drawPageNumber(int n, int n2) throws IOException {
        this.writeHtmlTag("<div class=\"pagenum\" style=\"position:absolute;top:0;width:" + n2 + "px;\"> ");
        this.writeHtmlTag("&nbsp;" + n);
        this.writeEndDiv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JRLog.indent("HTML PipeLine Exporter");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4400001, "Pipeline mode");
        }
        this.isPipeLineExport = true;
        this._params.setHasHyperlink(true);
        this._params.setHasPageNumber(true);
        this._params.setIsExportToMultiFiles(true);
        this._params.setEmbededCSS(true);
        try {
            if (this._params.isIncludeDrillDownFile()) {
                this._drillExporter = new HtmlDrillPageExporter(this._commu, this._params, this._filename);
                this._drillExporter._rstFileList = this._rstFileList;
                this._drillExporter._imgPool = this._imgPool;
                this._drillExporter.pageNumToPipeIndexMap = this.pageNumToPipeIndexMap;
            }
            this.init(false);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "htmlpipeLine JRInterruptedException", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(1)) {
                JRLog.error(1, 131087, (Throwable)exception);
            }
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].noteError(Thread.currentThread(), exception, 1, "");
                }
            }
            this.exit();
            return;
        }
        int n = 1;
        JRLog.indent("build html file.");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4400011);
        }
        try {
            TempFile tempFile = new TempFile(ReportEnv.getTemporaryPath(), this._exportFileNameHeader + "_htmlp");
            this.tempFile = tempFile.createTempFile();
            try {
                this.tempWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), this._commu.getEncoding()));
                int n2 = 0;
                for (Communicator this._commu : this._communicators) {
                    DSPage dSPage = this._commu.getPage(n);
                    while (dSPage != null) {
                        DSPage dSPage2 = this._commu.getPage(n + 1);
                        ExportUtil.checkStop(this._commu);
                        ++this._currentProcessPageCount;
                        if (dSPage2 == null || this.stop != 0) {
                            this.finish = true;
                        }
                        this.dirty = dSPage.beDirty();
                        if (this.dirty) {
                            this.refresh(n);
                        }
                        n2 = this.exportPage(dSPage, n2);
                        this.fn.add(this.writeHtmlFile(true, this._currentProcessPageCount, n2));
                        this.exportDrillPages();
                        this._drillDownPagesOfCurrentPage.clear();
                        this.dirty = false;
                        if (this.stop != 0) break;
                        if (this.finish && this._commu.getPhysicalTotalPageNum() == dSPage.getPageNum()) {
                            this._lastPgIndexInFn = ((int[])this.pageNumToPipeIndexMap.get(new Integer(dSPage.getPageNum())))[0];
                            this.fn.setLastPage(this._lastPgIndexInFn);
                            if (JRLog.isTrace(4)) {
                                JRLog.trace(4, 4400104, new Object[]{new Integer(this._lastPgIndexInFn), this.fn.getFilename(this._lastPgIndexInFn)});
                            }
                        }
                        ++n;
                        dSPage = dSPage2;
                    }
                    for (int i = 0; i < this.fn.size(); ++i) {
                        if (!JRLog.isTrace(4)) continue;
                        JRLog.trace(4, 4400105, new Object[]{new Integer(i), this.fn.getFilename(i)});
                    }
                    this.refreshAll();
                }
            }
            finally {
                this.tempWriter.close();
            }
            this.checkResultFileList();
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "htmlpipeLine JRInterruptedException", (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (JRStopEngineException jRStopEngineException) {
            try {
                this.tempWriter.close();
            }
            catch (IOException iOException) {
                JRLog.error(2, "pipe line tempWriter", (Throwable)iOException);
            }
            this.tempFile.delete();
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2400002, (Throwable)exception);
            }
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].noteError(Thread.currentThread(), exception, 1, "");
                }
            }
        }
        finally {
            this.tempFile.delete();
            this.exit();
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4400012);
        }
        JRLog.deIndent("build html file.");
        if (JRLog.isTrace(4)) {
            JRLog.indent("Result info:");
            JRLog.trace(4, 4400003, new Integer(this._rstFileList.size()));
            JRLog.trace(4, 4400002, this._rstFileList);
            JRLog.deIndent("Result info:");
            JRLog.trace(4, 4400004);
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4400004);
        }
        JRLog.deIndent("HTML PipeLine Exporter");
    }

    public void refreshAll() {
        Iterator iterator = this.refreshPages.iterator();
        if (this.refreshPages.size() > 0) {
            this.isRefresh = true;
        }
        while (iterator.hasNext()) {
            block9: {
                int n;
                int n2 = (Integer)iterator.next();
                this.fn.update(n2);
                try {
                    DSPage dSPage = this._commu.getPage(n2);
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, 4400106, new Integer(n2));
                    }
                    this._currentProcessPageCount = n2;
                    n = this.exportPage(dSPage, 0);
                    this._drillDownPagesOfCurrentPage.clear();
                    this.writeHtmlFile(true, this._currentProcessPageCount, n);
                }
                catch (JRInterruptedException jRInterruptedException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, "htmlpipeLine JRInterruptedException", (Throwable)jRInterruptedException);
                    }
                    throw jRInterruptedException;
                }
                catch (Exception exception) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2400002, (Throwable)exception);
                    }
                    if (this.listeners == null) break block9;
                    for (n = 0; n < this.listeners.length; ++n) {
                        this.listeners[n].noteError(Thread.currentThread(), exception, 1, "");
                    }
                }
            }
            this.fn.refresh();
        }
        this.isRefresh = false;
        this.refreshPages.clear();
    }

    @Override
    public void stop(int n) {
        this.stop = n;
    }

    @Override
    public synchronized void refresh(int n) {
        if (n <= this._currentProcessPageCount) {
            this.refreshPages.add(new Integer(n));
        }
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5400501, new Integer(n));
        }
    }

    public void exit() {
        this.fn.finish(2);
        if (this.stop == 1) {
            for (int i = 0; i < this.SEDU.size(); ++i) {
                ((ExportFinishListener)this.SEDU.elementAt(i)).stopReport();
            }
        } else {
            for (int i = 0; i < this.SEDU.size(); ++i) {
                ((ExportFinishListener)this.SEDU.elementAt(i)).exit();
            }
            this.SEDU.removeAllElements();
        }
    }

    public void addListener(ExportFinishListener exportFinishListener) {
        if (!this.SEDU.contains(exportFinishListener)) {
            this.SEDU.addElement(exportFinishListener);
        }
    }

    public void removeListener(ExportFinishListener exportFinishListener) {
        if (this.SEDU.contains(exportFinishListener)) {
            this.SEDU.removeElement(exportFinishListener);
        }
    }

    @Override
    public void fault(Throwable throwable) {
        this.stop = 2;
        if (this.fn != null) {
            this.fn.fault(throwable);
        }
    }

    public void setOlap(boolean bl) {
        this.olap = bl;
    }

    public boolean isOlap() {
        return this.olap;
    }

    @Override
    protected BufferedOutputStream getOutputStream(String string) throws IOException {
        if (!this.isRefresh) {
            this._rstFileList.add(string);
        }
        return new BufferedOutputStream(new FileOutputStream(string));
    }
}

