/*
 * Decompiled with CFR 0.152.
 */
package jet.export.html;

import com.jinfonet.util.JRLog;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import jet.JRStopEngineException;
import jet.JResource;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.html.HtmlConstant;
import jet.export.html.HtmlPlsParameter;
import jet.export.html.HtmlUtil;
import jet.export.util.ExpLineStyle;
import jet.export.util.ExpRect;

public class HtmlPlsExporter
extends AbstractExporter {
    private HtmlPlsParameter NavigatorBarHeight = new HtmlPlsParameter();
    private Hashtable SEDU;
    private String append;
    private Hashtable booleanValue = new Hashtable();
    private static boolean borderStyle;
    private static boolean checkFilePathExist;
    private static String close;
    private OutputStream containsKey;
    private int deIndent = 0;
    private int drawFirstButton = 0;
    private int drawLastButton = HtmlConstant.NavigatorBarHeight;
    private int drawNavigationHrefTag = 0;
    private StringBuffer drawNavigatorButton;
    private String drawNextButton = JResource.getMessage("HTML_FIRST");
    private String drawPageNavigator = JResource.getMessage("HTML_PREV");
    private String drawPageNumber = JResource.getMessage("HTML_NEXT");
    private String drawPriorButton = JResource.getMessage("HTML_LAST");
    private String equals = JResource.getMessage("HTML_SKIP");
    private String equalsIgnoreCase = JResource.getMessage("HTML_PAGENUMBERMSG");
    private static String error;
    private static String exists;
    private static String exportPage;
    private static String flush;
    private Hashtable get = new Hashtable();
    private String getBgColor = ".tmp";
    private int getBorderStyle = 0;
    private byte[] getBottomBorder;
    private byte[] getBytes;
    private byte[] getColor;
    private byte[] getColorString;
    private byte[] getHeight;
    private byte[] getHtmlBgColorTags;
    private byte[] getHtmlFileNameHeader;
    private byte[] getLeftBorder;
    private byte[] getLineStyle;
    private byte[] getLineStyleCSS;
    private byte[] getLineWidth;
    private String getMessage;
    public String resultfilename = null;
    private String getPageNumberMessage;
    RandomAccessFile raFile = null;
    private String getParent;
    protected ExportAuxInfo auxinfo;

    public HtmlPlsExporter(String string, Hashtable hashtable, Hashtable hashtable2, HtmlPlsParameter htmlPlsParameter, Hashtable hashtable3) throws ExpException, UnsupportedEncodingException {
        JRLog.indent("HtmlPlsExporter:");
        this.checkFilePathExist(string);
        File file = new File(string);
        this.append = file.getParent();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 0x432434, this.append);
        }
        this.getPageNumberMessage = HtmlUtil.getHtmlFileNameHeader(file);
        this.SEDU = hashtable;
        this.booleanValue = hashtable2;
        this.NavigatorBarHeight = htmlPlsParameter;
        this.get = hashtable3;
        this.getBorderStyle = ((Long)this.get.get("total")).intValue();
        this.append();
        this.getMessage = (String)this.SEDU.get("UrlPrefix");
    }

    @Override
    protected void checkFilePathExist(String string) throws ExpException {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists() || !file2.isDirectory()) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 4406004, file2.getPath());
            }
            throw new ExpException(406003);
        }
    }

    private Object NavigatorBarHeight(int n, Hashtable hashtable) {
        int n2 = 0;
        for (n2 = n; n2 >= 0; --n2) {
            if (!hashtable.containsKey(new Integer(n2))) continue;
            return new Integer(n2);
        }
        return new Integer(n2);
    }

    private Rectangle SEDU(int n) {
        Object object = this.NavigatorBarHeight(n, this.booleanValue);
        return (Rectangle)this.booleanValue.get(object);
    }

    private void append() throws UnsupportedEncodingException {
        close = this.SEDU.get("encoding") != null ? (String)this.SEDU.get("encoding") : "UTF-8";
        borderStyle = new Boolean(this.SEDU.get("isMultifile").toString()) != false;
        checkFilePathExist = new Boolean(this.SEDU.get("isSection508").toString()) != false;
        this.drawNavigatorButton = HtmlPlsExporter.auxinfo();
        this.drawNavigationHrefTag = this.NavigatorBarHeight.getplsViewPageList().length;
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 4400181, new Integer(this.getBorderStyle));
            JRLog.trace(6, 4400182, new Integer(this.drawNavigationHrefTag));
            JRLog.trace(6, 4400183, close);
            JRLog.trace(6, 4400184, new Boolean(borderStyle));
            JRLog.trace(6, 4400185, new Boolean(checkFilePathExist));
        }
        this.getBottomBorder = (byte[])this.SEDU.get("headerbytes");
        this.getBytes = (byte[])this.SEDU.get("divbytes");
        this.getColor = (byte[])this.SEDU.get("htmltagbytes");
        this.getHeight = (byte[])this.SEDU.get("styletagbyts");
        this.getColorString = (byte[])this.SEDU.get("divideBlankbyts");
        this.getHtmlBgColorTags = (byte[])this.SEDU.get("ntagbyts");
        this.getHtmlFileNameHeader = (byte[])this.SEDU.get("ttagbyts");
        this.getLineWidth = (byte[])this.SEDU.get("brtyts");
        this.getLineStyleCSS = (byte[])this.SEDU.get("accbyts");
        this.getLeftBorder = (byte[])this.SEDU.get("style2tagbyts");
        this.getLineStyle = (byte[])this.SEDU.get("style3tagbyts");
    }

    public void exportToPlsHtml(OutputStream outputStream, int n) throws JRStopEngineException, IOException {
        JRLog.indent("begin export to pls html page : ");
        int n2 = n;
        int n3 = 0;
        int[] nArray = this.NavigatorBarHeight.getplsViewPageList();
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 4400188, new Integer(nArray.length));
        }
        if (n <= this.drawNavigationHrefTag && n - 1 <= nArray.length) {
            n3 = nArray[n - 1];
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 131091, "page :" + n + ";viewTotalPage: " + this.drawNavigationHrefTag);
        }
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 4400186, new Integer(n));
            JRLog.trace(6, 4400187, new Integer(n3));
        }
        this.containsKey = outputStream;
        int n4 = 0;
        if (borderStyle) {
            this.drawFirstButton = n2;
            Rectangle rectangle = this.SEDU(n3);
            this.writeHtmlFileHeader(outputStream);
            n4 = this.exportPage(n4, n2, rectangle);
            this.writeHtmlFileFooter(outputStream);
        } else {
            this.writeHtmlFileHeader(outputStream);
            for (int i = 0; i < nArray.length; ++i) {
                ++this.drawFirstButton;
                Rectangle rectangle = this.SEDU(nArray[i]);
                n4 = this.exportPage(n4, i + 1, rectangle);
            }
            this.containsKey.flush();
            this.writeHtmlFileFooter(outputStream);
        }
        this.containsKey.close();
        JRLog.indent("end export to pls html page ");
    }

    private static StringBuffer auxinfo() {
        StringBuffer stringBuffer = new StringBuffer(5120);
        stringBuffer.append("\t .pagenum{text-align:right;border-top:1px solid black;border-bottom:1px solid black;width:100%;}\n");
        stringBuffer.append("\t ." + HtmlConstant.hyperlinkID + "{text-align:center;border-top:1px solid black;border-bottom:1px solid black;width:100%;}\n");
        if (checkFilePathExist) {
            stringBuffer.append("\t a:hover{background:highlight;color:highlighttext;}\n");
            stringBuffer.append("\t H1,H2,H3,H4,H5,H6,TH{font-size:1em;font-weight:normal;}\n");
        }
        return stringBuffer;
    }

    protected void writeHtmlFileHeader(OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        outputStream.write(this.getBottomBorder);
        outputStream.flush();
    }

    protected void writeHtmlFileFooter(OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        outputStream.write(this.getBytes);
        outputStream.write(this.getColor);
    }

    private void booleanValue(OutputStream outputStream, int n) throws IOException {
        if (n > this.getBorderStyle) {
            return;
        }
        long l = (Long)this.get.get("pg_" + n);
        long l2 = (Long)this.get.get("pg_" + (n + 1));
        String string = this.borderStyle(n);
        if (this.raFile == null || !string.equalsIgnoreCase(this.getParent)) {
            this.raFile = new RandomAccessFile(this.append + File.separator + string + this.getBgColor, "rw");
            this.getParent = string;
        }
        if (l2 == 0L) {
            l2 = this.raFile.length();
        }
        byte[] byArray = new byte[(int)(l2 - l + 1L)];
        this.raFile.seek(l);
        this.raFile.read(byArray);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, 4400189, new Long(n));
            JRLog.trace(6, 4400190, new Long(l));
            JRLog.trace(6, 4400191, new Long(l2));
            JRLog.trace(6, 4400192, new Long(byArray.length));
        }
        outputStream.write(byArray);
    }

    private String borderStyle(int n) {
        int n2 = new Long(this.get.get("idx_0").toString()).intValue();
        if ((Integer)this.get.get("idx_0") == 1) {
            return "interimResult_1";
        }
        for (int i = 1; i <= n2; ++i) {
            if (n > (Integer)this.get.get("idx_" + i)) continue;
            return "interimResult_" + i;
        }
        return "interimResult_1";
    }

    protected int exportPage(int n, int n2, Rectangle rectangle) throws IOException, JRStopEngineException {
        int n3 = n2;
        int n4 = this.NavigatorBarHeight.getplsViewPageList()[n2 - 1];
        int n5 = (int)rectangle.getWidth();
        int n6 = (int)rectangle.getHeight();
        this.deIndent = 0;
        this.checkFilePathExist(n, n5, n6);
        this.booleanValue(this.containsKey, n4);
        n += this.drawLastButton;
        if (borderStyle) {
            this.drawNavigationHrefTag((int)rectangle.getX(), n3, (int)rectangle.getX(), (int)((double)n5 + rectangle.getX()), n6 + n);
        } else {
            this.drawNavigationHrefTag((int)rectangle.getX(), n3, (int)rectangle.getX(), n5, n6);
        }
        int n7 = n6 + this.drawLastButton;
        return n += n7;
    }

    private void checkFilePathExist(int n, int n2, int n3) throws IOException {
        this.indent();
        this.writeHtmlTag(this.getLineStyle);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append("px; left:0px;\">");
        this.writeHtmlTag(stringBuffer.toString());
        this.drawPageNavigator(n2, this.drawFirstButton, 0);
    }

    private String close(int n) {
        return "page_" + n;
    }

    protected void drawPageNavigator(int n, int n2, int n3) throws IOException {
        int n4 = n;
        int n5 = this.drawLastButton;
        this.indent();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<div style=\"position:absolute;width:").append(n4).append("px;top:").append(n3).append("px;height:").append(n5).append("px;\">");
        stringBuffer.append("<a name=\"").append(this.close(n2)).append("\"/>");
        stringBuffer.append("<div class=\"").append(HtmlConstant.hyperlinkID).append(" \" style=\"z-index:1;text-align:center;position:absolute;top:0;width:").append(n4).append("px;\"> ");
        if (checkFilePathExist) {
            stringBuffer.append("<a href=\"#").append("mainContent").append(n2).append("\" accesskey=\"s\" title=\"").append(this.equals).append("\">").append(this.equals).append("</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeHtmlTag(stringBuffer.toString());
        this.drawNavigatorButton(n2);
        this.deIndent();
        this.writeIndent();
        this.writeHtmlTag(this.getBytes);
        this.writeIndent();
        this.drawPageNumber(n2, n4);
        this.deIndent();
        this.writeIndent();
        this.writeHtmlTag(this.getBytes);
    }

    protected void drawPageNumber(int n, int n2) throws IOException {
        this.writeHtmlTag("<div class=\"pagenum");
        this.writeHtmlTag(this.getLeftBorder);
        this.writeHtmlTag(n2 + "px;\"> ");
        this.writeHtmlTag(this.getPageNumberMessage(n, this.drawNavigationHrefTag));
        this.writeHtmlTag(this.getBytes);
    }

    public String getPageNumberMessage(int n, int n2) {
        String string = this.equalsIgnoreCase;
        String string2 = "@CurrentPageNumber;";
        String string3 = "@TotalPageNumber;";
        if (string != null && !string.equals("")) {
            int n3;
            int n4 = string.indexOf(string2);
            if (n4 != -1) {
                string = string.substring(0, n4) + n + string.substring(n4 + string2.length());
            }
            if ((n3 = string.indexOf(string3)) != -1) {
                string = string.substring(0, n3) + n2 + string.substring(n3 + string3.length());
            }
        } else {
            string = "&nbsp;" + n + "&nbsp;of&nbsp;" + n2;
        }
        return string;
    }

    protected void drawNavigatorButton(int n) throws IOException {
        if (this.drawNavigationHrefTag != 1) {
            if (n == 1) {
                this.drawNextButton(n);
                this.writeHtmlTag(this.getColorString);
                this.drawLastButton();
            } else if (n == this.drawNavigationHrefTag) {
                this.drawFirstButton();
                this.writeHtmlTag(this.getColorString);
                this.drawPriorButton(n);
            } else {
                this.drawFirstButton();
                this.writeHtmlTag(this.getColorString);
                this.drawPriorButton(n);
                this.writeHtmlTag(this.getColorString);
                this.drawNextButton(n);
                this.writeHtmlTag(this.getColorString);
                this.drawLastButton();
            }
        }
    }

    protected void drawPriorButton(int n) throws IOException {
        if (!borderStyle) {
            this.drawNavigationHrefTag(this.drawPageNavigator, this.containsKey(n - 1), false);
        } else {
            this.drawNavigationHrefTag(this.drawPageNavigator, this.getMessage + exportPage + (n - 1), false);
        }
    }

    protected void drawLastButton() throws IOException {
        if (!borderStyle) {
            this.drawNavigationHrefTag(this.drawPriorButton, this.containsKey(this.drawNavigationHrefTag), false);
        } else {
            this.drawNavigationHrefTag(this.drawPriorButton, this.getMessage + flush, false);
        }
    }

    protected void drawNextButton(int n) throws IOException {
        if (!borderStyle) {
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            this.drawNavigationHrefTag(this.drawPageNumber, this.containsKey(n + 1), bl);
        } else {
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            this.drawNavigationHrefTag(this.drawPageNumber, this.getMessage + exists + (n + 1), bl);
        }
    }

    protected void drawFirstButton() throws IOException {
        if (!borderStyle) {
            this.drawNavigationHrefTag(this.drawNextButton, this.containsKey(1), true);
        } else {
            this.drawNavigationHrefTag(this.drawNextButton, this.getMessage + error, true);
        }
    }

    private String containsKey(int n) {
        return "#" + this.close(n);
    }

    protected void drawNavigationHrefTag(String string, String string2, boolean bl) throws IOException {
        this.writeHtmlTag("<a href=\"" + string2 + "\" title=\"" + string + "\"");
        if (bl) {
            this.writeHtmlTag(this.getLineStyleCSS);
        }
        this.writeHtmlTag(">" + string + "</a>");
    }

    private void deIndent(ExpRect expRect) throws IOException {
        this.writeHtmlTag(" left:" + expRect.getX() + "px;top:" + expRect.getY() + "px;");
    }

    private String drawFirstButton(String string, ExpRect expRect, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(HtmlUtil.getHtmlBgColorTags(expRect.getBgColor()));
        stringBuffer.append(this.drawLastButton(expRect));
        if (stringBuffer.length() > 0) {
            this.writeCSS("\t." + string + "{" + stringBuffer.toString() + "}\n");
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    void writeCSS(String string) {
        this.drawNavigatorButton.append(string);
    }

    private StringBuffer drawLastButton(ExpRect expRect) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getBorderStyle("border-top", expRect.getTopBorder())).append(this.getBorderStyle("border-bottom", expRect.getBottomBorder())).append(this.getBorderStyle("border-left", expRect.getLeftBorder())).append(this.getBorderStyle("border-right", expRect.getRightBorder()));
        return stringBuffer;
    }

    StringBuffer getBorderStyle(String string, ExpLineStyle expLineStyle) {
        StringBuffer stringBuffer = new StringBuffer();
        if (expLineStyle != null && expLineStyle.getLineWidth() > 0 && expLineStyle.getColor() != null && !expLineStyle.getLineStyle().equals(ExpLineStyle.borderStyle[0])) {
            stringBuffer.append(string).append(":");
            stringBuffer.append(this.getLineStyleCSS(expLineStyle));
        }
        return stringBuffer;
    }

    StringBuffer getLineStyleCSS(ExpLineStyle expLineStyle) {
        StringBuffer stringBuffer = new StringBuffer();
        if (expLineStyle.getLineStyle().equalsIgnoreCase(ExpLineStyle.borderStyle[0])) {
            return null;
        }
        stringBuffer.append(expLineStyle.getLineWidth() + "px " + expLineStyle.getLineStyle());
        String string = HtmlUtil.getColorString(expLineStyle.getColor());
        if (string != null) {
            return stringBuffer.append(" #" + string + ";");
        }
        return stringBuffer.append(";");
    }

    private void drawNavigationHrefTag(int n, int n2, int n3, int n4, int n5) throws JRStopEngineException, IOException {
        this.writeIndent();
        this.deIndent();
        this.writeIndent();
        this.writeHtmlTag(this.getBytes);
        this.writeIndent();
        this.writeHtmlTag(this.getLineWidth);
        this.writeIndent();
        if (borderStyle) {
            this.writeIndent();
            this.drawPageNavigator(n4, n2, n5 + this.drawLastButton);
        }
        this.deIndent();
        this.writeIndent();
        this.writeHtmlTag(this.getBytes);
    }

    void indent() throws IOException {
        ++this.deIndent;
        this.writeIndent();
    }

    void deIndent() {
        --this.deIndent;
    }

    void writeIndent() throws IOException {
        this.writeHtmlTag(this.getHtmlBgColorTags);
        for (int i = 0; i < this.deIndent; ++i) {
            this.writeHtmlTag(this.getHtmlFileNameHeader);
        }
    }

    void writeHtmlTag(String string) throws IOException {
        this.containsKey.write(string.getBytes(close));
    }

    void writeHtmlTag(byte[] byArray) throws IOException {
        this.containsKey.write(byArray);
    }

    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        return null;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.auxinfo = exportAuxInfo;
    }

    static {
        error = "&op=1&pg=";
        exists = "&op=3&pg=";
        exportPage = "&op=3&pg=";
        flush = "&op=2&pg=";
    }
}

