/*
 * Decompiled with CFR 0.152.
 */
package jet.export.mail;

import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jet.export.mail.MailAuthenticator;
import jet.export.mail.MailException;
import jet.export.mail.MailFile;
import jet.export.mail.MailSend;

public final class Mailing
implements MailSend {
    private boolean BCC;
    private boolean CC = true;
    private static int SEDU = 5120;
    private String TO = "UTF-8";
    private String add = "";
    private String addBodyPart;
    private String addElement = "";
    private String addHeader;
    private String append;
    private String available = ".html";
    private String clear = ".htm";
    private String clearAllAddress;
    private String close = "";
    private String closeEntry;
    private String compressAttachFile;
    private long connect = -1L;
    private ArrayList currentTimeMillis;
    private Vector delete;
    private Vector elementAt;
    private Vector endsWith;
    private Vector error = new Vector();
    private Vector exists = new Vector();
    private Vector get = new Vector();
    private Properties getAllRecipients;
    private Authenticator getAttachFile;
    private Transport getBytes;
    private Session getComment;
    private boolean getCommentFile = false;
    private Vector getHtmlImageExp = new Vector();

    public Mailing(String string, int n, String string2, byte by) {
        this.getAllRecipients = new Properties();
        this.append = string;
        if (by == 1) {
            this.getCommentFile = true;
            this.getAllRecipients.put("mail.smtps.host", string);
            this.getAllRecipients.put("mail.smtps.port", String.valueOf(n));
            this.getAllRecipients.put("mail.transport.protocol", "smtps");
            String string3 = "javax.net.ssl.SSLSocketFactory";
            this.getAllRecipients.setProperty("mail.smtp.socketFactory.class", string3);
        } else {
            this.getAllRecipients.put("mail.smtp.host", string);
            this.getAllRecipients.put("mail.smtp.port", String.valueOf(n));
            this.getAllRecipients.put("mail.transport.protocol", "smtp");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "default";
        }
        this.addHeader = this.add(string2);
    }

    @Override
    public void setMailThreshold(long l) {
        if (l > 0L) {
            this.connect = l * 1024L;
        }
    }

    @Override
    public void setTOAddress(String string) {
        if (string != null && string.length() > 0) {
            this.get = this.BCC(string);
        } else {
            this.get.removeAllElements();
        }
    }

    @Override
    public void setCCAddress(String string) {
        if (string != null && string.length() > 0) {
            this.exists = this.BCC(string);
        } else {
            this.exists.removeAllElements();
        }
    }

    private Vector BCC(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    @Override
    public void setBCCAddress(String string) {
        if (string != null && string.length() > 0) {
            this.error = this.BCC(string);
        } else {
            this.error.removeAllElements();
        }
    }

    @Override
    public void setSubject(String string) {
        this.close = string == null ? "" : string;
    }

    @Override
    public void setZipFileName(String string) {
        this.compressAttachFile = string;
    }

    @Override
    public void setEncoding(String string) {
        this.addBodyPart = string;
    }

    public void clearAllAddress() {
        if (this.get != null) {
            this.get.clear();
        }
        if (this.exists != null) {
            this.exists.clear();
        }
        if (this.error != null) {
            this.error.clear();
        }
    }

    @Override
    public void setAuthenticatMessage(String string, String string2) {
        this.getAttachFile = new MailAuthenticator(string, string2);
        if (this.getCommentFile) {
            this.getAllRecipients.put("mail.smtps.auth", "true");
        } else {
            this.getAllRecipients.put("mail.smtp.auth", "true");
        }
        this.closeEntry = string;
        this.clearAllAddress = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MailFile mailFile) throws MessagingException, MailException {
        if (mailFile != null) {
            this.delete = mailFile.getAttachFile();
            this.elementAt = mailFile.getCommentFile();
            this.endsWith = mailFile.getHtmlImageExp();
            this.add = mailFile.getComment();
            this.BCC = mailFile.compressAttachFile();
        } else {
            this.delete = new Vector();
        }
        if (this.get != null && this.get.size() != 0 || this.exists != null && this.exists.size() != 0 || this.error != null && this.error.size() != 0) {
            try {
                this.SEDU();
            }
            finally {
                this.clear();
            }
        } else {
            throw new MailException(402405);
        }
    }

    @Override
    public void clear() {
        if (this.delete != null) {
            this.delete.clear();
            this.delete = null;
        }
        if (this.elementAt != null) {
            this.elementAt.clear();
            this.elementAt = null;
        }
        if (this.endsWith != null) {
            this.endsWith.clear();
            this.endsWith = null;
        }
        this.clearAllAddress();
        this.get = null;
        this.exists = null;
        this.error = null;
        this.getAllRecipients = null;
        if (this.currentTimeMillis != null) {
            this.currentTimeMillis.clear();
            this.currentTimeMillis = null;
        }
        this.getAttachFile = null;
        this.getBytes = null;
        this.getComment = null;
        if (this.getHtmlImageExp != null) {
            for (int i = 0; i < this.getHtmlImageExp.size(); ++i) {
                File file = (File)this.getHtmlImageExp.get(i);
                if (!file.exists()) continue;
                file.delete();
            }
            this.getHtmlImageExp = null;
        }
    }

    private MimeBodyPart CC(String string, boolean bl) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(string);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        string = this.closeEntry(string);
        byte[] byArray = new byte[512];
        try {
            byArray = this.addBodyPart != null && this.addBodyPart.length() > 0 ? string.getBytes(this.addBodyPart) : string.getBytes("UTF-8");
            string = new String(byArray, "ISO8859-1").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = string.getBytes("UTF-8");
                string = new String(byArray, "ISO8859-1").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                // empty catch block
            }
        }
        mimeBodyPart.setFileName(string);
        if (bl) {
            mimeBodyPart.addHeader("Content-ID", string + ".mail@jinfonet.com");
        }
        return mimeBodyPart;
    }

    private void SEDU() throws MessagingException, MailException {
        this.addHeader();
        try {
            String string = System.getProperty("line.separator");
            this.append();
            if (this.addElement != null && this.addElement.length() != 0) {
                if (this.CC) {
                    this.TO(string);
                } else {
                    this.getBytes.close();
                }
            } else {
                this.TO(string);
            }
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, exception);
            }
            this.addElement = this.addElement + exception.getMessage();
        }
        if (this.addElement.length() > 0) {
            throw new MailException(402404, this.addElement);
        }
        this.addElement = "";
    }

    private void TO(String string) throws MessagingException, IOException {
        String string2 = this.add;
        if (this.currentTimeMillis != null) {
            int n = this.currentTimeMillis.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    string2 = this.add + string + " Continue....... " + i;
                    this.elementAt = null;
                }
                this.delete = (Vector)this.currentTimeMillis.get(i);
                this.addBodyPart(string2);
                this.delay(50L);
            }
        }
        this.getBytes.close();
    }

    private String add(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n2 != -1) {
            if (n == -1) {
                n = n2;
            } else if (n > n2) {
                n = n2;
            }
        }
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private void addBodyPart(String string) throws MessagingException, IOException {
        int n;
        MimeMessage mimeMessage = new MimeMessage(this.getComment);
        InternetAddress internetAddress = null;
        try {
            internetAddress = new InternetAddress(this.addHeader);
        }
        catch (AddressException addressException) {
            try {
                internetAddress = new InternetAddress("", this.addHeader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    internetAddress = new InternetAddress("", this.addHeader, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
            }
        }
        mimeMessage.setFrom((Address)internetAddress);
        Date date = new Date();
        mimeMessage.setSentDate(date);
        InternetAddress[] internetAddressArray = new InternetAddress[this.get.size()];
        for (n = 0; n < internetAddressArray.length; ++n) {
            internetAddressArray[n] = new InternetAddress(this.add((String)this.get.elementAt(n)));
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
        if (this.exists != null && this.exists.size() != 0) {
            internetAddressArray = new InternetAddress[this.exists.size()];
            for (n = 0; n < internetAddressArray.length; ++n) {
                internetAddressArray[n] = new InternetAddress(this.add((String)this.exists.elementAt(n)));
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])internetAddressArray);
        }
        if (this.error != null && this.error.size() != 0) {
            internetAddressArray = new InternetAddress[this.error.size()];
            for (n = 0; n < internetAddressArray.length; ++n) {
                internetAddressArray[n] = new InternetAddress(this.add((String)this.error.elementAt(n)));
            }
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])internetAddressArray);
        }
        if (this.close != null) {
            String string2 = this.addBodyPart != null ? this.addBodyPart : this.TO;
            mimeMessage.setSubject(this.add(this.close), string2);
        }
        MimeMultipart mimeMultipart = new MimeMultipart("mixed");
        if (this.elementAt != null || this.delete.size() != 0) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            if (this.elementAt != null && this.elementAt.size() != 0) {
                int n2;
                String string3;
                if (((String)this.elementAt.get(0)).endsWith(".txt")) {
                    FileInputStream fileInputStream = null;
                    try {
                        File file = new File((String)this.elementAt.get(0));
                        fileInputStream = new FileInputStream(file);
                        int n3 = fileInputStream.available();
                        byte[] byArray = new byte[n3];
                        fileInputStream.read(byArray);
                        fileInputStream.close();
                        fileInputStream = null;
                        string3 = new String(byArray, "UTF-8");
                        if (string != null) {
                            StringBuffer stringBuffer = new StringBuffer(string);
                            stringBuffer.append(System.getProperty("line.separator"));
                            stringBuffer.append(string3);
                            string3 = stringBuffer.toString();
                        }
                        mimeBodyPart.setContent((Object)string3, "text/plain; charset=UTF-8");
                    }
                    catch (IOException iOException) {
                        throw new MessagingException("Produce IO exception when send the text file:" + iOException.getMessage());
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                int n4 = this.elementAt.size();
                if (n4 > 1) {
                    mimeMultipart = new MimeMultipart("related");
                }
                int n5 = 0;
                String string4 = null;
                for (n2 = 0; n2 < n4; ++n2) {
                    string4 = (String)this.elementAt.get(n2);
                    if (!string4.endsWith(this.available) && !string4.endsWith(this.clear)) continue;
                    n5 = n2;
                    break;
                }
                this.addElement(mimeBodyPart, (String)this.elementAt.get(n5));
                if (n4 > 1) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        if (n2 == n5) continue;
                        string3 = (String)this.elementAt.get(n2);
                        mimeMultipart.addBodyPart((BodyPart)this.CC(string3, true));
                    }
                }
            } else if (this.addBodyPart != null && this.addBodyPart.length() > 0) {
                mimeBodyPart.setContent((Object)string, "text/plain; charset=" + this.addBodyPart);
            } else {
                mimeBodyPart.setContent((Object)string, "text/plain; charset=" + this.TO);
            }
            this.elementAt = null;
            if (this.delete.size() != 0) {
                for (int i = 0; i < this.delete.size(); ++i) {
                    String string5 = (String)this.delete.elementAt(i);
                    mimeMultipart.addBodyPart((BodyPart)this.CC(string5, false));
                }
            }
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart, 0);
            mimeMessage.setContent((Multipart)mimeMultipart);
        } else if (this.addBodyPart != null && this.addBodyPart.length() > 0) {
            mimeMessage.setContent((Object)string, "text/plain; charset=" + this.addBodyPart);
        } else {
            mimeMessage.setContent((Object)string, "text/plain; charset=" + this.TO);
        }
        this.getBytes.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement(MimeBodyPart mimeBodyPart, String string) throws IOException, MessagingException {
        int n;
        File file = new File(string);
        long l = file.length();
        if (l < (long)(n = 2048)) {
            n = (int)file.length();
        }
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2;
            fileInputStream.read(byArray);
            String string2 = new String(byArray, "UTF-8");
            int n3 = string2.indexOf("charset=");
            fileInputStream.close();
            fileInputStream = null;
            int n4 = 2;
            String string3 = "UTF-8";
            boolean bl = false;
            while (n3 < 0) {
                if ((long)(n = 2048 * n4++) > l) {
                    n = (int)l;
                    bl = true;
                }
                byArray = new byte[n];
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                fileInputStream = null;
                string2 = new String(byArray, "UTF-8");
                n3 = string2.indexOf("charset=");
                if (!bl) continue;
            }
            if (n3 > 0 && (n2 = string2.indexOf("\"", n3 += 8)) > 0) {
                string3 = string2.substring(n3, n2);
            }
            n = (int)file.length();
            byArray = new byte[n];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
            fileInputStream = null;
            string2 = new String(byArray, string3);
            mimeBodyPart.setContent((Object)string2, "text/html; charset=" + this.add(string3));
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void addHeader() throws MessagingException {
        this.getComment = Session.getInstance((Properties)this.getAllRecipients, (Authenticator)this.getAttachFile);
        if (this.getCommentFile) {
            this.getComment.setProtocolForAddress("rfc822", "smtps");
            this.getBytes = this.getComment.getTransport("smtps");
        } else {
            this.getBytes = this.getComment.getTransport("smtp");
        }
        boolean bl = true;
        MessagingException messagingException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.getBytes.connect(this.append, this.closeEntry, this.clearAllAddress);
                bl = false;
                break;
            }
            catch (MessagingException messagingException2) {
                messagingException = messagingException2;
                try {
                    Thread.sleep(800L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (bl) {
            throw messagingException;
        }
    }

    private void delay(long l) {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        while (l3 - l2 < l) {
            l3 = System.currentTimeMillis();
        }
    }

    private void append() {
        File file;
        Object object;
        this.currentTimeMillis = new ArrayList();
        long l = this.close();
        boolean bl = false;
        if (this.delete == null || this.delete.size() == 0) {
            this.currentTimeMillis.add(new Vector());
            return;
        }
        int n = this.delete.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        long l2 = 0L;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        String string = this.compressAttachFile != null && this.compressAttachFile.length() != 0 ? this.compressAttachFile + ".zip" : "attachFile.zip";
        String string2 = this.compressAttachFile((String)this.delete.get(0));
        File file2 = new File(string2, string);
        if (this.BCC) {
            if (file2.exists()) {
                file2.delete();
            }
            try {
                this.delete(this.delete, file2);
                l2 = file2.length();
                this.getHtmlImageExp.add(file2);
            }
            catch (Exception exception) {
                File file3;
                if (file2.exists()) {
                    file2.delete();
                }
                for (int i = 0; i < n; ++i) {
                    object = (String)this.delete.get(i);
                    file3 = new File((String)object);
                    stringArray2[i] = object;
                    lArray2[i] = file3.length();
                    l2 += file3.length();
                    if (bl || !((String)object).endsWith(this.available) && !((String)object).endsWith(this.clear)) continue;
                    bl = true;
                }
                file3 = null;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                String string3 = (String)this.delete.get(i);
                file = new File(string3);
                stringArray2[i] = string3;
                lArray2[i] = file.length();
                l2 += file.length();
                if (bl || !string3.endsWith(this.available) && !string3.endsWith(this.clear)) continue;
                bl = true;
            }
            file = null;
        }
        if (this.connect > 0L && l2 + l > this.connect) {
            if (this.BCC && file2.exists()) {
                file2.delete();
                for (int i = 0; i < n; ++i) {
                    String string4 = (String)this.delete.get(i);
                    file = new File(string4);
                    stringArray2[i] = string4;
                    lArray2[i] = file.length();
                    if (bl || !string4.endsWith(this.available) && !string4.endsWith(this.clear)) continue;
                    bl = true;
                }
                file = null;
            }
            int n2 = 0;
            long l3 = 0L;
            object = null;
            String[] stringArray3 = null;
            if (bl) {
                int n3;
                long l4 = 0L;
                stringArray3 = new String[n];
                object = new long[n];
                int n4 = 0;
                String[] stringArray4 = new String[n];
                long[] lArray3 = new long[n];
                for (n3 = 0; n3 < n; ++n3) {
                    int n5;
                    String string5 = stringArray2[n3];
                    if (string5.endsWith(this.available) || string5.endsWith(this.clear)) {
                        stringArray3[n2] = string5;
                        l4 = lArray2[n3];
                        object[n2] = l4;
                        l3 += l4;
                        ++n2;
                        continue;
                    }
                    int n6 = 0;
                    if (this.endsWith != null) {
                        n6 = this.endsWith.size();
                    }
                    for (n5 = 0; n5 < n6; ++n5) {
                        if (!string5.endsWith((String)this.endsWith.get(n5))) continue;
                        stringArray3[n2] = string5;
                        l4 = lArray2[n3];
                        object[n2] = l4;
                        l3 += l4;
                        ++n2;
                        break;
                    }
                    if (n5 != n6) continue;
                    stringArray4[n4] = string5;
                    lArray3[n4] = lArray2[n3];
                    ++n4;
                }
                stringArray2 = new String[n4];
                lArray2 = new long[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    stringArray2[n3] = stringArray4[n3];
                    lArray2[n3] = lArray3[n3];
                }
                stringArray4 = null;
                lArray3 = null;
            }
            this.sort(stringArray2, lArray2);
            stringArray = stringArray2;
            lArray = lArray2;
            lArray2 = null;
            stringArray2 = null;
            if (l3 > this.connect) {
                stringArray2 = new String[n2];
                lArray2 = new long[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray2[i] = stringArray3[i];
                    lArray2[i] = (long)object[i];
                }
                this.sort(stringArray2, lArray2);
                stringArray3 = stringArray2;
                object = lArray2;
                lArray2 = null;
                stringArray2 = null;
                try {
                    this.available(stringArray3, (long[])object, l, string2);
                }
                catch (MailException mailException) {
                    this.addElement = this.addElement + mailException.getMessage();
                }
                l = 0L;
            } else if (n2 > 0) {
                int n7;
                lArray2 = new long[n];
                stringArray2 = new String[n];
                int n8 = stringArray.length;
                for (n7 = 0; n7 < n8; ++n7) {
                    stringArray2[n7] = stringArray[n7];
                    lArray2[n7] = lArray[n7];
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    stringArray2[n7 + n8] = stringArray3[n7];
                    lArray2[n7 + n8] = (long)object[n7];
                }
                stringArray = stringArray2;
                lArray = lArray2;
                stringArray2 = null;
                lArray2 = null;
                stringArray3 = null;
                object = null;
                string = null;
            }
            try {
                this.sort(stringArray, lArray);
                this.available(stringArray, lArray, l, string2);
            }
            catch (MailException mailException) {
                this.addElement = this.addElement + mailException.getMessage();
            }
        } else {
            if (this.BCC && file2.exists()) {
                this.delete.removeAllElements();
                this.delete.addElement(file2.getPath());
            }
            this.currentTimeMillis.add(this.delete);
            lArray2 = null;
            stringArray2 = null;
            lArray = null;
            stringArray = null;
        }
    }

    private void available(String[] stringArray, long[] lArray, long l, String string) throws MailException {
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = stringArray.length;
        boolean bl = false;
        if (l <= 0L) {
            l = SEDU;
        }
        if (this.BCC) {
            int n4 = 2048;
            for (int i = 0; i < n3; ++i) {
                int n5;
                Vector<String> vector;
                String string2 = this.currentTimeMillis() + ".zip";
                File file = new File(string, string2);
                while (file.exists()) {
                    string2 = this.currentTimeMillis();
                    file = new File(string, string2);
                }
                this.connect(stringArray[i], file);
                l3 = file.length();
                if (l3 > this.connect - l - (long)n4) {
                    file.delete();
                    vector = null;
                    for (n5 = 0; n5 < n2; ++n5) {
                        if (vector == null) {
                            vector = new Vector<String>();
                        }
                        vector.add(stringArray[n5]);
                    }
                    if (vector != null) {
                        File file2 = new File(string, "attachedFile" + n2 + ".zip");
                        this.delete(vector, file2);
                        vector.clear();
                        vector.add(file2.getPath());
                        this.currentTimeMillis.add(vector);
                    }
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2402402, stringArray[i] + " Compress size is : " + l3);
                    }
                    throw new MailException(402402, new Object[]{stringArray[i], l3}, null);
                }
                file.delete();
                n2 = i;
                if ((l2 += l3) <= this.connect - l - (long)n4) continue;
                vector = new Vector();
                for (n5 = n; n5 < n2; ++n5) {
                    vector.add(stringArray[n5]);
                }
                file = new File(string, "html" + n2 + ".zip");
                this.delete(vector, file);
                vector.clear();
                vector.add(file.getPath());
                this.currentTimeMillis.add(vector);
                n = n2;
                l2 = l3;
                l = SEDU;
            }
            Vector<String> vector = null;
            for (int i = 0; i < n2; ++i) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.add(stringArray[i]);
            }
            if (vector != null) {
                File file = new File(string, "attachedFile" + n2 + ".zip");
                this.delete(vector, file);
                vector.clear();
                vector.add(file.getPath());
                this.currentTimeMillis.add(vector);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                Object object;
                l3 = lArray[i];
                if (l3 > this.connect - 256L) {
                    object = stringArray[i];
                    if (bl) {
                        Vector<String> vector = new Vector<String>(1);
                        String string3 = this.currentTimeMillis() + ".zip";
                        File file = new File(string, string3);
                        while (file.exists()) {
                            string3 = this.currentTimeMillis();
                            file = new File(string, string3);
                        }
                        this.connect((String)object, file);
                        if (file.length() > this.connect - l) {
                            file.delete();
                            Vector<String> vector2 = null;
                            for (int j = n; j <= n2; ++j) {
                                if (vector2 == null) {
                                    vector2 = new Vector<String>();
                                }
                                vector2.add(stringArray[j]);
                            }
                            if (vector2 != null) {
                                this.currentTimeMillis.add(vector2);
                            }
                            if (JRLog.isError(2)) {
                                JRLog.error(2, 2402403, object);
                            }
                            throw new MailException(402403, (String)object);
                        }
                        if (file.exists()) {
                            vector.add(file.getPath());
                        }
                        this.currentTimeMillis.add(vector);
                        l = SEDU;
                        continue;
                    }
                    JRLog.error(2, 2402403, object);
                    throw new MailException(402403, (String)object);
                }
                n2 = i;
                if ((l2 += l3) <= this.connect - l) continue;
                object = new Vector();
                for (int j = n; j < n2; ++j) {
                    ((Vector)object).add(stringArray[j]);
                }
                this.currentTimeMillis.add(object);
                n = n2;
                l2 = l3;
                l = SEDU;
            }
            Vector<String> vector = null;
            for (int i = n; i <= n2; ++i) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.add(stringArray[i]);
            }
            if (vector != null) {
                this.currentTimeMillis.add(vector);
            }
        }
    }

    private void sort(String[] stringArray, long[] lArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            long l = lArray[i];
            for (int j = i + 1; j < n; ++j) {
                if (l <= lArray[j]) continue;
                long l2 = lArray[j];
                String string2 = stringArray[j];
                lArray[j] = l;
                stringArray[j] = string;
                lArray[i] = l2;
                stringArray[i] = string2;
                l = l2;
                string = string2;
            }
        }
    }

    private long close() {
        long l = 0L;
        if (this.elementAt != null) {
            int n = this.elementAt.size();
            File file = null;
            for (int i = 0; i < n; ++i) {
                file = new File((String)this.elementAt.get(i));
                l += file.length();
            }
        }
        return l;
    }

    private String closeEntry(String string) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string);
        string2 = file.getName();
        return string2;
    }

    private String compressAttachFile(String string) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string);
        string2 = file.getParent() + File.separator;
        return string2;
    }

    private void connect(String string, File file) throws MailException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            File file2 = new File(string);
            ZipEntry zipEntry = new ZipEntry(file2.getName());
            long l = file2.length();
            zipEntry.setSize(l);
            zipEntry.setComment(file2.getName());
            zipOutputStream.putNextEntry(zipEntry);
            if (l > 0x100000L) {
                l = 0x100000L;
            }
            byte[] byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            l = fileInputStream.read(byArray);
            while (l > 0L) {
                zipOutputStream.write(byArray, 0, (int)l);
                l = fileInputStream.read(byArray);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
            fileInputStream = null;
            zipOutputStream.close();
            zipOutputStream = null;
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            throw new MailException(402401, (Throwable)iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String currentTimeMillis() {
        return String.valueOf((int)Math.round(1.0E8 * new SecureRandom().nextDouble()));
    }

    private void delete(Vector vector, File file) throws MailException {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                File file2 = new File(string);
                ZipEntry zipEntry = new ZipEntry(file2.getName());
                long l = file2.length();
                zipEntry.setSize(l);
                zipEntry.setComment(file2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                if (l > 0x100000L) {
                    l = 0x100000L;
                }
                byte[] byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file2);
                l = fileInputStream.read(byArray);
                while (l > 0L) {
                    zipOutputStream.write(byArray, 0, (int)l);
                    l = fileInputStream.read(byArray);
                }
                zipOutputStream.closeEntry();
                fileInputStream.close();
                fileInputStream = null;
                if (!JRLog.isTrace(5)) continue;
                JRLog.trace(5, 5402412, file2.getName() + " length:" + l);
            }
            zipOutputStream.close();
            zipOutputStream = null;
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            throw new MailException(402401, (Throwable)iOException);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

