/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import java.awt.Color;
import jet.export.pdf.Box;
import jet.export.pdf.ExportLineStyle;
import jet.export.util.BorderProperties;
import jet.export.util.FillPatternProperties;

class ExportRectangle {
    Box location;
    private Box BORDERJOINT_MITER = null;
    ExportLineStyle leftBorderStyle = null;
    ExportLineStyle rightBorderStyle = null;
    ExportLineStyle topBorderStyle = null;
    ExportLineStyle bottomBorderStyle = null;
    Color background;
    boolean drawHShadow = false;
    boolean drawVShadow = false;
    boolean indentHShadow = false;
    boolean indentVShadow = false;
    Color shadowColor;
    int shadowWidth;
    FillPatternProperties fillProp = null;
    int borderJoint = BorderProperties.BORDERJOINT_MITER;
    float roundJointRadius = 0.0f;

    ExportRectangle(ExportRectangle exportRectangle) {
        this.location = exportRectangle.location;
        this.leftBorderStyle = exportRectangle.leftBorderStyle;
        this.rightBorderStyle = exportRectangle.rightBorderStyle;
        this.topBorderStyle = exportRectangle.topBorderStyle;
        this.bottomBorderStyle = exportRectangle.bottomBorderStyle;
        this.background = exportRectangle.background;
        this.drawHShadow = exportRectangle.drawHShadow;
        this.drawVShadow = exportRectangle.drawVShadow;
        this.indentHShadow = exportRectangle.indentHShadow;
        this.indentVShadow = exportRectangle.indentVShadow;
        this.shadowColor = exportRectangle.shadowColor;
        this.shadowWidth = exportRectangle.shadowWidth;
        this.fillProp = exportRectangle.fillProp;
        this.borderJoint = exportRectangle.borderJoint;
        this.roundJointRadius = exportRectangle.roundJointRadius;
    }

    ExportRectangle(Box box, Color color) {
        this.location = box;
        this.background = color;
    }

    public void setExpRectLine(ExportLineStyle exportLineStyle) {
        this.topBorderStyle = this.bottomBorderStyle = exportLineStyle;
        this.rightBorderStyle = this.bottomBorderStyle;
        this.leftBorderStyle = this.bottomBorderStyle;
    }

    public void setExpRectBorder(ExportLineStyle exportLineStyle, ExportLineStyle exportLineStyle2, ExportLineStyle exportLineStyle3, ExportLineStyle exportLineStyle4) {
        this.leftBorderStyle = exportLineStyle;
        this.topBorderStyle = exportLineStyle2;
        this.rightBorderStyle = exportLineStyle3;
        this.bottomBorderStyle = exportLineStyle4;
    }

    public void setLeftBorder(ExportLineStyle exportLineStyle) {
        this.leftBorderStyle = exportLineStyle;
    }

    public void setTopBorder(ExportLineStyle exportLineStyle) {
        this.topBorderStyle = exportLineStyle;
    }

    public void setRightBorder(ExportLineStyle exportLineStyle) {
        this.rightBorderStyle = exportLineStyle;
    }

    public void setBottomBorder(ExportLineStyle exportLineStyle) {
        this.bottomBorderStyle = exportLineStyle;
    }

    public void setExpRectBackground(Color color) {
        this.background = color;
    }

    public void setFillPatternProperties(FillPatternProperties fillPatternProperties) {
        this.fillProp = fillPatternProperties;
    }

    public void setBorderJoint(int n) {
        this.borderJoint = n;
    }

    public void setRoundJointRadius(float f) {
        this.roundJointRadius = f;
    }

    public Box getInnerLocation() {
        if (this.BORDERJOINT_MITER == null) {
            float f = this.leftBorderStyle == null ? 0.0f : this.leftBorderStyle.lineWidth / 2.0f;
            float f2 = this.topBorderStyle == null ? 0.0f : this.topBorderStyle.lineWidth / 2.0f;
            float f3 = this.rightBorderStyle == null ? 0.0f : this.rightBorderStyle.lineWidth / 2.0f;
            float f4 = this.bottomBorderStyle == null ? 0.0f : this.bottomBorderStyle.lineWidth / 2.0f;
            Box box = new Box(this.location);
            box.x += f;
            box.y += f2;
            box.width = box.width - f - f3;
            box.height = box.height - f2 - f4;
            this.BORDERJOINT_MITER = box;
        }
        return this.BORDERJOINT_MITER;
    }

    public void setShadow(boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color, int n) {
        this.drawHShadow = bl;
        this.drawVShadow = bl2;
        this.indentHShadow = bl3;
        this.indentVShadow = bl4;
        this.shadowWidth = n;
        this.shadowColor = color;
    }
}

