/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.bean.PDFParameter;
import jet.connect.DbBinary;
import jet.connect.DbValue;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.CommNode;
import jet.datastream.Communicator;
import jet.datastream.DSArea;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDBField;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSGMap;
import jet.datastream.DSGeoMap;
import jet.datastream.DSGroup;
import jet.datastream.DSMap;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSNavigateControl;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSPicture;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSSlider;
import jet.datastream.DSSubReport;
import jet.datastream.DSTOC;
import jet.datastream.DSTable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextBox;
import jet.datastream.DSTextObj;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderHidden;
import jet.datastream.render.RenderImage;
import jet.datastream.render.RenderImageButton;
import jet.datastream.render.RenderRank;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.pdf.ArabicShaping;
import jet.export.pdf.Box;
import jet.export.pdf.ExportLine;
import jet.export.pdf.ExportLineStyle;
import jet.export.pdf.ExportRectFromV7;
import jet.export.pdf.ExportRectangle;
import jet.export.pdf.ExportText;
import jet.export.pdf.ExportTextStyle;
import jet.export.pdf.GeoBdrInfo;
import jet.export.pdf.GridBox;
import jet.export.pdf.GridBoxes;
import jet.export.pdf.PDFCache;
import jet.export.pdf.PDFConstants;
import jet.export.pdf.PDFFont;
import jet.export.pdf.PDFSpliter;
import jet.export.pdf.PDFWriter;
import jet.export.pdf.PdfExt;
import jet.export.relayout.table.ContainerInfo;
import jet.export.relayout.table.ContentCell;
import jet.export.relayout.table.DrawingTable;
import jet.export.relayout.table.RectCell;
import jet.export.relayout.table.Row;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;
import jet.export.util.DSShapeRegion;
import jet.export.util.ExportUtil;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.FontInfo;
import jet.export.util.ImageEngine;
import jet.export.util.ImageInfo;
import jet.export.util.ImageTool;
import jet.naming.PropertyNames;
import jet.thinviewer.JReportGoMap;
import jet.thinviewer.JReportGoogleMap;
import jet.thinviewer.JReportMap;
import jet.udo.HtmlGeneratable;
import jet.udo.JRObjectRender;
import jet.udos.JHyperLinkRslt;
import jet.udos.JHyperlinkLineInfo;
import jet.util.BitmapReader;
import jet.util.FontSets;
import jet.util.JRInterruptedException;
import jet.util.TreeIterater;
import jet.util.image.ImageResource;

public class ExportToPDF
extends AbstractExporter
implements PDFConstants {
    private String BLACK = null;
    private OutputStream BORDERJOINT_ROUND = null;
    public static final String FILENAME_SEPARATE = "_";
    public static final String FILENAME_OF = "of";
    public final int maxSizeofPDF;
    public final int maxPageofPDF;
    private String ConvertProperties;
    private CommEnumeration FILL_COLOR;
    private Vector HorizontalAlignment;
    private Hashtable SEDU;
    private Vector WHITE;
    private boolean _bdcolor;
    private Stack _bdrstyle;
    private Vector _bdrwidth;
    private Vector _bgcolor;
    private Rectangle _height;
    private int _toolkit;
    private int _type;
    private int _width;
    private int _x;
    private boolean _y;
    private int add;
    private int addElement = -1;
    private float addPropsChangedBy = -1.0f;
    private boolean addSuffix;
    private boolean append;
    private IntHashtable arca;
    private ArabicShaping ascent;
    private PDFWriter background;
    private PdfExt backgroundColor;
    private int bgRect;
    private String black;
    private int booleanValue;
    private final boolean borderColor;
    private int borderCount = 1;
    private final PDFParameter borderJoint;
    private ImageEngine borderStyle;
    private boolean borderWidth = false;
    private HashMap bottomBorderStyle = new HashMap();
    private HashMap charAt = new HashMap();
    private HashMap checkFilePathExist = new HashMap();
    private PDFCache checkOutputStream;
    private ImageTool checkStop;
    private Hashtable clear;
    private Hashtable clearCacheRender;
    private int clip = 0;
    private ExportAuxInfo close;

    public ExportToPDF(Communicator[] communicatorArray, PDFParameter pDFParameter) {
        this._commuList = communicatorArray;
        this.borderJoint = pDFParameter;
        this.borderColor = pDFParameter.isSimPrintMode();
        this.maxSizeofPDF = pDFParameter.getMaxSizeOfOneFile();
        this.maxPageofPDF = pDFParameter.getMaxPageOfOneFile();
        this.checkStop = new ImageTool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        JRLog.indent("PDF Exporter");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401001);
        }
        this.checkOutputStream = new PDFCache(this.close, "pdf");
        this.checkFilePathExist(string);
        this.BLACK = this.validFileName(string);
        this.BW2();
        Stack<String> stack = new Stack<String>();
        try {
            JRLog.indent("build PDF file.");
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401011);
            }
            int n = 1;
            int[] nArray = this.borderJoint.getExportPages();
            int[][] nArray2 = this.borderJoint.getExportPageRange();
            Color color = null;
            int n2 = 0;
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                if (this._commu == null) continue;
                this.clip += n2;
                n2 = 0;
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "Start export communicator: " + this._commu);
                }
                this.CONTACT();
                try {
                    color = this._commu.getHeaderInfo((int)0).background;
                    while (this.FILL_COLOR.hasMoreElements()) {
                        ExportUtil.checkStop(this._commu);
                        if ((nArray != null || nArray2 != null) && this.BORDERLINENAME(nArray, nArray2, ++n2)) {
                            this.FILL_COLOR.nextElement();
                            continue;
                        }
                        DSPage dSPage = (DSPage)this.FILL_COLOR.nextElement();
                        this.BORDERJOINT_ROUND(dSPage, n, stack, color);
                        if (color != null) {
                            this.background.fillRect(0.0f, 0.0f, this._width, this._x, color);
                        }
                        this.DEF_COLOR(dSPage);
                        ++n;
                    }
                    continue;
                }
                finally {
                    this._commu.setResolution(this.booleanValue);
                    this.BH();
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, "Finished export communicator: " + this._commu);
                    }
                }
            }
            this.clip();
            File file = new File(this.BLACK);
            if (file.exists() && file.isFile()) {
                stack.push(this.BLACK);
            }
            this.clearCacheRender(stack, color);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, this.BLACK, true);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)exception);
            }
            ExportUtil.checkStop(this._commu);
            throw new ExpException(401001, (Throwable)exception);
        }
        finally {
            if (this.background != null && this.background._pdf != null) {
                try {
                    this.background.dispose();
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, outOfSpaceException);
                    }
                    throw new ExpException(outOfSpaceException);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, iOException);
                    }
                    throw new ExpException(iOException);
                }
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401012);
            }
            JRLog.deIndent("build PDF file.");
        }
        ExportUtil.checkStop(this._commu);
        if (this.maxSizeofPDF == -1) {
            this.BLACK(stack);
        }
        ExportUtil.checkStop(this._commu);
        JRLog.deIndent("PDF Exporter");
        PDFSpliter pDFSpliter = new PDFSpliter(stack, this.borderJoint, this.close);
        if (this.maxSizeofPDF != -1 && stack.size() > 0) {
            pDFSpliter.splitBySize();
        } else if (this.maxPageofPDF != -1 && stack.size() > 0) {
            pDFSpliter.splitByPage();
        }
        return stack;
    }

    private void BH() {
        this.charAt.clear();
        this.bottomBorderStyle.clear();
        this.checkOutputStream.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void BLACK(Stack stack) throws ExpException {
        if (this.borderJoint != null && this.borderJoint.hasSignature()) {
            try {
                KeyStore keyStore = this.getKeyStore(this.borderJoint.getDigitalIDFileStream(), this.borderJoint.getDigitalIDFilePassword());
                Enumeration enumeration = stack.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = ExportToPDF.addSuffix("encrypt.pdf", String.valueOf(new SecureRandom().nextDouble()));
                    File file = new File(string);
                    File file2 = new File(this.checkOutputStream.getTemporaryPath(), string2);
                    file.renameTo(file2);
                    this.checkOutputStream.fileUpdated(new File(string));
                    this.checkOutputStream.fileUpdated(file2);
                    try {
                        PdfReader pdfReader = new PdfReader(file2.getPath());
                        File file3 = this.close.getDiskStore().createFile(string);
                        FileOutputStream fileOutputStream = new FileOutputStream(file3);
                        PdfStamper pdfStamper = PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)fileOutputStream, (char)'\u0000');
                        PDFWriter.signAndEncrypt(keyStore, pdfStamper, this.borderJoint);
                        pdfStamper.close();
                        this.close.getDiskStore().fileUpdated(file3);
                    }
                    finally {
                        if (file2 == null || !file2.exists()) continue;
                        this.checkOutputStream.delete(file2);
                    }
                }
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401002, (Throwable)exception);
                }
                throw new ExpException(401002, (Throwable)exception);
            }
        }
    }

    protected KeyStore getKeyStore(InputStream inputStream, String string) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        if (string != null) {
            keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(inputStream, string.toCharArray());
        } else if (JRLog.isError(2)) {
            JRLog.error(2, 131590);
        }
        return keyStore;
    }

    private void BORDERJOINT_ROUND(DSPage dSPage, int n, Stack stack, Color color) throws IOException, DocumentException, OutOfSpaceException {
        this.color(dSPage);
        boolean bl = false;
        if (n == 1) {
            this.close(this.BLACK);
        }
        if (n == 1 || bl) {
            this.background.open(new Dimension(this._width, this._x), color);
        } else {
            this.background.initPdfPage(new Dimension(this._width, this._x), color);
        }
    }

    private boolean BORDERLINENAME(int[] nArray, int[][] nArray2, int n) {
        int n2;
        int n3 = 0;
        if (nArray != null) {
            n3 = nArray.length;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            return false;
        }
        n2 = 0;
        if (nArray2 != null) {
            n2 = nArray2.length;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int[] nArray3 = nArray2[i];
            n4 = nArray3[0];
            n5 = nArray3[1];
            if (n < n4 || n > n5) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        JRLog.indent("PDF Exporter");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401001);
        }
        this.checkOutputStream = new PDFCache(this.close, "pdf");
        this.checkOutputStream(outputStream);
        OutputStream outputStream2 = this.BORDERJOINT_ROUND = new BufferedOutputStream(outputStream);
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.borderJoint.hasSignature()) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream2 = byteArrayOutputStream;
        }
        this.BW2();
        try {
            JRLog.indent("build PDF file.");
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401011);
            }
            int n = 1;
            int[] nArray = this.borderJoint.getExportPages();
            int[][] nArray2 = this.borderJoint.getExportPageRange();
            this.backgroundColor = new PdfExt();
            this.background = new PDFWriter(this.backgroundColor, outputStream2, this.borderJoint, this.close);
            this.background.setEncoding(this._commuList[0].getEncoding());
            int n2 = 0;
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                this.clip += n2;
                n2 = 0;
                if (JRLog.isTrace(4)) {
                    JRLog.trace(4, "Start export communicator: " + this._commu);
                }
                this.CONTACT();
                try {
                    Color color = this._commu.getHeaderInfo((int)0).background;
                    while (this.FILL_COLOR.hasMoreElements()) {
                        ExportUtil.checkStop(this._commu);
                        if ((nArray != null || nArray2 != null) && this.BORDERLINENAME(nArray, nArray2, ++n2)) {
                            this.FILL_COLOR.nextElement();
                            continue;
                        }
                        DSPage dSPage = (DSPage)this.FILL_COLOR.nextElement();
                        this.color(dSPage);
                        if (n == 1) {
                            this.background.open(new Dimension(this._width, this._x), color);
                        } else {
                            this.background.initPdfPage(new Dimension(this._width, this._x), color);
                        }
                        if (color != null) {
                            this.background.fillRect(0.0f, 0.0f, this._width, this._x, color);
                        }
                        this.DEF_COLOR(dSPage);
                        ++n;
                    }
                    continue;
                }
                finally {
                    this._commu.setResolution(this.booleanValue);
                    this.BH();
                    if (JRLog.isTrace(4)) {
                        JRLog.trace(4, "Finished export communicator: " + this._commu);
                    }
                }
            }
            this.clip();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, "", false);
        }
        catch (JRInterruptedException jRInterruptedException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)jRInterruptedException);
            }
            throw jRInterruptedException;
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401001, (Throwable)exception);
            }
            throw new ExpException(401001, (Throwable)exception);
        }
        finally {
            if (this.background != null && this.background._pdf != null) {
                try {
                    this.background.dispose();
                }
                catch (OutOfSpaceException outOfSpaceException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, outOfSpaceException);
                    }
                    throw new ExpException(outOfSpaceException);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, iOException);
                    }
                    throw new ExpException(iOException);
                }
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4401012);
            }
            JRLog.deIndent("build PDF file.");
        }
        ExportUtil.checkStop(this._commu);
        this.BW1(byteArrayOutputStream);
        ExportUtil.checkStop(this._commu);
        JRLog.deIndent("PDF Exporter");
    }

    private void BW1(ByteArrayOutputStream byteArrayOutputStream) throws ExpException {
        if (this.borderJoint != null && this.borderJoint.hasSignature()) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            try {
                PdfReader pdfReader = new PdfReader((InputStream)byteArrayInputStream);
                PdfStamper pdfStamper = PdfStamper.createSignature((PdfReader)pdfReader, (OutputStream)this.BORDERJOINT_ROUND, (char)'\u0000');
                KeyStore keyStore = this.getKeyStore(this.borderJoint.getDigitalIDFileStream(), this.borderJoint.getDigitalIDFilePassword());
                PDFWriter.signAndEncrypt(keyStore, pdfStamper, this.borderJoint);
                pdfStamper.close();
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401003, (Throwable)exception);
                }
                throw new ExpException(401003, (Throwable)exception);
            }
            finally {
                try {
                    byteArrayInputStream.close();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2401004, (Throwable)iOException);
                    }
                    throw new ExpException(401004, (Throwable)iOException);
                }
            }
        }
    }

    private void BW2() {
        JRLog.indent("Init parameters");
        JRLog.indent("Parameters list");
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "Communicator count: " + this._commuList.length);
            JRLog.trace(5, 5401002, new Integer(this.borderJoint.getImageCompressRatio()));
            JRLog.trace(5, 5401003, new Integer(this.borderJoint.getMaxSizeOfOneFile()));
            JRLog.trace(5, 5401004, new Boolean(this.borderJoint.hasDrill()));
            JRLog.trace(5, 5401005, new Boolean(this.borderJoint.hasToc()));
            JRLog.trace(5, 5401006, new Boolean(this.borderJoint.isSimPrintMode()));
            JRLog.trace(5, 5401007, new Boolean(this.borderJoint.noMargin()));
            JRLog.trace(5, 5401008, (Object[])this.borderJoint.getExportPageRange());
            JRLog.trace(5, 5401009, (Object)this.borderJoint.getExportPages());
            JRLog.trace(5, 5401010, new Boolean(this.borderJoint.hasEncryption()));
            if (this.borderJoint.hasEncryption()) {
                JRLog.trace(5, 5401013, new Integer(this.borderJoint.getPermissions()));
                JRLog.trace(5, 5401014, new Boolean(this.borderJoint.isStrength128Bits()));
            }
            JRLog.trace(5, 5401015, new Boolean(this.borderJoint.hasSignature()));
            if (this.borderJoint.hasSignature()) {
                JRLog.trace(5, 5401017, this.borderJoint.getDigitalIDFileStream());
                JRLog.trace(5, 5401018, new Integer(this.borderJoint.getSignatureMethod()));
                JRLog.trace(5, 5401019, this.borderJoint.getSigningContact());
                JRLog.trace(5, 5401020, this.borderJoint.getSigningLocation());
                JRLog.trace(5, 5401021, this.borderJoint.getSigningReason());
            }
            JRLog.trace(5, 5401022, new Boolean(this.append));
            JRLog.trace(5, 5401023, new Boolean(this._y));
            JRLog.trace(5, 5401024, new Boolean(this.borderJoint.isTransparent()));
            JRLog.trace(5, "parameter \"clippingArea\" = " + this.borderJoint.getClippingArea());
        }
        JRLog.deIndent("Parameters list");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4401002);
        }
        JRLog.deIndent("Init parameters");
    }

    private void CONTACT() throws ExpException, JRStopEngineException {
        DataStream dataStream;
        this.waitCommunicator();
        this._toolkit = 0;
        this._type = 0;
        if (this.borderJoint.hasDrill()) {
            this.SEDU = new Hashtable();
            this.WHITE = new Vector();
        }
        this._bdcolor = true;
        this.black = "";
        this.append = this.convertUnitToPoint();
        if (this.append && this.arca == null) {
            this.ConvertProperties();
        }
        this.ConvertProperties = this._commu.getHeaderInfo(0).getEmbFonts();
        Vector vector = this._commu.getLinkComms();
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = ((Communicator)vector.get(i)).getHeaderInfo(0).getEmbFonts();
                this.ConvertProperties = this.ConvertProperties + "; " + string;
            }
        }
        this._y = (dataStream = (DataStream)this._commu.getDataStream(0)).ie() == 1;
        this.borderStyle = new ImageEngine();
        this.borderWidth = this.borderJoint.getImageCompressRatio() == -1;
        this.borderStyle.setResolusion(Unit.getResolution());
        this._bdrstyle = new Stack();
        this._bdrstyle.push(new Offset(0, 0));
        this.FILL_COLOR = new CommEnumeration(this._commu);
        this.booleanValue = this._commu.getResolution();
        this._commu.setResolution(Unit.getResolution());
    }

    private void ConvertProperties() {
        if (this.arca == null) {
            this.arca = new IntHashtable();
            this.arca.put(40, 41);
            this.arca.put(41, 40);
            this.arca.put(60, 62);
            this.arca.put(62, 60);
            this.arca.put(91, 93);
            this.arca.put(93, 91);
            this.arca.put(123, 125);
            this.arca.put(125, 123);
            this.arca.put(171, 187);
            this.arca.put(187, 171);
            this.arca.put(8249, 8250);
            this.arca.put(8250, 8249);
            this.arca.put(8261, 8262);
            this.arca.put(8262, 8261);
            this.arca.put(8317, 8318);
            this.arca.put(8318, 8317);
            this.arca.put(8333, 8334);
            this.arca.put(8334, 8333);
            this.arca.put(8712, 8715);
            this.arca.put(8713, 8716);
            this.arca.put(8714, 8717);
            this.arca.put(8715, 8712);
            this.arca.put(8716, 8713);
            this.arca.put(8717, 8714);
            this.arca.put(8725, 10741);
            this.arca.put(8764, 8765);
            this.arca.put(8765, 8764);
            this.arca.put(8771, 8909);
            this.arca.put(8786, 8787);
            this.arca.put(8787, 8786);
            this.arca.put(8788, 8789);
            this.arca.put(8789, 8788);
            this.arca.put(8804, 8805);
            this.arca.put(8805, 8804);
            this.arca.put(8806, 8807);
            this.arca.put(8807, 8806);
            this.arca.put(8808, 8809);
            this.arca.put(8809, 8808);
            this.arca.put(8810, 8811);
            this.arca.put(8811, 8810);
            this.arca.put(8814, 8815);
            this.arca.put(8815, 8814);
            this.arca.put(8816, 8817);
            this.arca.put(8817, 8816);
            this.arca.put(8818, 8819);
            this.arca.put(8819, 8818);
            this.arca.put(8820, 8821);
            this.arca.put(8821, 8820);
            this.arca.put(8822, 8823);
            this.arca.put(8823, 8822);
            this.arca.put(8824, 8825);
            this.arca.put(8825, 8824);
            this.arca.put(8826, 8827);
            this.arca.put(8827, 8826);
            this.arca.put(8828, 8829);
            this.arca.put(8829, 8828);
            this.arca.put(8830, 8831);
            this.arca.put(8831, 8830);
            this.arca.put(8832, 8833);
            this.arca.put(8833, 8832);
            this.arca.put(8834, 8835);
            this.arca.put(8835, 8834);
            this.arca.put(8836, 8837);
            this.arca.put(8837, 8836);
            this.arca.put(8838, 8839);
            this.arca.put(8839, 8838);
            this.arca.put(8840, 8841);
            this.arca.put(8841, 8840);
            this.arca.put(8842, 8843);
            this.arca.put(8843, 8842);
            this.arca.put(8847, 8848);
            this.arca.put(8848, 8847);
            this.arca.put(8849, 8850);
            this.arca.put(8850, 8849);
            this.arca.put(8856, 10680);
            this.arca.put(8866, 8867);
            this.arca.put(8867, 8866);
            this.arca.put(8870, 10974);
            this.arca.put(8872, 10980);
            this.arca.put(8873, 10979);
            this.arca.put(8875, 10981);
            this.arca.put(8880, 8881);
            this.arca.put(8881, 8880);
            this.arca.put(8882, 8883);
            this.arca.put(8883, 8882);
            this.arca.put(8884, 8885);
            this.arca.put(8885, 8884);
            this.arca.put(8886, 8887);
            this.arca.put(8887, 8886);
            this.arca.put(8905, 8906);
            this.arca.put(8906, 8905);
            this.arca.put(8907, 8908);
            this.arca.put(8908, 8907);
            this.arca.put(8909, 8771);
            this.arca.put(8912, 8913);
            this.arca.put(8913, 8912);
            this.arca.put(8918, 8919);
            this.arca.put(8919, 8918);
            this.arca.put(8920, 8921);
            this.arca.put(8921, 8920);
            this.arca.put(8922, 8923);
            this.arca.put(8923, 8922);
            this.arca.put(8924, 8925);
            this.arca.put(8925, 8924);
            this.arca.put(8926, 8927);
            this.arca.put(8927, 8926);
            this.arca.put(8928, 8929);
            this.arca.put(8929, 8928);
            this.arca.put(8930, 8931);
            this.arca.put(8931, 8930);
            this.arca.put(8932, 8933);
            this.arca.put(8933, 8932);
            this.arca.put(8934, 8935);
            this.arca.put(8935, 8934);
            this.arca.put(8936, 8937);
            this.arca.put(8937, 8936);
            this.arca.put(8938, 8939);
            this.arca.put(8939, 8938);
            this.arca.put(8940, 8941);
            this.arca.put(8941, 8940);
            this.arca.put(8944, 8945);
            this.arca.put(8945, 8944);
            this.arca.put(8946, 8954);
            this.arca.put(8947, 8955);
            this.arca.put(8948, 8956);
            this.arca.put(8950, 8957);
            this.arca.put(8951, 8958);
            this.arca.put(8954, 8946);
            this.arca.put(8955, 8947);
            this.arca.put(8956, 8948);
            this.arca.put(8957, 8950);
            this.arca.put(8958, 8951);
            this.arca.put(8968, 8969);
            this.arca.put(8969, 8968);
            this.arca.put(8970, 8971);
            this.arca.put(8971, 8970);
            this.arca.put(9001, 9002);
            this.arca.put(9002, 9001);
            this.arca.put(10088, 10089);
            this.arca.put(10089, 10088);
            this.arca.put(10090, 10091);
            this.arca.put(10091, 10090);
            this.arca.put(10092, 10093);
            this.arca.put(10093, 10092);
            this.arca.put(10094, 10095);
            this.arca.put(10095, 10094);
            this.arca.put(10096, 10097);
            this.arca.put(10097, 10096);
            this.arca.put(10098, 10099);
            this.arca.put(10099, 10098);
            this.arca.put(10100, 10101);
            this.arca.put(10101, 10100);
            this.arca.put(10197, 10198);
            this.arca.put(10198, 10197);
            this.arca.put(10205, 10206);
            this.arca.put(10206, 10205);
            this.arca.put(10210, 10211);
            this.arca.put(10211, 10210);
            this.arca.put(10212, 10213);
            this.arca.put(10213, 10212);
            this.arca.put(10214, 10215);
            this.arca.put(10215, 10214);
            this.arca.put(10216, 10217);
            this.arca.put(10217, 10216);
            this.arca.put(10218, 10219);
            this.arca.put(10219, 10218);
            this.arca.put(10627, 10628);
            this.arca.put(10628, 10627);
            this.arca.put(10629, 10630);
            this.arca.put(10630, 10629);
            this.arca.put(10631, 10632);
            this.arca.put(10632, 10631);
            this.arca.put(10633, 10634);
            this.arca.put(10634, 10633);
            this.arca.put(10635, 10636);
            this.arca.put(10636, 10635);
            this.arca.put(10637, 10640);
            this.arca.put(10638, 10639);
            this.arca.put(10639, 10638);
            this.arca.put(10640, 10637);
            this.arca.put(10641, 10642);
            this.arca.put(10642, 10641);
            this.arca.put(10643, 10644);
            this.arca.put(10644, 10643);
            this.arca.put(10645, 10646);
            this.arca.put(10646, 10645);
            this.arca.put(10647, 10648);
            this.arca.put(10648, 10647);
            this.arca.put(10680, 8856);
            this.arca.put(10688, 10689);
            this.arca.put(10689, 10688);
            this.arca.put(10692, 10693);
            this.arca.put(10693, 10692);
            this.arca.put(10703, 10704);
            this.arca.put(10704, 10703);
            this.arca.put(10705, 10706);
            this.arca.put(10706, 10705);
            this.arca.put(10708, 10709);
            this.arca.put(10709, 10708);
            this.arca.put(10712, 10713);
            this.arca.put(10713, 10712);
            this.arca.put(10714, 10715);
            this.arca.put(10715, 10714);
            this.arca.put(10741, 8725);
            this.arca.put(10744, 10745);
            this.arca.put(10745, 10744);
            this.arca.put(10748, 10749);
            this.arca.put(10749, 10748);
            this.arca.put(10795, 10796);
            this.arca.put(10796, 10795);
            this.arca.put(10797, 10796);
            this.arca.put(10798, 10797);
            this.arca.put(10804, 10805);
            this.arca.put(10805, 10804);
            this.arca.put(10812, 10813);
            this.arca.put(10813, 10812);
            this.arca.put(10852, 10853);
            this.arca.put(10853, 10852);
            this.arca.put(10873, 10874);
            this.arca.put(10874, 10873);
            this.arca.put(10877, 10878);
            this.arca.put(10878, 10877);
            this.arca.put(10879, 10880);
            this.arca.put(10880, 10879);
            this.arca.put(10881, 10882);
            this.arca.put(10882, 10881);
            this.arca.put(10883, 10884);
            this.arca.put(10884, 10883);
            this.arca.put(10891, 10892);
            this.arca.put(10892, 10891);
            this.arca.put(10897, 10898);
            this.arca.put(10898, 10897);
            this.arca.put(10899, 10900);
            this.arca.put(10900, 10899);
            this.arca.put(10901, 10902);
            this.arca.put(10902, 10901);
            this.arca.put(10903, 10904);
            this.arca.put(10904, 10903);
            this.arca.put(10905, 10906);
            this.arca.put(10906, 10905);
            this.arca.put(10907, 10908);
            this.arca.put(10908, 10907);
            this.arca.put(10913, 10914);
            this.arca.put(10914, 10913);
            this.arca.put(10918, 10919);
            this.arca.put(10919, 10918);
            this.arca.put(10920, 10921);
            this.arca.put(10921, 10920);
            this.arca.put(10922, 10923);
            this.arca.put(10923, 10922);
            this.arca.put(10924, 10925);
            this.arca.put(10925, 10924);
            this.arca.put(10927, 10928);
            this.arca.put(10928, 10927);
            this.arca.put(10931, 10932);
            this.arca.put(10932, 10931);
            this.arca.put(10939, 10940);
            this.arca.put(10940, 10939);
            this.arca.put(10941, 10942);
            this.arca.put(10942, 10941);
            this.arca.put(10943, 10944);
            this.arca.put(10944, 10943);
            this.arca.put(10945, 10946);
            this.arca.put(10946, 10945);
            this.arca.put(10947, 10948);
            this.arca.put(10948, 10947);
            this.arca.put(10949, 10950);
            this.arca.put(10950, 10949);
            this.arca.put(10957, 10958);
            this.arca.put(10958, 10957);
            this.arca.put(10959, 10960);
            this.arca.put(10960, 10959);
            this.arca.put(10961, 10962);
            this.arca.put(10962, 10961);
            this.arca.put(10963, 10964);
            this.arca.put(10964, 10963);
            this.arca.put(10965, 10966);
            this.arca.put(10966, 10965);
            this.arca.put(10974, 8870);
            this.arca.put(10979, 8873);
            this.arca.put(10980, 8872);
            this.arca.put(10981, 8875);
            this.arca.put(10988, 10989);
            this.arca.put(10989, 10988);
            this.arca.put(10999, 11000);
            this.arca.put(11000, 10999);
            this.arca.put(11001, 11002);
            this.arca.put(11002, 11001);
            this.arca.put(12296, 12297);
            this.arca.put(12297, 12296);
            this.arca.put(12298, 12299);
            this.arca.put(12299, 12298);
            this.arca.put(12300, 12301);
            this.arca.put(12301, 12300);
            this.arca.put(12302, 12303);
            this.arca.put(12303, 12302);
            this.arca.put(12304, 12305);
            this.arca.put(12305, 12304);
            this.arca.put(12308, 12309);
            this.arca.put(12309, 12308);
            this.arca.put(12310, 12311);
            this.arca.put(12311, 12310);
            this.arca.put(12312, 12313);
            this.arca.put(12313, 12312);
            this.arca.put(12314, 12315);
            this.arca.put(12315, 12314);
            this.arca.put(65288, 65289);
            this.arca.put(65289, 65288);
            this.arca.put(65308, 65310);
            this.arca.put(65310, 65308);
            this.arca.put(65339, 65341);
            this.arca.put(65341, 65339);
            this.arca.put(65371, 65373);
            this.arca.put(65373, 65371);
            this.arca.put(65375, 65376);
            this.arca.put(65376, 65375);
            this.arca.put(65378, 65379);
            this.arca.put(65379, 65378);
            this.ascent = new ArabicShaping(127);
        }
    }

    private void DEF_COLOR(DSPage dSPage) throws IOException, DocumentException, JRStopEngineException {
        float f = ExportToPDF.convertUnitToPoint(this._height.width);
        float f2 = ExportToPDF.convertUnitToPoint(this._height.height);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(this._toolkit, this._type, f, f2);
        }
        this.add = dSPage.getPageNum();
        this.HorizontalAlignment = new Vector();
        List list = ExportUtil.getContainerChildren(dSPage);
        this.FB(list, 0, 0);
        if (this._y) {
            this.writeEvaluation();
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void FB(List list, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle;
        ArrayList<JRObjectResult> arrayList = new ArrayList<JRObjectResult>();
        ArrayList<JRObjectResult> arrayList2 = new ArrayList<JRObjectResult>();
        HashMap<DSSection, ExportRectangle> hashMap = new HashMap<DSSection, ExportRectangle>();
        JRObjectResult jRObjectResult = null;
        DSContainer dSContainer = null;
        Vector vector = null;
        Box box = null;
        int n3 = list.size();
        while (--n3 >= 0) {
            jRObjectResult = this.convertTwoRes((JRObjectResult)list.get(n3));
            boolean bl = this.checkOutputStream.isExport(jRObjectResult);
            if (!bl && this.addElement == -1) continue;
            if (jRObjectResult instanceof DSShape) {
                arrayList2.add(jRObjectResult);
                continue;
            }
            if (jRObjectResult instanceof DSTable) {
                dSContainer = (DSTable)jRObjectResult;
                continue;
            }
            if (jRObjectResult instanceof DSGroup) continue;
            arrayList.add(jRObjectResult);
        }
        if (dSContainer != null) {
            box = this.writeTable((DSTable)dSContainer, n, n2, (Offset)this._bdrstyle.peek());
            vector = dSContainer.getChildren();
            this.addPropsChangedBy = box.width;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            JRObjectResult jRObjectResult2 = (JRObjectResult)listIterator.next();
            if (!(jRObjectResult2 instanceof DSSection)) continue;
            exportRectangle = this._bdcolor((DSSection)jRObjectResult2, n, n2);
            hashMap.put((DSSection)jRObjectResult2, exportRectangle);
            this.drawRect(exportRectangle);
        }
        if (vector != null) {
            this.writeColumns(vector, n, box);
        }
        listIterator = arrayList2.listIterator();
        while (listIterator.hasNext()) {
            this.writeShape((DSShape)listIterator.next(), n);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JRObjectResult jRObjectResult3 = (JRObjectResult)arrayList.get(i);
            exportRectangle = null;
            if (jRObjectResult3 instanceof DSSection) {
                exportRectangle = (ExportRectangle)hashMap.get((DSSection)jRObjectResult3);
                this._bdrstyle((DSSection)jRObjectResult3, exportRectangle, n);
                continue;
            }
            this.FILL_COLOR(jRObjectResult3, n, n2);
        }
        Enumeration enumeration = this.HorizontalAlignment.elements();
        while (enumeration.hasMoreElements()) {
            this.writeShapeBorder((GeoBdrInfo)enumeration.nextElement());
        }
        this.addPropsChangedBy = -1.0f;
    }

    private void FILL_COLOR(JRObjectResult jRObjectResult, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        boolean bl = this.checkOutputStream.isExport(jRObjectResult);
        if (bl || this.addElement != -1) {
            int n3 = jRObjectResult.getObjectType();
            if (jRObjectResult instanceof DSField) {
                String string = this.convertPixelToUnit((DSField)jRObjectResult);
                this.writeField((DSField)jRObjectResult, n, n2, string);
            } else if (jRObjectResult instanceof DSSubReport) {
                this.append((DSSubReport)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSBody) {
                this._bdrwidth((DSBody)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTabular) {
                this.WHITE((DSTabular)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTabularCell) {
                this.TW((DSTabularCell)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParagraph) {
                this._bgcolor((DSParagraph)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParagraphText) {
                this.writeParagraphText((DSParagraphText)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSCrossTab) {
                this.writeCrosstab((DSCrossTab)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTextObj) {
                this.writeTextObject((DSTextObj)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSChartPlatform) {
                this.writeChart((DSChartPlatform)jRObjectResult, n2);
            } else if (jRObjectResult instanceof DSTableObject) {
                this.SEDU((DSTableObject)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTableRow) {
                this.NEWBORDERCOLOR((DSTableRow)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTableCell) {
                this.PHONE((DSTableCell)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSTextBox) {
                this.NEWBORDERWIDTH((DSTextBox)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSMultiValueContainer) {
                boolean bl2 = CCUtil.getBooleanPropertyByName(jRObjectResult, "ExportToPDF");
                if (bl2) {
                    this.arca((DSMultiValueContainer)jRObjectResult, n, n2);
                }
            } else if ((n3 & 0x80) == 128) {
                if (n3 == 128) {
                    this.writePicture((DSPicture)jRObjectResult, n, n2);
                } else if (n3 == 129) {
                    this.writeMediaField((DSPicture)jRObjectResult, n, n2);
                }
            } else if (n3 == 4096) {
                this.writeUDO((JRVisiableResult)jRObjectResult, n);
            } else if (jRObjectResult instanceof DSMap) {
                this.ascent((DSMap)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSFilterControl) {
                this.FT((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSNavigateButton) {
                this.FT((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSSlider) {
                this.FT((JRVisiableResult)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSParameterForm) {
                this.LIMITEDBOUND((DSParameterForm)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSNavigateControl) {
                this.HorizontalAlignment((DSNavigateControl)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSGMap) {
                this.background((DSGMap)jRObjectResult, n, n2);
            } else if (jRObjectResult instanceof DSGeoMap) {
                this.backgroundColor((DSGeoMap)jRObjectResult, n, n2);
            } else if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3401001, jRObjectResult);
            }
        }
    }

    private void FT(JRVisiableResult jRVisiableResult, int n, int n2) throws IOException, DocumentException {
        ExportRectangle exportRectangle = this.addElement(jRVisiableResult, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        this.drawRect(exportRectangle);
        Render render = null;
        if (jRVisiableResult instanceof DSFilterControl) {
            render = ((DSFilterControl)jRVisiableResult).getRender();
        } else if (jRVisiableResult instanceof DSNavigateButton) {
            render = ((DSNavigateButton)jRVisiableResult).getRender();
        } else if (jRVisiableResult instanceof DSSlider) {
            render = ((DSSlider)jRVisiableResult).getRender();
        }
        if (render != null) {
            this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), jRVisiableResult.getX(), this.getY(jRVisiableResult, n2)));
            this.borderColor(render, n, null);
            this._bdrstyle.pop();
        }
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void HorizontalAlignment(DSNavigateControl dSNavigateControl, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        this._commu(dSNavigateControl, n, n2);
    }

    private void LIMITEDBOUND(DSParameterForm dSParameterForm, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        ExportRectangle exportRectangle = this.addElement(dSParameterForm, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        this.drawRect(exportRectangle);
        this._commuList(dSParameterForm, n, n2);
        boolean bl = CCUtil.getBooleanPropertyByName(dSParameterForm, "IsShowTitle");
        if (bl) {
            Offset offset = (Offset)this._bdrstyle.peek();
            Rectangle rectangle = dSParameterForm.getTitleRec();
            int[] nArray = dSParameterForm.getTitleXY();
            Color color = CCUtil.getColorPropertyByName(dSParameterForm, "TitleBackground");
            if (rectangle != null) {
                int n3 = dSParameterForm.getX() + n + rectangle.x;
                int n4 = this.getY(dSParameterForm, n2) + rectangle.y;
                Box box = this.getLocation(offset, n3, n4, rectangle.width, rectangle.height);
                if (color != null) {
                    this.background.fillRect(box.x, box.y, box.width, box.height, color);
                }
                Color color2 = CCUtil.getColorPropertyByName(dSParameterForm, "TitleForeground");
                boolean bl2 = CCUtil.getBooleanPropertyByName(dSParameterForm, "TitleUnderline");
                FontInfo fontInfo = this.checkOutputStream.getFontInfo(dSParameterForm);
                String string = fontInfo.getFontName();
                boolean bl3 = this.createChildren(string);
                float f = this.drawFileLink(fontInfo.getFontSize());
                int n5 = this.drawExpRectShadow(dSParameterForm, string);
                PDFFont pDFFont = new PDFFont(string, n5, f);
                FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
                int n6 = fontMetrics.getAscent();
                ExportTextStyle exportTextStyle = new ExportTextStyle(color2, pDFFont, bl3);
                exportTextStyle.setUnderline(bl2, 1, color2);
                exportTextStyle.setAscent(n6);
                String string2 = CCUtil.getStringPropertyByName(dSParameterForm, "TitleText");
                float f2 = ExportToPDF.convertUnitToPoint(n3 + nArray[0] + offset.dx) + (float)this._toolkit;
                float f3 = ExportToPDF.convertUnitToPoint(n4 + nArray[1] + offset.dy) + (float)this._type;
                ExportText exportText = new ExportText(string2, f2, f3, exportTextStyle);
                this.drawString(exportText);
            }
        }
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void NEWBORDERCOLOR(DSTableRow dSTableRow, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commu(dSTableRow, n, n2);
    }

    private void NEWBORDERWIDTH(DSTextBox dSTextBox, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commu(dSTextBox, n, n2);
    }

    private void PHONE(DSTableCell dSTableCell, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commu(dSTableCell, n, n2);
    }

    private void SEDU(DSTableObject dSTableObject, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle = this.addElement(dSTableObject, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        this.drawRect(exportRectangle);
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSTableObject.getX(), this.getY(dSTableObject, n2)));
        int n3 = dSTableObject.getStartYPos();
        DrawingTable drawingTable = DrawingTable.getInstance(dSTableObject, this.checkOutputStream, (byte)0);
        this.clear = new Hashtable();
        this.clearCacheRender = new Hashtable();
        this._bdrwidth = new Vector();
        this._bgcolor = new Vector();
        while (drawingTable.hasMoreChild()) {
            Row row = drawingTable.nextChild();
            Box box = this.getLocation((Offset)this._bdrstyle.peek(), row.getX(), row.getY(), row.getWidth(), row.getHeight());
            ExportRectangle exportRectangle2 = this._pdf(row, box);
            ExportRectangle exportRectangle3 = new ExportRectangle(exportRectangle2);
            exportRectangle3.setTopBorder(null);
            exportRectangle3.setBottomBorder(null);
            this._bdrwidth.add(exportRectangle3);
            ExportRectangle exportRectangle4 = new ExportRectangle(exportRectangle2);
            exportRectangle4.setLeftBorder(null);
            exportRectangle4.setRightBorder(null);
            this._bgcolor.add(exportRectangle4);
            this.drawRect(exportRectangle2);
            Offset offset = new Offset((Offset)this._bdrstyle.peek(), row.getX(), row.getY());
            while (row.hasMoreChild()) {
                RectCell rectCell = row.nextChild();
                if (rectCell.isMerged()) {
                    this.clearCacheRender.put(rectCell, offset);
                    continue;
                }
                this._height(rectCell, offset, n, n3);
            }
        }
        this._y();
        this._x(n, n3);
        this._width(n, n3);
        this.add();
        this._bdrstyle.pop();
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void TW(DSTabularCell dSTabularCell, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commu(dSTabularCell, n, n2);
    }

    private void WHITE(DSTabular dSTabular, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commu(dSTabular, n, n2);
    }

    private ExportRectangle _bdcolor(DSSection dSSection, int n, int n2) {
        int n3 = dSSection.getX() + n;
        int n4 = this.getY(dSSection, n2);
        int n5 = dSSection.getWidth();
        int n6 = dSSection.getHeight();
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.getLocation(offset, n3, n4, n5, n6);
        return this.addPropsChangedBy(dSSection, box);
    }

    private void _bdrstyle(DSSection dSSection, ExportRectangle exportRectangle, int n) throws IOException, DocumentException, JRStopEngineException {
        boolean bl;
        if (this.borderJoint.hasDrill()) {
            this.convertInchToPixel(dSSection, this.BLACK.substring(0, this.BLACK.length() - 4));
        }
        if ((bl = CCUtil.getBooleanPropertyByName(dSSection, "ShowBottomLine")) && null == exportRectangle.bottomBorderStyle) {
            if (this.addPropsChangedBy != -1.0f) {
                exportRectangle.location.width = this.addPropsChangedBy;
            }
            exportRectangle.setBottomBorder(new ExportLineStyle(1.0f, 1, Color.BLACK));
        }
        Offset offset = (Offset)this._bdrstyle.peek();
        int n2 = (int)Unit.convertPixelToUnit(exportRectangle.location.y - (float)this._type, 72) - offset.dy;
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        int n3 = -1;
        if (this.addElement != -1) {
            n3 = this.addElement;
            this.addElement = -1;
        }
        ++n;
        int n4 = dSSection.getStartYPos();
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSSection.getX(), n2));
        Vector vector = dSSection.getChildren();
        if (vector != null) {
            int n5 = vector.size();
            while (--n5 >= 0) {
                JRObjectResult jRObjectResult = this.convertTwoRes((JRObjectResult)vector.get(n5));
                this.FILL_COLOR(jRObjectResult, n, n4);
            }
        }
        if (n3 != -1) {
            this.addElement = n3;
        }
        this._bdrstyle.pop();
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void _bdrwidth(DSBody dSBody, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this.checkOutputStream.handleContainerBegin(dSBody);
        this._commu(dSBody, n, n2);
        this.checkOutputStream.handleContainerEnd(dSBody);
    }

    private void _bgcolor(DSParagraph dSParagraph, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._commuList(dSParagraph, n, n2);
    }

    private void _commu(DSContainer dSContainer, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ExportRectangle exportRectangle = this.addElement(dSContainer, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        this.drawRect(exportRectangle);
        this._commuList(dSContainer, n, n2);
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void _commuList(DSContainer dSContainer, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSContainer.getX(), this.getY(dSContainer, n2)));
        int n3 = dSContainer.getStartYPos();
        List list = ExportUtil.getContainerChildren(dSContainer);
        if (list != null) {
            int n4 = list.size();
            while (--n4 >= 0) {
                JRObjectResult jRObjectResult = this.convertTwoRes((JRObjectResult)list.get(n4));
                this.FILL_COLOR(jRObjectResult, n, n3);
            }
        }
        this._bdrstyle.pop();
    }

    private void _height(RectCell rectCell, Offset offset, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        Box box = this.getLocation(offset, rectCell.getX(), rectCell.getY(), rectCell.getWidth(), rectCell.getHeight());
        ExportRectangle exportRectangle = this._pdf(rectCell, box);
        this._bdrwidth.add(exportRectangle);
        this.drawRect(exportRectangle);
        Offset offset2 = new Offset(offset, rectCell.getX(), rectCell.getY());
        Box box2 = this.getLocation(offset2, 0, 0, rectCell.getWidth(), rectCell.getHeight());
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box2.x, box2.y, box2.width, box2.height);
        }
        while (rectCell.hasMoreChild()) {
            ContentCell contentCell = rectCell.nextChild();
            Offset offset3 = new Offset(offset2, contentCell.getX(), contentCell.getY());
            if (contentCell.isExpand()) {
                this.clear.put(contentCell, offset3);
                continue;
            }
            this._toolkit(contentCell, offset3, n, n2);
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private ExportRectangle _pdf(ContainerInfo containerInfo, Box box) {
        Color color = containerInfo.getBackground();
        ExportRectangle exportRectangle = new ExportRectangle(box, color);
        ExportLineStyle exportLineStyle = null;
        if (containerInfo.hasTopBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getTopBorderWidth()), this.addSuffix(containerInfo.getTopBorderStyle()), containerInfo.getTopBorderColor());
            exportRectangle.setTopBorder(exportLineStyle);
        }
        if (containerInfo.hasBottomBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getBottomBorderWidth()), this.addSuffix(containerInfo.getBottomBorderStyle()), containerInfo.getBottomBorderColor());
            exportRectangle.setBottomBorder(exportLineStyle);
        }
        if (containerInfo.hasLeftBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getLeftBorderWidth()), this.addSuffix(containerInfo.getLeftBorderStyle()), containerInfo.getLeftBorderColor());
            exportRectangle.setLeftBorder(exportLineStyle);
        }
        if (containerInfo.hasRightBorder()) {
            exportLineStyle = new ExportLineStyle(ExportToPDF.convertUnitToPoint(containerInfo.getRightBorderWidth()), this.addSuffix(containerInfo.getRightBorderStyle()), containerInfo.getRightBorderColor());
            exportRectangle.setRightBorder(exportLineStyle);
        }
        boolean bl = containerInfo.hasShadow();
        Color color2 = containerInfo.getShadowColor();
        exportRectangle.setShadow(bl, bl, bl, bl, color2, shadow);
        if (containerInfo instanceof Row) {
            DSTableRow dSTableRow = ((Row)containerInfo).getDSRow();
            FillPatternProperties fillPatternProperties = FillPatternAdapter.ConvertProperties(dSTableRow);
            exportRectangle.setFillPatternProperties(fillPatternProperties);
        }
        return exportRectangle;
    }

    private void _toolkit(ContentCell contentCell, Offset offset, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        JRObjectResult jRObjectResult = contentCell.getSimpleObject();
        this._bdrstyle.push(new Offset(offset, contentCell.getContentX(), contentCell.getContentY()));
        Box box = this.getLocation(offset, 0, 0, contentCell.getWidth(), contentCell.getHeight());
        if (box.width > 0.0f && box.height > 0.0f) {
            if (this.borderJoint.getClippingArea()) {
                this.background.saveState();
                this.background.clip(box.x, box.y, box.width, box.height);
            }
            if (jRObjectResult instanceof DSField) {
                DSField dSField = (DSField)jRObjectResult;
                this._type(dSField, box, n, n2);
            } else if (jRObjectResult instanceof DSParagraph) {
                List list = ExportUtil.getContainerChildren((DSParagraph)jRObjectResult);
                if (list != null) {
                    int n3 = list.size();
                    while (--n3 >= 0) {
                        JRObjectResult jRObjectResult2 = this.convertTwoRes((JRObjectResult)list.get(n3));
                        this.FILL_COLOR(jRObjectResult2, n, n2);
                    }
                }
            } else {
                JRObjectResult jRObjectResult3 = this.convertTwoRes(jRObjectResult);
                this.FILL_COLOR(jRObjectResult3, n, n2);
            }
            if (this.borderJoint.getClippingArea()) {
                this.background.restoreState();
            }
        }
        this._bdrstyle.pop();
    }

    private void _type(DSField dSField, Box box, int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        Render render = this.checkOutputStream.getRender(dSField);
        if (render instanceof RenderHidden) {
            render = null;
            return;
        }
        int n3 = dSField.getRenderType();
        boolean bl = true;
        if (!(n3 != 4 && n3 != 5 && n3 != 6 && n3 != 7 && n3 != 8 && n3 != 9 && n3 != 10 && n3 != 11 || (bl = CCUtil.getBooleanPropertyByName(dSField, "ExportToPDF")))) {
            return;
        }
        ExportRectFromV7 exportRectFromV7 = this.black(dSField);
        Object[] objectArray = new Object[]{exportRectFromV7, box};
        this._bdrwidth.add(objectArray);
        this.fillBackground(exportRectFromV7.backgroundColor, exportRectFromV7.hasShadow, box);
        this.fillFieldPattern(dSField, exportRectFromV7, box);
        Box box2 = this.getLocation((Offset)this._bdrstyle.peek(), 0, 0, dSField.getWidth(), dSField.getHeight());
        this.borderColor(render, n, box2);
        render.clearCacheRender();
        render = null;
        if (exportRectFromV7.enableHyperlinkOnPDF) {
            this.corner(dSField, box);
        }
    }

    private void _width(int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        if (this.clear.size() <= 0) {
            return;
        }
        Enumeration enumeration = this.clear.keys();
        while (enumeration.hasMoreElements()) {
            ContentCell contentCell = (ContentCell)enumeration.nextElement();
            Offset offset = (Offset)this.clear.get(contentCell);
            this._toolkit(contentCell, offset, n, n2);
        }
    }

    private void _x(int n, int n2) throws JRStopEngineException, IOException, DocumentException {
        if (this.clearCacheRender.size() <= 0) {
            return;
        }
        Enumeration enumeration = this.clearCacheRender.keys();
        while (enumeration.hasMoreElements()) {
            RectCell rectCell = (RectCell)enumeration.nextElement();
            Offset offset = (Offset)this.clearCacheRender.get(rectCell);
            this._height(rectCell, offset, n, n2);
        }
    }

    private void _y() {
        for (int i = 0; i < this._bgcolor.size(); ++i) {
            Object e = this._bgcolor.get(i);
            if (!(e instanceof ExportRectangle)) continue;
            this.drawRoundRect((ExportRectangle)e);
        }
    }

    private void add() {
        for (int i = 0; i < this._bdrwidth.size(); ++i) {
            Object e = this._bdrwidth.get(i);
            if (e instanceof ExportRectangle) {
                this.drawRoundRect((ExportRectangle)e);
                continue;
            }
            if (!(e instanceof Object[])) continue;
            Object[] objectArray = (Object[])e;
            this.drawFieldBorder((ExportRectFromV7)objectArray[0], (Box)objectArray[1]);
        }
    }

    private ExportRectangle addElement(JRVisiableResult jRVisiableResult, int n, int n2) {
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(jRVisiableResult, offset, n, n2);
        return this.addPropsChangedBy(jRVisiableResult, box);
    }

    private ExportRectangle addPropsChangedBy(JRVisiableResult jRVisiableResult, Box box) {
        FillPatternProperties fillPatternProperties;
        Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
        ExportRectangle exportRectangle = new ExportRectangle(box, color);
        if (jRVisiableResult.getObjectType() == 45) {
            int n = CCUtil.getIntPropertyByName(jRVisiableResult, "BorderJoint");
            float f = ExportToPDF.convertUnitToPoint(CCUtil.getFloatPropertyByName(jRVisiableResult, "RoundJointRadius"));
            exportRectangle.setBorderJoint(n);
            exportRectangle.setRoundJointRadius(f);
        }
        int[] nArray = new int[4];
        float[] fArray2 = new float[4];
        Color[] colorArray = new Color[4];
        int n = 4;
        while (--n >= 0) {
            nArray[n] = this.addSuffix(CCUtil.getIntPropertyByName(jRVisiableResult, BORDERLINENAME[n]));
            fArray2[n] = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(jRVisiableResult, NEWBORDERWIDTH[n]));
            colorArray[n] = CCUtil.getColorPropertyByName(jRVisiableResult, NEWBORDERCOLOR[n]);
        }
        ExportLineStyle exportLineStyle = null;
        if (nArray[1] != 0 && colorArray[1] != null && fArray2[1] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[1], nArray[1], colorArray[1]);
            exportRectangle.setLeftBorder(exportLineStyle);
        }
        if (nArray[0] != 0 && colorArray[0] != null && fArray2[0] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[0], nArray[0], colorArray[0]);
            exportRectangle.setTopBorder(exportLineStyle);
        }
        if (nArray[3] != 0 && colorArray[3] != null && fArray2[3] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[3], nArray[3], colorArray[3]);
            exportRectangle.setRightBorder(exportLineStyle);
        }
        if (nArray[2] != 0 && colorArray[2] != null && fArray2[2] > 0.0f) {
            exportLineStyle = new ExportLineStyle(fArray2[2], nArray[2], colorArray[2]);
            exportRectangle.setBottomBorder(exportLineStyle);
        }
        boolean bl = CCUtil.getBooleanPropertyByName(jRVisiableResult, "Shadow");
        Color color2 = CCUtil.getColorPropertyByName(jRVisiableResult, "ShadowColor");
        exportRectangle.setShadow(bl, bl, bl, bl, color2, shadow);
        if ((jRVisiableResult instanceof DSSection || jRVisiableResult instanceof DSTableRow || jRVisiableResult instanceof DSBody) && (fillPatternProperties = FillPatternAdapter.ConvertProperties(jRVisiableResult)).getFillPatternType() != FillPatternProperties.FILL_COLOR) {
            exportRectangle.setFillPatternProperties(fillPatternProperties);
        }
        return exportRectangle;
    }

    private int addSuffix(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        if (JRLog.isTrace(3)) {
            JRLog.trace(3, 3401002, new Integer(n));
        }
        return 0;
    }

    private void append(DSSubReport dSSubReport, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        boolean bl = !this.checkOutputStream.isExport(dSSubReport);
        int n3 = dSSubReport.getStartYPos();
        if (bl) {
            return;
        }
        this.checkOutputStream.handleContainerBegin(dSSubReport);
        ExportRectangle exportRectangle = this.addElement(dSSubReport, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            if (exportRectangle.borderJoint == BorderProperties.BORDERJOINT_ROUND) {
                this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height, exportRectangle.roundJointRadius);
            } else {
                this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
            }
        }
        this.drawRect(exportRectangle);
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSSubReport.getX(), this.getY(dSSubReport, n2)));
        List list = ExportUtil.getContainerChildren(dSSubReport);
        this.FB(list, n, n3);
        this._bdrstyle.pop();
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
        this.checkOutputStream.handleContainerEnd(dSSubReport);
    }

    Box writeTable(DSTable dSTable, int n, int n2, Offset offset) {
        Box box = this.drawVShadow(dSTable, offset, n, n2);
        Color color = CCUtil.getColorPropertyByName(dSTable, "Background");
        if (color != null) {
            this.background.fillRect(box.x, box.y, box.width, box.height, color);
        }
        if (CCUtil.getBooleanPropertyByName(dSTable, "ShowBorder")) {
            this.HorizontalAlignment.addElement(new GeoBdrInfo(box.x, box.y, box.width, box.height, 23, Color.black, 1.0f, 1, -1, -1, -1));
        }
        return box;
    }

    void writeColumns(Vector vector, int n, Box box) {
        float f;
        float f2;
        int n2;
        DSColumn dSColumn = null;
        Color color = null;
        Offset offset = (Offset)this._bdrstyle.elementAt(0);
        float f3 = box.y;
        float f4 = box.height;
        for (n2 = 0; n2 < vector.size(); ++n2) {
            dSColumn = (DSColumn)vector.elementAt(n2);
            if (!this.checkOutputStream.isExport(dSColumn)) continue;
            f2 = ExportToPDF.convertUnitToPoint(dSColumn.getX() + offset.dx + n) + box.x;
            f = ExportToPDF.convertUnitToPoint(dSColumn.getWidth());
            color = CCUtil.getColorPropertyByName(dSColumn, "Background");
            if (color == null) continue;
            this.background.fillRect(f2, f3, f, f4, color);
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            dSColumn = (DSColumn)vector.elementAt(n2);
            if (!this.checkOutputStream.isExport(dSColumn)) continue;
            f2 = ExportToPDF.convertUnitToPoint(dSColumn.getX() + offset.dx + n) + box.x;
            f = ExportToPDF.convertUnitToPoint(dSColumn.getWidth());
            if (!CCUtil.getBooleanPropertyByName(dSColumn, "ShowBorder")) continue;
            this.background.drawLine(f2 + f, f3, f2 + f, f3 + f4, 1.0f, 1, Color.black);
        }
    }

    private void arca(DSMultiValueContainer dSMultiValueContainer, int n, int n2) throws IOException, DocumentException {
        ExportRectangle exportRectangle = this.addElement(dSMultiValueContainer, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(exportRectangle.location.x, exportRectangle.location.y, exportRectangle.location.width, exportRectangle.location.height);
        }
        this.drawRect(exportRectangle);
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSMultiValueContainer.getX(), this.getY(dSMultiValueContainer, n2)));
        Render render = dSMultiValueContainer.getRender();
        this.borderColor(render, n, null);
        this._bdrstyle.pop();
        this.drawRoundRect(exportRectangle);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void ascent(DSMap dSMap, int n, int n2) throws JRStopEngineException {
        Object object;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSMap, offset, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        JReportMap jReportMap = new JReportMap();
        if (!this.borderColor) {
            object = jReportMap.getMapImage(dSMap);
            if (object != null) {
                this.writeImage(dSMap, (Image)object, box.x, box.y, box.width, box.height);
            }
        } else {
            jReportMap.setProperty(dSMap);
            jReportMap.setBounds(dSMap.getBounds());
            jReportMap.createChildren(dSMap);
            object = this.background.getGraphics((float)this._width > box.width ? (float)this._width : box.width, (float)this._x > box.height ? (float)this._x : box.height);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            ((Graphics2D)object).setTransform(affineTransform);
            jReportMap.paint((Graphics)object);
            ((Graphics)object).dispose();
        }
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSMap.getX(), dSMap.getY()));
        object = ExportUtil.getContainerChildren(dSMap);
        if (object != null) {
            int n3 = object.size();
            while (--n3 >= 0) {
                JRObjectResult jRObjectResult = this.convertTwoRes((JRObjectResult)object.get(n3));
                if (!(jRObjectResult instanceof DSArea)) continue;
                List list = ExportUtil.getContainerChildren((DSArea)jRObjectResult);
                int n4 = list.size();
                while (--n4 >= 0) {
                    JRObjectResult jRObjectResult2 = this.convertTwoRes((JRObjectResult)list.get(n4));
                    if (!(jRObjectResult2 instanceof DSField)) continue;
                    DSField dSField = (DSField)jRObjectResult2;
                    Box box2 = this.drawVShadow(dSField, (Offset)this._bdrstyle.peek(), n, n2);
                    this.corner(dSField, box2);
                }
            }
        }
        this._bdrstyle.pop();
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void background(DSGMap dSGMap, int n, int n2) {
        JReportGoogleMap jReportGoogleMap;
        Image image;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSGMap, offset, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        if ((image = (jReportGoogleMap = new JReportGoogleMap()).getMapImage(dSGMap)) != null) {
            this.writeImage(dSGMap, image, box.x, box.y, box.width, box.height);
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private void backgroundColor(DSGeoMap dSGeoMap, int n, int n2) throws JRStopEngineException {
        JReportGoMap jReportGoMap;
        Image image;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSGeoMap, offset, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        if ((image = (jReportGoMap = new JReportGoMap()).getMapImage(dSGeoMap)) != null) {
            this.writeImage(dSGeoMap, image, box.x, box.y, box.width, box.height);
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    void writePicture(DSPicture dSPicture, int n, int n2) throws JRStopEngineException {
        ImageInfo imageInfo;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSPicture, offset, n, n2);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        if ((imageInfo = this.borderStyle.getImage(this.borderWidth, true, dSPicture)) != null) {
            Image image = imageInfo.getImage();
            int n3 = imageInfo.getWidth();
            int n4 = imageInfo.getHeight();
            int n5 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
            int n6 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
            n3 = Unit.convertUnitToPixel(n3, 72);
            n4 = Unit.convertUnitToPixel(n4, 72);
            if (image != null) {
                this.writeImage(dSPicture, image, box.x + (float)n5, box.y + (float)n6, n3, n4);
            }
        }
        this.corner(dSPicture, box);
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    void writeImage(JRVisiableResult jRVisiableResult, Image image, float f, float f2, float f3, float f4) {
        String string = null;
        ExportUtil.waitImage(image);
        if (jRVisiableResult instanceof DSPicture) {
            string = this.bgRect(jRVisiableResult, image);
        }
        this.background.drawImage(image, f, f2, f3, f4, string);
    }

    private String bgRect(JRVisiableResult jRVisiableResult, Image image) {
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        Object v = this.bottomBorderStyle.get(dSTemplatible);
        if (v != null) {
            return v.toString();
        }
        String string = this.background.getImgID(image);
        if (!CCUtil.isChangeByFormularProperty(jRVisiableResult, "PictureName")) {
            this.bottomBorderStyle.put(dSTemplatible, string);
        }
        return string;
    }

    void writeParagraphText(DSParagraphText dSParagraphText, int n, int n2) throws IOException, DocumentException {
        String string = dSParagraphText.getText();
        if (string != null) {
            Offset offset = (Offset)this._bdrstyle.peek();
            Box box = this.drawVShadow(dSParagraphText, offset, n, n2);
            Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
            if (color != null) {
                this.background.fillRect(box.x, box.y, box.width, box.height, color);
            }
            if (string.trim().length() > 0) {
                int n3;
                Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
                FontInfo fontInfo = this.checkOutputStream.getFontInfo(dSParagraphText);
                String string2 = fontInfo.getFontName();
                boolean bl = this.createChildren(string2);
                boolean bl2 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript") != 0;
                float f = fontInfo.getFontSize();
                if (bl2) {
                    f = f * 2.0f / 3.0f;
                }
                f = this.drawFileLink(f);
                int n4 = this.drawArc(dSParagraphText, string2);
                PDFFont pDFFont = new PDFFont(string2, n4, f);
                boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
                int n5 = 0;
                Color color3 = null;
                if (bl3) {
                    n5 = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
                    if (n5 == 0) {
                        n5 = 1;
                    } else if (n5 == 1) {
                        n5 = 5;
                    }
                    color3 = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
                }
                boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
                int n6 = 0;
                Color color4 = null;
                if (bl4) {
                    n6 = this.createFile(dSParagraphText, CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle"));
                    color4 = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
                }
                ExportTextStyle exportTextStyle = new ExportTextStyle(color2, pDFFont, bl);
                exportTextStyle.setUnderline(bl4, n6, color4);
                exportTextStyle.setStrikethrough(bl3, n5, color3);
                int n7 = CCUtil.getIntPropertyByName((DSParagraph)dSParagraphText.getParent(), PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
                if (n7 == 3 && (n3 = dSParagraphText.getWords().size()) > 0) {
                    for (int i = 0; i < n3; ++i) {
                        string = this.createImage((String)dSParagraphText.getWords().elementAt(i));
                        float f2 = box.x + ExportToPDF.convertUnitToPoint(dSParagraphText.getWordsPosition()[i] + dSParagraphText.getTextX());
                        float f3 = box.y + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextY());
                        ExportText exportText = new ExportText(string, f2, f3, exportTextStyle);
                        this.drawString(exportText);
                    }
                    return;
                }
                string = this.createImage(string);
                float f4 = box.x + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextX());
                float f5 = box.y + ExportToPDF.convertUnitToPoint(dSParagraphText.getTextY());
                ExportText exportText = new ExportText(string, f4, f5, exportTextStyle);
                this.drawString(exportText);
            }
        }
    }

    void writeField(DSField dSField, int n, int n2, String string) throws IOException, DocumentException, JRStopEngineException {
        Render render = this.checkOutputStream.getRender(dSField);
        if (render instanceof RenderHidden) {
            render = null;
            return;
        }
        boolean bl = this.checkOutputStream.isExport(dSField);
        if (!bl) {
            return;
        }
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSField, offset, n, n2);
        if (box.width <= 0.0f || box.height <= 0.0f) {
            return;
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        ExportRectFromV7 exportRectFromV7 = this.black(dSField);
        this.fillBackground(exportRectFromV7.backgroundColor, exportRectFromV7.hasShadow, box);
        this.fillFieldPattern(dSField, exportRectFromV7, box);
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSField.getX(), this.getY(dSField, n2)));
        this.borderColor(render, n, box);
        render.clearCacheRender();
        render = null;
        this._bdrstyle.pop();
        this.drawFieldBorder(exportRectFromV7, box);
        if (exportRectFromV7.enableHyperlinkOnPDF) {
            this.corner(dSField, box);
        }
        if (string != null) {
            if (string.lastIndexOf("\\") != -1) {
                string = string.substring(string.lastIndexOf("\\") + 1, string.length());
            }
            this.background.drawFileLink(string, box.x, box.y, box.width, box.height);
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    void fillBackground(Color color, boolean bl, Box box) {
        if (color != null) {
            if (bl) {
                this.background.fillRect(box.x, box.y, box.width - (float)shadow, box.height - (float)shadow, color);
            } else {
                this.background.fillRect(box.x, box.y, box.width, box.height, color);
            }
        }
    }

    void fillFieldPattern(DSField dSField, ExportRectFromV7 exportRectFromV7, Box box) {
        int[] nArray = exportRectFromV7.borderStyle;
        float f = exportRectFromV7.borderWidth;
        int n = exportRectFromV7.patternStyle;
        if (n != 0) {
            float f2;
            float f3 = box.x;
            float f4 = box.y;
            float f5 = box.width;
            float f6 = box.height;
            float f7 = f2 = f;
            float f8 = f2;
            float f9 = f2;
            if (exportRectFromV7.borderCount > 0) {
                if (nArray[0] == 5) {
                    f9 = f * 3.0f;
                }
                if (nArray[1] == 5) {
                    f8 = f * 3.0f;
                }
                if (nArray[2] == 5) {
                    f7 = f * 3.0f;
                }
                if (nArray[3] == 5) {
                    f2 = f * 3.0f;
                }
                f3 += f8;
                f4 += f9;
                f5 -= f8 + f2;
                f6 -= f9 + f7;
            }
            if (exportRectFromV7.hasShadow) {
                f5 -= (float)shadow;
                f6 -= (float)shadow;
            }
            Color color = CCUtil.getColorPropertyByName(dSField, "PatternColor");
            Box box2 = new Box(f3, f4, f5, f6);
            this.createSignature(box2, color, n);
        }
    }

    void drawFieldBorder(ExportRectFromV7 exportRectFromV7, Box box) {
        boolean bl = exportRectFromV7.hasShadow;
        this.drawHShadow(box, null, exportRectFromV7.borderColor, exportRectFromV7.borderWidth, exportRectFromV7.borderStyle, bl, bl, bl, bl, exportRectFromV7.shadowColor, shadow);
    }

    /*
     * WARNING - void declaration
     */
    private ExportRectFromV7 black(DSField dSField) {
        void var6_10;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.checkFilePathExist.get(dSTemplatible);
        if (v != null) {
            int n;
            ExportRectFromV7 exportRectFromV7 = new ExportRectFromV7((ExportRectFromV7)v);
            Vector vector = exportRectFromV7.getPropsChangedBy();
            if (vector != null && (n = vector.size()) > 0) {
                block9: for (int i = 0; i < n; ++i) {
                    int n2 = (Integer)vector.get(i);
                    switch (n2) {
                        case 1: {
                            int[] nArray = new int[4];
                            int n3 = 0;
                            int n4 = 4;
                            while (--n4 >= 0) {
                                nArray[n4] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[n4]);
                                n3 += nArray[n4];
                            }
                            exportRectFromV7.setBorderCount(n3);
                            exportRectFromV7.setBorderStyle(nArray);
                            continue block9;
                        }
                        case 2: {
                            int n4 = CCUtil.getBooleanPropertyByName(dSField, "Shadow");
                            exportRectFromV7.setHasShadow(n4 != 0);
                            continue block9;
                        }
                        case 3: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "ShadowColor");
                            exportRectFromV7.setShadowColor(color);
                            continue block9;
                        }
                        case 4: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "BorderColor");
                            exportRectFromV7.setBorderColor(color);
                            continue block9;
                        }
                        case 5: {
                            float f = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "BorderWidth"));
                            exportRectFromV7.setBorderWidth(f);
                            continue block9;
                        }
                        case 6: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "Background");
                            exportRectFromV7.setBackground(color);
                            continue block9;
                        }
                        case 7: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "EnableHyperlinkOnPDF");
                            exportRectFromV7.setEnablelink(bl);
                        }
                    }
                }
            }
            return exportRectFromV7;
        }
        int[] nArray = new int[4];
        int n = 0;
        int bl = 4;
        while (--var6_10 >= 0) {
            nArray[var6_10] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[var6_10]);
            n += nArray[var6_10];
        }
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Shadow");
        Color color = CCUtil.getColorPropertyByName(dSField, "ShadowColor");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        float f = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "BorderWidth"));
        Color color3 = CCUtil.getColorPropertyByName(dSField, "Background");
        int n5 = CCUtil.getIntPropertyByName(dSField, "PatternStyle");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSField, "EnableHyperlinkOnPDF");
        ExportRectFromV7 exportRectFromV7 = new ExportRectFromV7(color3, f, nArray, color2, n, n5);
        exportRectFromV7.setShadow(bl2, color);
        exportRectFromV7.setEnablelink(bl3);
        this.booleanValue(dSField, exportRectFromV7);
        this.checkFilePathExist.put(dSTemplatible, exportRectFromV7);
        return exportRectFromV7;
    }

    private void booleanValue(DSField dSField, ExportRectFromV7 exportRectFromV7) {
        if (CCUtil.isChangeByFormularProperty(dSField, "TopLine") || CCUtil.isChangeByFormularProperty(dSField, "LeftLine") || CCUtil.isChangeByFormularProperty(dSField, "BottomLine") || CCUtil.isChangeByFormularProperty(dSField, "RightLine")) {
            exportRectFromV7.addPropsChangedBy(1);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Shadow")) {
            exportRectFromV7.addPropsChangedBy(2);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "ShadowColor")) {
            exportRectFromV7.addPropsChangedBy(3);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "BorderColor")) {
            exportRectFromV7.addPropsChangedBy(4);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "BorderWidth")) {
            exportRectFromV7.addPropsChangedBy(5);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Background")) {
            exportRectFromV7.addPropsChangedBy(6);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "EnableHyperlinkOnPDF")) {
            exportRectFromV7.addPropsChangedBy(7);
        }
    }

    private void borderColor(Render render, int n, Box box) throws IOException, DocumentException {
        if (render instanceof RenderText) {
            this.charAt((RenderText)render, box);
        } else if (render instanceof RenderImage) {
            this.borderStyle(render, n);
        } else if (render instanceof RenderBarCode) {
            this.borderJoint((RenderBarCode)render, n);
        } else {
            this.borderCount(render, n);
        }
    }

    private void borderCount(Render render, int n) {
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawURLLink(render, offset, n);
        box.x = (float)((double)box.x + 0.75);
        box.y = (float)((double)box.y + 0.5);
        box.width = (float)((double)box.width - 0.75);
        box.height = (float)((double)box.height - 0.5);
        if (!this.borderColor) {
            ImageInfo imageInfo = this.borderStyle.getImage(this.borderWidth, true, render);
            if (imageInfo != null) {
                Image image = imageInfo.getImage();
                if (image == null) {
                    return;
                }
                if (render instanceof RenderImageButton || render instanceof RenderRank) {
                    int n2 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
                    int n3 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
                    int n4 = Unit.convertTwoRes(imageInfo.getWidth(), this.booleanValue, 72);
                    int n5 = Unit.convertTwoRes(imageInfo.getHeight(), this.booleanValue, 72);
                    this.writeImage(render.getParent(), image, box.x + (float)n2, box.y + (float)n3, Unit.convertUnitToPixel(n4), Unit.convertUnitToPixel(n5));
                } else {
                    this.writeImage(render.getParent(), image, box.x, box.y, box.width, box.height);
                }
            }
        } else {
            Rectangle rectangle = new Rectangle(Unit.convertUnitToPixel(render.getWidth()), Unit.convertUnitToPixel(render.getHeight()));
            render.setPaintCalledByField(false);
            Graphics2D graphics2D = this.background.getGraphics(this._width > rectangle.width ? (float)this._width : (float)rectangle.width, this._x > rectangle.height ? (float)this._x : (float)rectangle.height);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            graphics2D.setTransform(affineTransform);
            render.paint(graphics2D);
            graphics2D.dispose();
        }
    }

    private void borderJoint(RenderBarCode renderBarCode, int n) {
        this.borderCount(renderBarCode, n);
    }

    private void borderStyle(Render render, int n) {
        ImageInfo imageInfo;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawURLLink(render, offset, n);
        if (this.borderJoint.getClippingArea()) {
            this.background.saveState();
            this.background.clip(box.x, box.y, box.width, box.height);
        }
        if ((imageInfo = this.borderStyle.getImage(this.borderWidth, true, render)) != null) {
            Image image = imageInfo.getImage();
            int n2 = Unit.convertUnitToPixel(imageInfo.getX(), 72);
            int n3 = Unit.convertUnitToPixel(imageInfo.getY(), 72);
            int n4 = Unit.convertUnitToPixel(imageInfo.getWidth(), 72);
            int n5 = Unit.convertUnitToPixel(imageInfo.getHeight(), 72);
            if (image != null) {
                this.writeImage(render.getParent(), image, box.x + (float)n2, box.y + (float)n3, n4, n5);
            }
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private Dimension borderWidth(Image image) {
        int n = Unit.convertTwoRes(image.getWidth(null), Unit.getResolution(), 72);
        int n2 = Unit.convertTwoRes(image.getHeight(null), Unit.getResolution(), 72);
        return new Dimension(n, n2);
    }

    private Image bottomBorderStyle(Render render) {
        Image image = null;
        if (render instanceof RenderImage || render instanceof RenderImageButton || render instanceof RenderRank) {
            ImageInfo imageInfo = this.borderStyle.getImage(this.borderWidth, true, render);
            image = imageInfo.getImage();
        } else {
            ImageResource imageResource = render.getImageResource();
            image = imageResource == null ? null : imageResource.getImage();
        }
        ExportUtil.waitImage(image);
        return image;
    }

    private void charAt(RenderText renderText, Box box) throws IOException, DocumentException {
        Offset offset = (Offset)this._bdrstyle.peek();
        DSField dSField = renderText.getParent();
        ExportTextStyle exportTextStyle = this.checkFilePathExist(dSField);
        Vector vector = renderText.getVLines();
        int[][] nArray = renderText.getEveryLinePos();
        if (vector != null && nArray != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = this.createImage((String)vector.get(i));
                float f = ExportToPDF.convertUnitToPoint(nArray[i][0] + offset.dx) + (float)this._toolkit;
                float f2 = ExportToPDF.convertUnitToPoint(nArray[i][1] + offset.dy) + (float)this._type;
                ExportText exportText = new ExportText(string, f, f2, exportTextStyle);
                this.drawToc(exportText, box);
            }
        }
    }

    private ExportTextStyle checkFilePathExist(DSField dSField) {
        int n;
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.charAt.get(dSTemplatible);
        if (v != null) {
            int n2;
            ExportTextStyle exportTextStyle = new ExportTextStyle((ExportTextStyle)v);
            Vector vector = exportTextStyle.getPropsChangedBy();
            if (vector != null && (n2 = vector.size()) > 0) {
                block6: for (int i = 0; i < n2; ++i) {
                    int n3 = (Integer)vector.get(i);
                    switch (n3) {
                        case 3: {
                            Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
                            exportTextStyle.setUnderlineColor(color);
                            exportTextStyle.setStrikethroughColor(color);
                            exportTextStyle.setForeColor(color);
                            exportTextStyle.setFont(color, exportTextStyle.font, exportTextStyle.embedded);
                            continue block6;
                        }
                        case 4: {
                            FontInfo fontInfo = this.checkOutputStream.getFontInfo(dSField);
                            String string = fontInfo.getFontName();
                            float f = this.drawFileLink(fontInfo.getFontSize());
                            boolean bl = this.createChildren(string);
                            int n4 = this.drawArc(dSField, string);
                            PDFFont pDFFont = new PDFFont(string, n4, f);
                            FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
                            int n5 = fontMetrics.getAscent();
                            exportTextStyle.setFont(exportTextStyle.foreground, pDFFont, bl);
                            exportTextStyle.setAscent(n5);
                            continue block6;
                        }
                        case 1: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
                            exportTextStyle.setStrikethrough(bl, 1, exportTextStyle.foreground);
                            continue block6;
                        }
                        case 2: {
                            boolean bl = CCUtil.getBooleanPropertyByName(dSField, "Underline");
                            exportTextStyle.setUnderline(bl, 1, exportTextStyle.foreground);
                        }
                    }
                }
            }
            return exportTextStyle;
        }
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Underline");
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        FontInfo fontInfo = this.checkOutputStream.getFontInfo(dSField);
        String string = fontInfo.getFontName();
        boolean bl3 = this.createChildren(string);
        float f = this.drawFileLink(fontInfo.getFontSize());
        int n6 = this.drawArc(dSField, string);
        PDFFont pDFFont = new PDFFont(string, n6, f);
        FontMetrics fontMetrics = PDFWriter.getFontMetrics(pDFFont.getAwtFont());
        int n7 = fontMetrics.getAscent();
        int n8 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        ExportTextStyle exportTextStyle = new ExportTextStyle(color, pDFFont, bl3);
        exportTextStyle.setUnderline(bl2, 1, color);
        exportTextStyle.setStrikethrough(bl, 1, color);
        exportTextStyle.setAlignment(n8);
        exportTextStyle.setAscent(n7);
        if (n8 == 1 && !pDFFont.isJFont() && ((n = CCUtil.getIntPropertyByName(dSField, "position")) == 2 || dSField instanceof DSCTField)) {
            exportTextStyle.setRightPadding(ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSField, "padding-right")));
        }
        this.checkOutputStream(dSField, exportTextStyle, fontInfo);
        this.charAt.put(dSTemplatible, exportTextStyle);
        return exportTextStyle;
    }

    private void checkOutputStream(DSField dSField, ExportTextStyle exportTextStyle, FontInfo fontInfo) {
        if (CCUtil.isChangeByFormularProperty(dSField, "Foreground")) {
            exportTextStyle.addPropsChangedBy(3);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "StrikeOut")) {
            exportTextStyle.addPropsChangedBy(1);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Underline")) {
            exportTextStyle.addPropsChangedBy(2);
        }
        if (CCUtil.isChangeByFormularProperty(dSField, "Italic") || CCUtil.isChangeByFormularProperty(dSField, "Bold") || !fontInfo.isCanBeCache()) {
            exportTextStyle.addPropsChangedBy(4);
        }
    }

    void writeChart(DSChartPlatform dSChartPlatform, int n) throws JRStopEngineException {
        Object object;
        Object object2;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSChartPlatform, offset, 0, n);
        Rectangle rectangle = dSChartPlatform.getBounds();
        if (!this.borderColor) {
            object2 = new BufferedImage(rectangle.width, rectangle.height, 1);
            object = ((Image)object2).getGraphics();
            ((Graphics)object).setColor(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, rectangle.width, rectangle.height);
            dSChartPlatform.paint((Graphics)object);
            this.writeImage(dSChartPlatform, (Image)object2, box.x, box.y, box.width, box.height);
        } else {
            object2 = this.background.getGraphics(this._width, this._x);
            object = new AffineTransform();
            ((AffineTransform)object).scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
            ((AffineTransform)object).translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
            ((Graphics2D)object2).setTransform((AffineTransform)object);
            dSChartPlatform.paint((Graphics)object2);
            ((Graphics)object2).dispose();
        }
        if (dSChartPlatform.isHeatMapChart()) {
            this._bdrstyle.push(new Offset(offset, dSChartPlatform.getX(), this.getY(dSChartPlatform, n)));
            object2 = dSChartPlatform.getChildren();
            int n2 = dSChartPlatform.getStartYPos();
            for (int i = 0; i < object2.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)object2.get(i);
                if (!(jRObjectResult instanceof DSChartCoordinatepaper)) continue;
                DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)jRObjectResult;
                this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSChartCoordinatepaper.getX(), this.getY(dSChartCoordinatepaper, n2)));
                Vector vector = dSChartCoordinatepaper.getChildren();
                int n3 = dSChartCoordinatepaper.getStartYPos();
                for (int j = 0; j < vector.size(); ++j) {
                    JRObjectResult jRObjectResult2 = (JRObjectResult)vector.get(j);
                    if (!(jRObjectResult2 instanceof DSChartHeatMapGroupRect)) continue;
                    DSChartHeatMapGroupRect dSChartHeatMapGroupRect = (DSChartHeatMapGroupRect)jRObjectResult2;
                    Box box2 = this.drawVShadow(dSChartHeatMapGroupRect, (Offset)this._bdrstyle.peek(), 0, n3);
                    this.corner(dSChartHeatMapGroupRect, box2);
                    this.checkStop(dSChartHeatMapGroupRect, n3);
                }
                this._bdrstyle.pop();
            }
            this._bdrstyle.pop();
        }
    }

    private void checkStop(DSContainer dSContainer, int n) throws JRStopEngineException {
        this._bdrstyle.push(new Offset((Offset)this._bdrstyle.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        Vector vector = dSContainer.getChildren();
        int n2 = dSContainer.getStartYPos();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSField)) continue;
            Offset offset = (Offset)this._bdrstyle.peek();
            Box box = this.drawVShadow((DSField)jRObjectResult, offset, 0, n2);
            this.corner(jRObjectResult, box);
        }
        this._bdrstyle.pop();
    }

    void writeTextObject(DSTextObj dSTextObj, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        ++n;
        Offset offset = (Offset)this._bdrstyle.peek();
        float f = dSTextObj.getX();
        float f2 = this.getY(dSTextObj, n2);
        float f3 = dSTextObj.getWidth();
        float f4 = dSTextObj.getHeight();
        this._bdrstyle.push(new Offset(offset, (int)f, (int)f2));
        f = ExportToPDF.convertUnitToPoint(f + (float)offset.dx + (float)n) + (float)this._toolkit;
        f2 = ExportToPDF.convertUnitToPoint(f2 + (float)offset.dy) + (float)this._type;
        f3 = ExportToPDF.convertUnitToPoint(f3);
        f4 = ExportToPDF.convertUnitToPoint(f4);
        int n3 = dSTextObj.getStartYPos();
        boolean bl = CCUtil.getBooleanPropertyByName(dSTextObj, "Shadow");
        Color color = CCUtil.getColorPropertyByName(dSTextObj, "Background");
        if (color != null) {
            if (bl) {
                this.background.fillRect(f, f2, f3 - (float)shadow, f4 - (float)shadow, color);
            } else {
                this.background.fillRect(f, f2, f3, f4, color);
            }
        }
        Vector vector = dSTextObj.getChildren();
        int n4 = -1;
        int n5 = n4 = vector.size();
        while (--n5 >= 0) {
            this.FILL_COLOR((JRObjectResult)vector.elementAt(n5), n, n3);
        }
        int[] nArray = new int[4];
        n5 = 0;
        int n6 = 4;
        while (--n6 >= 0) {
            nArray[n6] = CCUtil.getIntPropertyByName(dSTextObj, BORDERLINENAME[n6]);
            n5 += nArray[n6];
        }
        Box box = new Box(f, f2, f3, f4);
        if (n5 > 0) {
            float f5 = ExportToPDF.convertUnitToPoint(CCUtil.getIntPropertyByName(dSTextObj, "BorderWidth"));
            Color color2 = CCUtil.getColorPropertyByName(dSTextObj, "BorderColor");
            if (bl) {
                Color color3 = CCUtil.getColorPropertyByName(dSTextObj, "ShadowColor");
                this.drawHShadow(box, color, color2, f5, nArray, bl, bl, bl, bl, color3, shadow);
            } else {
                this.drawHShadow(box, color, color2, f5, nArray, false, false, false, false, null, shadow);
            }
        } else if (bl) {
            Color color4 = CCUtil.getColorPropertyByName(dSTextObj, "ShadowColor");
            this.drawHShadow(box, color, null, 0.0f, null, bl, bl, bl, bl, color4, shadow);
        } else {
            this.drawHShadow(box, color, null, 0.0f, null, false, false, false, false, null, shadow);
        }
        this._bdrstyle.pop();
    }

    void writeCrosstab(DSCrossTab dSCrossTab, int n, int n2) throws IOException, DocumentException, JRStopEngineException {
        int n3;
        this.dispose(dSCrossTab, n, n2);
        ++n;
        Offset offset = new Offset((Offset)this._bdrstyle.peek(), dSCrossTab.getX(), this.getY(dSCrossTab, n2));
        this._bdrstyle.push(offset);
        boolean bl = CCUtil.getBooleanPropertyByName(dSCrossTab, "Hasborder");
        Color color = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
        int n4 = dSCrossTab.getStartYPos();
        GridBoxes gridBoxes = new GridBoxes();
        Vector vector = dSCrossTab.getGridInfos();
        int n5 = -1;
        int n6 = n5 = vector.size();
        while (--n6 >= 0) {
            Vector vector2 = (Vector)vector.elementAt(n6);
            n3 = vector2.size();
            while (--n3 >= 0) {
                CTGridInfo cTGridInfo = (CTGridInfo)vector2.elementAt(n3);
                if (n6 == 0 && n3 == 0 && cTGridInfo.getChildren().size() == 0) continue;
                float f = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.x + offset.dx);
                float f2 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.y - n4 + offset.dy);
                float f3 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.x + offset.dx + cTGridInfo.bgRect.width) - f;
                float f4 = ExportToPDF.convertUnitToPoint(cTGridInfo.bgRect.y - n4 + offset.dy + cTGridInfo.bgRect.height) - f2;
                if (!bl && cTGridInfo.fillColor == null) continue;
                gridBoxes.add(new GridBox(f + (float)this._toolkit, f2 + (float)this._type, f3, f4, cTGridInfo.fillColor));
            }
        }
        Enumeration enumeration = gridBoxes.hboxes.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            n3 = n5 = vector3.size();
            while (--n3 >= 0) {
                GridBox gridBox = (GridBox)vector3.elementAt(n3);
                boolean bl2 = true;
                if (gridBox._bgcolor != null) {
                    this.background.fillRect(gridBox._x, (float)bl2 / 2.0f + gridBox._y, gridBox._width, gridBox._height, gridBox._bgcolor);
                }
                if (!bl || color == null || color.equals(gridBox._bgcolor)) continue;
                this.background.drawRect(gridBox._x, (float)bl2 / 2.0f + gridBox._y, gridBox._width, gridBox._height - (float)bl2 / 2.0f, (float)bl2, 1, color);
            }
        }
        Vector vector4 = dSCrossTab.getChildren();
        n3 = n5 = vector4.size();
        while (--n3 >= 0) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector4.elementAt(n3);
            this.writeField((DSField)jRObjectResult, n, n4, null);
        }
        this._bdrstyle.pop();
    }

    void writeMediaField(DSPicture dSPicture, int n, int n2) {
        Object object;
        Object object2;
        Offset offset = (Offset)this._bdrstyle.peek();
        Box box = this.drawVShadow(dSPicture, offset, ++n, n2);
        Box box2 = new Box(box.x, box.y, box.width, box.height);
        int n3 = Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSPicture, "BorderWidth"), 72);
        boolean bl = CCUtil.getBooleanPropertyByName(dSPicture, "Shadow");
        int[] nArray = new int[4];
        int n4 = 0;
        int n5 = 4;
        while (--n5 >= 0) {
            nArray[n5] = CCUtil.getIntPropertyByName(dSPicture, BORDERLINENAME[n5]);
            n4 += nArray[n5];
        }
        DbBinary dbBinary = CCUtil.getDbBinaryPropertyByName(dSPicture, "ColumnName");
        if (!dbBinary.isNull()) {
            object2 = dbBinary.get();
            int n6 = (Integer)dSPicture.getPropertyByName("MediaType").getObject();
            if (object2 != null) {
                if (n6 == 2) {
                    if (object2[0] == 66 && object2[1] == 77) {
                        n6 = 1;
                    } else if (object2[0] == 71 && object2[1] == 73 && object2[2] == 70) {
                        n6 = 4;
                    } else if (object2[0] == -1 && object2[1] == -40 && object2[2] == -1 && object2[3] == -32) {
                        n6 = 0;
                    }
                }
                if (n6 == 4 || n6 == 0) {
                    object = PDFWriter._toolkit.createImage((byte[])object2);
                    if (n4 > 0) {
                        box.x += (float)n3;
                        box.y += (float)n3;
                        box.width -= (float)(n3 << 1);
                        box.height -= (float)(n3 << 1);
                    }
                    this.writeImage(dSPicture, (Image)object, box.x, box.y, bl ? box.width - (float)shadow : box.width, bl ? box.height - (float)shadow : box.height);
                } else if (n6 == 1 && (object = BitmapReader.loadFromBMP(new DataInputStream(new ByteArrayInputStream((byte[])object2)))) != null) {
                    Image image = PDFWriter._toolkit.createImage(((BitmapReader)object).getMemImgSrc());
                    ExportUtil.waitImage(image);
                    if (n4 > 0) {
                        box.x += (float)n3;
                        box.y += (float)n3;
                        box.width -= (float)(n3 << 1);
                        box.height -= (float)(n3 << 1);
                    }
                    this.writeImage(dSPicture, image, box.x, box.y, bl ? box.width - (float)shadow : box.width, bl ? box.height - (float)shadow : box.height);
                }
            }
        }
        if (n4 > 0) {
            object2 = CCUtil.getColorPropertyByName(dSPicture, "BorderColor");
            if (bl) {
                object = CCUtil.getColorPropertyByName(dSPicture, "ShadowColor");
                this.drawHShadow(box2, null, (Color)object2, n3, nArray, bl, bl, bl, bl, (Color)object, shadow);
            } else {
                this.drawHShadow(box2, null, (Color)object2, n3, nArray, false, false, false, false, null, shadow);
            }
        } else if (bl) {
            object2 = CCUtil.getColorPropertyByName(dSPicture, "ShadowColor");
            this.drawHShadow(box2, null, null, 0.0f, null, bl, bl, bl, bl, (Color)object2, shadow);
        } else {
            this.drawHShadow(box2, null, null, 0.0f, null, false, false, false, false, null, shadow);
        }
    }

    void writeUDO(JRVisiableResult jRVisiableResult, int n) throws IOException, DocumentException {
        block19: {
            Offset offset = (Offset)this._bdrstyle.peek();
            Box box = this.drawVShadow(jRVisiableResult, offset, n, 0);
            if (this.borderJoint.getClippingArea()) {
                this.background.saveState();
                this.background.clip(box.x, box.y, box.width, box.height);
            }
            try {
                JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
                if (jRObjectRender == null) break block19;
                jRObjectRender.setProperty(jRVisiableResult);
                if (jRVisiableResult instanceof JHyperLinkRslt) {
                    Image image;
                    ImageResource imageResource = jRVisiableResult.getImgResourceByPropertyName("displayImage");
                    Image image2 = image = imageResource == null ? null : imageResource.getImage();
                    if (image == null) {
                        ExportTextStyle exportTextStyle = this.clear(jRVisiableResult);
                        exportTextStyle.setUnderline(true, 1, exportTextStyle.foreground);
                        Box box2 = new Box(box.x, box.y, box.width, box.height);
                        Color color = (Color)jRVisiableResult.getPropertyByName("background").getObject();
                        if (color != null) {
                            this.background.fillRect(box.x, box.y, box.width, box.height, color);
                        }
                        List list = ((JHyperLinkRslt)jRVisiableResult).getLines();
                        for (int i = 0; i < list.size(); ++i) {
                            float f = box2.x + ExportToPDF.convertUnitToPoint(((JHyperlinkLineInfo)list.get(i)).getX());
                            float f2 = box2.y + ExportToPDF.convertUnitToPoint(((JHyperlinkLineInfo)list.get(i)).getY());
                            String string = ((JHyperlinkLineInfo)list.get(i)).getLine();
                            ExportText exportText = new ExportText(string, f, f2, exportTextStyle);
                            this.drawString(exportText);
                        }
                    } else if (image != null) {
                        this.writeImage(jRVisiableResult, image, box.x, box.y, box.width, box.height);
                    }
                    try {
                        boolean bl = true;
                        if (jRVisiableResult.getPropertyByName("EnableHyperlinkOnPDF") != null) {
                            bl = CCUtil.getBooleanPropertyByName(jRVisiableResult, "EnableHyperlinkOnPDF");
                        }
                        if (bl) {
                            this.background.drawURLLink(((HtmlGeneratable)((Object)jRVisiableResult)).getHyperLinks()[0], box.x, box.y, box.width, box.height);
                        }
                        break block19;
                    }
                    catch (Exception exception) {
                        if (JRLog.isError(2)) {
                            JRLog.error(2, 2401005, (Throwable)exception);
                        }
                        break block19;
                    }
                }
                Rectangle rectangle = jRVisiableResult.getBounds();
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
                if (!this.borderColor) {
                    BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
                    Graphics graphics = ((Image)bufferedImage).getGraphics();
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                    graphics.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics);
                    graphics.dispose();
                    this.writeImage(jRVisiableResult, bufferedImage, box.x, box.y, box.width, box.height);
                } else {
                    Graphics2D graphics2D = this.background.getGraphics(this._width > rectangle.width ? (float)this._width : (float)rectangle.width, this._x > rectangle.height ? (float)this._x : (float)rectangle.height);
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
                    affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
                    graphics2D.setTransform(affineTransform);
                    graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics2D);
                    graphics2D.dispose();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.borderJoint.getClippingArea()) {
            this.background.restoreState();
        }
    }

    private ExportTextStyle clear(JRVisiableResult jRVisiableResult) {
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        Object v = this.charAt.get(dSTemplatible);
        if (v != null) {
            return (ExportTextStyle)v;
        }
        int n = 0;
        FontInfo fontInfo = this.checkOutputStream.getUdoFontInfo(jRVisiableResult);
        float f = this.drawFileLink(fontInfo.getFontSize());
        String string = fontInfo.getFontName();
        boolean bl = false;
        if (((Boolean)jRVisiableResult.getPropertyByName("fontBold").getObject()).booleanValue()) {
            n |= 1;
        }
        if (((Boolean)jRVisiableResult.getPropertyByName("fontItalic").getObject()).booleanValue()) {
            n |= 2;
        }
        Color color = (Color)jRVisiableResult.getPropertyByName("foreground").getObject();
        PDFFont pDFFont = new PDFFont(string, n, f);
        boolean bl2 = this.createChildren(string);
        ExportTextStyle exportTextStyle = new ExportTextStyle(color, pDFFont, bl2);
        if (CCUtil.isChangeByFormularProperty(jRVisiableResult, "foreground") || CCUtil.isChangeByFormularProperty(jRVisiableResult, "fontItalic") || CCUtil.isChangeByFormularProperty(jRVisiableResult, "fontBold") || !fontInfo.isCanBeCache()) {
            return exportTextStyle;
        }
        this.charAt.put(dSTemplatible, exportTextStyle);
        return exportTextStyle;
    }

    void writeShape(DSShape dSShape, int n) {
        DSShapeRegion dSShapeRegion = new DSShapeRegion(dSShape, false);
        Rectangle rectangle = dSShapeRegion.getShapeRegion();
        if (rectangle != null) {
            float f;
            Offset offset = (Offset)this._bdrstyle.elementAt(0);
            float f2 = ExportToPDF.convertUnitToPoint(rectangle.x + offset.dx + n) + (float)this._toolkit;
            float f3 = ExportToPDF.convertUnitToPoint(rectangle.y + offset.dy) + (float)this._type;
            float f4 = ExportToPDF.convertUnitToPoint(rectangle.width);
            float f5 = ExportToPDF.convertUnitToPoint(rectangle.height);
            Color color = null;
            Color color2 = null;
            int n2 = 0;
            int n3 = dSShape.getObjectType();
            if (n3 != 22) {
                color = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
                color2 = CCUtil.getColorPropertyByName(dSShape, "Background");
                n2 = CCUtil.getIntPropertyByName(dSShape, "BorderStyle");
                f = Unit.convertUnitToPixel(CCUtil.getFloatPropertyByName(dSShape, "BorderWidth"), 72);
                if (f > 0.0f && n2 != 0 && color2 != null) {
                    f2 += (float)((int)f >> 1);
                    f3 += (float)((int)f >> 1);
                    f4 -= f;
                    f5 -= f;
                }
            } else {
                color = CCUtil.getColorPropertyByName(dSShape, "LineColor");
                f = ExportToPDF.convertUnitToPoint(CCUtil.getFloatPropertyByName(dSShape, "LineWidth"));
                n2 = CCUtil.getIntPropertyByName(dSShape, "LineStyle");
            }
            if (n3 == 22) {
                this.HorizontalAlignment.addElement(new GeoBdrInfo(f2, f3, f4 + f2, f5 + f3, n3, color, f, n2, -1, -1, -1));
            } else if (n3 == 23) {
                if (color2 != null) {
                    this.background.fillRect(f2, f3, f4, f5, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.HorizontalAlignment.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, -1, -1));
                }
            } else if (n3 == 20) {
                int n4 = Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSShape, "CornerFactor"));
                if (color2 != null) {
                    this.background.fillRoundRect(f2, f3, f4, f5, n4, n4, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.HorizontalAlignment.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, n4, -1, -1));
                }
            } else if (n3 == 19) {
                if (color2 != null) {
                    this.background.fillOval(f2, f3, f4, f5, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.HorizontalAlignment.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, -1, -1));
                }
            } else if (n3 == 18) {
                int n5 = CCUtil.getIntPropertyByName(dSShape, "StartAngle");
                int n6 = CCUtil.getIntPropertyByName(dSShape, "ArcAngle");
                if (color2 != null) {
                    this.background.fillArc(f2, f3, f4, f5, n5, n6, color2);
                }
                if (n2 != 0 && color != null && !color.equals(color2)) {
                    this.HorizontalAlignment.addElement(new GeoBdrInfo(f2, f3, f4, f5, n3, color, f, n2, -1, n5, n6));
                }
            }
        }
    }

    private void clearCacheRender(Stack stack, Color color) throws IOException, DocumentException, JRStopEngineException, OutOfSpaceException {
        if (this.borderJoint.hasDrill() && this.WHITE.size() > 0 && this._commuList.length == 1) {
            this._bdcolor = false;
            for (int i = 0; i < this.WHITE.size(); ++i) {
                this.addElement = 0;
                String string = (String)this.WHITE.elementAt(i);
                DSPage dSPage = (DSPage)this.SEDU.get(string);
                this.color(dSPage);
                this.close(string);
                this.background.open(new Dimension(this._width, this._x), color);
                this.DEF_COLOR(dSPage);
                this.background.dispose();
                stack.push(string);
                this.addElement = -1;
            }
        }
    }

    private void clip() throws NumberFormatException, OutOfSpaceException, IOException {
        if (this.borderJoint.hasToc() && this._commuList.length == 1 && this.maxSizeofPDF == -1) {
            if (Float.valueOf(System.getProperty("java.version").substring(0, 3)).floatValue() > 1.29f) {
                DSTOC dSTOC = this._commu.getDSTOC();
                if (dSTOC != null) {
                    this.background.drawToc(dSTOC.getTOCNode());
                }
            } else if (JRLog.isTrace(3)) {
                JRLog.trace(3, 3401003);
            }
        }
        if (this.background != null) {
            this.background.dispose();
        }
    }

    String validFileName(String string) {
        return string.endsWith(".pdf") ? string : string + ".pdf";
    }

    String escapeFileName(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ("\\/:*?\"<>|()".indexOf(c) == -1) continue;
            string = string.replace(c, '-');
        }
        return string;
    }

    private void close(String string) throws IOException, DocumentException, OutOfSpaceException {
        this.backgroundColor = new PdfExt();
        this.background = new PDFWriter(this.backgroundColor, string, this.borderJoint, this.close);
        this.background.setEncoding(this._commu.getEncoding());
    }

    static String addSuffix(String string, String string2) {
        String string3 = string.substring(0, string.length() - 4);
        string3 = string3 + string2 + ".pdf";
        return string3;
    }

    private void color(DSPage dSPage) {
        Rectangle rectangle = dSPage.getPageArea();
        this._height = dSPage.getPrintableArea();
        rectangle.width = rectangle.width <= LIMITEDBOUND ? rectangle.width : LIMITEDBOUND;
        rectangle.height = rectangle.height <= LIMITEDBOUND ? rectangle.height : LIMITEDBOUND;
        this._height.width = this._height.width <= LIMITEDBOUND ? this._height.width : LIMITEDBOUND;
        int n = this._height.height = this._height.height <= LIMITEDBOUND ? this._height.height : LIMITEDBOUND;
        if (!this.borderJoint.noMargin()) {
            this._toolkit = Unit.convertUnitToPixel(this._height.x, 72);
            this._type = Unit.convertUnitToPixel(this._height.y, 72);
        }
        this._width = Unit.convertUnitToPixel(rectangle.width, 72);
        this._x = Unit.convertUnitToPixel(rectangle.height, 72);
    }

    private String convertInchToPixel(DSSection dSSection, String string) {
        String string2 = null;
        if (dSSection.getObjectType() == 515 || dSSection.getObjectType() == 518) {
            if (dSSection.groupLevel < this.bgRect) {
                int n = -1;
                for (int i = 0; i < dSSection.groupLevel; ++i) {
                    n = this.black.indexOf(FILENAME_SEPARATE, n + 1);
                }
                this.black = n > 0 ? this.black.substring(0, n) : "";
            } else if (dSSection.groupLevel == this.bgRect) {
                this.black = this.black.substring(0, this.black.lastIndexOf(FILENAME_SEPARATE));
            }
            this.black = string2 = dSSection.groupValue == null ? this.black + '_' + "NULL" : this.black + '_' + dSSection.groupValue.toString();
            this.bgRect = dSSection.groupLevel;
            string2 = string + this.escapeFileName(string2);
        }
        return string2;
    }

    private String convertPixelToUnit(DSField dSField) throws JRStopEngineException {
        int n;
        DSSection dSSection;
        String string = null;
        if (this.borderJoint.hasDrill() && this._bdcolor && (dSSection = dSField.getSection()) != null && ((n = dSSection.getObjectType()) == 515 || n == 518) && this.convertUnitToPixel(dSField) && (string = this.convertInchToPixel(dSSection, this.BLACK.substring(0, this.BLACK.length() - 4))) != null) {
            string = this.validFileName(string);
            this.WHITE.addElement(string);
            DSPage dSPage = this._commu.getDrillDownPage(dSSection.getDataStream().getSubIndex(), this.add, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), (Integer)dSSection.getTemplate().getPropertyByName("BranchIdx").getObject(), dSSection);
            this.SEDU.put(string, dSPage);
        }
        return string;
    }

    private JRObjectResult convertTwoRes(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult2.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    private boolean convertUnitToPixel(DSField dSField) {
        boolean bl = false;
        if (dSField.getObjectType() == 258) {
            DbValue dbValue = ((DSDBField)dSField).getValue();
            bl = dbValue.getColDesc().isGroupable();
        }
        return bl;
    }

    private boolean convertUnitToPoint() {
        this.addSuffix = this._commu.getLocale().getLanguage().equals(new Locale("ar", "", "").getLanguage());
        return this.addSuffix || this._commu.getLocale().getLanguage().equals(new Locale("iw", "", "").getLanguage());
    }

    private void corner(JRObjectResult jRObjectResult, Box box) throws JRStopEngineException {
        int n = this.FILL_COLOR != null ? this.getPageNumber(this.FILL_COLOR.getCurrentCommunicator(), jRObjectResult) : -1;
        if (n != -1) {
            this.background.drawLocalLink(this.clip + n, box.x, box.y, box.width, box.height);
        } else if (jRObjectResult.getLinkComm() == -1 && this._bdcolor) {
            String string;
            String string2 = string = this.FILL_COLOR == null ? null : this.FILL_COLOR.getCurrentCommunicator().getLinkedInfo(jRObjectResult.getLinkCondition());
            if (string != null) {
                this.background.drawURLLink(string, box.x, box.y, box.width, box.height);
            }
        }
    }

    private boolean createChildren(String string) {
        boolean bl = false;
        if (this.ConvertProperties.length() > 0 && string.startsWith("*")) {
            bl = this.ConvertProperties.indexOf(string) > -1;
        }
        return bl;
    }

    private int createFile(JRObjectResult jRObjectResult, int n) {
        if (jRObjectResult instanceof DSParagraphText) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 5;
                }
                case 3: {
                    return 6;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 9;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 10;
                }
                case 9: {
                    return 11;
                }
                case 10: {
                    return 4;
                }
                case 11: {
                    return 12;
                }
                case 12: {
                    return 13;
                }
                case 13: {
                    return 14;
                }
                case 14: {
                    return 15;
                }
                case 15: {
                    return 16;
                }
                case 16: {
                    return 17;
                }
            }
        }
        return 0;
    }

    private String createImage(String string) {
        if (this.append) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            StringBuffer stringBuffer2 = new StringBuffer(n);
            String string2 = this.reverseString(string);
            if (string2 != null) {
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    if (this.isFromRightToLeft(c)) {
                        if (stringBuffer2.length() != 0) {
                            stringBuffer.append(stringBuffer2.reverse().toString());
                            stringBuffer2 = new StringBuffer();
                        }
                        stringBuffer.append(c);
                        continue;
                    }
                    char c2 = (char)this.arca.get((int)c);
                    if (c2 != '\u0000') {
                        if (stringBuffer2.length() != 0) {
                            stringBuffer.append(stringBuffer2.reverse().toString());
                            stringBuffer2 = new StringBuffer();
                        }
                        stringBuffer.append(c2);
                        continue;
                    }
                    int n2 = Character.getType(c);
                    if (n2 != 20 && n2 != 22 && n2 != 24 && n2 != 14) {
                        stringBuffer2.append(c);
                        continue;
                    }
                    if (stringBuffer2.length() != 0) {
                        stringBuffer.append(stringBuffer2.reverse().toString());
                        stringBuffer2 = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer2.length() != 0) {
                    stringBuffer.append(stringBuffer2.reverse().toString());
                }
                string = stringBuffer.toString();
                if (this.addSuffix) {
                    string = this.ascent.shape(string);
                }
            }
        }
        return string;
    }

    boolean isFromRightToLeft(char c) {
        return this.isArabic(c) || this.isHebrew(c);
    }

    boolean isArabic(char c) {
        return c >= '\u0600' && c < '\u0700';
    }

    boolean isHebrew(char c) {
        return c >= '\u0590' && c < '\u0600';
    }

    int getPageNumber(Communicator communicator, JRObjectResult jRObjectResult) throws JRStopEngineException {
        int n;
        Communicator communicator2;
        int n2 = jRObjectResult.getLinkComm();
        int n3 = -1;
        if (n2 != -1 && (communicator2 = communicator.getLinkedComm(n2)) != null && (n = communicator2.getLinkedPage(jRObjectResult.getLinkCondition())) >= 0) {
            n3 = this.getPageNumber(communicator, n2, n);
        }
        return n3;
    }

    int getPageNumber(Communicator communicator, int n, int n2) {
        if (n != -1 || n2 != -1) {
            Communicator communicator2;
            CommNode commNode;
            TreeIterater treeIterater = new TreeIterater(new CommNode(this._commu), false);
            communicator = communicator.getLinkedComm(n);
            while ((commNode = (CommNode)treeIterater.next()) != null && (communicator2 = commNode.getComm()) != communicator) {
                n2 += communicator2.getPageNum();
            }
        }
        return n2;
    }

    String reverseString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length - 1;
        boolean bl = false;
        for (int i = n - 1 >> 1; i >= 0; --i) {
            char c = cArray[i];
            cArray[i] = cArray[n - i];
            cArray[n - i] = c;
            if (bl) continue;
            bl = this.isFromRightToLeft(cArray[i]) || this.isFromRightToLeft(cArray[n - i]);
        }
        return bl ? new String(cArray) : null;
    }

    private void createSignature(Box box, Color color, int n) {
        if (color != null) {
            switch (n) {
                case 1: {
                    this.deIndent(box, 2, color);
                    break;
                }
                case 5: {
                    this.deIndent(box, 6, color);
                    break;
                }
                case 2: {
                    this.delete(box, 6, 1, color);
                    break;
                }
                case 3: {
                    this.delete(box, 6, 2, color);
                    break;
                }
                case 4: {
                    this.delete(box, 6, 3, color);
                }
            }
        }
    }

    private void deIndent(Box box, int n, Color color) {
        float f;
        float f2;
        float f3 = f2 = box.x;
        float f4 = f = box.y;
        float f5 = box.width + f2;
        float f6 = box.height + f;
        this.background.drawLine(f2, f, f2, f, 1.0f, 1, color);
        if (box.width > box.height) {
            while (f + (float)n < f6) {
                this.background.drawLine(f2 + (float)n, f4, f3, f + (float)n, 1.0f, 1, color);
                f2 += (float)n;
                f += (float)n;
            }
            f3 = f + (float)n - f6 + f3;
            while (f2 + (float)n < f5) {
                this.background.drawLine(f2 + (float)n, f4, f3, f6, 1.0f, 1, color);
                f2 += (float)n;
                f3 += (float)n;
            }
            for (f4 = f2 + (float)n - f5 + f4; f4 <= f6; f4 += (float)n) {
                this.background.drawLine(f5, f4, f3, f6, 1.0f, 1, color);
                f3 += (float)n;
            }
        } else {
            while (f2 + (float)n < f5) {
                this.background.drawLine(f2 + (float)n, f4, f3, f + (float)n, 1.0f, 1, color);
                f2 += (float)n;
                f += (float)n;
            }
            f4 = f2 + (float)n - f5 + f4;
            while (f + (float)n < f6) {
                this.background.drawLine(f5, f4, f3, f + (float)n, 1.0f, 1, color);
                f += (float)n;
                f4 += (float)n;
            }
            f3 = f + (float)n - f6 + f3;
            while (f3 <= f5) {
                this.background.drawLine(f5, f4, f3, f6, 1.0f, 1, color);
                f3 += (float)n;
                f4 += (float)n;
            }
        }
    }

    private void delete(Box box, int n, int n2, Color color) {
        float f;
        float f2 = box.x;
        float f3 = box.x + box.width;
        float f4 = box.y;
        float f5 = box.y + box.height;
        if ((n2 & 1) != 0) {
            for (f = f4 + (float)n - 1.0f; f < f5 + 1.0f; f += (float)n) {
                this.background.drawLine(f2, f, f3, f, 1.0f, 1, color);
            }
        }
        if ((n2 & 2) != 0) {
            for (f = f2 + (float)n - 1.0f; f < f3 + 1.0f; f += (float)n) {
                this.background.drawLine(f, f4, f, f5, 1.0f, 1, color);
            }
        }
    }

    private Box dispose(JRVisiableResult jRVisiableResult, int n, int n2) {
        Offset offset = (Offset)this._bdrstyle.peek();
        float f = ExportToPDF.convertUnitToPoint(jRVisiableResult.getX() + offset.dx + n) + (float)this._toolkit;
        float f2 = ExportToPDF.convertUnitToPoint(this.getY(jRVisiableResult, n2) + offset.dy) + (float)this._type;
        float f3 = ExportToPDF.convertUnitToPoint(jRVisiableResult.getWidth());
        float f4 = ExportToPDF.convertUnitToPoint(jRVisiableResult.getHeight());
        Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
        if (color != null) {
            this.background.fillRect(f, f2, f3, f4, color);
        }
        return new Box(f, f2, f3, f4);
    }

    private int drawArc(JRObjectResult jRObjectResult, String string) {
        int n = 0;
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Bold")) {
            n |= 1;
        }
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "Italic")) {
            n |= 2;
        }
        return n;
    }

    private int drawExpRectShadow(JRObjectResult jRObjectResult, String string) {
        int n = 0;
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "TitleBold")) {
            n |= 1;
        }
        if (CCUtil.getBooleanPropertyByName(jRObjectResult, "TitleItalic")) {
            n |= 2;
        }
        return n;
    }

    private static int drawFieldBorder(String string, boolean bl) {
        if (bl) {
            return FontSets.getTrueTypeFontStyle(string);
        }
        return -1;
    }

    private float drawFileLink(float f) {
        return ExportToPDF.convertUnitToPoint(f);
    }

    public boolean isVectorExportChart() {
        return this.borderColor;
    }

    void writeShapeBorder(GeoBdrInfo geoBdrInfo) {
        switch (geoBdrInfo._type) {
            case 22: {
                this.background.drawLine(geoBdrInfo._x, geoBdrInfo._y, geoBdrInfo._width, geoBdrInfo._height, geoBdrInfo._bdrwidth, geoBdrInfo._bdrstyle, geoBdrInfo._bdcolor);
                break;
            }
            case 23: {
                this.background.drawRect(geoBdrInfo._x, geoBdrInfo._y, geoBdrInfo._width, geoBdrInfo._height, geoBdrInfo._bdrwidth, geoBdrInfo._bdrstyle, geoBdrInfo._bdcolor);
                break;
            }
            case 20: {
                this.background.drawRoundRect(geoBdrInfo._x, geoBdrInfo._y, geoBdrInfo._width, geoBdrInfo._height, geoBdrInfo.corner, geoBdrInfo.corner, geoBdrInfo._bdrwidth, geoBdrInfo._bdrstyle, geoBdrInfo._bdcolor);
                break;
            }
            case 19: {
                this.background.drawOval(geoBdrInfo._x, geoBdrInfo._y, geoBdrInfo._width, geoBdrInfo._height, geoBdrInfo._bdrwidth, geoBdrInfo._bdrstyle, geoBdrInfo._bdcolor);
                break;
            }
            case 18: {
                this.background.drawArc(geoBdrInfo._x, geoBdrInfo._y, geoBdrInfo._width, geoBdrInfo._height, geoBdrInfo.starta, geoBdrInfo.arca, geoBdrInfo._bdrwidth, geoBdrInfo._bdrstyle, geoBdrInfo._bdcolor);
            }
        }
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult instanceof DSSection && this.addElement != -1) {
            int n2 = this.addElement;
            this.addElement += jRVisiableResult.getHeight();
            return n2;
        }
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (jRVisiableResult instanceof DSSubReport) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n5 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n5 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n4 = (n3 = n5) > 0 ? n3 : 0;
        }
        return n4;
    }

    void writeEvaluation() throws IOException, DocumentException {
        int n = Unit.convertInchToPixel(2.0, 72);
        int n2 = Unit.convertInchToPixel(3.0, 72);
        int n3 = Unit.convertInchToPixel(2.0, 72);
        for (int i = Unit.convertInchToPixel(1.0, 72); n < this._width || i < this._x; n += n2, i += n3) {
            int n4 = n - TW / 2;
            int n5 = n - BW1 / 2;
            int n6 = n - BW2 / 2;
            int n7 = i - BH / 2 - 5;
            int n8 = i;
            int n9 = i + BH / 2 + 5;
            this.background.setFont(FT, false);
            this.background.drawString("JReport Evaluation Copy", n4 + this._toolkit, n7 + this._type, DEF_COLOR);
            this.background.setFont(FB, false);
            this.background.drawString(CONTACT, n5 + this._toolkit, n8 + this._type, DEF_COLOR);
            this.background.drawString(PHONE, n6 + this._toolkit, n9 + this._type, DEF_COLOR);
        }
    }

    private void drawHShadow(Box box, Color color, Color color2, float f, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color3, int n) {
        Color[] colorArray = null;
        float[] fArray2 = new float[4];
        if (color2 != null) {
            colorArray = new Color[4];
            colorArray[1] = colorArray[3] = color2;
            colorArray[2] = colorArray[3];
            colorArray[0] = colorArray[3];
        }
        fArray2[1] = fArray2[3] = f;
        fArray2[2] = fArray2[3];
        fArray2[0] = fArray2[3];
        this.drawImage(box, color, colorArray, fArray2, nArray, bl, bl2, bl3, bl4, color3, n);
    }

    private void drawImage(Box box, Color color, Color[] colorArray, float[] fArray2, int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color2, int n) {
        float f = box.width;
        float f2 = box.height;
        if (bl) {
            f2 -= (float)n;
        }
        if (bl2) {
            f -= (float)n;
        }
        if (colorArray != null) {
            if (fArray2[0] > 0.0f && colorArray[0] != null && !colorArray[0].equals(color) && nArray[0] != 0) {
                if (nArray[0] != 5) {
                    this.background.drawLine(box.x, fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] / 2.0f + box.y, fArray2[0], nArray[0], colorArray[0]);
                } else {
                    this.background.drawLine(box.x, fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] / 2.0f + box.y, fArray2[0], 1, colorArray[0]);
                    this.background.drawLine(box.x, fArray2[0] * 2.0f + fArray2[0] / 2.0f + box.y, f + box.x, fArray2[0] * 2.0f + fArray2[0] / 2.0f + box.y, fArray2[0], 1, colorArray[0]);
                }
            }
            if (fArray2[2] > 0.0f && colorArray[2] != null && !colorArray[2].equals(color) && nArray[2] != 0) {
                if (nArray[2] != 5) {
                    this.background.drawLine(box.x, f2 - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] / 2.0f + box.y, fArray2[2], nArray[2], colorArray[2]);
                } else {
                    this.background.drawLine(box.x, f2 - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] / 2.0f + box.y, fArray2[2], 1, colorArray[2]);
                    this.background.drawLine(box.x, f2 - fArray2[2] * 2.0f - fArray2[2] / 2.0f + box.y, f + box.x, f2 - fArray2[2] * 2.0f - fArray2[2] / 2.0f + box.y, fArray2[2], 1, colorArray[2]);
                }
            }
            if (fArray2[1] > 0.0f && colorArray[1] != null && !colorArray[1].equals(color) && nArray[1] != 0) {
                if (nArray[1] != 5) {
                    this.background.drawLine(fArray2[1] / 2.0f + box.x, box.y, fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], nArray[1], colorArray[1]);
                } else {
                    this.background.drawLine(fArray2[1] / 2.0f + box.x, box.y, fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], 1, colorArray[1]);
                    this.background.drawLine(fArray2[1] * 2.0f + fArray2[1] / 2.0f + box.x, box.y, fArray2[1] * 2.0f + fArray2[1] / 2.0f + box.x, f2 + box.y, fArray2[1], 1, colorArray[1]);
                }
            }
            if (fArray2[3] > 0.0f && colorArray[3] != null && !colorArray[3].equals(color) && nArray[3] != 0) {
                if (nArray[3] != 5) {
                    this.background.drawLine(f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], nArray[3], colorArray[3]);
                } else {
                    this.background.drawLine(f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], 1, colorArray[3]);
                    this.background.drawLine(f - fArray2[3] * 2.0f - fArray2[3] / 2.0f + box.x, box.y, f - fArray2[3] * 2.0f - fArray2[3] / 2.0f + box.x, f2 + box.y, fArray2[3], 1, colorArray[3]);
                }
            }
        }
        if ((bl || bl2) && color2 != null && n > 0) {
            int n2;
            if (bl) {
                n2 = bl3 ? n : 0;
                this.background.fillRect((float)n2 + box.x, box.height - (float)n + box.y, box.width - (float)n2, n, color2);
            }
            if (bl2) {
                n2 = bl4 ? n : 0;
                this.background.fillRect(box.width - (float)n + box.x, (float)n2 + box.y, n, box.height - (float)n2, color2);
            }
        }
    }

    private void drawLine(ExportLine exportLine) {
        ExportLineStyle exportLineStyle = exportLine.lineStyle;
        if (exportLineStyle != null && exportLineStyle.color != null && exportLineStyle.lineWidth > 0.0f) {
            float f = exportLineStyle.lineWidth;
            if (exportLineStyle.lineStyle == 5) {
                if (f < 3.0f) {
                    this.background.drawLine(exportLine.startX, exportLine.startY, exportLine.endX, exportLine.endY, exportLineStyle.lineWidth, 1, exportLineStyle.color);
                } else if (exportLine.startX == exportLine.endX) {
                    this.background.drawLine(exportLine.startX, exportLine.startY, exportLine.endX, exportLine.endY, f / 3.0f, 1, exportLineStyle.color);
                    this.background.drawLine(exportLine.startX + f * 2.0f / 3.0f, exportLine.startY, exportLine.endX + f * 2.0f / 3.0f, exportLine.endY, f / 3.0f, 1, exportLineStyle.color);
                } else if (exportLine.startY == exportLine.endY) {
                    this.background.drawLine(exportLine.startX, exportLine.startY, exportLine.endX, exportLine.endY, f / 3.0f, 1, exportLineStyle.color);
                    this.background.drawLine(exportLine.startX, exportLine.startY + f * 2.0f / 3.0f, exportLine.endX, exportLine.endY + f * 2.0f / 3.0f, f / 3.0f, 1, exportLineStyle.color);
                }
            } else if (exportLineStyle.lineStyle != 0) {
                this.background.drawLine(exportLine.startX, exportLine.startY, exportLine.endX, exportLine.endY, f, exportLineStyle.lineStyle, exportLineStyle.color);
            }
        }
    }

    private void drawLocalLink(ExportRectangle exportRectangle) {
        Box box;
        if (exportRectangle.fillProp != null && (box = new Box(exportRectangle.getInnerLocation())) != null) {
            FillPatternAdapter fillPatternAdapter = new FillPatternAdapter(exportRectangle.fillProp);
            if (exportRectangle.fillProp.getFillPatternType() == 2 && exportRectangle.fillProp.getGradientStyle() == 1) {
                BufferedImage bufferedImage = new BufferedImage((int)box.width, (int)box.height, 1);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, (int)box.width, (int)box.height);
                fillPatternAdapter.fillPattern(graphics, new Rectangle(0, 0, (int)box.width, (int)box.height));
                this.writeImage(null, bufferedImage, box.x, box.y, box.width, box.height);
            } else {
                int n = Unit.convertTwoRes((int)box.width, 72, Unit.getResolution());
                int n2 = Unit.convertTwoRes((int)box.height, 72, Unit.getResolution());
                Graphics2D graphics2D = this.drawOval(box);
                fillPatternAdapter.fillPattern(graphics2D, new Rectangle(0, 0, n, n2));
                graphics2D.dispose();
            }
        }
    }

    private Graphics2D drawOval(Box box) {
        Graphics2D graphics2D = this.background.getGraphics((float)this._width > box.width ? (float)this._width : box.width, (float)this._x > box.height ? (float)this._x : box.height);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(72.0f / (float)Unit.getResolution(), 72.0f / (float)Unit.getResolution());
        affineTransform.translate(box.x * (float)Unit.getResolution() / 72.0f, box.y * (float)Unit.getResolution() / 72.0f);
        graphics2D.setTransform(affineTransform);
        return graphics2D;
    }

    private void drawRect(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if (box != null) {
            if (exportRectangle.fillProp != null && exportRectangle.fillProp.getFillPatternType() != FillPatternProperties.FILL_COLOR) {
                this.drawLocalLink(exportRectangle);
                return;
            }
            if (exportRectangle.drawHShadow) {
                box.height -= (float)exportRectangle.shadowWidth;
            }
            if (exportRectangle.drawVShadow) {
                box.width -= (float)exportRectangle.shadowWidth;
            }
            if (exportRectangle.background != null) {
                if (exportRectangle.borderJoint == BorderProperties.BORDERJOINT_ROUND) {
                    float f = exportRectangle.roundJointRadius;
                    this.background.fillRoundRect(box.x, box.y, box.width, box.height, f, f, exportRectangle.background);
                } else {
                    this.background.fillRect(box.x, box.y, box.width, box.height, exportRectangle.background);
                }
            }
        }
    }

    private void drawRoundRect(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if (box != null) {
            if (exportRectangle.borderJoint == BorderProperties.BORDERJOINT_ROUND) {
                float f = exportRectangle.roundJointRadius;
                ExportLineStyle exportLineStyle = exportRectangle.topBorderStyle;
                if (exportLineStyle != null) {
                    this.background.drawRoundRect(box.x, box.y, box.width, box.height, f, f, exportLineStyle.lineWidth, exportLineStyle.lineStyle, exportLineStyle.color);
                }
            } else {
                ExportLine exportLine;
                if (exportRectangle.drawHShadow) {
                    box.height -= (float)exportRectangle.shadowWidth;
                }
                if (exportRectangle.drawVShadow) {
                    box.width -= (float)exportRectangle.shadowWidth;
                }
                ExportLineStyle exportLineStyle = exportRectangle.leftBorderStyle;
                float f = 0.0f;
                if (exportLineStyle != null) {
                    exportLine = new ExportLine(box.x + f, box.y, box.x + f, box.y + box.height);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.drawLine(exportLine);
                }
                if ((exportLineStyle = exportRectangle.topBorderStyle) != null) {
                    exportLine = new ExportLine(box.x, box.y + f, box.x + box.width, box.y + f);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.drawLine(exportLine);
                }
                if ((exportLineStyle = exportRectangle.rightBorderStyle) != null) {
                    exportLine = new ExportLine(box.x + box.width - f, box.y, box.x + box.width - f, box.y + box.height);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.drawLine(exportLine);
                }
                if ((exportLineStyle = exportRectangle.bottomBorderStyle) != null) {
                    exportLine = new ExportLine(box.x, box.y + box.height - f, box.x + box.width, box.y + box.height - f);
                    exportLine.setExpLineStyle(exportLineStyle);
                    this.drawLine(exportLine);
                }
                this.drawExpRectShadow(exportRectangle);
            }
        }
    }

    void drawExpRectShadow(ExportRectangle exportRectangle) {
        Box box = new Box(exportRectangle.getInnerLocation());
        if ((exportRectangle.drawHShadow || exportRectangle.drawVShadow) && exportRectangle.shadowColor != null && exportRectangle.shadowWidth > 0) {
            int n;
            if (exportRectangle.drawHShadow) {
                n = exportRectangle.indentHShadow ? exportRectangle.shadowWidth : 0;
                this.background.fillRect((float)n + box.x, box.height - (float)exportRectangle.shadowWidth + box.y, box.width - (float)n, exportRectangle.shadowWidth, exportRectangle.shadowColor);
            }
            if (exportRectangle.drawVShadow) {
                n = exportRectangle.indentVShadow ? exportRectangle.shadowWidth : 0;
                this.background.fillRect(box.width - (float)exportRectangle.shadowWidth + box.x, (float)n + box.y, exportRectangle.shadowWidth, box.height - (float)n, exportRectangle.shadowColor);
            }
        }
    }

    private void drawString(ExportText exportText) throws IOException, DocumentException {
        String string = exportText.text;
        ExportTextStyle exportTextStyle = exportText.expTextStyle;
        PDFFont pDFFont = exportTextStyle.font;
        Font font = pDFFont.getAwtFont();
        if (exportTextStyle.foreground != null && string != null && string.length() != 0 && font != null) {
            float f;
            BaseFont baseFont = this.backgroundColor.getBaseFont(string, pDFFont, exportTextStyle.embedded, pDFFont.isJFont());
            float f2 = font.getSize2D();
            this.background.setFont(pDFFont, exportTextStyle.embedded);
            FontMetrics fontMetrics = PDFWriter.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            float f3 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
            f3 = f3 > 1.0f ? f3 : 1.0f;
            float f4 = exportText.x;
            float f5 = exportText.y;
            if (pDFFont.isNeedChangeStyle()) {
                this.background.drawString(string, baseFont, pDFFont.getTrueStyle(), f2, f4, f5 + (float)n, exportTextStyle.foreground);
            } else {
                this.background.drawString(string, baseFont, f2, f4, f5 + (float)n, exportTextStyle.foreground);
            }
            if (exportTextStyle.haveUnderline && exportTextStyle.underlineColor != null) {
                f = baseFont.getWidthPoint(string, f2);
                if (exportTextStyle.underlineStyle == 5) {
                    this.background.drawLine(f4, f5 + (float)n + 1.0f, f4 + f, f5 + (float)n + 1.0f, f3, 1, exportTextStyle.underlineColor);
                    this.background.drawLine(f4, f5 + (float)n + 2.0f + f3 / 2.0f, f4 + f, f5 + (float)n + 2.0f + f3 / 2.0f, f3, 1, exportTextStyle.underlineColor);
                } else {
                    float f6 = f5 + (float)n + 2.0f + f3 / 2.0f;
                    this.background.drawLine(f4, f6, f4 + f, f6, f3, exportTextStyle.underlineStyle, exportTextStyle.underlineColor);
                }
            }
            if (exportTextStyle.haveStrikethrough && exportTextStyle.throughlineColor != null) {
                f = baseFont.getWidthPoint(string, f2);
                int n2 = fontMetrics.getHeight();
                if (exportTextStyle.throughlineStyle == 5) {
                    this.background.drawLine(f4, f5 + (float)(n2 / 2) + 1.0f, f4 + f, f5 + (float)(n2 / 2) + 1.0f, f3, 1, exportTextStyle.throughlineColor);
                    this.background.drawLine(f4, f5 + (float)(n2 / 2) + 2.0f + f3 / 2.0f, f4 + f, f5 + (float)(n2 / 2) + 2.0f + f3 / 2.0f, f3, 1, exportTextStyle.throughlineColor);
                } else {
                    this.background.drawLine(f4, f5 + (float)(n2 / 2) + 1.0f, f4 + f, f5 + (float)(n2 / 2) + 1.0f, f3, exportTextStyle.throughlineStyle, exportTextStyle.throughlineColor);
                }
            }
        }
    }

    private void drawToc(ExportText exportText, Box box) throws IOException, DocumentException {
        String string = exportText.text;
        ExportTextStyle exportTextStyle = exportText.expTextStyle;
        PDFFont pDFFont = exportTextStyle.font;
        Font font = pDFFont.getAwtFont();
        if (exportTextStyle.foreground != null && string != null && string.length() != 0 && font != null) {
            BaseFont baseFont = this.backgroundColor.getBaseFont(string, pDFFont, exportTextStyle.embedded, pDFFont.isJFont());
            float f = font.getSize2D();
            this.background.setFont(pDFFont, exportTextStyle.embedded);
            int n = exportTextStyle.ascent;
            float f2 = exportText.x;
            float f3 = exportText.y;
            float f4 = -1.0f;
            int n2 = exportText.expTextStyle.HorizontalAlignment;
            if (n2 == 1 && !pDFFont.isJFont() && box != null) {
                f4 = baseFont.getWidthPoint(string, f);
                f2 = box.x + box.width - f4 - exportTextStyle.rightPadding;
            }
            if (pDFFont.isNeedChangeStyle()) {
                this.background.drawString(string, baseFont, pDFFont.getTrueStyle(), f, f2, f3 + (float)n, exportTextStyle.foreground);
            } else {
                this.background.drawString(string, baseFont, f, f2, f3 + (float)n, exportTextStyle.foreground);
            }
            if (exportTextStyle.haveUnderline && exportTextStyle.underlineColor != null) {
                if (f4 == -1.0f) {
                    f4 = baseFont.getWidthPoint(string, f);
                }
                float f5 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
                float f6 = f5 = f5 > 1.0f ? f5 : 1.0f;
                if (exportTextStyle.underlineStyle == 5) {
                    this.background.drawLine(f2, f3 + (float)n + 1.0f, f2 + f4, f3 + (float)n + 1.0f, f5, 1, exportTextStyle.underlineColor);
                    this.background.drawLine(f2, f3 + (float)n + 2.0f + f5 / 2.0f, f2 + f4, f3 + (float)n + 2.0f + f5 / 2.0f, f5, 1, exportTextStyle.underlineColor);
                } else {
                    float f7 = f3 + (float)n + 2.0f + f5 / 2.0f;
                    this.background.drawLine(f2, f7, f2 + f4, f7, f5, exportTextStyle.underlineStyle, exportTextStyle.underlineColor);
                }
            }
            if (exportTextStyle.haveStrikethrough && exportTextStyle.throughlineColor != null) {
                if (f4 == -1.0f) {
                    f4 = baseFont.getWidthPoint(string, f);
                }
                FontMetrics fontMetrics = PDFWriter.getFontMetrics(font);
                int n3 = fontMetrics.getHeight();
                float f8 = (float)(font.getSize() + (font.isBold() ? 2 : 0)) / 10.0f * 3.0f / 4.0f;
                float f9 = f8 = f8 > 1.0f ? f8 : 1.0f;
                if (exportTextStyle.throughlineStyle == 5) {
                    this.background.drawLine(f2, f3 + (float)(n3 / 2) + 1.0f, f2 + f4, f3 + (float)(n3 / 2) + 1.0f, f8, 1, exportTextStyle.throughlineColor);
                    this.background.drawLine(f2, f3 + (float)(n3 / 2) + 2.0f + f8 / 2.0f, f2 + f4, f3 + (float)(n3 / 2) + 2.0f + f8 / 2.0f, f8, 1, exportTextStyle.throughlineColor);
                } else {
                    this.background.drawLine(f2, f3 + (float)(n3 / 2) + 1.0f, f2 + f4, f3 + (float)(n3 / 2) + 1.0f, f8, exportTextStyle.throughlineStyle, exportTextStyle.throughlineColor);
                }
            }
        }
    }

    private Box drawURLLink(Render render, Offset offset, int n) {
        Box box = new Box();
        box.x = ExportToPDF.convertUnitToPoint(render.getX() + offset.dx + n) + (float)this._toolkit;
        box.y = ExportToPDF.convertUnitToPoint(render.getY() + offset.dy) + (float)this._type;
        box.width = ExportToPDF.convertUnitToPoint(render.getWidth());
        box.height = ExportToPDF.convertUnitToPoint(render.getHeight());
        return box;
    }

    private Box drawVShadow(JRVisiableResult jRVisiableResult, Offset offset, int n, int n2) {
        int n3;
        int n4;
        if (jRVisiableResult.getParent() instanceof DSTableCell) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = jRVisiableResult.getX() + n;
            n3 = this.getY(jRVisiableResult, n2);
        }
        int n5 = jRVisiableResult.getWidth();
        int n6 = jRVisiableResult.getHeight();
        return this.getLocation(offset, n4, n3, n5, n6);
    }

    Box getLocation(Offset offset, int n, int n2, int n3, int n4) {
        float f = ExportToPDF.convertUnitToPoint(n + offset.dx) + (float)this._toolkit;
        float f2 = ExportToPDF.convertUnitToPoint(n2 + offset.dy) + (float)this._type;
        float f3 = ExportToPDF.convertUnitToPoint(n3);
        float f4 = ExportToPDF.convertUnitToPoint(n4);
        return new Box(f, f2, f3, f4);
    }

    public static float convertUnitToPoint(float f) {
        return Unit.convertUnitToPixel(f, 72);
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.close = exportAuxInfo;
    }
}

