/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jet.bean.PDFParameter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.pdf.ExportToPDF;
import jet.export.pdf.PDFImporter;

public class PDFSpliter {
    PDFParameter _parameter;
    private static final int SEDU = 1;
    private long add;
    private int addSuffix;
    private int append;
    private String backupFile;
    private List backwardPages;
    private PDFImporter calculateAveragePagesOfSplitSize;
    private int cleanBackupFile;
    private static final int clear = -1;
    private static final String closeSourcePDFFile = ".temp";
    private ExportAuxInfo delete;
    private String deleteFile;

    public PDFSpliter(List list, PDFParameter pDFParameter, ExportAuxInfo exportAuxInfo) {
        this._parameter = pDFParameter;
        this.backwardPages = list;
        this.delete = exportAuxInfo;
    }

    void init() throws ExpException {
        this.calculateAveragePagesOfSplitSize = null;
        this.backupFile = (String)this.backwardPages.get(0);
        long l = PDFSpliter.getFileSize(this.backupFile);
        if (l > 0L) {
            this.add = PDFSpliter.getMaxPDFSize(this._parameter.getMaxSizeOfOneFile());
            this.addSuffix = this._parameter.getMaxPageOfOneFile();
            this.calculateAveragePagesOfSplitSize = new PDFImporter(this._parameter, this.delete);
            this.calculateAveragePagesOfSplitSize.openSourcePDFFile(this.backupFile);
            this.cleanBackupFile = this.calculateAveragePagesOfSplitSize.getTotalPagesNumberOfSourcePDF();
            this.calculateAveragePagesOfSplitSize(l);
        }
    }

    void calculateAveragePagesOfSplitSize(long l) {
        this.append = (int)(this.add / (l / (long)this.cleanBackupFile));
        if (this.append == 0) {
            this.append = 1;
        }
    }

    protected boolean splitBySize() throws ExpException {
        boolean bl = false;
        this.init();
        String string = null;
        int n = 1;
        long l = 0L;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n3 = this.estimateEndPageNumber(n);
            string = this.getSplitFileName(++n2);
            PDFSpliter.deleteFile(string, this.delete);
            this.calculateAveragePagesOfSplitSize.importPDFFile(string, n, n3);
            l = PDFSpliter.getFileSize(string);
            if (l > this.add) {
                n3 = this.backwardPages(string, n, n3);
            } else if (l < this.add) {
                n3 = this.forwardPages(string, n, n3);
            }
            if (n3 == this.cleanBackupFile) {
                arrayList.add(string);
                bl = true;
                break;
            }
            if (n3 == -1) {
                bl = false;
                break;
            }
            n = n3 + 1;
            arrayList.add(string);
        }
        this.calculateAveragePagesOfSplitSize.closeSourcePDFFile();
        if (bl) {
            PDFSpliter.renameFiles(this.backwardPages, arrayList, this.delete);
            PDFSpliter.deleteFile(this.backupFile, this.delete);
            arrayList = null;
        }
        return bl;
    }

    protected boolean splitByPage() throws ExpException {
        boolean bl = false;
        this.init();
        String string = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            n2 = (n2 += this.addSuffix) > this.cleanBackupFile ? this.cleanBackupFile : n2;
            string = this.getSplitFileName(++n3);
            PDFSpliter.deleteFile(string, this.delete);
            this.calculateAveragePagesOfSplitSize.importPDFFile(string, n, n2);
            if (n2 >= this.cleanBackupFile) {
                arrayList.add(string);
                bl = true;
                break;
            }
            if (n2 == -1) {
                bl = false;
                break;
            }
            n = n2 + 1;
            arrayList.add(string);
        }
        this.calculateAveragePagesOfSplitSize.closeSourcePDFFile();
        if (bl) {
            PDFSpliter.renameFiles(this.backwardPages, arrayList, this.delete);
            PDFSpliter.deleteFile(this.backupFile, this.delete);
            arrayList = null;
        }
        return bl;
    }

    static int getMaxPDFSize(int n) {
        int n2 = 0;
        if (n != -1) {
            n2 = n * 1000 * 1;
        }
        return n2;
    }

    int backwardPages(String string, int n, int n2) throws ExpException {
        long l = 0L;
        while (n != n2) {
            PDFSpliter.deleteFile(string, this.delete);
            this.calculateAveragePagesOfSplitSize.importPDFFile(string, n, --n2);
            l = PDFSpliter.getFileSize(string);
            if (l > this.add) continue;
            break;
        }
        return n2;
    }

    int forwardPages(String string, int n, int n2) throws ExpException {
        long l = 0L;
        while (n2 != this.cleanBackupFile) {
            this.backupFile(string);
            if (n == n2) {
                this.restoreFile(string);
                break;
            }
            this.calculateAveragePagesOfSplitSize.importPDFFile(string, n, ++n2);
            l = PDFSpliter.getFileSize(string);
            if (l <= this.add) continue;
            this.restoreFile(string);
            --n2;
            break;
        }
        this.cleanBackupFile();
        return n2;
    }

    int estimateEndPageNumber(int n) {
        int n2 = n + this.append;
        if (n2 > this.cleanBackupFile) {
            n2 = this.cleanBackupFile;
        }
        return n2;
    }

    void backupFile(String string) throws ExpException {
        if (this.deleteFile != null) {
            PDFSpliter.deleteFile(this.deleteFile, this.delete);
        }
        this.deleteFile = string + closeSourcePDFFile;
        PDFSpliter.renameFile(string, this.deleteFile, this.delete);
    }

    void cleanBackupFile() {
        if (this.deleteFile != null) {
            PDFSpliter.deleteFile(this.deleteFile, this.delete);
        }
    }

    void restoreFile(String string) throws ExpException {
        if (this.deleteFile != null) {
            PDFSpliter.deleteFile(string, this.delete);
            PDFSpliter.renameFile(this.deleteFile, string, this.delete);
            this.deleteFile = null;
        }
    }

    String getSplitFileName(int n) {
        String string = ExportToPDF.addSuffix(this.backupFile, "_" + n);
        return string;
    }

    static void renameFiles(List list, List list2, ExportAuxInfo exportAuxInfo) throws ExpException {
        int n = list2.size();
        list.remove(0);
        for (int i = 0; i < n; ++i) {
            String string = (String)list2.get(i);
            String string2 = ExportToPDF.addSuffix(string, "of" + String.valueOf(n));
            PDFSpliter.renameFile(string, string2, exportAuxInfo);
            list.add(string2);
        }
        list2.clear();
    }

    static long getFileSize(String string) {
        File file = new File(string);
        long l = 0L;
        if (file.isFile()) {
            l = file.length();
        }
        file = null;
        return l;
    }

    static boolean deleteFile(String string, ExportAuxInfo exportAuxInfo) {
        boolean bl = false;
        File file = new File(string);
        if (file.isFile()) {
            bl = file.delete();
            exportAuxInfo.getDiskStore().delete(file);
        }
        file = null;
        return bl;
    }

    static boolean renameFile(String string, String string2, ExportAuxInfo exportAuxInfo) throws ExpException {
        boolean bl = false;
        File file = new File(string);
        File file2 = new File(string2);
        if (file != null && file2 != null && file.isFile()) {
            bl = file.renameTo(file2);
            try {
                exportAuxInfo.getDiskStore().fileUpdated(new File(string));
                exportAuxInfo.getDiskStore().fileUpdated(file2);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, outOfSpaceException);
                }
                throw new ExpException(outOfSpaceException);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
                throw new ExpException(iOException);
            }
        }
        file = null;
        file2 = null;
        return bl;
    }
}

