/*
 * Decompiled with CFR 0.152.
 */
package jet.export.print;

import com.jinfonet.util.JRLog;
import java.awt.PrintJob;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JFrame;
import jet.JRStopEngineException;
import jet.bean.CustomMediaMargin;
import jet.bean.CustomMediaPaper;
import jet.datastream.Communicator;
import jet.export.ExportAuxInfo;
import jet.export.print.CustomerPaper;
import jet.export.print.JReportPrintListener;
import jet.export.print.JReportSwingPrintViewer_JDK11;
import jet.export.print.JReportSwingPrintViewer_JDK12;
import jet.export.print.JReportSwingPrintViewer_JDK14;
import jet.export.print.NoSuchPrintAttributeException;
import jet.util.JRInterruptedException;

public class JReportSwingPrinter {
    public static final int JDK11 = 0;
    public static final int JDK12 = 1;
    public static final int JDK14 = 2;
    private static final Object[][] DEFAULT = new Object[][]{{"default", CustomMediaPaper.DEFAULT}, {"Letter", CustomMediaPaper.NA_LETTER}, {"Legal", CustomMediaPaper.NA_LEGAL}, {"Executive", CustomMediaPaper.EXECUTIVE}, {"Ledger", CustomMediaPaper.LEDGER}, {"ISO-A4", CustomMediaPaper.ISO_A4}, {"ISO-A3", CustomMediaPaper.ISO_A3}, {"ISO-A2", CustomMediaPaper.ISO_A2}, {"ISO-A5", CustomMediaPaper.ISO_A5}, {"ISO-A6", CustomMediaPaper.ISO_A6}, {"ISO-A7", CustomMediaPaper.ISO_A7}, {"ISO-A8", CustomMediaPaper.ISO_A8}, {"ISO-A9", CustomMediaPaper.ISO_A9}, {"ISO-A10", CustomMediaPaper.ISO_A10}, {"ISO-A1", CustomMediaPaper.ISO_A1}, {"ISO-A0", CustomMediaPaper.ISO_A0}, {"B0(ISO/DIN)", CustomMediaPaper.ISO_B0}, {"B1(ISO/DIN)", CustomMediaPaper.ISO_B1}, {"B2(ISO/DIN)", CustomMediaPaper.ISO_B2}, {"B3(ISO/DIN)", CustomMediaPaper.ISO_B3}, {"B4(ISO/DIN)", CustomMediaPaper.ISO_B4}, {"B5(ISO/DIN)", CustomMediaPaper.ISO_B5}, {"B6(ISO/DIN)", CustomMediaPaper.ISO_B6}, {"B7(ISO/DIN)", CustomMediaPaper.ISO_B7}, {"B8(ISO/DIN)", CustomMediaPaper.ISO_B8}, {"B9(ISO/DIN)", CustomMediaPaper.ISO_B9}, {"B10(ISO/DIN)", CustomMediaPaper.ISO_B10}, {"C0(ISO/DIN)", CustomMediaPaper.ISO_C0}, {"C1(ISO/DIN)", CustomMediaPaper.ISO_C1}, {"C2(ISO/DIN)", CustomMediaPaper.ISO_C2}, {"C3(ISO/DIN)", CustomMediaPaper.ISO_C3}, {"C4(ISO/DIN)", CustomMediaPaper.ISO_C4}, {"C5(ISO/DIN)", CustomMediaPaper.ISO_C5}, {"C6(ISO/DIN)", CustomMediaPaper.ISO_C6}};

    public static void printInSameProcess(JFrame jFrame, Communicator communicator, Object object, boolean bl, Object object2, boolean bl2, JReportPrintListener jReportPrintListener, boolean bl3, boolean bl4, boolean bl5, String string, String string2, ExportAuxInfo exportAuxInfo) throws JRStopEngineException {
        block5: {
            if (bl3) {
                JReportSwingPrintViewer_JDK11.print(jFrame, communicator, (PrintJob)object, bl2, bl, bl4, bl5, string, string2);
                return;
            }
            try {
                Vector vector = new Vector();
                JReportSwingPrinter.printInSameProcess(jFrame, communicator, object, bl, object2, bl2, jReportPrintListener, 1, bl4, bl5, null, vector, null, exportAuxInfo);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JReportSwingPrinter JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                JReportSwingPrintViewer_JDK12.print(jFrame, communicator, (PrinterJob)object, bl, (PageFormat)object2, bl2, jReportPrintListener, bl4, bl5, string);
                if (!JRLog.isTrace(5)) break block5;
                JRLog.trace(5, exception);
            }
        }
    }

    public static void printInSameProcess(JFrame jFrame, Communicator communicator, Object object, boolean bl, Object object2, boolean bl2, JReportPrintListener jReportPrintListener, int n, boolean bl3, boolean bl4, String string, Vector vector, String string2, ExportAuxInfo exportAuxInfo) throws NoSuchPrintAttributeException, JRStopEngineException {
        try {
            switch (n) {
                case 0: {
                    JReportSwingPrintViewer_JDK11.print(jFrame, communicator, (PrintJob)object, bl2, bl, bl3, bl4, string, string2);
                    break;
                }
                case 1: {
                    JReportSwingPrintViewer_JDK12.print(jFrame, communicator, (PrinterJob)object, bl, (PageFormat)object2, bl2, jReportPrintListener, bl3, bl4, string);
                    break;
                }
                case 2: {
                    if (JReportSwingPrinter.isJDK14Compatible()) {
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "print_JDK14 begin");
                        }
                        Vector<CustomMediaMargin> vector2 = new Vector<CustomMediaMargin>();
                        JReportSwingPrintViewer_JDK14.setPagination(bl4);
                        vector2.add(new CustomMediaMargin(7.0f, 7.0f, 7.0f, 7.0f, 1000));
                        JReportSwingPrinter.printJDK14(jFrame, communicator, bl, bl2, jReportPrintListener, bl3, string, vector, vector2, string2, exportAuxInfo);
                        if (JRLog.isTrace(5)) {
                            JRLog.trace(5, "print_JDK14 return");
                        }
                        break;
                    }
                    JReportSwingPrintViewer_JDK12.print(jFrame, communicator, (PrinterJob)object, bl, (PageFormat)object2, bl2, jReportPrintListener, bl3, bl4, string);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new NoSuchPrintAttributeException(runtimeException);
        }
    }

    public static void print_JDK14(JFrame jFrame, Communicator[] communicatorArray, boolean bl, boolean bl2, JReportPrintListener jReportPrintListener, boolean bl3, String string, Vector vector, Vector vector2, String string2, ExportAuxInfo exportAuxInfo) throws NoSuchPrintAttributeException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "print_JDK14 begin");
        }
        long l = System.currentTimeMillis();
        JReportSwingPrintViewer_JDK14.print_JDK14(jFrame, communicatorArray, bl, bl2, jReportPrintListener, bl3, string, vector, vector2, string2, exportAuxInfo);
        long l2 = System.currentTimeMillis();
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "print_JDK14 return");
            JRLog.trace(5, "print JDK14 elapsed:" + (l2 - l));
        }
    }

    public static void printJDK14(JFrame jFrame, Communicator communicator, boolean bl, boolean bl2, JReportPrintListener jReportPrintListener, boolean bl3, String string, Vector vector, Vector vector2, String string2, ExportAuxInfo exportAuxInfo) throws NoSuchPrintAttributeException {
        if (JRLog.isTrace(5)) {
            JRLog.trace(4, "print_JDK14 begin");
        }
        Long l = System.currentTimeMillis();
        try {
            JReportSwingPrintViewer_JDK14.print_JDK14(jFrame, communicator, bl, bl2, jReportPrintListener, bl3, string, vector, vector2, string2);
        }
        catch (RuntimeException runtimeException) {
            throw new NoSuchPrintAttributeException(runtimeException);
        }
        Long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, "print_JDK14 return");
            JRLog.trace(5, "print JDK14 Elapsed:" + l3);
        }
    }

    static boolean isJDK14Compatible() {
        String string = System.getProperty("java.version");
        int n = string.indexOf("version");
        if (n != -1) {
            string = string.substring(n);
        }
        return string.compareTo("1.4.0") >= 0;
    }

    static boolean isJDK13Compatible() {
        return System.getProperty("java.version").indexOf("1.3") != -1;
    }

    static boolean isJDK12Compatible() {
        return System.getProperty("java.version").indexOf("1.2") != -1;
    }

    public static String[] getPaperList() {
        int n = DEFAULT.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)DEFAULT[i][0];
        }
        return stringArray;
    }

    public static CustomMediaPaper getCustomMediaPaper(String string) {
        int n = -1;
        for (int i = 0; i < DEFAULT.length; ++i) {
            if (!DEFAULT[i][0].equals(string)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            return (CustomMediaPaper)DEFAULT[n][1];
        }
        CustomerPaper customerPaper = new CustomerPaper();
        customerPaper.setPaperName(string);
        return customerPaper;
    }
}

