/*
 * Decompiled with CFR 0.152.
 */
package jet.export.print;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jet.JViewResource;

class PrintSwingSettingDialog
extends JDialog
implements ActionListener,
FocusListener {
    private JFrame InitControls;
    private JRadioButton InitData;
    private JRadioButton SEDU;
    private JTextField add;
    private JTextField addActionListener;
    private JButton addExitListener;
    private JComboBox addFocusListener;
    private JButton addItem;
    private JButton append;
    static int[] aiDPIS = new int[]{72, 75, 150, 300, 600, 1200, 1440};
    static String[] astrDPIItems = new String[]{JViewResource.getMessage("TV_6"), JViewResource.getMessage("TV_7"), JViewResource.getMessage("TV_8"), JViewResource.getMessage("TV_9"), JViewResource.getMessage("TV_10"), JViewResource.getMessage("TV_11"), JViewResource.getMessage("TV_12")};
    private static String black = JViewResource.getMessage("TV_13");
    private static float clickCancel = 3.5f;
    protected boolean bIsOk = false;
    private boolean clickOK;
    private int clickTest;
    private int dispose;
    private int drawLine;
    private int drawString;

    PrintSwingSettingDialog(JFrame jFrame, int n, int n2) {
        super((Frame)jFrame, "Print");
        this.InitControls = jFrame;
        this.drawLine = n;
        this.drawString = n2 == -1 ? 9999 : n2;
        this.InitControls();
        this.InitData();
        this.setVisible(true);
    }

    protected boolean InitControls() {
        this.setBounds(200, 200, 420, 365);
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setModal(true);
        JPanel jPanel = new JPanel(null);
        jPanel.setBounds(10, 5, 394, 90);
        jPanel.setLayout(null);
        jPanel.setBorder(new TitledBorder(" Print Range "));
        this.InitData = new JRadioButton("Print all page(s)");
        this.InitData.setBounds(20, 20, 135, 23);
        this.InitData.addActionListener(this);
        this.SEDU = new JRadioButton("Print page(s)");
        this.SEDU.setBounds(20, 50, 145, 23);
        this.SEDU.addActionListener(this);
        this.SEDU.setSelected(false);
        JLabel jLabel = new JLabel("From : ");
        jLabel.setBounds(165, 50, 50, 23);
        this.add = new JTextField("");
        this.add.setBounds(220, 50, 40, 23);
        JLabel jLabel2 = new JLabel(" To : ");
        jLabel2.setBounds(260, 50, 40, 23);
        this.addActionListener = new JTextField("");
        this.addActionListener.setBounds(300, 50, 40, 23);
        jPanel.add(jLabel);
        jPanel.add(this.add);
        jPanel.add(jLabel2);
        jPanel.add(this.addActionListener);
        jPanel.add(this.SEDU);
        jPanel.add(this.InitData);
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBorder(new TitledBorder(" Calibration Test "));
        jPanel2.setBounds(10, 105, 394, 175);
        JLabel jLabel3 = new JLabel("Click the Test button to print a Calibration page which contains");
        jLabel3.setBounds(10, 20, 390, 23);
        JLabel jLabel4 = new JLabel("serveral rows of test and lines.");
        jLabel4.setBounds(10, 40, 390, 23);
        jPanel2.add(jLabel3);
        jPanel2.add(jLabel4);
        this.addExitListener = new JButton("Test");
        this.addItem = new JButton("OK");
        this.append = new JButton("Cancel");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBounds(12, 57, 95, 40);
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(this.addExitListener);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.setBounds(88, 283, 200, 40);
        jPanel4.add(this.addItem);
        jPanel4.add(this.append);
        jPanel2.add(jPanel3);
        this.getContentPane().add(jPanel4);
        JLabel jLabel5 = new JLabel("Enter the line number for the best matching set of text and lines.");
        jLabel5.setBounds(10, 100, 390, 23);
        jPanel2.add(jLabel5);
        JLabel jLabel6 = new JLabel("Line Number : ");
        jLabel6.setBounds(20, 125, 100, 23);
        jPanel2.add(jLabel6);
        this.addFocusListener = new JComboBox();
        this.addFocusListener.setBounds(110, 125, 110, 23);
        jPanel2.add(this.addFocusListener);
        this.getContentPane().add(jPanel2);
        this.add.addFocusListener(this);
        this.addActionListener.addFocusListener(this);
        this.addExitListener.addActionListener(this);
        this.addItem.addActionListener(this);
        this.append.addActionListener(this);
        this.addExitListener();
        return true;
    }

    protected void printDPICalibrationPaper() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this.InitControls, JViewResource.getMessage("TV_4"), new Properties());
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            this.paintDPICalibrationPaper(graphics);
            graphics.dispose();
            printJob.end();
            printJob = null;
        }
    }

    public void clickOK() {
        this.clickOK = this.InitData.isSelected();
        if (!this.clickOK) {
            try {
                this.clickTest = Integer.parseInt(this.add.getText());
                this.dispose = Integer.parseInt(this.addActionListener.getText());
                if (this.clickTest <= 0 || this.dispose <= 0) {
                    JOptionPane.showMessageDialog(this.InitControls, JViewResource.getMessage("TV_1", (Object)String.valueOf(this.drawString)), JViewResource.getMessage("TV_WARNING"), 0);
                    return;
                }
                if (this.clickTest > this.drawString || this.dispose > this.drawString) {
                    JOptionPane.showMessageDialog(this.InitControls, JViewResource.getMessage("TV_1", (Object)String.valueOf(this.drawString)), JViewResource.getMessage("TV_WARNING"), 0);
                    return;
                }
                if (this.clickTest > this.dispose) {
                    JOptionPane.showMessageDialog(this.InitControls, JViewResource.getMessage("TV_2"), JViewResource.getMessage("TV_WARNING"), 0);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.InitControls, JViewResource.getMessage("TV_3"), JViewResource.getMessage("TV_WARNING"), 0);
                return;
            }
        }
        String string = (String)this.addFocusListener.getSelectedItem();
        this.drawLine = this.getDPIByItem(string);
        this.bIsOk = true;
        this.dispose();
    }

    protected void InitData() {
        this.InitData.setSelected(true);
        this.add.setText("1");
        this.addActionListener.setText(String.valueOf(this.drawString));
        int n = 0;
        do {
            this.addFocusListener.addItem(astrDPIItems[n]);
        } while (++n < 7);
        this.addFocusListener.setSelectedItem(this.getItemByDPI(this.drawLine));
        if (this.addFocusListener.getSelectedIndex() < 0) {
            this.addFocusListener.setSelectedIndex(0);
        }
    }

    public int getFromPage() {
        if (this.bIsOk) {
            return this.clickTest;
        }
        return -1;
    }

    public int getToPage() {
        if (this.bIsOk) {
            return this.dispose;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.addItem)) {
            this.clickOK();
            return;
        }
        if (object.equals(this.append)) {
            this.clickCancel();
            return;
        }
        if (object.equals(this.addExitListener)) {
            this.clickTest();
            return;
        }
        if (object.equals(this.InitData)) {
            this.InitData.setSelected(true);
            this.SEDU.setSelected(false);
            return;
        }
        if (object.equals(this.SEDU)) {
            this.SEDU.setSelected(true);
            this.InitData.setSelected(false);
            return;
        }
    }

    public void clickCancel() {
        this.bIsOk = false;
        this.dispose();
    }

    protected String getItemByDPI(int n) {
        int n2 = 0;
        do {
            if (n != aiDPIS[n2]) continue;
            return astrDPIItems[n2];
        } while (++n2 < 6);
        return null;
    }

    protected void paintDPICalibrationPaper(Graphics graphics) {
        graphics.setFont(new Font("Courier", 0, 14));
        graphics.setColor(Color.black);
        int n = 50;
        int n2 = 80;
        graphics.drawString(JViewResource.getMessage("TV_5"), n, n2);
        int n3 = n + 30;
        int n4 = n2 + 70;
        for (int i = 0; i < aiDPIS.length; ++i) {
            int n5 = aiDPIS[i];
            graphics.drawString(i + 1 + ": ", n, n4);
            graphics.drawString(black, n3, n4);
            graphics.drawLine(n3, n4, n3 + (int)(clickCancel * (float)n5), n4);
            n4 += 50;
        }
    }

    public boolean isPrintAll() {
        if (this.bIsOk) {
            return this.clickOK;
        }
        return false;
    }

    public boolean isOKClick() {
        return this.bIsOk;
    }

    public void clickTest() {
        this.printDPICalibrationPaper();
    }

    protected int getDPIByItem(String string) {
        int n = 0;
        if (string != null) {
            do {
                if (!string.equals(astrDPIItems[n])) continue;
                return aiDPIS[n];
            } while (++n < 6);
        }
        return -1;
    }

    protected void addExitListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PrintSwingSettingDialog.this.dispose();
            }
        });
    }

    public int getDPI() {
        if (this.bIsOk) {
            return this.drawLine;
        }
        return -1;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object.equals(this.add) || object.equals(this.addActionListener)) {
            this.SEDU.setSelected(true);
            this.InitData.setSelected(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }
}

