/*
 * Decompiled with CFR 0.152.
 */
package jet.export.relayout.table.imp;

import java.util.ArrayList;
import java.util.List;
import jet.datastream.DSTableRow;
import jet.export.relayout.table.LogicRow;
import jet.export.relayout.table.TableCellWrap;
import jet.export.relayout.table.imp.CellWrapper;
import jet.export.relayout.table.imp.RectInfo;

class LogicRowImp
implements LogicRow {
    private List SEDU = new ArrayList();
    private DSTableRow add;
    private int get = 0;
    private boolean getColIndex = false;
    private boolean getColSpan;
    private int w;
    private int h;
    private int getHeight = 0;
    private CellWrapper[] getObjectType = null;

    LogicRowImp(DSTableRow dSTableRow, boolean bl, boolean bl2) {
        this.add = dSTableRow;
        this.w = this.add.getWidth();
        this.h = this.add.getHeight();
        this.getColIndex = bl;
        this.getColSpan = bl2;
    }

    @Override
    public boolean isContinue() {
        return this.getColIndex;
    }

    @Override
    public boolean hasMoreChild() {
        return this.get < this.SEDU.size();
    }

    @Override
    public TableCellWrap nextChild() {
        return (TableCellWrap)this.SEDU.get(this.get++);
    }

    @Override
    public int getHeight() {
        return this.h;
    }

    @Override
    public int getWidth() {
        return this.w;
    }

    void setWidthHeight(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    @Override
    public byte getType() {
        return 0;
    }

    void addCell(CellWrapper cellWrapper) {
        this.SEDU.add(cellWrapper);
    }

    void setCellNull(int n) {
        this.SEDU.set(n, null);
    }

    void removeNullCell() {
        for (int i = this.SEDU.size() - 1; i >= 0; --i) {
            if (this.SEDU.get(i) != null) continue;
            this.SEDU.remove(i);
        }
    }

    boolean isNullRow() {
        return this.SEDU.size() == 0;
    }

    int size() {
        return this.SEDU.size();
    }

    @Override
    public DSTableRow getRow() {
        return this.add;
    }

    boolean isTableHeader() {
        return this.add.getObjectType() == 0x1000004;
    }

    void addReduceValue(int n) {
        this.getHeight += n;
    }

    void setReduce(int n) {
        this.getHeight = n;
    }

    @Override
    public int getX() {
        if (this.getColSpan) {
            return this.add.getX() - this.getHeight;
        }
        return this.add.getX();
    }

    @Override
    public int getY() {
        if (this.getColSpan) {
            return this.add.getY();
        }
        return this.add.getY() - this.getHeight;
    }

    int getReduce() {
        return this.getHeight;
    }

    @Override
    public int getDSObjectType() {
        return this.add.getObjectType();
    }

    boolean[] getNullColumnFlag(boolean[] blArray) {
        int n;
        if (this.SEDU.size() == 0) {
            return blArray;
        }
        if (blArray == null) {
            n = this.SEDU();
            blArray = new boolean[n];
        }
        n = blArray.length;
        this.getObjectType = new CellWrapper[n];
        for (int i = 0; i < this.SEDU.size(); ++i) {
            CellWrapper cellWrapper = (CellWrapper)this.SEDU.get(i);
            int n2 = cellWrapper.getColIndex(this.getColSpan);
            if (cellWrapper.isHideCell(this.getColSpan)) {
                blArray[n2] = true;
            }
            this.getObjectType[n2] = cellWrapper;
        }
        return blArray;
    }

    void removeNullCol(int[] nArray) {
        int n;
        if (this.getObjectType == null) {
            return;
        }
        if (nArray == null) {
            this.getObjectType = null;
            return;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = nArray[n];
            RectInfo rectInfo = null;
            for (int i = n2; i >= 0 && (rectInfo = this.getObjectType[i]) == null; --i) {
            }
            if (rectInfo == null) continue;
            int n3 = rectInfo.getColSpan();
            if (n3 == 1 && ((CellWrapper)rectInfo).isHideCell(this.getColSpan)) {
                this.getObjectType[i] = null;
                continue;
            }
            rectInfo.setColSpan(n3 - 1);
        }
        this.SEDU = new ArrayList();
        for (n = 0; n < this.getObjectType.length; ++n) {
            CellWrapper cellWrapper = this.getObjectType[n];
            if (cellWrapper == null) continue;
            this.SEDU.add(cellWrapper);
        }
        this.getObjectType = null;
    }

    private int SEDU() {
        int n = 0;
        for (int i = 0; i < this.SEDU.size(); ++i) {
            CellWrapper cellWrapper = (CellWrapper)this.SEDU.get(i);
            int n2 = cellWrapper.getColIndex(this.getColSpan) + cellWrapper.getColSpan();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }
}

