/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Stack;
import jet.JRStopEngineException;
import jet.JResource;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExpException;
import jet.export.relayout.table.RectCell;
import jet.export.relayout.table.Row;
import jet.export.rtf.BaseTool;
import jet.export.rtf.LinkInfo;
import jet.export.rtf.RtfCache;
import jet.export.rtf.api.DocPage;
import jet.export.rtf.api.Factory;
import jet.export.rtf.api.FillInfo;
import jet.export.rtf.api.GradientInfo;
import jet.export.rtf.api.ImageInfo;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.api.PageInfo;
import jet.export.rtf.api.RTFDoc;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;
import jet.export.util.DrawBorderAdapter;
import jet.export.util.ExportUtil;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.ImageEngine;
import jet.util.Propertiable;

abstract class BaseRtfExport
extends BaseTool {
    private RTFDoc BORDERJOINT_ROUND;
    protected DocPage docPage;
    private static final int BorderIsRound = 20;
    protected Factory rtfObjfactory;
    private static final String[] ConvertBorderProperties = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    protected static final String[] NEWBORDERWIDTH = new String[]{"border-top-width", "border-left-width", "border-bottom-width", "border-right-width"};
    protected static final String[] NEWBORDERCOLOR = new String[]{"border-top-color", "border-left-color", "border-bottom-color", "border-right-color"};
    protected ImageEngine imageEngine = null;
    protected Stack offsets;
    private static final int ConvertProperties = 4;
    protected static final int NONE_LINE = 0;
    private static final int FILL_COLOR = 1;
    private static final int FILL_GRADIENT = 2;
    private static final int FILL_IMAGE = 3;
    private static final int SEDU = 4;
    private static final int addPage = 5;
    protected static final int TOP = 0;
    protected static final int LEFT = 1;
    protected static final int BOTTOM = 2;
    protected static final int RIGHT = 3;
    private LineInfo append = new LineInfo();
    private LineInfo background = new LineInfo();
    private LineInfo canBeReuse = new LineInfo();
    private LineInfo checkStop = new LineInfo();
    protected static final int CENTER_X = 2;
    protected static final int CENTER_Y = 1;
    protected static final int DELTA_X = 3;
    protected static final int DELTA_Y = 2;
    protected static final int TOP_LINE = 20;
    protected static final int BOTTOM_LINE = 12;
    protected static final int LINE_SPACEING = 280;
    protected static final String EVAL = "JReport Evaluation Copy";
    protected static final String CONTACT = "to purchase contact " + JResource.getMessage("Sale");
    protected static final String PHONE = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
    protected static final String EVALFONT = "Arial Narrow";
    protected static Font FT = new Font("Arial Narrow", 0, 20);
    protected static Font FB = new Font("Arial Narrow", 0, 12);
    protected static final FontRenderContext FTR = new FontRenderContext(FT.getTransform(), false, true);
    protected static final FontRenderContext FBR = new FontRenderContext(FT.getTransform(), false, true);
    protected static final Color DEF_COLOR = Color.cyan;
    protected static final int TH = (int)(FT.getStringBounds("JReport Evaluation Copy", FTR).getHeight() * 20.0);
    protected static final int BH = (int)(FB.getStringBounds(CONTACT, FBR).getHeight() * 20.0);
    protected static final int TW = (int)(FT.getStringBounds("JReport Evaluation Copy", FTR).getWidth() * 20.0);
    protected static final int BW1 = (int)(FB.getStringBounds(CONTACT, FBR).getWidth() * 20.0) + 500;
    protected static final int BW2 = (int)(FB.getStringBounds(PHONE, FBR).getWidth() * 20.0) + 500;
    protected static final int TEXT_RENDER = 0;
    protected static final int TEXT_FIELD_RENDER = 4;
    private Communicator[] clear;
    private boolean convertInchToPixel;
    private int convertPixelToUnit = 0;
    private int createObjFactory = 0;
    private int createPage = -1;
    private int currentTimeMillis = Integer.MAX_VALUE;
    private Communicator cyan;

    BaseRtfExport(Communicator[] communicatorArray, boolean bl) {
        this.clear = communicatorArray;
        this.convertInchToPixel = !bl;
        this.imageEngine = new ImageEngine();
        this.imageEngine.setResolusion(96);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(BufferedOutputStream bufferedOutputStream, File file) throws IOException, JRStopEngineException, ExpException, OutOfSpaceException {
        try {
            this.BORDERJOINT_ROUND(file);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        String string = this.clear[0].getEncoding();
        if (string == null || string.trim().length() == 0) {
            string = "UTF-8";
        }
        this.createObjFactory(string);
        this.BORDERJOINT_ROUND = this.rtfObjfactory.getDoc();
        this.initalValible();
        try {
            int n = 0;
            block8: for (int i = 0; i < this.clear.length; ++i) {
                Communicator communicator = this.clear[i];
                if (communicator == null) {
                    this.logCommunicatorNullInfo(i);
                    continue;
                }
                this.BH(communicator);
                int n2 = communicator.getResolution();
                try {
                    communicator.setResolution(96);
                    this.cache.setBaseCommunicator(communicator);
                    boolean bl = ((DataStream)communicator.getDataStream(0)).ie() == 1;
                    CommEnumeration commEnumeration = new CommEnumeration(communicator);
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    Stack<Communicator> stack = new Stack<Communicator>();
                    stack.push(communicator);
                    Color color = communicator.getHeaderInfo((int)0).background;
                    boolean bl2 = false;
                    this.createObjFactory += n;
                    n = 0;
                    while (commEnumeration.hasMoreElements()) {
                        int n8;
                        int n9;
                        ++this.convertPixelToUnit;
                        ++n;
                        ExportUtil.checkStop(communicator);
                        if (++n7 < this.createPage) {
                            commEnumeration.nextElement();
                            continue;
                        }
                        this.cyan = commEnumeration.getCurrentCommunicator();
                        if (!this.cyan.equals(stack.peek())) {
                            stack.push(this.cyan);
                            bl2 = true;
                        }
                        DSPage dSPage = (DSPage)commEnumeration.nextElement();
                        Rectangle rectangle = dSPage.getPageArea();
                        Rectangle rectangle2 = dSPage.getPrintableArea();
                        if (rectangle.getWidth() > 126720.0) {
                            n9 = 126720;
                            n3 = 0;
                            n5 = 0;
                        } else {
                            n9 = rectangle.width;
                            if (this.convertInchToPixel) {
                                n3 = this.unitToTwip(rectangle2.x);
                                n5 = this.unitToTwip(rectangle.width - (rectangle2.x + rectangle2.width));
                            }
                        }
                        if (rectangle.getHeight() > 126720.0) {
                            n8 = 126720;
                            n4 = 0;
                            n6 = 0;
                        } else {
                            n8 = rectangle.height;
                            if (this.convertInchToPixel) {
                                n4 = this.unitToTwip(rectangle2.y);
                                n6 = this.unitToTwip(rectangle.height - (rectangle2.y + rectangle2.height));
                            }
                        }
                        int n10 = this.unitToTwip(n9);
                        int n11 = this.unitToTwip(n8);
                        PageInfo pageInfo = new PageInfo(n10, n11, n3, n4, n5, n6, color);
                        this.docPage = this.rtfObjfactory.createPage(pageInfo);
                        this.writePage(dSPage, bl2);
                        if (bl) {
                            this.writeEvaluation();
                        }
                        this.BORDERJOINT_ROUND.addPage(this.docPage);
                        if (n7 != this.currentTimeMillis) continue;
                        continue block8;
                    }
                    continue;
                }
                finally {
                    communicator.setResolution(n2);
                }
            }
            this.BORDERJOINT_ROUND.output(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        finally {
            if (this.BORDERJOINT_ROUND != null) {
                this.BORDERJOINT_ROUND.free();
                this.BORDERJOINT_ROUND = null;
            }
            this.clear();
        }
    }

    void setObjFactory(Factory factory) {
        this.rtfObjfactory = factory;
    }

    private void BH(Communicator communicator) throws ExpException {
        long l = System.currentTimeMillis();
        communicator.waitFinished();
        long l2 = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4406005, l2 - l);
        }
    }

    protected String getCurPageBookMark() {
        return this.getBookMark(this.convertPixelToUnit);
    }

    protected LinkInfo getLinkInfo(JRVisiableResult jRVisiableResult) throws JRStopEngineException {
        String string;
        int n;
        int n2 = jRVisiableResult.getLinkComm();
        LinkInfo linkInfo = n2 != -1 ? ((n = this.cache.getPageNumber(this.cyan, jRVisiableResult)) != -1 ? new LinkInfo(this.getBookMark(this.createObjFactory + n), true) : null) : ((string = this.cyan.getLinkedInfo(jRVisiableResult.getLinkCondition())) != null ? new LinkInfo(string, false) : null);
        return linkInfo;
    }

    protected abstract void createObjFactory(String var1);

    protected abstract void writeEvaluation() throws IOException, OutOfSpaceException;

    protected abstract void writePage(DSPage var1, boolean var2) throws IOException, JRStopEngineException, ExpException;

    protected void initalValible() {
        this.offsets = new Stack();
    }

    protected void clear() {
        if (this.cache != null) {
            this.cache.clear();
            this.cache = null;
        }
    }

    protected void deleteFile(File file) {
        if (file != null) {
            if (file.isFile() && file.exists()) {
                file.delete();
            } else if (file.isDirectory() && file.exists()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.deleteFile(fileArray[i]);
                    }
                }
                file.delete();
            }
        }
    }

    private void BORDERJOINT_ROUND(File file) throws OutOfSpaceException, IOException {
        this.cache = new RtfCache(this.exportAuxInfo, "rtf");
    }

    protected int unitToTwip(int n) {
        return this.cache.unitToTwip(n);
    }

    protected int inchToTwip(int n) {
        return Unit.convertInchToPixel(n, 1440);
    }

    protected int twipToUnit(int n) {
        return Unit.convertPixelToUnit(n, 1440);
    }

    protected LineInfo[] getRowBorder(Row row) {
        LineInfo[] lineInfoArray = new LineInfo[4];
        if (row.hasLeftBorder()) {
            lineInfoArray[1] = new LineInfo();
            lineInfoArray[1].setColor(row.getLeftBorderColor());
            this.setLineStyle(lineInfoArray[1], row.getLeftBorderStyle());
            lineInfoArray[1].setLineWidth(this.unitToTwip(row.getLeftBorderWidth()));
        }
        if (row.hasTopBorder()) {
            lineInfoArray[0] = new LineInfo();
            lineInfoArray[0].setColor(row.getTopBorderColor());
            this.setLineStyle(lineInfoArray[0], row.getTopBorderStyle());
            lineInfoArray[0].setLineWidth(this.unitToTwip(row.getTopBorderWidth()));
        }
        if (row.hasRightBorder()) {
            lineInfoArray[3] = new LineInfo();
            lineInfoArray[3].setColor(row.getRightBorderColor());
            this.setLineStyle(lineInfoArray[3], row.getRightBorderStyle());
            lineInfoArray[3].setLineWidth(this.unitToTwip(row.getRightBorderWidth()));
        }
        if (row.hasBottomBorder()) {
            lineInfoArray[2] = new LineInfo();
            lineInfoArray[2].setColor(row.getBottomBorderColor());
            this.setLineStyle(lineInfoArray[2], row.getBottomBorderStyle());
            lineInfoArray[2].setLineWidth(this.unitToTwip(row.getBottomBorderWidth()));
        }
        return lineInfoArray;
    }

    protected LineInfo[] getCellBorder(RectCell rectCell) {
        LineInfo[] lineInfoArray = new LineInfo[4];
        if (rectCell.hasLeftBorder()) {
            lineInfoArray[1] = new LineInfo();
            lineInfoArray[1].setColor(rectCell.getLeftBorderColor());
            this.setLineStyle(lineInfoArray[1], rectCell.getLeftBorderStyle());
            lineInfoArray[1].setLineWidth(this.unitToTwip(rectCell.getLeftBorderWidth()));
        }
        if (rectCell.hasTopBorder()) {
            lineInfoArray[0] = new LineInfo();
            lineInfoArray[0].setColor(rectCell.getTopBorderColor());
            this.setLineStyle(lineInfoArray[0], rectCell.getTopBorderStyle());
            lineInfoArray[0].setLineWidth(this.unitToTwip(rectCell.getTopBorderWidth()));
        }
        if (rectCell.hasRightBorder()) {
            lineInfoArray[3] = new LineInfo();
            lineInfoArray[3].setColor(rectCell.getRightBorderColor());
            this.setLineStyle(lineInfoArray[3], rectCell.getRightBorderStyle());
            lineInfoArray[3].setLineWidth(this.unitToTwip(rectCell.getRightBorderWidth()));
        }
        if (rectCell.hasBottomBorder()) {
            lineInfoArray[2] = new LineInfo();
            lineInfoArray[2].setColor(rectCell.getBottomBorderColor());
            this.setLineStyle(lineInfoArray[2], rectCell.getBottomBorderStyle());
            lineInfoArray[2].setLineWidth(this.unitToTwip(rectCell.getBottomBorderWidth()));
        }
        return lineInfoArray;
    }

    protected LineInfo[] getBorderInfo(JRVisiableResult jRVisiableResult) {
        Color[] colorArray;
        int[] nArray;
        int[] nArray2 = this.getBorderStyle(jRVisiableResult);
        if (jRVisiableResult.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            nArray = this.getBorderWidth(jRVisiableResult, true);
            colorArray = this.getBorderColor(jRVisiableResult, true);
        } else {
            nArray = this.getBorderWidth(jRVisiableResult, false);
            colorArray = this.getBorderColor(jRVisiableResult, false);
        }
        LineInfo lineInfo = this.append.canBeReuse() ? this.append : new LineInfo();
        LineInfo lineInfo2 = this.canBeReuse.canBeReuse() ? this.canBeReuse : new LineInfo();
        LineInfo lineInfo3 = this.background.canBeReuse() ? this.background : new LineInfo();
        LineInfo lineInfo4 = this.checkStop.canBeReuse() ? this.checkStop : new LineInfo();
        this.setLineStyle(lineInfo, nArray2[1]);
        this.setLineStyle(lineInfo3, nArray2[0]);
        this.setLineStyle(lineInfo2, nArray2[3]);
        this.setLineStyle(lineInfo4, nArray2[2]);
        lineInfo.setColor(colorArray[1]);
        lineInfo3.setColor(colorArray[0]);
        lineInfo2.setColor(colorArray[3]);
        lineInfo4.setColor(colorArray[2]);
        lineInfo.setLineWidth(this.unitToTwip(nArray[1]));
        lineInfo3.setLineWidth(this.unitToTwip(nArray[0]));
        lineInfo2.setLineWidth(this.unitToTwip(nArray[3]));
        lineInfo4.setLineWidth(this.unitToTwip(nArray[2]));
        LineInfo[] lineInfoArray = new LineInfo[4];
        if (lineInfo.getLineWidth() > 0L) {
            lineInfoArray[1] = lineInfo;
        }
        if (lineInfo3.getLineWidth() > 0L) {
            lineInfoArray[0] = lineInfo3;
        }
        if (lineInfo2.getLineWidth() > 0L) {
            lineInfoArray[3] = lineInfo2;
        }
        if (lineInfo4.getLineWidth() > 0L) {
            lineInfoArray[2] = lineInfo4;
        }
        return lineInfoArray;
    }

    protected int[] getBorderStyle(JRVisiableResult jRVisiableResult) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = this.getIntProperty(jRVisiableResult, ConvertBorderProperties[i]);
        }
        return nArray;
    }

    protected boolean borderStyleCanBeStrore(JRVisiableResult jRVisiableResult) {
        for (int i = 0; i < 4; ++i) {
            if (!this.isChangeByFormularProperty(jRVisiableResult, ConvertBorderProperties[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isChangeByFormularProperty(JRObjectResult jRObjectResult, String string) {
        return CCUtil.isChangeByFormularProperty(jRObjectResult, string);
    }

    protected boolean isChangeByFormularNewProperty(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getTemplate().getPropertyByName(string);
        return propertiable != null && propertiable.isChangeByOther();
    }

    protected int[] getBorderWidth(JRVisiableResult jRVisiableResult, boolean bl) {
        int[] nArray = new int[4];
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = this.getNewIntProperty(jRVisiableResult, NEWBORDERWIDTH[i]);
            }
        } else {
            int n = this.getIntProperty(jRVisiableResult, "BorderWidth");
            for (int i = 0; i < 4; ++i) {
                nArray[i] = n;
            }
        }
        return nArray;
    }

    protected boolean borderWidthCanBeStore(JRVisiableResult jRVisiableResult, boolean bl) {
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                if (!this.isChangeByFormularNewProperty(jRVisiableResult, NEWBORDERWIDTH[i])) continue;
                return false;
            }
            return true;
        }
        return !this.isChangeByFormularProperty(jRVisiableResult, "BorderWidth");
    }

    protected Color[] getBorderColor(JRVisiableResult jRVisiableResult, boolean bl) {
        Color[] colorArray = new Color[4];
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                colorArray[i] = this.getNewColorProperty(jRVisiableResult, NEWBORDERCOLOR[i]);
            }
        } else {
            Color color = this.getColorProperty(jRVisiableResult, "BorderColor");
            for (int i = 0; i < 4; ++i) {
                colorArray[i] = color;
            }
        }
        return colorArray;
    }

    protected boolean borderColorCanBeStore(JRVisiableResult jRVisiableResult, boolean bl) {
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                if (!this.isChangeByFormularNewProperty(jRVisiableResult, NEWBORDERCOLOR[i])) continue;
                return false;
            }
            return true;
        }
        return !this.isChangeByFormularProperty(jRVisiableResult, "BorderColor");
    }

    protected void setLineStyle(LineInfo lineInfo, int n) {
        switch (n) {
            case 1: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)6);
                break;
            }
            case 2: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)9);
                break;
            }
            case 3: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)8);
                break;
            }
            case 4: {
                lineInfo.setLineStyle((byte)1);
                lineInfo.setDashed((byte)10);
                break;
            }
            case 5: {
                lineInfo.setLineStyle((byte)2);
                lineInfo.setDashed((byte)6);
                break;
            }
            default: {
                lineInfo.setLineStyle((byte)0);
            }
        }
    }

    protected int[] drawBackGround(DSContainer dSContainer, int n, int n2) throws IOException, OutOfSpaceException {
        Offset offset = (Offset)this.offsets.peek();
        int n3 = this.unitToTwip(dSContainer.getX() + offset.dx) + n;
        int n4 = this.unitToTwip(this.getY(dSContainer, n2) + offset.dy);
        int n5 = this.unitToTwip(dSContainer.getWidth());
        int n6 = this.unitToTwip(dSContainer.getHeight());
        FillInfo fillInfo = this.getFillProperty(dSContainer);
        if (fillInfo != null) {
            if (dSContainer.getObjectType() == 45 && this.BorderIsRound(dSContainer)) {
                this.docPage.fillRoundBoxBackGround(n3, n4, n5, n6, fillInfo);
            } else {
                this.docPage.fillBackGround(n3, n4, n5, n6, fillInfo);
            }
        }
        int[] nArray = new int[]{n3, n4, n5, n6};
        return nArray;
    }

    protected boolean BorderIsRound(JRVisiableResult jRVisiableResult) {
        boolean bl = false;
        BorderProperties borderProperties = DrawBorderAdapter.ConvertBorderProperties(jRVisiableResult, 72);
        int n = borderProperties.getBorderJoint();
        if (n == BorderProperties.BORDERJOINT_ROUND) {
            bl = true;
        }
        return bl;
    }

    protected FillInfo getFillProperty(JRVisiableResult jRVisiableResult) throws IOException {
        FillPatternProperties fillPatternProperties = FillPatternAdapter.ConvertProperties(jRVisiableResult);
        FillInfo fillInfo = new FillInfo();
        int n = fillPatternProperties.getFillPatternType();
        if (n == FillPatternProperties.FILL_COLOR && fillPatternProperties.getBackgroundColor() == null) {
            return null;
        }
        if (n == FillPatternProperties.FILL_COLOR) {
            fillInfo.setFillColor(fillPatternProperties.getBackgroundColor());
        } else if (n == FillPatternProperties.FILL_IMAGE) {
            ImageInfo imageInfo = this.getGroundImage(jRVisiableResult);
            fillInfo.setImage(imageInfo);
        } else if (n == FillPatternProperties.FILL_GRADIENT) {
            Color color = fillPatternProperties.getGradientStartColor();
            Color color2 = fillPatternProperties.getGradientEndColor();
            int n2 = fillPatternProperties.getTransparency();
            int n3 = fillPatternProperties.getGradientStyle();
            GradientInfo gradientInfo = new GradientInfo(color, color2, n2, n3);
            fillInfo.setGradient(gradientInfo);
        } else {
            ImageInfo imageInfo = this.getGroundImage(jRVisiableResult);
            fillInfo.setImage(imageInfo);
        }
        return fillInfo;
    }

    protected ImageInfo getGroundImage(JRVisiableResult jRVisiableResult) throws IOException {
        Rectangle rectangle = jRVisiableResult.getBounds();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 2);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        FillPatternAdapter fillPatternAdapter = new FillPatternAdapter(jRVisiableResult);
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        fillPatternAdapter.fillPattern(graphics, rectangle2);
        graphics.dispose();
        int[] nArray = this.getImageWH(bufferedImage);
        ImageInfo imageInfo = new ImageInfo(bufferedImage, nArray[0], nArray[1]);
        return imageInfo;
    }

    protected int[] getImageWH(Image image) {
        int n = Unit.convertPixelToUnit(image.getWidth(null));
        int n2 = Unit.convertPixelToUnit(image.getHeight(null));
        n = this.unitToTwip(n);
        n2 = this.unitToTwip(n2);
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    protected void drawBorder(DSContainer dSContainer, int n, int n2, int n3, int n4) throws IOException, OutOfSpaceException {
        int n5;
        int n6;
        Color[] colorArray;
        int[] nArray;
        int[] nArray2 = this.getBorderStyle(dSContainer);
        if (dSContainer.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            nArray = this.getBorderWidth(dSContainer, true);
            colorArray = this.getBorderColor(dSContainer, true);
        } else {
            nArray = this.getBorderWidth(dSContainer, false);
            colorArray = this.getBorderColor(dSContainer, false);
        }
        LineInfo lineInfo = new LineInfo();
        if (nArray2[0] != 0 && nArray[0] != 0) {
            n6 = this.unitToTwip(nArray[0]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[0]);
            this.setLineStyle(lineInfo, nArray2[0]);
            this.docPage.drawLine(n, n2 + n5, n + n3, n2 + n5, lineInfo);
        }
        if (nArray2[1] != 0 && nArray[1] != 0) {
            n6 = this.unitToTwip(nArray[1]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[1]);
            this.setLineStyle(lineInfo, nArray2[1]);
            this.docPage.drawLine(n + n5, n2, n + n5, n2 + n4, lineInfo);
        }
        if (nArray2[2] != 0 && nArray[2] != 0) {
            n6 = this.unitToTwip(nArray[2]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[2]);
            this.setLineStyle(lineInfo, nArray2[2]);
            this.docPage.drawLine(n, n2 + n4 - n5, n + n3, n2 + n4 - n5, lineInfo);
        }
        if (nArray2[3] != 0 && nArray[3] != 0) {
            n6 = this.unitToTwip(nArray[3]);
            n5 = n6 / 2;
            lineInfo.setLineWidth(n6);
            lineInfo.setColor(colorArray[3]);
            this.setLineStyle(lineInfo, nArray2[3]);
            this.docPage.drawLine(n + n3 - n5, n2, n + n3 - n5, n2 + n4, lineInfo);
        }
        lineInfo = null;
    }

    public void drawRoundBorder(DSContainer dSContainer, int n, int n2, int n3, int n4) throws IOException, OutOfSpaceException {
        LineInfo lineInfo = this.getBorderInfo(dSContainer)[0];
        if (lineInfo != null) {
            this.docPage.drawShape(n, n2, n3, n4, null, lineInfo, 2);
        }
    }
}

