/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.jinfonet.util.loader.DynamicClassManager;
import guitools.toolkit.Offset;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import jet.Env;
import jet.JRStopEngineException;
import jet.JResource;
import jet.connect.DbBinary;
import jet.datastream.CTGridInfo;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSArea;
import jet.datastream.DSBarcode;
import jet.datastream.DSChartCoordinatepaper;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSGMap;
import jet.datastream.DSGeoMap;
import jet.datastream.DSMap;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSPicture;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSSlider;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableObject;
import jet.datastream.DSTabular;
import jet.datastream.DSTabularCell;
import jet.datastream.DSTemplatible;
import jet.datastream.DSTextBox;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.ExpException;
import jet.export.relayout.table.exp.ExportLayoutFactory;
import jet.export.relayout.table.exp.RtfTable;
import jet.export.rtf.BaseTool;
import jet.export.rtf.CTCell;
import jet.export.rtf.CTLayoutManager;
import jet.export.rtf.CrossTableRow;
import jet.export.rtf.LinkInfo;
import jet.export.rtf.PropertyInfo;
import jet.export.rtf.RtfCache;
import jet.export.rtf.ShapeInfo;
import jet.export.rtf.api.FillInfo;
import jet.export.rtf.api.FontInfo;
import jet.export.rtf.api.GradientInfo;
import jet.export.rtf.api.HyperLinkInfo;
import jet.export.rtf.api.ImageInfo;
import jet.export.rtf.reLayout.ObjectRectInfo;
import jet.export.rtf.reLayout.TableInfo;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;
import jet.export.util.DSShapeRegion;
import jet.export.util.DrawBorderAdapter;
import jet.export.util.ExportUtil;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.ImageEncoder;
import jet.export.util.ImageEngine;
import jet.thinviewer.JReportBarcode;
import jet.thinviewer.JReportGoMap;
import jet.thinviewer.JReportGoogleMap;
import jet.thinviewer.JReportMap;
import jet.udo.JRObjectRender;
import jet.util.BitmapReader;
import jet.util.Containable;
import jet.util.FontSets;
import jet.util.PictureFileFormatDetector;
import jet.util.Propertiable;
import jet.util.image.ImageResource;

class ExportToRtfFlow
extends BaseTool {
    private static final Toolkit BORDERJOINT_ROUND = Toolkit.getDefaultToolkit();
    public static final String EXP = ".rtf";
    private static final String ConvertBorderProperties = ".tmp";
    private static final String ConvertProperties = "{\\fonttbl{\\f0\\froman\\fcharset0\\fprq2 Times New Roman;}";
    private static final String FALSE = "{\\colortbl;";
    private static final String FILL_COLOR = "\\ansi";
    private static final char FILL_IMAGE = '{';
    private static final char SEDU = '}';
    private static final String WHITE = "{\\rtf1";
    private static final String _colSpan = "}}}";
    private static final String _height = "cpg936";
    private static final int _isMergeHead = 20;
    private static final int _isMergeRowHead = 1440;
    private static final int _object = 0;
    private static final int _rowSpan = 1;
    private static final int _width = 2;
    private static final int add = 3;
    private static final int addImage = 4;
    private static final int append = 5;
    private static final int background = 6;
    private static final int[] bdColor = new int[]{20, 1, 2, 3, 19, 202, 75, 24};
    public static final String[] NEWBORDERWIDTH = new String[]{"border-top-width", "border-left-width", "border-bottom-width", "border-right-width"};
    public static final String[] NEWBORDERCOLOR = new String[]{"border-top-color", "border-left-color", "border-bottom-color", "border-right-color"};
    private static final int X = 0;
    private static final int Y = 1;
    private static final int bdStyle = 2;
    private static final int bdWidth = 3;
    private static final int bginfo = 0;
    private static final int black = 1;
    private static final int blue = 2;
    private static final int checkStop = 3;
    private static final int clipsString = 4;
    private static final int close = 5;
    private static final String[] contains = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    private static final int containsKey = 0;
    private static final int convertInchToPixel = 1;
    private static final int convertPixelToUnit = 2;
    private static final int convertUnitToCentimeter = 3;
    private static final int convertUnitToPixel = 4;
    public static final int ALIGN_LEFTTOP = 0;
    public static final int ALIGN_CENTERTOP = 1;
    public static final int ALIGN_RIGHTTOP = 2;
    public static final int ALIGN_LEFTCENTER = 3;
    public static final int ALIGN_CENTERCENTER = 4;
    public static final int ALIGN_RIGHTCENTER = 5;
    public static final int ALIGN_LEFTBOTTOM = 6;
    public static final int ALIGN_CENTERBOTTOM = 7;
    public static final int ALIGN_RIGHTBOTTOM = 8;
    public static final int ALIGN_JUSTIFYTOP = 9;
    public static final int ALIGN_JUSTIFYCENTER = 10;
    public static final int ALIGN_JUSTIFYBOTTOM = 11;
    private static final String[] createImage = new String[]{"\\ql", "\\qc", "\\qr", "\\qj"};
    private static final String currentTimeMillis = "\\sl240\\slmult1";
    public static final int CENTER_X = 2;
    public static final int CENTER_Y = 1;
    public static final int DELTA_X = 3;
    public static final int DELTA_Y = 2;
    public static final int TOP_LINE = 20;
    public static final int BOTTOM_LINE = 12;
    public static final String EVAL = "JReport Evaluation Copy";
    public static final String CONTACT = "to purchase contact " + JResource.getMessage("Sale");
    public static final String PHONE = JResource.getMessage("SalePhone") + " / " + JResource.getMessage("homeURL");
    public static final String EVALFONT = "*ArialNarrow";
    public static final Font FT = FontSets.getFont("*ArialNarrow", 0, 20);
    public static final Font FB = FontSets.getFont("*ArialNarrow", 0, 12);
    public static final FontMetrics FMT = ExportToRtfFlow.getForecolor(FT);
    public static final FontMetrics FMB = ExportToRtfFlow.getForecolor(FB);
    public static final int TH = FMT.getHeight() * 20;
    public static final int BH = FMB.getHeight() * 20;
    public static final int TW = FMT.stringWidth("JReport Evaluation Copy") * 20;
    public static final int BW1 = FMB.stringWidth(CONTACT) * 20;
    public static final int BW2 = FMB.stringWidth(PHONE) * 20;
    public static final Color DEF_COLOR = Color.cyan;
    private static final int cyan = 1;
    public static final int LINE_SPACEING = 280;
    private static final char[] deIndent = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String delete = "\\'";
    private static final int dispose = -1;
    private static final int dx = 0;
    private static final int dy = 1;
    private static final int elementAt = 2;
    private static final int elements = 3;
    private static final int endsWith = 4;
    private static final int equals = 5;
    private static final int equalsIgnoreCase = 6;
    private static final int error = 7;
    private static final int exists = 0;
    private static final int fillColor = 1;
    private static final int fillPattern = 2;
    private static final String[] fillRect = new String[]{"\\b", "\\i", "\\strike", "\\ul"};
    private static final int flush = 1;
    private static final int get = 2;
    private static final int getAlignment = 3;
    private static final int getAscent = 4;
    private static final int getBackgroundColor = Unit.convertPixelToUnit(1, 1440);
    private static final Hashtable getBlue = new Hashtable();
    private String getBookMark;
    private String getBooleanProperty;
    private String getBooleanPropertyByName;
    private boolean getBorderJoint;
    private boolean getBounds;
    private boolean getBytes;
    private boolean getCell;
    private Communicator[] getCellColor;
    private PrintWriter getCells;
    private StringBuffer getChildren;
    private StringBuffer getClass;
    private StringBuffer getColNum;
    private Hashtable getColor;
    private Hashtable getColorProperty;
    private Vector getColorPropertyByName;
    private int getCurrentCommunicator;
    private int getDataStream;
    private int getDefaultToolkit;
    private int getDescent;
    private int getDisplay;
    private int getEncoding;
    private int getEndColor;
    private int getFamily;
    private int getFillPatternType;
    private int getFillProperty;
    private int getFloatPropertyByName;
    private int getFont;
    private int getFontInfo;
    private int getFontMetrics;
    private int getFontName;
    private int getFontRender;
    private int getFontSize;
    private int getForecolor;
    private int getGradient;
    private int getGradientEndColor = 0;
    private int getGradientStartColor = 0;
    private BufferedOutputStream getGraphics;
    private ImageEngine getGreen;
    private Communicator getGridInfo;
    private int getHGap = 0;
    private static String[][] getHal;
    private Stack getHalByOld;
    private Hashtable getHeaderInfo = new Hashtable();
    private Hashtable getHeight = new Hashtable();
    private static final int getImage = 2;
    private static final int getImageHeight = 3;
    private static Integer[] getImageResource;

    public ExportToRtfFlow(Communicator[] communicatorArray, boolean bl) {
        this.getCellColor = communicatorArray;
        this.getBooleanPropertyByName = Env.getTemporaryPath();
        this.getBorderJoint = bl;
    }

    public void publish(BufferedOutputStream bufferedOutputStream, File file) throws JRStopEngineException, IOException, ExpException {
        this.getGraphics = bufferedOutputStream;
        this.publish();
    }

    protected String prepareText(String string) {
        char[] cArray = string.toCharArray();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u00ff') {
                stringBuffer.append("\\uc2\\u").append((int)c).append(delete).append(deIndent[c >> 12 & 0xF]).append(deIndent[c >> 8 & 0xF]).append(delete).append(deIndent[c >> 4 & 0xF]).append(deIndent[c & 0xF]);
                continue;
            }
            if (c >= '\u0080') {
                stringBuffer.append(delete).append(Integer.toHexString(c));
                continue;
            }
            if (c == '\r' || c == '\n') {
                if (c == '\r') {
                    if (i + 1 < cArray.length && cArray[i + 1] == '\n') {
                        stringBuffer.append(" \\par ");
                        ++i;
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(" \\par ");
                continue;
            }
            if (c < ' ') {
                stringBuffer.append(delete).append(Integer.toHexString(c));
                continue;
            }
            if (c == '\\' || c == '{' || c == '}') {
                stringBuffer.append(delete).append(Integer.toHexString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private void BH() throws FileNotFoundException, UnsupportedEncodingException, ExpException {
        try {
            this.cache = new RtfCache(this.exportAuxInfo, "flow layout rtf");
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        this.getColorPropertyByName = new Vector();
        this.getColor = new Hashtable();
        this.getColorProperty = new Hashtable();
        this.getColorProperty.put("Times New Roman", 0);
        this.getChildren = new StringBuffer(256);
        this.getClass = new StringBuffer(ConvertProperties);
        this.getColNum = new StringBuffer(FALSE);
        this.getFont = -1;
        this.getDataStream = 1;
        this.getDefaultToolkit = 1;
        this.getDescent = 1026;
        this.getCurrentCommunicator = -1;
        this.getFontInfo = 0;
        this.getCell = false;
        this.getBooleanProperty = this.getCellColor[0].getEncoding() != null ? this.getCellColor[0].getEncoding() : "Cp1252";
        this.getGreen = new ImageEngine();
        this.BORDERJOINT_ROUND();
    }

    private synchronized void BORDERJOINT_ROUND() throws FileNotFoundException, UnsupportedEncodingException {
        File file;
        JRLog.indent("Create temp file");
        do {
            if (this.getBooleanPropertyByName == null || this.getBooleanPropertyByName.trim().length() == 0) {
                this.getBooleanPropertyByName = System.getProperty("java.io.tmpdir");
            }
            this.getBookMark = this.getBooleanPropertyByName + File.separatorChar + this.hashCode() + System.currentTimeMillis() + ConvertBorderProperties;
        } while ((file = new File(this.getBookMark)).exists());
        this.getCells = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getBooleanProperty));
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5403001, this.getBookMark);
        }
        JRLog.deIndent("Create temp file");
    }

    private void BW1() {
        String string = FILL_COLOR + this.BW2(this.getBooleanProperty);
        this.getChildren.append(WHITE).append(FILL_COLOR);
        this.getChildren.append(string);
        if (string.endsWith(_height)) {
            this.getChildren.append("\\uc2 ");
        } else {
            this.getChildren.append("\\uc1 ");
        }
        this.getChildren.append("\\deff0\\deflang1033\\deflangfe1033\\jexpand");
    }

    private String BW2(String string) {
        for (int i = 0; i < getHal.length; ++i) {
            if (!getHal[i][0].equalsIgnoreCase(string)) continue;
            return getHal[i][1];
        }
        return "cpg1252";
    }

    private int CONTACT(int n) {
        return Unit.convertUnitToPixel(n, 1440);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish() throws IOException, JRStopEngineException, ExpException {
        JRLog.indent("build RTF file.");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4403002);
        }
        this.getHalByOld = new Stack();
        try {
            this.BH();
            this.BW1();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(64);
            for (int i = 0; i < this.getCellColor.length; ++i) {
                Communicator communicator = this.getCellColor[i];
                if (communicator == null) {
                    this.logCommunicatorNullInfo(i);
                    continue;
                }
                this.ConvertBorderProperties(communicator);
                this.cache.setBaseCommunicator(communicator);
                Color color = communicator.getHeaderInfo((int)0).background;
                int n2 = communicator.getResolution();
                DataStream dataStream = (DataStream)communicator.getDataStream(0);
                this.getBounds = dataStream.ie() == 1;
                CommEnumeration commEnumeration = new CommEnumeration(communicator);
                boolean bl = false;
                Stack<Communicator> stack = new Stack<Communicator>();
                stack.push(communicator);
                this.getHGap += n;
                n = 0;
                while (commEnumeration.hasMoreElements()) {
                    ExportUtil.checkStop(communicator);
                    this.getHalByOld.push(new Offset(0, 0));
                    DSPage dSPage = (DSPage)commEnumeration.nextElement();
                    ++n;
                    this.getGridInfo = commEnumeration.getCurrentCommunicator();
                    if (!this.getGridInfo.equals(stack.peek())) {
                        stack.push(this.getGridInfo);
                        bl = true;
                    }
                    Rectangle rectangle = dSPage.getPageArea();
                    Rectangle rectangle2 = dSPage.getPrintableArea();
                    if (rectangle != null) {
                        int n3;
                        int n4;
                        if (rectangle.getWidth() > 126720.0) {
                            n4 = 126720;
                            this.getForecolor = 0;
                            this.getGradient = 0;
                        } else {
                            n4 = rectangle.width;
                            if (!this.getBorderJoint) {
                                this.getForecolor = this.CONTACT(rectangle2.x);
                                this.getGradient = this.CONTACT(rectangle.width - (rectangle2.x + rectangle2.width));
                            }
                        }
                        if (rectangle.getHeight() > 126720.0) {
                            n3 = 126720;
                            this.getFontRender = 0;
                            this.getFontSize = 0;
                        } else {
                            n3 = rectangle.height;
                            if (!this.getBorderJoint) {
                                this.getFontRender = this.CONTACT(rectangle2.y);
                                this.getFontSize = this.CONTACT(rectangle.height - (rectangle2.y + rectangle2.height));
                            }
                        }
                        this.getEndColor = this.CONTACT(n4);
                        this.getFamily = this.CONTACT(n3);
                        this.getDisplay = 0;
                        this.FB(dSPage, this.getHGap + n, stringBuffer, color, bl);
                    }
                    this.getHalByOld.pop();
                }
                communicator.setResolution(n2);
            }
            StringBuffer stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("\\sectd");
            if (this.getEndColor > this.getFamily) {
                stringBuffer2.append("\\lndscpsxn");
            }
            stringBuffer2.append("\\pgwsxn").append(this.getEndColor).append("\\pghsxn").append(this.getFamily).append("\\marglsxn").append(this.getForecolor).append("\\margrsxn").append(this.getGradient).append("\\margtsxn").append(this.getFontRender + this.getGradientEndColor).append("\\margbsxn").append(this.getFontSize + this.getGradientStartColor).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
            this.getCells.write(stringBuffer2.toString());
            this.getCells.write(125);
            this.getCells.close();
            if (this.getFont != -1) {
                this.getChildren.append("\\deftab").append(this.getFont);
            }
            this.getChildren.append(this.getClass.append('}').toString()).append(this.getColNum.append('}').toString()).append(stringBuffer.toString()).append("\n");
            this.getHal();
        }
        finally {
            this.getGreen = null;
            this.getCells.close();
            File file = new File(this.getBookMark);
            if (file.exists()) {
                file.delete();
            }
            if (JRLog.isTrace(4)) {
                JRLog.trace(4, 4403003);
            }
            JRLog.deIndent("build RTF file.");
        }
        JRLog.deIndent("RTF Exporter");
        this.getHalByOld = null;
    }

    private void ConvertBorderProperties(Communicator communicator) throws ExpException {
        long l = System.currentTimeMillis();
        communicator.waitFinished();
        long l2 = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, 4406005, new Long(l2 - l));
        }
    }

    private LinkInfo ConvertProperties(JRVisiableResult jRVisiableResult) throws JRStopEngineException {
        String string;
        int n;
        int n2 = jRVisiableResult.getLinkComm();
        LinkInfo linkInfo = n2 != -1 ? ((n = this.cache.getPageNumber(this.getGridInfo, jRVisiableResult)) != -1 ? new LinkInfo(this.getBookMark(this.getHGap + n), true) : null) : ((string = this.getGridInfo.getLinkedInfo(jRVisiableResult.getLinkCondition())) != null ? new LinkInfo(string, false) : null);
        return linkInfo;
    }

    private HyperLinkInfo DEF_COLOR(JRVisiableResult jRVisiableResult) throws JRStopEngineException {
        LinkInfo linkInfo = this.ConvertProperties(jRVisiableResult);
        if (linkInfo != null) {
            HyperLinkInfo hyperLinkInfo = linkInfo.isLinkReport() ? new HyperLinkInfo(linkInfo.getLink(), null, 1) : new HyperLinkInfo(linkInfo.getLink(), null, 0);
            return hyperLinkInfo;
        }
        return null;
    }

    private String FALSE(HyperLinkInfo hyperLinkInfo, boolean bl) {
        if (hyperLinkInfo != null) {
            StringBuffer stringBuffer = new StringBuffer(56);
            stringBuffer.append("{\\field{\\*\\fldinst {\\hich\\af0\\dbch\\af13\\loch\\f0  ").append("\\hich\\af0\\dbch\\af13\\loch\\f0 HYPERLINK ");
            if (hyperLinkInfo.getType() == 1) {
                stringBuffer.append("\\\\l ");
            }
            stringBuffer.append("\"").append(hyperLinkInfo.getUrl()).append("\" ");
            String string = hyperLinkInfo.getTip();
            if (string != null && string.length() != 0) {
                stringBuffer.append("\\\\o \"").append(string).append("\" ");
            }
            stringBuffer.append("\\hich\\af0\\dbch\\af13\\loch\\f0 }}");
            if (bl) {
                stringBuffer.append("{\\fldrslt ");
            } else {
                FontInfo fontInfo = hyperLinkInfo.getFont();
                if (fontInfo == null) {
                    stringBuffer.append("{\\fldrslt {\\cs15\\ul\\cf2\\hich\\af0\\dbch\\af13\\loch\\fs34\\f0 ");
                } else {
                    stringBuffer.append("{\\fldrslt {\\cs15\\ul\\hich\\af0\\dbch\\af13\\loch");
                    if (fontInfo.isItalic()) {
                        stringBuffer.append("\\i");
                    }
                    if (fontInfo.isBold()) {
                        stringBuffer.append("\\b");
                    }
                    if (hyperLinkInfo.getDisplay().trim().length() != 0) {
                        if (hyperLinkInfo.getForecolor() != null) {
                            stringBuffer.append("\\ulc" + this.getFontRender(hyperLinkInfo.getForecolor()));
                        } else {
                            stringBuffer.append("\\ulc" + this.getFontRender(Color.blue));
                        }
                    }
                    if (hyperLinkInfo.getForecolor() != null) {
                        stringBuffer.append("\\cf").append(this.getFontRender(hyperLinkInfo.getForecolor()));
                    } else {
                        stringBuffer.append("\\cf").append(this.getFontRender(Color.black));
                    }
                    String string2 = this.getFontName(fontInfo.getFontName());
                    Integer n = (Integer)this.getColorProperty.get(string2);
                    int n2 = n == null ? 0 : n;
                    stringBuffer.append("\\fs").append(fontInfo.getFontSize()).append("\\f").append(n2).append(" ");
                }
                stringBuffer.append(this.prepareText(hyperLinkInfo.getDisplay()));
                stringBuffer.append(_colSpan);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private void FB(DSPage dSPage, int n, StringBuffer stringBuffer, Color color, boolean bl) throws IOException, JRStopEngineException {
        int n2;
        StringBuffer stringBuffer2;
        JRObjectResult jRObjectResult;
        int n3 = dSPage.size();
        if (n3 == 0) {
            return;
        }
        List list = new ArrayList<JRObjectResult>(n3);
        int n4 = -1;
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector<JRObjectResult> vector2 = new Vector<JRObjectResult>();
        for (int i = 0; i < n3; ++i) {
            jRObjectResult = this.getRealObject(dSPage.getObject(i));
            if (!this.isExport(jRObjectResult)) continue;
            n4 = jRObjectResult.getObjectType();
            if (n4 == 514) {
                this.getGradientEndColor = this.CONTACT(((DSContainer)jRObjectResult).getHeight());
            }
            if ((n4 & 0x10) == 16) {
                if (n4 == 22) {
                    vector2.add(jRObjectResult);
                    continue;
                }
                vector.add(jRObjectResult);
                continue;
            }
            list.add(jRObjectResult);
        }
        if (n == 1) {
            stringBuffer.append("{\\stylesheet").append("\\viewkind1\\viewscale100}").append("\\paperw").append(this.getEndColor).append("\\paperh").append(this.getFamily).append("\\margl").append(this.getForecolor).append("\\margr").append(this.getGradient).append("\\margt").append(this.getFontRender + this.getGradientEndColor).append("\\margb").append(this.getFontSize + this.getGradientStartColor);
            if (this.getEndColor > this.getFamily) {
                stringBuffer.append("\\landscape");
            }
            stringBuffer.append("\\viewbksp1{\\*\\background {\\shp{\\*\\shpinst\\shpleft0\\shptop0\\shpright0\\shpbottom0\\shpfhdr0\\shpbxmargin\\shpbxignore\\shpbymargin\\shpbyignore\\shpwr0\\shpwrk0\\shpfblwtxt1");
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv 1}}{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv " + this.getFontSize(color) + "}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv 1}}{\\sp{\\sn lineWidth}{\\sv 0}}{\\sp{\\sn fLine}{\\sv 0}}{\\sp{\\sn bWMode}{\\sv 9}}{\\sp{\\sn fBackground}{\\sv 1}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}}}}");
            stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("\\sectd");
            if (this.getEndColor > this.getFamily) {
                stringBuffer2.append("\\lndscpsxn");
            }
            stringBuffer2.append("\\pgwsxn").append(this.getEndColor).append("\\pghsxn").append(this.getFamily).append("\\marglsxn").append(this.getForecolor).append("\\margrsxn").append(this.getGradient).append("\\margtsxn").append(this.getFontRender + this.getGradientEndColor).append("\\margbsxn").append(this.getFontSize + this.getGradientStartColor).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
            this.getCells.write(stringBuffer2.toString());
        } else {
            stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("{\\fs2 \\sect}\n");
            stringBuffer2.append("\\sectd");
            if (this.getEndColor > this.getFamily) {
                stringBuffer2.append("\\lndscpsxn");
            }
            stringBuffer2.append("\\pgwsxn").append(this.getEndColor).append("\\pghsxn").append(this.getFamily).append("\\marglsxn").append(this.getForecolor).append("\\margrsxn").append(this.getGradient).append("\\margtsxn").append(this.getFontRender + this.getGradientEndColor).append("\\margbsxn").append(this.getFontSize + this.getGradientStartColor).append("\\linex0\\endnhere\\sectdefaultcl\\sftnbj\n");
            this.getCells.write(stringBuffer2.toString());
        }
        if (bl) {
            stringBuffer2 = new StringBuffer(128);
            stringBuffer2.append("{\\*\\bkmkstart ").append(this.getBookMark(n)).append("}{\\*\\bkmkend ").append(this.getBookMark(n)).append("}");
            this.getCells.write(stringBuffer2.toString());
        }
        list = this.sort(list);
        for (n2 = 0; n2 < list.size(); ++n2) {
            jRObjectResult = (JRObjectResult)list.get(n2);
            n4 = jRObjectResult.getObjectType();
            this.getFloatPropertyByName = 0;
            this.getFontName = 0;
            this.getFontMetrics = 0;
            if (jRObjectResult instanceof DSSection) {
                this.getFontInfo = 1;
                DSSection dSSection = (DSSection)jRObjectResult;
                this.getFontInfo = 0;
                this.FILL_COLOR(jRObjectResult, n4, 0);
                continue;
            }
            this.getFontInfo = 0;
            this.FILL_COLOR(jRObjectResult, n4, 0);
        }
        n2 = this.getColorPropertyByName.size();
        while (--n2 >= 0) {
            this.getCells.write(this.getDisplay((ShapeInfo)this.getColorPropertyByName.elementAt(n2)));
        }
        n2 = vector.size();
        while (--n2 >= 0) {
            this.getDefaultToolkit((DSShape)vector.elementAt(n2));
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            this.getDefaultToolkit((DSShape)enumeration.nextElement());
        }
        if (this.getBounds) {
            this.getDescent();
        }
    }

    private List sort(List list) {
        if (list.size() <= 1) {
            return list;
        }
        int n = list.size();
        Vector<JRVisiableResult> vector = new Vector<JRVisiableResult>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            JRVisiableResult jRVisiableResult = (JRVisiableResult)list.get(i);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                JRVisiableResult jRVisiableResult2 = (JRVisiableResult)vector.get(n2);
                if (jRVisiableResult.getY() < jRVisiableResult2.getY() || jRVisiableResult.getY() == jRVisiableResult2.getY() && jRVisiableResult.getX() < jRVisiableResult2.getX()) break;
            }
            vector.insertElementAt(jRVisiableResult, n2);
        }
        return vector;
    }

    private void FILL_COLOR(JRObjectResult jRObjectResult, int n, int n2) throws IOException, JRStopEngineException {
        if ((n & 0x20) == 32) {
            switch (n) {
                case 33: 
                case 37: 
                case 45: {
                    this.cache.handleContainerBegin((DSSubReport)jRObjectResult);
                    this.elements((DSSubReport)jRObjectResult, n2);
                    this.cache.handleContainerEnd((DSSubReport)jRObjectResult);
                    break;
                }
                case 262178: {
                    this.bdStyle((DSParagraph)jRObjectResult, n2);
                    break;
                }
                case 34: {
                    this.getBooleanProperty((DSCrossTab)jRObjectResult, n2);
                    break;
                }
                case 46: {
                    this._rowSpan((DSTabular)jRObjectResult, n2);
                    break;
                }
                case 262179: {
                    this.getBounds((DSTableObject)jRObjectResult, n2);
                    break;
                }
                case 47: {
                    this.add((DSTabularCell)jRObjectResult, n2);
                    break;
                }
                case 36: 
                case 262181: {
                    this.getColorProperty((DSContainer)jRObjectResult, n2);
                    break;
                }
                case 40: {
                    this.TH((DSMap)jRObjectResult, n2);
                    break;
                }
                case 0x2000021: {
                    this.WHITE((DSGMap)jRObjectResult, n2);
                    break;
                }
                case 262183: {
                    this._height((DSMultiValueContainer)jRObjectResult, n2);
                    break;
                }
                case 16385: {
                    this.getCurrentCommunicator((DSTable)jRObjectResult, n2);
                    break;
                }
                case 262184: {
                    this.FILL_IMAGE((DSParameterForm)jRObjectResult, n2);
                    break;
                }
                case 67108897: {
                    this._colSpan((DSGeoMap)jRObjectResult, n2);
                    break;
                }
                default: {
                    this.cache.handleContainerBegin((DSContainer)jRObjectResult);
                    this.NEWBORDERWIDTH((DSContainer)jRObjectResult, n2);
                    this.cache.handleContainerEnd((DSContainer)jRObjectResult);
                    break;
                }
            }
        } else if ((n & 0x100) == 256) {
            this.clipsString((DSField)jRObjectResult, n, n2);
        } else if ((n & 0x200) == 512) {
            this._isMergeHead((DSSection)jRObjectResult, n2);
        } else if ((n & 0x80) == 128) {
            if (n == 128) {
                this.fillRect((DSPicture)jRObjectResult, n2);
            } else if (n == 129) {
                this.fillColor((DSPicture)jRObjectResult, n2);
            }
        } else if (n == 71) {
            this.getBackgroundColor((DSChartPlatform)jRObjectResult, n2);
        } else if (n == 524291) {
            this.checkStop((DSParagraphText)jRObjectResult, n2);
        } else if (n == 4096) {
            this.exportAuxInfo((JRVisiableResult)jRObjectResult, n2);
        } else if (n == 65541) {
            this.FT((DSNavigateButton)jRObjectResult, n2);
        } else if (n == 65542) {
            this.FMT((DSSlider)jRObjectResult, n2);
        } else if (n == 65540) {
            this.FMB((DSFilterControl)jRObjectResult, n2);
        } else if (jRObjectResult instanceof DSShape) {
            DSShape dSShape = (DSShape)jRObjectResult;
            this.getDefaultToolkit(dSShape);
        } else if (JRLog.isTrace(3)) {
            JRLog.trace(3, 3403001, jRObjectResult);
        }
    }

    private void FILL_IMAGE(DSParameterForm dSParameterForm, int n) throws IOException, JRStopEngineException {
        if (this.getNewBoolean(dSParameterForm, "IsShowTitle")) {
            Offset offset = new Offset((Offset)this.getHalByOld.peek(), dSParameterForm.getX(), this.getY(dSParameterForm, n));
            Rectangle rectangle = dSParameterForm.getTitleRec();
            int n2 = this.CONTACT(rectangle.x + offset.dx);
            int n3 = this.CONTACT(rectangle.y + offset.dy);
            int n4 = this.CONTACT(rectangle.width);
            int n5 = this.CONTACT(rectangle.height);
            int[] nArray = new int[]{n2, n3, n4, n5};
            String string = this.getNewStringProperty(dSParameterForm, "TitleText");
            int[] nArray2 = new int[7];
            jet.export.util.FontInfo fontInfo = this.cache.getFontInfo(dSParameterForm);
            String string2 = fontInfo.getFontName();
            boolean bl = this.getBooleanProperty(dSParameterForm, "TitleBold");
            boolean bl2 = this.getBooleanProperty(dSParameterForm, "TitleItalic");
            int n6 = 0;
            if (bl) {
                n6 |= 1;
            }
            if (bl2) {
                n6 |= 2;
            }
            int n7 = fontInfo.getFontSize();
            Font font = FontSets.getFont(string2, n6, Unit.convertUnitToPixel(n7));
            n6 = FontSets.getTrueFontStyleForUser(string2, n6);
            string2 = font.getFamily();
            bl = (n6 & 1) == 1;
            boolean bl3 = bl2 = (n6 & 2) == 2;
            if (bl) {
                nArray2[0] = 1;
            }
            if (bl2) {
                nArray2[1] = 1;
            }
            if (this.getNewBoolean(dSParameterForm, "TitleUnderline")) {
                nArray2[3] = 1;
            }
            nArray2[4] = Unit.convertUnitToPixel(n7, 72) * 2;
            Color[] colorArray = new Color[4];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = CCUtil.getIntPropertyByName(dSParameterForm, "TitleHorizontalAlignment");
            int n12 = 0;
            switch (n10) {
                case 1: {
                    if (n11 == 0) {
                        n12 = 0;
                        break;
                    }
                    if (n11 == 2) {
                        n12 = 1;
                        break;
                    }
                    if (n11 == 1) {
                        n12 = 2;
                        break;
                    }
                    if (n11 != 3) break;
                    n12 = 9;
                    break;
                }
                case 0: {
                    if (n11 == 0) {
                        n12 = 3;
                        break;
                    }
                    if (n11 == 2) {
                        n12 = 4;
                        break;
                    }
                    if (n11 == 1) {
                        n12 = 5;
                        break;
                    }
                    if (n11 != 3) break;
                    n12 = 10;
                    break;
                }
                case 2: {
                    if (n11 == 0) {
                        n12 = 6;
                        break;
                    }
                    if (n11 == 2) {
                        n12 = 7;
                        break;
                    }
                    if (n11 == 1) {
                        n12 = 8;
                        break;
                    }
                    if (n11 != 3) break;
                    n12 = 11;
                }
            }
            int n13 = 0;
            int n14 = 3;
            Color color = this.getNewColorProperty(dSParameterForm, "TitleBackground");
            Color color2 = this.getNewColorProperty(dSParameterForm, "TitleForeground");
            LinkInfo linkInfo = null;
            this.deIndent(false, nArray, string, nArray2, colorArray, font, n8, n9, n12, n13, n7, n14, string2, color2, color, null, false, linkInfo);
        }
        this.NEWBORDERWIDTH(dSParameterForm, n);
    }

    private void FMB(DSFilterControl dSFilterControl, int n) throws IOException {
        Render render = dSFilterControl.getRender();
        LinkInfo linkInfo = null;
        this.NEWBORDERCOLOR(render, dSFilterControl, n, linkInfo);
        this.getFloatPropertyByName(dSFilterControl, n);
    }

    private void FMT(DSSlider dSSlider, int n) throws IOException {
        Render render = dSSlider.getRender();
        LinkInfo linkInfo = null;
        this.NEWBORDERCOLOR(render, dSSlider, n, linkInfo);
        this.getFloatPropertyByName(dSSlider, n);
    }

    private void FT(DSNavigateButton dSNavigateButton, int n) throws IOException {
        Render render = dSNavigateButton.getRender();
        LinkInfo linkInfo = null;
        this.NEWBORDERCOLOR(render, dSNavigateButton, n, linkInfo);
        this.getFloatPropertyByName(dSNavigateButton, n);
    }

    private void NEWBORDERCOLOR(Render render, JRVisiableResult jRVisiableResult, int n, LinkInfo linkInfo) throws IOException {
        Image image;
        Offset offset = (Offset)this.getHalByOld.peek();
        ImageResource imageResource = render.getImageResource();
        Image image2 = image = imageResource == null ? null : imageResource.getImage();
        if (image == null) {
            return;
        }
        int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n4 = jRVisiableResult.getWidth();
        int n5 = jRVisiableResult.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = CCUtil.getIntPropertyByName(jRVisiableResult, "HorizontalAlignment");
        Color color = CCUtil.getColorPropertyByName(jRVisiableResult, "Background");
        this.getAscent(image, false, n2, n3, n4, n5, n6, n7, n8, color, linkInfo);
    }

    private void NEWBORDERWIDTH(DSContainer dSContainer, int n) throws IOException, JRStopEngineException {
        List list = this.zOrder(dSContainer.getChildren());
        this.endsWith(dSContainer, n);
        int n2 = list.size();
        if (n2 != 0) {
            this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
            int n3 = dSContainer.getStartYPos();
            int n4 = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                if (!this.isExport(jRObjectResult)) continue;
                this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n3);
            }
            this.getHalByOld.pop();
        }
    }

    @Override
    protected List zOrder(List list) {
        return this.sort(list);
    }

    private void PHONE(DSSection dSSection, int n) throws IOException, JRStopEngineException {
        Object object;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5403003, dSSection);
        }
        this.getCells.write("{\\footer\\pard\\plain ");
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = dSSection.getX();
        int n3 = this.getY(dSSection, n);
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), n2, n3));
        n2 = this.CONTACT(n2 + offset.dx);
        n3 = this.CONTACT(n3 + offset.dy);
        int n4 = this.CONTACT(dSSection.getWidth());
        int n5 = this.CONTACT(dSSection.getHeight());
        Color color = CCUtil.getColorPropertyByName(dSSection, "Background");
        if (color != null) {
            object = new FillInfo();
            ((FillInfo)object).setFillColor(color);
            this.getFillPatternType(n2, n3, n4, n5, (FillInfo)object, false);
            this.getFloatPropertyByName(dSSection, n);
        }
        object = dSSection.getChildren();
        int n6 = dSSection.getStartYPos();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)((Vector)object).get(i);
            if (!this.isExport(jRObjectResult)) continue;
            this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n6);
        }
        this.getCells.write("}");
        this.getHalByOld.pop();
    }

    private void SEDU(DSSection dSSection, int n) throws IOException, JRStopEngineException {
        Object object;
        if (JRLog.isTrace(5)) {
            JRLog.trace(5, 5403002, dSSection);
        }
        this.getCells.write("{\\header\\pard\\plain ");
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = dSSection.getX();
        int n3 = this.getY(dSSection, n);
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), n2, n3));
        n2 = this.CONTACT(n2 + offset.dx);
        n3 = this.CONTACT(n3 + offset.dy);
        int n4 = this.CONTACT(dSSection.getWidth());
        int n5 = this.CONTACT(dSSection.getHeight());
        Color color = CCUtil.getColorPropertyByName(dSSection, "Background");
        if (color != null) {
            object = new FillInfo();
            ((FillInfo)object).setFillColor(color);
            this.getFillPatternType(n2, n3, n4, n5, (FillInfo)object, false);
            this.getFloatPropertyByName(dSSection, n);
        }
        object = dSSection.getChildren();
        int n6 = dSSection.getStartYPos();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)((Vector)object).get(i);
            if (!this.isExport(jRObjectResult)) continue;
            this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n6);
        }
        this.getCells.write("}");
        this.getHalByOld.pop();
    }

    private void TH(DSMap dSMap, int n) throws IOException, JRStopEngineException {
        JReportMap jReportMap = new JReportMap();
        Image image = jReportMap.getMapImage(dSMap);
        if (image == null) {
            return;
        }
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSMap.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSMap, n));
        int n4 = dSMap.getWidth();
        int n5 = dSMap.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        LinkInfo linkInfo = null;
        int n8 = this.getGreen(dSMap);
        switch (n8) {
            case 1: {
                this.getAscent(image, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                this.getAscent(image, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 3: {
                this.get(image, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSMap.getParent()) instanceof DSParagraph && !dSMap.equals(dSMap.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(image, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
        this.getHalByOld.push(new Offset(offset, dSMap.getX(), dSMap.getY()));
        Vector vector = dSMap.getChildren();
        int n9 = vector == null ? 0 : vector.size();
        int n10 = dSMap.getStartYPos();
        for (int i = 0; i < n9; ++i) {
            Rectangle[] rectangleArray;
            DSArea dSArea;
            JRObjectResult jRObjectResult = this.getRealObject((JRObjectResult)vector.get(i));
            if (!(jRObjectResult instanceof DSArea) || (linkInfo = this.ConvertProperties(dSArea = (DSArea)jRObjectResult)) == null || (rectangleArray = this.TW(dSArea, n10)) == null) continue;
            for (int j = 0; j < rectangleArray.length; ++j) {
                Rectangle rectangle = rectangleArray[j];
                if (rectangle == null) continue;
                n4 = (int)rectangle.getWidth();
                n5 = (int)rectangle.getHeight();
                n4 = Unit.convertUnitToPixel(n4, 96);
                n5 = Unit.convertUnitToPixel(n5, 96);
                BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
                n4 = (int)rectangle.getWidth();
                n5 = (int)rectangle.getHeight();
                n2 = this.CONTACT((int)rectangle.getX());
                n3 = this.CONTACT((int)rectangle.getY());
                n6 = n2 + this.CONTACT(n4);
                n7 = n3 + this.CONTACT(n5);
                this.getAscent(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
            }
        }
        this.getHalByOld.pop();
    }

    private Rectangle[] TW(DSArea dSArea, int n) {
        int n2 = dSArea.getShapeType();
        Rectangle[] rectangleArray = null;
        Offset offset = (Offset)this.getHalByOld.peek();
        switch (n2) {
            case 1: {
                rectangleArray = new Rectangle[1];
                int n3 = dSArea.getX() + offset.dx;
                int n4 = this.getY(dSArea, n) + offset.dy;
                int n5 = dSArea.getWidth();
                int n6 = dSArea.getHeight();
                rectangleArray[0] = new Rectangle(n3, n4, n5, n6);
                break;
            }
            case 2: {
                rectangleArray = new Rectangle[1];
                int n7 = dSArea.getX() + offset.dx;
                int n8 = this.getY(dSArea, n) + offset.dy;
                int n9 = dSArea.getWidth();
                int n10 = n9 / 2;
                int n11 = n9;
                n7 += n10;
                n8 += n10;
                int n12 = (int)(0.707 * (double)n10);
                n11 = n9 = n12 * 2;
                rectangleArray[0] = new Rectangle(n7 -= n12, n8 -= n12, n9, n11);
                break;
            }
            case 3: 
            case 4: {
                int n13;
                Vector vector = dSArea.getChildren();
                int n14 = n13 = vector == null ? 0 : vector.size();
                if (n13 <= 0) break;
                rectangleArray = new Rectangle[n13];
                for (int i = 0; i < n13; ++i) {
                    DSField dSField = (DSField)vector.get(i);
                    int n15 = dSField.getX() + offset.dx;
                    int n16 = this.getY(dSField, n) + offset.dy;
                    int n17 = dSField.getWidth();
                    int n18 = dSField.getHeight();
                    rectangleArray[i] = new Rectangle(n15, n16, n17, n18);
                }
                break;
            }
        }
        return rectangleArray;
    }

    private void WHITE(DSGMap dSGMap, int n) throws IOException {
        JReportGoogleMap jReportGoogleMap = new JReportGoogleMap();
        Image image = jReportGoogleMap.getMapImage(dSGMap);
        if (image == null) {
            return;
        }
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSGMap.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSGMap, n));
        int n4 = dSGMap.getWidth();
        int n5 = dSGMap.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        LinkInfo linkInfo = null;
        switch (this.getGreen(dSGMap)) {
            case 1: {
                this.getAscent(image, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                this.getAscent(image, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 3: {
                this.get(image, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSGMap.getParent()) instanceof DSParagraph && !dSGMap.equals(dSGMap.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(image, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
    }

    private void _colSpan(DSGeoMap dSGeoMap, int n) throws IOException {
        JReportGoMap jReportGoMap = new JReportGoMap();
        Image image = jReportGoMap.getMapImage(dSGeoMap);
        if (image == null) {
            return;
        }
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSGeoMap.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSGeoMap, n));
        int n4 = dSGeoMap.getWidth();
        int n5 = dSGeoMap.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        LinkInfo linkInfo = null;
        switch (this.getGreen(dSGeoMap)) {
            case 1: {
                this.getAscent(image, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                this.getAscent(image, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 3: {
                this.get(image, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSGeoMap.getParent()) instanceof DSParagraph && !dSGeoMap.equals(dSGeoMap.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(image, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
    }

    private void _height(DSMultiValueContainer dSMultiValueContainer, int n) throws IOException {
        Render render = dSMultiValueContainer.getRender();
        this.close(render, dSMultiValueContainer, n, null);
        this.getFloatPropertyByName(dSMultiValueContainer, n);
    }

    private void _isMergeHead(DSSection dSSection, int n) throws IOException, JRStopEngineException {
        Vector vector = dSSection.getChildren();
        int n2 = dSSection.getStartYPos();
        switch (this.getGreen(dSSection)) {
            case 1: {
                ++this.getFontMetrics;
                this.endsWith(dSSection, n);
                this.getFillProperty(dSSection, n);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSSection.getX(), this.getY(dSSection, n)));
                for (int i = 0; i < vector.size(); ++i) {
                    JRObjectResult jRObjectResult = this.getRealObject((JRObjectResult)vector.get(i));
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                }
                --this.getFontMetrics;
                break;
            }
            default: {
                ++this.getFloatPropertyByName;
                this._isMergeRowHead(dSSection);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSSection.getX(), this.getY(dSSection, n)));
                for (int i = 0; i < vector.size(); ++i) {
                    JRObjectResult jRObjectResult = this.getRealObject((JRObjectResult)vector.get(i));
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                }
                this._object(dSSection);
                --this.getFloatPropertyByName;
            }
        }
        this.getHalByOld.pop();
    }

    private void _isMergeRowHead(DSContainer dSContainer) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = Unit.convertUnitToPixel(dSContainer.getWidth(), 1440);
        int n2 = Unit.convertUnitToPixel(dSContainer.getHeight(), 1440);
        Color color = CCUtil.getColorPropertyByName(dSContainer, "Background");
        if (this.getFloatPropertyByName <= 1) {
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\n");
        } else {
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto\\rin0\\lin0").append("\\itap").append(this.getFloatPropertyByName).append("\n");
        }
        this.getCells.write(stringBuffer.toString());
    }

    private void _object(DSContainer dSContainer) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = Unit.convertUnitToPixel(dSContainer.getWidth(), 1440);
        int n2 = Unit.convertUnitToPixel(dSContainer.getHeight(), 1440);
        Color color = CCUtil.getColorPropertyByName(dSContainer, "Background");
        if (this.getFloatPropertyByName <= 1) {
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n);
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0\\cgrid\\langnp1033\\langfenp2052 {\\cell}").append("\n");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\nowrap\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0 {");
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\\row }");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto").append("\n");
        } else {
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0").append("\\itap").append(this.getFloatPropertyByName).append("{\\nestcell{\\nonesttables\\par}}").append("\n");
            stringBuffer.append("\\pard\\plain\\ql\\li0\\ri0\\widctlpar\\intbl\\aspalpha\\aspnum\\faauto").append("\\rin0\\lin0").append("\\itap").append(this.getFloatPropertyByName);
            stringBuffer.append("{{\\*\\nesttableprops");
            stringBuffer.append("\\trowd\\irow0\\irowband0\\lastrow\\trrh-").append(n2).append("\\trleft-5");
            stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1");
            stringBuffer.append("\\clvertalt").append("\\clbrdrt\\brdrtbl").append("\\clbrdrl\\brdrtbl").append("\\clbrdrb\\brdrtbl").append("\\clbrdrr\\brdrtbl");
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
            stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n);
            stringBuffer.append("\\cellx").append(n).append("\\nestrow}{\\nonesttables\\par}}").append("\n");
        }
        this.getCells.write(stringBuffer.toString());
    }

    private void _rowSpan(DSTabular dSTabular, int n) throws IOException, JRStopEngineException {
        Vector vector = dSTabular.getChildren();
        int n2 = dSTabular.getStartYPos();
        switch (this.getGreen(dSTabular)) {
            case 1: {
                ++this.getFontMetrics;
                this.endsWith(dSTabular, n);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSTabular.getX(), this.getY(dSTabular, n)));
                for (int i = 0; i < vector.size(); ++i) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                }
                --this.getFontMetrics;
                break;
            }
            default: {
                ++this.getFontMetrics;
                int n3 = this.CONTACT(dSTabular.getWidth());
                int n4 = this.CONTACT(dSTabular.getHeight());
                this._width(n3, n4);
                this.endsWith(dSTabular, n);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSTabular.getX(), this.getY(dSTabular, n)));
                for (int i = 0; i < vector.size(); ++i) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                }
                --this.getFontMetrics;
            }
        }
    }

    private void _width(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}").append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private void add(DSTabularCell dSTabularCell, int n) throws IOException, JRStopEngineException {
        Vector vector = dSTabularCell.getChildren();
        int n2 = dSTabularCell.getStartYPos();
        this.endsWith(dSTabularCell, n);
        int n3 = this.CONTACT(dSTabularCell.getWidth());
        int n4 = this.CONTACT(dSTabularCell.getHeight());
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSTabularCell.getX(), this.getY(dSTabularCell, n)));
        this.getBytes = true;
        this.getFillProperty = n4;
        this.getFillPatternType = n3;
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!this.isExport(jRObjectResult)) continue;
            this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
        }
        this.getBytes = false;
        this.getHalByOld.pop();
    }

    private void addImage(DSParagraph dSParagraph, int n, StringBuffer stringBuffer, boolean bl) throws IOException, JRStopEngineException {
        int n2;
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector vector2 = dSParagraph.getChildren();
        int n3 = dSParagraph.getStartYPos();
        this.bdColor(dSParagraph, stringBuffer);
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
        ArrayList<DSTemplatible> arrayList = new ArrayList<DSTemplatible>();
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector2.get(n2);
            int n4 = jRObjectResult.getObjectType();
            if ((n4 & 0x100) == 256) {
                DSField dSField = (DSField)jRObjectResult;
                DSTemplatible dSTemplatible = dSField.getTemplate();
                if (arrayList.contains(dSTemplatible)) continue;
                this.background(dSField, n3, stringBuffer);
                arrayList.add(dSTemplatible);
                continue;
            }
            if (jRObjectResult instanceof DSParagraphText) {
                this.blue((DSParagraphText)jRObjectResult, n3, stringBuffer);
                continue;
            }
            if (n4 == 128) {
                if (this.getGreen((JRVisiableResult)jRObjectResult) == 2) {
                    vector.add(jRObjectResult);
                    continue;
                }
                this.append((DSPicture)jRObjectResult, n3, stringBuffer);
                continue;
            }
            if (!JRLog.isAd()) continue;
            JRLog.print("Export to flow rtf, can not handle this object, its type is:(" + n4 + ")");
        }
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.append((DSPicture)vector.get(n2), n3, stringBuffer);
        }
        n2 = this.getFontInfo(CCUtil.getIntPropertyByName(dSParagraph, "FontSize"));
        if (!bl) {
            stringBuffer.append("{\\fs" + n2 + "\\par}\n");
        }
        this.getHalByOld.pop();
    }

    private void append(DSPicture dSPicture, int n, StringBuffer stringBuffer) throws IOException, JRStopEngineException {
        jet.export.util.ImageInfo imageInfo = this.getGreen.getImage(true, false, dSPicture);
        Image image = imageInfo.getImage();
        if (image == null) {
            return;
        }
        LinkInfo linkInfo = this.ConvertProperties(dSPicture);
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.getY(dSPicture, n) + offset.dy;
        int n3 = this.CONTACT(dSPicture.getX() + offset.dx);
        int n4 = this.CONTACT(n2);
        int n5 = dSPicture.getWidth();
        int n6 = dSPicture.getHeight();
        if (this.getCurrentCommunicator > 0 && this.getCurrentCommunicator < n2 + n6) {
            if (this.getCurrentCommunicator < n2) {
                return;
            }
            n6 = this.getCurrentCommunicator - n2;
        }
        int n7 = n3 + this.CONTACT(n5);
        int n8 = n4 + this.CONTACT(n6);
        switch (this.getGreen(dSPicture)) {
            case 1: {
                this.getAlignment(image, false, n3, n4, n5, n6, n7, n8, 0, null, stringBuffer, linkInfo);
                break;
            }
            case 2: {
                this.getAlignment(image, true, n3, n4, n5, n6, n7, n8, 0, null, stringBuffer, linkInfo);
                break;
            }
            case 3: {
                this.flush(image, n5, n6, stringBuffer, linkInfo);
                this.getCells.write(stringBuffer.toString());
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSPicture.getParent()) instanceof DSParagraph && !dSPicture.equals(dSPicture.getParent().getChildren().get(0))) {
                    stringBuffer.append("{\\par}");
                }
                this.flush(image, n5, n6, stringBuffer, linkInfo);
                stringBuffer.append("{\\par}");
                this.getCells.write(stringBuffer.toString());
            }
        }
    }

    private void background(DSField dSField, int n, StringBuffer stringBuffer) throws IOException {
        this.getColor(dSField, 0, 0, stringBuffer, n);
    }

    private void bdColor(DSParagraph dSParagraph, StringBuffer stringBuffer) {
        int n = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_line");
        int n2 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_Left");
        int n3 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_Right");
        float f = Unit.convertUnitToPixel(CCUtil.getFloatPropertyByName(dSParagraph, "Spacing_line"), 1440);
        int n4 = CCUtil.getBooleanPropertyByName(dSParagraph, "Spacing_type") ? 1 : 0;
        int n5 = CCUtil.getIntPropertyByName(dSParagraph, "HorizontalAlignment");
        int n6 = CCUtil.getIntPropertyByName(dSParagraph, "Spacing_Before");
        int n7 = CCUtil.getIntPropertyByName(dSParagraph, "Spacing_After");
        int n8 = CCUtil.getIntPropertyByName(dSParagraph, "Indentation_hang");
        if (this.getFont != 0) {
            this.getFont = CCUtil.getIntPropertyByName(dSParagraph, "TAB_defaultStop");
        }
        n = Unit.convertUnitToPixel(n, 1440);
        n8 = Unit.convertUnitToPixel(n8, 1440);
        n2 = Unit.convertUnitToPixel(n2, 1440);
        n3 = Unit.convertUnitToPixel(n3, 1440);
        n6 = Unit.convertUnitToPixel(n6, 1440);
        n7 = Unit.convertUnitToPixel(n7, 1440);
        int[] nArray = dSParagraph.getStops();
        int[] nArray2 = dSParagraph.getAlignment();
        int[] nArray3 = dSParagraph.getLeaders();
        stringBuffer.append("\\pard\\plain");
        switch (n5) {
            case 0: {
                stringBuffer.append("\\ql");
                break;
            }
            case 1: {
                stringBuffer.append("\\qr");
                break;
            }
            case 2: {
                stringBuffer.append("\\qc");
                break;
            }
            case 3: {
                stringBuffer.append("\\qj");
            }
        }
        if (n >= 0 && n8 == 0) {
            stringBuffer.append("\\fi").append(n);
        } else {
            stringBuffer.append("\\fi").append(-n8);
        }
        stringBuffer.append("\\li").append(n2).append("\\ri").append(n3);
        if (this.getCell) {
            n6 += Unit.convertUnitToPixel(dSParagraph.getY(), 1440);
        }
        if (n6 > 0) {
            stringBuffer.append("\\sb").append(n6);
        }
        stringBuffer.append("\\sa").append(n7).append("\\widctlpar");
        if (nArray != null) {
            block18: for (int i = 0; i < nArray.length; ++i) {
                int n9 = nArray[i];
                int n10 = nArray2[i];
                int n11 = nArray3[i];
                switch (n10) {
                    case 2: {
                        stringBuffer.append("\\tqr");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("\\tqc");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("\\tqdec");
                        break;
                    }
                    default: {
                        stringBuffer.append("\\tql");
                    }
                }
                stringBuffer.append("\\tx").append(n9);
                switch (n11) {
                    case 1: {
                        stringBuffer.append("");
                        continue block18;
                    }
                    case 2: {
                        stringBuffer.append("\\tldot");
                        continue block18;
                    }
                    case 3: {
                        stringBuffer.append("\\tlhyph");
                        continue block18;
                    }
                    case 4: {
                        stringBuffer.append("\\tlul");
                        continue block18;
                    }
                    case 5: {
                        stringBuffer.append("\\tlmdot");
                    }
                }
            }
        }
        stringBuffer.append("\\sl").append((int)f).append("\\slmult").append(n4);
        stringBuffer.append("\\nowidctlpar\\aspalpha\\aspnum").append("\\faauto\\adjustright").append("\\itap").append(this.getFloatPropertyByName).append("\\cgrig\\langnp1033\\langfeng2052 ");
    }

    private void bdStyle(DSParagraph dSParagraph, int n) throws IOException, JRStopEngineException {
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector vector2 = dSParagraph.getChildren();
        int n2 = dSParagraph.getStartYPos();
        switch (this.getGreen(dSParagraph)) {
            case 1: {
                this.endsWith(dSParagraph, n);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                for (int i = 0; i < vector2.size(); ++i) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector2.get(i);
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                }
                break;
            }
            default: {
                JRObjectResult jRObjectResult;
                int n3;
                if (!this.bdWidth(dSParagraph)) {
                    this.bginfo(dSParagraph);
                    this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        jRObjectResult = (JRObjectResult)vector2.elementAt(n3);
                        if (jRObjectResult instanceof DSPicture && this.getGreen((JRVisiableResult)jRObjectResult) == 2) {
                            vector.add(jRObjectResult);
                            continue;
                        }
                        this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                } else {
                    this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSParagraph.getX(), this.getY(dSParagraph, n)));
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        jRObjectResult = (JRObjectResult)vector2.elementAt(n3);
                        if (jRObjectResult instanceof DSPicture && this.getGreen((JRVisiableResult)jRObjectResult) == 2) {
                            vector.add(jRObjectResult);
                            continue;
                        }
                        if (jRObjectResult instanceof DSParagraphText) {
                            this.cache((DSParagraphText)jRObjectResult, n2);
                            continue;
                        }
                        this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n2);
                    }
                }
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    this.fillRect((DSPicture)vector.get(n3), n2);
                }
                n3 = this.getFontInfo(CCUtil.getIntPropertyByName(dSParagraph, "FontSize"));
                this.getCells.write("{\\fs" + n3 + "\\par}\n");
                break;
            }
        }
        this.getHalByOld.pop();
    }

    private boolean bdWidth(DSParagraph dSParagraph) {
        Vector vector = dSParagraph.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            int n2 = jRObjectResult.getObjectType();
            if ((n2 & 0x20) != 32) continue;
            return true;
        }
        return false;
    }

    private void bginfo(DSParagraph dSParagraph) {
        StringBuffer stringBuffer = new StringBuffer(128);
        this.bdColor(dSParagraph, stringBuffer);
        this.getCells.write(stringBuffer.toString());
    }

    private void black(DSField dSField, int n, LinkInfo linkInfo) throws IOException {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        Offset offset = (Offset)this.getHalByOld.peek();
        nArray2[0] = this.CONTACT(dSField.getX() + offset.dx);
        nArray2[1] = this.CONTACT(this.getY(dSField, n) + offset.dy);
        nArray2[2] = this.CONTACT(dSField.getWidth());
        nArray2[3] = this.CONTACT(dSField.getHeight());
        String string = "";
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "Foreground");
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "StrikeOut");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Underline");
        jet.export.util.FontInfo fontInfo = this.cache.getFontInfo(dSField);
        String string2 = fontInfo.getFontName();
        int n2 = fontInfo.getFontSize();
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSField, "Bold");
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSField, "Italic");
        int n3 = 0;
        if (bl3) {
            n3 |= 1;
        }
        if (bl4) {
            n3 |= 2;
        }
        Font font = FontSets.getFont(string2, n3, Unit.convertUnitToPixel(n2));
        n3 = FontSets.getTrueFontStyleForUser(string2, n3);
        string2 = font.getFamily();
        bl3 = (n3 & 1) == 1;
        bl4 = (n3 & 2) == 2;
        string2 = this.getFontName(string2);
        if (bl) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSField, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSField, "StrikeoutlineColor");
        }
        if (bl2) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSField, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSField, "UnderlineColor");
        }
        nArray[4] = this.getFontInfo(n2);
        Render render = dSField.getRender();
        switch (this.getGreen(dSField)) {
            case 1: {
                this.close(render, dSField, n, linkInfo);
                break;
            }
            default: {
                if (render instanceof RenderText) {
                    RenderText renderText = (RenderText)render;
                    Vector vector = renderText.getVLines();
                    if (vector != null && vector.size() != 0) {
                        for (int i = 0; i < vector.size(); ++i) {
                            string = (String)vector.get(i);
                        }
                    }
                    this.elementAt(string, nArray, 1, string2, colorArray, color2, color, linkInfo);
                    break;
                }
                if (render instanceof RenderList || render instanceof RenderDropDownList) {
                    this.contains(render, dSField, n, linkInfo);
                    break;
                }
                this.containsKey(dSField, n, linkInfo);
            }
        }
    }

    private void blue(DSParagraphText dSParagraphText, int n, StringBuffer stringBuffer) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        boolean bl = dSParagraphText.getIsTab();
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.getY(dSParagraphText, n) + offset.dy;
        int n3 = dSParagraphText.getHeight();
        if (this.getCurrentCommunicator > 0 && this.getCurrentCommunicator < n2 + n3) {
            if (this.getCurrentCommunicator < n2) {
                return;
            }
            n3 = this.getCurrentCommunicator - n2;
        }
        nArray2[0] = this.CONTACT(dSParagraphText.getX() + offset.dx);
        nArray2[1] = this.CONTACT(n2);
        nArray2[2] = this.CONTACT(dSParagraphText.getWidth());
        nArray2[3] = this.CONTACT(n3);
        String string = dSParagraphText.getText();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        jet.export.util.FontInfo fontInfo = this.cache.getFontInfo(dSParagraphText);
        String string2 = fontInfo.getFontName();
        int n4 = fontInfo.getFontSize();
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold");
        boolean bl5 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic");
        int n5 = 0;
        if (bl4) {
            n5 |= 1;
        }
        if (bl5) {
            n5 |= 2;
        }
        Font font = FontSets.getFont(string2, n5, Unit.convertUnitToPixel(n4));
        n5 = FontSets.getTrueFontStyleForUser(string2, n5);
        string2 = font.getFamily();
        bl4 = (n5 & 1) == 1;
        bl5 = (n5 & 2) == 2;
        string2 = this.getFontName(string2);
        if (bl2) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
        }
        if (bl3) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
        }
        if (bl4) {
            nArray[0] = 1;
        }
        if (bl5) {
            nArray[1] = 1;
        }
        nArray[4] = this.getFontInfo(n4);
        int n6 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript");
        if (bl && this.getGreen(dSParagraphText) != 1) {
            stringBuffer.append("{\\tab}");
        } else {
            LinkInfo linkInfo = null;
            switch (this.getGreen(dSParagraphText)) {
                case 1: {
                    if (n6 > 0) {
                        n4 = n4 * 2 / 3;
                    }
                    nArray[4] = this.getFontInfo(n4);
                    Vector vector = dSParagraphText.getWords();
                    int[] nArray3 = dSParagraphText.getWordsPosition();
                    int n7 = nArray2[0];
                    int n8 = nArray2[2];
                    nArray2[3] = Unit.convertUnitToPixel(dSParagraphText.getTextHeight(), 1440);
                    if (vector.size() != 0) {
                        for (int i = 0; i < vector.size(); ++i) {
                            nArray2[0] = n7;
                            nArray2[2] = n8;
                            String string3 = (String)vector.get(i);
                            int n9 = Unit.convertUnitToPixel(nArray3[i], 1440);
                            nArray2[0] = nArray2[0] + n9;
                            nArray2[2] = nArray2[2] - n9;
                            this.cyan(false, nArray2, string3, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, stringBuffer, linkInfo);
                        }
                        break;
                    }
                    this.cyan(false, nArray2, string, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, stringBuffer, linkInfo);
                    break;
                }
                default: {
                    this.dy(string, nArray, n6, string2, colorArray, color2, color, stringBuffer, linkInfo);
                }
            }
        }
    }

    private void cache(DSParagraphText dSParagraphText, int n) {
        int[] nArray = new int[4];
        Offset offset = (Offset)this.getHalByOld.peek();
        nArray[0] = this.CONTACT(dSParagraphText.getX() + offset.dx);
        nArray[1] = this.CONTACT(this.getY(dSParagraphText, n) + offset.dy);
        nArray[2] = this.CONTACT(dSParagraphText.getWidth());
        nArray[3] = this.CONTACT(dSParagraphText.getHeight());
        int n2 = this.getGradientStartColor(dSParagraphText);
        n2 = n2 == 2 ? 3 : n2;
        int n3 = 0;
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        int n4 = 1;
        int[] nArray2 = new int[7];
        DSTemplatible dSTemplatible = dSParagraphText.getTemplate();
        Object object = this.cache.getFontInfo(dSParagraphText);
        String string = ((jet.export.util.FontInfo)object).getFontName();
        boolean bl = this.getBooleanProperty(dSParagraphText, "Bold");
        int n5 = this.getBooleanProperty(dSParagraphText, "Italic");
        boolean bl2 = this.getBooleanProperty(dSParagraphText, "Underline");
        PropertyInfo propertyInfo = new PropertyInfo(string, this.getFontMetrics((jet.export.util.FontInfo)object), bl, n5 != 0, this.getBooleanProperty(dSParagraphText, "StrikeOut"));
        propertyInfo.haveUnderline = bl2;
        object = propertyInfo.getFontInfo();
        string = ((FontInfo)object).getFontName();
        String string2 = dSParagraphText.getText();
        string = this.getFontName(string);
        if (((FontInfo)object).isBold()) {
            nArray2[0] = 1;
        }
        if (((FontInfo)object).isItalic()) {
            nArray2[1] = 1;
        }
        if (propertyInfo.strikethrough) {
            nArray2[2] = 1;
        }
        if (propertyInfo.haveUnderline) {
            nArray2[3] = 1;
        }
        n5 = CCUtil.getIntPropertyByName(dSParagraphText, "FontSize");
        nArray2[4] = this.getFontInfo(n5);
        Font font = propertyInfo.getFont();
        byte by = this.getHal(dSParagraphText);
        n4 = 3;
        int n6 = 0;
        Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
        boolean bl3 = false;
        int n7 = 0;
        Color color3 = null;
        Color[] colorArray = new Color[]{null, null, null, null};
        LinkInfo linkInfo = null;
        this.deIndent(false, nArray, string2, nArray2, colorArray, font, n3, n7, n4, n6, n5, n2, string, color2, color, color3, bl3, linkInfo);
    }

    private void checkStop(DSParagraphText dSParagraphText, int n) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[2];
        boolean bl = dSParagraphText.getIsTab();
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.getY(dSParagraphText, n) + offset.dy;
        int n3 = dSParagraphText.getHeight();
        if (this.getCurrentCommunicator > 0 && this.getCurrentCommunicator < n2 + n3) {
            if (this.getCurrentCommunicator < n2) {
                return;
            }
            n3 = this.getCurrentCommunicator - n2;
        }
        nArray2[0] = this.CONTACT(dSParagraphText.getX() + offset.dx);
        nArray2[1] = this.CONTACT(n2);
        nArray2[2] = this.CONTACT(dSParagraphText.getWidth());
        nArray2[3] = this.CONTACT(n3);
        String string = dSParagraphText.getText();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        boolean bl3 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        jet.export.util.FontInfo fontInfo = this.cache.getFontInfo(dSParagraphText);
        String string2 = fontInfo.getFontName();
        int n4 = fontInfo.getFontSize();
        boolean bl4 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold");
        boolean bl5 = CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic");
        int n5 = 0;
        if (bl4) {
            n5 |= 1;
        }
        if (bl5) {
            n5 |= 2;
        }
        Font font = FontSets.getFont(string2, n5, Unit.convertUnitToPixel(n4));
        n5 = FontSets.getTrueFontStyleForUser(string2, n5);
        string2 = font.getFamily();
        bl4 = (n5 & 1) == 1;
        bl5 = (n5 & 2) == 2;
        string2 = this.getFontName(string2);
        if (bl2) {
            nArray[2] = 1;
            nArray[5] = CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle");
            colorArray[0] = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
        }
        if (bl3) {
            nArray[3] = 1;
            nArray[6] = CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle");
            colorArray[1] = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
        }
        if (bl4) {
            nArray[0] = 1;
        }
        if (bl5) {
            nArray[1] = 1;
        }
        nArray[4] = this.getFontInfo(n4);
        int n6 = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript");
        if (bl && this.getGreen(dSParagraphText) != 1) {
            this.getCells.write("{\\tab}");
        } else {
            LinkInfo linkInfo = null;
            switch (this.getGreen(dSParagraphText)) {
                case 1: {
                    if (n6 > 0) {
                        n4 = n4 * 2 / 3;
                    }
                    nArray[4] = this.getFontInfo(n4);
                    Vector vector = dSParagraphText.getWords();
                    int[] nArray3 = dSParagraphText.getWordsPosition();
                    int n7 = nArray2[0];
                    int n8 = nArray2[2];
                    nArray2[3] = Unit.convertUnitToPixel(dSParagraphText.getTextHeight(), 1440);
                    if (vector.size() != 0) {
                        for (int i = 0; i < vector.size(); ++i) {
                            nArray2[0] = n7;
                            nArray2[2] = n8;
                            String string3 = (String)vector.get(i);
                            int n9 = Unit.convertUnitToPixel(nArray3[i], 1440);
                            nArray2[0] = nArray2[0] + n9;
                            nArray2[2] = nArray2[2] - n9;
                            this.deIndent(false, nArray2, string3, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, linkInfo);
                        }
                        break;
                    }
                    this.deIndent(false, nArray2, string, nArray, colorArray, font, 0, 0, 1, 1, n4, 1, string2, color2, color, null, false, linkInfo);
                    break;
                }
                default: {
                    this.elementAt(string, nArray, n6, string2, colorArray, color2, color, linkInfo);
                }
            }
        }
    }

    private void clipsString(DSField dSField, int n, int n2) throws IOException, JRStopEngineException {
        if (n == 264) {
            try {
                this.delete((DSBarcode)dSField, n2);
            }
            catch (Exception exception) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403002, (Throwable)exception);
                }
            }
        } else {
            LinkInfo linkInfo = this.ConvertProperties(dSField);
            if (dSField.getParent() instanceof DSParagraph || dSField.getParent() instanceof DSTextBox && this.getGreen(dSField) == 3) {
                this.black(dSField, n2, linkInfo);
            } else {
                this.close(dSField.getRender(), dSField, n2, linkInfo);
            }
        }
    }

    private void close(Render render, JRVisiableResult jRVisiableResult, int n, LinkInfo linkInfo) throws IOException {
        if (render instanceof RenderText) {
            RenderText renderText = (RenderText)render;
            this.convertInchToPixel(renderText, jRVisiableResult, n, linkInfo);
        } else if (render instanceof RenderList || render instanceof RenderDropDownList) {
            this.contains(render, jRVisiableResult, n, linkInfo);
        } else {
            this.containsKey(jRVisiableResult, n, linkInfo);
        }
    }

    private void contains(Render render, JRVisiableResult jRVisiableResult, int n, LinkInfo linkInfo) throws IOException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n4 = jRVisiableResult.getWidth();
        int n5 = jRVisiableResult.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getGradientStartColor(jRVisiableResult);
        n8 = n8 == 2 ? 3 : n8;
        ImageResource imageResource = render.getImageResource();
        Image image = imageResource == null ? null : imageResource.getImage();
        switch (this.getGreen(jRVisiableResult)) {
            case 1: {
                this.getAscent(image, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                if (this.getFontName == 0) {
                    this.getAscent(image, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                    break;
                }
                this.get(image, n4, n5, linkInfo);
                break;
            }
            case 3: {
                this.get(image, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)jRVisiableResult.getParent()) instanceof DSParagraph && !jRVisiableResult.equals(jRVisiableResult.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(image, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
    }

    private void containsKey(JRObjectResult jRObjectResult, int n, LinkInfo linkInfo) throws IOException {
        DSField dSField = (DSField)jRObjectResult;
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSField.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSField, n) + offset.dy);
        int n4 = dSField.getWidth();
        int n5 = dSField.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getGradientStartColor(dSField);
        n8 = n8 == 2 ? 3 : n8;
        int n9 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        FillInfo fillInfo = new FillInfo();
        fillInfo.setFillColor(color);
        Render render = dSField.getRender();
        jet.export.util.ImageInfo imageInfo = this.getGreen.getImage(true, false, render);
        Image image = imageInfo.getImage();
        if (image == null) {
            if (color != null && this.getGreen(dSField) == 1) {
                this.getFillPatternType(n2, n3, Unit.convertUnitToPixel(n4, 1440), Unit.convertUnitToPixel(n5, 1440), fillInfo, false);
            }
            if (color != null && this.getGreen(dSField) != 1) {
                this.createImage(Unit.convertUnitToPixel(n4, 1440), Unit.convertUnitToPixel(n5, 1440), color);
            }
            return;
        }
        switch (this.getGreen(dSField)) {
            case 1: {
                this.getAscent(image, false, n2, n3, n4, n5, n6, n7, n9, color, linkInfo);
                break;
            }
            case 2: {
                if (this.getFontName == 0) {
                    this.getAscent(image, true, n2, n3, n4, n5, n6, n7, n9, color, linkInfo);
                    break;
                }
                this.get(image, n4, n5, linkInfo);
                break;
            }
            case 3: {
                this.get(image, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSField.getParent()) instanceof DSParagraph && !dSField.equals(dSField.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(image, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
    }

    private void convertInchToPixel(RenderText renderText, JRObjectResult jRObjectResult, int n, LinkInfo linkInfo) {
        int n2;
        int n3;
        byte by;
        int n4;
        String string;
        Object object;
        PropertyInfo propertyInfo;
        DSField dSField = (DSField)jRObjectResult;
        if (renderText.getWidth() <= 0) {
            return;
        }
        int[] nArray = new int[4];
        Offset offset = (Offset)this.getHalByOld.peek();
        nArray[0] = this.CONTACT(dSField.getX() + offset.dx);
        nArray[1] = this.CONTACT(this.getY(dSField, n) + offset.dy);
        nArray[2] = this.CONTACT(dSField.getWidth());
        nArray[3] = this.CONTACT(dSField.getHeight());
        int n5 = this.getGradientStartColor(dSField);
        n5 = n5 == 2 ? 3 : n5;
        int n6 = 0;
        int n7 = CCUtil.getIntPropertyByName(dSField, "LeftLine");
        int n8 = CCUtil.getIntPropertyByName(dSField, "RightLine");
        int n9 = CCUtil.getIntPropertyByName(dSField, "TopLine");
        int n10 = CCUtil.getIntPropertyByName(dSField, "BottomLine");
        if (n7 != 0) {
            n6 = n7;
        } else if (n9 != 0) {
            n6 = n9;
        } else if (n8 != 0) {
            n6 = n8;
        } else if (n10 != 0) {
            n6 = n10;
        }
        int n11 = CCUtil.getIntPropertyByName(dSField, "BorderWidth");
        Color color = CCUtil.getColorPropertyByName(dSField, "Background");
        Color color2 = CCUtil.getColorPropertyByName(dSField, "BorderColor");
        int n12 = 1;
        int[] nArray2 = new int[7];
        DSTemplatible dSTemplatible = dSField.getTemplate();
        if (this.getHeaderInfo.containsKey(dSTemplatible)) {
            propertyInfo = (PropertyInfo)this.getHeaderInfo.get(dSTemplatible);
        } else {
            object = this.cache.getFontInfo(dSField);
            string = ((jet.export.util.FontInfo)object).getFontName();
            boolean bl = false;
            n4 = 0;
            bl = this.getBooleanProperty(dSField, "Bold");
            n4 = this.getBooleanProperty(dSField, "Italic");
            boolean bl2 = this.getBooleanProperty(dSField, "Underline");
            propertyInfo = new PropertyInfo(string, this.getFontMetrics((jet.export.util.FontInfo)object), bl, n4 != 0, this.getBooleanProperty(dSField, "StrikeOut"));
            propertyInfo.haveUnderline = bl2;
            if (!this.getHeight.containsKey(dSTemplatible)) {
                byte by2 = this.convertPixelToUnit(dSField, "Bold") ? (byte)0 : (this.convertPixelToUnit(dSField, "Italic") ? (byte)0 : (this.convertPixelToUnit(dSField, "StrikeOut") ? (byte)0 : (by = this.convertPixelToUnit(dSField, "Underline") ? (byte)0 : 1)));
                if (by != 0) {
                    by = (byte)(((jet.export.util.FontInfo)object).isCanBeCache() ? 1 : 0);
                }
                if (by != 0) {
                    this.getHeaderInfo.put(dSTemplatible, propertyInfo);
                } else {
                    this.getHeight.put(dSTemplatible, Boolean.FALSE);
                }
            }
        }
        object = propertyInfo.getFontInfo();
        string = ((FontInfo)object).getFontName();
        String string2 = dSField.toString();
        string = this.getFontName(string);
        if (((FontInfo)object).isBold()) {
            nArray2[0] = 1;
        }
        if (((FontInfo)object).isItalic()) {
            nArray2[1] = 1;
        }
        if (propertyInfo.strikethrough) {
            nArray2[2] = 1;
        }
        if (propertyInfo.haveUnderline) {
            nArray2[3] = 1;
        }
        n4 = CCUtil.getIntPropertyByName(dSField, "FontSize");
        nArray2[4] = this.getFontInfo(n4);
        Font font = propertyInfo.getFont();
        by = this.getHal(dSField);
        if (dSField.getParent() instanceof DSParagraph && CCUtil.getIntPropertyByName(dSField, "position") != 2) {
            n12 = 3;
        } else {
            int n13 = CCUtil.getIntPropertyByName(dSField, "VerticalAlignment");
            n3 = CCUtil.getIntPropertyByName(dSField, "HorizontalAlignment");
            switch (n13) {
                case 1: {
                    if (n3 == 0) {
                        n12 = 0;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 1;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 2;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 9;
                    break;
                }
                case 0: {
                    if (n3 == 0) {
                        n12 = 3;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 4;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 5;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 10;
                    break;
                }
                case 2: {
                    if (n3 == 0) {
                        n12 = 6;
                        break;
                    }
                    if (n3 == 2) {
                        n12 = 7;
                        break;
                    }
                    if (n3 == 1) {
                        n12 = 8;
                        break;
                    }
                    if (n3 != 3) break;
                    n12 = 11;
                }
            }
        }
        Vector vector = renderText.getVLines();
        int n14 = n3 = vector == null ? 0 : vector.size();
        if (n3 > 0 && dSField.getParent() instanceof DSParagraph) {
            string2 = (String)vector.get(0);
        }
        Color color3 = CCUtil.getColorPropertyByName(dSField, "Foreground");
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
        FontRenderContext fontRenderContext = propertyInfo.getFontRender();
        if (!bl) {
            string2 = this.clipsString(string2, font, fontRenderContext, by, this.convertUnitToCentimeter(dSField));
        }
        int[] nArray3 = this.equalsIgnoreCase(dSField);
        boolean bl3 = false;
        if (dSField.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            bl3 = true;
        }
        int[] nArray4 = this.error(dSField, bl3);
        Color[] colorArray = this.exists(dSField, bl3);
        if (nArray3[0] != 0 && nArray4[0] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[0], 1440) / 2;
            nArray[1] = nArray[1] + n2;
            nArray[3] = nArray[3] - n2;
        }
        if (nArray3[2] != 0 && nArray4[2] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[2], 1440) / 2;
            nArray[3] = nArray[3] - n2;
        }
        if (nArray3[1] != 0 && nArray4[1] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[1], 1440) / 2;
            nArray[0] = nArray[0] + n2;
            nArray[2] = nArray[2] - n2;
        }
        if (nArray3[3] != 0 && nArray4[3] != 0) {
            n2 = Unit.convertUnitToPixel(nArray4[3], 1440) / 2;
            nArray[2] = nArray[2] - n2;
        }
        switch (this.getGreen(dSField)) {
            case 1: {
                this.deIndent(false, nArray, string2, nArray2, colorArray, font, n6, n11, n12, n3, n4, n5, string, color3, color, color2, bl, linkInfo);
                break;
            }
            case 2: {
                this.deIndent(true, nArray, string2, nArray2, colorArray, font, n6, n11, n12, n3, n4, n5, string, color3, color, color2, bl, linkInfo);
                break;
            }
            case 3: {
                this.currentTimeMillis(nArray, string2, nArray2, colorArray, n6, n11, n12, string, font, n4, n3, color3, color, color2, bl);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSField.getParent()) instanceof DSParagraph && !dSField.equals(((DSParagraph)dSField.getParent()).getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.currentTimeMillis(nArray, string2, nArray2, colorArray, n6, n11, n12, string, font, n4, n3, color3, color, color2, bl);
                this.getCells.write("{\\par}");
            }
        }
    }

    private boolean convertPixelToUnit(JRObjectResult jRObjectResult, String string) {
        return CCUtil.isChangeByFormularProperty(jRObjectResult, string);
    }

    private int convertUnitToCentimeter(DSField dSField) {
        return Unit.convertUnitToPixel(dSField.getRender().getWidth(), 72);
    }

    private int convertUnitToPixel(DSParagraphText dSParagraphText) {
        return Unit.convertUnitToPixel(dSParagraphText.getWidth(), 72);
    }

    private void createImage(int n, int n2, Color color) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(n).append("\\shpbottom").append(n2);
        stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(202).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFilled}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn fLine}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 2}}{\\sp{\\sn posrelv}{\\sv 2}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
        stringBuffer.append("{\\shptxt\\pard\\plain").append("\\li0\\ri0\\widctlpar").append("\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\langnp1033\\langfenp2052");
        stringBuffer.append("{\\fs").append(24);
        stringBuffer.append(' ').append("\\par");
        stringBuffer.append("}}}}}");
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color)).append("}}").append("{\\sp{\\sn fFilled}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}}}").append("\n");
        stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private void currentTimeMillis(int[] nArray, String string, int[] nArray2, Color[] colorArray, int n, int n2, int n3, String string2, Font font, int n4, int n5, Color color, Color color2, Color color3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n6 = n3 < 10 ? n3 % 3 : 3;
        int n7 = color2 == null ? 0 : 1;
        n2 = (int)(Unit.convertUnitToCentimeter(n2) * 360000.0);
        stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(nArray[2]).append("\\shpbottom").append(nArray[3]);
        stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(n7).append("}}");
        this.getEndColor(stringBuffer, n, n2, color3);
        stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
        stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 3}}{\\sp{\\sn posrelv}{\\sv 3}}");
        if (!bl) {
            stringBuffer.append("{\\sp{\\sn WrapText}{\\sv 2}}");
        }
        stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 0}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
        stringBuffer.append("{\\shptxt\\pard\\plain").append(createImage[n6]);
        FontMetrics fontMetrics = ExportToRtfFlow.getForecolor(font);
        int n8 = Unit.convertPixelToUnit(nArray[3], 1440);
        n8 = Unit.convertUnitToPixel(n8 - n4 * n5, 1440);
        int n9 = -1;
        if (n3 > 2 && n3 <= 5 || n3 == 10) {
            n9 = n8 / 2 - fontMetrics.getAscent() - fontMetrics.getDescent();
        } else if (n3 > 5 && n3 <= 8 || n3 == 11) {
            n9 = n8 - fontMetrics.getAscent() - fontMetrics.getDescent();
        }
        if (n9 > 0) {
            stringBuffer.append("\\sb").append(n9).append(currentTimeMillis);
        }
        stringBuffer.append("\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\langnp1033\\langfenp2052");
        stringBuffer.append("{\\fs").append(nArray2[4]);
        if (color != null) {
            stringBuffer.append("\\cf").append(this.getFontRender(color));
        }
        if (string2 != null) {
            Integer n10 = (Integer)this.getColorProperty.get(string2);
            stringBuffer.append("\\f").append(n10 == null ? 0 : n10);
        }
        stringBuffer.append(nArray2[0] == 1 ? fillRect[0] : "").append(nArray2[1] == 1 ? fillRect[1] : "").append(nArray2[2] == 1 ? fillRect[2] : "").append(nArray2[3] == 1 ? fillRect[3] : "");
        string = this.prepareText(string);
        stringBuffer.append(' ').append(string);
        stringBuffer.append("\\par");
        stringBuffer.append("}}}}}");
        stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
        stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(nArray[2]).append("\\pichgoal").append(nArray[3]).append("\\wmetafile8").append("}}}}").append("\n");
        stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private void cyan(boolean bl, int[] nArray, String string, int[] nArray2, Color[] colorArray, Font font, int n, int n2, int n3, int n4, int n5, int n6, String string2, Color color, Color color2, Color color3, boolean bl2, StringBuffer stringBuffer, LinkInfo linkInfo) {
        int n7 = n3 < 10 ? n3 % 3 : 3;
        int n8 = color2 == null ? 0 : 1;
        n2 = (int)(Unit.convertUnitToCentimeter(n2) * 360000.0);
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst");
        if (bl) {
            stringBuffer.append("\\shpleft").append(0).append("\\shptop").append(0).append("\\shpright").append(nArray[2]).append("\\shpbottom").append(nArray[3]);
            stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore");
            stringBuffer.append("\\shpwr2\\shpwrk0");
        } else {
            if (this.getFontInfo == 1) {
                stringBuffer.append("\\shpleft").append(nArray[0]).append("\\shptop").append(nArray[1] + this.getFontRender).append("\\shpright").append(nArray[0] + nArray[2]).append("\\shpbottom").append(nArray[1] + nArray[3] + this.getFontRender);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(nArray[0]).append("\\shptop").append(nArray[1] - this.getGradientEndColor).append("\\shpright").append(nArray[0] + nArray[2]).append("\\shpbottom").append(nArray[1] + nArray[3] - this.getGradientEndColor);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
        }
        stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++);
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[5]).append("}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
        if (color2 != null) {
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
        }
        this.getEndColor(stringBuffer, n, n2, color3);
        if (bl) {
            stringBuffer.append("{\\sp{\\sn posh}{\\sv ").append(n6).append("}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}");
        }
        if (this.getFontInfo == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        if (bl && !bl2) {
            stringBuffer.append("{\\sp{\\sn WrapText}{\\sv 2}}");
        }
        if (bl) {
            stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        }
        stringBuffer.append("{\\shptxt\\pard\\plain").append(createImage[n7]);
        FontMetrics fontMetrics = ExportToRtfFlow.getForecolor(font);
        int n9 = Unit.convertPixelToUnit(nArray[3], 1440);
        n9 = Unit.convertUnitToPixel(n9 - n5 * n4, 1440);
        int n10 = -1;
        if (n3 > 2 && n3 <= 5 || n3 == 10) {
            n10 = n9 / 2 - fontMetrics.getAscent() - fontMetrics.getDescent();
        } else if (n3 > 5 && n3 <= 8 || n3 == 11) {
            n10 = n9 - fontMetrics.getAscent() - fontMetrics.getDescent();
        }
        if (n10 > 0) {
            stringBuffer.append("\\sb").append(n10).append(currentTimeMillis);
        }
        stringBuffer.append("\\li0\\ri0\\widctlpar");
        stringBuffer.append("\\aspalpha\\aspnum\\faauto\\adjustright\\langnp1033\\langfenp2052");
        stringBuffer.append("\\dntblnsbdb");
        if (linkInfo != null) {
            FontInfo fontInfo = new FontInfo();
            fontInfo.setFontSize(nArray2[4] / 2);
            fontInfo.setFontName(string2);
            fontInfo.setBold(nArray2[0] == 1);
            fontInfo.setItaliac(nArray2[1] == 1);
            HyperLinkInfo hyperLinkInfo = new HyperLinkInfo(linkInfo.getLink(), string, color, null, fontInfo, linkInfo.isLinkReport() ? (byte)1 : 0);
            stringBuffer.append(this.FALSE(hyperLinkInfo, false));
        } else {
            stringBuffer.append("\\fs").append(nArray2[4]);
            if (nArray2[3] == 1) {
                this.getGridInfo(stringBuffer, nArray2[6]);
            }
            if (colorArray[1] != null) {
                stringBuffer.append("\\ulc").append(this.getFontRender(colorArray[1]));
            }
            if (color != null) {
                stringBuffer.append("\\cf").append(this.getFontRender(color));
            }
            if (string2 != null) {
                Integer n11 = (Integer)this.getColorProperty.get(string2);
                stringBuffer.append("\\f").append(n11 == null ? 0 : n11);
            }
            stringBuffer.append(nArray2[0] == 1 ? fillRect[0] : "").append(nArray2[1] == 1 ? fillRect[1] : "").append(nArray2[2] == 1 ? fillRect[2] : "");
            string = this.prepareText(string);
            stringBuffer.append(' ').append(string);
        }
        stringBuffer.append("\\par");
        stringBuffer.append("}}}}").append("\n");
    }

    private void deIndent(boolean bl, int[] nArray, String string, int[] nArray2, Color[] colorArray, Font font, int n, int n2, int n3, int n4, int n5, int n6, String string2, Color color, Color color2, Color color3, boolean bl2, LinkInfo linkInfo) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.cyan(bl, nArray, string, nArray2, colorArray, font, n, n2, n3, n4, n5, n6, string2, color, color2, color3, bl2, stringBuffer, linkInfo);
        this.getCells.write(stringBuffer.toString());
        stringBuffer = null;
    }

    private void delete(DSBarcode dSBarcode, int n) throws IOException, JRStopEngineException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSBarcode.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSBarcode, n) + offset.dy);
        int n4 = dSBarcode.getWidth();
        int n5 = dSBarcode.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getGradientStartColor(dSBarcode);
        n8 = n8 == 2 ? 3 : n8;
        Rectangle rectangle = dSBarcode.getBounds();
        JReportBarcode jReportBarcode = new JReportBarcode();
        jReportBarcode.setBounds(rectangle);
        jReportBarcode.setProperty(dSBarcode);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        jReportBarcode.paint(graphics);
        LinkInfo linkInfo = this.ConvertProperties(dSBarcode);
        switch (this.getGreen(dSBarcode)) {
            case 1: {
                this.getAscent(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                this.getAscent(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 3: {
                this.get(bufferedImage, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSBarcode.getParent()) instanceof DSParagraph && !dSBarcode.equals(dSBarcode.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(bufferedImage, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
    }

    private void dispose(DSField dSField, Render render, StringBuffer stringBuffer, int n) throws IOException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSField.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSField, n) + offset.dy);
        int n4 = render.getWidth();
        int n5 = render.getHeight();
        int n6 = this.CONTACT(n2 + n4 - 1);
        int n7 = this.CONTACT(n3 + n5 - 1);
        jet.export.util.ImageInfo imageInfo = this.getGreen.getImage(true, false, render);
        Image image = imageInfo.getImage();
        if (image == null) {
            return;
        }
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(n6 + 216).append("\\pich").append(n7 + 48).append("\\pngblip ");
        ImageEncoder imageEncoder = new ImageEncoder();
        stringBuffer.append(this.getHGap(imageEncoder.renderImageToPNG(image)));
        stringBuffer.append(_colSpan).append("\n");
    }

    private void dx(DSField dSField, int n, int n2, StringBuffer stringBuffer) {
        Serializable serializable;
        int[] nArray = new int[7];
        String string = dSField.toString();
        jet.export.util.FontInfo fontInfo = this.cache.getFontInfo(dSField);
        String string2 = fontInfo.getFontName();
        Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
        int n3 = fontInfo.getFontSize();
        nArray[4] = this.getFontInfo(n3);
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "Bold");
        boolean bl2 = CCUtil.getBooleanPropertyByName(dSField, "Italic");
        int n4 = 0;
        if (bl) {
            n4 |= 1;
        }
        if (bl2) {
            n4 |= 2;
        }
        Font font = FontSets.getFont(string2, n4, 10);
        n4 = FontSets.getTrueFontStyleForUser(string2, n4);
        string2 = font.getFamily();
        bl = (n4 & 1) == 1;
        bl2 = (n4 & 2) == 2;
        string2 = this.getFontName(string2);
        if (bl) {
            nArray[0] = 1;
        }
        if (bl2) {
            nArray[1] = 1;
        }
        if (CCUtil.getBooleanPropertyByName(dSField, "StrikeOut")) {
            nArray[2] = 1;
        }
        if (CCUtil.getBooleanPropertyByName(dSField, "Underline")) {
            nArray[3] = 1;
        }
        stringBuffer.append("{\\li").append(n).append("\\ri").append(n).append("\\sb").append(n2);
        stringBuffer.append("\\fs").append(nArray[4]);
        if (color != null) {
            this.getFontRender(color);
            stringBuffer.append("\\cf").append(this.getColor.get(color));
        }
        if (string2 != null) {
            serializable = (Integer)this.getColorProperty.get(string2);
            stringBuffer.append("\\f").append(serializable == null ? 0 : serializable);
        }
        stringBuffer.append(nArray[0] == 1 ? fillRect[0] : "").append(nArray[1] == 1 ? fillRect[1] : "").append(nArray[2] == 1 ? fillRect[2] : "").append(nArray[3] == 1 ? fillRect[3] : "");
        serializable = CCUtil.getColorPropertyByName(dSField, "Background");
        if (serializable != null) {
            this.getFontRender((Color)serializable);
            stringBuffer.append("\\chshdng0").append("\\chcbpat").append(this.getColor.get(serializable));
        }
        string = this.prepareText(string);
        stringBuffer.append(' ').append(string);
        stringBuffer.append("}");
    }

    private void dy(String string, int[] nArray, int n, String string2, Color[] colorArray, Color color, Color color2, StringBuffer stringBuffer, LinkInfo linkInfo) {
        if (linkInfo != null) {
            FontInfo fontInfo = new FontInfo();
            fontInfo.setFontSize(nArray[4] / 2);
            fontInfo.setFontName(string2);
            fontInfo.setBold(nArray[0] == 1);
            fontInfo.setItaliac(nArray[1] == 1);
            HyperLinkInfo hyperLinkInfo = new HyperLinkInfo(linkInfo.getLink(), string, color, null, fontInfo, linkInfo.isLinkReport() ? (byte)1 : 0);
            stringBuffer.append(this.FALSE(hyperLinkInfo, false));
        } else {
            stringBuffer.append("{\\fs").append(nArray[4]);
            switch (n) {
                case 2: {
                    stringBuffer.append("\\super");
                    break;
                }
                case 3: {
                    stringBuffer.append("\\sub");
                }
            }
            if (nArray[3] == 1) {
                this.getGridInfo(stringBuffer, nArray[6]);
            }
            if (colorArray[1] != null) {
                stringBuffer.append("\\ulc").append(this.getFontRender(colorArray[1]));
            }
            if (color != null) {
                stringBuffer.append("\\cf").append(this.getFontRender(color));
            }
            if (string2 != null) {
                Integer n2 = (Integer)this.getColorProperty.get(string2);
                stringBuffer.append("\\f").append(n2 == null ? 0 : n2);
            }
            stringBuffer.append(nArray[0] == 1 ? fillRect[0] : "").append(nArray[1] == 1 ? fillRect[1] : "").append(nArray[2] == 1 ? fillRect[2] : "");
            if (color2 != null) {
                stringBuffer.append("\\chshdng0").append("\\chcbpat").append(this.getFontRender(color2));
            }
            string = this.prepareText(string);
            stringBuffer.append(' ').append(string);
            stringBuffer.append("}").append("\n");
        }
    }

    private void elementAt(String string, int[] nArray, int n, String string2, Color[] colorArray, Color color, Color color2, LinkInfo linkInfo) {
        StringBuffer stringBuffer = new StringBuffer(256);
        this.dy(string, nArray, n, string2, colorArray, color, color2, stringBuffer, linkInfo);
        this.getCells.write(stringBuffer.toString());
        stringBuffer = null;
    }

    private void elements(DSSubReport dSSubReport, int n) throws IOException, JRStopEngineException {
        int n2;
        Vector<JRObjectResult> vector = new Vector<JRObjectResult>();
        Vector<JRObjectResult> vector2 = new Vector<JRObjectResult>();
        Vector vector3 = dSSubReport.getChildren();
        int n3 = dSSubReport.getStartYPos();
        switch (this.getGreen(dSSubReport)) {
            case 1: {
                int n4;
                JRObjectResult jRObjectResult;
                int n5;
                ++this.getFontMetrics;
                this.endsWith(dSSubReport, n);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSSubReport.getX(), this.getY(dSSubReport, n)));
                ArrayList<JRObjectResult> arrayList = new ArrayList();
                ArrayList<JRObjectResult> arrayList2 = new ArrayList();
                for (n5 = 0; n5 < vector3.size(); ++n5) {
                    jRObjectResult = this.getRealObject((JRObjectResult)vector3.get(n5));
                    if (!this.isExport(jRObjectResult)) continue;
                    n4 = jRObjectResult.getObjectType();
                    if (jRObjectResult instanceof DSTable) {
                        arrayList.add(jRObjectResult);
                        continue;
                    }
                    if ((n4 & 0x10) == 16) {
                        if (n4 == 22) {
                            vector2.add(jRObjectResult);
                            continue;
                        }
                        vector.add(jRObjectResult);
                        continue;
                    }
                    arrayList2.add(jRObjectResult);
                }
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    jRObjectResult = (JRObjectResult)arrayList.get(n5);
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n3);
                }
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    jRObjectResult = (JRObjectResult)arrayList2.get(n5);
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n3);
                }
                --this.getFontMetrics;
                break;
            }
            default: {
                int n4;
                JRObjectResult jRObjectResult;
                int n5;
                ++this.getFloatPropertyByName;
                this._isMergeRowHead(dSSubReport);
                this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSSubReport.getX(), this.getY(dSSubReport, n)));
                ArrayList<JRObjectResult> arrayList = new ArrayList<JRObjectResult>();
                ArrayList<JRObjectResult> arrayList2 = new ArrayList<JRObjectResult>();
                for (n5 = 0; n5 < vector3.size(); ++n5) {
                    jRObjectResult = this.getRealObject((JRObjectResult)vector3.get(n5));
                    if (!this.isExport(jRObjectResult)) continue;
                    n4 = jRObjectResult.getObjectType();
                    if (jRObjectResult instanceof DSTable) {
                        arrayList.add(jRObjectResult);
                        continue;
                    }
                    if ((n4 & 0x10) == 16) {
                        if (n4 == 22) {
                            vector2.add(jRObjectResult);
                            continue;
                        }
                        vector.add(jRObjectResult);
                        continue;
                    }
                    arrayList2.add(jRObjectResult);
                }
                for (n5 = 0; n5 < arrayList.size(); ++n5) {
                    jRObjectResult = (JRObjectResult)arrayList.get(n5);
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n3);
                }
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    jRObjectResult = (JRObjectResult)arrayList2.get(n5);
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n3);
                }
                this._object(dSSubReport);
                --this.getFloatPropertyByName;
                break;
            }
        }
        this.getHalByOld.pop();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.getDefaultToolkit((DSShape)vector.get(n2));
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            this.getDefaultToolkit((DSShape)vector2.get(n2));
        }
    }

    protected boolean BorderIsRound(JRVisiableResult jRVisiableResult) {
        boolean bl = false;
        BorderProperties borderProperties = DrawBorderAdapter.ConvertBorderProperties(jRVisiableResult, 72);
        int n = borderProperties.getBorderJoint();
        if (n == BorderProperties.BORDERJOINT_ROUND) {
            bl = true;
        }
        return bl;
    }

    protected int getBorderFigureStyle(JRVisiableResult jRVisiableResult) {
        BorderProperties borderProperties = DrawBorderAdapter.ConvertBorderProperties(jRVisiableResult, 72);
        int n = borderProperties.getBorderJoint();
        return n;
    }

    private void endsWith(DSContainer dSContainer, int n) throws IOException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSContainer.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSContainer, n) + offset.dy);
        int n4 = this.CONTACT(dSContainer.getWidth());
        int n5 = this.CONTACT(dSContainer.getHeight());
        FillInfo fillInfo = dSContainer.getObjectType() == 262178 ? null : this.getFillProperty(dSContainer);
        if (fillInfo != null) {
            this.getFillPatternType(n2, n3, n4, n5, fillInfo, false);
        }
        this.equals(n2, n3, n4, n5, dSContainer);
    }

    protected FillInfo getFillProperty(JRObjectResult jRObjectResult) throws IOException {
        FillPatternProperties fillPatternProperties = FillPatternAdapter.ConvertProperties(jRObjectResult);
        FillInfo fillInfo = new FillInfo();
        int n = fillPatternProperties.getFillPatternType();
        if (n == FillPatternProperties.FILL_COLOR && fillPatternProperties.getBackgroundColor() == null) {
            return null;
        }
        if (n == FillPatternProperties.FILL_COLOR) {
            fillInfo.setFillColor(fillPatternProperties.getBackgroundColor());
        } else if (n == FillPatternProperties.FILL_IMAGE) {
            ImageInfo imageInfo = new ImageInfo(fillPatternProperties.getImage(), fillPatternProperties.getImageWidth(), fillPatternProperties.getImageHeight());
            fillInfo.setImage(imageInfo);
        } else {
            Color color = fillPatternProperties.getGradientStartColor();
            Color color2 = fillPatternProperties.getGradientEndColor();
            int n2 = fillPatternProperties.getTransparency();
            GradientInfo gradientInfo = new GradientInfo(color, color2, n2);
            fillInfo.setGradient(gradientInfo);
        }
        return fillInfo;
    }

    protected ImageInfo getGroundImage(JRVisiableResult jRVisiableResult) throws IOException {
        Rectangle rectangle = jRVisiableResult.getBounds();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        FillPatternAdapter fillPatternAdapter = new FillPatternAdapter(jRVisiableResult);
        fillPatternAdapter.fillPattern(graphics, rectangle);
        graphics.dispose();
        int n = Unit.convertPixelToUnit(((Image)bufferedImage).getWidth(null));
        int n2 = Unit.convertPixelToUnit(((Image)bufferedImage).getHeight(null));
        n = this.CONTACT(n);
        n2 = this.CONTACT(n2);
        ImageInfo imageInfo = new ImageInfo(bufferedImage, n, n2);
        return imageInfo;
    }

    private void equals(int n, int n2, int n3, int n4, JRVisiableResult jRVisiableResult) {
        int n5;
        int[] nArray = this.equalsIgnoreCase(jRVisiableResult);
        boolean bl = false;
        if (jRVisiableResult.getPropertyByName(NEWBORDERWIDTH[0]) != null) {
            bl = true;
        }
        int[] nArray2 = this.error(jRVisiableResult, bl);
        Color[] colorArray = this.exists(jRVisiableResult, bl);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (nArray[0] != 0 && nArray2[0] != 0) {
            n5 = this.CONTACT(nArray2[0]) / 2;
            stringBuffer.append(this.getFamily(n, n2 + n5, n + n3, n2 + n5, colorArray[0], nArray2[0], nArray[0]));
        }
        if (nArray[1] != 0 && nArray2[1] != 0) {
            n5 = this.CONTACT(nArray2[1]) / 2;
            stringBuffer.append(this.getFamily(n + n5, n2, n + n5, n2 + n4, colorArray[1], nArray2[1], nArray[1]));
        }
        if (nArray[2] != 0 && nArray2[2] != 0) {
            n5 = this.CONTACT(nArray2[2]) / 2;
            stringBuffer.append(this.getFamily(n, n2 + n4 - n5, n + n3, n2 + n4 - n5, colorArray[2], nArray2[2], nArray[2]));
        }
        if (nArray[3] != 0 && nArray2[3] != 0) {
            n5 = this.CONTACT(nArray2[3]) / 2;
            stringBuffer.append(this.getFamily(n + n3 - n5, n2, n + n3 - n5, n2 + n4, colorArray[3], nArray2[3], nArray[3]));
        }
        stringBuffer.append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private int[] equalsIgnoreCase(JRVisiableResult jRVisiableResult) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = this.getIntProperty(jRVisiableResult, contains[i]);
        }
        return nArray;
    }

    private int[] error(JRVisiableResult jRVisiableResult, boolean bl) {
        int[] nArray = new int[4];
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                nArray[i] = this.getNewIntProperty(jRVisiableResult, NEWBORDERWIDTH[i]);
            }
        } else {
            int n = this.getIntProperty(jRVisiableResult, "BorderWidth");
            for (int i = 0; i < 4; ++i) {
                nArray[i] = n;
            }
        }
        return nArray;
    }

    private Color[] exists(JRVisiableResult jRVisiableResult, boolean bl) {
        Color[] colorArray = new Color[4];
        if (bl) {
            for (int i = 0; i < 4; ++i) {
                colorArray[i] = this.getNewColorProperty(jRVisiableResult, NEWBORDERCOLOR[i]);
            }
        } else {
            Color color = this.getColorProperty(jRVisiableResult, "BorderColor");
            for (int i = 0; i < 4; ++i) {
                colorArray[i] = color;
            }
        }
        return colorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportAuxInfo(JRVisiableResult jRVisiableResult, int n) throws IOException {
        block15: {
            Offset offset = (Offset)this.getHalByOld.peek();
            int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
            int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
            int n4 = this.CONTACT(jRVisiableResult.getWidth());
            int n5 = this.CONTACT(jRVisiableResult.getHeight());
            int n6 = n2 + n4;
            int n7 = n3 + n5;
            int n8 = this.getGradientStartColor(jRVisiableResult);
            n8 = n8 == 2 ? 3 : n8;
            BufferedImage bufferedImage = null;
            try {
                JRObjectRender jRObjectRender = (JRObjectRender)DynamicClassManager.getInstance().getClass((String)jRVisiableResult.getPropertyByName("UDORenderName").getObject()).newInstance();
                LinkInfo linkInfo = null;
                if (jRObjectRender == null) break block15;
                jRObjectRender.setProperty(jRVisiableResult);
                Rectangle rectangle = jRVisiableResult.getBounds();
                ((Component)((Object)jRObjectRender)).setBounds(rectangle);
                bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                try {
                    graphics.setClip(0, 0, rectangle.width, rectangle.height);
                    ((Component)((Object)jRObjectRender)).paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
                switch (this.getGreen(jRVisiableResult)) {
                    case 1: {
                        this.getAscent(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                        break;
                    }
                    case 2: {
                        this.getAscent(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                        break;
                    }
                    case 3: {
                        this.get(bufferedImage, n4, n5, linkInfo);
                        break;
                    }
                    default: {
                        if ((JRVisiableResult)((Object)jRVisiableResult.getParent()) instanceof DSParagraph && !jRVisiableResult.equals(jRVisiableResult.getParent().getChildren().get(0))) {
                            this.getCells.write("{\\par}");
                        }
                        this.get(bufferedImage, n4, n5, linkInfo);
                        this.getCells.write("{\\par}");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403003, (Throwable)classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2403004, (Throwable)instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!JRLog.isError(2)) break block15;
                JRLog.error(2, 2403005, (Throwable)illegalAccessException);
            }
        }
    }

    private void fillColor(DSPicture dSPicture, int n) throws IOException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSPicture.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSPicture, n) + offset.dy);
        int n4 = dSPicture.getWidth();
        int n5 = dSPicture.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getGradientStartColor(dSPicture);
        n8 = n8 == 2 ? 3 : n8;
        DbBinary dbBinary = (DbBinary)dSPicture.getRecord().getCell(CCUtil.getStringPropertyByName(dSPicture, "ColumnName"));
        Image image = null;
        if (!dbBinary.isNull()) {
            DataInputStream dataInputStream;
            byte[] byArray = dbBinary.get();
            int n9 = (Integer)dSPicture.getPropertyByName("MediaType").getObject();
            if (byArray != null && byArray.length > 0) {
                if (n9 == 2) {
                    n9 = PictureFileFormatDetector.getPictureFileType(byArray);
                }
                if (n9 == 4 || n9 == 0) {
                    image = BORDERJOINT_ROUND.createImage(byArray);
                } else if (n9 == 1) {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    BitmapReader bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
                    image = BORDERJOINT_ROUND.createImage(bitmapReader.getMemImgSrc());
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            dataInputStream = null;
            if (image != null) {
                switch (this.getGreen(dSPicture)) {
                    case 1: {
                        this.getAscent(image, false, n2, n3, n4, n5, n6, n7, 0, null, (LinkInfo)((Object)dataInputStream));
                        break;
                    }
                    case 2: {
                        this.getAscent(image, true, n2, n3, n4, n5, n6, n7, 0, null, (LinkInfo)((Object)dataInputStream));
                        break;
                    }
                    case 3: {
                        this.get(image, n4, n5, (LinkInfo)((Object)dataInputStream));
                        break;
                    }
                    default: {
                        if ((JRVisiableResult)((Object)dSPicture.getParent()) instanceof DSParagraph && !dSPicture.equals(dSPicture.getParent().getChildren().get(0))) {
                            this.getCells.write("{\\par}");
                        }
                        this.get(image, n4, n5, (LinkInfo)((Object)dataInputStream));
                        this.getCells.write("{\\par}");
                    }
                }
            }
        }
    }

    private void fillPattern(DSPicture dSPicture, int n, StringBuffer stringBuffer) throws IOException, JRStopEngineException {
        jet.export.util.ImageInfo imageInfo = this.getGreen.getImage(true, false, dSPicture);
        Image image = imageInfo.getImage();
        if (image == null) {
            return;
        }
        LinkInfo linkInfo = this.ConvertProperties(dSPicture);
        int n2 = dSPicture.getWidth();
        int n3 = dSPicture.getHeight();
        this.flush(image, n2, n3, stringBuffer, linkInfo);
    }

    private void fillRect(DSPicture dSPicture, int n) throws IOException, JRStopEngineException {
        StringBuffer stringBuffer = new StringBuffer();
        this.append(dSPicture, n, stringBuffer);
        this.getCells.write(stringBuffer.toString());
    }

    private void flush(Image image, int n, int n2, StringBuffer stringBuffer, LinkInfo linkInfo) throws IOException {
        Object object;
        boolean bl = false;
        if (linkInfo != null) {
            object = new HyperLinkInfo(linkInfo.getLink(), null, linkInfo.isLinkReport() ? (byte)1 : 0);
            stringBuffer.append(this.FALSE((HyperLinkInfo)object, true));
            bl = true;
        }
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(image.getWidth(null) + 216).append("\\pich").append(image.getHeight(null) + 48).append("\\pngblip ");
        object = new ImageEncoder();
        stringBuffer.append(this.getHGap(((ImageEncoder)object).renderImageToPNG(image)));
        if (bl) {
            stringBuffer.append("}}}}}\n");
        } else {
            stringBuffer.append("}}}\n");
        }
    }

    private void get(Image image, int n, int n2, LinkInfo linkInfo) throws IOException {
        if (image != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.flush(image, n, n2, stringBuffer, linkInfo);
            this.getCells.write(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    private void getAlignment(Image image, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, StringBuffer stringBuffer, LinkInfo linkInfo) throws IOException {
        Object object;
        stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst");
        if (bl) {
            stringBuffer.append("\\shpleft").append(0).append("\\shptop").append(0).append("\\shpright").append(n5).append("\\shpbottom").append(n6);
            stringBuffer.append("\\shpbxcolumn\\shpbxignore\\shpbypara\\shpbyignore");
            stringBuffer.append("\\shpwr2\\shpwrk0");
        } else {
            if (this.getFontInfo == 1) {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.getFontRender).append("\\shpright").append(n5).append("\\shpbottom").append(n6 + this.getFontRender);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getGradientEndColor).append("\\shpright").append(n5).append("\\shpbottom").append(n6 - this.getGradientEndColor);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
        }
        stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++);
        stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[5]).append("}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
        if (color == null) {
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(0).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv " + this.getFontSize(color) + "}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(1).append("}}");
        }
        this.getEndColor(stringBuffer, 0, 0, null);
        if (bl) {
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}");
        }
        if (this.getFontInfo == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        if (bl) {
            stringBuffer.append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
        }
        stringBuffer.append("{\\shptxt\\pard\\plain");
        switch (n7) {
            case 0: {
                stringBuffer.append("\\ql");
                break;
            }
            case 2: {
                stringBuffer.append("\\qc");
                break;
            }
            case 1: {
                stringBuffer.append("\\qr");
            }
        }
        boolean bl2 = false;
        if (linkInfo != null) {
            bl2 = true;
            object = new HyperLinkInfo(linkInfo.getLink(), null, linkInfo.isLinkReport() ? (byte)1 : 0);
            stringBuffer.append(this.FALSE((HyperLinkInfo)object, true));
        }
        stringBuffer.append("{{\\*\\shppict{\\pict{\\*\\picprop\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[6]).append("}}").append("{\\sp{\\sn pibFlags}{\\sv 2}}{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}").append("{\\sp{\\sn dxWrapDistLeft}{\\sv 0}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv 0}}").append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw").append(image.getWidth(null) + 216).append("\\pich").append(image.getHeight(null) + 48).append("\\pngblip ");
        object = new ImageEncoder();
        stringBuffer.append(this.getHGap(((ImageEncoder)object).renderImageToPNG(image)));
        if (bl2) {
            stringBuffer.append("}}}}}}}}}\n");
        } else {
            stringBuffer.append("}}}}}}}\n");
        }
    }

    private void getAscent(Image image, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, LinkInfo linkInfo) throws IOException {
        if (image != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.getAlignment(image, bl, n, n2, n3, n4, n5, n6, n7, color, stringBuffer, linkInfo);
            this.getCells.write(stringBuffer.toString());
            stringBuffer = null;
        }
    }

    private void getBackgroundColor(DSChartPlatform dSChartPlatform, int n) throws IOException, JRStopEngineException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSChartPlatform.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSChartPlatform, n) + offset.dy);
        int n4 = dSChartPlatform.getWidth();
        int n5 = dSChartPlatform.getHeight();
        int n6 = n2 + this.CONTACT(n4);
        int n7 = n3 + this.CONTACT(n5);
        int n8 = this.getGradientStartColor(dSChartPlatform);
        n8 = n8 == 2 ? 3 : n8;
        Rectangle rectangle = dSChartPlatform.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.dispose();
        bufferedImage.flush();
        LinkInfo linkInfo = null;
        switch (this.getGreen(dSChartPlatform)) {
            case 1: {
                this.getAscent(bufferedImage, false, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 2: {
                this.getAscent(bufferedImage, true, n2, n3, n4, n5, n6, n7, 0, null, linkInfo);
                break;
            }
            case 3: {
                this.get(bufferedImage, n4, n5, linkInfo);
                break;
            }
            default: {
                if ((JRVisiableResult)((Object)dSChartPlatform.getParent()) instanceof DSParagraph && !dSChartPlatform.equals(dSChartPlatform.getParent().getChildren().get(0))) {
                    this.getCells.write("{\\par}");
                }
                this.get(bufferedImage, n4, n5, linkInfo);
                this.getCells.write("{\\par}");
            }
        }
        if (dSChartPlatform.isHeatMapChart()) {
            this.getHalByOld.push(new Offset(offset, dSChartPlatform.getX(), this.getY(dSChartPlatform, n)));
            Vector vector = dSChartPlatform.getChildren();
            int n9 = dSChartPlatform.getStartYPos();
            for (int i = 0; i < vector.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                if (!(jRObjectResult instanceof DSChartCoordinatepaper)) continue;
                DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)jRObjectResult;
                this.getHalByOld.push(new Offset(offset, dSChartCoordinatepaper.getX(), this.getY(dSChartCoordinatepaper, n9)));
                Vector vector2 = dSChartCoordinatepaper.getChildren();
                for (int j = 0; j < vector2.size(); ++j) {
                    JRObjectResult jRObjectResult2 = (JRObjectResult)vector2.get(j);
                    if (!(jRObjectResult2 instanceof DSChartHeatMapGroupRect)) continue;
                    DSChartHeatMapGroupRect dSChartHeatMapGroupRect = (DSChartHeatMapGroupRect)jRObjectResult2;
                    linkInfo = this.ConvertProperties(dSChartHeatMapGroupRect);
                    if (linkInfo != null) {
                        this.getBlue((Offset)this.getHalByOld.peek(), dSChartHeatMapGroupRect, linkInfo);
                    }
                    this.getBookMark(dSChartHeatMapGroupRect);
                }
                this.getHalByOld.pop();
            }
            this.getHalByOld.pop();
        }
    }

    private void getBlue(Offset offset, JRVisiableResult jRVisiableResult, LinkInfo linkInfo) throws IOException {
        int n = jRVisiableResult.getWidth();
        int n2 = jRVisiableResult.getHeight();
        n = Unit.convertUnitToPixel(n, 96);
        n2 = Unit.convertUnitToPixel(n2, 96);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        n = jRVisiableResult.getWidth();
        n2 = jRVisiableResult.getHeight();
        int n3 = this.CONTACT(offset.dx + jRVisiableResult.getX());
        int n4 = this.CONTACT(offset.dy + jRVisiableResult.getY());
        int n5 = n3 + this.CONTACT(n);
        int n6 = n4 + this.CONTACT(n2);
        this.getAscent(bufferedImage, false, n3, n4, n, n2, n5, n6, 0, null, linkInfo);
    }

    private void getBookMark(DSContainer dSContainer) throws JRStopEngineException, IOException {
        Vector vector = dSContainer.getChildren();
        Offset offset = new Offset((Offset)this.getHalByOld.peek(), dSContainer.getX(), dSContainer.getY());
        for (int i = 0; i < vector.size(); ++i) {
            DSField dSField;
            LinkInfo linkInfo;
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSField) || (linkInfo = this.ConvertProperties(dSField = (DSField)jRObjectResult)) == null) continue;
            this.getBlue(offset, dSField, linkInfo);
        }
    }

    private void getBooleanProperty(DSCrossTab dSCrossTab, int n) throws IOException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSCrossTab.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSCrossTab, n) + offset.dy);
        int n4 = this.CONTACT(dSCrossTab.getWidth());
        int n5 = this.CONTACT(dSCrossTab.getHeight());
        Color color = CCUtil.getColorPropertyByName(dSCrossTab, "Background");
        int n6 = this.getGreen(dSCrossTab);
        boolean bl = CCUtil.getBooleanPropertyByName(dSCrossTab, "Hasborder");
        Color color2 = CCUtil.getColorPropertyByName(dSCrossTab, "BorderColor");
        int n7 = this.CONTACT(dSCrossTab.getHGap());
        int n8 = this.CONTACT(dSCrossTab.getVGap());
        StringBuffer stringBuffer = new StringBuffer();
        CTLayoutManager cTLayoutManager = new CTLayoutManager(dSCrossTab);
        cTLayoutManager.manageLayout();
        Hashtable hashtable = cTLayoutManager.getRows();
        if (this.getBytes) {
            if (n4 > this.getFillPatternType) {
                n4 = this.getFillPatternType;
            }
            if (n5 > this.getFillProperty) {
                n5 = this.getFillProperty;
            }
        }
        this.getCellColor(n2, n3, n4, n5, n6, 0, 0, null, null, stringBuffer);
        for (int i = 0; i < hashtable.size(); ++i) {
            Hashtable hashtable2 = ((CrossTableRow)hashtable.get(this.getBooleanPropertyByName(i))).getCells();
            int n9 = 0;
            for (int j = 0; j < hashtable2.size(); ++j) {
                CTCell cTCell = (CTCell)hashtable2.get(this.getBooleanPropertyByName(j));
                if (j == 0 && stringBuffer != null) {
                    stringBuffer.append("\\trowd\\trgaph5");
                    stringBuffer.append("\\trrh-").append(Unit.convertUnitToPixel(cTCell._height, 1440));
                    stringBuffer.append("\\trleft0\\irow").append(i).append("\\irowband").append(i).append("\\ts15");
                    stringBuffer.append("\\trftsWidth1\\trftsWidthB3\\trautofit1\\tbllkhdrrows\\tbllklastrow\\tbllkhdrcols\\tbllklastcol").append("\n");
                }
                n9 = this.getBorderJoint(cTCell, color, color2, n9, n7, n8, bl, stringBuffer);
            }
            stringBuffer.append("{\\row}\n");
        }
        this.getCells(n4, n5, n6, stringBuffer);
        this.getCells.write(stringBuffer.toString());
    }

    private Object getBooleanPropertyByName(int n) {
        if (n < 21) {
            return getImageResource[n];
        }
        return n;
    }

    private int getBorderJoint(CTCell cTCell, Color color, Color color2, int n, int n2, int n3, boolean bl, StringBuffer stringBuffer) throws IOException {
        int n4 = cTCell._rowSpan;
        int n5 = cTCell._colSpan;
        int n6 = cTCell._width;
        CTGridInfo cTGridInfo = cTCell.getGridInfo();
        DSField dSField = cTCell._object;
        int n7 = Unit.convertUnitToPixel(n6, 1440);
        Vector vector = cTGridInfo.getChildren();
        if (vector.size() <= 1) {
            if (cTCell._isMergeHead && cTCell._rowSpan > 0) {
                stringBuffer.append("\\clvmgf");
            } else if (n4 > 0) {
                stringBuffer.append("\\clvmrg");
            }
            if (cTCell._isMergeRowHead && cTCell._colSpan > 0) {
                stringBuffer.append("\\clmgf");
            } else if (n5 > 0) {
                stringBuffer.append("\\clmrg");
            }
        }
        int n8 = dSField != null ? CCUtil.getIntPropertyByName(dSField, "Alignment") : 1;
        stringBuffer.append("\\clvertalc");
        stringBuffer.append("\\clbrdrt");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getFontRender(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrl");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getFontRender(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrb");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getFontRender(color2));
        } else {
            stringBuffer.append("tbl");
        }
        stringBuffer.append("\\clbrdrr");
        stringBuffer.append("\\brdr");
        if (bl) {
            stringBuffer.append("s");
            stringBuffer.append("\\brdrw").append(1);
            stringBuffer.append("\\brdrcf").append(this.getFontRender(color2));
        } else {
            stringBuffer.append("tbl");
        }
        int n9 = n8 < 10 ? n8 % 3 : 3;
        stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n7).append("\\clshdrawnil").append(createImage[n9]);
        Color color3 = cTGridInfo.fillColor;
        if (color3 != null) {
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color3));
        } else if (color != null) {
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
        }
        stringBuffer.append("\\intbl\\cellx").append(n + n7 - 5).append(" ");
        stringBuffer.append("{");
        if (dSField != null) {
            this.getColor(dSField, n2, n3, stringBuffer, 0);
        }
        stringBuffer.append("}\\cell").append("\n");
        return n + n7;
    }

    private void getBounds(DSTableObject dSTableObject, int n) throws IOException, JRStopEngineException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = dSTableObject.getX();
        int n3 = this.getY(dSTableObject, n);
        this.getHalByOld.push(new Offset(offset, n2, n3));
        n2 = this.CONTACT(n2 + offset.dx);
        n3 = this.CONTACT(n3 + offset.dy);
        int n4 = this.CONTACT(dSTableObject.getWidth());
        int n5 = this.CONTACT(dSTableObject.getHeight());
        Color color = this.getNewColorProperty(dSTableObject, "Background");
        int n6 = this.getGreen(dSTableObject);
        if (this.getBytes) {
            if (n4 > this.getFillPatternType) {
                n4 = this.getFillPatternType;
            }
            if (n5 > this.getFillProperty) {
                n5 = this.getFillProperty;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.getCellColor(n2, n3, n4, n5, n6, 0, 0, null, null, stringBuffer);
        this.getCells.write(stringBuffer.toString());
        stringBuffer = null;
        RtfTable rtfTable = ExportLayoutFactory.getInstance(this.cache);
        TableInfo tableInfo = rtfTable.getTableInfo(dSTableObject);
        int n7 = tableInfo.getRowNumber();
        for (int i = 0; i < n7; ++i) {
            int n8 = tableInfo.getColNum(i);
            boolean bl = true;
            stringBuffer = new StringBuffer();
            stringBuffer.append("\\trowd\\trgaph0\\trleft-5");
            for (int j = 0; j < n8; ++j) {
                ObjectRectInfo objectRectInfo = tableInfo.getCell(i, j);
                if (bl) {
                    stringBuffer.append("\\trrh-").append(this.CONTACT(tableInfo.getRowHeight(i)));
                    stringBuffer.append("\\trftsWidth1\\trftsWidthB3");
                    bl = false;
                }
                if (objectRectInfo.isDep()) continue;
                this.getBytes(objectRectInfo, stringBuffer, color);
            }
            stringBuffer.append("{\\row}\n");
            this.getCells.write(stringBuffer.toString());
            stringBuffer = null;
        }
        stringBuffer = new StringBuffer();
        this.getCells(n4, n5, n6, stringBuffer);
        this.getCells.write(stringBuffer.toString());
        stringBuffer = null;
        this.getHalByOld.pop();
    }

    private void getBytes(ObjectRectInfo objectRectInfo, StringBuffer stringBuffer, Color color) throws IOException, JRStopEngineException {
        DSTableCell dSTableCell = objectRectInfo.getTableCell();
        Color color2 = objectRectInfo.getCellColor();
        if (color2 == null) {
            color2 = color;
        }
        int n = this.CONTACT(objectRectInfo.getX());
        int n2 = this.CONTACT(objectRectInfo.getWidth());
        this.getCell(n, n2, dSTableCell, color2, stringBuffer, objectRectInfo.isMergeRow(), objectRectInfo.isFirstMergeRow());
    }

    private void getCell(int n, int n2, DSTableCell dSTableCell, Color color, StringBuffer stringBuffer, boolean bl, boolean bl2) throws IOException, JRStopEngineException {
        JRVisiableResult jRVisiableResult;
        int n3;
        Object object;
        Vector vector = dSTableCell.getChildren();
        byte by = 0;
        byte by2 = 0;
        boolean bl3 = true;
        if (vector.size() == 1 && (object = (JRObjectResult)vector.get(0)) instanceof DSField) {
            DSField dSField = (DSField)object;
            by = this.getHal(dSField);
            by2 = this.getVal(dSField);
            bl3 = false;
        }
        if (bl3) {
            by = this.getHalByOld(dSTableCell);
            by2 = this.getValByOld(dSTableCell);
        }
        if (by2 == 0) {
            stringBuffer.append("\\clvertalt");
        } else if (by2 == 1) {
            stringBuffer.append("\\clvertalc");
        } else {
            stringBuffer.append("\\clvertalb");
        }
        if (bl) {
            if (bl2) {
                stringBuffer.append("\\clvmgf");
            } else {
                stringBuffer.append("\\clvmrg");
            }
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "TopLine") != 0) {
            stringBuffer.append("\\clbrdrt");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "TopLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-top-width"), 1440));
            object = CCUtil.getColorPropertyByName(dSTableCell, "border-top-color");
            stringBuffer.append("\\brdrcf").append(this.getFontRender((Color)object));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "LeftLine") != 0) {
            stringBuffer.append("\\clbrdrl");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "LeftLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-left-width"), 1440));
            object = CCUtil.getColorPropertyByName(dSTableCell, "border-left-color");
            stringBuffer.append("\\brdrcf").append(this.getFontRender((Color)object));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "BottomLine") != 0) {
            stringBuffer.append("\\clbrdrb");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "BottomLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-bottom-width"), 1440));
            object = CCUtil.getColorPropertyByName(dSTableCell, "border-bottom-color");
            stringBuffer.append("\\brdrcf").append(this.getFontRender((Color)object));
        }
        if (CCUtil.getIntPropertyByName(dSTableCell, "RightLine") != 0) {
            stringBuffer.append("\\clbrdrr");
            stringBuffer.append("\\brdr").append(this.getColorPropertyByName(CCUtil.getIntPropertyByName(dSTableCell, "RightLine")));
            stringBuffer.append("\\brdrw").append(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(dSTableCell, "border-right-width"), 1440));
            object = CCUtil.getColorPropertyByName(dSTableCell, "border-right-color");
            stringBuffer.append("\\brdrcf").append(this.getFontRender((Color)object));
        }
        stringBuffer.append("\\cltxlrtb\\clftsWidth3\\clwWidth").append(n2).append("\\clshdrawnil");
        if (by == 0) {
            stringBuffer.append("\\ql");
        } else if (by == 2) {
            stringBuffer.append("\\qc");
        } else if (by == 1) {
            stringBuffer.append("\\qr");
        } else {
            stringBuffer.append("\\qj");
        }
        if (color != null) {
            stringBuffer.append("\\clcbpat").append(this.getFontRender(color));
        }
        stringBuffer.append("\\intbl\\cellx").append(n + n2 - 5).append(" ");
        stringBuffer.append("{");
        for (n3 = 0; vector.size() > 1 && n3 < vector.size(); ++n3) {
            JRVisiableResult jRVisiableResult2 = (JRVisiableResult)vector.get(n3);
            for (int i = n3 + 1; i < vector.size(); ++i) {
                jRVisiableResult = (JRVisiableResult)vector.get(i);
                if (jRVisiableResult.getX() >= jRVisiableResult2.getX()) continue;
                vector.remove(i);
                vector.add(n3, jRVisiableResult);
                jRVisiableResult2 = jRVisiableResult;
            }
        }
        n3 = dSTableCell.getStartYPos();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (jRObjectResult instanceof DSField) {
                jRVisiableResult = (DSField)jRObjectResult;
                this.getColor((DSField)jRVisiableResult, 0, 0, stringBuffer, n3);
                continue;
            }
            if (jRObjectResult instanceof DSChartPlatform) {
                jRVisiableResult = (DSChartPlatform)jRObjectResult;
                this.getClass((DSChartPlatform)jRVisiableResult, stringBuffer, n3);
                continue;
            }
            if (jRObjectResult instanceof DSPicture) {
                jRVisiableResult = (DSPicture)jRObjectResult;
                this.fillPattern((DSPicture)jRVisiableResult, n3, stringBuffer);
                continue;
            }
            if (!(jRObjectResult instanceof DSParagraph) || ((DSContainer)(jRVisiableResult = (DSParagraph)jRObjectResult)).getChildren().size() == 0) continue;
            this.addImage((DSParagraph)jRVisiableResult, n3, stringBuffer, true);
        }
        stringBuffer.append("\\e2\\cell}");
    }

    private void getCellColor(int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, Color color2, StringBuffer stringBuffer) {
        int n8 = color == null ? 0 : 1;
        n7 = (int)(Unit.convertUnitToCentimeter(n7) * 360000.0);
        if (n5 == 4) {
            stringBuffer.append("{\\field\\fldedit\\fldlock{\\*\\fldinst").append("{\\hich\\af0\\dbch\\af13\\loch\\f0  SHAPE  \\\\* MERGEFORMAT }}").append("{\\fldrslt");
            stringBuffer.append("{\\lang1024\\langfe1024{\\shp{\\*\\shpinst").append("\\shpleft0\\shptop0\\shpright").append(n3).append("\\shpbottom").append(n4);
            stringBuffer.append("\\shpbxcolumn\\hpbxignore\\shpbypara\\shpbyignore\\shpwr3\\shpwrk0\\shpfblwtxt0\\shplockanchor");
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}{\\sp{\\sn fFlipV}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}");
            stringBuffer.append("{\\sp{\\sn dxWrapDistLeft}{\\sv ").append(0).append("}}").append("{\\sp{\\sn dxWrapDistRight}{\\sv ").append(0).append("}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
            stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv ").append(0).append("}}");
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 3}}{\\sp{\\sn posrelv}{\\sv 3}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}{\\sp{\\sn fAllowOverlap}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 0}}{\\sp{\\sn fLayoutInCell}{\\sv 1}}");
            this.getEndColor(stringBuffer, n6, n7, color2);
            stringBuffer.append("{\\shptxt").append("\n");
        } else {
            stringBuffer.append("{\\lang1024\\langfe1024\\noproof{\\shp{\\*\\shpinst");
            if (this.getFontInfo == 1) {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.getFontRender).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 + this.getFontRender);
                stringBuffer.append("\\shpbxmargin\\shpbypage");
            } else {
                stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getGradientEndColor).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 - this.getGradientEndColor);
                stringBuffer.append("\\shpbxmargin\\shpbymargin");
            }
            stringBuffer.append("\\shpwr3\\shpwrk2");
            stringBuffer.append("\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++);
            stringBuffer.append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[5]).append("}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn dxTextLeft}{\\sv 0}}").append("{\\sp{\\sn dyTextTop}{\\sv 0}}").append("{\\sp{\\sn dxTextRight}{\\sv 0}}").append("{\\sp{\\sn dyTextBottom}{\\sv 0}}").append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}").append("{\\sp{\\sn fRecolorFillAsPicture}{\\sv 0}}");
            if (this.getFontInfo == 1) {
                stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
            } else {
                stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
            }
            stringBuffer.append("{\\sp{\\sn fFitTextToShape}{\\sv 1}}");
            stringBuffer.append("{\\sp{\\sn fFilled}{\\sv ").append(n8).append("}}");
            this.getEndColor(stringBuffer, n6, n7, color2);
            stringBuffer.append("{\\shptxt").append("\n");
        }
    }

    private void getCells(int n, int n2, int n3, StringBuffer stringBuffer) {
        if (n3 == 4) {
            stringBuffer.append("\\pard\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\itap0 {\\par }");
            stringBuffer.append("}}}}");
            stringBuffer.append("{{\\pict{\\*\\picprop\\defshp").append("{\\sp{\\sn shapeType}{\\sv 75}}").append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fLayoutInCell}{\\sv 1}}}");
            stringBuffer.append("\\picscalex100\\picscaley100\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picwgoal").append(n).append("\\pichgoal").append(n2).append("\\wmetafile8").append("}}}}").append("\n");
            stringBuffer.append("\\sectd\\linex0\\endnhere\\sectdefaultcl").append("{\\par}").append("\n");
        } else {
            stringBuffer.append("\\pard\\ql\\li0\\ri0\\widctlpar\\aspalpha\\aspnum\\faauto\\adjustright\\rin0\\lin0\\itap0 {\\par }");
            stringBuffer.append("}}}}").append("\n");
        }
    }

    private void getChildren(DSTableCell dSTableCell, Color color, boolean bl, StringBuffer stringBuffer) throws IOException, JRStopEngineException {
        JRVisiableResult jRVisiableResult = (JRVisiableResult)((Object)dSTableCell.getParent());
        int n = bl ? this.CONTACT(jRVisiableResult.getX()) : this.CONTACT(dSTableCell.getX());
        int n2 = this.CONTACT(dSTableCell.getWidth());
        Color color2 = CCUtil.getColorPropertyByName(dSTableCell, "Background");
        if (color2 == null) {
            color2 = color;
        }
        this.getCell(n, n2, dSTableCell, color2, stringBuffer, false, false);
    }

    private void getClass(DSChartPlatform dSChartPlatform, StringBuffer stringBuffer, int n) throws IOException, JRStopEngineException {
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSChartPlatform.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(dSChartPlatform, n) + offset.dy);
        int n4 = dSChartPlatform.getWidth();
        int n5 = dSChartPlatform.getHeight();
        int n6 = this.CONTACT(n2 + n4 - 1);
        int n7 = this.CONTACT(n3 + n5 - 1);
        Rectangle rectangle = dSChartPlatform.getBounds();
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        dSChartPlatform.paint(graphics);
        LinkInfo linkInfo = null;
        this.getColNum(n4, n5, bufferedImage, stringBuffer, linkInfo);
        if (dSChartPlatform.isHeatMapChart()) {
            this.getHalByOld.push(new Offset(offset, dSChartPlatform.getX(), this.getY(dSChartPlatform, n)));
            Vector vector = dSChartPlatform.getChildren();
            int n8 = dSChartPlatform.getStartYPos();
            for (int i = 0; i < vector.size(); ++i) {
                JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                if (!(jRObjectResult instanceof DSChartCoordinatepaper)) continue;
                DSChartCoordinatepaper dSChartCoordinatepaper = (DSChartCoordinatepaper)jRObjectResult;
                this.getHalByOld.push(new Offset(offset, dSChartCoordinatepaper.getX(), this.getY(dSChartCoordinatepaper, n8)));
                Vector vector2 = dSChartCoordinatepaper.getChildren();
                for (int j = 0; j < vector2.size(); ++j) {
                    JRObjectResult jRObjectResult2 = (JRObjectResult)vector2.get(j);
                    if (!(jRObjectResult2 instanceof DSChartHeatMapGroupRect)) continue;
                    DSChartHeatMapGroupRect dSChartHeatMapGroupRect = (DSChartHeatMapGroupRect)jRObjectResult2;
                    linkInfo = this.ConvertProperties(dSChartHeatMapGroupRect);
                    if (linkInfo != null) {
                        this.getBlue((Offset)this.getHalByOld.peek(), dSChartHeatMapGroupRect, linkInfo);
                    }
                    this.getBookMark(dSChartHeatMapGroupRect);
                }
                this.getHalByOld.pop();
            }
            this.getHalByOld.pop();
        }
    }

    private void getColNum(int n, int n2, Image image, StringBuffer stringBuffer, LinkInfo linkInfo) throws IOException {
        if (image != null) {
            n = Unit.convertUnitToPixel(n, 96);
            n2 = Unit.convertUnitToPixel(n2, 96);
            if (image.getWidth(null) != n || image.getHeight(null) != n2) {
                image = image.getScaledInstance(n, n2, 4);
            }
            this.getGradient(image);
            if (n != 0 && n2 != 0 && image.getWidth(null) == 0 && image.getHeight(null) == 0) {
                for (int i = 0; i < 200 && image.getWidth(null) == 0 && image.getHeight(null) == 0; ++i) {
                    this.getGradient(image);
                }
            }
            this.get(image, n, n2, linkInfo);
        }
    }

    private void getColor(DSField dSField, int n, int n2, StringBuffer stringBuffer, int n3) throws IOException {
        Render render;
        block6: {
            render = dSField.getRender();
            if (dSField.getObjectType() == 264) {
                try {
                    this.delete((DSBarcode)dSField, n3);
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block6;
                    JRLog.error(2, 2403002, (Throwable)exception);
                }
            }
        }
        if (dSField.getObjectType() != 264) {
            if (render instanceof RenderText) {
                this.dx(dSField, n, n2, stringBuffer);
            } else {
                this.dispose(dSField, render, stringBuffer, n3);
            }
        }
    }

    private void getColorProperty(DSContainer dSContainer, int n) throws IOException, JRStopEngineException {
        StringBuffer stringBuffer = new StringBuffer(256);
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.getY(dSContainer, n) + offset.dy;
        int n3 = this.CONTACT(dSContainer.getX() + offset.dx);
        int n4 = this.CONTACT(n2);
        int n5 = this.CONTACT(dSContainer.getWidth());
        int n6 = this.CONTACT(dSContainer.getHeight());
        Color color = this.getColorProperty((JRObjectResult)dSContainer, "Background");
        int n7 = this.getGreen(dSContainer);
        int n8 = 0;
        int n9 = this.getIntProperty(dSContainer, "LeftLine");
        int n10 = this.getIntProperty(dSContainer, "RightLine");
        int n11 = this.getIntProperty(dSContainer, "TopLine");
        int n12 = this.getIntProperty(dSContainer, "BottomLine");
        int n13 = -1;
        Color color2 = null;
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        n13 = this.getIntProperty(dSContainer, "BorderWidth");
        color2 = this.getColorProperty((JRObjectResult)dSContainer, "BorderColor");
        if (n9 != 0) {
            n8 = n9;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-left-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n11 != 0) {
            n8 = n11;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-top-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n10 != 0) {
            n8 = n10;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-right-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        } else if (n12 != 0) {
            n8 = n12;
            n13 = CCUtil.getIntPropertyByName(dSContainer, "border-bottom-width");
            color2 = CCUtil.getColorPropertyByName(dSContainer, "border-top-color");
        }
        Vector vector = dSContainer.getChildren();
        int n14 = dSContainer.getStartYPos();
        switch (this.getGreen(dSContainer)) {
            case 1: {
                ++this.getFontMetrics;
                this.getCurrentCommunicator = n2 + dSContainer.getHeight();
                if (color != null) {
                    FillInfo fillInfo = new FillInfo();
                    fillInfo.setFillColor(color);
                    this.getFillPatternType(n3, n4, n5, n6, fillInfo, false);
                }
                for (int i = 0; i < vector.size(); ++i) {
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n14);
                }
                this.getHalByOld.pop();
                this.getFloatPropertyByName(dSContainer, n);
                this.getCurrentCommunicator = -1;
                --this.getFontMetrics;
                break;
            }
            default: {
                ++this.getFontName;
                this.getCellColor(n3, n4, n5, n6, n7, n8, n13, color, color2, stringBuffer);
                this.getCells.write(stringBuffer.toString());
                int n15 = CCUtil.getIntPropertyByName(dSContainer, "VerticalAlignment");
                for (int i = 0; i < vector.size(); ++i) {
                    this.getCell = i == 0 && n15 != 1;
                    JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
                    if (!this.isExport(jRObjectResult)) continue;
                    this.FILL_COLOR(jRObjectResult, jRObjectResult.getObjectType(), n14);
                }
                stringBuffer = new StringBuffer(256);
                this.getCells(n5, n6, n7, stringBuffer);
                this.getCells.write(stringBuffer.toString());
                --this.getFontName;
                this.getHalByOld.pop();
                break;
            }
        }
    }

    private String getColorPropertyByName(int n) {
        switch (n) {
            case 0: {
                return "tbl";
            }
            case 1: {
                return "s";
            }
            case 2: {
                return "dash";
            }
            case 3: {
                return "dot";
            }
            case 4: {
                return "dashd";
            }
            case 5: {
                return "db";
            }
        }
        return "s";
    }

    private void getCurrentCommunicator(DSTable dSTable, int n) throws IOException {
        Vector vector;
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(dSTable.getX() + offset.dx);
        int n3 = this.getY(dSTable, n);
        this.getHalByOld.push(new Offset((Offset)this.getHalByOld.peek(), dSTable.getX(), n3));
        n3 = this.CONTACT(dSTable.getY() + offset.dy);
        int n4 = this.CONTACT(dSTable.getWidth());
        int n5 = this.CONTACT(dSTable.getHeight());
        FillInfo fillInfo = this.getFillProperty(dSTable);
        Rectangle rectangle = new Rectangle(n2, n3, n4, n5);
        if (fillInfo != null) {
            this.getFillPatternType(n2, n3, n4, n5, fillInfo, false);
        }
        if ((vector = dSTable.getChildren()) != null) {
            this.getDataStream(vector, rectangle);
        }
        if (CCUtil.getBooleanPropertyByName(dSTable, "ShowBorder")) {
            this.getDisplay(new ShapeInfo(n2, n3, n4, n5, Color.black, null, 1, getBackgroundColor, 1));
        }
        this.getHalByOld.pop();
    }

    private void getDataStream(Vector vector, Rectangle rectangle) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(256);
        DSColumn dSColumn = null;
        Color color = null;
        int n = rectangle.y;
        int n2 = rectangle.height;
        Offset offset = (Offset)this.getHalByOld.peek();
        for (int i = 0; i < vector.size(); ++i) {
            dSColumn = (DSColumn)vector.elementAt(i);
            int n3 = this.CONTACT(dSColumn.getX() + offset.dx) + rectangle.x;
            int n4 = this.CONTACT(dSColumn.getWidth());
            color = CCUtil.getColorPropertyByName(dSColumn, "Background");
            if (color != null) {
                FillInfo fillInfo = new FillInfo();
                fillInfo.setFillColor(color);
                this.getFillPatternType(n3 + 1, n + 1, n4 - 2, n2 - 1, fillInfo, false);
            }
            if (!CCUtil.getBooleanPropertyByName(dSColumn, "ShowBorder")) continue;
            stringBuffer.append(this.getFamily(n3 + n4 - 1, n, n3 + n4 - 1, n + n2, Color.black, getBackgroundColor, 1));
        }
        this.getCells.write(stringBuffer.toString());
    }

    private void getDefaultToolkit(DSShape dSShape) throws IOException {
        DSShapeRegion dSShapeRegion;
        Rectangle rectangle;
        int n = dSShape.getObjectType();
        Color color = null;
        int n2 = 0;
        int n3 = 0;
        if (n != 18 && (rectangle = (dSShapeRegion = new DSShapeRegion(dSShape, false)).getShapeRegion()) != null) {
            FillInfo fillInfo = new FillInfo();
            int n4 = 0;
            int n5 = Unit.convertUnitToPixel(rectangle.x, 1440);
            int n6 = Unit.convertUnitToPixel(rectangle.y, 1440);
            int n7 = Unit.convertUnitToPixel(rectangle.width, 1440);
            int n8 = Unit.convertUnitToPixel(rectangle.height, 1440);
            if (n != 22) {
                fillInfo.setFillColor(CCUtil.getColorPropertyByName(dSShape, "Background"));
                color = CCUtil.getColorPropertyByName(dSShape, "BorderColor");
                n3 = CCUtil.getIntPropertyByName(dSShape, "BorderStyle");
                n2 = CCUtil.getIntPropertyByName(dSShape, "BorderWidth");
                if (n2 > 0) {
                    n5 += n2 >> 1;
                    n6 += n2 >> 1;
                    n7 -= n2;
                    n8 -= n2;
                } else {
                    n3 = 0;
                }
                if (color == null) {
                    n3 = 0;
                }
                if (n3 == 0 && fillInfo.getColor() == null) {
                    return;
                }
            } else {
                color = CCUtil.getColorPropertyByName(dSShape, "LineColor");
                n2 = CCUtil.getIntPropertyByName(dSShape, "LineWidth");
                n3 = CCUtil.getIntPropertyByName(dSShape, "LineStyle");
            }
            switch (n) {
                case 22: {
                    this.getCells.print(this.getFamily(n5, n6, n5 + n7, n6 + n8, color, n2, n3));
                    break;
                }
                case 23: {
                    n4 = 1;
                    break;
                }
                case 20: {
                    n4 = 2;
                    break;
                }
                case 19: {
                    n4 = 3;
                }
            }
            if (n4 != 0) {
                this.getCells.print(this.getEncoding(n5, n6, n7, n8, color, fillInfo, n3, n2, n4));
            }
        }
    }

    private void getDescent() {
        StringBuffer stringBuffer = new StringBuffer(512);
        int n = Unit.convertInchToPixel(2.0, 1440);
        int n2 = Unit.convertInchToPixel(3.0, 1440);
        int n3 = Unit.convertInchToPixel(2.0, 1440);
        int[] nArray = new int[7];
        this.getFontName("Arial Narrow");
        LinkInfo linkInfo = null;
        for (int i = Unit.convertInchToPixel(1.0, 1440); n < this.getEndColor && i < this.getFamily; n += n2, i += n3) {
            int n4 = n - TW / 2;
            int n5 = n - BW1 / 2;
            int n6 = n - BW2 / 2;
            int n7 = i - BH / 2 - 280;
            int n8 = i;
            int n9 = i + BH / 2 + 280;
            nArray[0] = FT.isBold() ? 1 : 0;
            nArray[4] = FT.getSize() * 2;
            this.deIndent(false, new int[]{n4, n7, TW, TH}, EVAL, nArray, new Color[2], FT, 0, 0, 1, 1, 20, 0, "Arial Narrow", DEF_COLOR, null, null, false, linkInfo);
            nArray[0] = FB.isBold() ? 1 : 0;
            nArray[4] = FB.getSize() * 2;
            this.deIndent(false, new int[]{n5, n8, BW1, BH}, CONTACT, nArray, new Color[2], FB, 0, 0, 1, 1, 12, 0, "Arial Narrow", DEF_COLOR, null, null, false, linkInfo);
            this.deIndent(false, new int[]{n6, n9, BW2, BH}, PHONE, nArray, new Color[2], FB, 0, 0, 1, 1, 12, 0, "Arial Narrow", DEF_COLOR, null, null, false, linkInfo);
        }
        this.getCells.write(stringBuffer.toString());
    }

    private String getDisplay(ShapeInfo shapeInfo) throws IOException {
        return this.getEncoding(shapeInfo.x, shapeInfo.y, shapeInfo.width, shapeInfo.height, shapeInfo.bdColor, shapeInfo.bginfo, shapeInfo.bdStyle, shapeInfo.bdWidth, shapeInfo.type);
    }

    private String getEncoding(int n, int n2, int n3, int n4, Color color, FillInfo fillInfo, int n5, int n6, int n7) throws IOException {
        if (n7 == 0) {
            return this.getFamily(n, n2, n3, n4, color, n6, n5);
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.getEncoding);
        if (this.getFontInfo == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.getFontRender).append("\\shpbottom").append(n2 + n4 + this.getFontRender).append("\\shpright").append(n + n3);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getGradientEndColor).append("\\shpright").append(n + n3).append("\\shpbottom").append(n2 + n4 - this.getGradientEndColor);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[n7]).append("}}");
        if (fillInfo != null) {
            if (fillInfo.getColor() != null) {
                Color color2 = fillInfo.getColor();
                stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color2)).append("}}").append("{\\sp{\\sn fFilled}{\\sv ").append(color2 == null ? 0 : 1).append("}}{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            } else if (fillInfo.getImage() != null) {
                ImageInfo imageInfo = fillInfo.getImage();
                stringBuffer.append("{\\sp{\\sn fillType}{\\sv 3}}").append("{\\sp{\\sn fillBlip}{\\sv").append("{\\pict\\picscalex-1\\picscaley-1\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw" + imageInfo.getImageWidth()).append("\\pich" + imageInfo.getImageHeight()).append("\\jpegblip\\bliptag1189660870{\\*\\blipuid 46e8c8c629798837d965a4b36bc28543}").append(new String(imageInfo.getBytes())).append(_colSpan).append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            } else if (fillInfo.getGradient() != null) {
                GradientInfo gradientInfo = fillInfo.getGradient();
                Color color3 = gradientInfo.getEndColor();
                Color color4 = gradientInfo.getStartColor();
                int n8 = 100 - gradientInfo.getTransparency();
                stringBuffer.append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillType}{\\sv 7}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color3)).append("}}").append("{\\sp{\\sn fillOpacity}{\\sv ").append(this.getTradient(n8)).append("}}");
                stringBuffer.append("{\\sp{\\sn fillBackColor}{\\sv ").append(this.getFontSize(color4)).append("}}").append("{\\sp{\\sn fillBackOpacity}{\\sv ").append(this.getTradient(n8)).append("}}");
                stringBuffer.append("{\\sp{\\sn fillAngle}{\\sv -5898240}}").append("{\\sp{\\sn fFilled}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            } else {
                stringBuffer.append("{\\sp{\\sn fFilled}{\\sv 0}}");
            }
        }
        if (this.getFontInfo == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        n6 = (int)(Unit.convertUnitToCentimeter(n6) * 360000.0);
        this.getEndColor(stringBuffer, n5, n6, color);
        stringBuffer.append(_colSpan);
        return stringBuffer.toString();
    }

    protected int getTradient(int n) {
        double d = 655.36 * (double)n;
        return (int)d;
    }

    private void getEndColor(StringBuffer stringBuffer, int n, int n2, Color color) {
        if (color != null && n != 0 && n2 != 0) {
            stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getFontSize(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
        }
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 6}}");
                break;
            }
            case 3: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 2}}");
                break;
            }
            case 4: {
                stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 9}}");
                break;
            }
            case 5: {
                stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 1}}");
            }
        }
        if (n != 5) {
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(n2).append("}}");
        } else {
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(n2 << 1).append("}}");
        }
    }

    private String getFamily(int n, int n2, int n3, int n4, Color color, int n5, int n6) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.getEncoding);
        if (this.getFontInfo == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.getFontRender).append("\\shpright").append(n3).append("\\shpbottom").append(n4 + this.getFontRender);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getGradientEndColor).append("\\shpright").append(n3).append("\\shpbottom").append(n4 - this.getGradientEndColor);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ").append(bdColor[0]).append("}}");
        if (this.getFontInfo == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        n5 = (int)(Unit.convertUnitToCentimeter(n5) * 360000.0);
        this.getEndColor(stringBuffer, n6, n5, color);
        stringBuffer.append(_colSpan);
        return stringBuffer.toString();
    }

    private void getFillPatternType(int n, int n2, int n3, int n4, FillInfo fillInfo, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{\\lang1024\\langfe1024\\noproof").append("{\\shp{\\*\\shpinst");
        stringBuffer.append("\\shpfhdr").append(this.getEncoding);
        if (this.getFontInfo == 1) {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 + this.getFontRender).append("\\shpbottom").append(n2 + n4 - 1 + this.getFontRender).append("\\shpright").append(n + n3 - 1);
            stringBuffer.append("\\shpbxmargin\\shpbypage");
        } else {
            stringBuffer.append("\\shpleft").append(n).append("\\shptop").append(n2 - this.getGradientEndColor).append("\\shpbottom").append(n2 + n4 - 1 - this.getGradientEndColor).append("\\shpright").append(n + n3 - 1);
            stringBuffer.append("\\shpbxmargin\\shpbymargin");
        }
        stringBuffer.append("\\shpwr3\\shpwrk2\\shpfblwtxt0").append("\\shpz").append(this.getDisplay++).append("\\shplid").append(this.getDescent++).append("{\\sp{\\sn shapeType}{\\sv ");
        if (bl) {
            stringBuffer.append(bdColor[2]).append("}}");
        } else {
            stringBuffer.append(bdColor[1]).append("}}");
        }
        if (fillInfo != null) {
            Color color = fillInfo.getColor();
            ImageInfo imageInfo = fillInfo.getImage();
            GradientInfo gradientInfo = fillInfo.getGradient();
            if (color != null) {
                stringBuffer.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color)).append("}}").append("{\\sp{\\sn fLine}{\\sv 0}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            } else if (imageInfo != null) {
                stringBuffer.append("{\\sp{\\sn fillType}{\\sv 3}}").append("{\\sp{\\sn fillBlip}{\\sv").append("{\\pict\\picscalex-1\\picscaley-1\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw" + imageInfo.getImageWidth()).append("\\pich" + imageInfo.getImageHeight()).append("\\jpegblip\\bliptag1189660870{\\*\\blipuid 46e8c8c629798837d965a4b36bc28543}").append(new String(imageInfo.getBytes())).append(_colSpan).append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            } else if (gradientInfo != null) {
                Color color2 = gradientInfo.getEndColor();
                Color color3 = gradientInfo.getStartColor();
                int n5 = 100 - gradientInfo.getTransparency();
                stringBuffer.append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillType}{\\sv 7}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getFontSize(color2)).append("}}").append("{\\sp{\\sn fillOpacity}{\\sv ").append(this.getTradient(n5)).append("}}");
                stringBuffer.append("{\\sp{\\sn fillBackColor}{\\sv ").append(this.getFontSize(color3)).append("}}").append("{\\sp{\\sn fillBackOpacity}{\\sv ").append(this.getTradient(n5)).append("}}");
                stringBuffer.append("{\\sp{\\sn fillAngle}{\\sv -5898240}}").append("{\\sp{\\sn fFilled}{\\sv 1}}").append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
            }
        }
        if (this.getFontInfo == 1) {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 1}}");
        } else {
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        stringBuffer.append(_colSpan).append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private void getFillProperty(JRVisiableResult jRVisiableResult, int n) {
        if (!this.getBooleanProperty(jRVisiableResult, "ShowBottomLine")) {
            return;
        }
        Offset offset = (Offset)this.getHalByOld.peek();
        int n2 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n3 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n4 = this.CONTACT(jRVisiableResult.getWidth());
        int n5 = this.CONTACT(jRVisiableResult.getHeight());
        this.getCells.write(this.getFamily(n2, n3 + n5, n2 + n4, n3 + n5, Color.black, 98, 1));
    }

    private void getFloatPropertyByName(JRVisiableResult jRVisiableResult, int n) {
        int n2;
        Offset offset = (Offset)this.getHalByOld.peek();
        int n3 = this.CONTACT(jRVisiableResult.getX() + offset.dx);
        int n4 = this.CONTACT(this.getY(jRVisiableResult, n) + offset.dy);
        int n5 = this.CONTACT(jRVisiableResult.getWidth());
        int n6 = this.CONTACT(jRVisiableResult.getHeight());
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Color[] colorArray = new Color[4];
        try {
            int n7 = 4;
            while (--n7 >= 0) {
                nArray[n7] = CCUtil.getIntPropertyByName(jRVisiableResult, contains[n7]);
                nArray2[n7] = CCUtil.getIntPropertyByName(jRVisiableResult, "BorderWidth");
                colorArray[n7] = CCUtil.getColorPropertyByName(jRVisiableResult, "BorderColor");
            }
        }
        catch (NullPointerException nullPointerException) {
            n2 = 4;
            while (--n2 >= 0) {
                nArray[n2] = this.getFont(CCUtil.getIntPropertyByName(jRVisiableResult, contains[n2]));
                nArray2[n2] = CCUtil.getIntPropertyByName(jRVisiableResult, NEWBORDERWIDTH[n2]);
                colorArray[n2] = CCUtil.getColorPropertyByName(jRVisiableResult, NEWBORDERCOLOR[n2]);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        if (nArray[0] != 0 && nArray2[0] != 0) {
            n2 = Unit.convertUnitToPixel(nArray2[0], 1440) / 2;
            stringBuffer.append(this.getFamily(n3, n4 + n2, n3 + n5, n4 + n2, colorArray[0], nArray2[0], nArray[0]));
        }
        if (nArray[1] != 0 && nArray2[1] != 0) {
            n2 = Unit.convertUnitToPixel(nArray2[1], 1440) / 2;
            stringBuffer.append(this.getFamily(n3 + n2, n4, n3 + n2, n4 + n6, colorArray[1], nArray2[1], nArray[1]));
        }
        if (jRVisiableResult instanceof DSSection && CCUtil.getBooleanPropertyByName(jRVisiableResult, "ShowBottomLine")) {
            this.getFillProperty(jRVisiableResult, n);
        } else if (nArray[2] != 0 && nArray2[2] != 0) {
            n2 = Unit.convertUnitToPixel(nArray2[2], 1440) / 2;
            stringBuffer.append(this.getFamily(n3, n4 + n6 - n2, n3 + n5, n4 + n6 - n2, colorArray[2], nArray2[2], nArray[2]));
        }
        if (nArray[3] != 0 && nArray2[3] != 0) {
            n2 = Unit.convertUnitToPixel(nArray2[3], 1440) / 2;
            stringBuffer.append(this.getFamily(n3 + n5 - n2, n4, n3 + n5 - n2, n4 + n6, colorArray[3], nArray2[3], nArray[3]));
        }
        stringBuffer.append("\n");
        this.getCells.write(stringBuffer.toString());
    }

    private int getFont(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    private int getFontInfo(int n) {
        return Unit.convertUnitToPixel(n, 72) * 2;
    }

    private int getFontMetrics(jet.export.util.FontInfo fontInfo) {
        return Unit.convertUnitToPixel(fontInfo.getFontSize(), 72);
    }

    private String getFontName(String string) {
        String string2 = (String)getBlue.get(string);
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if (this.getColorProperty.get(string2) == null) {
            this.getColorProperty.put(string2, this.getDataStream);
            this.getClass.append("{\\f").append(this.getDataStream++).append("\\froman").append("\\charset0").append("\\fprq1 ").append(string2).append(";}");
        }
        return string2;
    }

    private int getFontRender(Color color) {
        if (color == null) {
            return -1;
        }
        if (this.getColor.get(color) == null) {
            this.getColor.put(color, this.getDefaultToolkit);
            this.getColNum.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
            ++this.getDefaultToolkit;
            return this.getDefaultToolkit - 1;
        }
        return (Integer)this.getColor.get(color);
    }

    private String getFontSize(Color color) {
        color = color == null ? Color.white : color;
        return Integer.toString((color.getBlue() << 16) + (color.getGreen() << 8) + color.getRed());
    }

    private static FontMetrics getForecolor(Font font) {
        return BORDERJOINT_ROUND.getFontMetrics(font);
    }

    private void getGradient(Image image) {
        block3: {
            MediaTracker mediaTracker = new MediaTracker(new Container());
            if (image != null) {
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2403006, (Throwable)interruptedException);
                }
            }
        }
    }

    private int getGradientEndColor(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("display");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 0;
    }

    private int getGradientStartColor(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("float");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 0;
    }

    private int getGraphics(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("position");
        if (propertiable != null) {
            return ((Number)propertiable.getObject()).intValue();
        }
        return 2;
    }

    private int getGreen(JRVisiableResult jRVisiableResult) {
        boolean bl;
        Containable containable;
        int n = jRVisiableResult.getObjectType();
        if (jRVisiableResult instanceof DSSection) {
            if (n == 514 || n == 517) {
                return 1;
            }
            if (n == 2562 && this.getBooleanProperty(jRVisiableResult, "ToBottom")) {
                return 1;
            }
        }
        boolean bl2 = false;
        bl2 = (n & 0x100) == 256 ? !((containable = jRVisiableResult.getParent()) instanceof DSParagraph || containable instanceof DSTableCell || containable instanceof DSTabularCell) : false;
        if (bl2) {
            return 1;
        }
        if (this.getFontName > 0) {
            return 3;
        }
        if (this.getFontMetrics > 0) {
            return 1;
        }
        int n2 = this.getGraphics(jRVisiableResult);
        int n3 = this.getGradientStartColor(jRVisiableResult);
        int n4 = this.getGradientEndColor(jRVisiableResult);
        boolean bl3 = n2 == 2;
        boolean bl4 = n3 != 2;
        boolean bl5 = n4 == 1;
        boolean bl6 = bl = n4 == 0;
        if (bl3) {
            return 1;
        }
        if (bl4) {
            return 2;
        }
        if (bl5) {
            return 3;
        }
        if (bl) {
            return 0;
        }
        return 1;
    }

    private void getGridInfo(StringBuffer stringBuffer, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "\\ul";
                break;
            }
            case 2: {
                string = "\\uldb";
                break;
            }
            case 3: {
                string = "\\ulth";
                break;
            }
            case 4: {
                string = "\\uld";
                break;
            }
            case 5: {
                string = "\\ulthd";
                break;
            }
            case 6: {
                string = "\\uldash";
                break;
            }
            case 7: {
                string = "\\ulthdash";
                break;
            }
            case 8: {
                string = "\\ulldash";
                break;
            }
            case 9: {
                string = "\\ulthldash";
                break;
            }
            case 10: {
                string = "\\uldashd";
                break;
            }
            case 11: {
                string = "\\ulthdashd";
                break;
            }
            case 12: {
                string = "\\uldashdd";
                break;
            }
            case 13: {
                string = "\\ulthdashdd";
                break;
            }
            case 14: {
                string = "\\ulwave";
                break;
            }
            case 15: {
                string = "\\ulhwave";
                break;
            }
            case 16: {
                string = "\\ululdbwave";
                break;
            }
            default: {
                string = "\\ul";
            }
        }
        stringBuffer.append(string);
    }

    private String getHGap(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(deIndent[byArray[i] >> 4 & 0xF]).append(deIndent[byArray[i] & 0xF]);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHal() throws IOException {
        File file = new File(this.getBookMark);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            int n;
            this.getGraphics.write(this.getChildren.toString().getBytes(this.getBooleanProperty));
            byte[] byArray = new byte[5120];
            while ((n = randomAccessFile.read(byArray)) != -1) {
                this.getGraphics.write(byArray, 0, n);
            }
            randomAccessFile.close();
            randomAccessFile = null;
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        file.delete();
    }

    static {
        getBlue.put("Default", "Arial");
        getBlue.put("Dialog", "Arial");
        getBlue.put("ArialMT", "Arial");
        getBlue.put("ArialNarrow", "Arial Narrow");
        getBlue.put("Helvetica", "Microsoft Sans Serif");
        getBlue.put("SansSerif", "Microsoft Sans Serif");
        getBlue.put("Serif", "Times New Roman");
        getBlue.put("Monospaced", "Courier New");
        getBlue.put("TimesRoman", "Times New Roman");
        getBlue.put("DialogInput", "Courier New");
        getBlue.put("ZapfDingbats", "WingDings");
        getBlue.put("ComicSansMS", "Comic Sans MS");
        getHal = new String[][]{{"Big5", "cpg950"}, {"Cp037", "cpg37"}, {"Cp1006", "cpg1006"}, {"Cp1025", "cpg1025"}, {"Cp1026", "cpg1026"}, {"Cp1046", "cpg1046"}, {"Cp1097", "cpg1097"}, {"Cp1098", "cpg1098"}, {"Cp1112", "cpg1112"}, {"Cp1122", "cpg1122"}, {"Cp1123", "cpg1123"}, {"Cp1124", "cpg1124"}, {"Cp1250", "cpg1250"}, {"Cp1251", "cpg1251"}, {"Cp1252", "cpg1252"}, {"Cp1253", "cpg1253"}, {"Cp1254", "cpg1254"}, {"Cp1255", "cpg1255"}, {"Cp1256", "cpg1256"}, {"Cp1257", "cpg1257"}, {"Cp1258", "cpg1258"}, {"Cp1381", "cpg1381"}, {"Cp1383", "cpg1383"}, {"Cp273", "cpg273"}, {"Cp277", "cpg277"}, {"Cp278", "cpg278"}, {"Cp280", "cpg280"}, {"Cp284", "cpg284"}, {"Cp285", "cpg285"}, {"Cp297", "cpg297"}, {"Cp33722", "cpg33722"}, {"Cp420", "cpg420"}, {"Cp424", "cpg424"}, {"Cp437", "cpg437"}, {"Cp500", "cpg500"}, {"Cp737", "cpg737"}, {"Cp775", "cpg775"}, {"Cp838", "cpg838"}, {"Cp850", "cpg850"}, {"Cp852", "cpg852"}, {"Cp855", "cpg855"}, {"Cp857", "cpg857"}, {"Cp860", "cpg860"}, {"Cp861", "cpg861"}, {"Cp862", "cpg862"}, {"Cp863", "cpg863"}, {"Cp864", "cpg864"}, {"Cp865", "cpg865"}, {"Cp866", "cpg866"}, {"Cp868", "cpg868"}, {"Cp869", "cpg869"}, {"Cp870", "cpg870"}, {"Cp871", "cpg871"}, {"Cp874", "cpg874"}, {"Cp875", "cpg875"}, {"Cp918", "cpg918"}, {"Cp921", "cpg921"}, {"Cp922", "cpg922"}, {"Cp930", "cpg930"}, {"Cp933", "cpg933"}, {"Cp935", "cpg935"}, {"Cp937", "cpg937"}, {"Cp939", "cpg939"}, {"Cp942", "cpg942"}, {"Cp948", "cpg948"}, {"Cp949", "cpg949"}, {"Cp950", "cpg950"}, {"Cp964", "cpg964"}, {"Cp970", "cpg970"}, {"EUC_CN", _height}, {"EUC_JP", "cpg932"}, {"EUC_KR", "cpg933"}, {"EUC_TW", "cpg950"}, {"GBK", _height}, {"GB2312", _height}, {"ISO2022CN", _height}, {"ISO2022CN_CNS", "cpg950"}, {"ISO2022CN_GB", _height}, {"ISO2022JP", "cpg932"}, {"ISO2022KR", "cpg933"}, {"JIS0201", "cpg932"}, {"JIS0208", "cpg932"}, {"JIS0212", "cpg932"}, {"KOI8_R", "cpg933"}, {"MS874", "cpg874"}, {"SJIS", "cpg932"}};
        getImageResource = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }
}

