/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf;

import com.jinfonet.resstore.OutOfSpaceException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jet.JRStopEngineException;
import jet.bean.RtfParameter;
import jet.datastream.Communicator;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.rtf.BaseRtfExport;
import jet.export.rtf.ExportToRtf;
import jet.export.rtf.ExportToRtfFlow;

public final class RTFExporter
extends AbstractExporter {
    private boolean SEDU;
    private boolean add;
    private BaseRtfExport append;
    private File close;
    private ExportAuxInfo createFile;

    public RTFExporter(Communicator[] communicatorArray, RtfParameter rtfParameter) {
        this._commuList = communicatorArray;
        this.SEDU = rtfParameter.isExportFlow();
        this.add = rtfParameter.isNoMargin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        String string2 = string.endsWith(".rtf") ? string : string + ".rtf";
        this.close = new File(string2).getParentFile();
        try {
            this.createFile.getDiskStore().createFile(string2);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string2);
            this.exportToStream(fileOutputStream);
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, string, true);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.treatIOException(iOException, string, true);
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.createFile.getDiskStore().fileUpdated(new File(string2));
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        arrayList.add(string2);
        return arrayList;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.publish(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
    }

    private void publish(BufferedOutputStream bufferedOutputStream) throws ExpException, JRStopEngineException, FileNotFoundException, UnsupportedEncodingException, IOException {
        if (this.SEDU) {
            ExportToRtfFlow exportToRtfFlow = new ExportToRtfFlow(this._commuList, this.add);
            exportToRtfFlow.setAuxiliaryInfo(this.createFile);
            exportToRtfFlow.publish(bufferedOutputStream, this.close);
        } else {
            this.append = new ExportToRtf(this._commuList, this.add);
            this.append.setAuxiliaryInfo(this.createFile);
            try {
                this.append.publish(bufferedOutputStream, this.close);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                throw new ExpException(outOfSpaceException);
            }
        }
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.createFile = exportAuxInfo;
    }
}

