/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import java.awt.Color;
import java.io.IOException;
import jet.export.rtf.api.FillInfo;
import jet.export.rtf.api.GlobalDoc;
import jet.export.rtf.api.GradientInfo;
import jet.export.rtf.api.ImageInfo;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.imp.WriteTool;

class RtfShape
extends WriteTool {
    private StringBuffer SEDU;
    private static final String append = "{\\shp{\\*\\shpinst";
    private static final String getBytes = "}}";
    private GlobalDoc getColor;
    private boolean getEndColor;
    private boolean getGradient;
    private boolean getImage;
    private int getImageHeight;
    private int getImageWidth;
    private int getNewShapeId;
    private int getNoEndContents;
    private int getStartColor;
    private FillInfo getTradient;
    private LineInfo getTransparency;
    private boolean getTwipLineWidth;

    RtfShape(GlobalDoc globalDoc) {
        this.getColor = globalDoc;
        this.reset();
    }

    void reset() {
        this.SEDU = new StringBuffer(420);
        this.getEndColor = true;
        this.getGradient = true;
        this.getTwipLineWidth = false;
        this.getImage = false;
        this.getTradient = null;
        this.getTransparency = null;
    }

    private void SEDU() {
        if (this.getImage) {
            this.SEDU.append("\\shpfhdr1");
        } else {
            this.SEDU.append("\\shpfhdr0");
        }
    }

    void setInHeader(boolean bl) {
        this.getImage = bl;
    }

    private void ShapeType() {
        boolean bl = false;
        this.SEDU.append(append).append("\\shpleft").append(this.getImageHeight).append("\\shptop").append(this.getImageWidth).append("\\shpbottom").append(this.getNoEndContents).append("\\shpright").append(this.getNewShapeId).append("\\shpfhdr0\\shpbxmargin\\shpbymargin\\shpwr3\\shpfblwtxt0\\shpz").append(this.getColor.getZorder()).append("\\shplid").append(this.getColor.getNewShapeId());
    }

    void setPosition(int n, int n2, int n3, int n4) {
        this.getImageHeight = n;
        this.getImageWidth = n2;
        this.getNewShapeId = n3;
        this.getNoEndContents = n4;
    }

    private void append() {
        this.SEDU.append("{\\sp{\\sn shapeType}{\\sv ").append(ShapeType[this.getStartColor]).append(getBytes);
    }

    void setType(int n) {
        this.getStartColor = n;
    }

    private void getBytes() throws IOException {
        if (this.getTradient == null || !this.getTradient.isFilled()) {
            return;
        }
        this.getEndColor = false;
        Color color = this.getTradient.getColor();
        if (color != null) {
            this.SEDU.append("{\\sp{\\sn fillColor}{\\sv ").append(this.getColor(color)).append("}}{\\sp{\\sn fFilled}{\\sv 1}}");
        } else if (this.getTradient.getImage() != null) {
            ImageInfo imageInfo = this.getTradient.getImage();
            this.SEDU.append("{\\sp{\\sn fillType}{\\sv 3}}").append("{\\sp{\\sn fillBlip}{\\sv").append("{\\pict\\picscalex-1\\picscaley-1\\piccropl0\\piccropr0\\piccropt0\\piccropb0").append("\\picw" + imageInfo.getImageWidth()).append("\\pich" + imageInfo.getImageHeight()).append("\\jpegblip\\bliptag1189660870{\\*\\blipuid 46e8c8c629798837d965a4b36bc28543}").append(new String(imageInfo.getBytes())).append("}}}");
        } else if (this.getTradient.getGradient() != null) {
            GradientInfo gradientInfo = this.getTradient.getGradient();
            Color color2 = gradientInfo.getEndColor();
            Color color3 = gradientInfo.getStartColor();
            int n = 100 - gradientInfo.getTransparency();
            this.SEDU.append("{\\sp{\\sn fFlipH}{\\sv 0}}").append("{\\sp{\\sn fFlipV}{\\sv 0}}").append("{\\sp{\\sn fillType}{\\sv 7}}").append("{\\sp{\\sn fillColor}{\\sv ").append(this.getColor(color2)).append(getBytes).append("{\\sp{\\sn fillOpacity}{\\sv ").append(this.getTradient(n)).append(getBytes);
            this.SEDU.append("{\\sp{\\sn fillBackColor}{\\sv ").append(this.getColor(color3)).append(getBytes).append("{\\sp{\\sn fillBackOpacity}{\\sv ").append(this.getTradient(n)).append(getBytes);
            this.SEDU.append("{\\sp{\\sn fillAngle}{\\sv -5898240}}");
        }
    }

    void setFillInfor(FillInfo fillInfo) {
        this.getTradient = fillInfo;
    }

    private void getColor() {
        this.setBorderStyle(this.SEDU, this.getTransparency);
    }

    void setBorderInfo(LineInfo lineInfo) {
        this.getTransparency = lineInfo;
    }

    String getContents() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNoEndContents());
        stringBuffer.append(getBytes);
        return stringBuffer.toString();
    }

    String getNoEndContents() throws IOException {
        if (this.getGradient) {
            if (this.getTransparency != null && this.getStartColor != 0) {
                int n = this.getTransparency.getTwipLineWidth() / 2;
                this.getImageHeight += n;
                this.getImageWidth += n;
                this.getNewShapeId -= n;
                this.getNoEndContents -= n;
            }
            this.ShapeType();
            this.append();
            this.getBytes();
            this.getColor();
            this.getEndColor();
            if (this.getEndColor) {
                this.SEDU.append("{\\sp{\\sn fFilled}{\\sv 0}}");
            }
            this.getGradient = false;
        }
        return this.SEDU.toString();
    }

    private void getEndColor() {
        if (this.getTwipLineWidth) {
            this.SEDU.append("{\\sp{\\sn fBehindDocument}{\\sv 1}}");
        }
    }

    void setBackDoc(boolean bl) {
        this.getTwipLineWidth = bl;
    }
}

