/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.imp;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jet.export.rtf.api.Constant;
import jet.export.rtf.api.LineInfo;
import jet.export.rtf.api.PatternInfo;

public class WriteTool
implements Constant {
    private static final String add = "\\'";

    protected String getColor(Color color) {
        if (color == null) {
            return "16777215";
        }
        return Integer.toString((color.getBlue() << 16) + (color.getGreen() << 8) + color.getRed());
    }

    protected int getTradient(int n) {
        double d = 655.36 * (double)n;
        return (int)d;
    }

    protected void setBorderStyle(StringBuffer stringBuffer, LineInfo lineInfo) {
        if (lineInfo == null || lineInfo.isNoLine()) {
            stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
            return;
        }
        stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(lineInfo.getLineWidth()).append("}}");
        if (lineInfo.getPattern() != null) {
            PatternInfo patternInfo = lineInfo.getPattern();
            stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getColor(patternInfo.getForeColor())).append("}}");
            stringBuffer.append("{\\sp{\\sn lineBackColor}{\\sv ").append(this.getColor(patternInfo.getBackColor())).append("}}");
            stringBuffer.append("{\\sp{\\sn lineType}{\\sv 1}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
        } else {
            byte by;
            if (lineInfo.getLineColor() != null) {
                stringBuffer.append("{\\sp{\\sn lineColor}{\\sv ").append(this.getColor(lineInfo.getLineColor())).append("}}").append("{\\sp{\\sn fLine}{\\sv 1}}");
            } else {
                stringBuffer.append("{\\sp{\\sn fLine}{\\sv 0}}");
            }
            stringBuffer.append("{\\sp{\\sn lineWidth}{\\sv ").append(lineInfo.getLineWidth()).append("}}");
            byte by2 = lineInfo.getLineDash();
            switch (by2) {
                case 7: {
                    stringBuffer.append("{\\sp{\\sn lineEndCapStyle}{\\sv 0}}");
                }
                case 8: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 2}}");
                    break;
                }
                case 9: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 6}}");
                    break;
                }
                case 10: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 8}}");
                    break;
                }
                case 11: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 7}}");
                    break;
                }
                case 12: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 9}}");
                    break;
                }
                case 13: {
                    stringBuffer.append("{\\sp{\\sn lineDashing}{\\sv 10}}");
                    break;
                }
            }
            byte by3 = lineInfo.getLineStyle();
            switch (by3) {
                case 2: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 1}}");
                    break;
                }
                case 4: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 2}}");
                    break;
                }
                case 3: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 3}}");
                    break;
                }
                case 5: {
                    stringBuffer.append("{\\sp{\\sn lineStyle}{\\sv 4}}");
                    break;
                }
            }
            stringBuffer.append("{\\sp{\\sn fArrowheadsOK}{\\sv 0}}");
            byte by4 = lineInfo.getBeginArrowStyle();
            if (by4 != 14) {
                switch (by4) {
                    case 15: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 1}}");
                        break;
                    }
                    case 17: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 2}}");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 5}}");
                        break;
                    }
                    case 18: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 3}}");
                        break;
                    }
                    default: {
                        stringBuffer.append("{\\sp{\\sn lineStartArrowhead}{\\sv 4}}");
                    }
                }
                stringBuffer.append("{\\sp{\\sn lineStartArrowWidth}{\\sv 1}}{\\sp{\\sn lineStartArrowLength}{\\sv 1}}");
            }
            if ((by = lineInfo.getEndArrowStyle()) != 14) {
                switch (by4) {
                    case 15: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 1}}");
                        break;
                    }
                    case 17: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 2}}");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 5}}");
                        break;
                    }
                    case 18: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 3}}");
                        break;
                    }
                    default: {
                        stringBuffer.append("{\\sp{\\sn lineEndArrowhead}{\\sv 4}}");
                    }
                }
                stringBuffer.append("{\\sp{\\sn lineEndArrowWidth}{\\sv 1}}{\\sp{\\sn lineEndArrowLength}{\\sv 1}}");
            }
            stringBuffer.append("{\\sp{\\sn posrelh}{\\sv 0}}{\\sp{\\sn posrelv}{\\sv 0}}");
        }
        lineInfo.reset();
    }

    public String prepareText(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        boolean bl = this.add(cArray);
        if (bl) {
            List list = this.HEX(cArray);
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                char[] cArray2 = (char[])list.get(i);
                char c = cArray2[0];
                if (this.append(c, false)) {
                    stringBuffer.append("{\\rtlch ");
                } else {
                    stringBuffer.append("{\\ltlch ");
                }
                stringBuffer.append(this.SEDU(cArray2));
                stringBuffer.append("}");
            }
            return stringBuffer.toString();
        }
        return this.SEDU(cArray);
    }

    private List HEX(char[] cArray) {
        int n;
        boolean bl;
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = bl = this.append(cArray[0], false);
        for (n = 1; n < n2; ++n) {
            char c = cArray[n];
            bl2 = this.append(c, bl);
            if (bl == bl2) continue;
            int n4 = n - n3;
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, n3, cArray2, 0, n4);
            arrayList.add(cArray2);
            n3 = n;
            bl = bl2;
        }
        n = n2 - n3;
        char[] cArray3 = new char[n];
        System.arraycopy(cArray, n3, cArray3, 0, n);
        arrayList.add(cArray3);
        return arrayList;
    }

    private String SEDU(char[] cArray) {
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u00ff') {
                stringBuffer.append("\\uc2\\u").append((int)c).append(add).append(HEX[c >> 12 & 0xF]).append(HEX[c >> 8 & 0xF]).append(add).append(HEX[c >> 4 & 0xF]).append(HEX[c & 0xF]);
                continue;
            }
            if (c >= '\u0080') {
                stringBuffer.append(add).append(Integer.toHexString(c));
                continue;
            }
            if (c == '\r' || c == '\n') {
                if (c == '\r') {
                    if (i + 1 < cArray.length && cArray[i + 1] == '\n') {
                        stringBuffer.append(" \\par ");
                        ++i;
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(" \\par ");
                continue;
            }
            if (c == '\t') {
                stringBuffer.append("\\tab ");
                continue;
            }
            if (c < ' ') {
                stringBuffer.append(add).append(Integer.toHexString(c));
                continue;
            }
            if (c == '\\' || c == '{' || c == '}') {
                stringBuffer.append(add).append(Integer.toHexString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean add(char[] cArray) {
        for (char c : cArray) {
            if (!this.append(c, false)) continue;
            return true;
        }
        return false;
    }

    private boolean append(char c, boolean bl) {
        if (c == ' ') {
            return bl;
        }
        return c >= '\u0600' && c < '\u0700' || c >= '\u0590' && c < '\u0600';
    }

    protected boolean equal(LineInfo lineInfo, LineInfo lineInfo2) {
        if (lineInfo == null && lineInfo2 == null) {
            return true;
        }
        if (lineInfo != null && lineInfo2 != null) {
            return lineInfo.equal(lineInfo2);
        }
        return false;
    }
}

