/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.toolkit.Offset;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.CommEnumeration;
import jet.datastream.Communicator;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTable;
import jet.datastream.DSTableObject;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderBarCode;
import jet.datastream.render.RenderDropDownList;
import jet.datastream.render.RenderList;
import jet.datastream.render.RenderText;
import jet.export.ExpException;
import jet.export.excel.tool.PD;
import jet.export.excel.tool.PDTable;
import jet.export.relayout.table.LogicObj;
import jet.export.relayout.table.LogicRow;
import jet.export.relayout.table.TableCellWrap;
import jet.export.relayout.table.VisibleRowTable;
import jet.export.text.CSVCache;
import jet.export.text.SDFTextBase;
import jet.export.text.SimpleSDFText;
import jet.export.util.CCUtil;
import jet.export.util.ExportUtil;
import jet.udo.TextGeneratable;
import jet.udos.JHyperLinkRslt;

public class SDFText
extends SDFTextBase {
    private Hashtable C;
    private Stack SEDU;
    protected Vector pageData;
    private SDFTextBase add;
    private boolean addElement = true;
    private String addLineSeparator;
    private long adjustString = 0L;
    protected int debugBreakV = Integer.MAX_VALUE;
    protected int debugContinueV = -1;
    private long append = 0L;
    private PDTable arraycopy = new PDTable(256);
    private long canExportToCSV = 0L;

    public SDFText(Communicator[] communicatorArray, TextParameter textParameter) {
        if (textParameter.isUseDelimiter()) {
            this.setDelimiter(textParameter.getDelimiter());
        }
        if (communicatorArray[0].getHeaderInfo(0).isPreDefinedCol()) {
            this.add = new SimpleSDFText(communicatorArray, textParameter);
        } else {
            JRLog.trace(4, "Exporting to CSV......");
            this._commuList = communicatorArray;
            this.getParameters(textParameter);
            this.add = this;
        }
    }

    private OutputStream getOutputStream(String string) throws ExpException {
        FileOutputStream fileOutputStream = null;
        this.addLineSeparator = this.addElement ? (string.endsWith(".txt") || string.endsWith(".csv") ? string : (this.isCSV ? string + ".csv" : string + ".txt")) : (string.endsWith(".zip") ? string : string + ".zip");
        try {
            fileOutputStream = new FileOutputStream(this.addLineSeparator);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.treatIOException(fileNotFoundException, this.addLineSeparator, true);
        }
        if (this.addElement) {
            return fileOutputStream;
        }
        String string2 = this.addLineSeparator.substring(0, this.addLineSeparator.lastIndexOf(".zip"));
        if (!string2.endsWith(".txt") && !string2.endsWith(".csv")) {
            string2 = this.isCSV ? string2 + ".csv" : string2 + ".txt";
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        ZipEntry zipEntry = new ZipEntry(string2);
        try {
            zipOutputStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, this.addLineSeparator, true);
        }
        return zipOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this.checkFilePathExist(string);
        try {
            this.exportAuxInfo.getDiskStore().createFile(string);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        OutputStream outputStream = this.getOutputStream(string);
        try {
            this.exportToStream(outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                this.treatIOException(iOException, this.addLineSeparator, true);
            }
        }
        try {
            this.exportAuxInfo.getDiskStore().fileUpdated(new File(this.addLineSeparator));
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(this.addLineSeparator);
        return arrayList;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this.checkOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            this.add.setAuxiliaryInfo(this.exportAuxInfo);
            this.add.publish(bufferedOutputStream);
            this.add.free();
            bufferedOutputStream.flush();
        }
        catch (IOException iOException) {
            this.treatIOException(iOException, null, false);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        finally {
            if (this.cache != null) {
                this.cache.clear();
                this.cache = null;
            }
        }
    }

    @Override
    protected void publish(BufferedOutputStream bufferedOutputStream) throws IOException, JRStopEngineException, ExpException, OutOfSpaceException {
        this.cache = new CSVCache(this.exportAuxInfo, this.hasHeadFoot, false);
        long l = System.currentTimeMillis();
        boolean bl = JRLog.isTrace(4);
        if (bl) {
            JRLog.indent("Export to sdf text");
            JRLog.trace(4, 4402101, new Timestamp(l));
        }
        super.publish(bufferedOutputStream);
        for (int i = 0; i < this._commuList.length; ++i) {
            Communicator communicator = this._commuList[i];
            if (communicator == null) {
                this.logCommunicatorNullInfo(i);
                continue;
            }
            this.C(communicator);
        }
        if (bl) {
            long l2 = System.currentTimeMillis();
            JRLog.trace(4, 4402102, new Timestamp(l2));
            JRLog.trace(4, 4402103, l2 - l - this.adjustString);
            JRLog.trace(4, "Export getData times(" + this.canExportToCSV + ")");
            JRLog.trace(4, "Get render and to String times(" + this.append + ")");
            JRLog.deIndent("Export to sdf text");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce the sdf text");
        }
    }

    private void C(Communicator communicator) throws JRStopEngineException, ExpException {
        long l;
        long l2;
        this.pageData = new Vector();
        this.SEDU = new Stack();
        this.C = new Hashtable();
        this._commu = communicator;
        this.waitCommunicator();
        CommEnumeration commEnumeration = new CommEnumeration(communicator);
        int n = 0;
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(communicator);
            if (++n < this.debugContinueV) {
                commEnumeration.nextElement();
                continue;
            }
            l2 = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            l = System.currentTimeMillis();
            this.adjustString += l - l2;
            this.writePage(dSPage, true);
            if (n != this.debugBreakV) continue;
            break;
        }
        int n2 = this.addLineSeparator();
        commEnumeration = new CommEnumeration(communicator);
        n = 0;
        while (commEnumeration.hasMoreElements()) {
            ExportUtil.checkStop(communicator);
            if (++n < this.debugContinueV) {
                commEnumeration.nextElement();
                continue;
            }
            l2 = System.currentTimeMillis();
            DSPage dSPage = (DSPage)commEnumeration.nextElement();
            l = System.currentTimeMillis();
            this.adjustString += l - l2;
            this.writePage(dSPage, false);
            String string = this.adjustString(n2);
            this.textwriter.print(string);
            this.pageData.removeAllElements();
            if (n != this.debugBreakV) continue;
            break;
        }
        this.textwriter.flush();
    }

    @Override
    protected void writeBody(DSBody dSBody, int n, boolean bl) {
        this.SEDU(dSBody, n, bl);
    }

    @Override
    protected void writeSection(DSSection dSSection, int n, boolean bl) {
        this.SEDU(dSSection, n, bl);
    }

    private void SEDU(DSContainer dSContainer, int n, boolean bl) {
        int n2 = dSContainer.getStartYPos();
        List list = this.zOrder(dSContainer.getChildren());
        int n3 = list.size();
        this.SEDU.push(this.SEDU.isEmpty() ? new Offset(dSContainer.getX(), this.getY(dSContainer, n)) : new Offset((Offset)this.SEDU.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        int n4 = n3;
        while (--n4 >= 0) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(n4);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.canExportToCSV(jRObjectResult, n2, bl);
        }
        this.SEDU.pop();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _commu(DSField dSField, int n, boolean bl) {
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        block9: {
            int[][] nArray;
            block10: {
                if (!this.isTextField(dSField)) {
                    return;
                }
                Offset offset = (Offset)this.SEDU.peek();
                n5 = dSField.getX() + offset.dx;
                n4 = dSField.getWidth();
                if (bl) {
                    this.addElement(n5, 0, n4, 0, null, bl);
                    return;
                }
                string = this.cache.getFieldValue(dSField);
                n3 = this.getY(dSField, n) + offset.dy;
                n2 = dSField.getHeight();
                nArray = dSField.getLineBreakPos();
                if (nArray == null) break block9;
                string = Painter.adjustString(string);
                int n6 = dSField.getObjectType();
                if (n6 != 257) break block10;
                int n7 = dSField.getStartLine();
                if (n7 >= 0 && n7 < nArray.length) {
                    int n8 = dSField.getEndLine();
                    if (n8 >= 0) {
                        n8 = Math.min(nArray.length - 1, n8) < 0 ? 0 : Math.min(nArray.length - 1, n8);
                        string = string.substring(nArray[n7][0], nArray[n8][0] + nArray[n8][1]);
                    }
                    break block9;
                } else {
                    return;
                }
            }
            if (string.length() > 50) {
                int n9 = dSField.getStartLine();
                int n10 = dSField.getEndLine();
                if (n10 < 0) {
                    JRLog.error(2, 2405109, new Object[]{string.length(), n10});
                    return;
                }
                n10 = Math.min(nArray.length - 1, n10) < 0 ? 0 : Math.min(nArray.length - 1, n10);
                string = string.substring(nArray[n9][0], nArray[n10][0] + nArray[n10][1]);
            } else if (dSField.getStartLine() > 0) {
                return;
            }
        }
        this.addElement(n5, n3, n4, n2, string, bl);
    }

    private String _commuList(Render render, Object object) {
        if (render instanceof RenderText) {
            if (object != null && object instanceof DSField) {
                return ((DSField)object).toString();
            }
        } else {
            if (render instanceof RenderList) {
                RenderList renderList = (RenderList)render;
                Vector vector = renderList.getSelectedText();
                Vector vector2 = renderList.getTexts();
                AbstractList abstractList = null;
                if (vector == null || vector.size() == 0) {
                    abstractList = vector2;
                } else {
                    abstractList = new ArrayList(vector.size());
                    boolean bl = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        if (!vector2.contains(vector.get(i))) continue;
                        bl = true;
                        abstractList.add(vector.get(i));
                    }
                    if (!bl) {
                        abstractList = vector2;
                    }
                }
                String string = null;
                if (abstractList != null && abstractList.size() != 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append((String)abstractList.get(0));
                    for (int i = 1; i < abstractList.size(); ++i) {
                        stringBuffer.append("\n").append((String)abstractList.get(i));
                    }
                    string = stringBuffer.toString();
                }
                return string;
            }
            if (render instanceof RenderDropDownList) {
                String string = null;
                RenderDropDownList renderDropDownList = (RenderDropDownList)render;
                String string2 = renderDropDownList.getSelectedTexts();
                Vector vector = renderDropDownList.getTexts();
                if (string2 != null && vector != null && vector.size() != 0) {
                    string = vector.contains(string2) ? string2 : (String)vector.get(0);
                }
                return string;
            }
            if (render instanceof RenderBarCode) {
                return object instanceof DSField ? ((DSField)object).toString() : null;
            }
        }
        return null;
    }

    private void add(JRVisiableResult jRVisiableResult, int n, boolean bl) {
        boolean bl2 = jRVisiableResult instanceof TextGeneratable;
        String string = null;
        if (bl2) {
            string = ((TextGeneratable)((Object)jRVisiableResult)).toText();
        } else if (jRVisiableResult instanceof JHyperLinkRslt) {
            string = ((JHyperLinkRslt)jRVisiableResult).getDisplayValue();
        }
        if (string != null) {
            Offset offset = (Offset)this.SEDU.peek();
            int n2 = jRVisiableResult.getX() + offset.dx;
            int n3 = this.getY(jRVisiableResult, n) + offset.dy;
            int n4 = jRVisiableResult.getWidth();
            int n5 = jRVisiableResult.getHeight();
            this.addElement(n2, n3, n4, n5, string, bl);
        }
    }

    private int getY(JRVisiableResult jRVisiableResult, int n) {
        if (jRVisiableResult.getParent() instanceof DSPage) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult instanceof DSTable) {
            return jRVisiableResult.getY();
        }
        if (jRVisiableResult.getStartYPos() == 0) {
            return jRVisiableResult.getY() - n;
        }
        if (!(jRVisiableResult instanceof DSSection)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        if (jRVisiableResult.getStartYPos() != 0) {
            JRObjectResult jRObjectResult;
            int n4 = 0;
            if (jRVisiableResult instanceof DSSection && ((jRObjectResult = (JRObjectResult)((Object)((DSSection)jRVisiableResult).getParent())).getObjectType() == 45 || jRObjectResult.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded"))) {
                n4 = Math.max(0, ((DSSection)jRVisiableResult).getY() - ((DSSubReport)jRObjectResult).getStartYPos());
            }
            n3 = (n2 = n4) > 0 ? n2 : 0;
        }
        return n3;
    }

    private void addElement(int n, int n2, int n3, int n4, String string, boolean bl) {
        if (bl) {
            this.arraycopy.put(n, n3);
        } else if (this.pageData.isEmpty()) {
            Vector<TxtBlock> vector = new Vector<TxtBlock>();
            vector.addElement(new TxtBlock(n, n2, n3, n4, string));
            this.pageData.addElement(vector);
        } else {
            Vector<TxtBlock> vector;
            TxtBlock txtBlock;
            Vector vector2;
            int n5;
            boolean bl2 = true;
            for (n5 = this.pageData.size() - 1; n5 >= 0; --n5) {
                vector2 = (Vector)this.pageData.elementAt(n5);
                txtBlock = (TxtBlock)vector2.elementAt(0);
                if (n2 == txtBlock.y) {
                    vector2.addElement(new TxtBlock(n, n2, n3, n4, string));
                    bl2 = false;
                    break;
                }
                if (n2 >= txtBlock.y - n4 / 2 && n2 < txtBlock.y + n4 / 2 && txtBlock.y + txtBlock.height > n2) {
                    boolean bl3 = true;
                    if (n2 < txtBlock.y && n5 >= 1) {
                        Vector vector3 = (Vector)this.pageData.elementAt(n5 - 1);
                        TxtBlock txtBlock2 = (TxtBlock)vector3.elementAt(0);
                        int n6 = txtBlock2.y < n2 ? n2 : txtBlock2.y;
                        int n7 = txtBlock2.height + txtBlock2.y > n2 + n4 ? n2 + n4 : txtBlock2.height + txtBlock2.y;
                        int n8 = n7 - n6;
                        int n9 = (n7 = txtBlock.height + txtBlock.y > n2 + n4 ? n2 + n4 : txtBlock.height + txtBlock.y) - (n6 = txtBlock.y < n2 ? n2 : txtBlock.y);
                        if (n8 > n9) {
                            vector3.addElement(new TxtBlock(n, n2, n3, n4, string));
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        vector2.addElement(new TxtBlock(n, n2, n3, n4, string));
                    }
                    bl2 = false;
                    break;
                }
                vector = new Vector();
                vector.addElement(new TxtBlock(n, n2, n3, n4, string));
                if (n5 == 0 && n2 <= txtBlock.y - n4 / 2) {
                    this.pageData.insertElementAt(vector, 0);
                    bl2 = false;
                    break;
                }
                if (n5 == this.pageData.size() - 1 && (n2 > txtBlock.y + n4 / 2 || n2 >= txtBlock.y + txtBlock.height)) {
                    this.pageData.addElement(vector);
                    bl2 = false;
                    break;
                }
                if (n5 <= 0) continue;
                Vector vector4 = (Vector)this.pageData.elementAt(n5 - 1);
                TxtBlock txtBlock3 = (TxtBlock)vector4.elementAt(0);
                if (n2 <= txtBlock3.y + n4 / 2 || n2 > txtBlock.y - n4 / 2) continue;
                this.pageData.insertElementAt(vector, n5);
                bl2 = false;
                break;
            }
            if (bl2) {
                for (n5 = 0; n5 < this.pageData.size(); ++n5) {
                    vector2 = (Vector)this.pageData.elementAt(n5);
                    txtBlock = (TxtBlock)vector2.elementAt(0);
                    if (txtBlock.y <= n2) continue;
                    vector = new Vector();
                    vector.addElement(new TxtBlock(n, n2, n3, n4, string));
                    this.pageData.insertElementAt(vector, n5);
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    vector = new Vector<TxtBlock>();
                    vector.add(new TxtBlock(n, n2, n3, n4, string));
                    this.pageData.addElement(vector);
                }
            }
        }
    }

    private int addLineSeparator() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.arraycopy.size();
        if (n5 == 0) {
            return 0;
        }
        PD[] pDArray = new PD[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            PD pD = this.arraycopy.get(n2);
            for (n = 0; n < n4 && pD.getPoint() >= pDArray[n].getPoint() && (pD.getPoint() != pDArray[n].getPoint() || pD.getDimension() >= pDArray[n].getDimension()); ++n) {
            }
            System.arraycopy(pDArray, n, pDArray, n + 1, n4 - n);
            pDArray[n] = pD;
            ++n4;
        }
        n2 = pDArray[0].getPoint() + pDArray[0].getDimension() / 2;
        n = pDArray[0].getDimension();
        this.C.put(pDArray[0], n3);
        for (int i = 0; i < n4; ++i) {
            if (pDArray[i].getPoint() < n2) {
                this.C.put(pDArray[i], n3);
                if (pDArray[i].getDimension() >= n) continue;
                n2 = pDArray[i].getPoint() + pDArray[i].getDimension() / 2;
                n = pDArray[i].getDimension();
                continue;
            }
            this.C.put(pDArray[i], ++n3);
            n2 = pDArray[i].getPoint() + pDArray[i].getDimension() / 2;
            n = pDArray[i].getDimension();
        }
        return n3;
    }

    private String adjustString(int n) {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        if (!this.pageData.isEmpty()) {
            for (int i = 0; i < this.pageData.size(); ++i) {
                int n2;
                String string;
                int n3;
                Vector vector = (Vector)this.pageData.elementAt(i);
                if (vector.isEmpty()) continue;
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    int n4;
                    TxtBlock txtBlock = (TxtBlock)vector.elementAt(n3);
                    int n5 = txtBlock.x;
                    string = txtBlock.text;
                    if (bl && string.length() != 0) {
                        bl = false;
                    }
                    if (stringArray[n4 = ((Integer)this.C.get(this.arraycopy.getPD(n5, txtBlock.width))).intValue()] != null) {
                        n2 = stringArray.length;
                        String[] stringArray3 = new String[n2 + 1];
                        int n6 = -1;
                        for (int j = 0; j < n2; ++j) {
                            stringArray3[++n6] = stringArray[j];
                            if (j != n4) continue;
                            stringArray3[++n6] = string;
                        }
                        stringArray = stringArray3;
                        stringArray2 = new String[stringArray.length + 1];
                        continue;
                    }
                    stringArray[n4] = string;
                }
                if (!this.isCompress || !bl) {
                    n3 = 0;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        if (n3 != 0 && this.useDelimiter) {
                            stringBuffer.append(this.delimiter);
                        }
                        if (this.useQuoteMark) {
                            stringBuffer.append(this.quoteMark);
                        }
                        if ((string = stringArray[n2]) != null && string.length() != 0) {
                            if (this.useQuoteMark || this.isCSV) {
                                string = this.prepareText(string);
                            }
                            stringBuffer.append(string);
                            stringArray2[n2] = stringArray[n2];
                        } else {
                            string = stringArray2[n2];
                            if (this.isRepeat && string != null && string.length() != 0) {
                                if (this.useQuoteMark || this.isCSV) {
                                    string = this.prepareText(string);
                                }
                                stringBuffer.append(string);
                            }
                        }
                        if (this.useQuoteMark) {
                            stringBuffer.append(this.quoteMark);
                        }
                        n3 = 1;
                        stringArray[n2] = null;
                    }
                    this.addLineSeparator(stringBuffer);
                }
                bl = true;
            }
        }
        long l2 = System.currentTimeMillis();
        this.canExportToCSV += l2 - l;
        return stringBuffer.toString();
    }

    private void append(DSParagraphText dSParagraphText, int n, boolean bl) {
        String string = dSParagraphText.getText();
        if (string != null) {
            Offset offset = (Offset)this.SEDU.peek();
            int n2 = dSParagraphText.getX() + offset.dx;
            int n3 = this.getY(dSParagraphText, n) + offset.dy;
            int n4 = dSParagraphText.getWidth();
            int n5 = dSParagraphText.getHeight();
            this.addElement(n2, n3, n4, n5, string, bl);
        }
    }

    private void arraycopy(DSParagraph dSParagraph, int n, boolean bl) {
        if (!this.cache.hasContainer(dSParagraph)) {
            Vector vector = dSParagraph.getChildren();
            int n2 = vector.size();
            if (n2 > 0) {
                Object object;
                JRObjectResult jRObjectResult = null;
                StringBuffer stringBuffer = new StringBuffer();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < n2; ++i) {
                    String string;
                    Object object2;
                    jRObjectResult = this.getFactOject((JRObjectResult)vector.get(i));
                    int n3 = jRObjectResult.getObjectType();
                    if (!this.canExportToCSV(jRObjectResult)) continue;
                    if (n3 == 524291) {
                        object = (DSParagraphText)jRObjectResult;
                        object2 = ((DSParagraphText)object).getText();
                        if (object2 == null) continue;
                        stringBuffer.append((String)object2);
                        continue;
                    }
                    if ((n3 & 0x100) != 256 || arrayList.contains(object2 = ((JRObjectResult)(object = (DSField)jRObjectResult)).getTemplate())) continue;
                    if (this.isTextField((DSField)object) && (string = ((DSField)object).toString()) != null) {
                        stringBuffer.append(string);
                    }
                    arrayList.add(object2);
                }
                arrayList.clear();
                arrayList = null;
                String string = stringBuffer.toString();
                if (string.length() != 0) {
                    object = (Offset)this.SEDU.peek();
                    int n4 = dSParagraph.getX() + ((Offset)object).dx;
                    int n5 = this.getY(dSParagraph, n) + ((Offset)object).dy;
                    int n6 = dSParagraph.getWidth();
                    int n7 = dSParagraph.getHeight();
                    this.addElement(n4, n5, n6, n7, string, bl);
                }
            }
        } else {
            this.SEDU(dSParagraph, n, bl);
        }
    }

    private void cache(DSTableObject dSTableObject, int n, boolean bl) {
        this.SEDU.push(this.SEDU.isEmpty() ? new Offset(dSTableObject.getX(), this.getY(dSTableObject, n)) : new Offset((Offset)this.SEDU.peek(), dSTableObject.getX(), this.getY(dSTableObject, n)));
        VisibleRowTable visibleRowTable = VisibleRowTable.getInstance(dSTableObject, this.cache, (byte)3);
        while (visibleRowTable.hasMoreChild()) {
            LogicObj logicObj = visibleRowTable.nextChild();
            if (logicObj.getType() == 1) continue;
            LogicRow logicRow = (LogicRow)logicObj;
            this.SEDU.push(new Offset((Offset)this.SEDU.peek(), logicRow.getX(), logicRow.getY()));
            while (logicRow.hasMoreChild()) {
                TableCellWrap tableCellWrap = logicRow.nextChild();
                List list = tableCellWrap.getChildren();
                if (list.size() <= 0) continue;
                this.SEDU.push(new Offset((Offset)this.SEDU.peek(), tableCellWrap.getX(), tableCellWrap.getY()));
                for (int i = 0; i < list.size(); ++i) {
                    JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
                    this.canExportToCSV(jRObjectResult, 0, bl);
                }
                this.SEDU.pop();
            }
            this.SEDU.pop();
        }
        this.SEDU.pop();
    }

    private void canExportToCSV(JRObjectResult jRObjectResult, int n, boolean bl) {
        int n2 = jRObjectResult.getObjectType();
        if (this.canExportToCSV(jRObjectResult)) {
            if ((n2 & 0x20) == 32) {
                switch (n2) {
                    case 262178: {
                        this.arraycopy((DSParagraph)jRObjectResult, n, bl);
                        break;
                    }
                    case 262179: {
                        this.cache((DSTableObject)jRObjectResult, n, bl);
                        break;
                    }
                    case 262183: {
                        this.checkFilePathExist((DSMultiValueContainer)jRObjectResult, n, bl);
                        break;
                    }
                    case 34: {
                        this.checkStop((DSCrossTab)jRObjectResult, n, bl);
                        break;
                    }
                    case 45: {
                        this.checkOutputStream((DSContainer)jRObjectResult, n, bl);
                        break;
                    }
                    default: {
                        this.SEDU((DSContainer)jRObjectResult, n, bl);
                        break;
                    }
                }
            } else if ((n2 & 0x100) == 256 && ((DSField)jRObjectResult).getStartLine() != -1) {
                this._commu((DSField)jRObjectResult, n, bl);
            } else if (n2 == 4096) {
                this.add((JRVisiableResult)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSSection) {
                this.writeSection((DSSection)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSParagraphText) {
                this.append((DSParagraphText)jRObjectResult, n, bl);
            } else if (jRObjectResult instanceof DSContainer) {
                this.SEDU((DSContainer)jRObjectResult, n, bl);
            } else if (JRLog.isAd()) {
                JRLog.print("Now, when export to text(CSV) can not treat this object : " + jRObjectResult + " type is : " + jRObjectResult.getObjectType());
            }
        }
    }

    private void checkFilePathExist(DSMultiValueContainer dSMultiValueContainer, int n, boolean bl) {
        String string = this._commuList(dSMultiValueContainer.getRender(), null);
        if (string != null) {
            Offset offset = (Offset)this.SEDU.peek();
            int n2 = dSMultiValueContainer.getX() + offset.dx;
            int n3 = this.getY(dSMultiValueContainer, n) + offset.dy;
            int n4 = dSMultiValueContainer.getWidth();
            int n5 = dSMultiValueContainer.getHeight();
            this.addElement(n2, n3, n4, n5, string, bl);
        }
    }

    private void checkOutputStream(DSContainer dSContainer, int n, boolean bl) {
        int n2 = dSContainer.getStartYPos();
        List list = this.zOrder(dSContainer.getChildren());
        int n3 = list.size();
        this.SEDU.push(this.SEDU.isEmpty() ? new Offset(dSContainer.getX(), this.getY(dSContainer, n)) : new Offset((Offset)this.SEDU.peek(), dSContainer.getX(), this.getY(dSContainer, n)));
        for (int i = 0; i < n3; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.canExportToCSV(jRObjectResult, n2, bl);
        }
        this.SEDU.pop();
    }

    private void checkStop(DSCrossTab dSCrossTab, int n, boolean bl) {
        int n2 = dSCrossTab.getStartYPos();
        List list = this.zOrder(dSCrossTab.getChildren());
        int n3 = list.size();
        this.SEDU.push(this.SEDU.isEmpty() ? new Offset(dSCrossTab.getX(), this.getY(dSCrossTab, n)) : new Offset((Offset)this.SEDU.peek(), dSCrossTab.getX(), this.getY(dSCrossTab, n)));
        for (int i = 0; i < n3; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            jRObjectResult = this.getFactOject(jRObjectResult);
            this.canExportToCSV(jRObjectResult, n2, bl);
        }
        this.SEDU.pop();
    }

    private int clear(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    @Override
    protected void free() {
        super.free();
        if (this.C != null) {
            this.C.clear();
            this.C = null;
        }
        if (this.pageData != null) {
            this.pageData.clear();
            this.pageData = null;
        }
    }

    private class TxtBlock {
        int x;
        int y;
        int width;
        int height;
        String text;

        TxtBlock(int n, int n2, int n3, int n4, String string) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.text = string;
        }

        public String toString() {
            return this.text + ", y=" + this.y + ",heigth=" + this.height;
        }
    }
}

