/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.util.JRLog;
import jet.datastream.DSField;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportCache;
import jet.util.Propertiable;

abstract class TextBaseCache
extends ExportCache {
    protected int firstLogid;
    protected int secondLogid;

    TextBaseCache(ExportAuxInfo exportAuxInfo, String string) {
        super(exportAuxInfo, string);
    }

    boolean isCannotExportingType(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTextField(DSField dSField) {
        int n = dSField.getRenderType();
        return !this.isCannotExportingType(n);
    }

    public String getFieldValue(DSField dSField) {
        String string;
        Propertiable propertiable;
        Object object = this.getToString(dSField);
        if (object == null || ((String)object).length() == 0) {
            return object;
        }
        int n = dSField.getRenderType();
        if (n == 4) {
            int n2;
            Object object2;
            Propertiable propertiable2 = dSField.getPropertyByName("WebValue");
            if (propertiable2 != null && (object2 = (String)propertiable2.getObject()) != null && ((String)object2).length() > 0) {
                object = object2;
            }
            if ((object2 = dSField.getPropertyByName("TextFieldType")) != null && (n2 = ((Number)object2.getObject()).intValue()) == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < ((String)object).length(); ++i) {
                    stringBuffer.append("*");
                }
                object = stringBuffer.toString();
            }
        } else if ((n == 11 || n == 5 || n == 7 || n == 6) && (propertiable = dSField.getPropertyByName("WebValue")) != null && (string = (String)propertiable.getObject()) != null && string.length() > 0) {
            object = string;
        }
        return object;
    }

    protected abstract String getToString(DSField var1);

    @Override
    public boolean isExport(JRObjectResult jRObjectResult) {
        boolean bl = jRObjectResult instanceof JRVisiableResult;
        if (bl) {
            int n = jRObjectResult.getObjectType();
            if ((n & 0x20) == 32) {
                switch (n) {
                    case 40: 
                    case 0x2000021: 
                    case 67108897: {
                        return false;
                    }
                }
            } else if ((n & 0x100) == 256) {
                DSField dSField = (DSField)jRObjectResult;
                int n2 = dSField.getRenderType();
                if (this.isCannotExportingType(n2)) {
                    return false;
                }
            } else {
                if (n == 71 || n == 129 || n == 128 || n == 65542) {
                    return false;
                }
                if (n == 264 || n == 262183) {
                    return false;
                }
            }
            boolean bl2 = bl = !CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
            if (bl) {
                bl = this.checkExportProperty(jRObjectResult);
            }
            if (bl) {
                if (jRObjectResult.getObjectType() == 262178) {
                    bl = true;
                } else if (((JRVisiableResult)jRObjectResult).getWidth() <= 0 || ((JRVisiableResult)jRObjectResult).getHeight() <= 0) {
                    if (JRLog.isError(3)) {
                        JRLog.trace(3, this.firstLogid, String.valueOf(((JRVisiableResult)jRObjectResult).getObjectType()));
                        JRLog.trace(3, this.secondLogid, ((JRVisiableResult)jRObjectResult).getWidth() + "*" + ((JRVisiableResult)jRObjectResult).getHeight());
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    abstract boolean checkExportProperty(JRObjectResult var1);
}

