/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.util.Locale;
import jet.connect.DbArray;
import jet.connect.DbBinary;
import jet.connect.DbValue;
import jet.datastream.DSDBField;
import jet.datastream.DSPicture;
import jet.datastream.DSSubReport;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.util.DbValueFormat;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import jet.util.UpdLFString;
import jet.util.image.ImageResource;

public class CCUtil {
    private static short SEDU = 1;

    public static Object getPropertyByName(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getPropertyByName(string);
        if (propertiable == null) {
            if (string.equals("FontFace")) {
                return "default";
            }
            if (string.equals("ScalingMode")) {
                return new Integer(4);
            }
            if (string.equals("BorderJoint")) {
                return new Integer(0);
            }
            if (string.equals("BackgroundType")) {
                return new Integer(0);
            }
            if (string.equals("BGGradientStyle")) {
                return new Integer(0);
            }
            if (string.equals("BGTextureStyle")) {
                return new Integer(0);
            }
            if (string.endsWith("BGImgLayout")) {
                return new Integer(0);
            }
            if (string.equals("ExportToXLS")) {
                return new Boolean(true);
            }
            if (string.equals("Invisible")) {
                if (jRObjectResult instanceof DSSubReport) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            if (string.equals("Embedded")) {
                return new Boolean(true);
            }
            return null;
        }
        return propertiable.getObject();
    }

    public static Object getPropertiablePropertyByName(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getPropertyByName(string);
        if (null != propertiable) {
            return propertiable;
        }
        return "";
    }

    public static int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        int n;
        block36: {
            n = 0;
            try {
                Propertiable propertiable = jRObjectResult.getPropertyByName(string);
                if (propertiable != null) {
                    return ((Number)propertiable.getObject()).intValue();
                }
                if (jRObjectResult.getTemplate() != null) {
                    if (string.equalsIgnoreCase("FontSize")) {
                        return jRObjectResult.getTemplate().getFontSize(jRObjectResult);
                    }
                    if (string.equals("BorderWidth")) {
                        return jRObjectResult.getTemplate().getBorderWidth(jRObjectResult);
                    }
                    if (string.equals("TopLine")) {
                        return jRObjectResult.getTemplate().getTopLine(jRObjectResult);
                    }
                    if (string.equals("LeftLine")) {
                        return jRObjectResult.getTemplate().getLeftLine(jRObjectResult);
                    }
                    if (string.equals("BottomLine")) {
                        return jRObjectResult.getTemplate().getBottomLine(jRObjectResult);
                    }
                    if (string.equals("RightLine")) {
                        return jRObjectResult.getTemplate().getRightLine(jRObjectResult);
                    }
                    if (string.equals("BorderStyle")) {
                        return jRObjectResult.getTemplate().getBorderStyle(jRObjectResult);
                    }
                    if (string.equals("LineWidth")) {
                        return jRObjectResult.getTemplate().getLineWidth(jRObjectResult);
                    }
                    if (string.equals("LineStyle")) {
                        return jRObjectResult.getTemplate().getLineStyle(jRObjectResult);
                    }
                    if (string.equalsIgnoreCase("Alignment")) {
                        return jRObjectResult.getTemplate().getAlignment(jRObjectResult);
                    }
                    if (string.equals("BottomAttachPosX")) {
                        return jRObjectResult.getTemplate().getBottomAttachPosX(jRObjectResult);
                    }
                    if (string.equals("BottomAttachPosY")) {
                        return jRObjectResult.getTemplate().getBottomAttachPosY(jRObjectResult);
                    }
                    if (string.equals("TopAttachPosX")) {
                        return jRObjectResult.getTemplate().getTopAttachPosX(jRObjectResult);
                    }
                    if (string.equals("TopAttachPosY")) {
                        return jRObjectResult.getTemplate().getTopAttachPosY(jRObjectResult);
                    }
                    if (string.equals("CornerFactor")) {
                        return jRObjectResult.getTemplate().getCornerFactor(jRObjectResult);
                    }
                    if (string.equals("StartAngle")) {
                        return jRObjectResult.getTemplate().getStartAngle(jRObjectResult);
                    }
                    if (string.equals("ArcAngle")) {
                        return jRObjectResult.getTemplate().getArcAngle(jRObjectResult);
                    }
                    if (string.equals("PatternStyle")) {
                        return jRObjectResult.getTemplate().getPatternStyle(jRObjectResult);
                    }
                    if (string.equals("FieldType")) {
                        return jRObjectResult.getTemplate().getFieldType(jRObjectResult);
                    }
                    if (string.equals("X")) {
                        return jRObjectResult.getTemplate().getX(jRObjectResult);
                    }
                    if (string.equals("Y")) {
                        return jRObjectResult.getTemplate().getY(jRObjectResult);
                    }
                    if (string.equals("Width")) {
                        return jRObjectResult.getTemplate().getWidth(jRObjectResult);
                    }
                    if (string.equals("Height")) {
                        return jRObjectResult.getTemplate().getHeight(jRObjectResult);
                    }
                } else if (JRLog.isTrace(6)) {
                    JRLog.trace(6, "The template is null.");
                }
                if (string.equals("ScalingMode")) {
                    return new Integer(4);
                }
                if (string.equals("BorderJoint")) {
                    return new Integer(0);
                }
                if (string.equals("BackgroundType")) {
                    return new Integer(0);
                }
                if (string.equals("BGGradientStyle")) {
                    return new Integer(0);
                }
                if (string.equals("BGTextureStyle")) {
                    return new Integer(0);
                }
                if (string.endsWith("BGImgLayout")) {
                    return new Integer(0);
                }
                if (JRLog.isError(3) && !"BGTransparency".equals(string)) {
                    JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult});
                }
            }
            catch (Exception exception) {
                if (!JRLog.isError(3)) break block36;
                JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult, exception});
            }
        }
        return n;
    }

    public static String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getPropertyByName(string);
        if (propertiable != null) {
            String string2 = (String)propertiable.getObject();
            if (string2 != null) {
                if (string.equals("Scope")) {
                    String string3 = string2.trim();
                    if (string3.equalsIgnoreCase("null")) {
                        return "none";
                    }
                    return string3;
                }
                return string2.trim();
            }
            if (string.equals("ExternalCSSClassValue")) {
                return "";
            }
            return null;
        }
        if (jRObjectResult.getTemplate() != null) {
            String string4;
            if (string.equals("Group")) {
                return jRObjectResult.getTemplate().getGroup(jRObjectResult);
            }
            if (string.equals("Alt")) {
                return jRObjectResult.getTemplate().getAlt(jRObjectResult);
            }
            if (string.equals("Format")) {
                return jRObjectResult.getTemplate().getFormat(jRObjectResult).trim();
            }
            if (string.equalsIgnoreCase("FontFace") && (string4 = jRObjectResult.getTemplate().getFontFace(jRObjectResult)) != null) {
                return string4;
            }
            if (string.equals("ColumnName")) {
                string4 = "";
                String string5 = jRObjectResult.getTemplate().getColumnName(jRObjectResult);
                if (string5 != null) {
                    string4 = string5;
                }
                return string4;
            }
            if (string.equals("RunTimeInstName")) {
                return jRObjectResult.getTemplate().getReport(jRObjectResult);
            }
            if (string.equals("ColumnName")) {
                return jRObjectResult.getTemplate().getColumnName(jRObjectResult);
            }
            if (string.equals("DisplayNull")) {
                return jRObjectResult.getTemplate().getDisplayNull(jRObjectResult);
            }
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, "The template is null.");
        }
        if (string.equalsIgnoreCase("FontFace")) {
            return "default";
        }
        if (JRLog.isError(3)) {
            JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult});
        }
        return null;
    }

    public static boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        boolean bl = false;
        Propertiable propertiable = jRObjectResult.getPropertyByName(string);
        if (propertiable != null) {
            Object object = propertiable.getObject();
            if (object != null) {
                return (Boolean)object;
            }
            return false;
        }
        if (jRObjectResult.getTemplate() != null) {
            if (string.equals("Underlay")) {
                return jRObjectResult.getTemplate().getUnderlay(jRObjectResult);
            }
            if (string.equals("TransWhileToHtml")) {
                return jRObjectResult.getTemplate().getTransWhileToHtml(jRObjectResult);
            }
            if (string.equals("Invisible")) {
                return jRObjectResult.getTemplate().getInvisible(jRObjectResult);
            }
            if (string.equals("Bold")) {
                return jRObjectResult.getTemplate().getBold(jRObjectResult);
            }
            if (string.equals("fontBold")) {
                return jRObjectResult.getTemplate().getBold(jRObjectResult);
            }
            if (string.equals("Italic")) {
                return jRObjectResult.getTemplate().getItalic(jRObjectResult);
            }
            if (string.equals("fontItalic")) {
                return jRObjectResult.getTemplate().getItalic(jRObjectResult);
            }
            if (string.equals("StrikeOut")) {
                return jRObjectResult.getTemplate().getStrikeOut(jRObjectResult);
            }
            if (string.equals("Underline")) {
                return jRObjectResult.getTemplate().getUnderline(jRObjectResult);
            }
            if (string.equals("Shadow")) {
                return jRObjectResult.getTemplate().getShadow(jRObjectResult);
            }
            if (string.equals("WordWrap")) {
                return jRObjectResult.getTemplate().getWordWrap(jRObjectResult);
            }
            if (string.equals("Hasborder")) {
                return jRObjectResult.getTemplate().getHasBorder(jRObjectResult);
            }
            if (string.equals("ShowBottomLine")) {
                return jRObjectResult.getTemplate().getShowBottomLine(jRObjectResult);
            }
            if (string.equals("Embedded")) {
                try {
                    return jRObjectResult.getTemplate().getEmbedded(jRObjectResult);
                }
                catch (NullPointerException nullPointerException) {
                    return true;
                }
            }
            if (string.equals("ShowBorder")) {
                return jRObjectResult.getTemplate().getShowBorder(jRObjectResult);
            }
            if (string.equals("ExportToCSV")) {
                return jRObjectResult.getTemplate().getExportToCSV(jRObjectResult);
            }
            if (string.equals("ExportToXLS")) {
                return jRObjectResult.getTemplate().getExportToXLS(jRObjectResult);
            }
        } else if (JRLog.isTrace(6)) {
            JRLog.trace(6, "The template is null.");
        }
        if (string.equals("ExportToXLS")) {
            return new Boolean(true);
        }
        if (string.equals("Invisible")) {
            if (jRObjectResult instanceof DSSubReport) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (string.equals("Embedded")) {
            return new Boolean(true);
        }
        if (JRLog.isError(3)) {
            JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult});
        }
        return bl;
    }

    public static Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        try {
            Propertiable propertiable = jRObjectResult.getPropertyByName(string);
            if (propertiable != null) {
                return (Color)propertiable.getObject();
            }
            if (jRObjectResult.getTemplate() != null) {
                if (string.equals("BorderColor")) {
                    return jRObjectResult.getTemplate().getBorderColor(jRObjectResult);
                }
                if (string.equals("Background")) {
                    return jRObjectResult.getTemplate().getBackground(jRObjectResult);
                }
                if (string.equals("Foreground")) {
                    return jRObjectResult.getTemplate().getForeground(jRObjectResult);
                }
                if (string.equals("LineColor")) {
                    return jRObjectResult.getTemplate().getLineColor(jRObjectResult);
                }
                if (string.equals("ShadowColor")) {
                    return jRObjectResult.getTemplate().getShadowColor(jRObjectResult);
                }
                if (string.equals("PatternColor")) {
                    return jRObjectResult.getTemplate().getPatternColor(jRObjectResult);
                }
            } else if (JRLog.isTrace(6)) {
                JRLog.trace(6, "The template is null.");
            }
            if (JRLog.isError(3)) {
                JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult});
            }
            return null;
        }
        catch (Exception exception) {
            if (JRLog.isError(3)) {
                JRLog.trace(3, 3401002, new Object[]{string, jRObjectResult, exception});
            }
            return null;
        }
    }

    public static ImageResource getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        return jRObjectResult.getImgResourceByPropertyName(string);
    }

    public static DbBinary getDbBinaryPropertyByName(DSPicture dSPicture, String string) {
        return (DbBinary)dSPicture.getRecord().getCell(CCUtil.getStringPropertyByName(dSPicture, "ColumnName"));
    }

    public static float getFloatPropertyByName(JRObjectResult jRObjectResult, String string) {
        Object object = CCUtil.getPropertyByName(jRObjectResult, string);
        if (object == null) {
            return 0.0f;
        }
        return ((Number)object).floatValue();
    }

    public static String formatValue(DSDBField dSDBField, DbValue dbValue, String string, Locale locale) {
        String string2 = "";
        if (dbValue != null && !dbValue.isNull()) {
            if (dbValue instanceof DbBinary) {
                return "DbBinary";
            }
            if (string == null || string.equals("") || string.equalsIgnoreCase("null")) {
                string2 = dbValue.toString();
            } else {
                DbValueFormat dbValueFormat = ReportFormat.getOneFormat(dbValue.getSqlType(), string, locale);
                if (dbValue instanceof DbArray) {
                    String string3 = UpdLFString.getUpdString(CCUtil.getStringPropertyByName(dSDBField, "ValueDelimiter"));
                    string2 = dbValueFormat != null ? dbValueFormat.format(dbValue, string3) : dbValue.toString();
                } else {
                    string2 = dbValueFormat != null ? dbValueFormat.format(dbValue) : dbValue.toString();
                }
            }
        } else {
            block10: {
                string2 = null;
                try {
                    string2 = CCUtil.getStringPropertyByName(dSDBField, "DisplayNull");
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block10;
                    JRLog.error(2, exception);
                }
            }
            if (string2 == null) {
                string2 = "NULL";
            }
        }
        return string2;
    }

    public static boolean isChangeByFormularProperty(JRObjectResult jRObjectResult, String string) {
        DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
        if (dSTemplatible == null) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        if (string.equalsIgnoreCase("Invisible")) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        if (string.equalsIgnoreCase("EnableHyperlinkOnPDF")) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        if (string.equalsIgnoreCase("MaxScalingRatio")) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        if (string.equalsIgnoreCase("Rotation")) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        int n = jRObjectResult.getObjectType();
        if (n == 4096) {
            return CCUtil.SEDU(jRObjectResult, string);
        }
        if (string.equalsIgnoreCase("FontFace")) {
            short s = dSTemplatible.getFontFaceChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getFontFaceChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("FontSize")) {
            short s = dSTemplatible.getFontSizeChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getFontSizeChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("Italic")) {
            short s = dSTemplatible.getItalicChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getItalicChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("Bold")) {
            short s = dSTemplatible.getBoldChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getBoldChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("Foreground")) {
            short s = dSTemplatible.getForegroundChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getForegroundChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("StrikeOut")) {
            return dSTemplatible.getStrikeOutChBy();
        }
        if (string.equalsIgnoreCase("Underline")) {
            short s = dSTemplatible.getUnderlineChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getUnderlineChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("Alignment")) {
            return dSTemplatible.getAlignmentChBy();
        }
        if (string.equalsIgnoreCase("Background")) {
            short s = dSTemplatible.getBackgroundByType();
            if (s <= SEDU) {
                return dSTemplatible.getBackgroundChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("Shadow")) {
            return dSTemplatible.getShadowChBy();
        }
        if (string.equalsIgnoreCase("ShadowColor")) {
            return dSTemplatible.getShadowColorChBy();
        }
        if (string.equalsIgnoreCase("BorderWidth")) {
            return dSTemplatible.getBorderWidthChBy();
        }
        if (string.equalsIgnoreCase("TopLine")) {
            short s = dSTemplatible.getTopLineChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getTopLineChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("LeftLine")) {
            short s = dSTemplatible.getLeftLineChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getLeftLineChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("BottomLine")) {
            short s = dSTemplatible.getBottomLineChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getBottomLineChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("RightLine")) {
            short s = dSTemplatible.getRightLineChangeByType();
            if (s <= SEDU) {
                return dSTemplatible.getRightLineChBy();
            }
            return true;
        }
        if (string.equalsIgnoreCase("BorderColor")) {
            return dSTemplatible.getBorderColorChBy();
        }
        if (string.equalsIgnoreCase("PictureName")) {
            return dSTemplatible.getPictureNameChBy();
        }
        if (string.equalsIgnoreCase("LineColor")) {
            return dSTemplatible.getLineColorChBy();
        }
        if (string.equalsIgnoreCase("LineStyle")) {
            return dSTemplatible.getLineStyleChBy();
        }
        if (string.equals("ExportToXLS")) {
            return dSTemplatible.getExportToXLSChBy();
        }
        if (string.equalsIgnoreCase("PatternColor")) {
            Propertiable propertiable = dSTemplatible.getPropertyByName(string);
            if (propertiable != null) {
                return propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
            }
            return dSTemplatible.getChangByF().containsKey(39);
        }
        if (string.equalsIgnoreCase("Hasborder")) {
            Propertiable propertiable = dSTemplatible.getPropertyByName(string);
            if (propertiable != null) {
                return propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
            }
            return dSTemplatible.getChangByF().containsKey(88);
        }
        if (string.equalsIgnoreCase("WordWrap")) {
            Propertiable propertiable = dSTemplatible.getPropertyByName(string);
            if (propertiable != null) {
                return propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
            }
            return dSTemplatible.getChangByF().containsKey(27);
        }
        return false;
    }

    private static boolean SEDU(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getTemplate().getPropertyByName(string);
        return propertiable != null && (propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL());
    }

    public static boolean canCacheToXls(JRObjectResult jRObjectResult) {
        return !CCUtil.isChangeByFormularProperty(jRObjectResult, "ExportToXLS");
    }
}

