/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import jet.datastream.JRObjectResult;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;

public class DrawBorderAdapter {
    BorderProperties _prop;

    public DrawBorderAdapter(JRObjectResult jRObjectResult, int n) {
        this._prop = DrawBorderAdapter.ConvertBorderProperties(jRObjectResult, n);
    }

    public DrawBorderAdapter(BorderProperties borderProperties) {
        this._prop = borderProperties;
    }

    public BorderProperties getBorderProperties() {
        return this._prop;
    }

    public static BorderProperties ConvertBorderProperties(JRObjectResult jRObjectResult, int n) {
        BorderProperties borderProperties = new BorderProperties();
        int n2 = CCUtil.getIntPropertyByName(jRObjectResult, "BorderJoint");
        borderProperties.setBorderJoint(n2);
        if (n2 == BorderProperties.BORDERJOINT_ROUND) {
            float f = Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(jRObjectResult, "RoundJointRadius"), n);
            borderProperties.setRoundJointRadius(f);
        }
        int[] nArray = new int[4];
        int n3 = 4;
        while (--n3 >= 0) {
            nArray[n3] = CCUtil.getIntPropertyByName(jRObjectResult, BorderProperties.BORDERLINENAME[n3]);
        }
        borderProperties.setBorderStyle(nArray);
        borderProperties.setBorderColor(CCUtil.getColorPropertyByName(jRObjectResult, "BorderColor"));
        borderProperties.setBorderWidth(Unit.convertUnitToPixel(CCUtil.getIntPropertyByName(jRObjectResult, "BorderWidth"), n));
        return borderProperties;
    }

    public void drawBorder(Graphics graphics, Shape shape) {
        this.BORDERJOINT_ROUND((Graphics2D)graphics, shape);
    }

    private void BORDERJOINT_ROUND(Graphics2D graphics2D, Shape shape) {
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenWidth(this._prop.getBorderWidth());
        chartPenStyle.setLineJoints(this._prop.getBorderJoint());
        chartPenStyle.setJointRadiusPixel(this._prop.getRoundJointRadius());
        chartPenStyle.setPenColor(new ChartColorPattern(this._prop.getBorderColor()));
        chartPenStyle.setDashPattern(this.BORDERLINENAME(this._prop.getBorderStyle()[0]));
        chartPenStyle.setVariabledDash(true);
        float f = this._prop.getBorderWidth();
        float f2 = (float)shape.getBounds().x + f / 2.0f;
        float f3 = (float)shape.getBounds().y + f / 2.0f;
        float f4 = (float)shape.getBounds().width - f - 1.0f;
        float f5 = (float)shape.getBounds().height - f - 1.0f;
        RectangularShape rectangularShape = this._prop.getBorderJoint() == BorderProperties.BORDERJOINT_ROUND ? new RoundRectangle2D.Float(f2, f3, f4, f5, this._prop.getRoundJointRadius(), this._prop.getRoundJointRadius()) : new Rectangle2D.Float(f2, f3, f4, f5);
        chartPenStyle.draw(graphics2D, rectangularShape);
    }

    private int BORDERLINENAME(int n) {
        switch (n) {
            case 0: {
                return ChartPenStyle.getBuiltinDashPattern("Invisible");
            }
            case 1: 
            case 5: {
                return ChartPenStyle.getBuiltinDashPattern("Solid Line");
            }
            case 2: {
                return ChartPenStyle.getBuiltinDashPattern("Dashed");
            }
            case 3: {
                return ChartPenStyle.getBuiltinDashPattern("Dotted");
            }
            case 4: {
                return ChartPenStyle.getBuiltinDashPattern("Dash-Dotted");
            }
        }
        if (JRLog.isTrace(3)) {
            JRLog.trace(3, 3401002, new Integer(n));
        }
        return ChartPenStyle.getBuiltinDashPattern("Invisible");
    }
}

