/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSSubReport;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.Cache;
import jet.export.util.FontInfo;
import jet.export.util.FontToolkit;
import jet.util.Propertiable;
import jet.util.nls.INLSMap;

public class ExportCache
implements Cache {
    private Map canBeCatch = new HashMap();
    private static final int createTempFile = 20;
    private int createTempFolder = 110;
    private String delete;
    private File fileUpdated;
    private List getChildren = new ArrayList();
    private Hashtable getCurrentINLSMap = new Hashtable();
    private boolean getDiskStore = false;
    private DiskStore getFontInfo;
    private FontToolkit getName;

    public ExportCache(ExportAuxInfo exportAuxInfo, String string) {
        this.delete = string == null || string.trim().length() == 0 ? "export" : string;
        this.getFontInfo = exportAuxInfo.getDiskStore();
        this.getName = new FontToolkit();
    }

    public void setMaxCacheSizeOfRender(int n) {
        this.createTempFolder = n < 20 ? 20 : n;
    }

    public int getCachedRenderNumber() {
        return this.canBeCatch.size();
    }

    @Override
    public Render getRender(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Render render = (Render)this.canBeCatch.get(dSTemplatible);
        if (render == null) {
            render = dSField.getRender();
            if (this.canBeCatch.size() < this.createTempFolder && render.canBeCatch()) {
                this.canBeCatch.put(dSTemplatible, render);
            }
        } else {
            render.updateRender(dSField);
        }
        return render;
    }

    @Override
    public void clear() {
        if (this.canBeCatch != null) {
            this.canBeCatch.clear();
        }
        if (this.getChildren != null) {
            for (int i = 0; i < this.getChildren.size(); ++i) {
                File file = (File)this.getChildren.get(i);
                this.delete(file);
            }
            this.getChildren.clear();
        }
        if (this.getCurrentINLSMap != null) {
            this.getCurrentINLSMap.clear();
        }
        if (this.fileUpdated != null) {
            this.delete(this.fileUpdated);
            this.fileUpdated = null;
        }
        if (this.getName != null) {
            this.getName.clear();
        }
    }

    @Override
    public File getTemporaryPath() throws OutOfSpaceException, IOException {
        if (this.fileUpdated == null) {
            this.fileUpdated = this.getFontInfo.createTempFolder(this.delete);
        }
        return this.fileUpdated;
    }

    @Override
    public File getNextTemporaryFile() throws IOException, OutOfSpaceException {
        if (this.fileUpdated == null) {
            this.fileUpdated = this.getFontInfo.createTempFolder(this.delete);
        }
        File file = this.getFontInfo.createTempFile(this.fileUpdated.getName(), this.delete, null);
        this.getChildren.add(file);
        return file;
    }

    @Override
    public boolean hasContainer(DSParagraph dSParagraph) {
        Vector vector = dSParagraph.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            int n = jRObjectResult.getObjectType();
            if (n != 262185 && n != 262184) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTextField(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Object v = this.getCurrentINLSMap.get(dSTemplatible);
        if (v != null) {
            return (Boolean)v;
        }
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            int n = (Integer)propertiable.getObject();
            if (n == 0 || n == 4) {
                this.getCurrentINLSMap.put(dSTemplatible, Boolean.TRUE);
                return true;
            }
            this.getCurrentINLSMap.put(dSTemplatible, Boolean.FALSE);
            return false;
        }
        this.getCurrentINLSMap.put(dSTemplatible, Boolean.TRUE);
        return true;
    }

    public void setIsOneHeaderFooter(boolean bl) {
        this.getDiskStore = bl;
    }

    @Override
    public boolean isOneHeaderFooter() {
        return this.getDiskStore;
    }

    @Override
    public void fileUpdated(File file) throws OutOfSpaceException, IOException {
        this.getFontInfo.fileUpdated(file);
    }

    @Override
    public void delete(File file) {
        this.getFontInfo.delete(file);
    }

    @Override
    public boolean isExport(JRObjectResult jRObjectResult) {
        return !CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
    }

    @Override
    public FontInfo getFontInfo(DSField dSField) {
        return this.getName.getFontInfo(dSField);
    }

    @Override
    public FontInfo getFontInfo(DSParagraph dSParagraph) {
        return this.getName.getFontInfo(dSParagraph);
    }

    @Override
    public FontInfo getFontInfo(DSParagraphText dSParagraphText) {
        return this.getName.getFontInfo(dSParagraphText);
    }

    @Override
    public FontInfo getUdoFontInfo(JRVisiableResult jRVisiableResult) {
        return this.getName.getUdoFontInfo(jRVisiableResult);
    }

    @Override
    public FontInfo getFontInfo(DSParameterForm dSParameterForm) {
        return this.getName.getFontInfo(dSParameterForm);
    }

    @Override
    public FontInfo getFontInfo(JRVisiableResult jRVisiableResult) {
        return this.getName.getFontInfo(jRVisiableResult);
    }

    @Override
    public void handleContainerBegin(DSContainer dSContainer) {
        this.getName.handleContainerBegin(dSContainer);
    }

    @Override
    public void handleContainerEnd(DSContainer dSContainer) {
        this.getName.handleContainerEnd(dSContainer);
    }

    protected INLSMap getCurrentINLSMap() {
        return this.getName.getCurrentINLSMap();
    }

    protected void setCurrentINLSMap(INLSMap iNLSMap) {
        this.getName.setCurrentINLSMap(iNLSMap);
    }

    @Override
    public void handleContainerBegin(DSBody dSBody) {
        this.getName.handleContainerBegin(dSBody);
    }

    @Override
    public void handleContainerEnd(DSBody dSBody) {
        this.getName.handleContainerEnd(dSBody);
    }

    @Override
    public void handleContainerBegin(DSSubReport dSSubReport) {
        this.getName.handleContainerBegin(dSSubReport);
    }

    @Override
    public void handleContainerEnd(DSSubReport dSSubReport) {
        this.getName.handleContainerEnd(dSSubReport);
    }

    @Override
    public String getFormat() {
        return this.delete;
    }
}

