/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import guitools.toolkit.Unit;
import java.util.Hashtable;
import java.util.Stack;
import jet.datastream.DSBody;
import jet.datastream.DSColumn;
import jet.datastream.DSContainer;
import jet.datastream.DSField;
import jet.datastream.DSFilterControl;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSNavigateButton;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSParameterForm;
import jet.datastream.DSSlider;
import jet.datastream.DSSubReport;
import jet.datastream.DSTOC;
import jet.datastream.DSTableObject;
import jet.datastream.DSTemplatible;
import jet.datastream.JRVisiableResult;
import jet.export.util.CCUtil;
import jet.export.util.FontInfo;
import jet.util.Propertiable;
import jet.util.nls.INLSMap;
import jet.util.nls.NLSFontValue;

class FontToolkit {
    private Stack SEDU = new Stack();
    private Hashtable add = new Hashtable();
    private Hashtable append = new Hashtable();
    private INLSMap clear;

    FontToolkit() {
    }

    public void clear() {
        if (this.SEDU != null) {
            this.SEDU.clear();
            this.add.clear();
            this.append.clear();
        }
    }

    public void handleContainerBegin(DSContainer dSContainer) {
        if (dSContainer instanceof DSBody) {
            this.handleContainerBegin((DSBody)dSContainer);
        } else if (dSContainer instanceof DSSubReport) {
            this.handleContainerBegin((DSSubReport)dSContainer);
        }
    }

    public void handleContainerEnd(DSContainer dSContainer) {
        if (dSContainer instanceof DSBody) {
            this.handleContainerEnd((DSBody)dSContainer);
        } else if (dSContainer instanceof DSSubReport) {
            this.handleContainerEnd((DSSubReport)dSContainer);
        }
    }

    public void handleContainerBegin(DSBody dSBody) {
        this.SEDU.add(new NLSMapStore(this.clear));
        this.clear = dSBody.getINLSMap();
    }

    public void handleContainerEnd(DSBody dSBody) {
        this.clear = ((NLSMapStore)this.SEDU.pop()).map;
    }

    public void handleContainerBegin(DSSubReport dSSubReport) {
        int n = dSSubReport.getObjectType();
        if (n == 33) {
            this.SEDU.add(new NLSMapStore(this.clear));
            this.clear = dSSubReport.getINLSMap();
        }
    }

    public void handleContainerEnd(DSSubReport dSSubReport) {
        int n = dSSubReport.getObjectType();
        if (n == 33) {
            this.clear = ((NLSMapStore)this.SEDU.pop()).map;
        }
    }

    public FontInfo getFontInfo(JRVisiableResult jRVisiableResult) {
        if (jRVisiableResult instanceof DSField) {
            return this.convertPixelToUnit(jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSParagraphText) {
            return this.getFontInfo((DSParagraphText)jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSParagraph) {
            return this.getFontInfo((DSParagraph)jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSMultiValueContainer) {
            return this.convertPixelToUnit(jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSParameterForm) {
            return this.getFontInfo((DSParameterForm)jRVisiableResult);
        }
        if (jRVisiableResult instanceof DSTOC || jRVisiableResult instanceof DSFilterControl || jRVisiableResult instanceof DSNavigateButton || jRVisiableResult instanceof DSSlider || jRVisiableResult instanceof DSColumn || jRVisiableResult instanceof DSTableObject) {
            return this.append(jRVisiableResult);
        }
        return this.getUdoFontInfo(jRVisiableResult);
    }

    public FontInfo getFontInfo(DSField dSField) {
        return this.convertPixelToUnit(dSField);
    }

    private FontInfo SEDU(String string, double d, boolean bl) {
        this.log("Before:(" + string + ")(" + d + ")");
        if (bl) {
            if (this.clear != null) {
                double d2 = Unit.convertUnitToPixel(d, 72);
                NLSFontValue nLSFontValue = this.clear.getFontValue(string, d2);
                if (nLSFontValue != null && !nLSFontValue.isEmptyValue()) {
                    int n = Unit.convertPixelToUnit((int)nLSFontValue.getFontSize(), 72);
                    FontInfo fontInfo = new FontInfo();
                    fontInfo.setFontName(nLSFontValue.getFontName());
                    fontInfo.setFontSize(n);
                    this.log("After map :(" + fontInfo.getFontName() + ")(" + fontInfo.getFontSize());
                    return fontInfo;
                }
            } else {
                this.log("map is null");
            }
        } else {
            this.log("isChagneByFmtt flag is false");
        }
        return null;
    }

    private void log(String string) {
    }

    public FontInfo getFontInfo(DSParagraph dSParagraph) {
        Propertiable propertiable = dSParagraph.getPropertyByName("FontFace");
        String string = propertiable != null ? (String)propertiable.getObject() : "default";
        int n = CCUtil.getIntPropertyByName(dSParagraph, "FontSize");
        boolean bl = this.add(dSParagraph);
        return this.clear(string, n, false, bl);
    }

    private boolean add(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("FontFace");
        return propertiable != null && propertiable.isChagneByFmtt();
    }

    private FontInfo append(JRVisiableResult jRVisiableResult) {
        Propertiable propertiable = jRVisiableResult.getPropertyByName("FontFace");
        String string = (String)propertiable.getObject();
        int n = CCUtil.getIntPropertyByName(jRVisiableResult, "FontSize");
        boolean bl = this.add(jRVisiableResult);
        return this.clear(string, n, false, bl);
    }

    public FontInfo getFontInfo(DSParagraphText dSParagraphText) {
        Propertiable propertiable = dSParagraphText.getPropertyByName("FontFace");
        String string = propertiable != null ? (String)propertiable.getObject() : "default";
        int n = CCUtil.getIntPropertyByName(dSParagraphText, "FontSize");
        boolean bl = this.add(dSParagraphText);
        return this.clear(string, n, false, bl);
    }

    public FontInfo getUdoFontInfo(JRVisiableResult jRVisiableResult) {
        String string = (String)jRVisiableResult.getPropertyByName("fontFace").getObject();
        int n = (Integer)jRVisiableResult.getPropertyByName("fontSize").getObject();
        boolean bl = this.add(jRVisiableResult);
        return this.clear(string, n, false, bl);
    }

    private FontInfo clear(String string, int n, boolean bl, boolean bl2) {
        FontInfo fontInfo = this.SEDU(string, n, bl2);
        if (fontInfo == null) {
            fontInfo = new FontInfo();
            fontInfo.setFontName(string);
            fontInfo.setFontSize(n);
            fontInfo.setCanBeCache(bl);
        } else {
            fontInfo.setCanBeCache(false);
        }
        return fontInfo;
    }

    public FontInfo getFontInfo(DSParameterForm dSParameterForm) {
        String string = (String)dSParameterForm.getPropertyByName("TitleFontFace").getObject();
        int n = (Integer)dSParameterForm.getPropertyByName("TitleFontSize").getObject();
        boolean bl = this.add(dSParameterForm);
        return this.clear(string, n, false, bl);
    }

    private FontInfo convertPixelToUnit(JRVisiableResult jRVisiableResult) {
        boolean bl;
        int n;
        boolean bl2;
        String string;
        DSTemplatible dSTemplatible = jRVisiableResult.getTemplate();
        FontInfo fontInfo = (FontInfo)this.add.get(dSTemplatible);
        if (fontInfo != null) {
            return fontInfo;
        }
        fontInfo = (FontInfo)this.append.get(dSTemplatible);
        if (fontInfo == null) {
            string = CCUtil.getStringPropertyByName(jRVisiableResult, "FontFace");
            bl2 = !CCUtil.isChangeByFormularProperty(jRVisiableResult, "FontFace");
            n = CCUtil.getIntPropertyByName(jRVisiableResult, "FontSize");
            if (bl2) {
                fontInfo = new FontInfo();
                fontInfo.setFontName(string);
                fontInfo.setFontSize(n);
                fontInfo.setCanBeCache(bl2);
                this.append.put(dSTemplatible, fontInfo);
            }
        } else {
            string = fontInfo.getFontName();
            bl2 = true;
            n = fontInfo.getFontSize();
        }
        if ((fontInfo = this.SEDU(string, n, bl = this.add(jRVisiableResult))) == null) {
            fontInfo = new FontInfo();
            fontInfo.setFontName(string);
            fontInfo.setFontSize(n);
            fontInfo.setCanBeCache(bl2);
        } else {
            fontInfo.setCanBeCache(false);
        }
        if (fontInfo.isCanBeCache()) {
            this.add.put(dSTemplatible, fontInfo);
        }
        return fontInfo;
    }

    public INLSMap getCurrentINLSMap() {
        return this.clear;
    }

    public void setCurrentINLSMap(INLSMap iNLSMap) {
        this.clear = iNLSMap;
    }

    class NLSMapStore {
        INLSMap map;

        NLSMapStore(INLSMap iNLSMap) {
            this.map = iNLSMap;
        }
    }
}

