/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import jet.export.util.ExportUtil;
import jet.export.util.ImageTool;

public class ImageGrabber {
    private int SEDU;
    private int WHITE;
    private boolean createGraphics = false;
    private Image dispose;
    private int[] drawImage = null;
    boolean _isBufferedImage = false;

    public ImageGrabber(Image image) {
        this.dispose = image;
        ImageTool.waitImage(this.dispose);
        this.SEDU = image.getWidth(null);
        this.WHITE = image.getHeight(null);
        if (this.dispose instanceof BufferedImage) {
            this._isBufferedImage = true;
        }
    }

    public boolean processImage() {
        boolean bl;
        PixelGrabber pixelGrabber;
        block3: {
            if (this._isBufferedImage) {
                this.createGraphics = ((BufferedImage)this.dispose).getColorModel().hasAlpha();
                return true;
            }
            ExportUtil.waitImage(this.dispose);
            this.drawImage = new int[this.SEDU * this.WHITE];
            pixelGrabber = new PixelGrabber(this.dispose, 0, 0, this.SEDU, this.WHITE, this.drawImage, 0, this.SEDU);
            bl = false;
            try {
                bl = pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, "Interrupted when grab image pixel. ", (Throwable)interruptedException);
            }
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        this.createGraphics = colorModel == null ? false : colorModel.hasAlpha();
        return bl;
    }

    public BufferedImage convertToBufferedImage(boolean bl) {
        if (this.dispose instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)this.dispose;
            int n = bufferedImage.getType();
            if (bl) {
                if (n == 2 || n == 3) {
                    return bufferedImage;
                }
                n = 2;
            } else {
                if (n == 1 || n == 4 || n == 5 || n == 9 || n == 8 || n == 9) {
                    return bufferedImage;
                }
                n = 1;
            }
            bufferedImage = new BufferedImage(this.SEDU, this.WHITE, n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (!bl) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, this.SEDU, this.WHITE);
            }
            graphics2D.drawImage(this.dispose, 0, 0, null);
            this.dispose.flush();
            graphics2D.dispose();
            return bufferedImage;
        }
        int n = 1;
        if (bl) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(this.SEDU, this.WHITE, n);
        bufferedImage.setRGB(0, 0, this.SEDU, this.WHITE, this.drawImage, 0, this.SEDU);
        return bufferedImage;
    }

    public boolean hasAlpha() {
        return this.createGraphics;
    }

    public int getHeight() {
        return this.WHITE;
    }

    public int getWidth() {
        return this.SEDU;
    }

    public Image getImage() {
        return this.dispose;
    }

    public boolean isBufferedImage() {
        return this._isBufferedImage;
    }
}

