/*
 * Decompiled with CFR 0.152.
 */
package jet.export.xml;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.io.InputStream;
import jet.export.xml.FormatOutputCtrl;
import jet.export.xml.LoadXSDException;
import jet.export.xml.OutputFormatInfo;
import jet.export.xml.XSSerializer;
import jet.export.xml.xs.SchemaSymbols;
import jet.jetc.ReadFailureException;
import jet.xml.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class XMLToFormatInfo
extends FormatOutputCtrl {
    public Object loadFrom(String string) throws ReadFailureException, LoadXSDException {
        String string2 = null;
        Document document = null;
        try {
            document = XMLTools.getDocument(string);
        }
        catch (IOException iOException) {
            string2 = iOException.getMessage();
            throw new ReadFailureException(210900, (Throwable)iOException);
        }
        if (document == null) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "XMLToInfo\n" + string2 == null ? "Fail to parse XML Document!" : string2);
            }
            throw new ReadFailureException(210901);
        }
        XSSerializer xSSerializer = this.ATT_VERSION("resource/images/XMapInfo.gif");
        if (xSSerializer != null) {
            String string3 = xSSerializer.getNotation();
            OutputFormatInfo outputFormatInfo = new OutputFormatInfo(xSSerializer);
            if (string3 != null) {
                if (!string3.equalsIgnoreCase(PUBLIC_ID)) {
                    throw new LoadXSDException(210902, (Object[])new String[]{string3, xSSerializer.getExistFullPath()}, null);
                }
                try {
                    Attr attr = document.getDocumentElement().getAttributeNode(SchemaSymbols.ATT_VERSION);
                    double d = Double.parseDouble(attr.getValue());
                    double d2 = Double.parseDouble(this.VERSION);
                    if (d > d2) {
                        throw new ReadFailureException(210904, (Object[])new String[]{string3, String.valueOf(d)}, null);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw new ReadFailureException(210905, (Object[])new String[]{string}, (Throwable)nullPointerException);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ReadFailureException(210905, (Object[])new String[]{string}, (Throwable)numberFormatException);
                }
                try {
                    return outputFormatInfo.loadObject(document.getDocumentElement());
                }
                catch (Throwable throwable) {
                    throw new ReadFailureException(210906, (Object[])new String[]{string}, throwable);
                }
            }
            throw new LoadXSDException(210903, (Object[])new String[]{xSSerializer.getExistFullPath()}, null);
        }
        throw new LoadXSDException(210907, (Object[])new String[]{string}, null);
    }

    private XSSerializer ATT_VERSION(String string) throws LoadXSDException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        try {
            XSSerializer xSSerializer = XSSerializer.setExistXSInputStream(inputStream, false);
            return xSSerializer;
        }
        catch (IOException iOException) {
            throw new LoadXSDException(200070, (Throwable)iOException);
        }
    }
}

