/*
 * Decompiled with CFR 0.152.
 */
package jet.export.xml.xs;

import jet.export.xml.xs.SchemaSymbols;
import jet.export.xml.xs.XSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RefElement
extends XSObject {
    protected boolean isDup = false;
    protected boolean canBeNull = false;
    String maxOccurs = null;

    RefElement(String string, int n) {
        this.setName(string);
        this.setOccur(n);
    }

    RefElement(String string) {
        this(string, 1);
    }

    public void setOccur(RefElement refElement) {
        if (refElement.isDup) {
            this.isDup = true;
        }
        if (refElement.canBeNull) {
            this.canBeNull = true;
        }
    }

    public void setOccur(int n) {
        if (n == 0) {
            this.canBeNull = true;
        } else if (n > 1) {
            this.isDup = true;
        }
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public Element createElement(Document document) {
        Element element = document.createElement(this.getXSTag(SchemaSymbols.ELT_ELEMENT));
        element.setAttribute(SchemaSymbols.ATT_REF, this.getValidName());
        if (this.isDup) {
            element.setAttribute(SchemaSymbols.ATT_MAXOCCURS, "unbounded");
        }
        if (this.canBeNull) {
            element.setAttribute(SchemaSymbols.ATT_MINOCCURS, "0");
        }
        return element;
    }

    public static RefElement createRefEleByNode(Node node) {
        return RefElement.createRefEleByNode(node, XSObject.DEFAULT_NAMESPACE);
    }

    public static RefElement createRefEleByNode(Node node, String string) {
        String string2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_REF);
        RefElement refElement = null;
        if (node2 != null && (string2 = node2.getNodeValue()) != null && string2.length() > 0) {
            refElement = new RefElement(string2);
            refElement.setNamespace(string);
            Node node3 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_MAXOCCURS);
            if (node3 != null) {
                String string3;
                refElement.isDup = true;
                refElement.maxOccurs = string3 = node3.getNodeValue();
            }
            if (namedNodeMap.getNamedItem(SchemaSymbols.ATT_MINOCCURS) != null) {
                refElement.canBeNull = true;
            }
        }
        return refElement;
    }

    @Override
    public String toString() {
        String string = super.toString();
        if (this.isDup) {
            string = string + " maxOccur=unbounded";
        }
        if (this.canBeNull) {
            string = string + " minOccur=0";
        }
        return string;
    }
}

