/*
 * Decompiled with CFR 0.152.
 */
package jet.export.xml.xs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import jet.Resource;
import jet.export.xml.xs.RefElement;
import jet.export.xml.xs.SchemaSymbols;
import jet.export.xml.xs.XSAttribute;
import jet.export.xml.xs.XSEnumSimpleType;
import jet.export.xml.xs.XSListSimpleType;
import jet.export.xml.xs.XSObject;
import jet.export.xml.xs.XSSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSSimpleElement
extends RefElement {
    Vector attributes = new Vector(2);
    protected String type = null;
    protected String defValue = null;
    protected String fixValue = null;
    protected static final boolean needSort = true;
    protected boolean isExternalType = false;
    boolean bNullable = true;
    boolean listType = false;
    boolean bExtension = true;
    String pattern;

    public XSSimpleElement(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public XSSimpleElement(String string, String string2, String string3, boolean bl) {
        super(string);
        this.type = string2;
        this.defValue = string3;
        this.isExternalType = bl;
    }

    public XSSimpleElement(String string, String string2) {
        this(string, string2, null, false);
    }

    public XSSimpleElement(String string) {
        this(string, "", null, false);
    }

    public void setDefault(String string) {
        this.defValue = string;
    }

    public String getDefault() {
        return this.defValue;
    }

    public void setFixed(String string) {
        this.fixValue = string;
    }

    public String getFixed() {
        return this.fixValue;
    }

    public void setType(String string, boolean bl) {
        this.type = string;
        this.isExternalType = bl;
    }

    public String getType() {
        return this.type;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setNullable(boolean bl) {
        this.bNullable = bl;
    }

    public boolean isNullable() {
        return this.bNullable;
    }

    public void setExtension(boolean bl) {
        this.bExtension = bl;
    }

    public boolean isExtension() {
        return this.bExtension;
    }

    public void setListType(boolean bl) {
        this.listType = bl;
    }

    public boolean isListType() {
        return this.listType;
    }

    public void addAttribute(XSAttribute xSAttribute) {
        this.attributes.addElement(xSAttribute);
    }

    public boolean setAttribute(XSAttribute xSAttribute) {
        XSAttribute xSAttribute2 = (XSAttribute)this.isIncluded(this.attributes, xSAttribute.getName());
        if (xSAttribute2 == null) {
            this.attributes.addElement(xSAttribute);
            return !xSAttribute.bRequired;
        }
        return xSAttribute2.setDefault(xSAttribute.getDefault());
    }

    public XSAttribute getAttribute(String string) {
        return (XSAttribute)this.isIncluded(this.attributes, string);
    }

    public String getAttDefault(String string) {
        XSAttribute xSAttribute = this.getAttribute(string);
        if (xSAttribute != null) {
            return xSAttribute.getDefault();
        }
        return null;
    }

    protected XSObject isIncluded(Vector vector, String string) {
        XSObject xSObject = null;
        for (int i = 0; i < vector.size() && xSObject == null; ++i) {
            XSObject xSObject2 = (XSObject)vector.elementAt(i);
            if (!xSObject2.getName().equals(string)) continue;
            xSObject = xSObject2;
        }
        return xSObject;
    }

    @Override
    public Element createElement(Document document) {
        Element element = document.createElement(this.getXSTag(SchemaSymbols.ELT_ELEMENT));
        element.setAttribute(SchemaSymbols.ATT_NAME, this.getValidName());
        int n = this.attributes.size();
        if (this.type != null && n == 0) {
            element.setAttribute(SchemaSymbols.ATT_TYPE, this.isExternalType ? this.type : this.getXSTag(this.type));
        }
        if (this.defValue != null) {
            element.setAttribute(SchemaSymbols.ATT_DEFAULT, this.defValue);
        }
        if (n > 0) {
            Object object;
            Object object2 = document.createElement(this.getXSTag(SchemaSymbols.ELT_COMPLEXTYPE));
            element.appendChild((Node)object2);
            if (this.type != null) {
                Element element2 = document.createElement(this.getXSTag(SchemaSymbols.ELT_SIMPLECONTENT));
                object2.appendChild(element2);
                object = document.createElement(this.getXSTag("extension"));
                object.setAttribute(SchemaSymbols.ATT_BASE, this.getXSTag(this.type));
                element2.appendChild((Node)object);
                object2 = object;
            }
            for (int i = 0; i < n; ++i) {
                object = (XSAttribute)this.attributes.elementAt(i);
                Element element3 = ((XSAttribute)object).createElement(document);
                object2.appendChild(element3);
            }
        }
        return element;
    }

    protected Vector sort(Vector vector) {
        if (Resource.isJDK11()) {
            return vector;
        }
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((XSObject)object).name.toUpperCase().compareTo(((XSObject)object2).name.toUpperCase());
            }
        });
        return new Vector<Object>(Arrays.asList(objectArray));
    }

    public boolean isExternalType() {
        return this.type != null && this.isExternalType;
    }

    public static XSSimpleElement createSimpleByNode(Node node) {
        return XSSimpleElement.createSimpleByNode(node, XSObject.DEFAULT_NAMESPACE);
    }

    public static XSSimpleElement createSimpleByNode(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_NAME);
        XSSimpleElement xSSimpleElement = null;
        Node node3 = null;
        String string2 = null;
        Node node4 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_MAXOCCURS);
        if (node4 != null) {
            string2 = node4.getNodeValue();
        }
        if (node2 != null) {
            String string3 = node2.getNodeValue();
            xSSimpleElement = new XSSimpleElement(string3);
            xSSimpleElement.setNamespace(string);
            xSSimpleElement.maxOccurs = string2;
            if (string3 != null && string3.length() > 0) {
                Object object;
                boolean bl;
                String string4;
                Node node5 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_DEFAULT);
                String string5 = node5 != null ? node5.getNodeValue() : null;
                Node node6 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_FIXED);
                String string6 = node6 != null ? node6.getNodeValue() : null;
                XSListSimpleType xSListSimpleType = null;
                Node node7 = namedNodeMap.getNamedItem(SchemaSymbols.ATT_TYPE);
                String string7 = string4 = node7 != null ? node7.getNodeValue() : null;
                boolean bl2 = string4 != null ? !xSSimpleElement.isXSTag(string4) : (bl = false);
                if (string4 != null && !bl) {
                    string4 = string4.substring(string.length() + COLON.length());
                }
                if (string4 == null && (node3 = XSSimpleElement.findNode(node.getChildNodes(), xSSimpleElement.getXSTag(SchemaSymbols.ELT_SIMPLETYPE))) != null) {
                    xSListSimpleType = XSListSimpleType.createListByNode(node3, string);
                    if (xSListSimpleType != null) {
                        string4 = xSListSimpleType.getType();
                    } else {
                        object = XSEnumSimpleType.createEnumByNode(node3, string);
                        if (object != null) {
                            string4 = ((XSSimpleElement)object).getType();
                        }
                    }
                    object = XSSimpleType.createByNode(node3, string);
                    if (object != null) {
                        xSSimpleElement.pattern = ((XSSimpleType)object).getPattern();
                    }
                }
                xSSimpleElement.setType(string4, bl);
                xSSimpleElement.setDefault(string5);
                xSSimpleElement.setListType(xSListSimpleType != null);
                if (string6 != null) {
                    xSSimpleElement.setFixed(string6);
                }
                if ((object = XSSimpleElement.getAttValue(node, SchemaSymbols.ATT_NILLABLE)) != null && ((String)object).trim().length() > 0) {
                    xSSimpleElement.setNullable(new Boolean((String)object));
                }
                if (string4 == null && (string5 == null || string6 == null)) {
                    NodeList nodeList = ((Element)node).getElementsByTagName(xSSimpleElement.getXSTag(SchemaSymbols.ELT_ATTRIBUTE));
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node8;
                        Node node9 = nodeList.item(i);
                        XSAttribute xSAttribute = new XSAttribute(XSSimpleElement.getAttValue(node9, SchemaSymbols.ATT_NAME), XSSimpleElement.getAttValue(node9, SchemaSymbols.ATT_TYPE), XSSimpleElement.getAttValue(node9, SchemaSymbols.ATT_DEFAULT));
                        String string8 = XSSimpleElement.getAttValue(node9, SchemaSymbols.ATT_FIXED);
                        if (string8 != null) {
                            xSAttribute.setFixed(string8);
                        }
                        if ((node8 = XSSimpleElement.findNode(node9.getChildNodes(), xSAttribute.getXSTag(SchemaSymbols.ELT_SIMPLETYPE))) != null) {
                            XSSimpleType xSSimpleType = XSSimpleType.createByNode(node8, string);
                            xSAttribute.setPattern(xSSimpleType.getPattern());
                        }
                        xSAttribute.setNamespace(string);
                        xSSimpleElement.addAttribute(xSAttribute);
                    }
                }
            }
        }
        return xSSimpleElement;
    }

    public Vector getAttElements() {
        return this.attributes;
    }

    @Override
    public String toString() {
        String string = super.toString() + " Type=" + this.type + " ExternalType=" + this.isExternalType + " default=" + this.defValue;
        if (this.attributes.size() > 0) {
            string = string + "\n\tAttributes: " + this.attributes;
        }
        return string;
    }

    @Override
    public void clearMem() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.type = null;
        this.defValue = null;
        super.clearMem();
    }
}

