/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.util.JRLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import jet.dataengine.api.DSException;
import jet.dataengine.api.SumrySpecKeyTool;
import jet.formula.Aggregation;
import jet.formula.Functions;

public class AggDesc
implements Serializable,
Externalizable {
    private static final long serialVersionUID = -2254330571721884910L;
    public String fieldname;
    public String groupname;
    public String specFunc;
    public int aggCode;
    public boolean onFml;
    public int pass;
    public int grpidx;
    public int aggidx;
    public int calIndex;
    private int SumSqlType;
    private String qualifiedFieldName;
    private String qualifiedGroupName;
    public static String delim = "    ";
    private boolean isDynamicSummary;
    private String colName;

    public String qualifiedFieldName() {
        return this.qualifiedFieldName;
    }

    public String qualifiedGroupName() {
        return this.qualifiedGroupName;
    }

    public boolean isDynamicSummary() {
        return this.isDynamicSummary;
    }

    public void setDynamicSummary(boolean bl) {
        this.isDynamicSummary = bl;
    }

    public AggDesc() {
        this.pass = -1;
        this.grpidx = -1;
        this.aggidx = -1;
        this.calIndex = -1;
        this.SumSqlType = 0;
        this.isDynamicSummary = false;
        this.SumSqlType = 0;
    }

    public AggDesc(String string, String string2, String string3, String string4, int n, boolean bl, String string5) {
        block7: {
            this.pass = -1;
            this.grpidx = -1;
            this.aggidx = -1;
            this.calIndex = -1;
            this.SumSqlType = 0;
            this.isDynamicSummary = false;
            this.fieldname = string;
            this.groupname = string3;
            this.aggCode = n;
            this.onFml = bl;
            try {
                Integer.parseInt(string3);
                this.isDynamicSummary = true;
            }
            catch (Exception exception) {
                this.isDynamicSummary = false;
            }
            this.SumSqlType = 0;
            this.qualifiedFieldName = string2;
            this.qualifiedGroupName = string4;
            if (null != string5 && string5.length() != 0 && !string5.equalsIgnoreCase("None")) {
                try {
                    this.specFunc = SumrySpecKeyTool.getSpecKey(string5);
                }
                catch (DSException dSException) {
                    try {
                        int n2 = Integer.parseInt(string5);
                        this.specFunc = SumrySpecKeyTool.getSpecKey(Functions.getSpecFuncName(n2));
                    }
                    catch (Exception exception) {
                        this.specFunc = null;
                        if (!JRLog.isError(2)) break block7;
                        JRLog.error(2, dSException);
                    }
                }
            }
        }
    }

    public AggDesc(String string, String string2, int n) {
        this(string, null, string2, null, n, false, null);
    }

    public AggDesc(String string, String string2, int n, boolean bl) {
        this(string, string2, n);
    }

    public AggDesc(String string, String string2, int n, boolean bl, String string3) {
        this(string, null, string2, null, n, bl, string3);
    }

    public AggDesc(String string, String string2, int n, String string3) {
        this(string, string2, n, false, string3);
    }

    private boolean SEDU(String string) {
        return string == null || string.length() == 0;
    }

    public boolean equals(Object object) {
        boolean bl;
        AggDesc aggDesc = (AggDesc)object;
        boolean bl2 = bl = aggDesc.fieldname.equals(this.fieldname) && aggDesc.groupname.equals(this.groupname) && aggDesc.aggCode == this.aggCode;
        if (this.SEDU(aggDesc.specFunc)) {
            if (this.SEDU(this.specFunc)) {
                bl = bl;
            } else {
                if (bl) {
                    // empty if block
                }
                bl = false;
            }
        } else if (this.SEDU(this.specFunc)) {
            if (bl) {
                // empty if block
            }
            bl = false;
        } else {
            bl = bl;
        }
        return bl;
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.fieldname);
        if (this.specFunc != null) {
            dataOutputStream.writeUTF(this.groupname + delim + this.specFunc);
        } else {
            dataOutputStream.writeUTF(this.groupname);
        }
        dataOutputStream.writeInt(this.aggCode);
        dataOutputStream.writeBoolean(this.onFml);
        if (this.qualifiedFieldName != null) {
            dataOutputStream.writeUTF(this.qualifiedFieldName);
        } else {
            dataOutputStream.writeUTF("");
        }
        if (this.qualifiedGroupName != null) {
            dataOutputStream.writeUTF(this.qualifiedGroupName);
        } else {
            dataOutputStream.writeUTF("");
        }
    }

    public void readFromStream(DataInputStream dataInputStream, int n, int n2) throws IOException {
        int n3;
        this.fieldname = dataInputStream.readUTF();
        this.groupname = dataInputStream.readUTF();
        this.aggCode = dataInputStream.readInt();
        this.onFml = dataInputStream.readBoolean();
        if (n > 1 || n2 >= 11) {
            this.qualifiedFieldName = dataInputStream.readUTF();
            this.qualifiedGroupName = dataInputStream.readUTF();
        }
        if ((n3 = this.groupname.indexOf(delim)) != -1) {
            this.specFunc = this.groupname.substring(n3 + delim.length());
            this.groupname = this.groupname.substring(0, n3);
        }
        try {
            Integer.parseInt(this.groupname);
            this.isDynamicSummary = true;
        }
        catch (Exception exception) {
            this.isDynamicSummary = false;
        }
    }

    public static final String mapCodeToString(int n) {
        return Aggregation.getFunctionName(n);
    }

    public String toString() {
        if (this.specFunc != null) {
            return AggDesc.mapCodeToString(this.aggCode) + "{" + this.fieldname + "," + this.groupname + "," + this.specFunc + "}";
        }
        return AggDesc.mapCodeToString(this.aggCode) + "{" + this.fieldname + "," + this.qualifiedFieldName + ", " + this.groupname + "," + this.qualifiedGroupName + ", onFml = " + this.onFml + ", aggCode" + this.aggCode + ", isDynamic = " + this.isDynamicSummary + "}";
    }

    public Object clone() {
        AggDesc aggDesc = new AggDesc();
        aggDesc.fieldname = this.fieldname;
        aggDesc.groupname = this.groupname;
        aggDesc.aggCode = this.aggCode;
        aggDesc.onFml = this.onFml;
        aggDesc.qualifiedFieldName = this.qualifiedFieldName;
        aggDesc.qualifiedGroupName = this.qualifiedGroupName;
        aggDesc.pass = this.pass;
        aggDesc.grpidx = this.grpidx;
        aggDesc.aggidx = this.aggidx;
        aggDesc.calIndex = this.calIndex;
        aggDesc.SumSqlType = this.SumSqlType;
        aggDesc.specFunc = this.specFunc;
        aggDesc.setDynamicSummary(this.isDynamicSummary);
        aggDesc.setColName(this.colName);
        return aggDesc;
    }

    public void setSumSqlType(int n) {
        this.SumSqlType = n;
    }

    public int getSumSqlType() {
        return this.SumSqlType;
    }

    public String getFullGroupName() {
        if (this.specFunc != null && this.specFunc.trim().length() != 0) {
            return this.groupname + delim + this.specFunc;
        }
        return this.groupname;
    }

    public void setColName(String string) {
        this.colName = string;
    }

    public String getColName() {
        return this.colName;
    }

    public boolean isRunningTotal() {
        return Aggregation.isRunningTotal(this.aggCode);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fieldname = (String)objectInput.readObject();
        this.groupname = (String)objectInput.readObject();
        this.specFunc = (String)objectInput.readObject();
        this.aggCode = objectInput.readInt();
        this.onFml = objectInput.readBoolean();
        this.pass = objectInput.readInt();
        this.grpidx = objectInput.readInt();
        this.aggidx = objectInput.readInt();
        this.calIndex = objectInput.readInt();
        this.SumSqlType = objectInput.readInt();
        this.isDynamicSummary = objectInput.readBoolean();
        this.qualifiedFieldName = (String)objectInput.readObject();
        this.qualifiedGroupName = (String)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.fieldname);
        objectOutput.writeObject(this.groupname);
        objectOutput.writeObject(this.specFunc);
        objectOutput.writeInt(this.aggCode);
        objectOutput.writeBoolean(this.onFml);
        objectOutput.writeInt(this.pass);
        objectOutput.writeInt(this.grpidx);
        objectOutput.writeInt(this.aggidx);
        objectOutput.writeInt(this.calIndex);
        objectOutput.writeInt(this.SumSqlType);
        objectOutput.writeBoolean(this.isDynamicSummary);
        objectOutput.writeObject(this.qualifiedFieldName);
        objectOutput.writeObject(this.qualifiedGroupName);
    }

    public void reset() {
        this.aggidx = -1;
        this.grpidx = -1;
        this.calIndex = -1;
        this.pass = -1;
    }

    public int hashCode() {
        int n;
        int n2 = 17;
        int n3 = n = 37;
        n3 *= n2;
        n3 += this.fieldname.hashCode();
        n3 *= n2;
        n3 += this.groupname.hashCode();
        if (this.qualifiedFieldName != null) {
            n3 *= n2;
            n3 += this.qualifiedFieldName.hashCode();
        }
        if (this.qualifiedGroupName != null) {
            n3 *= n2;
            n3 += this.qualifiedGroupName.hashCode();
        }
        if (this.specFunc != null) {
            n3 *= n2;
            n3 += this.specFunc.hashCode();
        }
        n3 *= n2;
        return n3 += this.aggCode;
    }
}

