/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.util.JRLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import jet.connect.DbBigInt;
import jet.connect.DbColDesc;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.AggregationConstants;
import jet.formula.Any;
import jet.formula.Average;
import jet.formula.CompondAggregation;
import jet.formula.Count;
import jet.formula.DataTypeDef;
import jet.formula.Distinctcount;
import jet.formula.Every;
import jet.formula.Maximum;
import jet.formula.Minimum;
import jet.formula.NoAggFunc;
import jet.formula.PopulationStdDev;
import jet.formula.PopulationVariance;
import jet.formula.RecMax;
import jet.formula.RecMin;
import jet.formula.RecNotSatisfy;
import jet.formula.RecSatisfy;
import jet.formula.SQRSUM;
import jet.formula.StdDev;
import jet.formula.Summary;
import jet.formula.Variance;
import jet.formula.fCurrency;
import jet.log.JRLogger;

public abstract class Aggregation
extends AggregationConstants {
    AggDesc desc;
    protected DbValue agg;
    protected static DbBigInt ZERO = new DbBigInt(new DbColDesc("", 4, 15, 0, 2));
    int baseGroup = -1;
    private static JRLogger D;
    protected DbColDesc colDesc;
    protected boolean isDenied = false;
    protected HashSet denyList;

    public boolean isRunningTotal() {
        if (null == this.desc) {
            return false;
        }
        return Aggregation.isRunningTotal(this.desc.aggCode);
    }

    public Aggregation() {
    }

    Aggregation(AggDesc aggDesc) {
        this.desc = aggDesc;
    }

    public void setColDesc(DbColDesc dbColDesc) {
        this.colDesc = dbColDesc;
    }

    public DbColDesc getColDesc() {
        return this.colDesc;
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, String string4, String string5, boolean bl, String string6, boolean bl2) {
        return Aggregation.mapCode(string, string2, string3, string4, string5, bl, string6);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, String string4, String string5, boolean bl, String string6) {
        int[] nArray = (int[])codemap.get(string.toUpperCase());
        Aggregation[] aggregationArray = new Aggregation[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            AggDesc aggDesc = new AggDesc(string2, string3, string4, string5, nArray[i], bl, string6);
            aggregationArray[i] = Aggregation.makeAgg(aggDesc);
        }
        if (aggregationArray.length > 1) {
            ((CompondAggregation)aggregationArray[0]).setUsedAggs(aggregationArray);
        }
        return aggregationArray;
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, String string4) {
        return Aggregation.mapCode(string, string2, string3, bl, string4, false);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl) {
        return Aggregation.mapCode(string, string2, string3, bl, false);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        return Aggregation.mapCode(string, string2, null, string3, null, bl, string4, bl2);
    }

    public static final Aggregation[] mapCode(String string, String string2, String string3, boolean bl, boolean bl2) {
        return Aggregation.mapCode(string, string2, null, string3, null, bl, null, bl2);
    }

    public static final Aggregation makeAgg(AggDesc aggDesc, DbColDesc dbColDesc) {
        Aggregation aggregation;
        switch (aggDesc.aggCode) {
            case 1: 
            case 16: {
                aggregation = new Count(aggDesc);
                break;
            }
            case 2: 
            case 17: {
                aggregation = new Summary(aggDesc);
                break;
            }
            case 3: 
            case 18: {
                aggregation = new Minimum(aggDesc);
                break;
            }
            case 4: 
            case 19: {
                aggregation = new Maximum(aggDesc);
                break;
            }
            case 5: 
            case 20: {
                aggregation = new Distinctcount(aggDesc);
                break;
            }
            case 6: 
            case 21: {
                aggregation = new Average(aggDesc);
                break;
            }
            case 7: {
                aggregation = new SQRSUM(aggDesc);
                break;
            }
            case 8: {
                aggregation = new PopulationStdDev(aggDesc);
                break;
            }
            case 9: {
                aggregation = new PopulationVariance(aggDesc);
                break;
            }
            case 10: {
                aggregation = new StdDev(aggDesc);
                break;
            }
            case 11: {
                aggregation = new Variance(aggDesc);
                break;
            }
            case 12: {
                aggregation = new RecMin(aggDesc);
                break;
            }
            case 13: {
                aggregation = new RecMax(aggDesc);
                break;
            }
            case 14: {
                aggregation = new RecSatisfy(aggDesc);
                break;
            }
            case 15: {
                aggregation = new RecNotSatisfy(aggDesc);
                break;
            }
            case 0: {
                aggregation = new NoAggFunc(aggDesc);
                break;
            }
            case 22: {
                aggregation = new Any(aggDesc);
                break;
            }
            case 23: {
                aggregation = new Every(aggDesc);
                break;
            }
            default: {
                throw new Error("error agg type : " + aggDesc.aggCode);
            }
        }
        aggregation.setColDesc(dbColDesc);
        return aggregation;
    }

    public static final Aggregation makeAgg(AggDesc aggDesc) {
        return Aggregation.makeAgg(aggDesc, null);
    }

    public DbValue getValue() {
        if (this.isDenied) {
            if (this.agg == null) {
                this.agg = this.createDbValue();
            }
            this.agg.setNull();
        }
        return this.agg;
    }

    public abstract void exec(Record var1);

    public abstract void exec(DbValue var1);

    public void sum(Aggregation aggregation) {
        int n = DataTypeDef.SqlToFml(this.agg.getSqlType(), this.agg.isCurrency());
        switch (n) {
            case 3: {
                ((DbDecimal)this.agg).value.add(((DbDecimal)aggregation.agg).value);
                break;
            }
            case 1: {
                ((DbBigInt)this.agg).value += ((DbBigInt)aggregation.agg).value;
                break;
            }
            case 2: {
                ((DbDouble)this.agg).value += ((DbDouble)aggregation.agg).value;
                break;
            }
            default: {
                if (!JRLog.isError(2)) break;
                JRLog.error(2, new Exception("Unspported data type: " + DataTypeDef.toTypeString(n)));
            }
        }
    }

    public void execute(DbValue dbValue) {
        this.exec(dbValue);
    }

    public void reset() {
        if (this.agg != null) {
            if (this.agg instanceof DbNumber) {
                ((DbNumber)this.agg).setValue(ZERO);
            } else {
                this.agg = null;
            }
        }
    }

    public Object clone() {
        return this.clone(true);
    }

    public Object clone(boolean bl) {
        try {
            Aggregation aggregation = (Aggregation)this.getClass().newInstance();
            aggregation.desc = this.desc;
            aggregation.baseGroup = this.baseGroup;
            aggregation.setDenyList(this.denyList);
            if (this.agg != null) {
                aggregation.agg = (DbValue)this.agg.clone();
                if (bl) {
                    aggregation.reset();
                }
            }
            return aggregation;
        }
        catch (Exception exception) {
            if (D.isErrorEnabled()) {
                D.error("", exception);
            }
            return null;
        }
    }

    public Aggregation deepClone(boolean bl) {
        block6: {
            try {
                Aggregation aggregation = (Aggregation)this.getClass().newInstance();
                aggregation.desc = (AggDesc)this.desc.clone();
                aggregation.baseGroup = this.baseGroup;
                aggregation.colDesc = this.colDesc;
                aggregation.setDenyList(this.denyList);
                if (this.agg != null) {
                    aggregation.agg = (DbValue)this.agg.clone();
                    aggregation.agg.desc = (DbColDesc)this.agg.desc.clone();
                    aggregation.agg.desc.setColIndex(-1);
                    if (bl) {
                        aggregation.reset();
                    }
                }
                return aggregation;
            }
            catch (InstantiationException instantiationException) {
                if (D.isErrorEnabled()) {
                    D.error("", instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (!D.isErrorEnabled()) break block6;
                D.error("", illegalAccessException);
            }
        }
        return null;
    }

    public Aggregation deepClone() {
        return this.deepClone(true);
    }

    public AggDesc getAggDesc() {
        return this.desc;
    }

    public void setAggDesc(AggDesc aggDesc) {
        this.desc = aggDesc;
    }

    public boolean isCountFunc() {
        return this.desc.aggCode == 1 || this.desc.aggCode == 5 || this.desc.aggCode == 16 || this.desc.aggCode == 20;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        AggDesc aggDesc = ((Aggregation)object).getAggDesc();
        return this.desc.equals(aggDesc);
    }

    public void writeDescToStream(DataOutputStream dataOutputStream) throws IOException {
        this.desc.writeToStream(dataOutputStream);
    }

    public void readDescFromStream(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.desc.readFromStream(dataInputStream, n, n2);
    }

    public void setBaseGroup(int n) {
        this.baseGroup = n;
    }

    public int getBaseGroup() {
        return this.baseGroup;
    }

    public String getFName() {
        return this.desc.fieldname;
    }

    public String toString() {
        String string = "{";
        string = null != this.desc ? string + this.desc.aggCode : string + "null";
        string = string + ":";
        string = null != this.agg ? string + this.agg.toString() : string + "null";
        string = string + "}";
        return string;
    }

    public static DbColDesc getColDesc(int n, int n2, boolean bl) {
        int n3 = -1;
        switch (n) {
            case 1: 
            case 5: 
            case 16: 
            case 20: {
                n3 = 1;
                break;
            }
            case 2: 
            case 17: {
                n3 = DataTypeDef.SqlToFml(n2, bl);
                break;
            }
            case 3: 
            case 4: 
            case 18: 
            case 19: {
                n3 = DataTypeDef.SqlToFml(n2, bl);
                break;
            }
            case 6: 
            case 21: {
                if (bl) {
                    n3 = 3;
                    break;
                }
                n3 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 4;
                break;
            }
            case 22: 
            case 23: {
                n3 = 4;
                break;
            }
            default: {
                throw new Error("error agg type : " + n);
            }
        }
        int n4 = DataTypeDef.FmlToSql(n3);
        DbColDesc dbColDesc = new DbColDesc(null, n4, -1, -1, 2);
        return dbColDesc;
    }

    protected DbValue createDbValue(DbValue dbValue) {
        DbValue dbValue2 = null;
        dbValue2 = null != this.colDesc ? DbValue.makeDbValue(this.colDesc) : DbValue.makeDbValue(dbValue.getColDesc());
        if (dbValue2.getColDesc().isCurrency() || dbValue2 instanceof DbDecimal) {
            dbValue2 = new fCurrency(dbValue2.getColDesc());
            dbValue2.getColDesc().setCurrency(true);
        }
        return dbValue2;
    }

    protected DbValue createDbValue(int n) {
        DbValue dbValue = null;
        dbValue = null != this.colDesc ? DbValue.makeDbValue(this.colDesc) : DataTypeDef.makeData(n);
        if (dbValue.getColDesc().isCurrency() || dbValue instanceof DbDecimal) {
            dbValue = new fCurrency(dbValue.getColDesc());
            dbValue.getColDesc().setCurrency(true);
        }
        return dbValue;
    }

    public static final int getSqlType(int n, DbColDesc dbColDesc) {
        DbColDesc dbColDesc2 = Aggregation.getColDesc(n, dbColDesc.getSqlType(), dbColDesc.isCurrency());
        return dbColDesc2.getSqlType();
    }

    public void deny() {
        this.isDenied = true;
    }

    public void setDenyList(HashSet hashSet) {
        this.denyList = hashSet;
        if (hashSet == null) {
            return;
        }
        if (hashSet.contains(this.desc.qualifiedFieldName()) || hashSet.contains(this.desc.qualifiedGroupName())) {
            this.deny();
        }
    }

    protected abstract DbValue createDbValue();

    static {
        Aggregation.ZERO.bNull = false;
        D = JRLogger.getLogger(Aggregation.class.getName());
    }
}

