/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;

public abstract class CompondAggregation
extends Aggregation {
    Aggregation[] usedAggs;
    int[] idxs;

    public CompondAggregation() {
    }

    public CompondAggregation(AggDesc aggDesc) {
        super(aggDesc);
    }

    public Aggregation[] getUsedAggs() {
        return this.usedAggs;
    }

    public void setUsedAggs(Aggregation[] aggregationArray) {
        this.usedAggs = aggregationArray;
    }

    public Aggregation[] getReversedUsedAggs() {
        Aggregation[] aggregationArray = null;
        if (this.usedAggs != null) {
            aggregationArray = new Aggregation[this.usedAggs.length];
            for (int i = this.usedAggs.length - 1; i >= 0; --i) {
                aggregationArray[this.usedAggs.length - 1 - i] = this.usedAggs[i];
            }
        }
        return aggregationArray;
    }

    @Override
    public void exec(Record record) {
    }

    @Override
    public void exec(DbValue dbValue) {
    }

    @Override
    public void sum(Aggregation aggregation) {
        this.agg = this.calculate();
    }

    @Override
    public void execute(DbValue dbValue) {
    }

    @Override
    public DbValue getValue() {
        if (this.agg == null) {
            this.agg = this.calculate();
        } else if (this.isRunningTotal()) {
            this.agg = this.calculate();
        }
        if (this.isDenied) {
            this.agg.setNull();
        }
        return this.agg;
    }

    @Override
    public DbValue createDbValue() {
        return DataTypeDef.makeData(2);
    }

    public int[] clearIdxs() {
        int[] nArray = this.idxs;
        this.idxs = null;
        return nArray;
    }

    @Override
    public void writeDescToStream(DataOutputStream dataOutputStream) throws IOException {
        this.desc.writeToStream(dataOutputStream);
        dataOutputStream.writeInt(this.usedAggs.length);
        for (int i = 1; i < this.usedAggs.length; ++i) {
            dataOutputStream.writeInt(this.usedAggs[i].desc.aggidx);
        }
    }

    @Override
    public void readDescFromStream(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.idxs = new int[dataInputStream.readInt()];
        this.usedAggs = new Aggregation[this.idxs.length];
        for (int i = 1; i < this.idxs.length; ++i) {
            this.idxs[i] = dataInputStream.readInt();
        }
    }

    abstract DbValue calculate();

    @Override
    public Aggregation deepClone() {
        return this.deepClone(true);
    }

    @Override
    public Aggregation deepClone(boolean bl) {
        CompondAggregation compondAggregation = (CompondAggregation)super.deepClone(bl);
        compondAggregation.usedAggs = new Aggregation[this.usedAggs.length];
        compondAggregation.usedAggs[0] = compondAggregation;
        for (int i = 1; i < this.usedAggs.length; ++i) {
            compondAggregation.usedAggs[i] = this.usedAggs[i].deepClone(bl);
        }
        return compondAggregation;
    }

    @Override
    public Object clone() {
        CompondAggregation compondAggregation = (CompondAggregation)super.clone();
        compondAggregation.usedAggs = new Aggregation[this.usedAggs.length];
        compondAggregation.usedAggs[0] = compondAggregation;
        for (int i = 1; i < this.usedAggs.length; ++i) {
            compondAggregation.usedAggs[i] = (Aggregation)this.usedAggs[i].clone();
        }
        return compondAggregation;
    }
}

