/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;

public class Distinctcount
extends Aggregation {
    private static final int B = 10;
    DbValue curr;
    DbColDesc coldesc;
    HashSet btree = null;
    private long D;

    public Distinctcount() {
    }

    @Override
    protected DbValue createDbValue() {
        return DataTypeDef.makeData(1);
    }

    Distinctcount(AggDesc aggDesc) {
        super(aggDesc);
        this.agg = this.createDbValue();
        this.agg.bNull = false;
    }

    @Override
    public void exec(Record record) {
        if (null != this.coldesc && this.coldesc.isConstant()) {
            ((DbBigInt)this.agg).value = 1L;
            return;
        }
        if (null == this.coldesc) {
            this.curr = record.getCell(this.desc.fieldname);
            this.coldesc = this.curr.getColDesc();
            if (this.coldesc.isConstant()) {
                ((DbBigInt)this.agg).value = 1L;
                return;
            }
        } else {
            this.curr = record.getCell(this.coldesc.getColIndex());
        }
        this.exec(this.curr);
    }

    @Override
    public void exec(DbValue dbValue) {
        if (dbValue.isNull()) {
            return;
        }
        this.agg.bNull = false;
        if (null == this.btree) {
            this.coldesc = dbValue.getColDesc();
            this.btree = new HashSet();
        }
        switch (this.coldesc.sqlType) {
            case 5: {
                if (!this.btree.add(((DbSmallInt)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case -6: {
                if (!this.btree.add(((DbTinyInt)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 4: {
                if (!this.btree.add(((DbInteger)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case -5: {
                if (!this.btree.add(((DbBigInt)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 7: {
                if (!this.btree.add(Float.valueOf(((DbReal)dbValue).value))) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 2: 
            case 3: {
                if (!this.btree.add(((DbDecimal)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 6: 
            case 8: {
                if (!this.btree.add(((DbDouble)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case -7: {
                if (!this.btree.add(((DbBit)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 91: {
                if (!this.btree.add(((DbDate)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 92: {
                if (!this.btree.add(((DbTime)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case 93: {
                if (!this.btree.add(((DbTimestamp)dbValue).getTimestamp())) break;
                ++((DbBigInt)this.agg).value;
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (!this.btree.add(((DbChar)dbValue).value)) break;
                ++((DbBigInt)this.agg).value;
            }
        }
    }

    public void clearMem() {
        this.btree = null;
        this.curr = null;
        this.coldesc = null;
    }

    @Override
    public void sum(Aggregation aggregation) {
    }

    @Override
    public void execute(DbValue dbValue) {
        this.exec(dbValue);
    }

    public Vector getKeys() {
        Vector<DbValue> vector = new Vector<DbValue>();
        if (null == this.btree) {
            return vector;
        }
        Iterator iterator = this.btree.iterator();
        while (iterator.hasNext()) {
            DbValue dbValue = DbValue.makeDbValue(this.coldesc);
            switch (this.coldesc.sqlType) {
                case 5: {
                    ((DbSmallInt)dbValue).value = (Short)iterator.next();
                    break;
                }
                case -6: {
                    ((DbTinyInt)dbValue).value = (Byte)iterator.next();
                    break;
                }
                case 4: {
                    ((DbInteger)dbValue).value = (Integer)iterator.next();
                    break;
                }
                case -5: {
                    ((DbBigInt)dbValue).value = (Long)iterator.next();
                    break;
                }
                case 7: {
                    ((DbReal)dbValue).value = ((Float)iterator.next()).floatValue();
                    break;
                }
                case 2: 
                case 3: {
                    ((DbDecimal)dbValue).value = (BigDecimal)iterator.next();
                    break;
                }
                case 6: 
                case 8: {
                    ((DbDouble)dbValue).value = (Double)iterator.next();
                    break;
                }
                case -7: {
                    ((DbBit)dbValue).value = (Boolean)iterator.next();
                    break;
                }
                case 91: {
                    ((DbDate)dbValue).value = (Long)iterator.next();
                    break;
                }
                case 92: {
                    ((DbTime)dbValue).value = (Long)iterator.next();
                    break;
                }
                case 93: {
                    Timestamp timestamp = (Timestamp)iterator.next();
                    ((DbTimestamp)dbValue).value = timestamp.getTime();
                    ((DbTimestamp)dbValue).nanos = timestamp.getNanos();
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    ((DbChar)dbValue).value = (String)iterator.next();
                }
            }
            dbValue.bNull = false;
            vector.add(dbValue);
        }
        return vector;
    }
}

