/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.util.loader.DynamicClassManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import jet.ReportEnv;
import jet.dataengine.api.config.JavaFormulaConfig;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.FormulatoJava;
import jet.formula.Info;
import jet.formula.JetRptFormula;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.javacompiler.JavaCompiler;
import jet.formula.javacompiler.JavaCompilerProvider;
import jet.formula.syntaxtree.Variable;
import jet.log.JRLogger;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.LoadJavaFormulaException;
import jet.util.FullClassPath;

public class FormulaCompiler {
    private static JRLogger C = JRLogger.getLogger(FormulaCompiler.class.getName());
    protected FormulaCompilerListener compilerListener;
    protected String tmpDir = null;
    private FormulatoJava CodeEnd = null;
    Info log = new Info();

    public FormulaCompiler(FormulaCompilerListener formulaCompilerListener, JavaFormulaConfig javaFormulaConfig) {
        this.compilerListener = formulaCompilerListener;
        this.tmpDir = javaFormulaConfig == null ? ReportEnv.getTemporaryPath() : javaFormulaConfig.getTempPath();
        String string = this.tmpDir = this.tmpDir == null ? "" : this.tmpDir;
        if (!this.tmpDir.endsWith(File.separator) && !this.tmpDir.equals("")) {
            this.tmpDir = this.tmpDir + File.separator;
        }
    }

    public FormulatoJava getFormulatoJava() {
        return this.CodeEnd;
    }

    protected String translate(Vector vector, String string, VarsTable varsTable) {
        File file;
        PrintStream printStream;
        assert (this.tmpDir != null) : "tmpDir should not be null";
        String string2 = this.tmpDir + string + ".java";
        Vector<FormulaSyntaxErrorException> vector2 = new Vector<FormulaSyntaxErrorException>();
        try {
            printStream = new PrintStream((OutputStream)new FileOutputStream(string2), false, "utf-8");
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (C.isErrorEnabled()) {
                C.error("Can not open printStream: " + string2, fileNotFoundException);
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (C.isErrorEnabled()) {
                C.error("Can not open printStream: " + string2, unsupportedEncodingException);
            }
            return null;
        }
        this.CodeEnd = new FormulatoJava(string, printStream);
        if (vector.size() > 0) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(0);
            this.CodeEnd.setParserOption(jetRptFormula.getFormulaContainer().getParserOption());
        }
        this.CodeEnd.FormulaClass();
        boolean bl = true;
        JetRptFormula jetRptFormula = null;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                jetRptFormula = (JetRptFormula)vector.elementAt(j);
                try {
                    jetRptFormula.parseFormula(this.CodeEnd);
                    continue;
                }
                catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                    if (i == 0) {
                        bl = false;
                        continue;
                    }
                    vector2.addElement(formulaSyntaxErrorException);
                }
            }
            if (bl) break;
        }
        this.CodeEnd.declareVar(varsTable);
        this.CodeEnd.declareField();
        this.CodeEnd.declareAggDesc();
        this.CodeEnd.declareTempVar(varsTable);
        this.CodeEnd.schedule(vector);
        this.CodeEnd.CodeEnd();
        printStream.close();
        if (this.compilerListener != null) {
            this.compilerListener.translateComplete(vector2);
        }
        if (!(file = new File(string2)).exists()) {
            return null;
        }
        return string2;
    }

    protected Vector parseRefUDFName(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(i);
            if (!jetRptFormula.isparsedOK()) continue;
            Vector vector3 = jetRptFormula.formulainfo.refUDFClass;
            for (int j = 0; j < vector3.size(); ++j) {
                String string = (String)vector3.elementAt(j);
                if (vector2.contains(string) || string.length() <= 0) continue;
                vector2.add(string);
            }
        }
        return vector2;
    }

    protected String reflectClasspath(ClassLoader classLoader, Class clazz) {
        String string = clazz.getName().replace('.', '/') + ".class";
        URL uRL = classLoader.getResource(string);
        String string2 = URLDecoder.decode(uRL.getPath());
        String string3 = uRL.getProtocol();
        if (string3.equals("jar") || string3.equals("wsjar") || string3.equals("zip")) {
            if (string2.startsWith("file:")) {
                string2 = string2.charAt(7) == ':' ? string2.substring(6) : string2.substring(5);
            }
            return string2.substring(0, string2.indexOf(33)).replace('/', File.separatorChar);
        }
        if (string2.length() >= 3 && string2.charAt(0) == '/' && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        return string2.substring(0, string2.length() - string.length()).replace('/', File.separatorChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean $assertionsDisabled(File file, String string) {
        if (file.exists() && file.isFile()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                if (zipFile.getEntry(string) != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (ZipException zipException) {
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                boolean bl = false;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                try {
                    zipFile.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                return bl;
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return false;
    }

    protected String filterClassPath() {
        String string = "";
        String string2 = System.getProperty("java.home");
        String string3 = FullClassPath.getFullClassPath();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.indexOf(string2.substring(0, string2.length() - 4)) >= 0) continue;
            if (string4.endsWith(".zip") || string4.endsWith(".jar")) {
                File file = new File(string4);
                if (!file.exists() || !file.isFile() || !this.$assertionsDisabled(file, "jet")) continue;
                string = string + string4 + File.pathSeparator;
                continue;
            }
            string = string + string4 + File.pathSeparator;
        }
        return string;
    }

    private String C(String string) {
        String string2 = null;
        if (null != string) {
            string2 = "\"" + string.replace("\"", "") + "\"";
        }
        return string2;
    }

    protected String constructClassPath(Vector vector) {
        int n;
        String[] stringArray;
        String string = "";
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = (String[])vector.elementAt(i);
            stringArray2[i] = stringArray.indexOf(46) < 0 ? "jet.formula.javaformula." + (String)stringArray : stringArray;
        }
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        stringArray = dynamicClassManager.getResourceName(stringArray2);
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n];
            string = string.endsWith(File.pathSeparator) ? string + string2 : string + File.pathSeparator + string2;
        }
        for (n = 0; n < vector.size(); ++n) {
            try {
                Class<?> clazz = Class.forName(stringArray2[n]);
                String string3 = this.reflectClasspath(clazz.getClassLoader(), clazz);
                if (string.endsWith(File.pathSeparator)) {
                    string = string + string3;
                    continue;
                }
                string = string + File.pathSeparator + string3;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!C.isErrorEnabled()) continue;
                C.error(classNotFoundException);
            }
        }
        String[] stringArray3 = new String[]{"jet.formula.FormulaClassLoader", "jet.util.FullClassPath", "jet.connect.DbQuery", "jet.datasource.JRHierarchicalDataset", "jet.jaridentifier.JREngineJARIdentifier"};
        stringArray = dynamicClassManager.getResourceName(stringArray3);
        C.info("Class path found by Dynamic loader: " + stringArray);
        if (null != stringArray) {
            C.info("Class path found by Dynamic loader#1 length: " + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                C.info("Class path found by Dynamic loader#2 item 1: " + stringArray[i]);
            }
        }
        if (null == stringArray || stringArray.length == 0) {
            if (C.isDebugEnabled()) {
                C.info("Dynamic loader not found class path.");
            }
            String string4 = ReportEnv.getEnginePath();
            if (C.isDebugEnabled()) {
                C.info("Class path found by ReportEnv.getEnginePath(): " + string4);
            }
            if (null == string4) {
                string4 = "";
            }
            stringArray = new String[]{string4};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            string = string.endsWith(File.pathSeparator) ? string + string2 : string + File.pathSeparator + string2;
        }
        string2 = this.filterClassPath();
        string = string.endsWith(File.pathSeparator) ? string + string2 : string + File.pathSeparator + string2;
        return string;
    }

    protected String compileJava(String string, Vector vector) throws GenerateFormulasCodeException {
        File file;
        Vector vector2 = this.parseRefUDFName(vector);
        String string2 = this.constructClassPath(vector2);
        string2 = this.C(string2);
        String[] stringArray = new String[]{"-source", "1.4", "-target", "1.4", "-nowarn", "-encoding", "utf8", "-classpath", string2, string};
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + " " + stringArray[i];
        }
        if (C.isDebugEnabled()) {
            C.debug("The compile cmd: " + string3);
        }
        String string4 = null;
        JavaCompiler javaCompiler = JavaCompilerProvider.getJavaCompiler(this.tmpDir);
        if (javaCompiler == null) {
            if (C.isErrorEnabled()) {
                C.error("Cannot find java compiler!");
            }
            return null;
        }
        C.info("JavaCompiler: " + javaCompiler.getClass().getName());
        String[] stringArray2 = javaCompiler.compileJavaFile(stringArray);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!C.isErrorEnabled()) continue;
                C.error("java compiler message: " + stringArray2[i]);
            }
        }
        if (!(file = new File(string4 = string.substring(0, string.indexOf(".java")) + ".class")).exists()) {
            string4 = null;
            if (C.isErrorEnabled()) {
                C.error("class file not created!");
            }
        }
        return string4;
    }

    private void CodeEnd(Hashtable hashtable, VarsTable varsTable) {
        hashtable.clear();
        Enumeration enumeration = varsTable.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof SymbolInfo)) continue;
            SymbolInfo symbolInfo = (SymbolInfo)v;
            if (symbolInfo.attr != 10) continue;
            Variable variable = new Variable(symbolInfo.getSymName(), true, symbolInfo.type, symbolInfo.precise, symbolInfo.scale);
            hashtable.put(symbolInfo.getSymName(), variable);
        }
    }

    public String compileFormulas(Vector vector, String string, FormulaContainer formulaContainer) throws GenerateFormulasCodeException {
        if (vector == null || vector.size() == 0) {
            if (C.isDebugEnabled()) {
                C.debug("Did not compile formula because input 0 JetRptFormulas");
            }
            return null;
        }
        this.log.begin(string, "compile formula");
        Hashtable hashtable = formulaContainer.getGlobalVarContainer();
        VarsTable varsTable = formulaContainer.getGVarTable();
        this.CodeEnd(hashtable, varsTable);
        String string2 = this.compileFormulas(vector, string, varsTable);
        this.log.end(string, "compile formula");
        return string2;
    }

    public String compileFormulas(Vector vector, String string, VarsTable varsTable) throws GenerateFormulasCodeException {
        if (vector == null || vector.size() == 0) {
            if (C.isDebugEnabled()) {
                C.debug("Did not compile formula because input 0 JetRptFormulas");
            }
            return null;
        }
        String string2 = null;
        string2 = this.translate(vector, string, varsTable);
        if (string2 == null) {
            if (C.isErrorEnabled()) {
                C.error("FormulaComiler: the java file is null");
            }
            return null;
        }
        String string3 = this.compileJava(string2, vector);
        return string3;
    }

    public void checkFormulas(Vector vector) throws ParseFormulaFailedException {
        String string = "tempClass";
        if (vector == null || vector.size() == 0) {
            return;
        }
        Object object = (JetRptFormula)vector.elementAt(0);
        FormulaContainer formulaContainer = ((JetRptFormula)object).getFormulaContainer();
        Object object2 = formulaContainer.getGlobalVarContainer();
        VarsTable varsTable = formulaContainer.getGVarTable();
        this.CodeEnd((Hashtable)object2, varsTable);
        this.CodeEnd = new FormulatoJava(string, null);
        JetRptFormula jetRptFormula = (JetRptFormula)vector.elementAt(0);
        this.CodeEnd.setParserOption(formulaContainer.getParserOption());
        object = new Vector();
        boolean bl = true;
        object2 = null;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                object2 = (JetRptFormula)vector.elementAt(j);
                try {
                    ((JetRptFormula)object2).parseFormula(this.CodeEnd);
                    continue;
                }
                catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
                    if (i == 0) {
                        bl = false;
                        continue;
                    }
                    ((Vector)object).addElement(formulaSyntaxErrorException);
                }
            }
            if (bl) break;
        }
        if (((Vector)object).size() > 0) {
            throw new ParseFormulaFailedException((Vector)object);
        }
    }

    public Object loadJavaFormula(String string, byte[] byArray) throws InstantiationException, IllegalAccessException, ClassNotFoundException, LoadJavaFormulaException {
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        Class clazz = dynamicClassManager.bytesToClass(string, byArray);
        Object var5_5 = null;
        try {
            var5_5 = clazz.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (C.isErrorEnabled()) {
                C.error(noClassDefFoundError);
            }
            LoadJavaFormulaException loadJavaFormulaException = new LoadJavaFormulaException(1);
            loadJavaFormulaException.initCause(noClassDefFoundError);
            throw loadJavaFormulaException;
        }
        return var5_5;
    }
}

