/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.controls.JetObject;
import jet.formula.AbstractProperty;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.CompondAggregation;
import jet.formula.SqlwNode;
import jet.formula.SymbolInfo;
import jet.formula.application.cm.MeasureExpression;
import jet.formula.syntaxtree.Symbol;
import jet.log.JRLogger;

public class FormulaInfo
extends AbstractProperty {
    public static byte USE_SYSVAR = 1;
    public static byte NEXT_PREV = (byte)2;
    public static byte USE_PAGEVAR = (byte)4;
    public static byte NO_RECORD_CALLED = (byte)8;
    public static byte REF_RUNNING_TOTAL = (byte)16;
    public boolean parseOK = false;
    public SymbolInfo formulatype;
    private byte IsSum = 0;
    public boolean isGlobal = false;
    public boolean isGroupby = false;
    public Vector GroupbyNames = new Vector();
    public Vector refFormula = new Vector();
    public Vector refAggregation = new Vector();
    public Vector refDBfield = new Vector();
    public Vector refParameter = new Vector();
    public AggDesc aggdesc = null;
    public SqlwNode root;
    public int callee;
    public Vector refEnFormula = new Vector();
    public Vector refEnDbField = new Vector();
    public Vector refEnParameter = new Vector();
    public Vector refUDFClass = new Vector();
    public Vector refBuildInFunctions = new Vector();
    public Vector refMeasure = new Vector();
    private static JRLogger SEDU = JRLogger.getLogger(FormulaInfo.class.getName());
    public Vector importInfo = new Vector();
    public Vector UDFPrototypes = new Vector();
    public Vector refFormulaByUDF = new Vector();
    public static final short MAJOR_VER_FS_105158 = 1;
    public static final short MINOR_VER_FS_105158 = 11;
    public static final short MINOR_VER_FS_118687 = 12;
    public static final short MINOR_VER_FS_105211 = 13;
    public static final short MINOR_VER_FS_63921 = 14;
    public static final short MAJOR_VERSION = 1;
    public static final short MINOR_VERSION = 14;
    private int add = 1;
    private int addAll = 14;
    private Symbol addElement = null;
    public Vector refSysVars = new Vector();
    public Hashtable globalVars = new Hashtable();
    public Vector refDataMapping = new Vector();
    public Vector refMeasureExpression = new Vector();

    public void setIsNoRecordCalled(boolean bl) {
        this.IsSum = bl ? (byte)(this.IsSum | NO_RECORD_CALLED) : (byte)(this.IsSum & ~NO_RECORD_CALLED);
    }

    public boolean isNoRecordCalled() {
        return (this.IsSum & NO_RECORD_CALLED) == NO_RECORD_CALLED;
    }

    public void setRefRunningTotal(boolean bl) {
        this.IsSum = bl ? (byte)(this.IsSum | REF_RUNNING_TOTAL) : (byte)(this.IsSum & ~REF_RUNNING_TOTAL);
    }

    public boolean isRefRunningTotal() {
        return (this.IsSum & REF_RUNNING_TOTAL) == REF_RUNNING_TOTAL;
    }

    public void nonDuplicateAdd(Vector vector, Object object) {
        if (vector == null) {
            return;
        }
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }

    public void addRefAggregation(Aggregation aggregation) {
        this.nonDuplicateAdd(this.refAggregation, aggregation);
    }

    public void addRefBuildInFunctions(String string) {
        if (!this.refBuildInFunctions.contains(string)) {
            this.refBuildInFunctions.add(string);
        }
    }

    public Vector getRefBuildInFunctions() {
        return this.refBuildInFunctions;
    }

    public void addRefUDFClass(String string) {
        this.nonDuplicateAdd(this.refUDFClass, string);
    }

    public void addRefFormula(String string) {
        this.nonDuplicateAdd(this.refFormula, string);
    }

    public void addRefDbField(String string) {
        this.nonDuplicateAdd(this.refDBfield, string);
    }

    public void addRefParameter(String string) {
        this.nonDuplicateAdd(this.refParameter, string);
    }

    public void addRefFormula(String string, String string2) {
        this.refEnFormula.addElement(string);
        this.refFormula.addElement(string2);
    }

    public void addRefDbField(String string, String string2) {
        this.refEnDbField.addElement(string);
        this.refDBfield.addElement(string2);
    }

    public void addRefParameter(String string, String string2) {
        this.refEnParameter.addElement(string);
        this.refParameter.addElement(string2);
    }

    public String getRealDbFieldName(String string) {
        int n = this.refEnFormula.indexOf(string);
        if (n >= 0) {
            return (String)this.refFormula.elementAt(n);
        }
        n = this.refEnDbField.indexOf(string);
        if (n >= 0) {
            return (String)this.refDBfield.elementAt(n);
        }
        n = this.refEnParameter.indexOf(string);
        if (n >= 0) {
            return (String)this.refParameter.elementAt(n);
        }
        return string;
    }

    public void addRefMeasure(String string) {
        this.nonDuplicateAdd(this.refMeasure, string);
    }

    public FormulaInfo() {
    }

    public FormulaInfo(JetObject jetObject, String string) {
        super(jetObject, string);
    }

    void outStringVector(Vector vector, DataOutputStream dataOutputStream) throws IOException {
        int n = vector.size();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeUTF((String)vector.elementAt(i));
        }
    }

    void inStringVector(Vector vector, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            if (vector.contains(string)) continue;
            vector.addElement(string);
        }
    }

    private void GroupbyNames(Hashtable hashtable, DataOutputStream dataOutputStream) throws IOException {
        Enumeration enumeration = hashtable.keys();
        int n = hashtable.size();
        dataOutputStream.writeInt(n);
        while (enumeration.hasMoreElements()) {
            int n2;
            Integer n3 = (Integer)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(n3);
            if (vector == null || (n2 = vector.size()) <= 0) continue;
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                dataOutputStream.writeUTF((String)vector.elementAt(i));
            }
        }
    }

    private void IsSum(Hashtable hashtable, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            Vector<String> vector = new Vector<String>();
            for (int j = 0; j < n3; ++j) {
                vector.addElement(dataInputStream.readUTF());
            }
            hashtable.put(new Integer(n2), vector);
        }
    }

    public void addImportInfo(String string) {
        this.nonDuplicateAdd(this.importInfo, string);
    }

    public Vector getImportInfo() {
        return this.importInfo;
    }

    public void addUDFPrototype(Object[] objectArray) {
        this.nonDuplicateAdd(this.UDFPrototypes, objectArray);
    }

    public Vector getUDFPrototypes() {
        return this.UDFPrototypes;
    }

    private void NEXT_PREV(Vector vector, DataOutputStream dataOutputStream) throws IOException {
        int n = vector.size();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            String string = "";
            for (int j = 0; j < objectArray.length; ++j) {
                string = string + objectArray[j].toString() + ",";
            }
            string = string.substring(0, string.length() - 1);
            dataOutputStream.writeUTF(string);
        }
    }

    private void NO_RECORD_CALLED(Vector vector, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            int n2 = stringTokenizer.countTokens();
            Object[] objectArray = new Object[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                objectArray[n3] = n3 == 1 || n3 >= 3 ? Integer.valueOf(stringTokenizer.nextToken()) : stringTokenizer.nextToken();
                ++n3;
            }
            vector.addElement(objectArray);
        }
    }

    public void addRefFormulaByUDF(String string) {
        this.nonDuplicateAdd(this.refFormulaByUDF, string);
    }

    public Vector getRefFormulaByUDF() {
        return this.refFormulaByUDF;
    }

    @Override
    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(-5583634);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(14);
            dataOutputStream.writeBoolean(this.parseOK);
            if (this.parseOK) {
                dataOutputStream.writeUTF(this.formulatype.getSymName());
                dataOutputStream.writeInt(this.formulatype.getAttr());
                dataOutputStream.writeInt(this.formulatype.getDataType());
                dataOutputStream.writeBoolean(this.formulatype.IsSum());
                dataOutputStream.writeInt(this.formulatype.getPrecise());
                dataOutputStream.writeInt(this.formulatype.getScale());
                dataOutputStream.writeByte(this.IsSum);
                dataOutputStream.writeBoolean(this.isGlobal);
                dataOutputStream.writeBoolean(this.isGroupby);
                dataOutputStream.writeInt(this.callee);
                this.outStringVector(this.GroupbyNames, dataOutputStream);
                this.outStringVector(this.refFormula, dataOutputStream);
                this.outStringVector(this.refDBfield, dataOutputStream);
                this.outStringVector(this.refParameter, dataOutputStream);
                this.outStringVector(this.refEnFormula, dataOutputStream);
                this.outStringVector(this.refEnDbField, dataOutputStream);
                this.outStringVector(this.refEnParameter, dataOutputStream);
                this.outStringVector(this.refUDFClass, dataOutputStream);
                this.outStringVector(this.refSysVars, dataOutputStream);
                this.GroupbyNames(this.globalVars, dataOutputStream);
                this.outStringVector(this.refBuildInFunctions, dataOutputStream);
                this.outStringVector(this.importInfo, dataOutputStream);
                this.NEXT_PREV(this.UDFPrototypes, dataOutputStream);
                this.outStringVector(this.refMeasure, dataOutputStream);
                this.outStringVector(this.refFormulaByUDF, dataOutputStream);
                this.outStringVector(this.refDataMapping, dataOutputStream);
                int n = this.refMeasureExpression.size();
                dataOutputStream.writeInt(n);
                for (MeasureExpression measureExpression : this.refMeasureExpression) {
                    measureExpression.write(dataOutputStream);
                }
                int n2 = this.refAggregation.size();
                dataOutputStream.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    ((Aggregation)this.refAggregation.elementAt(i)).writeDescToStream(dataOutputStream);
                }
                if (this.aggdesc == null) {
                    dataOutputStream.writeInt(-1);
                } else {
                    dataOutputStream.writeInt(this.aggdesc.aggCode);
                    this.aggdesc.writeToStream(dataOutputStream);
                }
                dataOutputStream.writeInt(1410895008);
                dataOutputStream.writeShort(0);
                dataOutputStream.writeShort(1);
                if (this.root == null) {
                    dataOutputStream.writeShort(0);
                } else {
                    dataOutputStream.writeShort(1);
                    this.root.toByteArray(dataOutputStream);
                }
            }
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (SEDU.isErrorEnabled()) {
                SEDU.error("", unsupportedEncodingException);
            }
            return null;
        }
        catch (Exception exception) {
            if (SEDU.isErrorEnabled()) {
                SEDU.error("", exception);
            }
            return null;
        }
    }

    public int getMajorVersion() {
        return this.add;
    }

    public int getMinorVersion() {
        return this.addAll;
    }

    @Override
    public void setByteArray(byte[] byArray) {
        block32: {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (-5583634 != dataInputStream.readInt()) {
                    throw new Error("Formula Signature Error");
                }
                short s = dataInputStream.readShort();
                this.add = s;
                short s2 = dataInputStream.readShort();
                this.addAll = s2;
                if (s > 1 || s == 0 && s2 > 9 || s == 1 && s2 > 14) {
                    throw new Error("Cannot handle this version : " + s + "." + s2);
                }
                this.parseOK = dataInputStream.readBoolean();
                if (this.parseOK) {
                    int n;
                    Object object;
                    int n2;
                    int n3;
                    this.formulatype = new SymbolInfo();
                    this.formulatype.setSymName(dataInputStream.readUTF());
                    this.formulatype.setAttr(dataInputStream.readInt());
                    this.formulatype.setDataType(dataInputStream.readInt());
                    this.formulatype.setSum(dataInputStream.readBoolean());
                    if (s > 0 || s2 > 7) {
                        this.formulatype.setPrecise(dataInputStream.readInt());
                        this.formulatype.setScale(dataInputStream.readInt());
                    }
                    if (s > 0) {
                        this.IsSum = dataInputStream.readByte();
                    }
                    this.isGlobal = dataInputStream.readBoolean();
                    this.isGroupby = dataInputStream.readBoolean();
                    this.callee = dataInputStream.readInt();
                    this.inStringVector(this.GroupbyNames, dataInputStream);
                    this.inStringVector(this.refFormula, dataInputStream);
                    this.inStringVector(this.refDBfield, dataInputStream);
                    this.inStringVector(this.refParameter, dataInputStream);
                    if (s == 1 && s2 > 0) {
                        this.inStringVector(this.refEnFormula, dataInputStream);
                        this.inStringVector(this.refEnDbField, dataInputStream);
                        this.inStringVector(this.refEnParameter, dataInputStream);
                    }
                    if (s2 >= 2) {
                        this.inStringVector(this.refUDFClass, dataInputStream);
                    }
                    if (s2 >= 3) {
                        this.inStringVector(this.refSysVars, dataInputStream);
                    }
                    if (s2 >= 4) {
                        this.IsSum(this.globalVars, dataInputStream);
                    }
                    if (s2 >= 5) {
                        this.inStringVector(this.refBuildInFunctions, dataInputStream);
                    }
                    if (s2 >= 6) {
                        this.inStringVector(this.importInfo, dataInputStream);
                        this.NO_RECORD_CALLED(this.UDFPrototypes, dataInputStream);
                    }
                    if (s2 >= 7) {
                        this.inStringVector(this.refMeasure, dataInputStream);
                    }
                    if (s2 >= 8) {
                        this.inStringVector(this.refFormulaByUDF, dataInputStream);
                    }
                    if (s2 >= 10 && s2 < 14) {
                        this.inStringVector(new Vector(), dataInputStream);
                        n3 = dataInputStream.readInt();
                        for (n2 = 0; n2 < n3; ++n2) {
                            object = new Vector();
                            this.inStringVector((Vector)object, dataInputStream);
                        }
                    }
                    if (s2 >= 12) {
                        this.inStringVector(this.refDataMapping, dataInputStream);
                    }
                    if (s2 >= 14) {
                        n3 = dataInputStream.readInt();
                        for (n2 = 0; n2 < n3; ++n2) {
                            object = new MeasureExpression();
                            ((MeasureExpression)object).read(dataInputStream, this.add, this.addAll);
                            this.refMeasureExpression.addElement(object);
                        }
                    }
                    n3 = dataInputStream.readInt();
                    String string = null;
                    for (n = 0; n < n3; ++n) {
                        AggDesc aggDesc = new AggDesc();
                        aggDesc.readFromStream(dataInputStream, s, s2);
                        string = aggDesc.specFunc;
                        object = Aggregation.makeAgg(aggDesc);
                        this.refAggregation.addElement(object);
                        if (!(object instanceof CompondAggregation)) continue;
                        ((CompondAggregation)object).readDescFromStream(dataInputStream, s, s2);
                        int[] nArray = ((CompondAggregation)object).clearIdxs();
                        Aggregation[] aggregationArray = ((CompondAggregation)object).getUsedAggs();
                        for (int i = 1; i < aggregationArray.length; ++i) {
                            aggregationArray[i] = object = (Aggregation)this.refAggregation.elementAt(nArray[i]);
                            aggregationArray[i].desc.aggidx = nArray[i];
                        }
                    }
                    if (s > 0 || s2 > 8) {
                        n = dataInputStream.readInt();
                        if (n == -1) {
                            this.aggdesc = null;
                        } else if (s2 >= 9) {
                            this.aggdesc = new AggDesc();
                            this.aggdesc.readFromStream(dataInputStream, s, s2);
                        } else {
                            this.aggdesc = new AggDesc(dataInputStream.readUTF(), dataInputStream.readUTF(), n, string);
                        }
                    }
                    if (s > 0 || s2 >= 7) {
                        if (1410895008 != dataInputStream.readInt()) {
                            throw new Error("Met dirty data (version mismatch), current formula version is : " + s + "." + s2);
                        }
                        if (0 < dataInputStream.readShort()) {
                            throw new Error("Met dirty data (version mismatch), current formula version is : " + s + "." + s2);
                        }
                        n = dataInputStream.readShort();
                        if (n > 1) {
                            throw new Error("Met dirty data (version mismatch), current formula version is : " + s + "." + s2);
                        }
                        if (dataInputStream.readShort() == 1) {
                            this.root = new SqlwNode().setByteArray(dataInputStream);
                        }
                    }
                }
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                if (!SEDU.isErrorEnabled()) break block32;
                SEDU.error("", exception);
            }
        }
    }

    @Override
    public final boolean isEnableAutoValue() {
        return false;
    }

    @Override
    public void set(String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by;
            by = (by = byArray[i++]) > 57 ? (byte)(by - 65 + 10) : (byte)(by - 48);
            by = (byte)(by << 4);
            byte by2 = byArray[i];
            by2 = by2 > 57 ? (byte)(by2 - 65 + 10) : (byte)(by2 - 48);
            byArray2[i >> 1] = by = (byte)(by | by2);
        }
        this.setByteArray(byArray2);
    }

    @Override
    public String toString() {
        byte[] byArray = this.toByteArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte by;
            byte by2;
            int n3 = (by2 = (byte)(((by = byArray[n++]) & 0xFF) >> 4)) > 9 ? by2 - 10 + 65 : by2 + 48;
            stringBuffer.append((char)n3);
            by = (byte)(by & 0xF);
            n3 = by > 9 ? by - 10 + 65 : by + 48;
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public void copyTo(FormulaInfo formulaInfo) {
        if (formulaInfo == null) {
            return;
        }
        formulaInfo.add = this.add;
        formulaInfo.addAll = this.addAll;
        formulaInfo.parseOK = this.parseOK;
        formulaInfo.formulatype = this.formulatype != null ? (SymbolInfo)this.formulatype.clone() : null;
        formulaInfo.IsSum = this.IsSum;
        formulaInfo.isGlobal = this.isGlobal;
        formulaInfo.isGroupby = this.isGroupby;
        formulaInfo.GroupbyNames = this.GroupbyNames;
        formulaInfo.refFormula = this.refFormula;
        formulaInfo.refAggregation.clear();
        for (int i = 0; i < this.refAggregation.size(); ++i) {
            formulaInfo.refAggregation.addElement(((Aggregation)this.refAggregation.elementAt(i)).deepClone());
        }
        formulaInfo.refDBfield = this.refDBfield;
        formulaInfo.refParameter = this.refParameter;
        formulaInfo.refEnFormula = this.refEnFormula;
        formulaInfo.refEnDbField = this.refEnDbField;
        formulaInfo.refEnParameter = this.refEnParameter;
        formulaInfo.refUDFClass = this.refUDFClass;
        formulaInfo.refSysVars = this.refSysVars;
        formulaInfo.refBuildInFunctions = this.refBuildInFunctions;
        formulaInfo.globalVars = this.globalVars;
        formulaInfo.importInfo = this.importInfo;
        formulaInfo.UDFPrototypes = this.UDFPrototypes;
        formulaInfo.root = this.root;
        formulaInfo.callee = this.callee;
        if (this.aggdesc != null) {
            formulaInfo.aggdesc = (AggDesc)this.aggdesc.clone();
        }
        formulaInfo.refMeasure = this.refMeasure;
        formulaInfo.refMeasureExpression.clear();
        for (MeasureExpression measureExpression : this.refMeasureExpression) {
            formulaInfo.refMeasureExpression.addElement((MeasureExpression)measureExpression.clone());
        }
        formulaInfo.refDataMapping = this.refDataMapping;
    }

    public Object clone() {
        FormulaInfo formulaInfo = new FormulaInfo();
        this.copyTo(formulaInfo);
        return formulaInfo;
    }

    public void setUseSysVar(boolean bl) {
        this.IsSum = bl ? (byte)(this.IsSum | USE_SYSVAR) : (byte)(this.IsSum & ~USE_SYSVAR);
    }

    public boolean isSysVar() {
        return (this.IsSum & USE_SYSVAR) == USE_SYSVAR;
    }

    public void setNextPrev(boolean bl) {
        this.IsSum = bl ? (byte)(this.IsSum | NEXT_PREV) : (byte)(this.IsSum & ~NEXT_PREV);
    }

    public boolean isNextPrev() {
        return (this.IsSum & NEXT_PREV) == NEXT_PREV;
    }

    public byte getState() {
        return this.IsSum;
    }

    public void setState(byte by) {
        this.IsSum = by;
    }

    public void mergeState(byte by) {
        this.IsSum = (byte)(this.IsSum | by);
    }

    public void setUsePageVar(boolean bl) {
        this.IsSum = bl ? (byte)(this.IsSum | USE_PAGEVAR) : (byte)(this.IsSum & ~USE_PAGEVAR);
    }

    public boolean isUsePageVar() {
        return (this.IsSum & USE_PAGEVAR) == USE_PAGEVAR;
    }

    public void setSyntaxTree(Symbol symbol) {
        this.addElement = symbol;
    }

    public Symbol getSyntaxTree() {
        return this.addElement;
    }

    public void addRefSysVar(String string) {
        this.nonDuplicateAdd(this.refSysVars, string);
    }

    public Vector getRefSysVars() {
        return this.refSysVars;
    }

    public boolean isSysVarReferred(String string) {
        for (int i = 0; i < this.refSysVars.size(); ++i) {
            String string2 = (String)this.refSysVars.elementAt(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupBy() {
        return this.GroupbyNames.size() != 0 || this.isGroupby;
    }

    public SymbolInfo getSymbolInfo() {
        this.formulatype.setIsRunningTotal(this.isRefRunningTotal());
        return this.formulatype;
    }

    public void addRefGlobalVar(int n, String string) {
        Integer n2 = new Integer(n);
        Vector<String> vector = (Vector<String>)this.globalVars.get(n2);
        if (vector == null) {
            vector = new Vector<String>();
            this.globalVars.put(n2, vector);
        }
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    public Vector getRefGlobalVar(int n) {
        Integer n2 = new Integer(n);
        return (Vector)this.globalVars.get(n2);
    }

    public void viewRefNames() {
        System.out.println(this.formulatype.name + ": " + "\nrefAggregation = " + this.refAggregation + "\nrefBuildInFunctions = " + this.refBuildInFunctions + "\nrefDBfield = " + this.refDBfield + "\nrefFormula = " + this.refFormula + "\nrefFormulaByUDF = " + this.refFormulaByUDF + "\nrefMeasure = " + this.refMeasure + "\nrefParameter = " + this.refParameter + "\nrefSysVars = " + this.refSysVars + "\nrefUDFClass = " + this.refUDFClass + "\nUDFPrototypes = " + this.UDFPrototypes);
    }

    public void addRefDataMapping(String string) {
        this.nonDuplicateAdd(this.refDataMapping, string);
    }

    public boolean isLanguageRelated() {
        String[] stringArray = new String[]{"translate"};
        Vector vector = this.refBuildInFunctions;
        for (Object e : vector) {
            for (String string : stringArray) {
                if (!string.equalsIgnoreCase((String)e)) continue;
                return true;
            }
        }
        return false;
    }

    public void addRefMeasureExpression(MeasureExpression measureExpression) {
        this.nonDuplicateAdd(this.refMeasureExpression, measureExpression);
    }

    public Vector getAllRefMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(this.refMeasure);
        for (MeasureExpression measureExpression : this.refMeasureExpression) {
            String string;
            if (measureExpression.getMeasureType() != 1 || vector.contains(string = measureExpression.getMeasureName())) continue;
            vector.add(string);
        }
        return vector;
    }
}

