/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.formula.AggDesc;
import jet.formula.DataTypeDef;
import jet.formula.FormulaError;
import jet.formula.GSymbolInfo;
import jet.formula.JetRptFormula;
import jet.formula.JetRptSummary;
import jet.formula.ParserOption;
import jet.formula.SymbolInfo;
import jet.formula.VarRegisterTable;
import jet.formula.application.cm.MeasureExpression;
import jet.formula.formula;
import jet.log.JRLogger;
import jet.util.HashVector;

public class FormulatoJava {
    private static final int ASSIGN = 32;
    private static final int AggDescName = 1024;
    protected StringBuffer strbuf;
    protected boolean gencode = false;
    public String formulaname;
    public String className;
    public PrintStream writer;
    int tab = 0;
    public int[] maxtmpcnt = new int[33];
    public Vector aggdesc = new Vector();
    public Hashtable DbField = new Hashtable(100);
    public Vector measureExpr = new Vector();
    private StringBuffer DataTypeToClass = new StringBuffer();
    private static JRLogger FormulaHeader = JRLogger.getLogger(FormulatoJava.class.getName());
    private Vector IsSum = new Vector();
    private static final String SEDU = "registerDbFields()";
    private static final String TestNull = "registerFormulaNames()";
    private static final String TmpName = "registerGlobalVariables()";
    private static final String VarName_value = "initAggDescs()";
    private static final String abs = "initMeasureExp()";
    private StringBuffer add = new StringBuffer();
    private int addElement = 0;
    private int aggCode = 0;
    private boolean[] append = new boolean[32];
    private static String attr = "bFirst_";
    private static String buildStmts = "bBreak_";
    private static String callee = "bContinue_";
    private static final String[] charAt = new String[]{">", "<", "==", "!=", ">=", "<="};
    public static final int CMPG = 0;
    public static final int CMPL = 1;
    public static final int CMPE = 2;
    public static final int CMPNE = 3;
    public static final int CMPGE = 4;
    public static final int CMPLE = 5;
    public static final int IN = 6;
    private static final String[] clone = new String[]{")&&(", ")||(", "!("};
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    String[] unarystr = new String[]{"-", "+"};
    private static final String close = "formulafunctions";
    public int selectStmtCnt = 0;
    public static int RANGETO = 0;
    public static int RANGE_TO = 1;
    public static int RANGETO_ = 2;
    public static int RANGE_TO_ = 3;
    public static int RANGEUPFROM = 4;
    public static int RANGEUPFROM_ = 5;
    public static int RANGEUPTO = 6;
    public static int RANGEUPTO_ = 7;
    private ParserOption codes = null;

    public FormulatoJava(String string, PrintStream printStream) {
        this.className = this.regulateName_old(string);
        this.writer = printStream;
        if (this.writer == null) {
            this.gencode = false;
        } else {
            this.gencode = true;
            this.strbuf = new StringBuffer(1024);
        }
    }

    public void restoreFormulaName(String string) {
        this.formulaname = FormulatoJava.regulateName(string);
    }

    public void setFormulaName(String string) {
        if (!this.IsSum.contains(string)) {
            this.IsSum.add(string);
        }
        this.formulaname = FormulatoJava.regulateName(string);
        this.tab = 2;
        this.aggCode = 0;
    }

    public void FormulaClass() {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append("package jet.formula.javaformula;").append("\n\nimport jet.formula.*;").append("\nimport jet.formula.application.cm.*;").append("\nimport jet.util.*;").append("\nimport jet.connect.*;").append("\nimport java.util.*;").append("\nimport java.math.*;\n\n");
            this.strbuf.append("public class ").append(this.className).append(" extends ExecutableJavaFormula\n{");
            this.writer.println(this.strbuf.toString());
        }
    }

    protected String escape2Unicode(String string) {
        StringWriter stringWriter = new StringWriter();
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] > '\u00ff') {
                String string2 = Integer.toHexString(cArray[i]);
                n = 4 - string2.length();
                for (int j = 0; j < n; ++j) {
                    string2 = '0' + string2;
                }
                string2 = "\\u" + string2;
                stringWriter.write(string2);
                continue;
            }
            stringWriter.write(cArray[i]);
        }
        return stringWriter.toString();
    }

    private void ASSIGN() {
        if (!this.gencode) {
            return;
        }
        this.strbuf = new StringBuffer();
        this.strbuf.append("\n\t").append("private void ").append(SEDU).append("{").append("\n");
        this.strbuf.append("log.begin(\"#2 ").append(this.className).append("\", \"reg dBFields.\")").append(";\n");
        this.strbuf.append(this.DataTypeToClass.toString());
        this.strbuf.append("log.end(\"#2 ").append(this.className).append("\", \"reg dBFields.\")").append(";\n");
        this.strbuf.append("\t}");
        this.DataTypeToClass.setLength(0);
        this.writer.println(this.strbuf.toString());
    }

    private void AggDescName() {
        if (!this.gencode) {
            return;
        }
        this.strbuf = new StringBuffer();
        this.strbuf.append("\n\t").append("private void ").append(TestNull).append("{").append("\n");
        this.strbuf.append("log.begin(\"#3 ").append(this.className).append("\", \"reg formula.\")").append(";\n");
        for (int i = 0; i < this.IsSum.size(); ++i) {
            String string = this.escape2Unicode((String)this.IsSum.elementAt(i));
            this.strbuf.append("\tregisterFormulaName(\"" + string + "\");\n");
        }
        this.strbuf.append("log.end(\"#3 ").append(this.className).append("\", \"reg formula.\")").append(";\n");
        this.strbuf.append("\t}");
        this.writer.println(this.strbuf.toString());
    }

    private void DataTypeToClass(Hashtable hashtable) {
        if (!this.gencode) {
            return;
        }
        this.strbuf = new StringBuffer();
        this.strbuf.append("\n\t").append("private void ").append(TmpName).append("{").append("\n");
        this.strbuf.append("log.begin(\"#4 ").append(this.className).append("\", \"reg global.\")").append(";\n");
        Object var2_2 = null;
        Object var3_3 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            var3_3 = enumeration.nextElement();
            var2_2 = hashtable.get(var3_3);
            if (!(var2_2 instanceof SymbolInfo)) continue;
            SymbolInfo symbolInfo = var2_2;
            int n = symbolInfo.getAttr();
            String string = null;
            if (n != 4) continue;
            string = "\"" + this.RANGETO(symbolInfo) + "\"";
            this.strbuf.append(this.indent()).append("registerGlobalVariable(" + string + "," + symbolInfo.type + "," + symbolInfo.getScope() + ");\n");
        }
        this.strbuf.append("log.end(\"#4 ").append(this.className).append("\", \"reg global.\")").append(";\n");
        this.strbuf.append("\t}");
        this.writer.println(this.strbuf.toString());
    }

    private void DbField() {
        this.strbuf = new StringBuffer();
        this.strbuf.append("\n\t").append("private void ").append(abs).append("{").append("\n");
        this.strbuf.append("log.begin(\"#5 ").append(this.className).append("\", \"init measureEXP.\")").append(";\n");
        String string = "dimensionCollection";
        String string2 = "aggregation";
        String string3 = "usedAggs";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("indent", this.indent());
        hashtable.put("vectorName", string);
        hashtable.put("aggName", string2);
        hashtable.put("aggArray", string3);
        this.strbuf.append("\t\t").append("Vector ").append(string).append(" = null;\n");
        this.strbuf.append("\t\t").append("Aggregation ").append(string2).append(" = null;\n");
        this.strbuf.append("\t\t").append("Aggregation[] ").append(string3).append(" = null;\n");
        for (int i = 0; i < this.measureExpr.size(); ++i) {
            MeasureExpression measureExpression = (MeasureExpression)this.measureExpr.elementAt(i);
            String string4 = "measureExp[" + i + "] = ";
            hashtable.put("meName", string4);
            this.strbuf.append("\n\t\t").append(measureExpression.toJavaCode(hashtable));
        }
        this.strbuf.append("\nlog.end(\"#1 ").append(this.className).append("\", \"init measureEXP.\")").append(";\n");
        this.strbuf.append("\t\t\n}\n");
        this.writer.println(this.strbuf.toString());
    }

    public void declareTempVar(Hashtable hashtable) {
        if (this.gencode) {
            this.ASSIGN();
            this.AggDescName();
            this.DataTypeToClass(hashtable);
            this.IsSum();
            this.DbField();
            this.strbuf = new StringBuffer();
            boolean bl = false;
            this.strbuf.append("\tprivate DbValue[][] ").append("__tmp__ = new DbValue[DataTypeDef.TOTALTYPE][];\n");
            this.strbuf.append("\tprivate MeasureExpression[] measureExp = new MeasureExpression[" + this.measureExpr.size() + "];");
            this.strbuf.append("\n\tpublic ").append(this.className).append("()\n\t{\n");
            this.strbuf.append("log.begin(\"init class ").append(this.className).append("\", \"constructor\")").append(";\n");
            this.strbuf.append("log.begin(\"#1 ").append(this.className).append("\", \"init tmp vars.\")").append(";\n");
            for (int i = 1; i < 33; ++i) {
                if (this.maxtmpcnt[i] <= 0) continue;
                bl = true;
                this.strbuf.append("\t\t").append("__tmp__[").append(i).append("] = new ").append(DataTypeDef.typeClass[i]).append('[').append(this.maxtmpcnt[i]).append("];\n");
                this.strbuf.append("\t\tfor (int i=0; i<").append(this.maxtmpcnt[i]).append("; i++)\n").append("\t\t{\n").append("\t\t\t__tmp__[").append(i).append("][i] = new ").append(DataTypeDef.DataTypeToClass(i).getName()).append("();\n").append("\t\t}\n");
            }
            this.strbuf.append("log.end(\"#1 ").append(this.className).append("\", \"init tmp vars.\")").append(";\n");
            this.strbuf.append("\n\t").append(SEDU).append(";");
            this.strbuf.append("\n\t").append(TestNull).append(";");
            this.strbuf.append("\n\t").append(TmpName).append(";");
            this.strbuf.append("\n\t").append(VarName_value).append(";");
            this.strbuf.append("\n\t").append(abs).append(";");
            this.strbuf.append("log.end(\"init class ").append(this.className).append("\", \"constructor\")").append(";\n");
            this.strbuf.append("log.logSubTime(\"").append(this.className).append("\", \"").append("Init fDbField\");\n");
            this.strbuf.append("log.logSubTime(\"").append(this.className).append("\", \"").append("create GV\");\n");
            this.strbuf.append("log.logSubTime(\"").append(this.className).append("\", \"").append("addGV\");\n");
            this.strbuf.append("\n\t}\n");
            if (!bl) {
                this.strbuf.insert(0, "//");
            }
            this.writer.println(this.strbuf.toString());
        }
    }

    private void IsSum() {
        if (!this.gencode) {
            return;
        }
        this.strbuf = new StringBuffer();
        this.strbuf.append("\n\t").append("private void ").append(VarName_value).append("{").append("\n");
        this.strbuf.append("log.begin(\"#6 ").append(this.className).append("\", \"init aggDesc.\")").append(";\n");
        this.strbuf.append(this.add.toString());
        this.strbuf.append("log.end(\"#6 ").append(this.className).append("\", \"init aggDesc.\")").append(";\n");
        this.strbuf.append("\t}");
        this.add.setLength(0);
        this.writer.println(this.strbuf.toString());
    }

    private String RANGETO(SymbolInfo symbolInfo) {
        return "__g__" + FormulatoJava.regulateName(((GSymbolInfo)symbolInfo).getDeclareFormula()) + '_' + symbolInfo.getSymName();
    }

    public static String createAggDesc(String string, AggDesc aggDesc) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new AggDesc(\"");
        stringBuffer.append(aggDesc.fieldname).append("\", \"").append(aggDesc.qualifiedFieldName()).append("\", \"").append(aggDesc.groupname).append("\", \"").append(aggDesc.qualifiedGroupName()).append("\",").append(aggDesc.aggCode).append(",").append(aggDesc.onFml);
        if (aggDesc.specFunc != null) {
            stringBuffer.append(", \"").append(aggDesc.specFunc).append("\")");
        } else {
            stringBuffer.append(", null)");
        }
        return stringBuffer.toString();
    }

    public void declareAggDesc() {
        if (this.gencode) {
            int n = this.aggdesc.size();
            this.strbuf = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                AggDesc aggDesc = (AggDesc)this.aggdesc.elementAt(i);
                String string = this.AggDescName(i);
                this.strbuf.append('\n').append(this.indent()).append("AggDesc ").append(string).append(" = ");
                this.strbuf.append(FormulatoJava.createAggDesc(this.indent(), aggDesc)).append(";");
                String string2 = "\n" + this.indent() + "usedAggDescs.add(" + string + ");\n";
                this.add.append(string2);
            }
            if (this.strbuf.length() > 0) {
                this.writer.println(this.strbuf.toString());
            }
        }
    }

    public String AggDescName(int n) {
        return "__aggdesc__" + n;
    }

    public void declareVar(Hashtable hashtable) {
        this.strbuf = new StringBuffer();
        Object var2_2 = null;
        Object var3_3 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            var3_3 = enumeration.nextElement();
            var2_2 = hashtable.get(var3_3);
            if (var2_2 instanceof String) {
                object = (String)var2_2 + " " + FormulatoJava.RANGEUPTO(((String)var3_3).substring(1)) + " = " + "(" + "(" + (String)var2_2 + ")" + "loadUDFClass(\"" + (String)var2_2 + "\")" + ");\n";
                this.strbuf.append(this.indent()).append((String)object);
                continue;
            }
            object = var2_2;
            int n = ((SymbolInfo)object).getDataType();
            int n2 = ((SymbolInfo)object).getAttr();
            String string = null;
            String string2 = null;
            switch (n2) {
                case 3: {
                    string = DataTypeDef.typeClass[n];
                    string2 = this.SEDU((SymbolInfo)object);
                    break;
                }
                case 4: {
                    break;
                }
                case 10: {
                    break;
                }
                default: {
                    if (!FormulaHeader.isErrorEnabled()) break;
                    FormulaHeader.error("", new Exception("Unexpected variable type " + n2 + "."));
                }
            }
            if (string == null || string2 == null) continue;
            this.strbuf.append(this.indent()).append(string).append(' ').append(string2);
            this.strbuf.append(" = new ").append(string).append("();\n");
        }
        if (this.strbuf.length() > 0) {
            this.writer.println(this.strbuf.toString().substring(0, this.strbuf.length() - 1));
        }
    }

    public void declareField() {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            Enumeration enumeration = this.DbField.elements();
            while (enumeration.hasMoreElements()) {
                SymbolInfo symbolInfo = (SymbolInfo)enumeration.nextElement();
                int n = symbolInfo.getDataType();
                int n2 = symbolInfo.getAttr();
                String string = null;
                String string2 = null;
                String string3 = null;
                if (n2 != 2 && n2 != 6 && n2 != 9 && n2 != 13) continue;
                string2 = DataTypeDef.typeClass[0];
                string3 = this.FieldName(symbolInfo);
                String string4 = null;
                string4 = this.codes.isFormulaType(1) || this.codes.isFormulaType(3) ? '\"' + this.escape2Unicode(symbolInfo.getExpName()) + "\"" : "null";
                string = '\"' + this.escape2Unicode(symbolInfo.getSymName()) + "\", " + string4 + ", " + symbolInfo.getDataType() + ", this";
                this.strbuf.append(this.indent()).append("private ").append(string2).append(' ').append(string3).append(" = new ").append(string2).append("( ").append(string).append(" );\n");
                this.DataTypeToClass.append("\t\tusedfDbFields.add(").append(string3).append(");\n");
            }
            if (this.strbuf.length() > 0) {
                this.writer.println(this.strbuf.toString());
            }
        }
    }

    private void RANGETO_() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\t").append("public Object clone(){\n").append("\t\tObject ret = new ").append(this.className).append("();").append("\n\t\tcopyRuntimeInfo((JavaFormula)ret);").append("\n\t\treturn ret;").append("}");
        this.writer.println(stringBuffer.toString());
    }

    public void CodeEnd() {
        if (this.gencode) {
            this.RANGETO_();
            this.writer.println("}");
            this.writer.close();
        }
    }

    public void FormulaHeader() {
        this.strbuf = new StringBuffer();
        this.strbuf.append(this.indent()).append("public DbValue ").append(this.formulaname.toUpperCase()).append("()\n");
        this.strbuf.append(this.indent()).append("{");
        ++this.tab;
        this.writer.println(this.strbuf.toString());
    }

    private void RANGEUPFROM(Hashtable hashtable) {
        this.strbuf = new StringBuffer();
        SymbolInfo symbolInfo = null;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            symbolInfo = (SymbolInfo)enumeration.nextElement();
            if (symbolInfo.getGhost() <= 0) continue;
            this.DbField.put(symbolInfo.getSymName(), symbolInfo);
            if (symbolInfo.getAttr() == 7) {
                this.strbuf.append(this.indent()).append(this.TmpName(symbolInfo)).append(".setfoo((DbValue)params.get(\"").append(symbolInfo.getSymName()).append("\"));\n");
                continue;
            }
            this.strbuf.append(this.indent()).append(this.TmpName(symbolInfo)).append(".setfoo(").append(this.FieldName(symbolInfo)).append(".getDBField(rec));\n");
        }
        if (this.strbuf.length() > 0) {
            this.writer.println(this.strbuf.toString());
        }
    }

    public void initGlobal(Vector vector) {
        this.strbuf = new StringBuffer();
        int n = vector.size();
        if (n > 0) {
            ++this.tab;
            for (int i = 0; i < n; ++i) {
                this.strbuf.append(this.indent()).append(vector.elementAt(i));
            }
            --this.tab;
        }
        if (this.strbuf.length() > 0) {
            this.writer.println(this.strbuf.toString());
        }
    }

    private void RANGEUPFROM_(Vector vector) {
        this.strbuf = new StringBuffer();
        int n = vector.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.strbuf.append(vector.elementAt(i));
            }
            --this.tab;
            this.strbuf.append(this.indent()).append("}\n");
        }
        this.writer.println(this.strbuf.toString());
    }

    private static String RANGEUPTO(String string) {
        return "__import__" + string;
    }

    private final String RANGEUPTO_(SymbolInfo symbolInfo) {
        int n = symbolInfo.getAttr();
        switch (n) {
            case 5: {
                return symbolInfo.getValue();
            }
            case 1: {
                if (symbolInfo.getDataType() == 5) {
                    String string = '\"' + FormulatoJava.RANGE_TO(symbolInfo.getSymName()) + '\"';
                    char[] cArray = string.toCharArray();
                    return "transfer(" + this.escape2Unicode(string) + ")";
                }
                return symbolInfo.getSymName();
            }
        }
        return this.VarName_value(symbolInfo);
    }

    private static final String RANGE_TO(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\").append("n");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("\\").append("r");
                    continue block6;
                }
                case '\\': {
                    stringBuffer.append("\\").append("\\");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("\\").append('\"');
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private final String RANGE_TO_(SymbolInfo symbolInfo) {
        int n = symbolInfo.getAttr();
        int n2 = symbolInfo.getDataType();
        switch (n) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.TmpName(symbolInfo);
            }
            case 4: {
                String string = this.RANGETO(symbolInfo);
                return "((" + DataTypeDef.typeClass[n2] + ')' + "getScope(" + symbolInfo.getScope() + ")" + ".getGlobalVariable(\"" + string + "\"))";
            }
            case 3: {
                return this.formulaname + '_' + symbolInfo.getSymName();
            }
            case 10: {
                return "__sys__" + symbolInfo.getSymName() + "()";
            }
        }
        throw new Error(this.formulaname);
    }

    private final String SEDU(SymbolInfo symbolInfo) {
        int n = symbolInfo.getAttr();
        int n2 = symbolInfo.getDataType();
        switch (n) {
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                return "((" + DataTypeDef.typeClass[n2] + ')' + this.TmpName(symbolInfo) + ')';
            }
            case 4: {
                String string = this.RANGETO(symbolInfo);
                return "((" + DataTypeDef.typeClass[n2] + ')' + "getScope(" + symbolInfo.getScope() + ")" + ".getGlobalVariable(\"" + string + "\"))";
            }
            case 3: {
                return this.formulaname + '_' + symbolInfo.getSymName();
            }
            case 10: {
                return "__sys__" + symbolInfo.getSymName() + "()";
            }
            case 11: {
                return symbolInfo.getSymName();
            }
        }
        throw new Error(this.formulaname);
    }

    final String VarName_value(SymbolInfo symbolInfo) {
        switch (symbolInfo.getDataType()) {
            case 6: {
                return this.SEDU(symbolInfo) + ".getDate()";
            }
            case 7: {
                return this.SEDU(symbolInfo) + ".getTime()";
            }
            case 8: {
                return this.SEDU(symbolInfo) + ".getTimestamp()";
            }
        }
        return this.SEDU(symbolInfo) + ".value";
    }

    private final String TestNull(SymbolInfo symbolInfo) {
        return this.SEDU(symbolInfo) + ".bNull";
    }

    private final String FieldName(SymbolInfo symbolInfo) {
        return "__fld__" + FormulatoJava.regulateName(symbolInfo.getSymName());
    }

    final String TmpName(SymbolInfo symbolInfo) {
        return "__tmp__[" + symbolInfo.getDataType() + "][" + symbolInfo.getHost() + ']';
    }

    final String BooleanAssertion(SymbolInfo symbolInfo) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append('!').append(this.TestNull(symbolInfo)).append(" && ").append(this.VarName_value(symbolInfo));
            return this.strbuf.toString();
        }
        return null;
    }

    final String buildStmts(Stack stack, SymbolInfo symbolInfo) {
        this.strbuf = new StringBuffer();
        if (stack.empty()) {
            this.strbuf.append(this.indent()).append(symbolInfo.getValue()).append(";\n");
        } else {
            try {
                this.strbuf.append(this.indent()).append("if (");
                while (true) {
                    SymbolInfo symbolInfo2 = (SymbolInfo)stack.pop();
                    this.strbuf.append(this.TestNull(symbolInfo2)).append(" || ");
                }
            }
            catch (EmptyStackException emptyStackException) {
                this.strbuf.append("false)\n");
                this.strbuf.append(this.indent()).append("{\n");
                ++this.tab;
                this.strbuf.append(this.indent()).append(this.TestNull(symbolInfo)).append(" = true;\n");
                --this.tab;
                this.strbuf.append(this.indent()).append("}\n");
                this.strbuf.append(this.indent()).append("else\n");
                this.strbuf.append(this.indent()).append("{\n");
                ++this.tab;
                this.strbuf.append(this.indent()).append(symbolInfo.getValue()).append(";\n");
                --this.tab;
                this.strbuf.append(this.indent()).append("}\n");
            }
        }
        return this.strbuf.toString();
    }

    final void buildStmts(Stack stack, SymbolInfo symbolInfo, Vector vector) {
        block9: {
            if (this.gencode && symbolInfo != null) {
                try {
                    String string = null;
                    boolean bl = false;
                    if (symbolInfo.attr == 4 && !symbolInfo.isInitiated()) {
                        bl = true;
                    }
                    if (bl) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(this.indent()).append("if (!").append("getScope(").append(symbolInfo.getScope()).append(").isGlobalVarInitiated(").append("\"").append(this.RANGETO(symbolInfo)).append("\"").append("))\n");
                        stringBuffer.append(this.indent()).append("{\n");
                        if (this.addElement < vector.size()) {
                            int n;
                            for (n = this.addElement; n < vector.size(); ++n) {
                                stringBuffer.append(this.indent()).append((String)vector.elementAt(n));
                            }
                            for (n = vector.size() - 1; n >= this.addElement; --n) {
                                vector.remove(n);
                            }
                        }
                        ++this.tab;
                        string = this.buildStmts(stack, symbolInfo);
                        stringBuffer.append(this.indent()).append(string);
                        stringBuffer.append(this.indent()).append("getScope(").append(symbolInfo.getScope()).append(").setGlobalVarInitiated(").append("\"").append(this.RANGETO(symbolInfo)).append("\"").append(",").append("true").append(");\n");
                        --this.tab;
                        stringBuffer.append(this.indent()).append("}\n");
                        vector.addElement(stringBuffer.toString());
                        this.addElement = vector.size();
                    } else {
                        string = this.buildStmts(stack, symbolInfo);
                        vector.addElement(string);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (!FormulaHeader.isDebugEnabled()) break block9;
                    FormulaHeader.debug(nullPointerException.getMessage(), nullPointerException);
                }
            }
        }
    }

    public void closeThenStmts(Vector vector) {
        if (this.gencode) {
            StringBuffer stringBuffer = new StringBuffer();
            --this.tab;
            stringBuffer.append(this.indent()).append("}\n").append(this.indent()).append("else\n").append(this.indent()).append("{\n");
            ++this.tab;
            vector.addElement(stringBuffer.toString());
        }
    }

    public void beginIfStmt(SymbolInfo symbolInfo, Vector vector) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.indent()).append("if ( !").append(this.TestNull(symbolInfo)).append(" && ").append(this.VarName_value(symbolInfo)).append(" )\n").append(this.indent()).append("{\n");
            ++this.tab;
            vector.addElement(this.strbuf.toString());
        }
    }

    public void closeElseStmts(Vector vector) {
        if (this.gencode) {
            --this.tab;
            vector.addElement(this.indent() + "}\n");
        }
    }

    public void insertIfElseResult(SymbolInfo symbolInfo, SymbolInfo symbolInfo2, Vector vector, int n) {
        if (this.gencode) {
            ++this.tab;
            if (symbolInfo2 == null) {
                vector.insertElementAt(this.indent() + this.TestNull(symbolInfo) + " = true;\n", n);
            } else {
                vector.insertElementAt(this.indent() + this.RANGE_TO_(symbolInfo) + ".set(" + this.SEDU(symbolInfo2) + ");\n", n);
            }
            --this.tab;
        }
    }

    public int getLoopCount() {
        return this.aggCode;
    }

    public void setLoopCount(int n) {
        this.aggCode = n;
    }

    public int getTab() {
        return this.tab;
    }

    public void setTab(int n) {
        this.tab = n;
    }

    void beginForLoopStmt(Vector vector, String string, Vector vector2, Vector vector3) {
        if (this.gencode) {
            int n;
            this.strbuf = new StringBuffer();
            ++this.aggCode;
            this.append[this.aggCode] = false;
            for (n = 0; n < vector.size(); ++n) {
                this.strbuf.append((String)vector.elementAt(n));
            }
            this.strbuf.append(this.indent()).append("DbBit " + this.VarName_value() + " = new DbBit(true);\n");
            this.strbuf.append(this.indent()).append("DbBit " + this.abs() + " = new DbBit(false);\n");
            this.strbuf.append(this.indent()).append("DbBit " + this.add() + " = new DbBit(false);\n");
            this.strbuf.append(this.indent()).append("for (; !(!" + this.abs() + ".bNull && " + this.abs() + ".value); )\n");
            this.strbuf.append(this.indent()).append("{\n");
            ++this.tab;
            this.strbuf.append(this.indent()).append(this.add() + ".set(false);\n");
            this.strbuf.append(this.indent()).append("if (!" + this.VarName_value() + ".bNull && " + this.VarName_value() + ".value)\n");
            this.strbuf.append(this.indent()).append("{\n");
            ++this.tab;
            this.strbuf.append(this.indent()).append(this.VarName_value() + ".set(false);\n");
            --this.tab;
            this.strbuf.append(this.indent()).append("}\n");
            this.strbuf.append(this.indent()).append("else\n");
            this.strbuf.append(this.indent()).append("{\n");
            ++this.tab;
            for (n = 0; n < vector2.size(); ++n) {
                this.strbuf.append(this.TmpName((String)vector2.elementAt(n), 2));
            }
            for (n = 0; n < vector.size(); ++n) {
                this.strbuf.append(this.TmpName((String)vector.elementAt(n), 2));
            }
            --this.tab;
            this.strbuf.append(this.indent()).append("}\n");
            if (string != null) {
                this.append[this.aggCode] = true;
                this.strbuf.append(this.indent()).append("if (!(").append(string).append("))\n");
                this.strbuf.append(this.indent()).append("{\n");
                ++this.tab;
                this.strbuf.append(this.indent()).append(this.abs() + ".set(true);\n");
                --this.tab;
                this.strbuf.append(this.indent()).append("}\n");
                this.strbuf.append(this.indent()).append("else\n");
                this.strbuf.append(this.indent()).append("{\n");
                ++this.tab;
            }
            vector3.addElement(this.strbuf.toString());
        }
    }

    void endForLoopStmt(Vector vector) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            --this.tab;
            if (this.append[this.aggCode]) {
                this.strbuf.append(this.indent()).append("}\n");
                --this.tab;
            }
            this.strbuf.append(this.indent()).append("}\n");
            vector.addElement(this.strbuf.toString());
            --this.aggCode;
        }
    }

    private String indent() {
        if (this.tab < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.tab; ++i) {
            stringBuffer.append('\t');
        }
        return stringBuffer.toString();
    }

    private static String indent(int n) {
        if (n < 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append('\t');
        }
        return stringBuffer.toString();
    }

    private String TmpName(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n >= 0) {
                stringBuffer.append(FormulatoJava.indent(n)).append(string2).append('\n');
                continue;
            }
            if (string2.indexOf(FormulatoJava.indent(-n)) != 0) continue;
            stringBuffer.append(string2.substring(-n)).append('\n');
        }
        return stringBuffer.toString();
    }

    private String VarName_value() {
        return attr + this.aggCode;
    }

    private String abs() {
        return buildStmts + this.aggCode;
    }

    private String add() {
        return callee + this.aggCode;
    }

    public void schedule(Vector vector) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.indent()).append("public synchronized DbValue schedule(int fmlidx)\n").append(this.indent()).append("{\n");
            ++this.tab;
            this.strbuf.append(this.indent()).append("switch(fmlidx)\n");
            this.strbuf.append(this.indent()).append("{\n");
            int n = vector.size();
            JetRptFormula jetRptFormula = null;
            for (int i = 0; i < n; ++i) {
                jetRptFormula = vector instanceof HashVector ? (JetRptFormula)((HashVector)vector).get(vector.elementAt(i)) : (JetRptFormula)vector.elementAt(i);
                if (jetRptFormula instanceof JetRptSummary || !jetRptFormula.isparsedOK()) continue;
                this.strbuf.append(this.indent()).append("case ").append(i).append(":\n");
                ++this.tab;
                jetRptFormula.formulainfo.callee = i;
                this.strbuf.append(this.indent()).append("return ").append(FormulatoJava.regulateName(jetRptFormula.getName().toUpperCase()).toUpperCase()).append("();\n");
                --this.tab;
            }
            this.strbuf.append(this.indent()).append("default :\n");
            ++this.tab;
            this.strbuf.append(this.indent()).append("throw new Error(\"unknown formula\");\n");
            --this.tab;
            this.strbuf.append(this.indent()).append("}\n");
            --this.tab;
            this.strbuf.append(this.indent()).append("}");
            this.writer.println(this.strbuf.toString());
        }
    }

    public String regulateName_old(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }

    public static String regulateName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                stringBuffer.replace(0, stringBuffer.length(), "A" + Math.abs(string.hashCode()));
                break;
            }
            if (Character.isJavaIdentifierPart(c) && Character.isJavaIdentifierStart(c)) continue;
            char c2 = c;
            String string2 = String.valueOf((int)c2);
            stringBuffer.setCharAt(i + n, '_');
            stringBuffer.insert(i + 1 + n, string2);
            n += string2.length();
        }
        return stringBuffer.toString();
    }

    void generateCode(Vector vector, Vector vector2, VarRegisterTable varRegisterTable, String string) {
        if (this.gencode) {
            if (this.writer == null) {
                return;
            }
            try {
                byte[] byArray = string.getBytes("utf8");
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                String string2 = "";
                String string3 = "";
                while ((string3 = dataInputStream.readLine()) != null) {
                    string2 = string2 + "//\t" + string3 + "\n";
                }
                this.writer.println(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tab = 1;
            this.FormulaHeader();
            this.declareVar(varRegisterTable.ltab);
            this.RANGEUPFROM(varRegisterTable.metfld);
            this.initGlobal(vector);
            this.RANGEUPFROM_(vector2);
        }
    }

    SymbolInfo ADD(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " + " + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo2) + ".add(new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + "))");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".add(new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "))");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".add(" + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 8: {
                        n2 = 5;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 10: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " + " + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("DateAddNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("TimeAddNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("TimestampAddNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 8: {
                        n2 = 5;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 10: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " + " + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_1", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    SymbolInfo SUBTRACT(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " - " + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + ").subtract(" + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".subtract(new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "))");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".subtract(" + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("DateSubNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    case 6: {
                        if (this.gencode) {
                            symbolInfo.setValue("DateSubDate(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        }
                        n2 = 1;
                        n = 1;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("TimeSubNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    case 7: {
                        if (this.gencode) {
                            symbolInfo.setValue("TimeSubTime(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        }
                        n2 = 1;
                        n = 1;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("TimestampSubNum(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    case 8: {
                        if (this.gencode) {
                            symbolInfo.setValue("TimestampSubTimestamp(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                        }
                        n2 = 1;
                        n = 1;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_2", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    SymbolInfo MUL(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " * " + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo2) + ".multiply(new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + "))");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".multiply(new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "))");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".multiply(" + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_3", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    SymbolInfo DIV(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (this.gencode) {
                            symbolInfo.setValue("((double)" + this.RANGEUPTO_(symbolInfo) + ") / ((double)" + this.RANGEUPTO_(symbolInfo2) + ")");
                        }
                        n2 = 2;
                        n = 2;
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + ").divide(" + this.RANGEUPTO_(symbolInfo2) + ",20, BigDecimal.ROUND_HALF_DOWN)");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".divide(new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "),20, BigDecimal.ROUND_HALF_DOWN)");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".divide(" + this.RANGEUPTO_(symbolInfo2) + ",20,BigDecimal.ROUND_HALF_DOWN)");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_4", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    SymbolInfo PERCENT(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("((double)" + this.RANGEUPTO_(symbolInfo) + ") / ((double)" + this.RANGEUPTO_(symbolInfo2) + ") * 100");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + " / " + this.RANGEUPTO_(symbolInfo2) + ".doubleValue() * 100");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".doubleValue() / " + this.RANGEUPTO_(symbolInfo2) + " * 100");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".doubleValue() / " + this.RANGEUPTO_(symbolInfo2) + ".doubleValue() * 100");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_5", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        n2 = 2;
        n = 2;
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    SymbolInfo COMPARETO(SymbolInfo symbolInfo, int n, SymbolInfo symbolInfo2, SymbolInfo symbolInfo3) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n2 = symbolInfo.getDataType();
        int n3 = symbolInfo2.getDataType();
        boolean bl = false;
        block0 : switch (n2) {
            case 1: 
            case 2: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + charAt[n] + this.RANGEUPTO_(symbolInfo2));
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue("new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + ").compareTo(" + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + ".compareTo(new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "))" + charAt[n] + "0");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + ".compareTo(" + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 4: {
                if (n3 == 4 && (n == 2 || n == 3)) {
                    if (!this.gencode) break;
                    symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + charAt[n] + this.RANGEUPTO_(symbolInfo2));
                    break;
                }
                bl = true;
                break;
            }
            case 5: {
                switch (n3) {
                    case 5: 
                    case 10: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + ".compareTo(" + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (n3) {
                    case 6: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue("DateCompareToDate(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 7: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue("TimeCompareToTime(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 8: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue("TimestampCompareToTimestamp(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 5: 
                    case 10: {
                        if (!this.gencode) break block0;
                        symbolInfo3.setValue(this.RANGEUPTO_(symbolInfo) + ".compareTo(" + this.RANGEUPTO_(symbolInfo2) + ")" + charAt[n] + "0");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_6", new Object[]{charAt[n], DataTypeDef.toString(n2), DataTypeDef.toString(n3)});
        }
        symbolInfo3.setDataType(4);
        symbolInfo3.setAttr(5);
        symbolInfo3.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo3;
    }

    SymbolInfo truthTable(SymbolInfo symbolInfo, int n, SymbolInfo symbolInfo2, SymbolInfo symbolInfo3) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null && n != 2) {
            return null;
        }
        if (symbolInfo.getDataType() == 4) {
            if (n == 2) {
                if (this.gencode) {
                    String string = "";
                    string = symbolInfo.attr == 1 ? "new DbBit(" + symbolInfo.getSymName() + ")" : this.SEDU(symbolInfo);
                    symbolInfo3.setValue("calTruthTable(" + string + ", null, " + n + ")");
                }
                symbolInfo3.setDataType(4);
                symbolInfo3.setAttr(5);
                return symbolInfo3;
            }
            if (symbolInfo2.getDataType() == 4) {
                if (this.gencode) {
                    String string = "";
                    String string2 = "";
                    string = symbolInfo.attr == 1 ? "new DbBit(" + symbolInfo.getSymName() + ")" : this.SEDU(symbolInfo);
                    string2 = symbolInfo2.attr == 1 ? "new DbBit(" + symbolInfo2.getSymName() + ")" : this.SEDU(symbolInfo2);
                    symbolInfo3.setValue("calTruthTable(" + string + ", " + string2 + ", " + n + ")");
                }
                symbolInfo3.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
                symbolInfo3.setDataType(4);
                symbolInfo3.setAttr(5);
                return symbolInfo3;
            }
        }
        switch (n) {
            case 0: {
                throw new FormulaError("FML_7", new Object[]{DataTypeDef.toString(symbolInfo.getDataType()), DataTypeDef.toString(symbolInfo2.getDataType())});
            }
            case 1: {
                throw new FormulaError("FML_8", new Object[]{DataTypeDef.toString(symbolInfo.getDataType()), DataTypeDef.toString(symbolInfo2.getDataType())});
            }
        }
        throw new FormulaError("FML_9", new Object[]{DataTypeDef.toString(symbolInfo.getDataType())});
    }

    SymbolInfo TYPECAST(SymbolInfo symbolInfo, int n) throws Exception {
        if (symbolInfo == null) {
            return null;
        }
        int n2 = symbolInfo.getDataType();
        boolean bl = false;
        block0 : switch (n) {
            case 1: {
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("(long)(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".longValue())");
                        break;
                    }
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("Long.valueOf(" + this.RANGEUPTO_(symbolInfo) + ").longValue()");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("(double)(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".doubleValue()");
                        break;
                    }
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("Double.valueOf(" + this.RANGEUPTO_(symbolInfo) + ").doubleValue()");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("(new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + "))");
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("(new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + "))");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("\"\"+(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("java.sql.Date.valueOf(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    case 6: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo));
                        break;
                    }
                    case 8: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("new java.sql.Date(" + this.RANGEUPTO_(symbolInfo) + ".getTime())");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (n2) {
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("java.sql.Time.valueOf(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    case 7: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo));
                        break;
                    }
                    case 8: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("new java.sql.Time(" + this.RANGEUPTO_(symbolInfo) + ".getTime())");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (n2) {
                    case 5: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("java.sql.Timestamp.valueOf(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    case 8: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo));
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        if (!this.gencode) break block0;
                        symbolInfo.setValue("\"\"+(" + this.RANGEUPTO_(symbolInfo) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_10", new Object[]{DataTypeDef.toString(symbolInfo.getDataType()), DataTypeDef.toString(n)});
        }
        symbolInfo.setDataType(n);
        symbolInfo.setAttr(5);
        return symbolInfo;
    }

    SymbolInfo NEGATE(SymbolInfo symbolInfo, int n) throws Exception {
        if (symbolInfo == null) {
            return null;
        }
        switch (symbolInfo.getDataType()) {
            case 1: 
            case 2: {
                if (this.gencode) {
                    if (n == 0) {
                        symbolInfo.setValue(" -(" + this.RANGEUPTO_(symbolInfo) + ")");
                    } else if (symbolInfo.attr == 1) {
                        symbolInfo.setValue(this.RANGEUPTO_(symbolInfo));
                    }
                }
                if (symbolInfo.getDataType() != 1 || symbolInfo.attr != 1 || n != 0) break;
                String string = symbolInfo.getSymName();
                try {
                    int n2 = Integer.parseInt(string);
                    symbolInfo.setSymName(String.valueOf(0 - n2));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 3: {
                if (!this.gencode) break;
                if (n == 0) {
                    symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + ".negate()");
                    break;
                }
                if (symbolInfo.attr != 1) break;
                symbolInfo.setValue(this.RANGEUPTO_(symbolInfo));
                break;
            }
            default: {
                throw new FormulaError("FML_11", new Object[]{this.unarystr[n], DataTypeDef.toString(symbolInfo.getDataType())});
            }
        }
        symbolInfo.setAttr(5);
        return symbolInfo;
    }

    SymbolInfo ASSIGN(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getAttr();
        if (n != 3 && n != 4 && n != 8) {
            throw new FormulaError("FML_39", null);
        }
        int n2 = symbolInfo.getDataType();
        int n3 = symbolInfo2.getDataType();
        boolean bl = false;
        String[] stringArray = new String[]{".set(", ".setDate(", ".setTime(", ".setTimestamp(", " = "};
        int n4 = 0;
        switch (n2) {
            case 6: {
                n4 = 1;
                break;
            }
            case 7: {
                n4 = 2;
                break;
            }
            case 8: {
                n4 = 3;
                break;
            }
            case 32: {
                n4 = 4;
                break;
            }
            default: {
                n4 = 0;
            }
        }
        block6 : switch (n2) {
            case 2: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block6;
                        symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block6;
                        symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + "new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + "))");
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block6;
                        symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + this.RANGEUPTO_(symbolInfo2) + ")");
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                if (n2 == n3) {
                    if (!this.gencode) break;
                    int n5 = symbolInfo2.getAttr();
                    if (DataTypeDef.isArray(n2) && (n5 == 7 || n5 == 6)) {
                        symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + this.SEDU(symbolInfo2) + ")");
                        break;
                    }
                    if (n2 == 32) {
                        symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + this.SEDU(symbolInfo2));
                        break;
                    }
                    symbolInfo.setValue(this.SEDU(symbolInfo) + stringArray[n4] + this.RANGEUPTO_(symbolInfo2) + ")");
                    break;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(n3), DataTypeDef.toString(n2)});
        }
        symbolInfo.setSum(symbolInfo2.IsSum());
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    SymbolInfo ArrayElement(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        if (symbolInfo2.getDataType() != 1) {
            throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(symbolInfo2.getDataType()), DataTypeDef.toString(1)});
        }
        int n = symbolInfo.getDataType();
        if (n != 5) {
            if (DataTypeDef.isArray(n)) {
                if (this.gencode) {
                    symbolInfo.setValue(this.RANGEUPTO_(symbolInfo) + "[(int)" + this.RANGEUPTO_(symbolInfo2) + "]");
                }
                symbolInfo.name = symbolInfo.expr;
                symbolInfo.setDataType(n - 11);
                symbolInfo.setAttr(11);
            } else {
                throw new FormulaError("FML_13", new Object[]{DataTypeDef.toString(n)});
            }
        }
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SymbolInfo INDEXOF(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        if (symbolInfo2.getDataType() != 1) throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(symbolInfo2.getDataType()), DataTypeDef.toString(1)});
        int n = symbolInfo.getDataType();
        if (n == 5) {
            if (this.gencode) {
                symbolInfo.setValue("(" + this.RANGEUPTO_(symbolInfo) + ").substring((int)(" + this.RANGEUPTO_(symbolInfo2) + "), (int)(" + this.RANGEUPTO_(symbolInfo2) + "+1))");
            }
        } else {
            if (!DataTypeDef.isArray(n)) throw new FormulaError("FML_13", new Object[]{DataTypeDef.toString(n)});
            if (this.gencode) {
                switch (n - 11) {
                    case 6: {
                        symbolInfo.setValue("((" + DataTypeDef.typeClass[n - 11] + ")" + this.RANGEUPTO_(symbolInfo) + "[(int)" + this.RANGEUPTO_(symbolInfo2) + "]).getDate()");
                        break;
                    }
                    case 7: {
                        symbolInfo.setValue("((" + DataTypeDef.typeClass[n - 11] + ")" + this.RANGEUPTO_(symbolInfo) + "[(int)" + this.RANGEUPTO_(symbolInfo2) + "]).getTime()");
                        break;
                    }
                    case 8: {
                        symbolInfo.setValue("((" + DataTypeDef.typeClass[n - 11] + ")" + this.RANGEUPTO_(symbolInfo) + "[(int)" + this.RANGEUPTO_(symbolInfo2) + "]).getTimestamp()");
                        break;
                    }
                    default: {
                        symbolInfo.setValue("((" + DataTypeDef.typeClass[n - 11] + ")" + this.RANGEUPTO_(symbolInfo) + "[(int)" + this.RANGEUPTO_(symbolInfo2) + "]).value");
                    }
                }
            }
            symbolInfo.setDataType(n - 11);
        }
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        symbolInfo.setAttr(5);
        return symbolInfo;
    }

    SymbolInfo IN(SymbolInfo symbolInfo, SymbolInfo symbolInfo2, SymbolInfo symbolInfo3) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        boolean bl = false;
        if (n2 == 5) {
            if (n == n2) {
                if (this.gencode) {
                    symbolInfo3.setValue("((" + this.RANGEUPTO_(symbolInfo2) + ").indexOf(" + this.RANGEUPTO_(symbolInfo) + ") != -1)");
                }
            } else {
                bl = true;
            }
        } else if (DataTypeDef.isArray(n2)) {
            if (n == n2 - 11) {
                if (this.gencode) {
                    String string = this.SEDU(symbolInfo2) + ".isAll() ? true : " + "inary(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")";
                    symbolInfo3.setValue(string);
                }
            } else {
                bl = true;
            }
        } else if (DataTypeDef.isRange(n2)) {
            if (n == n2 - 22) {
                if (this.gencode) {
                    symbolInfo3.setValue("inrng(" + this.RANGEUPTO_(symbolInfo) + ", " + this.RANGEUPTO_(symbolInfo2) + ")");
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            throw new FormulaError("FML_16", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo3.setDataType(4);
        symbolInfo3.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        symbolInfo3.setAttr(5);
        return symbolInfo3;
    }

    SymbolInfo ARRAYRANGE(SymbolInfo symbolInfo, Vector vector) throws Exception {
        int n = vector.size();
        SymbolInfo symbolInfo2 = (SymbolInfo)vector.firstElement();
        int n2 = symbolInfo2.getDataType();
        String string = DataTypeDef.typeClass[n2];
        boolean bl = symbolInfo2.IsSum();
        if (DataTypeDef.isBasic(n2)) {
            if (this.gencode) {
                this.strbuf = new StringBuffer();
                this.strbuf.append(this.SEDU(symbolInfo)).append(".set(new DbValue[").append(n).append("]);\n");
            }
            for (int i = 0; i < n; ++i) {
                symbolInfo2 = (SymbolInfo)vector.elementAt(i);
                if (symbolInfo2 == null) {
                    return null;
                }
                if (n2 == symbolInfo2.getDataType()) {
                    boolean bl2 = bl = bl && symbolInfo2.IsSum();
                    if (!this.gencode) continue;
                    this.strbuf.append(this.VarName_value(symbolInfo)).append("[").append(i).append("] = ");
                    int n3 = symbolInfo2.getAttr();
                    if (n3 == 4 || n3 == 8 || n3 == 3 || n3 == 10) {
                        this.strbuf.append(this.SEDU(symbolInfo2));
                    } else {
                        this.strbuf.append("new ").append(string).append("(").append(this.RANGEUPTO_(symbolInfo2)).append(")");
                    }
                    this.strbuf.append(";\n");
                    continue;
                }
                throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(symbolInfo2.getDataType()), DataTypeDef.toString(n2)});
            }
            if (this.gencode) {
                symbolInfo.setValue(this.strbuf.toString());
            }
            symbolInfo.setSum(bl);
            symbolInfo.setGhost(-100);
            return symbolInfo;
        }
        throw new FormulaError("FML_18", new Object[]{DataTypeDef.toString(n2)});
    }

    SymbolInfo PARENTHESES(SymbolInfo symbolInfo) {
        if (symbolInfo == null) {
            return null;
        }
        if (this.gencode) {
            symbolInfo.setValue("(" + symbolInfo.getValue() + ")");
        }
        return symbolInfo;
    }

    SymbolInfo CONSTANT(long l) {
        return new SymbolInfo(String.valueOf(l), null, 1, -1, 1, -1, true);
    }

    SymbolInfo CONSTANT(double d) {
        return new SymbolInfo(String.valueOf(d), null, 2, -1, 1, -1, true);
    }

    SymbolInfo CONSTANT(String string) {
        return new SymbolInfo(string, null, 5, -1, 1, -1, true);
    }

    SymbolInfo CONSTANT(boolean bl) {
        return new SymbolInfo(String.valueOf(bl), null, 4, -1, 1, -1, true);
    }

    SymbolInfo FUNCTION(SymbolInfo symbolInfo, String string, SymbolInfo[] symbolInfoArray, String string2) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            string2 = string2.equals("") ? close : FormulatoJava.RANGEUPTO(string2);
            this.strbuf.append(this.TmpName(symbolInfo)).append(".set(").append(string2).append(".");
            if (string2.equalsIgnoreCase(close) && string.equalsIgnoreCase("Translate") && symbolInfoArray.length == 1) {
                String string3 = symbolInfoArray[0].getSymName();
                if (this.codes.isFormulaType(1) || this.codes.isFormulaType(3)) {
                    string3 = symbolInfoArray[0].getExpName();
                }
                if (symbolInfoArray[0].attr == 2) {
                    this.strbuf.append("TranslateByFieldName").append('(');
                    this.strbuf.append(this.SEDU(symbolInfoArray[0]));
                    this.strbuf.append(", \"");
                    this.strbuf.append(string3);
                    this.strbuf.append("\"");
                } else if (symbolInfoArray[0].attr == 7) {
                    this.strbuf.append("TranslateByParamName").append('(');
                    this.strbuf.append(this.SEDU(symbolInfoArray[0]));
                    this.strbuf.append(", \"");
                    this.strbuf.append(string3);
                    this.strbuf.append("\"");
                } else {
                    this.strbuf.append(string).append('(');
                    this.strbuf.append(this.SEDU(symbolInfoArray[0]));
                }
            } else {
                this.strbuf.append(string).append('(');
                for (int i = 0; i < symbolInfoArray.length; ++i) {
                    this.strbuf.append(this.SEDU(symbolInfoArray[i]));
                    if (i >= symbolInfoArray.length - 1) continue;
                    this.strbuf.append(", ");
                }
            }
            this.strbuf.append("))");
            symbolInfo.setValue(this.strbuf.toString());
        }
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    SymbolInfo GROUPFUNC(SymbolInfo symbolInfo, int n, SymbolInfo[] symbolInfoArray) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.TmpName(symbolInfo)).append(".set(getAggValue(").append(this.AggDescName(n)).append("))");
            symbolInfo.setValue(this.strbuf.toString());
        }
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    SymbolInfo RETURN(SymbolInfo symbolInfo) {
        if (symbolInfo == null) {
            return null;
        }
        if (this.gencode) {
            symbolInfo.setValue("return " + this.SEDU(symbolInfo));
        }
        symbolInfo.setGhost(-101);
        return symbolInfo;
    }

    SymbolInfo IFCOND(SymbolInfo symbolInfo) throws Exception {
        if (symbolInfo == null) {
            return null;
        }
        if (symbolInfo.getDataType() != 4) {
            throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(symbolInfo.getDataType()), DataTypeDef.toString(4)});
        }
        return symbolInfo;
    }

    public void resolveExp(SymbolInfo symbolInfo, Vector vector) {
        switch (symbolInfo.expType) {
            case 1: {
                switch (symbolInfo.op) {
                    case 0: 
                    case 1: {
                        this.resolveExp(symbolInfo.leftExp, vector);
                        this.resolveExp(symbolInfo.rightExp, vector);
                        break;
                    }
                    case 2: {
                        this.resolveExp(symbolInfo.leftExp, vector);
                    }
                }
                this.buildStmts(new Stack(), symbolInfo, vector);
                break;
            }
            case 2: {
                switch (symbolInfo.op) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.buildStmts(symbolInfo.TestNull, symbolInfo, vector);
                    }
                }
            }
        }
    }

    public void beginWhileLoopStatement(SymbolInfo symbolInfo, Vector vector) {
        if (this.gencode) {
            String string = "";
            int n = symbolInfo.getAttr();
            string = n == 1 ? symbolInfo.getSymName() : (n == 5 ? symbolInfo.getValue() : "!" + this.TestNull(symbolInfo) + " && " + this.VarName_value(symbolInfo));
            this.strbuf = new StringBuffer();
            this.strbuf.append("/* Begin of while-do-loop */ \n").append("while ( ").append(string).append(") \n { \n");
            vector.addElement(this.strbuf.toString());
        }
    }

    public void endWhileLoopStatement(Stack stack, SymbolInfo symbolInfo, Vector vector) {
        if (this.gencode) {
            stack.removeAllElements();
            this.resolveExp(symbolInfo, vector);
            vector.addElement("} \n");
            vector.addElement("/* End of while-do-loop */\n");
        }
    }

    public void beginLoopWhileStatement(Vector vector) {
        if (this.gencode) {
            vector.addElement("do {\n");
        }
    }

    public void endLoopWhileStatement(SymbolInfo symbolInfo, Vector vector) {
        if (this.gencode) {
            String string = "";
            int n = symbolInfo.getAttr();
            string = n == 1 ? symbolInfo.getSymName() : (n == 5 ? symbolInfo.getValue() : "!" + this.TestNull(symbolInfo) + " && " + this.VarName_value(symbolInfo));
            this.strbuf = new StringBuffer();
            this.strbuf.append("} \n ").append("while ( ").append(string).append("); \n");
            vector.addElement(this.strbuf.toString());
        }
    }

    public SymbolInfo Exponentiation(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        String string = "";
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (this.gencode) {
                            string = "Math.pow((double)" + this.RANGEUPTO_(symbolInfo) + "," + "(double)" + this.RANGEUPTO_(symbolInfo2) + ")";
                            symbolInfo.setValue(string);
                        }
                        n2 = 2;
                        n = 2;
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        string = "Math.pow(" + this.RANGEUPTO_(symbolInfo) + "." + this.RANGEUPTO_(symbolInfo2) + ".doubleValue())";
                        symbolInfo.setValue(string);
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        string = "new BigDecimal(Math.pow(" + this.RANGEUPTO_(symbolInfo) + ".doubleValue()" + "," + this.RANGEUPTO_(symbolInfo2) + ")" + ")";
                        symbolInfo.setValue(string);
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        string = "new BigDecimal(Math.pow(" + this.RANGEUPTO_(symbolInfo) + ".doubleValue()" + "," + this.RANGEUPTO_(symbolInfo2) + ".doubleValue())" + ")";
                        symbolInfo.setValue(string);
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_4", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    public SymbolInfo IntegerDivide(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null) {
            return null;
        }
        int n = symbolInfo.getDataType();
        int n2 = symbolInfo2.getDataType();
        String string = "";
        boolean bl = false;
        block0 : switch (n) {
            case 1: 
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (this.gencode) {
                            string = "Math.round(Math.round((double)" + this.RANGEUPTO_(symbolInfo) + ")" + "/" + "Math.round((double)" + this.RANGEUPTO_(symbolInfo2) + ")" + ")";
                            symbolInfo.setValue(string);
                        }
                        n2 = 2;
                        n = 2;
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        string = "new BigDecimal(Math.round(" + this.RANGEUPTO_(symbolInfo) + ")" + ").divide(" + this.RANGEUPTO_(symbolInfo2) + ".toBigInteger()" + ", BigDecimal.ROUND_HALF_DOWN)";
                        symbolInfo.setValue(string);
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        if (!this.gencode) break block0;
                        string = "new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + ".toBigInteger()" + ".divide(" + "new BigDecimal(" + this.RANGEUPTO_(symbolInfo2) + ").toBigInteger())" + ")";
                        symbolInfo.setValue(string);
                        break;
                    }
                    case 3: {
                        if (!this.gencode) break block0;
                        string = "new BigDecimal(" + this.RANGEUPTO_(symbolInfo) + ".toBigInteger()" + ".divide(" + this.RANGEUPTO_(symbolInfo2) + ".toBigInteger())" + ")";
                        symbolInfo.setValue(string);
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            throw new FormulaError("FML_4", new Object[]{DataTypeDef.toString(n), DataTypeDef.toString(n2)});
        }
        symbolInfo.setDataType(n2 > n ? n2 : n);
        symbolInfo.setAttr(5);
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum());
        return symbolInfo;
    }

    public void buildCaseStatement(SymbolInfo symbolInfo, Vector vector, Vector vector2, SymbolInfo symbolInfo2, boolean bl) throws Exception {
        Object object;
        formula.CodesOfSelectCase codesOfSelectCase;
        int n;
        Object object2;
        if (!this.gencode) {
            return;
        }
        ++this.selectStmtCnt;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector3 = (Vector)vector.clone();
        formula.CodesOfSelectCase codesOfSelectCase2 = null;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < vector3.size(); ++i) {
            object2 = (formula.CodesOfSelectCase)vector3.elementAt(i);
            if (((formula.CodesOfSelectCase)object2).isDefault()) {
                codesOfSelectCase2 = object2;
                n3 = i;
                continue;
            }
            ++n2;
        }
        if (n3 != -1) {
            vector3.removeElementAt(n3);
        }
        String string = this.indent();
        stringBuffer.append(this.indent()).append("int codeBlock" + this.selectStmtCnt + " = -1;\n");
        stringBuffer.append(this.indent()).append("java.util.Vector selList" + this.selectStmtCnt + " = new java.util.Vector();\n");
        stringBuffer.append(this.indent()).append("DbValue[] v" + this.selectStmtCnt + " = null;\n");
        object2 = new StringBuffer();
        for (n = 0; n < vector3.size(); ++n) {
            codesOfSelectCase = (formula.CodesOfSelectCase)vector3.elementAt(n);
            object = codesOfSelectCase.getCodesOfSelectList();
            if (object != null && ((String)object).length() > 0) {
                stringBuffer.append((String)object);
            }
            Vector vector4 = codesOfSelectCase.selectList();
            String string2 = "";
            for (int i = 0; i < vector4.size(); ++i) {
                SymbolInfo symbolInfo3 = (SymbolInfo)vector4.elementAt(i);
                string2 = string2 + this.SEDU(symbolInfo3);
                if (i >= vector4.size() - 1) continue;
                string2 = string2 + ", ";
            }
            stringBuffer.append(this.indent()).append("v" + this.selectStmtCnt + " = new DbValue[]{");
            stringBuffer.append(string2);
            stringBuffer.append("};\n");
            stringBuffer.append(this.indent()).append("selList" + this.selectStmtCnt + ".add(v" + this.selectStmtCnt + ");\n");
            string2 = "";
        }
        stringBuffer.append(this.indent()).append("if(!").append(this.TestNull(symbolInfo)).append("){\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 1)).append("boolean blockFound" + this.selectStmtCnt + " = false;\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 1)).append("for(int i = 0; i < selList" + this.selectStmtCnt + ".size() && !blockFound" + this.selectStmtCnt + "; i++){\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append("v" + this.selectStmtCnt + " = (DbValue[])selList" + this.selectStmtCnt + ".elementAt(i);\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append("for(int j = 0; j < v" + this.selectStmtCnt + ".length; j++){\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 3)).append("DbValue dbv" + this.selectStmtCnt + " = v" + this.selectStmtCnt + "[j];\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 3)).append("if(!dbv" + this.selectStmtCnt + ".bNull){\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 4)).append("if(dbv" + this.selectStmtCnt + ".equals(").append(this.SEDU(symbolInfo)).append(")){\n").append(FormulatoJava.indent(this.tab + 5)).append("codeBlock" + this.selectStmtCnt + " = i;\n").append(FormulatoJava.indent(this.tab + 5)).append("blockFound" + this.selectStmtCnt + " = true;\n").append(FormulatoJava.indent(this.tab + 5)).append("break;\n").append(FormulatoJava.indent(this.tab + 4)).append("}\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 3)).append("}\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append("}\n");
        stringBuffer.append(FormulatoJava.indent(this.tab + 1)).append("}\n");
        stringBuffer.append(this.indent()).append("} else {// null select variable, go default block.\n").append(FormulatoJava.indent(this.tab + 1)).append("codeBlock" + this.selectStmtCnt + " = -1;\n").append(this.indent()).append("}\n");
        stringBuffer.append(this.indent()).append("switch(codeBlock" + this.selectStmtCnt + "){\n");
        for (n = 0; n < vector3.size(); ++n) {
            stringBuffer.append(FormulatoJava.indent(this.tab + 1)).append("case ").append(n).append(":\n");
            codesOfSelectCase = (formula.CodesOfSelectCase)vector3.elementAt(n);
            object = codesOfSelectCase.codes();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append(((Vector)object).elementAt(i));
            }
            if (codesOfSelectCase.isReturnStatement()) continue;
            if (bl) {
                this.ASSIGN(symbolInfo2, codesOfSelectCase.getStatement());
                stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append(symbolInfo2.getValue()).append(";\n");
            }
            stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append("break;\n");
        }
        stringBuffer.append(FormulatoJava.indent(this.tab + 1)).append("default:\n");
        if (codesOfSelectCase2 != null) {
            Vector vector5 = codesOfSelectCase2.codes();
            for (int i = 0; i < vector5.size(); ++i) {
                stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append(vector5.elementAt(i));
            }
            if (bl && codesOfSelectCase2.getStatement().ghost != -101) {
                this.ASSIGN(symbolInfo2, codesOfSelectCase2.getStatement());
                stringBuffer.append(FormulatoJava.indent(this.tab + 2)).append(symbolInfo2.getValue()).append(";\n");
            }
        }
        stringBuffer.append(this.indent()).append("}\n");
        vector2.add(stringBuffer.toString());
    }

    public void checkCaseList(SymbolInfo symbolInfo, SymbolInfo symbolInfo2) throws Exception {
        if (symbolInfo.getDataType() != symbolInfo2.getDataType()) {
            throw new FormulaError("FML_12", new Object[]{DataTypeDef.toString(symbolInfo.getDataType()), DataTypeDef.toString(symbolInfo2.getDataType())});
        }
        if (symbolInfo.getAttr() != 1 && symbolInfo.getAttr() != 4 && symbolInfo.getAttr() != 3 && symbolInfo.getAttr() != 10) {
            throw new FormulaError("FML_ONLY_CONST_ALLOW_IN_CASE", null);
        }
    }

    public void checkCaseStatement(SymbolInfo symbolInfo) throws Exception {
        if (symbolInfo == null) {
            throw new FormulaError("FML_STATEMEMNT_MISSED", null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SymbolInfo SUBRANGE(SymbolInfo symbolInfo, SymbolInfo symbolInfo2, SymbolInfo symbolInfo3, int n) throws Exception {
        if (symbolInfo == null || symbolInfo2 == null || symbolInfo3 == null) {
            return null;
        }
        String string = "";
        String string2 = "";
        switch (n) {
            case 0: {
                string = this.RANGEUPTO_(symbolInfo2);
                string2 = this.RANGEUPTO_(symbolInfo3);
                break;
            }
            case 1: {
                string = this.RANGEUPTO_(symbolInfo2) + " +1 ";
                string2 = this.RANGEUPTO_(symbolInfo3);
                break;
            }
            case 2: {
                string = this.RANGEUPTO_(symbolInfo2);
                string2 = this.RANGEUPTO_(symbolInfo3) + " -1 ";
                break;
            }
            case 3: {
                string = this.RANGEUPTO_(symbolInfo2) + " +1 ";
                string2 = this.RANGEUPTO_(symbolInfo3) + " -1 ";
                break;
            }
            case 4: {
                string = this.RANGEUPTO_(symbolInfo2);
                string2 = this.RANGEUPTO_(symbolInfo) + ".length -1 ";
                break;
            }
            case 5: {
                string = this.RANGEUPTO_(symbolInfo2) + " +1";
                string2 = this.RANGEUPTO_(symbolInfo) + ".length -1 ";
                break;
            }
            case 6: {
                string = "0";
                string2 = this.RANGEUPTO_(symbolInfo3) + " -1 ";
                break;
            }
            case 7: {
                string = "0";
                string2 = this.RANGEUPTO_(symbolInfo3) + " -2 ";
            }
        }
        if (symbolInfo2.getDataType() != 1 || symbolInfo3.getDataType() != 1) throw new FormulaError("FML_15", new Object[]{DataTypeDef.toString(symbolInfo2.getDataType()), DataTypeDef.toString(symbolInfo3.getDataType()), DataTypeDef.toString(1)});
        int n2 = symbolInfo.getDataType();
        if (n2 == 5) {
            if (this.gencode) {
                String string3 = "new DbBigInt(" + string + ")";
                String string4 = "new DbBigInt(" + string2 + " - " + string + " + 1)";
                String string5 = this.SEDU(symbolInfo);
                String string6 = "formulafunctions.Mid(" + string5 + "," + string3 + "," + string4 + ")";
                symbolInfo.setValue(string6);
            }
        } else {
            if (!DataTypeDef.isArray(n2)) throw new FormulaError("FML_14", new Object[]{DataTypeDef.toString(n2)});
            if (this.gencode) {
                symbolInfo.setValue("subary(" + this.RANGEUPTO_(symbolInfo) + ", " + string + ", " + string2 + ")");
            }
        }
        symbolInfo.setSum(symbolInfo.IsSum() && symbolInfo2.IsSum() & symbolInfo3.IsSum());
        symbolInfo.setAttr(5);
        return symbolInfo;
    }

    public void checkBreakStatement(int n) throws Exception {
        if (n == 0) {
            throw new FormulaError("FML_BREAK_MUST_IN_LOOP_STATEMENT", null);
        }
    }

    public void checkContinueStatement(int n) throws Exception {
        if (n == 0) {
            throw new FormulaError("FML_CONTINUE_MUST_IN_LOOP", null);
        }
    }

    private String addElement(Vector vector) {
        String string = "";
        if (vector == null || vector.size() == 0) {
            string = "null";
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + "\"" + vector.elementAt(i) + "\"";
            }
            string = "new String[]{" + string + "}";
        }
        return string;
    }

    public SymbolInfo getCrosstabSummary(SymbolInfo symbolInfo, int n, Vector vector) {
        if (this.gencode) {
            String string = this.addElement(vector);
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.TmpName(symbolInfo)).append(".set(crosstab.getAggValue(").append(this.AggDescName(n)).append(",").append(string).append("))");
            symbolInfo.setValue(this.strbuf.toString());
        }
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    public int addMeasureExpression(MeasureExpression measureExpression) {
        this.measureExpr.addElement(measureExpression);
        return this.measureExpr.size() - 1;
    }

    public SymbolInfo callMeasureExpression(SymbolInfo symbolInfo, int n) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.TmpName(symbolInfo)).append(".set(getAggValue(measureExp[").append(n).append("]))");
            symbolInfo.setValue(this.strbuf.toString());
        }
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    public SymbolInfo callDetailExpression(SymbolInfo symbolInfo, int n) {
        if (this.gencode) {
            this.strbuf = new StringBuffer();
            this.strbuf.append(this.TmpName(symbolInfo)).append(" = getDetail(measureExp[").append(n).append("])");
            symbolInfo.setValue(this.strbuf.toString());
        }
        symbolInfo.setGhost(-100);
        return symbolInfo;
    }

    public void setParserOption(ParserOption parserOption) {
        this.codes = parserOption;
    }
}

