/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import com.jinfonet.ibus.InfoLifeCycleType;
import com.jinfonet.ibus.InformationBus;
import com.jinfonet.ibus.InformationBusManager;
import com.jinfonet.ibus.InformationContainer;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.security.SecureRandom;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbSecurityContext;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.connect.Record;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.formula.DataTypeDef;
import jet.formula.DateTimeParser;
import jet.formula.JavaFormula;
import jet.formula.MyCalendar;
import jet.formula.SpecFormulaDateTime;
import jet.formula.SpecFormulaNum;
import jet.formula.SpecFormulaString;
import jet.formula.SpecFormulaValueChange;
import jet.formula.fArray;
import jet.formula.fBinaryArray;
import jet.formula.fBoolArray;
import jet.formula.fCurArray;
import jet.formula.fCurrency;
import jet.formula.fDateArray;
import jet.formula.fDateRange;
import jet.formula.fDateTimeArray;
import jet.formula.fImage;
import jet.formula.fImageArray;
import jet.formula.fIntArray;
import jet.formula.fNumArray;
import jet.formula.fStrArray;
import jet.formula.fText;
import jet.formula.fTextArray;
import jet.formula.fTimeArray;
import jet.log.JRLogger;
import jet.util.JFieldValueNLSManager;

public class Functions {
    public static final long MILLION = 1000000L;
    public static final long BILLION = 1000000000L;
    public static final long TRILLION = 1000000000000L;
    public static final long QUADRILLION = 1000000000000000L;
    private static final int Average = 1000;
    private static final int CANADA = 60000;
    private static final int CHINA = 3600000;
    private static final long Count = 86400000L;
    private static final long CurrentDate = 604800000L;
    private static final int CurrentDateTime = 1;
    private static final int CurrentTime = 16;
    public static final int EACH = 1;
    public MyCalendar gc = new MyCalendar();
    public MyCalendar bgc = new MyCalendar();
    public Date sqldate = new Date(0L);
    public Time sqltime = new Time(0L);
    public Timestamp sqltimestamp = new Timestamp(0L);
    public SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance();
    public SimpleDateFormat stf = (SimpleDateFormat)DateFormat.getTimeInstance();
    public SimpleDateFormat sdtf = (SimpleDateFormat)DateFormat.getDateTimeInstance();
    public DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
    public DecimalFormat cf = (DecimalFormat)NumberFormat.getCurrencyInstance();
    public DecimalFormatSymbols dfs;
    public static final String[] ones = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    public static final String[] teens = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    public static final String[] tens = new String[]{"?", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    public static final String[] units = new String[]{"hundreds", "thousand", "million", "billion", "trillion"};
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    private static final int[] D = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final String[] ROUND_MODEL_KEY = new String[]{"UP", "DOWN", "CEILING", "FLOOR", "HALF_UP", "HALF_DOWN", "HALF_EVEN"};
    DbValue[] cache = new DbValue[33];
    protected TimeZone tz;
    Record rec;
    JavaFormula javaFormula;
    private static JRLogger DDB = JRLogger.getLogger(Functions.class.getName());
    public static final int NOSPECFUNC = -1;
    public static final int FOREACHSECOND = 0;
    public static final int FOREACHMINUTE = 1;
    public static final int FOREACHHOUR = 2;
    public static final int FOREACHDAY = 10;
    public static final int FOREACHWEEK = 11;
    public static final int FOREACHHALFMONTH = 12;
    public static final int FOREACHMONTH = 13;
    public static final int FOREACHQUARTER = 14;
    public static final int FOREACHHALFYEAR = 15;
    public static final int FOREACHYEAR = 16;
    public static final int FOREACHBIWEEK = 17;
    public static final String STRNOSPECFUNC = "None";
    private static final String DateAdd = "for each second";
    private static final String DateDiff = "for each minute";
    private static final String DatePart = "for each hour";
    private static final String Day = "for each day";
    private static final String DayOfWeek = "for each week";
    private static final String FRANCE = "for each bi-week";
    private static final String FV = "for each half month";
    private static final String ForEachMonth = "for each month";
    private static final String ForEachQuarter = "for each quarter";
    private static final String ForEachWeek = "for each half year";
    private static final String ForEachYear = "for each year";
    private JRecord GERMAN = null;
    private static Hashtable Hour = new Hashtable();
    private static Hashtable IPmt;
    public static Hashtable weekdayToName;
    public static Hashtable weekdayToAbbr;
    public static Hashtable firstdayOfWeek;
    public static String[] dateFormats;
    public static String[] timeFormats;
    public static String[] datetimeFormats;
    private static int[] IRR;
    private static String[] ITALIAN;
    private static Locale[] IsDate;
    private static Vector IsDateTime;
    private static Vector IsTime;
    private static Vector JAPAN;
    private SecureRandom KOREA = new SecureRandom();
    private DbDouble LOCAL_LANGUAGE = new DbDouble(0.0);
    private static final String LONG_TIME = " to <";
    private java.util.Date MRound;
    private static final int Minute = 0;
    private static final int Month = 1;
    private static final int NPer = 2;
    private DbChar Next = new DbChar();

    public Functions() {
        this.gc.setTimeZone(TimeZone.getDefault());
        this.sdf.setCalendar(this.gc);
        this.stf.setCalendar(this.gc);
        this.sdtf.setCalendar(this.gc);
        this.cf.setNegativePrefix("-$");
        this.cf.setNegativeSuffix("");
        for (int i = 1; i < 33; ++i) {
            this.cache[i] = DataTypeDef.makeData(i);
        }
        this.cache[0] = (DbDate)this.cache[6].clone();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.tz = timeZone;
            this.gc.setTimeZone(timeZone);
        }
    }

    public void setEnvironment(Record record) {
        this.rec = record;
    }

    public static int getRoundModelValue(String string) {
        int n = ROUND_MODEL_KEY.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(ROUND_MODEL_KEY[i])) continue;
            return D[i];
        }
        throw new RuntimeException("The round model key is invalid. key = " + string);
    }

    public DbBigInt Abs(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = Math.abs(dbBigInt.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDouble Abs(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.abs(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public fCurrency Abs(fCurrency fCurrency2) {
        if (fCurrency2.bNull) {
            this.cache[3].bNull = true;
        } else {
            ((fCurrency)this.cache[3]).value = fCurrency2.value.abs();
            this.cache[3].bNull = false;
        }
        return (fCurrency)this.cache[3];
    }

    public DbBigInt Asc(DbChar dbChar) {
        if (dbChar.bNull || dbChar.value.length() < 1) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = dbChar.value.charAt(0);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbChar Chr(DbBigInt dbBigInt) {
        if (dbBigInt.bNull || dbBigInt.value < 0L || dbBigInt.value >= 255L) {
            this.cache[5].bNull = true;
        } else {
            ((DbChar)this.cache[5]).value = "" + (char)dbBigInt.value;
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbBigInt InStr(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = dbChar2.value.indexOf(dbChar.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt InStr(DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        if (dbBigInt.bNull || dbChar.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
            return (DbBigInt)this.cache[1];
        }
        int n = (int)dbBigInt.value;
        ((DbBigInt)this.cache[1]).value = n < 0 || n >= dbChar.value.length() ? -1L : (long)dbChar.value.indexOf(dbChar2.value, n);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt LastIndexOf(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = dbChar.value.lastIndexOf(dbChar2.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt LastIndexOf(DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        if (dbBigInt.bNull || dbChar.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
            return (DbBigInt)this.cache[1];
        }
        int n = (int)dbBigInt.value;
        ((DbBigInt)this.cache[1]).value = n < 0 || n >= dbChar.value.length() ? -1L : (long)dbChar.value.lastIndexOf(dbChar2.value, n);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbChar ReplaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        String string = dbChar.value;
        String string2 = dbChar2.value;
        String string3 = dbChar3.value;
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        if (n3 == 0) {
            ((DbChar)this.cache[5]).value = string;
            return (DbChar)this.cache[5];
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuffer = stringBuffer.append(string.substring(n2, n)).append(string3);
            n2 = n + n3;
        }
        stringBuffer = stringBuffer.append(string.substring(n2, string.length()));
        this.cache[5].bNull = false;
        ((DbChar)this.cache[5]).value = stringBuffer.toString();
        return (DbChar)this.cache[5];
    }

    public DbChar Left(DbChar dbChar, DbBigInt dbBigInt) {
        int n = (int)dbBigInt.value;
        if (dbChar.bNull || dbBigInt.bNull || n < 0) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        if (n > dbChar.value.length()) {
            n = dbChar.value.length();
        }
        ((DbChar)this.cache[5]).value = n == 0 ? "" : dbChar.value.substring(0, n);
        this.cache[5].bNull = false;
        return (DbChar)this.cache[5];
    }

    public DbBigInt Length(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.cache[1].bNull = false;
            ((DbBigInt)this.cache[1]).value = dbChar.value.length();
        }
        return (DbBigInt)this.cache[1];
    }

    public DbChar LowerCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = dbChar.value.toLowerCase();
        }
        return (DbChar)this.cache[5];
    }

    public DbChar Mid(DbChar dbChar, DbBigInt dbBigInt) {
        int n = (int)dbBigInt.value;
        if (dbChar.bNull || dbBigInt.bNull || n < 0 || n >= dbChar.value.length()) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = dbChar.value.substring(n);
        }
        return (DbChar)this.cache[5];
    }

    public DbChar Mid(DbChar dbChar, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        int n = (int)dbBigInt.value;
        int n2 = (int)dbBigInt2.value;
        if (dbChar.bNull || dbBigInt.bNull || dbBigInt2.bNull || n < 0 || n >= dbChar.value.length() || n2 <= 0 || n + n2 > dbChar.value.length()) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = dbChar.value.substring(n, n + n2);
        }
        return (DbChar)this.cache[5];
    }

    public DbBit NumericText(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            try {
                Double.valueOf(dbChar.value);
                ((DbBit)this.cache[4]).value = true;
            }
            catch (Exception exception) {
                ((DbBit)this.cache[4]).value = false;
            }
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbChar ReplicateString(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.cache[5].bNull = true;
            } else {
                String string = "";
                int n2 = 254 / dbChar.value.length();
                if (n > n2) {
                    n = n2;
                }
                for (int i = 0; i < n; ++i) {
                    string = string + dbChar.value;
                }
                ((DbChar)this.cache[5]).value = string;
                this.cache[5].bNull = false;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar Right(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.cache[5].bNull = true;
            } else {
                int n2 = dbChar.value.length();
                if (n > n2) {
                    n = n2;
                }
                ((DbChar)this.cache[5]).value = dbChar.value.substring(n2 - n, n2);
                this.cache[5].bNull = false;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar Space(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            if (n < 0) {
                this.cache[5].bNull = true;
            } else {
                String string = "";
                if (n > 254) {
                    n = 254;
                }
                for (int i = 0; i < n; ++i) {
                    string = string + ' ';
                }
                ((DbChar)this.cache[5]).value = string;
                this.cache[5].bNull = false;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbBigInt StrCmp(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = dbChar.value.compareTo(dbChar2.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbChar Trim(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbChar.value;
            ((DbChar)this.cache[5]).value = string != null && string.length() > 0 ? dbChar.value.trim() : "";
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar TrimLeft(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n;
            byte[] byArray = dbChar.value.getBytes();
            int n2 = byArray.length;
            for (n = 0; n < n2 && byArray[n] <= 32; ++n) {
            }
            ((DbChar)this.cache[5]).value = dbChar.value.substring(n);
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar TrimRight(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n;
            char[] cArray = new char[n];
            dbChar.value.getChars(0, n, cArray, 0);
            for (n = dbChar.value.length(); 0 < n && cArray[n - 1] <= ' '; --n) {
            }
            ((DbChar)this.cache[5]).value = dbChar.value.substring(0, n);
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar UpperCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            ((DbChar)this.cache[5]).value = dbChar.value.toUpperCase();
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbDouble Val(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[2].bNull = true;
        } else {
            try {
                int n = dbChar.value.length();
                char[] cArray = new char[n];
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    char c = dbChar.value.charAt(i);
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                    cArray[n2++] = c;
                }
                String string = new String(cArray);
                ((DbDouble)this.cache[2]).value = this.df.parse(string).doubleValue();
                this.cache[2].bNull = false;
            }
            catch (Exception exception) {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble ToNumber(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[2].bNull = true;
        } else {
            try {
                ((DbDouble)this.cache[2]).value = this.df.parse(dbChar.value).doubleValue();
                this.cache[2].bNull = false;
            }
            catch (Exception exception) {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble ToNumber(fCurrency fCurrency2) {
        if (fCurrency2.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = fCurrency2.value.doubleValue();
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbChar ToText(DbBit dbBit) {
        if (dbBit.bNull) {
            this.cache[5].bNull = true;
        } else {
            ((DbChar)this.cache[5]).value = "" + dbBit.value;
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = dbChar.value;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(fCurrency fCurrency2) {
        return this.ToText(fCurrency2, (DbBigInt)null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt) {
        return this.ToText(fCurrency2, null, dbBigInt, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(fCurrency2, null, dbBigInt, dbChar, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(fCurrency2, null, dbBigInt, dbChar, dbChar2);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar) {
        return this.ToText(fCurrency2, dbChar, null, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt) {
        return this.ToText(fCurrency2, dbChar, dbBigInt, null, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2) {
        return this.ToText(fCurrency2, dbChar, dbBigInt, dbChar2, null);
    }

    public DbChar ToText(fCurrency fCurrency2, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        this.dfs = this.cf.getDecimalFormatSymbols();
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.dfs.clone();
        if (fCurrency2.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        try {
            if (dbChar2 != null && !dbChar2.bNull) {
                if (dbChar2.value.length() > 0) {
                    decimalFormatSymbols.setGroupingSeparator(dbChar2.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setGroupingSeparator(',');
            }
            if (dbChar3 != null && !dbChar3.bNull) {
                if (dbChar3.value.length() > 0) {
                    decimalFormatSymbols.setDecimalSeparator(dbChar3.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setDecimalSeparator('.');
            }
            this.cf.setDecimalFormatSymbols(decimalFormatSymbols);
            if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                this.cf.applyPattern(dbChar.value);
            } else {
                this.cf.applyPattern("$#,##0.00");
            }
            if (dbBigInt != null && !dbBigInt.bNull) {
                int n = (int)dbBigInt.value;
                this.cf.setMaximumFractionDigits(n);
                this.cf.setMinimumFractionDigits(n);
            }
            ((DbChar)this.cache[5]).value = this.cf.format(fCurrency2.value.doubleValue());
            this.cache[5].bNull = false;
        }
        catch (Exception exception) {
            this.cache[5].bNull = true;
        }
        this.cf.setDecimalFormatSymbols(this.dfs);
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbBigInt dbBigInt) {
        return this.ToText(dbBigInt, (DbBigInt)null);
    }

    public DbChar ToText(DbDouble dbDouble) {
        return this.ToText(dbDouble, (DbBigInt)null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.ToText(dbBigInt, null, dbBigInt2, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt) {
        return this.ToText(dbDouble, null, dbBigInt, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbChar dbChar) {
        return this.ToText(dbBigInt, null, dbBigInt2, dbChar, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(dbDouble, null, dbBigInt, dbChar, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbBigInt, null, dbBigInt2, dbChar, dbChar2);
    }

    public DbChar ToText(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbDouble, null, dbBigInt, dbChar, dbChar2);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar) {
        return this.ToText(dbBigInt, dbChar, null, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar) {
        return this.ToText(dbDouble, dbChar, null, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2) {
        return this.ToText(dbBigInt, dbChar, dbBigInt2, null, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt) {
        return this.ToText(dbDouble, dbChar, dbBigInt, null, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2, DbChar dbChar2) {
        return this.ToText(dbBigInt, dbChar, dbBigInt2, dbChar2, null);
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2) {
        return this.ToText(dbDouble, dbChar, dbBigInt, dbChar2, null);
    }

    public DbChar ToText(DbBigInt dbBigInt, DbChar dbChar, DbBigInt dbBigInt2, DbChar dbChar2, DbChar dbChar3) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.$assertionsDisabled(dbBigInt.value, dbChar, dbBigInt2, dbChar2, dbChar3);
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbDouble dbDouble, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        if (dbDouble.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.$assertionsDisabled(dbDouble.value, dbChar, dbBigInt, dbChar2, dbChar3);
        }
        return (DbChar)this.cache[5];
    }

    private void $assertionsDisabled(double d, DbChar dbChar, DbBigInt dbBigInt, DbChar dbChar2, DbChar dbChar3) {
        String string = this.df.toPattern();
        this.dfs = this.df.getDecimalFormatSymbols();
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)this.dfs.clone();
        try {
            if (dbChar2 != null && !dbChar2.bNull) {
                if (dbChar2.value.length() > 0) {
                    decimalFormatSymbols.setGroupingSeparator(dbChar2.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setGroupingSeparator(',');
            }
            if (dbChar3 != null && !dbChar3.bNull) {
                if (dbChar3.value.length() > 0) {
                    decimalFormatSymbols.setDecimalSeparator(dbChar3.value.charAt(0));
                }
            } else {
                decimalFormatSymbols.setDecimalSeparator('.');
            }
            this.df.setDecimalFormatSymbols(decimalFormatSymbols);
            if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                this.df.applyPattern(dbChar.value);
            } else {
                this.df.applyPattern("#,##0.###");
            }
            if (dbBigInt != null && !dbBigInt.bNull) {
                int n = (int)dbBigInt.value;
                this.df.setMinimumFractionDigits(n);
                this.df.setMaximumFractionDigits(n);
            }
            ((DbChar)this.cache[5]).value = this.df.format(d);
            this.cache[5].bNull = false;
        }
        catch (Exception exception) {
            if (DDB.isErrorEnabled()) {
                DDB.error("", exception);
            }
            this.cache[5].bNull = true;
        }
        this.df.applyPattern(string);
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    public DbChar ToHex(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = Long.toHexString(dbBigInt.value);
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToOctal(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = Long.toOctalString(dbBigInt.value);
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToBinary(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = Long.toBinaryString(dbBigInt.value);
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbDate dbDate) {
        return this.ToText(dbDate, null);
    }

    public DbChar ToText(DbDate dbDate, DbChar dbChar) {
        if (dbDate.bNull) {
            this.cache[5].bNull = true;
        } else {
            try {
                this.sqldate.setTime(dbDate.value);
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.sdf.applyPattern(dbChar.value);
                } else {
                    this.sdf.applyPattern("dd-MMM-yy");
                }
                ((DbChar)this.cache[5]).value = this.sdf.format(this.sqldate);
                this.cache[5].bNull = false;
            }
            catch (Exception exception) {
                this.cache[5].bNull = true;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbTime dbTime) {
        return this.ToText(dbTime, null, null, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar) {
        return this.ToText(dbTime, dbChar, null, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbTime, dbChar, dbChar2, null);
    }

    public DbChar ToText(DbTime dbTime, DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbTime.bNull) {
            this.cache[5].bNull = true;
        } else {
            try {
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.stf.applyPattern(dbChar.value);
                } else {
                    this.stf.applyPattern("h:mm:ss a");
                }
                DateFormatSymbols dateFormatSymbols = this.stf.getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (dbChar2 != null && !dbChar2.bNull && dbChar2.value.length() > 0) {
                    stringArray[0] = dbChar2.value;
                }
                if (dbChar3 != null && !dbChar3.bNull && dbChar3.value.length() > 0) {
                    stringArray[1] = dbChar3.value;
                }
                dateFormatSymbols.setAmPmStrings(stringArray);
                this.stf.setDateFormatSymbols(dateFormatSymbols);
                this.sqltime.setTime(dbTime.value);
                ((DbChar)this.cache[5]).value = this.stf.format(this.sqltime);
                this.cache[5].bNull = false;
            }
            catch (Exception exception) {
                if (DDB.isErrorEnabled()) {
                    DDB.error("", exception);
                }
                this.cache[5].bNull = true;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ToText(DbTimestamp dbTimestamp) {
        return this.ToText(dbTimestamp, null, null, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar) {
        return this.ToText(dbTimestamp, dbChar, null, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar, DbChar dbChar2) {
        return this.ToText(dbTimestamp, dbChar, dbChar2, null);
    }

    public DbChar ToText(DbTimestamp dbTimestamp, DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbTimestamp.bNull) {
            this.cache[5].bNull = true;
        } else {
            try {
                if (dbChar != null && !dbChar.bNull && dbChar.value.length() > 0) {
                    this.sdtf.applyPattern(dbChar.value);
                } else {
                    this.sdtf.applyPattern("dd-MMM-yy h:mm:ss a");
                }
                DateFormatSymbols dateFormatSymbols = this.sdtf.getDateFormatSymbols();
                String[] stringArray = dateFormatSymbols.getAmPmStrings();
                if (dbChar2 != null && !dbChar2.bNull) {
                    stringArray[0] = dbChar2.toString();
                }
                if (dbChar3 != null && !dbChar3.bNull) {
                    stringArray[1] = dbChar3.toString();
                }
                dateFormatSymbols.setAmPmStrings(stringArray);
                this.sdtf.setDateFormatSymbols(dateFormatSymbols);
                ((DbChar)this.cache[5]).value = this.sdtf.format(dbTimestamp.toUtilDate());
                this.cache[5].bNull = false;
            }
            catch (Exception exception) {
                if (DDB.isErrorEnabled()) {
                    DDB.error("", exception);
                }
                this.cache[5].bNull = true;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar toString(fText fText2) {
        ((DbChar)this.cache[5]).value = fText2.value;
        ((DbChar)this.cache[5]).bNull = fText2.bNull;
        return (DbChar)this.cache[5];
    }

    public fText toLongString(DbChar dbChar) {
        ((fText)this.cache[10]).value = dbChar.value;
        ((fText)this.cache[10]).bNull = dbChar.bNull;
        return (fText)this.cache[10];
    }

    public DbChar ToWords(DbBigInt dbBigInt) {
        return this.ToWords(dbBigInt, null);
    }

    public DbChar ToWords(DbDouble dbDouble) {
        return this.ToWords(dbDouble, null);
    }

    public DbChar ToWords(fCurrency fCurrency2) {
        return this.ToWords(fCurrency2, null);
    }

    public DbChar ToWords(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        ((DbDouble)this.cache[2]).value = dbBigInt.value;
        this.cache[2].bNull = false;
        return this.ToWords((DbDouble)this.cache[2], dbBigInt2);
    }

    public DbChar ToWords(fCurrency fCurrency2, DbBigInt dbBigInt) {
        if (fCurrency2.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        ((DbDouble)this.cache[2]).value = fCurrency2.value.doubleValue();
        this.cache[2].bNull = false;
        return this.ToWords((DbDouble)this.cache[2], dbBigInt);
    }

    public DbChar ToWords(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull) {
            this.cache[5].bNull = true;
        } else {
            double d = dbDouble.value;
            int n = 2;
            String string = "";
            if (dbBigInt != null && !dbBigInt.bNull) {
                n = (int)dbBigInt.value;
            }
            double d2 = Math.pow(10.0, n);
            if (d >= 1.0E15 || d <= -1.0E15 || n > 10 || n < 0) {
                this.cache[5].bNull = true;
                return (DbChar)this.cache[5];
            }
            if (d < 0.0) {
                string = "negative ";
            }
            d = Math.abs(d);
            d = (double)Math.round(d * d2) / d2;
            if (n == 0) {
                string = string + this.getWord((long)d);
            } else {
                String string2 = "/10";
                String string3 = "X";
                for (int i = 1; i < n; ++i) {
                    string2 = string2 + '0';
                    string3 = string3 + 'X';
                }
                string = string + this.getWord((long)d) + "and ";
                if (d - (double)((long)d) == 0.0) {
                    string = string + string3 + string2;
                } else {
                    d = Math.round((d - (double)((long)d)) * d2);
                    String string4 = String.valueOf(d);
                    string = string + string4.substring(0, string4.indexOf(".")) + string2;
                }
            }
            ((DbChar)this.cache[5]).value = string;
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    String getWord(long l) {
        String string;
        long l2;
        String string2 = "";
        if (l == 0L) {
            return "zero ";
        }
        if (l >= 1000000000000L) {
            l2 = l / 1000000000000L;
            string = this.getHTOWords(l2);
            string2 = string2 + string + " trillion ";
            l -= l2 * 1000000000000L;
        }
        if (l >= 1000000000L) {
            l2 = l / 1000000000L;
            string = this.getHTOWords(l2);
            string2 = string2 + string + " billion ";
            l -= l2 * 1000000000L;
        }
        if (l >= 1000000L) {
            l2 = l / 1000000L;
            string = this.getHTOWords(l2);
            string2 = string2 + string + " million ";
            l -= l2 * 1000000L;
        }
        if (l >= 1000L) {
            l2 = l / 1000L;
            string = this.getHTOWords(l2);
            string2 = string2 + string + " thousand ";
            l -= l2 * 1000L;
        }
        if (l > 0L) {
            String string3 = this.getHTOWords(l);
            string2 = string2 + string3;
            string2 = string2 + ' ';
        }
        return string2;
    }

    String getHTOWords(long l) {
        String string = "";
        if (l >= 100L) {
            long l2 = l / 100L;
            String string2 = ones[(int)l2];
            string = string2 + " hundred ";
            l -= l2 * 100L;
        }
        if (l > 0L) {
            String string3 = this.getTOWords(l);
            string = string + string3;
        }
        return string;
    }

    String getTOWords(long l) {
        String string = "";
        if (l > 19L) {
            long l2 = l / 10L;
            string = string + tens[(int)l2];
            if ((l -= l2 * 10L) > 0L) {
                string = string + '-';
                string = string + ones[(int)l];
            }
        } else {
            string = l >= 10L ? string + teens[(int)l - 10] : string + ones[(int)l];
        }
        return string;
    }

    public DbDouble Truncate(DbDouble dbDouble) {
        ((DbBigInt)this.cache[1]).value = 0L;
        this.cache[1].bNull = false;
        return this.Truncate(dbDouble, (DbBigInt)this.cache[1]);
    }

    public DbDouble Truncate(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            try {
                double d = Math.pow(10.0, dbBigInt.value);
                ((DbDouble)this.cache[2]).value = (double)((long)(dbDouble.value * d)) / d;
                this.cache[2].bNull = false;
            }
            catch (Exception exception) {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbBigInt Count(fArray fArray2) {
        if (fArray2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = fArray2.isAll() ? 0L : (long)fArray2.value.length;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Sum(fIntArray fIntArray2) {
        if (fIntArray2.bNull) {
            this.cache[1].bNull = true;
        } else {
            int n = fIntArray2.value.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (fIntArray2.value[i].bNull) continue;
                n2 = (int)((long)n2 + ((DbBigInt)fIntArray2.value[i]).value);
            }
            ((DbBigInt)this.cache[1]).value = n2;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDouble Sum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                if (fNumArray2.value[i].bNull) continue;
                d += ((DbDouble)fNumArray2.value[i]).value;
            }
            ((DbDouble)this.cache[2]).value = d;
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public fCurrency Sum(fCurArray fCurArray2) {
        if (fCurArray2.bNull) {
            this.cache[3].bNull = true;
        } else {
            int n = fCurArray2.value.length;
            BigDecimal bigDecimal = new BigDecimal(0.0);
            for (int i = 0; i < n; ++i) {
                if (fCurArray2.value[i].bNull) continue;
                bigDecimal = bigDecimal.add(((fCurrency)fCurArray2.value[i]).value);
            }
            ((fCurrency)this.cache[3]).value = bigDecimal;
            this.cache[3].bNull = false;
        }
        return (fCurrency)this.cache[3];
    }

    public DbDouble Average(fIntArray fIntArray2) {
        if (fIntArray2.bNull) {
            this.cache[2].bNull = true;
        } else {
            int n = fIntArray2.value.length;
            if (n > 0) {
                DbBigInt dbBigInt = this.Sum(fIntArray2);
                ((DbDouble)this.cache[2]).value = (double)dbBigInt.value / (double)n;
                this.cache[2].bNull = false;
            } else {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble Average(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            if (n > 0) {
                DbDouble dbDouble = this.Sum(fNumArray2);
                ((DbDouble)this.cache[2]).value = dbDouble.value / (double)n;
                this.cache[2].bNull = false;
            } else {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public fCurrency Average(fCurArray fCurArray2) {
        if (fCurArray2.bNull) {
            this.cache[3].bNull = true;
        } else {
            int n = fCurArray2.value.length;
            if (n > 0) {
                fCurrency fCurrency2 = this.Sum(fCurArray2);
                ((fCurrency)this.cache[3]).value = fCurrency2.value.divide(new BigDecimal(n), 2, 5);
                this.cache[3].bNull = false;
            } else {
                this.cache[3].bNull = true;
            }
        }
        return (fCurrency)this.cache[3];
    }

    private DbDouble CANADA(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                if (fNumArray2.value[i].bNull) continue;
                d += Math.pow(((DbDouble)fNumArray2.value[i]).value, 2.0);
            }
            ((DbDouble)this.cache[2]).value = d;
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    private DbDouble CHINA(fNumArray fNumArray2) {
        double d = this.Average((fNumArray)fNumArray2).value;
        double d2 = this.Sum((fNumArray)fNumArray2).value;
        double d3 = this.CANADA((fNumArray)fNumArray2).value;
        ((DbDouble)this.cache[2]).value = d3 - d2 * d;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble PopulationStdDev(fNumArray fNumArray2) {
        DbDouble dbDouble = this.PopulationVariance(fNumArray2);
        if (!dbDouble.bNull) {
            dbDouble.value = Math.sqrt(dbDouble.value);
        }
        return dbDouble;
    }

    public DbDouble PopulationVariance(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = this.CHINA((fNumArray)fNumArray2).value;
        double d2 = this.Count((fArray)fNumArray2).value;
        ((DbDouble)this.cache[2]).value = d / d2;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble StdDev(fNumArray fNumArray2) {
        DbDouble dbDouble = this.Variance(fNumArray2);
        if (!dbDouble.bNull) {
            dbDouble.value = Math.sqrt(dbDouble.value);
        }
        return dbDouble;
    }

    public DbDouble Variance(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
        } else {
            int n = fNumArray2.value.length;
            if (n <= 1) {
                ((DbDouble)this.cache[2]).value = 0.0;
            } else {
                double d = this.CHINA((fNumArray)fNumArray2).value;
                ((DbDouble)this.cache[2]).value = d / (double)(n - 1);
            }
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbBigInt DistinctCount(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[1].bNull = true;
        } else {
            int n = 0;
            int n2 = fNumArray2.value.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                for (n3 = 0; n3 < i && ((DbDouble)fNumArray2.value[n3]).value != ((DbDouble)fNumArray2.value[i]).value; ++n3) {
                }
                if (n3 != i) continue;
                ++n;
            }
            ((DbBigInt)this.cache[1]).value = n;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDouble Maximum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        int n = fNumArray2.value.length;
        if (n > 0) {
            DbDouble dbDouble = (DbDouble)fNumArray2.value[0];
            for (int i = 1; i < n; ++i) {
                if (!(dbDouble.value < ((DbDouble)fNumArray2.value[i]).value)) continue;
                dbDouble = (DbDouble)fNumArray2.value[i];
            }
            return dbDouble;
        }
        this.cache[2].bNull = true;
        return (DbDouble)this.cache[2];
    }

    public DbDouble Minimum(fNumArray fNumArray2) {
        if (fNumArray2.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        int n = fNumArray2.value.length;
        if (n > 0) {
            DbDouble dbDouble = (DbDouble)fNumArray2.value[0];
            for (int i = 1; i < n; ++i) {
                if (!(dbDouble.value >= ((DbDouble)fNumArray2.value[i]).value)) continue;
                dbDouble = (DbDouble)fNumArray2.value[i];
            }
            return dbDouble;
        }
        this.cache[2].bNull = true;
        return (DbDouble)this.cache[2];
    }

    public DbBigInt Remainder(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.cache[1].bNull = true;
        } else {
            int n = (int)dbBigInt.value;
            int n2 = (int)dbBigInt2.value;
            if (n2 == 0) {
                this.cache[1].bNull = true;
            } else {
                ((DbBigInt)this.cache[1]).value = n % n2;
                this.cache[1].bNull = false;
            }
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDouble Round(DbDouble dbDouble) {
        ((DbBigInt)this.cache[1]).value = 0L;
        this.cache[1].bNull = false;
        return this.Round(dbDouble, (DbBigInt)this.cache[1]);
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            try {
                int n = dbDouble.value < 0.0 ? -1 : 1;
                double d = Math.pow(10.0, (int)dbBigInt.value);
                ((DbDouble)this.cache[2]).value = (double)n * (double)Math.round(dbDouble.value * d * (double)n) / d;
                this.cache[2].bNull = false;
            }
            catch (Exception exception) {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbDouble.bNull || dbBigInt.bNull || dbBigInt2.bNull || dbBigInt.value < 0L || !Functions.Count(dbBigInt2)) {
            this.cache[2].bNull = true;
        } else {
            try {
                BigDecimal bigDecimal = new BigDecimal(Double.toString(dbDouble.value));
                bigDecimal = bigDecimal.setScale((int)dbBigInt.value, (int)dbBigInt2.value);
                ((DbDouble)this.cache[2]).set(bigDecimal.doubleValue());
            }
            catch (Exception exception) {
                this.cache[2].bNull = true;
            }
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble Round(DbDouble dbDouble, DbBigInt dbBigInt, DbChar dbChar) {
        if (dbDouble.bNull || dbBigInt.bNull || dbChar.bNull) {
            this.cache[2].bNull = true;
        } else {
            for (int i = 0; i < ROUND_MODEL_KEY.length; ++i) {
                if (!ROUND_MODEL_KEY[i].equalsIgnoreCase(dbChar.value)) continue;
                return this.Round(dbDouble, dbBigInt, new DbBigInt(D[i]));
            }
            this.cache[2].bNull = true;
        }
        return (DbDouble)this.cache[2];
    }

    private static boolean Count(DbBigInt dbBigInt) {
        switch ((int)dbBigInt.value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        if (DDB.isDebugEnabled()) {
            DDB.debug("Illegal RoundMode: " + dbBigInt.value);
        }
        return false;
    }

    public fCurrency MRound(fCurrency fCurrency2, DbDouble dbDouble) {
        return this.MRound(fCurrency2, new fCurrency(new BigDecimal(dbDouble.doubleValue())));
    }

    public fCurrency MRound(fCurrency fCurrency2, fCurrency fCurrency3) {
        if (fCurrency2.bNull || fCurrency3.bNull) {
            this.cache[3].bNull = true;
        } else {
            BigDecimal[] bigDecimalArray;
            BigDecimal bigDecimal = fCurrency3.value.abs();
            BigDecimal bigDecimal2 = fCurrency2.value.abs();
            bigDecimalArray = new BigDecimal[]{bigDecimal2.divide(bigDecimal, 1).setScale(0, 1), bigDecimal2.subtract(bigDecimalArray[0].multiply(bigDecimal))};
            ((fCurrency)this.cache[3]).value = (fCurrency2.value.signum() == -1 ? bigDecimal.negate() : bigDecimal).multiply(bigDecimalArray[0].add(bigDecimalArray[1].compareTo(bigDecimal.divide(new BigDecimal(2), 4)) >= 0 ? new BigDecimal(1) : new BigDecimal(0)));
            this.cache[3].bNull = false;
        }
        return (fCurrency)this.cache[3];
    }

    public DbDouble MRound(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.cache[2].bNull = true;
        } else {
            double d = Math.abs(dbDouble2.doubleValue());
            double d2 = Math.abs(dbDouble.doubleValue());
            double d3 = d2 / d;
            BigDecimal bigDecimal = new BigDecimal(d3).setScale(0, 1);
            ((DbDouble)this.cache[2]).value = (dbDouble.doubleValue() < 0.0 ? -d : d) * (bigDecimal.doubleValue() + (double)((d3 - bigDecimal.doubleValue()) * d >= d / 2.0 ? 1 : 0));
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDate CurrentDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.cache[6]).value = myCalendar.getTimeInLong();
        this.cache[6].bNull = false;
        return (DbDate)this.cache[6];
    }

    public DbDate Today() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.cache[6]).value = myCalendar.getTimeInLong();
        this.cache[6].bNull = false;
        return (DbDate)this.cache[6];
    }

    public DbTime CurrentTime() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTime)this.cache[7]).value = myCalendar.getTimeInLong();
        this.cache[7].bNull = false;
        return (DbTime)this.cache[7];
    }

    public DbBigInt Quarter() {
        DbDate dbDate = this.CurrentDate();
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = this.Quarter(dbDate, new DbBigInt(1L)).intValue();
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Quarter(DbDate dbDate, DbBigInt dbBigInt) {
        if (dbDate.bNull || dbBigInt.bNull || dbBigInt.intValue() < 1 || dbBigInt.intValue() > 12) {
            this.cache[1].bNull = true;
        } else {
            DbBigInt dbBigInt2 = this.Month(dbDate);
            ((DbBigInt)this.cache[1]).value = this.CurrentDate(dbBigInt2.intValue(), dbBigInt.intValue()).intValue();
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Quarter(DbTimestamp dbTimestamp, DbBigInt dbBigInt) {
        if (dbTimestamp.bNull || dbBigInt.bNull || dbBigInt.intValue() < 1 || dbBigInt.intValue() > 12) {
            this.cache[1].bNull = true;
        } else {
            DbBigInt dbBigInt2 = this.Month(dbTimestamp);
            ((DbBigInt)this.cache[1]).value = this.CurrentDate(dbBigInt2.intValue(), dbBigInt.intValue()).intValue();
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    private DbBigInt CurrentDate(int n, int n2) {
        int n3 = n - n2 >= 0 ? n - n2 + 1 : 12 - n2 + n + 1;
        if (n3 % 3 == 0) {
            return new DbBigInt(n3 / 3);
        }
        return new DbBigInt(n3 / 3 + 1);
    }

    public DbTimestamp CurrentDateTime() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTimestamp)this.cache[8]).value = myCalendar.getTimeInLong();
        ((DbTimestamp)this.cache[8]).nanos = 0;
        this.cache[8].bNull = false;
        return (DbTimestamp)this.cache[8];
    }

    public DbDate ToDate(DbDate dbDate) {
        return dbDate;
    }

    public DbDate ToDate(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[6].bNull = true;
        } else {
            Timestamp timestamp = dbTimestamp.getTimestamp();
            this.gc.setTime(timestamp.getTime());
            this.gc.computeFields();
            this.gc.set(10, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ToDate(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, 0, 0, 0);
            this.gc.set(14, 0);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbTimestamp ToDateTime(DbDate dbDate, DbTime dbTime) {
        if (dbDate.bNull || dbTime.bNull) {
            this.cache[8].bNull = true;
        } else {
            this.gc.setTime(dbTime.value);
            this.gc.computeTime();
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            this.gc.setTime(dbDate.value);
            this.gc.computeTime();
            this.gc.setHMS(n, n2, n3);
            ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
            ((DbTimestamp)this.cache[8]).nanos = 0;
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.cache[8].bNull = true;
            return (DbTimestamp)this.cache[8];
        }
        this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, 0, 0, 0);
        ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
        ((DbTimestamp)this.cache[8]).nanos = 0;
        this.cache[8].bNull = false;
        return (DbTimestamp)this.cache[8];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3, DbBigInt dbBigInt4, DbBigInt dbBigInt5, DbBigInt dbBigInt6) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull || dbBigInt4.bNull || dbBigInt5.bNull || dbBigInt6.bNull) {
            this.cache[8].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, (int)dbBigInt4.value, (int)dbBigInt5.value, (int)dbBigInt6.value);
            ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
            ((DbTimestamp)this.cache[8]).nanos = 0;
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3, DbBigInt dbBigInt4, DbBigInt dbBigInt5, DbBigInt dbBigInt6, DbBigInt dbBigInt7) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull || dbBigInt4.bNull || dbBigInt5.bNull || dbBigInt6.bNull || dbBigInt7.bNull) {
            this.cache[8].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set((int)dbBigInt.value, (int)dbBigInt2.value - 1, (int)dbBigInt3.value, (int)dbBigInt4.value, (int)dbBigInt5.value, (int)dbBigInt6.value);
            ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
            ((DbTimestamp)this.cache[8]).nanos = (int)dbBigInt7.value;
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbDate DateTimeToDate(DbTimestamp dbTimestamp) {
        return this.ToDate(dbTimestamp);
    }

    public DbBigInt DateTimeToSeconds(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            int n4 = (n * 60 + n2) * 60 + n3;
            ((DbBigInt)this.cache[1]).value = n4;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbTime DateTimeToTime(DbTimestamp dbTimestamp) {
        return this.ToTime(dbTimestamp);
    }

    public DbBigInt Day(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(5);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Day(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(5);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DayOfWeek(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(7);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DayOfWeek(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(7);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Month(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(2) + 1;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Month(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(2) + 1;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Year(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(1);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Year(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(1);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Hour(DbTime dbTime) {
        if (dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTime.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(11);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Hour(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(11);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Minute(DbTime dbTime) {
        if (dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTime.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(12);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Minute(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(12);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Second(DbTime dbTime) {
        if (dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTime.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(13);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Second(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(13);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfYear(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(3);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfYear(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(3);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfMonth(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(4);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfMonth(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            ((DbBigInt)this.cache[1]).value = this.gc.get(4);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekFrom1970(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            long l = dbTimestamp.value / 86400000L;
            ((DbBigInt)this.cache[1]).value = (int)((l + 5L) / 7L);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekFrom1970(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            long l = dbDate.value / 86400000L;
            ((DbBigInt)this.cache[1]).value = (int)((l + 5L) / 7L);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbTime ToTime(DbTimestamp dbTimestamp) {
        if (dbTimestamp.bNull) {
            this.cache[7].bNull = true;
        } else {
            this.gc.setTime(dbTimestamp.value);
            this.gc.computeFields();
            this.gc.set(1, 0);
            this.gc.set(2, 0);
            this.gc.set(5, 0);
            ((DbTime)this.cache[7]).value = this.gc.getTimeInLong();
            this.cache[7].bNull = false;
        }
        return (DbTime)this.cache[7];
    }

    public DbTime ToTime(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.cache[7].bNull = true;
        } else {
            this.gc.setTime(0L);
            this.gc.set(11, (int)dbBigInt.value);
            this.gc.set(12, (int)dbBigInt2.value);
            this.gc.set(13, (int)dbBigInt3.value);
            ((DbTime)this.cache[7]).value = this.gc.getTimeInLong();
            this.cache[7].bNull = false;
        }
        return (DbTime)this.cache[7];
    }

    public fDateRange Aged0To30Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, -30);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        ((DbDate)this.cache[0]).value = l;
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Aged31To60Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, -31);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, -29);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Aged61To90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, -61);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, -29);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange AllDatesFromToday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.cache[6]).value = myCalendar.getTimeInLong();
        this.cache[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], null};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange AllDatesFromTomorrow() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, 1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], null};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange AllDatesToToday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.cache[6]).value = myCalendar.getTimeInLong();
        this.cache[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{null, (DbDate)this.cache[6]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange AllDatesToYesterday() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.add(5, -1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{null, (DbDate)this.cache[6]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar1stHalf() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 0, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 5, 30, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar2ndHalf() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 6, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 11, 31, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar1stQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 0, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 2, 31, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar2ndQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 3, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 5, 30, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar3rdQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 6, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 8, 30, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Calendar4thQtr() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.set(myCalendar.get(1), 9, 1, 0, 0, 0);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(myCalendar.get(1), 11, 31, 0, 0, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Last4WeeksToSun() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * (this.gc.get(7) - 1);
        this.gc.add(5, n);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, -27);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Last7Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, -6);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        ((DbDate)this.cache[0]).value = l;
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange LastFullMonth() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.add(2, -1);
        this.gc.set(5, 1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(5, this.gc.getMaximum(5));
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange LastFullWeek() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * this.gc.get(7);
        this.gc.add(5, n);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, -6);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange LastYearMTD() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.add(1, -1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(5, 1);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange LastYearYTD() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.add(1, -1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.set(5, 1);
        this.gc.set(2, 0);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange MonthToDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(2, 0);
        this.gc.set(5, 1);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Next30Days() {
        long l;
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        ((DbDate)this.cache[6]).value = l = myCalendar.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.setTime(l);
        this.gc.add(5, 30);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Next31To60Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, 31);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, 29);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Next61To90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, 61);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, 29);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Next91To365Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(5, 91);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        this.gc.add(5, 264);
        ((DbDate)this.cache[0]).value = this.gc.getTimeInLong();
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange Over90Days() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        this.gc.setTime(myCalendar.getTimeInLong());
        this.gc.add(5, -91);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], null};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange WeekToDateFromSun() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.setFirstDayOfWeek(1);
        int n = -1 * (this.gc.get(7) - 1);
        this.gc.add(5, n);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        ((DbDate)this.cache[0]).value = l;
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public fDateRange YearToDate() {
        MyCalendar myCalendar = new MyCalendar();
        myCalendar.set(11, 0);
        myCalendar.set(12, 0);
        myCalendar.set(13, 0);
        myCalendar.set(14, 0);
        long l = myCalendar.getTimeInLong();
        this.gc.setTime(l);
        this.gc.add(2, 0);
        this.gc.set(2, 0);
        this.gc.set(5, 1);
        ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
        this.cache[6].bNull = false;
        ((DbDate)this.cache[0]).value = l;
        this.cache[0].bNull = false;
        DbDate[] dbDateArray = new DbDate[]{(DbDate)this.cache[6], (DbDate)this.cache[0]};
        ((fDateRange)this.cache[28]).value = dbDateArray;
        this.cache[28].bNull = false;
        return (fDateRange)this.cache[28];
    }

    public DbBit LooksLike(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.cache[4].bNull = true;
            return (DbBit)this.cache[4];
        }
        String string = dbChar.value;
        String string2 = dbChar2.value;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*?", true);
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string3.equals("*")) {
                if (!bl) continue;
                vector.addElement(string3);
                bl = false;
                continue;
            }
            vector.addElement(string3);
            bl = true;
        }
        int n = 0;
        int n2 = vector.size();
        int n3 = string.length();
        boolean bl2 = true;
        boolean bl3 = true;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            string3 = (String)vector.elementAt(i);
            if (string3.charAt(0) == '?') {
                if (++n <= n3) continue;
                bl2 = false;
                break;
            }
            if (string3.charAt(0) == '*') {
                bl3 = false;
                continue;
            }
            n4 = string.indexOf(string3, n);
            if (bl3) {
                int n5 = n4 = n == n4 ? n4 : -1;
            }
            if (n4 == -1) {
                bl2 = false;
                break;
            }
            n = n4 + string3.length();
            bl3 = true;
        }
        this.cache[4].bNull = false;
        ((DbBit)this.cache[4]).value = bl2;
        return (DbBit)this.cache[4];
    }

    public DbChar Now() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbTime)this.cache[7]).value = myCalendar.getTimeInLong();
        this.cache[7].bNull = false;
        return this.ToText((DbTime)this.cache[7]);
    }

    public DbChar Picture(DbChar dbChar, DbChar dbChar2) {
        if (dbChar.bNull || dbChar2.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbChar.value;
            String string2 = dbChar2.value;
            int n = string2.length();
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c != 'x' && c != 'X') continue;
                if (n3 < n2) {
                    stringBuffer.setCharAt(i, string.charAt(n3++));
                    continue;
                }
                for (int j = i; j < n; ++j) {
                    c = string2.charAt(j);
                    if (c == 'x' || c == 'X') continue;
                    stringBuffer.setCharAt(i++, c);
                }
                stringBuffer.setLength(i);
                break;
            }
            if (n3 < n2) {
                stringBuffer.append(string.substring(n3));
            }
            ((DbChar)this.cache[5]).value = stringBuffer.toString();
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ExtractString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbChar.value;
            String string2 = dbChar2.value;
            String string3 = dbChar3.value;
            String string4 = "";
            int n = 0;
            int n2 = 0;
            if (string != null && (n = string.indexOf(string2)) != -1) {
                n2 = string.indexOf(string3, n);
                string4 = n2 != -1 ? string.substring(n, n2) : string.substring(n);
            }
            ((DbChar)this.cache[5]).value = string4;
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbDouble FRCurrentRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRQuickRatio(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble3.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRDebtEquityRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FREquityVsTotalAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRNetProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRGrossProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FROperatingProfitMargin(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRInterestCoverage(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRCashFlowVsTotalDebt(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRReturnOnEquity(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRReturnOnNetFixedAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRReturnOntotalAssets(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRReturnOnInvestedCapital(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        double d = dbDouble2.value + dbDouble3.value;
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull || d == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / d;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRReturnOnCommonEquity(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else if (dbDouble3.value == 0.0 || dbDouble.value < dbDouble2.value) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FREarningsPerCommonShare(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble2.bNull || dbDouble3.bNull || dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else if (dbDouble3.value == 0.0 || dbDouble.value < dbDouble2.value) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = (dbDouble.value - dbDouble2.value) / (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRAccRecTurnover(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value * (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRInventoryTurnover(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value * (double)((int)dbDouble3.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRPriceEarningsRatio(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble FRDividendYield(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble2.value == 0.0) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = dbDouble.value / dbDouble2.value;
        }
        return (DbDouble)this.cache[2];
    }

    public DbBit IsNull(DbValue dbValue) {
        ((DbBit)this.cache[4]).value = dbValue.bNull;
        this.cache[4].bNull = false;
        return (DbBit)this.cache[4];
    }

    public static boolean isSupportSpecFunc(int n, int n2) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                if (n2 != 4 && n2 != 3) break;
                return true;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                if (n2 != 4) break;
                return true;
            }
            case 91: 
            case 92: 
            case 93: {
                if (n2 != 2) break;
                return true;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (n2 != 1) break;
                return true;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw new Error("unknow sql type : " + n);
            }
        }
        return false;
    }

    public static int[] getSpecFuncForType(int n) {
        int[] nArray = null;
        switch (n) {
            case 92: {
                break;
            }
            case 91: {
                nArray = new int[]{10, 11, 17, 12, 13, 14, 15, 16};
                break;
            }
            case 93: {
                nArray = new int[]{10, 11, 17, 12, 13, 14, 15, 16};
            }
        }
        return nArray;
    }

    public static String getSpecFuncName(String string, int n) {
        String string2 = null;
        if (string.equals(Integer.toString(1))) {
            switch (n) {
                case 1: {
                    string2 = ForEachYear;
                    break;
                }
                case 2: {
                    string2 = ForEachMonth;
                    break;
                }
                case 5: {
                    string2 = Day;
                    break;
                }
                case 10: {
                    string2 = DatePart;
                    break;
                }
                case 12: {
                    string2 = DateDiff;
                    break;
                }
                case 13: {
                    string2 = DateAdd;
                    break;
                }
                case 21: {
                    string2 = FV;
                    break;
                }
                case 20: {
                    string2 = ForEachWeek;
                    break;
                }
                case 22: {
                    string2 = ForEachQuarter;
                    break;
                }
                case 24: {
                    string2 = DayOfWeek;
                    break;
                }
                case 23: {
                    string2 = FRANCE;
                }
            }
        }
        return string2;
    }

    public static String getSpecFuncName(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = STRNOSPECFUNC;
                break;
            }
            case 0: {
                string = DateAdd;
                break;
            }
            case 1: {
                string = DateDiff;
                break;
            }
            case 2: {
                string = DatePart;
                break;
            }
            case 10: {
                string = Day;
                break;
            }
            case 11: {
                string = DayOfWeek;
                break;
            }
            case 12: {
                string = FV;
                break;
            }
            case 13: {
                string = ForEachMonth;
                break;
            }
            case 14: {
                string = ForEachQuarter;
                break;
            }
            case 15: {
                string = ForEachWeek;
                break;
            }
            case 16: {
                string = ForEachYear;
                break;
            }
            case 17: {
                string = FRANCE;
            }
        }
        return string;
    }

    private static String CurrentDateTime(String string) {
        String string2 = "";
        String string3 = " ";
        boolean bl = false;
        string = string.trim();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n++);
            while (Character.isWhitespace(c)) {
                bl = true;
                c = string.charAt(n++);
            }
            if (bl) {
                string2 = string2 + string3;
                bl = false;
            }
            string2 = string2 + c;
        }
        return string2;
    }

    public static int getSpecFuncByName(String string) {
        int n = -1;
        String string2 = Functions.CurrentDateTime(string);
        if (string2.equalsIgnoreCase(DateAdd)) {
            n = 0;
        } else if (string2.equalsIgnoreCase(DateDiff)) {
            n = 1;
        } else if (string2.equalsIgnoreCase(DatePart)) {
            n = 2;
        } else if (string2.equalsIgnoreCase(Day)) {
            n = 10;
        } else if (string2.equalsIgnoreCase(DayOfWeek)) {
            n = 11;
        } else if (string2.equalsIgnoreCase(FRANCE)) {
            n = 17;
        } else if (string2.equalsIgnoreCase(FV)) {
            n = 12;
        } else if (string2.equalsIgnoreCase(ForEachMonth)) {
            n = 13;
        } else if (string2.equalsIgnoreCase(ForEachQuarter)) {
            n = 14;
        } else if (string2.equalsIgnoreCase(ForEachWeek)) {
            n = 15;
        } else if (string2.equalsIgnoreCase(ForEachYear)) {
            n = 16;
        }
        return n;
    }

    public static String[] getSpecialFunctionNames() {
        String[] stringArray = new String[]{STRNOSPECFUNC, DateAdd, DateDiff, DatePart, Day, DayOfWeek, FRANCE, FV, ForEachMonth, ForEachQuarter, ForEachWeek, ForEachYear};
        return stringArray;
    }

    public DbDate ForEachDay(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachWeek(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.add(7, -1 * this.gc.get(7) + 1);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachBiWeek(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            DbDateTime dbDateTime2 = (DbDateTime)dbDateTime.clone();
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            int n = this.gc.get(3);
            if (n % 2 == 0) {
                this.gc.set(5, this.gc.get(5) - 7);
                dbDateTime2.value = this.gc.getTimeInLong();
            }
            DbDate dbDate = this.ForEachWeek(dbDateTime2);
            ((DbDate)this.cache[6]).value = dbDate.value;
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachHalfMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            if (this.gc.get(5) > 15) {
                this.gc.set(5, 16);
            } else {
                this.gc.set(5, 1);
            }
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachQuarter(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            int n = this.gc.get(2);
            if (n < 3) {
                this.gc.set(2, 0);
            } else if (n >= 3 && n < 6) {
                this.gc.set(2, 3);
            } else if (n >= 6 && n < 9) {
                this.gc.set(2, 6);
            } else if (n >= 9 && n <= 11) {
                this.gc.set(2, 9);
            }
            this.gc.set(5, 1);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachHalfYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            int n = this.gc.get(2);
            if (n < 6) {
                this.gc.set(2, 0);
            } else {
                this.gc.set(2, 6);
            }
            this.gc.set(5, 1);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate ForEachYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(2, 0);
            this.gc.set(5, 1);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbBigInt Age(DbDate dbDate, DbDate dbDate2) {
        if (dbDate.bNull || dbDate2.bNull) {
            this.cache[1].bNull = true;
        } else {
            this.gc.setTime(dbDate.value);
            this.gc.computeFields();
            int n = this.gc.get(1);
            this.gc.setTime(dbDate2.value);
            this.gc.computeFields();
            int n2 = this.gc.get(1);
            ((DbBigInt)this.cache[1]).value = n - n2;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Age(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            MyCalendar myCalendar = new MyCalendar();
            myCalendar.set(11, 0);
            myCalendar.set(12, 0);
            myCalendar.set(13, 0);
            myCalendar.set(14, 0);
            this.gc.setTime(dbDate.value);
            this.gc.computeFields();
            int n = this.gc.get(1);
            int n2 = myCalendar.get(1);
            ((DbBigInt)this.cache[1]).value = n - n2;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Day() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(5);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DayOfWeek() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(7);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DayOfYear() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(6);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Hour() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(11);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Second() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(13);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Minute() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(12);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt currentMonth() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(2) + 1;
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Month() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(2);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt Year() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(1);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfYear() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(3);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekOfMonth() {
        MyCalendar myCalendar = new MyCalendar();
        ((DbBigInt)this.cache[1]).value = myCalendar.get(4);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt WeekFrom1970() {
        MyCalendar myCalendar = new MyCalendar();
        long l = myCalendar.getTimeInLong() / 86400000L;
        ((DbBigInt)this.cache[1]).value = (int)((l + 5L) / 7L);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbValue Next(DbValue dbValue) {
        ((DbBigInt)this.cache[1]).value = 1L;
        this.cache[1].bNull = false;
        return this.Next(dbValue, (DbBigInt)this.cache[1]);
    }

    public DbValue Next(DbValue dbValue, DbBigInt dbBigInt) {
        return this.CurrentTime(dbValue, dbBigInt);
    }

    public DbValue Prev(DbValue dbValue) {
        ((DbBigInt)this.cache[1]).value = 1L;
        this.cache[1].bNull = false;
        return this.Prev(dbValue, (DbBigInt)this.cache[1]);
    }

    public DbValue Prev(DbValue dbValue, DbBigInt dbBigInt) {
        if (!dbBigInt.bNull) {
            dbBigInt.value = 0L - dbBigInt.value;
        }
        return this.CurrentTime(dbValue, dbBigInt);
    }

    private DbValue CurrentTime(DbValue dbValue, DbBigInt dbBigInt) {
        int n = DataTypeDef.SqlToFml(dbValue.getSqlType(), dbValue.isCurrency());
        if (dbBigInt.bNull) {
            this.cache[n].bNull = true;
        } else {
            int n2 = this.rec.getRecordIndex();
            int n3 = n2 + (int)dbBigInt.value;
            int n4 = ((JRecord)this.rec).getDependCursor().getCurrentEnd();
            if (n3 < 1 || n3 > n4) {
                this.cache[n].bNull = true;
            } else {
                if (this.GERMAN == null) {
                    try {
                        this.GERMAN = ((JRecord)this.rec).getDependCursor().createRecord();
                    }
                    catch (DSException dSException) {
                        this.GERMAN = null;
                    }
                }
                if (this.GERMAN != null) {
                    this.GERMAN.setRecordIndex(n3);
                    this.GERMAN.refresh(false);
                    int n5 = dbValue.getColDesc().getColIndex();
                    if (this.cache[n] instanceof DbNumber) {
                        ((DbNumber)this.cache[n]).setValue((DbNumber)this.GERMAN.getCell(n5));
                    } else {
                        this.cache[n].set(this.GERMAN.getCell(n5));
                    }
                } else {
                    this.cache[n].bNull = true;
                }
            }
        }
        return this.cache[n];
    }

    public fText openTxtFile(DbChar dbChar) {
        fText fText2;
        block5: {
            fText2 = (fText)this.cache[10];
            fText2.setNull();
            if (!dbChar.isNull()) {
                FileInputStream fileInputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        fileInputStream = new FileInputStream(string);
                        byte[] byArray = this.D(fileInputStream);
                        ((InputStream)fileInputStream).close();
                        if (byArray != null) {
                            fText2.setRaw(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!DDB.isDebugEnabled()) break block5;
                    DDB.debug(exception.getMessage(), exception);
                }
            }
        }
        return fText2;
    }

    public fText openTxtURL(DbChar dbChar) {
        fText fText2;
        block5: {
            fText2 = (fText)this.cache[10];
            fText2.setNull();
            if (!dbChar.isNull()) {
                InputStream inputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        byte[] byArray = this.D(inputStream);
                        inputStream.close();
                        if (byArray != null) {
                            fText2.setRaw(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!DDB.isDebugEnabled()) break block5;
                    DDB.debug(exception.getMessage(), exception);
                }
            }
        }
        return fText2;
    }

    public fImage openBinFile(DbChar dbChar) {
        fImage fImage2;
        block5: {
            fImage2 = (fImage)this.cache[11];
            fImage2.setNull();
            if (!dbChar.isNull()) {
                FileInputStream fileInputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        fileInputStream = new FileInputStream(string);
                        byte[] byArray = this.D(fileInputStream);
                        ((InputStream)fileInputStream).close();
                        if (byArray != null) {
                            fImage2.set(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!DDB.isDebugEnabled()) break block5;
                    DDB.debug(exception.getMessage(), exception);
                }
            }
        }
        return fImage2;
    }

    public fImage openBinURL(DbChar dbChar) {
        fImage fImage2;
        block5: {
            fImage2 = (fImage)this.cache[11];
            fImage2.setNull();
            if (!dbChar.isNull()) {
                InputStream inputStream = null;
                String string = dbChar.get();
                try {
                    if (string != null) {
                        URL uRL = new URL(string);
                        inputStream = uRL.openStream();
                        byte[] byArray = this.D(inputStream);
                        inputStream.close();
                        if (byArray != null) {
                            fImage2.set(byArray);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!DDB.isDebugEnabled()) break block5;
                    DDB.debug(exception.getMessage(), exception);
                }
            }
        }
        return fImage2;
    }

    private byte[] D(InputStream inputStream) throws IOException {
        byte[] byArray = null;
        if (inputStream != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while (n >= 0) {
                n = inputStream.read(byArray2);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 0) {
                byArray = null;
            }
        }
        return byArray;
    }

    public DbChar reportName() {
        String string = this.javaFormula.REPORT_NAME();
        ((DbChar)this.cache[5]).set(string);
        return (DbChar)this.cache[5];
    }

    public DbBit isRunBursting() {
        ((DbBit)this.cache[4]).value = this.javaFormula.isRunningBursting();
        this.cache[4].bNull = false;
        return (DbBit)this.cache[4];
    }

    public DbChar currentBurstingSchema() {
        String string = this.javaFormula.getCurrentBurstingSchema();
        ((DbChar)this.cache[5]).set(string);
        return (DbChar)this.cache[5];
    }

    public DbChar getLanguage() {
        String string = this.javaFormula.LOCAL_LANGUAGE();
        ((DbChar)this.cache[5]).set(string);
        return (DbChar)this.cache[5];
    }

    public DbBit IsNoRecord() {
        DbBit dbBit = (DbBit)this.cache[4];
        dbBit.set(this.javaFormula.isNoRecord());
        return dbBit;
    }

    public DbDate ToDate(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[6].bNull = true;
        } else {
            ((DbDate)this.cache[6]).value = dbBigInt.value;
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbTimestamp ToDateTime(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[8].bNull = true;
        } else {
            ((DbTimestamp)this.cache[8]).value = dbBigInt.value;
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbTime ToTime(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[7].bNull = true;
        } else {
            ((DbTime)this.cache[7]).value = dbBigInt.value;
            this.cache[7].bNull = false;
        }
        return (DbTime)this.cache[7];
    }

    public DbBigInt ToInt(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = dbDouble.longValue();
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt ToInt(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[1].bNull = true;
        } else {
            try {
                ((DbBigInt)this.cache[1]).value = this.df.parse(dbChar.value).longValue();
                this.cache[1].bNull = false;
            }
            catch (ParseException parseException) {
                this.cache[1].bNull = true;
            }
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDate DateTo2000(DbDate dbDate, DbBigInt dbBigInt) {
        if (dbDate.bNull || dbBigInt.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.clear();
            this.gc.setTime(dbDate.getDate());
            int n = this.gc.get(1);
            int n2 = this.gc.get(2);
            int n3 = this.gc.get(5);
            if (n < 2000 & n >= 1900) {
                int n4 = dbDate.getDate().getYear();
                if ((long)n4 < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n4 + 2000, n2, n3);
                    ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
                } else {
                    ((DbDate)this.cache[6]).value = dbDate.value;
                }
            } else if (n < 100 & n >= 0) {
                if ((long)n < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n + 2000, n2, n3);
                    ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
                } else {
                    this.gc.clear();
                    this.gc.set(n + 1900, n2, n3);
                    ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
                }
            } else {
                ((DbDate)this.cache[6]).value = dbDate.value;
            }
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbTimestamp DateTimeTo2000(DbTimestamp dbTimestamp, DbBigInt dbBigInt) {
        if (dbTimestamp.bNull || dbBigInt.bNull) {
            this.cache[8].bNull = true;
        } else {
            this.gc.clear();
            this.gc.setTime(dbTimestamp.getTimestamp());
            int n = this.gc.get(1);
            int n2 = this.gc.get(2);
            int n3 = this.gc.get(5);
            int n4 = this.gc.get(10);
            int n5 = this.gc.get(12);
            int n6 = this.gc.get(13);
            if (n < 2000 & n >= 1900) {
                int n7 = dbTimestamp.getTimestamp().getYear();
                if ((long)n7 < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n7 + 2000, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
                } else {
                    ((DbTimestamp)this.cache[8]).value = dbTimestamp.value;
                }
            } else if (n < 100 & n >= 0) {
                if ((long)n < dbBigInt.value) {
                    this.gc.clear();
                    this.gc.set(n + 2000, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
                } else {
                    this.gc.clear();
                    this.gc.set(n + 1900, n2, n3, n4, n5, n6);
                    ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
                }
            } else {
                ((DbTimestamp)this.cache[8]).value = dbTimestamp.value;
            }
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbChar DTSTo2000(DbChar dbChar, DbBigInt dbBigInt) {
        if (dbChar.bNull || dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            Integer n;
            Integer n2;
            int n3;
            Integer n4;
            Integer n5;
            int n6;
            int n7 = dbChar.value.length();
            String string = "";
            for (int i = 0; i < n7 && dbChar.value.charAt(i) >= '0' & dbChar.value.charAt(i) <= '9'; ++i) {
                string = string + dbChar.value.charAt(i);
            }
            ((DbChar)this.cache[5]).value = string.length() == 0 ? dbChar.value : (string.length() <= 4 & string.length() > 0 ? ((n6 = (n5 = new Integer(string)).intValue()) < 2000 & n6 >= 1900 ? ((long)(n4 = new Integer(string.substring(2, 4))).intValue() < dbBigInt.value ? "20" + dbChar.value.substring(2, dbChar.value.length()) : dbChar.value) : (n6 < 100 & n6 >= 10 ? ((long)n6 < dbBigInt.value ? "20" + dbChar.value : "19" + dbChar.value) : (n6 < 10 && n6 > 0 ? ((long)n6 < dbBigInt.value ? "200" + dbChar.value : "190" + dbChar.value) : dbChar.value))) : ((n3 = (n2 = new Integer(string.substring(0, 4))).intValue()) < 2000 & n3 >= 1900 ? ((long)(n = new Integer(string.substring(2, 4))).intValue() < dbBigInt.value ? "20" + dbChar.value.substring(2, dbChar.value.length()) : dbChar.value) : (n3 < 100 & n3 >= 0 ? ((long)n3 < dbBigInt.value ? "20" + dbChar.value : "19" + dbChar.value) : dbChar.value)));
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ByteToText(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            if (dbBigInt.value < 1024L) {
                ((DbChar)this.cache[5]).set(dbBigInt.toString() + " bytes");
            } else if (dbBigInt.value >= 1024L & dbBigInt.value < 0x100000L) {
                int n = (int)(dbBigInt.value / 1024L);
                DbBigInt dbBigInt2 = new DbBigInt();
                dbBigInt2.set(n);
                ((DbChar)this.cache[5]).set(dbBigInt2.toString() + " KB");
            } else if (dbBigInt.value >= 0x100000L) {
                int n = (int)(dbBigInt.value / 0x100000L);
                DbBigInt dbBigInt3 = new DbBigInt();
                dbBigInt3.set(n);
                ((DbChar)this.cache[5]).set(dbBigInt3.toString() + " MB");
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    private String DDB(String string) {
        String string2 = (string = string.toUpperCase()).substring(0, 1);
        if (!Character.isLetter(string2.charAt(0))) {
            return "0000";
        }
        block9: for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'A': 
                case 'E': 
                case 'H': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'W': 
                case 'Y': {
                    continue block9;
                }
                case 'B': 
                case 'F': 
                case 'P': 
                case 'V': {
                    string2 = string2 + "1";
                    continue block9;
                }
                case 'C': 
                case 'G': 
                case 'J': 
                case 'K': 
                case 'Q': 
                case 'S': 
                case 'X': 
                case 'Z': {
                    string2 = string2 + "2";
                    continue block9;
                }
                case 'D': 
                case 'T': {
                    string2 = string2 + "3";
                    continue block9;
                }
                case 'L': {
                    string2 = string2 + 4;
                    continue block9;
                }
                case 'M': 
                case 'N': {
                    string2 = string2 + "5";
                    continue block9;
                }
                case 'R': {
                    string2 = string2 + "6";
                    continue block9;
                }
                default: {
                    string2 = string2 + "0";
                }
            }
        }
        string2 = string2 + "0000";
        return string2.substring(0, 4);
    }

    public DbChar Soundex(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = this.DDB(dbChar.value);
            ((DbChar)this.cache[5]).set(string);
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ExchGetId(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            if (dbChar.value.toUpperCase().indexOf("/CN=") != -1) {
                for (int i = 0; !(i >= dbChar.value.length() || dbChar.value.charAt(i) == '/' && (string = dbChar.value.substring(i, i + 4)).toUpperCase().equals("/CN=") && (string2 = dbChar.value.substring(i + 4, dbChar.value.length())).toUpperCase().indexOf("/CN=") == -1); ++i) {
                }
                ((DbChar)this.cache[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf("DDA:SMTP=") != -1) {
                for (int i = 3; i < dbChar.value.length(); ++i) {
                    if (dbChar.value.charAt(i) != ':' || !(string = dbChar.value.substring(i - 3, i + 6)).toUpperCase().equals("DDA:SMTP=")) continue;
                    string2 = dbChar.value.substring(i + 6, dbChar.value.length());
                    break;
                }
                ((DbChar)this.cache[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf("DDA:MS=") != -1) {
                for (int i = 3; i < dbChar.value.length(); ++i) {
                    if (dbChar.value.charAt(i) != ':' || !(string = dbChar.value.substring(i - 3, i + 4)).toUpperCase().equals("DDA:MS=")) continue;
                    string2 = dbChar.value.substring(i + 4, dbChar.value.length());
                    break;
                }
                ((DbChar)this.cache[5]).value = string2;
            } else {
                ((DbChar)this.cache[5]).value = "";
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ExchGetOrganization(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            String string3 = "";
            if (dbChar.value.toUpperCase().indexOf("/O=") != -1) {
                int n;
                for (n = 0; n < dbChar.value.length(); ++n) {
                    if (dbChar.value.charAt(n) != '/' || !(string = dbChar.value.substring(n, n + 3)).toUpperCase().equals("/O=")) continue;
                    string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                    break;
                }
                for (n = 0; n < string3.length() && string3.charAt(n) != '/'; ++n) {
                    string2 = string2 + string3.charAt(n);
                }
                ((DbChar)this.cache[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf(";P=") != -1) {
                int n;
                for (n = 0; n < dbChar.value.length(); ++n) {
                    if (dbChar.value.charAt(n) != ';' || !(string = dbChar.value.substring(n, n + 3)).toUpperCase().equals(";P=")) continue;
                    string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                    break;
                }
                for (n = 0; n < string3.length() && string3.charAt(n) != ';'; ++n) {
                    string2 = string2 + string3.charAt(n);
                }
                ((DbChar)this.cache[5]).value = string2;
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ExchGetSite(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = "";
            String string2 = "";
            String string3 = "";
            if (dbChar.value.toUpperCase().indexOf("/OU=") != -1) {
                int n;
                for (n = 0; n < dbChar.value.length(); ++n) {
                    if (dbChar.value.charAt(n) != '/' || !(string = dbChar.value.substring(n, n + 4)).toUpperCase().equals("/OU=")) continue;
                    string3 = dbChar.value.substring(n + 4, dbChar.value.length());
                    break;
                }
                for (n = 0; n < string3.length() && string3.charAt(n) != '/'; ++n) {
                    string2 = string2 + string3.charAt(n);
                }
                ((DbChar)this.cache[5]).value = string2;
            } else if (dbChar.value.toUpperCase().indexOf(";O=") != -1) {
                int n;
                for (n = 0; n < dbChar.value.length(); ++n) {
                    if (dbChar.value.charAt(n) != ';' || !(string = dbChar.value.substring(n, n + 3)).toUpperCase().equals(";O=")) continue;
                    string3 = dbChar.value.substring(n + 3, dbChar.value.length());
                    break;
                }
                for (n = 0; n < string3.length() && string3.charAt(n) != ';'; ++n) {
                    string2 = string2 + string3.charAt(n);
                }
                ((DbChar)this.cache[5]).value = string2;
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar ExchGetPath(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = "";
            int n = 0;
            int n2 = 0;
            if (dbChar.value.toUpperCase().indexOf("CN=") != -1) {
                String string2;
                int n3;
                for (n3 = 2; n3 < dbChar.value.length(); ++n3) {
                    if (dbChar.value.toUpperCase().charAt(n3) != '=' || !(string = dbChar.value.substring(n3 - 2, n3 + 1)).toUpperCase().equals("CN=") || (string2 = dbChar.value.substring(n3 + 1, dbChar.value.length())).toUpperCase().indexOf("CN=") != -1) continue;
                    n = n3 - 3;
                }
                for (n3 = 2; n3 < dbChar.value.length(); ++n3) {
                    if (dbChar.value.toUpperCase().charAt(n3) != '=' || !(string = dbChar.value.substring(n3 - 2, n3 + 1)).toUpperCase().equals("CN=")) continue;
                    string2 = dbChar.value.substring(n3 + 1, dbChar.value.length());
                    if (string2.toUpperCase().indexOf("CN=") == -1) {
                        ((DbChar)this.cache[5]).value = "";
                        continue;
                    }
                    ((DbChar)this.cache[5]).value = dbChar.value.substring(n3 - 2, n);
                    break;
                }
            } else if (dbChar.value.toUpperCase().indexOf("P=") != -1 & dbChar.value.toUpperCase().indexOf("O=") != -1) {
                block2: for (int i = 1; i < dbChar.value.length(); ++i) {
                    if (dbChar.value.charAt(i) != '=') continue;
                    string = dbChar.value.substring(i - 1, i + 1);
                    if (string.toUpperCase().equals("P=")) {
                        String string3 = dbChar.value.substring(i + 1, dbChar.value.length());
                        for (int j = 0; j < string3.length(); ++j) {
                            if (string3.charAt(j) != ';') continue;
                            n = i + 1 + j + 1;
                            continue block2;
                        }
                        continue;
                    }
                    if (!string.toUpperCase().equals("O=")) continue;
                    n2 = i - 1;
                }
                if (n != 0 & n < n2) {
                    ((DbChar)this.cache[5]).value = dbChar.value.substring(n, n2);
                }
            } else if (dbChar.value.toUpperCase().indexOf("DDA:") != -1) {
                for (int i = 3; i < dbChar.value.length(); ++i) {
                    if (dbChar.value.charAt(i) != ':' || !(string = dbChar.value.substring(i - 3, i + 1)).toUpperCase().equals("DDA:")) continue;
                    ((DbChar)this.cache[5]).value = dbChar.value.substring(i + 1, dbChar.value.length());
                    break;
                }
            } else {
                ((DbChar)this.cache[5]).value = "UNKNOWN ADDRESS TYPE";
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbBit IsDate(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[4].bNull = true;
        } else {
            this.gc.clear();
            this.gc.set(1900, 0, (int)dbDouble.value, 0, 0, 0);
            int n = this.gc.get(1);
            ((DbBit)this.cache[4]).value = n >= 100 && n <= 9999;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbDate ToDate(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[6].bNull = true;
        } else if (this.IsDate((DbDouble)dbDouble).value) {
            this.gc.clear();
            this.gc.set(1900, 0, (int)dbDouble.value, 0, 0, 0);
            ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
            this.cache[6].bNull = false;
        } else {
            this.cache[6].bNull = true;
        }
        return (DbDate)this.cache[6];
    }

    public DbBit IsTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[7].bNull = true;
        } else if (this.IsDate((DbDouble)dbDouble).value) {
            float f;
            int n;
            float f2;
            int n2;
            int n3;
            float f3 = (float)(dbDouble.value - (double)((int)dbDouble.value));
            if (f3 < 0.0f) {
                f3 = 1.0f + f3;
            }
            if ((n3 = (int)(f3 * 24.0f)) < 24 & n3 >= 0 & (n2 = (int)((f2 = f3 * 24.0f - (float)n3) * 60.0f)) <= 59 & n2 >= 0 & (n = (int)((f = f2 * 60.0f - (float)n2) * 60.0f)) <= 59 & n2 >= 0) {
                ((DbBit)this.cache[4]).value = true;
                this.cache[7].bNull = false;
            } else {
                ((DbBit)this.cache[4]).value = false;
            }
        } else {
            ((DbBit)this.cache[4]).value = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbTime ToTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[6].bNull = true;
        } else if (this.IsTime((DbDouble)dbDouble).value) {
            float f = (float)(dbDouble.value - (double)((int)dbDouble.value));
            if (f < 0.0f) {
                f = 1.0f + f;
            }
            int n = (int)(f * 24.0f);
            float f2 = f * 24.0f - (float)n;
            int n2 = (int)(f2 * 60.0f);
            float f3 = f2 * 60.0f - (float)n2;
            int n3 = (int)(f3 * 60.0f);
            this.gc.clear();
            this.gc.set(11, n);
            this.gc.set(12, n2);
            this.gc.set(13, n3);
            ((DbTime)this.cache[7]).value = this.gc.getTimeInLong();
            this.cache[7].bNull = false;
        } else {
            this.cache[7].bNull = true;
        }
        return (DbTime)this.cache[7];
    }

    public DbBit IsDateTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = this.IsTime((DbDouble)dbDouble).value;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbTimestamp ToDateTime(DbDate dbDate) {
        if (dbDate.bNull) {
            this.cache[8].bNull = true;
        } else {
            ((DbTimestamp)this.cache[8]).value = dbDate.value;
            this.cache[8].bNull = false;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbTimestamp DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbBigInt.bNull || dbTimestamp.bNull) {
            this.cache[8].bNull = true;
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dbTimestamp.getTimestamp());
            int n = 0;
            String string = dbChar.value;
            if (string.equalsIgnoreCase("yyyy")) {
                n = (int)((long)(1900 + dbTimestamp.getTimestamp().getYear()) + dbBigInt.value);
                calendar.set(1, n);
            } else if (string.equalsIgnoreCase("q")) {
                calendar.add(2, (int)dbBigInt.value * 3);
            } else if (string.equalsIgnoreCase("m")) {
                calendar.add(2, (int)dbBigInt.value);
            } else if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("w")) {
                n = (int)((long)dbTimestamp.getTimestamp().getDate() + dbBigInt.value);
                calendar.set(5, n);
            } else if (string.equalsIgnoreCase("ww")) {
                n = (int)((long)dbTimestamp.getTimestamp().getDate() + dbBigInt.value * 7L);
                calendar.set(5, n);
            } else if (string.equalsIgnoreCase("h")) {
                n = (int)((long)dbTimestamp.getTimestamp().getHours() + dbBigInt.value);
                calendar.set(11, n);
            } else if (string.equalsIgnoreCase("n")) {
                n = (int)((long)dbTimestamp.getTimestamp().getMinutes() + dbBigInt.value);
                calendar.set(12, n);
            } else if (string.equalsIgnoreCase("s")) {
                n = (int)((long)dbTimestamp.getTimestamp().getSeconds() + dbBigInt.value);
                calendar.set(13, n);
            }
            this.cache[8].bNull = false;
            ((DbTimestamp)this.cache[8]).value = calendar.getTimeInMillis();
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTimestamp2.bNull) {
            this.cache[1].bNull = true;
        } else {
            String string = dbChar.value;
            if (string.equalsIgnoreCase("yyyy")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n2 = dbTimestamp2.getTimestamp().getYear();
                ((DbBigInt)this.cache[1]).value = n2 - n;
            } else if (string.equalsIgnoreCase("q")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n3 = dbTimestamp2.getTimestamp().getYear();
                int n4 = dbTimestamp.getTimestamp().getMonth();
                int n5 = dbTimestamp2.getTimestamp().getMonth();
                int n6 = 0;
                int n7 = 0;
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n6 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n6 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n6 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n6 = 4;
                    }
                }
                switch (n5) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n7 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n7 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n7 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n7 = 4;
                    }
                }
                ((DbBigInt)this.cache[1]).value = (n3 - n) * 4 + (n7 - n6);
            } else if (string.equalsIgnoreCase("m")) {
                int n = dbTimestamp.getTimestamp().getYear();
                int n8 = dbTimestamp2.getTimestamp().getYear();
                int n9 = dbTimestamp.getTimestamp().getMonth();
                int n10 = dbTimestamp2.getTimestamp().getMonth();
                ((DbBigInt)this.cache[1]).value = (n8 - n) * 12 + (n10 - n9);
            } else if (string.equalsIgnoreCase("d") || string.equalsIgnoreCase("y")) {
                this.Day(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("w")) {
                int n = (int)this.Day((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                ((DbBigInt)this.cache[1]).value = n / 7;
            } else if (string.equalsIgnoreCase("ww")) {
                int n = (int)this.Day((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                DbChar dbChar2 = new DbChar();
                dbChar2.setValue("jrSunday");
                DbBigInt dbBigInt = this.DateDiff(dbChar, dbTimestamp, dbTimestamp2, dbChar2);
                ((DbBigInt)this.cache[1]).value = dbBigInt.longValue();
            } else if (string.equalsIgnoreCase("h")) {
                this.DatePart(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("n")) {
                this.DateDiff(dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("s")) {
                this.DateAdd(dbTimestamp, dbTimestamp2);
            }
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2, DbChar dbChar2) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbTimestamp2.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("w") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DateDiff(dbChar, dbTimestamp, dbTimestamp2);
            } else if (string.equalsIgnoreCase("ww")) {
                int n = (int)this.Day((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
                int n2 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp).value;
                int n3 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp2).value;
                int n4 = (n - (7 - n2) - n3) / 7;
                String string2 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n5 = new Integer(string2);
                int n6 = n5;
                int n7 = 0;
                if (n6 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    n7 = dbDate.getDate().getDay() + 1;
                } else {
                    n7 = n6;
                }
                int n8 = 0;
                if (n2 < n7 & n3 >= n7) {
                    n8 = n4 + 2;
                } else if (n2 >= n7 & n3 >= n7 || n2 < n7 & n3 < n7) {
                    n8 = n4 + 1;
                } else if (n2 >= n7 & n3 < n7) {
                    n8 = n4;
                }
                dbBigInt.set(n8);
            }
        }
        return dbBigInt;
    }

    private DbBigInt DateAdd(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.DateDiff((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(13);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(13);
        ((DbBigInt)this.cache[1]).value = n * 60 + (n3 - n2);
        return (DbBigInt)this.cache[1];
    }

    private DbBigInt DateDiff(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.DatePart((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(12);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(12);
        ((DbBigInt)this.cache[1]).value = n * 60 + (n3 - n2);
        return (DbBigInt)this.cache[1];
    }

    private DbBigInt DatePart(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        int n = (int)this.Day((DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n2 = this.gc.get(11);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(11);
        ((DbBigInt)this.cache[1]).value = n * 24 + (n3 - n2);
        return (DbBigInt)this.cache[1];
    }

    private DbBigInt Day(DbTimestamp dbTimestamp, DbTimestamp dbTimestamp2) {
        this.gc.clear();
        this.gc.setTime(dbTimestamp.getTimestamp());
        int n = this.gc.get(1);
        int n2 = this.gc.get(6);
        this.gc.clear();
        this.gc.setTime(dbTimestamp2.getTimestamp());
        int n3 = this.gc.get(1);
        int n4 = this.gc.get(6);
        if (n == n3) {
            ((DbBigInt)this.cache[1]).value = n4 - n2;
        } else if (n3 > n) {
            int n5 = 0;
            n5 = this.gc.isLeapYear(n) ? 366 - n2 : 365 - n2;
            int n6 = 0;
            for (int i = n + 1; i < n3; ++i) {
                int n7 = 0;
                n7 = this.gc.isLeapYear(i) ? 366 : 365;
                n6 += n7;
            }
            ((DbBigInt)this.cache[1]).value = n6 + n5 + n4;
        } else {
            int n8 = 0;
            n8 = this.gc.isLeapYear(n3) ? 366 - n4 : 365 - n4;
            int n9 = 0;
            for (int i = n3 + 1; i < n; ++i) {
                int n10 = 0;
                n10 = this.gc.isLeapYear(i) ? 366 : 365;
                n9 += n10;
            }
            ((DbBigInt)this.cache[1]).value = -(n9 + n8 + n2);
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy")) {
                dbBigInt = this.Year(dbTimestamp);
            } else if (string.equalsIgnoreCase("q")) {
                int n = dbTimestamp.getTimestamp().getMonth();
                int n2 = 0;
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n2 = 3;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        n2 = 4;
                    }
                }
                ((DbBigInt)this.cache[1]).value = n2;
                this.cache[1].bNull = false;
                dbBigInt = (DbBigInt)this.cache[1];
            } else if (string.equalsIgnoreCase("m")) {
                dbBigInt = this.Month(dbTimestamp);
            } else if (string.equalsIgnoreCase("y")) {
                this.gc.setTime(dbTimestamp.getTimestamp());
                ((DbBigInt)this.cache[1]).value = this.gc.get(6);
                this.cache[1].bNull = false;
                dbBigInt = (DbBigInt)this.cache[1];
            } else if (string.equalsIgnoreCase("d")) {
                dbBigInt = this.Day(dbTimestamp);
            } else if (string.equalsIgnoreCase("w")) {
                dbBigInt = this.DayOfWeek(dbTimestamp);
            } else if (string.equalsIgnoreCase("ww")) {
                dbBigInt = this.WeekOfYear(dbTimestamp);
            } else if (string.equalsIgnoreCase("h")) {
                dbBigInt = this.Hour(dbTimestamp);
            } else if (string.equalsIgnoreCase("n")) {
                dbBigInt = this.Minute(dbTimestamp);
            } else if (string.equalsIgnoreCase("s")) {
                dbBigInt = this.Second(dbTimestamp);
            }
        }
        return dbBigInt;
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp, DbChar dbChar2) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DatePart(dbChar, dbTimestamp);
            } else if (string.equalsIgnoreCase("w")) {
                int n = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp).value;
                String string2 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n2 = new Integer(string2);
                int n3 = n2;
                int n4 = 0;
                if (n3 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    int n5 = dbDate.getDate().getDay();
                    n4 = (n - n5 + 7) % 7;
                } else {
                    n4 = (n - (n3 - 1) + 7) % 7;
                }
                if (n4 == 0) {
                    n4 += 7;
                }
                dbBigInt.set(n4);
            } else if (string.equalsIgnoreCase("ww")) {
                int n;
                int n6 = (int)this.DayOfWeek((DbTimestamp)dbTimestamp).value;
                int n7 = (int)this.WeekOfYear((DbTimestamp)dbTimestamp).value;
                String string3 = (String)firstdayOfWeek.get(dbChar2.toString().toUpperCase());
                Integer n8 = new Integer(string3);
                int n9 = n8;
                if (n9 == 0) {
                    DbDate dbDate = this.CurrentDate();
                    n = dbDate.getDate().getDay() + 1;
                } else {
                    n = n9;
                }
                int n10 = 0;
                if (n6 - (n - 1) > 0) {
                    n10 = n7;
                } else if (n6 - (n - 1) <= 0) {
                    n10 = n7 - 1;
                }
                this.gc.clear();
                this.gc.setTime(dbTimestamp.getTimestamp());
                int n11 = this.gc.get(1);
                this.gc.clear();
                this.gc.setTime(this.ToDate(new DbBigInt(n11), new DbBigInt(1L), new DbBigInt(1L)).getDate());
                int n12 = this.gc.get(7);
                int n13 = n12 >= n ? n10 : n10 + 1;
                dbBigInt.set(n13);
            }
            this.cache[1].bNull = false;
        }
        return dbBigInt;
    }

    public DbBigInt DatePart(DbChar dbChar, DbTimestamp dbTimestamp, DbChar dbChar2, DbChar dbChar3) {
        DbBigInt dbBigInt = new DbBigInt();
        if (dbChar.bNull || dbTimestamp.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[1].bNull = true;
        } else {
            String string = dbChar.toString();
            if (string.equalsIgnoreCase("yyyy") || string.equalsIgnoreCase("q") || string.equalsIgnoreCase("m") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("d") || string.equalsIgnoreCase("w") || string.equalsIgnoreCase("h") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("s")) {
                dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
            } else if (string.equalsIgnoreCase("ww")) {
                String string2 = dbChar3.toString();
                if (string2.equalsIgnoreCase("jrFirstJan1")) {
                    dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                } else if (string2.equalsIgnoreCase("jrFirstFourDays")) {
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp.getTimestamp());
                    int n = this.gc.get(1);
                    DbTimestamp dbTimestamp2 = this.ToDateTime(new DbBigInt(n), new DbBigInt(1L), new DbBigInt(1L));
                    int n2 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
                    if (7 - n2 + 1 < 4) {
                        dbBigInt.set(this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value - 1L);
                    } else {
                        dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                    }
                } else if (string2.equalsIgnoreCase("jrFirstFullWeek")) {
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp.getTimestamp());
                    int n = this.gc.get(1);
                    DbTimestamp dbTimestamp3 = this.ToDateTime(new DbBigInt(n), new DbBigInt(1L), new DbBigInt(1L));
                    int n3 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp3, (DbChar)dbChar2).value;
                    if (n3 == 1) {
                        dbBigInt = this.DatePart(dbChar, dbTimestamp, dbChar2);
                    } else {
                        dbBigInt.set(this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value - 1L);
                    }
                } else if (string2.equalsIgnoreCase("JRUSESYSTEM")) {
                    DbTimestamp dbTimestamp4 = this.CurrentDateTime();
                    this.gc.clear();
                    this.gc.setTime(dbTimestamp4.getTimestamp());
                    int n = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp4, (DbChar)dbChar2).value;
                    int n4 = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
                    DbTimestamp dbTimestamp5 = this.ToDateTime(new DbBigInt(this.gc.get(1)), new DbBigInt(1L), new DbBigInt(1L));
                    int n5 = (int)this.DatePart((DbChar)new DbChar((String)"w"), (DbTimestamp)dbTimestamp5, (DbChar)dbChar2).value;
                    int n6 = (int)this.DatePart((DbChar)dbChar, (DbTimestamp)this.ToDateTime((DbBigInt)new DbBigInt((long)((long)this.gc.get((int)1))), (DbBigInt)new DbBigInt((long)1L), (DbBigInt)new DbBigInt((long)((long)(1 - n5)))), (DbChar)dbChar2).value;
                    if (n4 >= n) {
                        dbBigInt.set(n4 - n + 1);
                    } else {
                        dbBigInt.set(n6 - (n - n4));
                    }
                }
            }
            this.cache[1].bNull = false;
        }
        return dbBigInt;
    }

    public DbChar MonthName(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbBigInt.toString();
            ((DbChar)this.cache[5]).value = (String)Hour.get(string);
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar MonthName(DbBigInt dbBigInt, DbBit dbBit) {
        if (dbBigInt.bNull || dbBit.bNull) {
            this.cache[5].bNull = true;
        } else {
            if (dbBit.value) {
                String string = dbBigInt.toString();
                ((DbChar)this.cache[5]).value = (String)IPmt.get(string);
            } else {
                String string = dbBigInt.toString();
                ((DbChar)this.cache[5]).value = (String)Hour.get(string);
            }
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbBigInt Timer() {
        DbTime dbTime = this.CurrentTime();
        MyCalendar myCalendar = new MyCalendar();
        int n = dbTime.getTime().getHours();
        int n2 = dbTime.getTime().getMinutes();
        int n3 = dbTime.getTime().getSeconds();
        int n4 = n * 3600 + n2 * 60 + n3;
        ((DbBigInt)this.cache[1]).set(n4);
        this.cache[1].bNull = false;
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt UBound(fArray fArray2) {
        if (fArray2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = fArray2.isAll() ? 0L : (long)fArray2.value.length;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbBigInt.toString();
            ((DbChar)this.cache[5]).value = (String)weekdayToName.get(string);
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt, DbBit dbBit) {
        if (dbBigInt.bNull || dbBit.bNull) {
            this.cache[5].bNull = true;
        } else {
            String string = dbBigInt.toString();
            String string2 = "";
            string2 = dbBit.value ? (String)weekdayToAbbr.get(string) : (String)weekdayToName.get(string);
            if (string2 == null) {
                this.cache[5].bNull = true;
            } else {
                ((DbChar)this.cache[5]).value = string2;
                this.cache[5].bNull = false;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbChar WeekdayName(DbBigInt dbBigInt, DbBit dbBit, DbChar dbChar) {
        if (dbBigInt.bNull || dbBit.bNull || dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n;
            String string = dbChar.value;
            String string2 = (String)firstdayOfWeek.get(string.toUpperCase());
            Integer n2 = new Integer(string2);
            int n3 = n2;
            boolean bl = false;
            if (n3 == 0) {
                Calendar calendar = Calendar.getInstance();
                n3 = calendar.get(7);
            }
            if ((n = (int)(((long)n3 + dbBigInt.value - 1L) % 7L)) == 0) {
                n = 7;
            }
            DbBigInt dbBigInt2 = new DbBigInt();
            dbBigInt2.set(n);
            String string3 = dbBigInt2.toString();
            String string4 = "";
            string4 = dbBit.value ? (String)weekdayToAbbr.get(string3) : (String)weekdayToName.get(string3);
            if (string4 == null) {
                this.cache[5].bNull = true;
            } else {
                ((DbChar)this.cache[5]).value = string4;
                this.cache[5].bNull = false;
            }
        }
        return (DbChar)this.cache[5];
    }

    public DbTimestamp ToDateTime(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[8].bNull = true;
        } else if (this.IsDateTime((DbDouble)dbDouble).value) {
            DbDate dbDate = this.ToDate(dbDouble);
            DbTime dbTime = this.ToTime(dbDouble);
            this.gc.setTime(dbTime.getTime());
            this.gc.computeTime();
            int n = this.gc.get(11);
            int n2 = this.gc.get(12);
            int n3 = this.gc.get(13);
            this.gc.setTime(dbDate.getDate());
            this.gc.computeTime();
            this.gc.setHMS(n, n2, n3);
            ((DbTimestamp)this.cache[8]).value = this.gc.getTimeInLong();
            ((DbTimestamp)this.cache[8]).nanos = 0;
            this.cache[8].bNull = false;
        } else {
            this.cache[8].bNull = true;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbBit IsDate(DbChar dbChar) {
        return this.IsDateTime(dbChar);
    }

    public DbDate ToDate(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[6].bNull = true;
        } else if (this.DayOfWeek((DbChar)dbChar).value) {
            ((DbDate)this.cache[6]).value = this.GERMAN((DbChar)dbChar).value;
            this.cache[6].bNull = false;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            ((DbDate)this.cache[6]).value = this.ToDate((DbTimestamp)this.ForEachYear((DbChar)dbChar)).value;
            this.cache[6].bNull = false;
        } else {
            this.cache[6].bNull = true;
        }
        return (DbDate)this.cache[6];
    }

    public DbBit IsTime(DbChar dbChar) {
        return this.ForEachWeek(dbChar);
    }

    public DbTime ToTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[7].bNull = true;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            ((DbTime)this.cache[7]).value = this.ToTime((DbTimestamp)this.ForEachYear((DbChar)dbChar)).value;
            this.cache[7].bNull = false;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            ((DbTime)this.cache[7]).value = this.Hour((DbChar)dbChar).value;
            this.cache[7].bNull = false;
        } else if (this.DayOfWeek((DbChar)dbChar).value) {
            this.gc.clear();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            ((DbTime)this.cache[7]).value = this.gc.getTimeInLong();
            this.cache[7].bNull = false;
        } else {
            this.cache[7].bNull = true;
        }
        return (DbTime)this.cache[7];
    }

    public DbBit IsDateTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = this.ForEachWeek((DbChar)dbChar).value ? true : (this.DayOfWeek((DbChar)dbChar).value ? true : this.ForEachQuarter((DbChar)dbChar).value);
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbTimestamp ToDateTime(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[8].bNull = true;
        } else if (this.ForEachQuarter((DbChar)dbChar).value) {
            ((DbTimestamp)this.cache[8]).value = this.ForEachYear((DbChar)dbChar).value;
            this.cache[8].bNull = false;
        } else if (this.DayOfWeek((DbChar)dbChar).value) {
            ((DbTimestamp)this.cache[8]).value = this.ToDateTime((DbDate)this.GERMAN((DbChar)dbChar)).value;
            this.cache[8].bNull = false;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            ((DbTimestamp)this.cache[8]).value = this.ToDateTime((DbDate)this.CurrentDate(), (DbTime)this.Hour((DbChar)dbChar)).value;
            this.cache[8].bNull = false;
        } else {
            this.cache[8].bNull = true;
        }
        return (DbTimestamp)this.cache[8];
    }

    public DbBigInt DTSToSeconds(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[1].bNull = true;
        } else {
            if (this.IsDateTime((DbChar)dbChar).value) {
                DbTimestamp dbTimestamp = new DbTimestamp();
                dbTimestamp.set(this.ToDateTime(dbChar));
                int n = dbTimestamp.getTimestamp().getHours();
                int n2 = dbTimestamp.getTimestamp().getMinutes();
                int n3 = dbTimestamp.getTimestamp().getSeconds();
                ((DbBigInt)this.cache[1]).value = n * 3600 + n2 * 60 + n3;
            } else {
                ((DbBigInt)this.cache[1]).value = 0L;
            }
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbTimestamp DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbDate dbDate) {
        return this.DateAdd(dbChar, dbBigInt, this.ToDateTime(dbDate));
    }

    public DbTime DateAdd(DbChar dbChar, DbBigInt dbBigInt, DbTime dbTime) {
        DbTimestamp dbTimestamp = new DbTimestamp();
        dbTimestamp.set(dbTime.get());
        DbTimestamp dbTimestamp2 = this.DateAdd(dbChar, dbBigInt, dbTimestamp);
        ((DbTime)this.cache[7]).value = dbTimestamp2.get();
        this.cache[7].bNull = dbTimestamp2.isNull();
        return (DbTime)this.cache[7];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbDate dbDate2) {
        if (dbChar.bNull || dbDate.bNull || dbDate2.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            dbTimestamp2.set(this.ToDateTime(dbDate2));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbDate dbDate) {
        if (dbChar.bNull || dbTimestamp.bNull || dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbDate.bNull || dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp2, (DbTimestamp)dbTimestamp).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTime dbTime) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTime dbTime) {
        if (dbChar.bNull || dbDate.bNull || dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTimestamp dbTimestamp) {
        if (dbChar.bNull || dbTime.bNull || dbTimestamp.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbDate dbDate) {
        if (dbChar.bNull || dbTime.bNull || dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTime dbTime2) {
        if (dbChar.bNull || dbTime.bNull || dbTime2.bNull) {
            this.cache[1].bNull = true;
        } else {
            if (dbChar.value.equalsIgnoreCase("yyyy") || dbChar.value.equalsIgnoreCase("q") || dbChar.value.equalsIgnoreCase("m") || dbChar.value.equalsIgnoreCase("y") || dbChar.value.equalsIgnoreCase("d") || dbChar.value.equalsIgnoreCase("w") || dbChar.value.equalsIgnoreCase("ww")) {
                ((DbBigInt)this.cache[1]).value = 0L;
            } else if (dbChar.value.equalsIgnoreCase("h")) {
                int n = dbTime.getTime().getHours();
                int n2 = dbTime2.getTime().getHours();
                ((DbBigInt)this.cache[1]).value = n2 - n;
            } else if (dbChar.value.equalsIgnoreCase("n")) {
                int n = dbTime.getTime().getHours();
                int n3 = dbTime2.getTime().getHours();
                int n4 = dbTime.getTime().getMinutes();
                int n5 = dbTime2.getTime().getMinutes();
                ((DbBigInt)this.cache[1]).value = (n3 - n) * 60 + (n5 - n4);
            } else if (dbChar.value.equalsIgnoreCase("s")) {
                int n = dbTime.getTime().getHours();
                int n6 = dbTime2.getTime().getHours();
                int n7 = dbTime.getTime().getMinutes();
                int n8 = dbTime2.getTime().getMinutes();
                int n9 = dbTime.getTime().getSeconds();
                int n10 = dbTime2.getTime().getSeconds();
                ((DbBigInt)this.cache[1]).value = (n6 - n) * 3600 + (n8 - n7) * 60 + (n10 - n9);
            }
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbDate dbDate2, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbDate2.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate2));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTimestamp dbTimestamp, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp2, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbDate.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp2 = new DbTimestamp();
            dbTimestamp2.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbTimestamp)dbTimestamp2, (DbChar)dbChar2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTimestamp dbTimestamp, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbTimestamp.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTimestamp dbTimestamp, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbTimestamp.bNull || dbTime.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbDate dbDate, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbTime.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbDate.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = 0L;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DateDiff(DbChar dbChar, DbTime dbTime, DbTime dbTime2, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbTime2.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = this.DateDiff((DbChar)dbChar, (DbTime)dbTime, (DbTime)dbTime2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate) {
        if (dbChar.bNull || dbDate.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = new DbTimestamp();
            dbTimestamp.set(this.ToDateTime(dbDate));
            ((DbBigInt)this.cache[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime) {
        if (dbChar.bNull || dbTime.bNull) {
            this.cache[1].bNull = true;
        } else {
            if (dbChar.value.equalsIgnoreCase("yyyy") || dbChar.value.equalsIgnoreCase("q") || dbChar.value.equalsIgnoreCase("m") || dbChar.value.equalsIgnoreCase("y") || dbChar.value.equalsIgnoreCase("d") || dbChar.value.equalsIgnoreCase("w") || dbChar.value.equalsIgnoreCase("ww")) {
                ((DbBigInt)this.cache[1]).value = 0L;
            } else if (dbChar.value.equalsIgnoreCase("h")) {
                ((DbBigInt)this.cache[1]).value = this.Hour((DbTime)dbTime).value;
            } else if (dbChar.value.equalsIgnoreCase("n")) {
                ((DbBigInt)this.cache[1]).value = this.Minute((DbTime)dbTime).value;
            } else if (dbChar.value.equalsIgnoreCase("s")) {
                ((DbBigInt)this.cache[1]).value = this.Second((DbTime)dbTime).value;
            }
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate, DbChar dbChar2) {
        if (dbChar.bNull || dbDate.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = this.ToDateTime(dbDate);
            ((DbBigInt)this.cache[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime, DbChar dbChar2) {
        if (dbChar.bNull || dbTime.bNull || dbChar2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = this.DatePart((DbChar)dbChar, (DbTime)dbTime).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbDate dbDate, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbDate.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[1].bNull = true;
        } else {
            DbTimestamp dbTimestamp = this.ToDateTime(dbDate);
            ((DbBigInt)this.cache[1]).value = this.DatePart((DbChar)dbChar, (DbTimestamp)dbTimestamp, (DbChar)dbChar2, (DbChar)dbChar3).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt DatePart(DbChar dbChar, DbTime dbTime, DbChar dbChar2, DbChar dbChar3) {
        if (dbChar.bNull || dbTime.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = this.DatePart((DbChar)dbChar, (DbTime)dbTime).value;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    private DbBit DayOfWeek(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            java.util.Date date;
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            for (int i = 0; i < dateFormats.length; ++i) {
                dateTimeParser.applyPattern(dateFormats[i]);
                try {
                    java.util.Date date2 = dateTimeParser.parse(string);
                    if (date2 == null) continue;
                    int n = dateTimeParser.getYear();
                    int n2 = dateTimeParser.getMonth();
                    int n3 = dateTimeParser.getDate();
                    this.gc.clear();
                    this.gc.setTime(date2);
                    if (dateTimeParser.hasYearField() && dateTimeParser.hasMonthField() && dateTimeParser.hasDateField()) {
                        if (this.gc.get(1) == n && this.gc.get(2) == n2 - 1 && this.gc.get(5) == n3) {
                            bl = true;
                            break;
                        }
                        bl2 = false;
                        bl3 = false;
                        continue;
                    }
                    if (bl3 && dateTimeParser.hasMonthField() && dateTimeParser.hasDateField()) {
                        if (this.gc.get(2) != n2 - 1) continue;
                        bl = true;
                        break;
                    }
                    if (bl2 && dateTimeParser.hasYearField() && dateTimeParser.hasMonthField()) {
                        if (this.gc.get(1) != n || this.gc.get(2) != n2 - 1 || this.gc.get(5) != 1) continue;
                        bl = true;
                        break;
                    }
                    bl = false;
                    continue;
                }
                catch (ParseException parseException) {
                    bl = false;
                }
            }
            if (!bl && null != (date = this.FRANCE(dbChar.value, this.gc))) {
                bl = true;
            }
            ((DbBit)this.cache[4]).value = bl;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.Date FRANCE(String string, MyCalendar myCalendar) {
        Vector vector = IsDateTime;
        synchronized (vector) {
            for (DateFormat dateFormat : IsDateTime) {
                ParsePosition parsePosition = new ParsePosition(0);
                dateFormat.setCalendar(myCalendar);
                java.util.Date date = dateFormat.parse(string, parsePosition);
                if (date == null || parsePosition.getIndex() != string.length()) continue;
                return date;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.Date FV(String string, MyCalendar myCalendar) {
        Vector vector = IsTime;
        synchronized (vector) {
            for (DateFormat dateFormat : IsTime) {
                ParsePosition parsePosition = new ParsePosition(0);
                dateFormat.setCalendar(myCalendar);
                java.util.Date date = dateFormat.parse(string, parsePosition);
                if (date == null || parsePosition.getIndex() != string.length()) continue;
                return date;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.Date ForEachMonth(String string, MyCalendar myCalendar) {
        Vector vector = JAPAN;
        synchronized (vector) {
            for (DateFormat dateFormat : JAPAN) {
                ParsePosition parsePosition = new ParsePosition(0);
                dateFormat.setCalendar(myCalendar);
                java.util.Date date = dateFormat.parse(string, parsePosition);
                if (date == null || parsePosition.getIndex() != string.length()) continue;
                return date;
            }
        }
        return null;
    }

    private DbBit ForEachQuarter(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            java.util.Date date;
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = "";
            String string3 = "";
            int n = 1;
            for (int i = 0; i < datetimeFormats.length; ++i) {
                dateTimeParser.applyPattern(datetimeFormats[i]);
                ParsePosition parsePosition = new ParsePosition(0);
                try {
                    java.util.Date date2 = dateTimeParser.parse(string, parsePosition);
                    if (date2 == null) continue;
                    if (parsePosition.getIndex() != string.length()) {
                        throw new ParseException("Unparseable date: \"" + string + "\"", parsePosition.getErrorIndex());
                    }
                    while (!bl2 && !bl3 && n <= string.length()) {
                        string2 = string.substring(0, n).trim();
                        string3 = string.substring(n, string.length()).trim();
                        if (this.DayOfWeek((DbChar)new DbChar((String)string2)).value && this.ForEachWeek((DbChar)new DbChar((String)string3)).value) {
                            bl2 = true;
                            bl3 = true;
                        }
                        ++n;
                    }
                    if (bl2 && bl3) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    continue;
                }
                catch (ParseException parseException) {
                    bl = false;
                }
            }
            if (!bl && null != (date = this.ForEachMonth(dbChar.value, this.gc))) {
                bl = true;
            }
            ((DbBit)this.cache[4]).value = bl;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    private DbBit ForEachWeek(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            java.util.Date date;
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            boolean bl = false;
            for (int i = 0; i < timeFormats.length; ++i) {
                dateTimeParser.applyPattern(timeFormats[i]);
                try {
                    java.util.Date date2 = dateTimeParser.parse(string);
                    if (date2 == null) continue;
                    int n = dateTimeParser.getHour();
                    int n2 = dateTimeParser.getMinute();
                    int n3 = dateTimeParser.getSecond();
                    this.gc.clear();
                    this.gc.setTime(date2);
                    if (n >= 0 && n < 24 && n2 >= 0 && n2 <= 59 && n3 >= 0 && n3 <= 59) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    continue;
                }
                catch (ParseException parseException) {
                    bl = false;
                }
            }
            if (!bl && null != (date = this.FV(dbChar.value, this.gc))) {
                bl = true;
            }
            ((DbBit)this.cache[4]).value = bl;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    private DbTimestamp ForEachYear(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[8].bNull = true;
        } else {
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = "";
            String string3 = "";
            int n = 1;
            java.util.Date date = null;
            for (int i = 0; i < datetimeFormats.length; ++i) {
                dateTimeParser.applyPattern(datetimeFormats[i]);
                ParsePosition parsePosition = new ParsePosition(0);
                try {
                    date = dateTimeParser.parse(string, parsePosition);
                    if (date == null) continue;
                    if (parsePosition.getIndex() != string.length()) {
                        throw new ParseException("Unparseable date: \"" + string + "\"", parsePosition.getErrorIndex());
                    }
                    while (!bl2 && !bl3 && n <= string.length()) {
                        string2 = string.substring(0, n).trim();
                        string3 = string.substring(n, string.length()).trim();
                        if (this.DayOfWeek((DbChar)new DbChar((String)string2)).value && this.ForEachWeek((DbChar)new DbChar((String)string3)).value) {
                            bl2 = true;
                            bl3 = true;
                        }
                        ++n;
                    }
                    if (bl2 && bl3) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    continue;
                }
                catch (ParseException parseException) {
                    bl = false;
                }
            }
            if (bl) {
                long l = date.getTime();
                int n2 = (int)(l % 1000L * 1000000L);
                if (n2 < 0) {
                    n2 = 1000000000 + n2;
                }
                ((DbTimestamp)this.cache[8]).set(l / 1000L * 1000L, n2);
                this.cache[8].bNull = false;
            } else {
                this.cache[8].bNull = true;
            }
        }
        return (DbTimestamp)this.cache[8];
    }

    private DbDate GERMAN(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[6].bNull = true;
        } else if (this.DayOfWeek((DbChar)dbChar).value) {
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            java.util.Date date = null;
            for (int i = 0; i < dateFormats.length; ++i) {
                dateTimeParser.applyPattern(dateFormats[i]);
                try {
                    date = dateTimeParser.parse(string);
                    if (date == null || !this.DayOfWeek((DbChar)dbChar).value) continue;
                    ((DbDate)this.cache[6]).value = this.gc.getTimeInLong();
                    break;
                }
                catch (ParseException parseException) {
                    date = null;
                    this.cache[6].bNull = true;
                }
            }
            if (date == null) {
                date = this.FRANCE(dbChar.value, this.gc);
                if (null != date) {
                    ((DbDate)this.cache[6]).set(date.getTime());
                } else {
                    ((DbDate)this.cache[6]).bNull = true;
                }
            } else {
                ((DbDate)this.cache[6]).bNull = false;
            }
        }
        return (DbDate)this.cache[6];
    }

    private DbTime Hour(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[7].bNull = true;
        } else if (this.ForEachWeek((DbChar)dbChar).value) {
            DateTimeParser dateTimeParser = new DateTimeParser();
            if (this.tz != null) {
                dateTimeParser.setTimeZone(this.tz);
            }
            String string = dbChar.value.trim();
            java.util.Date date = null;
            for (int i = 0; i < timeFormats.length; ++i) {
                dateTimeParser.applyPattern(timeFormats[i]);
                try {
                    date = dateTimeParser.parse(string);
                    if (date == null) continue;
                    if (dateTimeParser.getAMPM() == 1 && dateTimeParser.getHour() >= 12) {
                        int n = dateTimeParser.getHour();
                        int n2 = dateTimeParser.getMinute();
                        int n3 = dateTimeParser.getSecond();
                        this.gc.clear();
                        this.gc.set(11, n);
                        this.gc.set(12, n2);
                        this.gc.set(13, n3);
                        ((DbTime)this.cache[7]).set(this.gc.getTimeInLong());
                        this.cache[7].bNull = false;
                        break;
                    }
                    this.gc.clear();
                    this.gc.setTime(date);
                    ((DbTime)this.cache[7]).set(this.gc.getTimeInLong());
                    this.cache[7].bNull = false;
                    break;
                }
                catch (ParseException parseException) {
                    date = null;
                }
            }
            if (null == date) {
                date = this.FV(dbChar.value, this.gc);
                if (null != date) {
                    ((DbTime)this.cache[7]).set(this.gc.getTimeInLong());
                } else {
                    ((DbTime)this.cache[7]).bNull = true;
                }
            }
        }
        return (DbTime)this.cache[7];
    }

    private int IPmt(int n, int n2, int n3) {
        int n4 = 0;
        switch (n2) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n4 = n3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                if (n3 >= 31) {
                    n4 = 30;
                    break;
                }
                n4 = n3;
                break;
            }
            case 1: {
                if (this.gc.isLeapYear(n)) {
                    if (n3 > 30) {
                        n4 = 29;
                        break;
                    }
                    n4 = n3;
                    break;
                }
                n4 = n3 > 29 ? 28 : n3;
            }
        }
        return n4;
    }

    public DbDouble e() {
        DbDouble dbDouble = new DbDouble(Math.E);
        dbDouble.bNull = false;
        this.cache[2].bNull = false;
        ((DbDouble)this.cache[2]).value = Math.E;
        return dbDouble;
    }

    public DbDouble pi() {
        DbDouble dbDouble = new DbDouble(Math.PI);
        dbDouble.bNull = false;
        this.cache[2].bNull = false;
        ((DbDouble)this.cache[2]).value = Math.PI;
        return dbDouble;
    }

    public DbDouble random() {
        return this.random(new DbBigInt(123L));
    }

    public DbDouble random(DbBigInt dbBigInt) {
        return this.random(dbBigInt.value);
    }

    public DbDouble random(DbDouble dbDouble) {
        return this.random((long)dbDouble.value);
    }

    public DbDouble random(fCurrency fCurrency2) {
        return this.random(fCurrency2.value.intValue());
    }

    private DbDouble random(long l) {
        if (l == 0L) {
            return this.LOCAL_LANGUAGE;
        }
        if (l > 0L) {
            ((DbDouble)this.cache[2]).value = this.KOREA.nextDouble();
            this.cache[2].bNull = false;
            this.LOCAL_LANGUAGE = (DbDouble)this.cache[2];
            return (DbDouble)this.cache[2];
        }
        this.KOREA.setSeed(l);
        ((DbDouble)this.cache[2]).value = this.KOREA.nextDouble();
        this.cache[2].bNull = false;
        this.LOCAL_LANGUAGE = (DbDouble)this.cache[2];
        return (DbDouble)this.cache[2];
    }

    public DbDouble pow(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = Math.pow(dbBigInt.value, dbBigInt2.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble pow(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = Math.pow(dbDouble.value, dbBigInt.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble pow(DbBigInt dbBigInt, DbDouble dbDouble) {
        if (dbBigInt.bNull || dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = Math.pow(dbBigInt.value, dbDouble.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble pow(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.cache[2].bNull = true;
        } else {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = Math.pow(dbDouble.value, dbDouble2.value);
        }
        return (DbDouble)this.cache[2];
    }

    public DbBigInt sgn(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[1].bNull = true;
        } else {
            int n = 0;
            if (dbBigInt.value > 0L) {
                n = 1;
            } else if (dbBigInt.value < 0L) {
                n = -1;
            }
            ((DbBigInt)this.cache[1]).value = n;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt sgn(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[1].bNull = true;
        } else {
            int n = 0;
            if (dbDouble.value > 0.0) {
                n = 1;
            } else if (dbDouble.value < 0.0) {
                n = -1;
            }
            ((DbBigInt)this.cache[1]).value = n;
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbDouble sin(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.sin(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble sin(DbNumber dbNumber) {
        if (dbNumber.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.sin(dbNumber.doubleValue());
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble sin(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.sin(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble cos(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.cos(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble cos(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.cos(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble tan(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.tan(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble tan(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.tan(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble atan(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.atan(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble atan(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.atan(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble sqr(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
            return new DbDouble();
        }
        DbDouble dbDouble = new DbDouble();
        ((DbDouble)this.cache[2]).value = dbDouble.value = Math.sqrt(dbBigInt.value);
        dbDouble.bNull = false;
        return dbDouble;
    }

    public DbDouble sqr(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
            return new DbDouble();
        }
        DbDouble dbDouble2 = new DbDouble();
        ((DbDouble)this.cache[2]).value = dbDouble2.value = Math.sqrt(dbDouble.value);
        dbDouble2.bNull = false;
        return dbDouble2;
    }

    public DbDouble exp(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.exp(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble exp(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.exp(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble log(DbBigInt dbBigInt) {
        if (dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.log(dbBigInt.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble log(DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
        } else {
            ((DbDouble)this.cache[2]).value = Math.log(dbDouble.value);
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbBigInt integDiv(DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbBigInt.bNull || dbBigInt2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = (int)(dbBigInt.value / dbBigInt2.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt integDiv(DbBigInt dbBigInt, DbDouble dbDouble) {
        if (dbBigInt.bNull || dbDouble.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = (int)((double)dbBigInt.value / dbDouble.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt integDiv(DbDouble dbDouble, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbBigInt.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = (int)(dbDouble.value / (double)dbBigInt.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbBigInt integDiv(DbDouble dbDouble, DbDouble dbDouble2) {
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.cache[1].bNull = true;
        } else {
            ((DbBigInt)this.cache[1]).value = (int)(dbDouble.value / dbDouble2.value);
            this.cache[1].bNull = false;
        }
        return (DbBigInt)this.cache[1];
    }

    public DbChar strReverse(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            int n;
            if (dbChar.value.length() < 2) {
                return dbChar;
            }
            String string = dbChar.value;
            char[] cArray = new char[string.length()];
            for (n = string.length() - 1; n >= 0; --n) {
                cArray[string.length() - n - 1] = string.charAt(n);
            }
            String string2 = String.valueOf(cArray[0]);
            for (n = 1; n < string.length(); ++n) {
                string2 = string2 + String.valueOf(cArray[n]);
            }
            ((DbChar)this.cache[5]).value = string2;
            this.cache[5].bNull = false;
        }
        return (DbChar)this.cache[5];
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar) {
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        for (int i = 0; i < fStrArray2.value.length; ++i) {
            dbCharArray[i] = new DbChar();
            dbCharArray[i] = (DbChar)fStrArray2.value[i];
        }
        if (dbChar == null || dbChar.bNull || dbChar.value == null || dbChar.value.length() == 0) {
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.value = new DbChar[0];
            fStrArray3.bNull = true;
            return fStrArray3;
        }
        return this.filter(fStrArray2, dbChar, new DbBit(true));
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar, DbBit dbBit) {
        return this.filter(fStrArray2, dbChar, dbBit, new DbBigInt(0L));
    }

    public fStrArray filter(fStrArray fStrArray2, DbChar dbChar, DbBit dbBit, DbBigInt dbBigInt) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        int n3 = 0;
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        for (int i = 0; i < fStrArray2.value.length; ++i) {
            dbCharArray[i] = new DbChar();
            dbCharArray[i] = (DbChar)fStrArray2.value[i];
        }
        if (dbChar.bNull || dbChar.value.length() == 0) {
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.bNull = true;
            return fStrArray3;
        }
        for (n = 0; n < dbCharArray.length && (dbCharArray[n] == null || dbCharArray[n].bNull); ++n) {
        }
        if (n >= dbCharArray.length) {
            fStrArray fStrArray4 = new fStrArray(1);
            fStrArray4.bNull = true;
            return fStrArray4;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        if (dbBigInt.value == 0L) {
            if (dbBit.value) {
                block2: for (n2 = 0; n2 < dbCharArray.length; ++n2) {
                    if (dbCharArray[n2].value.length() < dbChar.value.length()) continue;
                    for (n3 = 0; n3 <= dbCharArray[n2].value.length() - dbChar.value.length(); ++n3) {
                        object2 = dbCharArray[n2].value.substring(n3, n3 + dbChar.value.length());
                        if (!dbChar.value.equals(object2)) continue;
                        arrayList.add(dbCharArray[n2]);
                        continue block2;
                    }
                }
            } else {
                for (n2 = 0; n2 < dbCharArray.length; ++n2) {
                    if (!dbChar.value.equals(dbCharArray[n2].value)) continue;
                    arrayList.add(dbCharArray[n2]);
                }
            }
        } else if (dbBigInt.value == 1L) {
            object2 = dbCharArray[0].value;
            object = dbChar.value;
            if (dbBit.value) {
                block5: for (n2 = 0; n2 < dbCharArray.length; ++n2) {
                    object2 = dbCharArray[n2].value;
                    for (n3 = 0; n3 <= ((String)object2).length() - ((String)object).length(); ++n3) {
                        if (!((String)object).equalsIgnoreCase(((String)object2).substring(n3, n3 + ((String)object).length()))) continue;
                        arrayList.add(dbCharArray[n2]);
                        continue block5;
                    }
                }
            } else {
                for (n2 = 0; n2 < dbCharArray.length; ++n2) {
                    object2 = dbCharArray[n2].value;
                    if (!((String)object).equalsIgnoreCase((String)object2)) continue;
                    arrayList.add(dbCharArray[n2]);
                }
            }
        }
        object2 = new DbChar[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            object2[n3] = (DbChar)arrayList.get(n3);
        }
        object = new fStrArray(((DbChar[])object2).length);
        ((fStrArray)object).value = object2;
        return object;
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt) {
        return this.replaceString(dbChar, dbChar2, dbChar3, dbBigInt, new DbBigInt(-1L), new DbBigInt(0L));
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.replaceString(dbChar, dbChar2, dbChar3, dbBigInt, dbBigInt2, new DbBigInt(0L));
    }

    public DbChar replaceString(DbChar dbChar, DbChar dbChar2, DbChar dbChar3, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbChar.bNull || dbChar2.bNull || dbChar3.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        int n = (int)dbBigInt.value;
        if (n > dbChar.value.length()) {
            n = dbChar.value.length();
        }
        if (n - 1 >= 0) {
            --n;
        }
        if (dbBigInt3.value == 0L) {
            String string = dbChar.value.substring(0, n);
            String string2 = dbChar.value.substring(n);
            String string3 = dbChar2.value;
            String string4 = dbChar3.value;
            int n2 = 0;
            int n3 = 0;
            int n4 = string3.length();
            int n5 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = string2.indexOf(string3, n3)) != -1 && ((long)n5 < dbBigInt2.value || dbBigInt2.value == -1L)) {
                stringBuffer = stringBuffer.append(string2.substring(n3, n2)).append(string4);
                n3 = n2 + n4;
                ++n5;
            }
            stringBuffer = stringBuffer.append(string2.substring(n3, string2.length()));
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = string + stringBuffer.toString();
            return (DbChar)this.cache[5];
        }
        if (dbBigInt3.value == 1L) {
            String string = dbChar.value.substring(0, n);
            String string5 = dbChar.value.substring(n);
            String string6 = dbChar3.value;
            String string7 = dbChar2.value.toLowerCase();
            String string8 = string5.toLowerCase();
            int n6 = 0;
            int n7 = 0;
            int n8 = string7.length();
            int n9 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n6 = string8.indexOf(string7, n7)) != -1 && ((long)n9 < dbBigInt2.value || dbBigInt2.value == -1L)) {
                stringBuffer = stringBuffer.append(string5.substring(n7, n6)).append(string6);
                n7 = n6 + n8;
                ++n9;
            }
            stringBuffer = stringBuffer.append(string5.substring(n7, string8.length()));
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = string + stringBuffer.toString();
            return (DbChar)this.cache[5];
        }
        return (DbChar)this.cache[5];
    }

    public DbChar join(fStrArray fStrArray2) {
        return this.join(fStrArray2, new DbChar(" "));
    }

    public DbChar join(fStrArray fStrArray2, DbChar dbChar) {
        DbChar[] dbCharArray = new DbChar[fStrArray2.value.length];
        for (int i = 0; i < fStrArray2.value.length; ++i) {
            dbCharArray[i] = (DbChar)fStrArray2.value[i];
        }
        if (fStrArray2 != null && dbCharArray.length > 0) {
            String string = dbCharArray[0].value;
            if (dbChar != null && dbChar.value != null && dbChar.value.length() > 0) {
                for (int i = 1; i < dbCharArray.length; ++i) {
                    string = string + dbChar.value + dbCharArray[i].value;
                }
            } else {
                for (int i = 1; i < dbCharArray.length; ++i) {
                    string = string + dbCharArray[i].value;
                }
            }
            ((DbChar)this.cache[5]).value = string;
            this.cache[5].bNull = false;
            return (DbChar)this.cache[5];
        }
        this.cache[5].bNull = true;
        return (DbChar)this.cache[5];
    }

    public fStrArray stringSplit(DbChar dbChar) {
        if (dbChar.bNull) {
            fStrArray fStrArray2 = new fStrArray(0);
            fStrArray2.bNull = true;
            return fStrArray2;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        String string = dbChar.value;
        while (string != null && string.length() > 0) {
            if (string.charAt(0) == ' ') {
                string = string.substring(1);
                continue;
            }
            DbChar dbChar2 = new DbChar();
            try {
                dbChar2.value = string.substring(0, string.indexOf(32));
                dbChar2.bNull = false;
                arrayList.add(dbChar2);
                string = string.substring(string.indexOf(32));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                dbChar2.value = string.substring(0, string.length());
                dbChar2.bNull = false;
                arrayList.add(dbChar2);
                break;
            }
        }
        DbChar[] dbCharArray = new DbChar[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dbCharArray[i] = (DbChar)arrayList.get(i);
        }
        fStrArray fStrArray3 = new fStrArray(dbCharArray.length);
        fStrArray3.value = dbCharArray;
        return fStrArray3;
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2) {
        return this.stringSplit(dbChar, dbChar2, new DbBigInt(-1L));
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2, DbBigInt dbBigInt) {
        return this.stringSplit(dbChar, dbChar2, dbBigInt, new DbBigInt(0L));
    }

    public fStrArray stringSplit(DbChar dbChar, DbChar dbChar2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbChar.bNull || dbBigInt.bNull || dbBigInt2.bNull) {
            this.cache[5].bNull = true;
            DbChar[] dbCharArray = new DbChar[]{dbChar};
            fStrArray fStrArray2 = new fStrArray(1);
            fStrArray2.bNull = true;
            fStrArray2.value = dbCharArray;
            return fStrArray2;
        }
        if (dbChar2.bNull || dbChar2.value == null || dbChar2.value.length() == 0) {
            DbChar[] dbCharArray = new DbChar[1];
            this.cache[5].bNull = false;
            dbCharArray[0] = dbChar;
            fStrArray fStrArray3 = new fStrArray(1);
            fStrArray3.bNull = false;
            fStrArray3.value = dbCharArray;
            return fStrArray3;
        }
        ArrayList<DbChar> arrayList = new ArrayList<DbChar>();
        String string = dbChar.value;
        String string2 = dbChar2.value;
        int n = 1;
        if (dbBigInt2.value != 1L) {
            while (string != null && string.length() > 0) {
                if (string.indexOf(string2) == 0) {
                    string = string.substring(string2.length());
                    continue;
                }
                DbChar dbChar3 = new DbChar();
                try {
                    if (dbBigInt.value == -1L || dbBigInt.value > (long)n) {
                        dbChar3.value = string.substring(0, string.indexOf(string2));
                        dbChar3.bNull = false;
                        arrayList.add(dbChar3);
                        string = string.substring(string.indexOf(string2));
                        ++n;
                        continue;
                    }
                    dbChar3.value = string.substring(0, string.length());
                    dbChar3.bNull = false;
                    arrayList.add(dbChar3);
                    break;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    dbChar3.value = string.substring(0, string.length());
                    dbChar3.bNull = false;
                    arrayList.add(dbChar3);
                    break;
                }
            }
            DbChar[] dbCharArray = new DbChar[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                dbCharArray[i] = (DbChar)arrayList.get(i);
            }
            fStrArray fStrArray4 = new fStrArray(dbCharArray.length);
            fStrArray4.value = dbCharArray;
            return fStrArray4;
        }
        if (dbBigInt2.value == 1L) {
            String string3 = string.toLowerCase();
            string2 = string2.toLowerCase();
            while (string != null && string.length() > 0) {
                if (string3.indexOf(string2) == 0) {
                    string = string.substring(string2.length());
                    string3 = string3.substring(string2.length());
                    continue;
                }
                DbChar dbChar4 = new DbChar();
                try {
                    if (dbBigInt.value == -1L || dbBigInt.value > (long)n) {
                        dbChar4.value = string.substring(0, string3.indexOf(string2));
                        dbChar4.bNull = false;
                        arrayList.add(dbChar4);
                        string = string.substring(string3.indexOf(string2));
                        string3 = string3.substring(string3.indexOf(string2));
                        ++n;
                        continue;
                    }
                    dbChar4.value = string.substring(0, string3.length());
                    dbChar4.bNull = false;
                    arrayList.add(dbChar4);
                    break;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    dbChar4.value = string.substring(0, string3.length());
                    dbChar4.bNull = false;
                    arrayList.add(dbChar4);
                    break;
                }
            }
            DbChar[] dbCharArray = new DbChar[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                dbCharArray[i] = (DbChar)arrayList.get(i);
            }
            fStrArray fStrArray5 = new fStrArray(dbCharArray.length);
            fStrArray5.value = dbCharArray;
            return fStrArray5;
        }
        fStrArray fStrArray6 = new fStrArray();
        fStrArray6.bNull = true;
        return fStrArray6;
    }

    public DbBit toBool(DbBigInt dbBigInt) {
        boolean bl;
        if (dbBigInt == null || dbBigInt.bNull) {
            this.cache[4].bNull = true;
            return (DbBit)this.cache[4];
        }
        ((DbBit)this.cache[4]).value = bl = (int)dbBigInt.value != 0;
        this.cache[4].bNull = false;
        return (DbBit)this.cache[4];
    }

    public DbBit toBool(DbDouble dbDouble) {
        boolean bl;
        if (dbDouble == null || dbDouble.bNull) {
            this.cache[4].bNull = true;
            return (DbBit)this.cache[4];
        }
        ((DbBit)this.cache[4]).value = bl = (int)dbDouble.value != 0;
        this.cache[4].bNull = false;
        return (DbBit)this.cache[4];
    }

    public DbBit toBool(fCurrency fCurrency2) {
        boolean bl;
        if (fCurrency2.bNull) {
            this.cache[4].bNull = true;
            return (DbBit)this.cache[4];
        }
        ((DbBit)this.cache[4]).value = bl = fCurrency2.value.intValue() != 0;
        this.cache[4].bNull = false;
        return (DbBit)this.cache[4];
    }

    public DbDouble toNumber(DbBit dbBit) {
        DbDouble dbDouble = new DbDouble();
        if (dbBit.bNull) {
            dbDouble.bNull = true;
            this.cache[2].bNull = true;
        } else {
            double d;
            ((DbDouble)this.cache[2]).value = d = dbBit.value ? 1.0 : 0.0;
            this.cache[2].bNull = false;
            dbDouble.value = d;
            dbDouble.bNull = false;
        }
        return dbDouble;
    }

    public DbBit isNumeric(DbChar dbChar) {
        DbBit dbBit = new DbBit();
        if (dbChar.bNull) {
            dbBit.bNull = true;
            this.cache[4].bNull = true;
        } else {
            String string = dbChar.value.trim();
            boolean bl = true;
            if (string == null || string.length() == 0) {
                dbBit.bNull = true;
                this.cache[4].bNull = true;
                return dbBit;
            }
            string.trim();
            int n = 0;
            int n2 = -1;
            int n3 = -1;
            try {
                Double.parseDouble(dbChar.value);
                dbBit.value = true;
                dbBit.bNull = false;
                ((DbBit)this.cache[4]).value = true;
                this.cache[4].bNull = false;
                return dbBit;
            }
            catch (Exception exception) {
                int n4;
                dbBit.value = false;
                dbBit.bNull = false;
                ((DbBit)this.cache[4]).value = true;
                this.cache[4].bNull = false;
                for (n4 = 0; n4 < string.length() && (string.charAt(n4) >= '0' && string.charAt(n4) <= '9' || string.charAt(n4) == ',' || string.charAt(n4) == '.'); ++n4) {
                    if (string.charAt(n4) == '.') {
                        n3 = n4;
                        ++n;
                    }
                    if (string.charAt(n4) != ',') continue;
                    if (n2 != -1 && n2 + 4 != n4) {
                        bl = false;
                        break;
                    }
                    n2 = n4;
                }
                if (n >= 2 || n3 != -1 && n2 != -1 && n3 != n2 + 4) {
                    bl = false;
                }
                if (n4 == string.length() && bl) {
                    dbBit.value = true;
                    dbBit.bNull = false;
                    ((DbBit)this.cache[4]).value = true;
                    this.cache[4].bNull = false;
                }
                dbBit.value = false;
                dbBit.bNull = false;
                ((DbBit)this.cache[4]).value = false;
                this.cache[4].bNull = false;
            }
        }
        return dbBit;
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.FV(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        return this.FV(dbDouble, dbBigInt, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.FV(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.FV(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble FV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.FV(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble FV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            ((DbDouble)this.cache[2]).bNull = true;
            dbDouble5.bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) / dbDouble.value : (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * (1.0 + dbDouble.value) / dbDouble.value;
            d *= -dbDouble3.value;
            long l = (long)(((d += Math.pow(1.0 + dbDouble.value, dbDouble2.value) * -dbDouble4.value) + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)l / 100.0;
            ((DbDouble)this.cache[2]).bNull = true;
            dbDouble5.value = (double)l / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.IPmt(dbDouble, dbDouble2, dbDouble4, dbDouble3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.IPmt(dbDouble, dbDouble4, dbDouble2, dbDouble3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2) {
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt2.bNull;
        dbDouble4.value = dbBigInt2.value;
        return this.IPmt(dbDouble, dbDouble3, dbDouble4, dbDouble2);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull) {
            ((DbDouble)this.cache[2]).bNull = true;
            dbDouble5.bNull = true;
        } else {
            double d = dbDouble4.value;
            double d2 = dbDouble4.value * dbDouble.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d = d * (1.0 + dbDouble.value) - d2;
                ++n;
            }
            long l = (long)((d * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            ((DbDouble)this.cache[2]).bNull = false;
            dbDouble5.value = (double)(-l) / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.IPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        return this.IPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5, new DbBigInt(0L));
    }

    public DbDouble IPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.IPmt(dbDouble, dbDouble4, dbDouble5, dbDouble2, dbDouble3, dbBigInt3);
    }

    public DbDouble IPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5, DbBigInt dbBigInt) {
        DbDouble dbDouble6 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
            dbDouble6.bNull = true;
        } else if (dbBigInt.value != 1L) {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d2 = dbDouble4.value;
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d2 = d2 * (1.0 + dbDouble.value) - d;
                ++n;
            }
            long l = (long)((d2 * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            this.cache[2].bNull = false;
            dbDouble6.value = (double)(-l) / 100.0;
            dbDouble6.bNull = false;
        } else {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d3 = dbDouble4.value;
            int n = 0;
            while ((double)n < dbDouble2.value - 2.0) {
                d3 = (d3 - d) * (1.0 + dbDouble.value);
                ++n;
            }
            long l = (long)(((d3 -= d) * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            this.cache[2].bNull = false;
            dbDouble6.value = (double)(-l) / 100.0;
            dbDouble6.bNull = false;
        }
        return dbDouble6;
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        return this.Pmt(dbDouble, dbDouble3, dbDouble2);
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull) {
            dbDouble4.bNull = true;
            this.cache[2].bNull = true;
        } else {
            double d = dbDouble3.value * dbDouble.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0);
            long l = (long)((d + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            ((DbDouble)this.cache[2]).bNull = false;
            dbDouble4.value = (double)(-l) / 100.0;
            dbDouble4.bNull = false;
        }
        return dbDouble4;
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Pmt(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.Pmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble Pmt(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.Pmt(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble Pmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        DbDouble dbDouble5 = new DbDouble();
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            dbDouble5.bNull = true;
            this.cache[2].bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? (dbDouble3.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) + dbDouble4.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) : (dbDouble3.value * Math.pow(1.0 + dbDouble.value, dbDouble2.value) + dbDouble4.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0);
            long l = (long)((d + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            this.cache[2].bNull = false;
            dbDouble5.value = (double)(-l) / 100.0;
            dbDouble5.bNull = false;
        }
        return dbDouble5;
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.PPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbDouble(0.0));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2) {
        return this.PPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        return this.PPmt(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5, new DbBigInt(0L));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PPmt(dbDouble, dbBigInt, dbBigInt2, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble PPmt(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt3) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.PPmt(dbDouble, dbDouble4, dbDouble5, dbDouble2, dbDouble3, dbBigInt3);
    }

    public DbDouble PPmt(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble3.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else if (dbBigInt.value != 1L) {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d2 = dbDouble4.value;
            int n = 1;
            while ((double)n < dbDouble2.value) {
                d2 = d2 * (1.0 + dbDouble.value) - d;
                ++n;
            }
            long l = (long)((d - d2 * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            this.cache[2].bNull = false;
        } else {
            double d = (dbDouble4.value * Math.pow(1.0 + dbDouble.value, dbDouble3.value) + dbDouble5.value) * dbDouble.value / (1.0 + dbDouble.value) / (Math.pow(1.0 + dbDouble.value, dbDouble3.value) - 1.0);
            double d3 = dbDouble4.value;
            int n = 0;
            while ((double)n < dbDouble2.value - 2.0) {
                d3 = (d3 - d) * (1.0 + dbDouble.value);
                ++n;
            }
            long l = (long)((d - (d3 -= d) * dbDouble.value + 0.005) * 100.0);
            ((DbDouble)this.cache[2]).value = (double)(-l) / 100.0;
            this.cache[2].bNull = false;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2) {
        return this.PV(dbDouble, dbBigInt, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PV(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.PV(dbDouble, dbBigInt, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.PV(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble PV(DbDouble dbDouble, DbBigInt dbBigInt, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        return this.PV(dbDouble, dbDouble4, dbDouble2, dbDouble3, dbBigInt2);
    }

    public DbDouble PV(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
        } else {
            double d = dbBigInt.value != 1L ? -(((Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * dbDouble3.value / dbDouble.value + dbDouble4.value) / Math.pow(1.0 + dbDouble.value, dbDouble2.value)) : -(((Math.pow(1.0 + dbDouble.value, dbDouble2.value) - 1.0) * dbDouble3.value / dbDouble.value + dbDouble4.value / (1.0 + dbDouble.value)) / Math.pow(1.0 + dbDouble.value, dbDouble2.value - 1.0));
            long l = (long)((d + 0.005) * 100.0);
            d = (double)l / 100.0;
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = d;
        }
        return (DbDouble)this.cache[2];
    }

    public DbDouble NPV(DbDouble dbDouble, fNumArray fNumArray2) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double[] dArray = new double[fNumArray2.value.length];
        for (int i = 0; i < fNumArray2.value.length; ++i) {
            if (((DbDouble)fNumArray2.value[i]).bNull) {
                this.cache[2].bNull = true;
                return (DbDouble)this.cache[2];
            }
            dArray[i] = ((DbDouble)fNumArray2.value[i]).value;
        }
        return this.IRR(dbDouble, dArray);
    }

    public DbDouble NPV(DbDouble dbDouble, fIntArray fIntArray2) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double[] dArray = new double[fIntArray2.value.length];
        for (int i = 0; i < fIntArray2.value.length; ++i) {
            if (((DbBigInt)fIntArray2.value[i]).bNull) {
                this.cache[2].bNull = true;
                return (DbDouble)this.cache[2];
            }
            dArray[i] = ((DbBigInt)fIntArray2.value[i]).value;
        }
        return this.IRR(dbDouble, dArray);
    }

    private DbDouble IRR(DbDouble dbDouble, double[] dArray) {
        if (dbDouble.bNull || dArray.length == 0) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * Math.pow(1.0 + dbDouble.value, dArray.length - i - 1);
        }
        long l = (long)(((d /= Math.pow(1.0 + dbDouble.value, dArray.length)) + 0.005) * 100.0);
        ((DbDouble)this.cache[2]).value = d = (double)l / 100.0;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        return this.NPer(dbDouble, dbBigInt, dbBigInt2, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        return this.NPer(dbDouble, dbBigInt, dbBigInt2, dbBigInt3, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3, DbBigInt dbBigInt4) {
        DbDouble dbDouble2 = new DbDouble();
        dbDouble2.bNull = dbBigInt.bNull;
        dbDouble2.value = dbBigInt.value;
        DbDouble dbDouble3 = new DbDouble();
        dbDouble3.bNull = dbBigInt2.bNull;
        dbDouble3.value = dbBigInt2.value;
        DbDouble dbDouble4 = new DbDouble();
        dbDouble4.bNull = dbBigInt3.bNull;
        dbDouble4.value = dbBigInt3.value;
        return this.NPer(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbBigInt4);
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.NPer(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0), new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.NPer(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble NPer(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        if (dbDouble2.value == 0.0 && dbDouble3.value == 0.0 && dbDouble4.value == 0.0) {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = 0.0;
            return (DbDouble)this.cache[2];
        }
        if (dbDouble2.value == 0.0 && dbDouble3.value * dbDouble4.value != 0.0) {
            if (dbDouble3.value * dbDouble4.value > 0.0) {
                this.cache[2].bNull = true;
            } else {
                this.cache[2].bNull = false;
                ((DbDouble)this.cache[2]).value = this.ITALIAN(dbDouble.value, dbDouble3.value, dbDouble4.value);
            }
            return (DbDouble)this.cache[2];
        }
        if (dbDouble2.value * (dbDouble3.value + dbDouble4.value) > 0.0) {
            this.cache[2].bNull = false;
            ((DbDouble)this.cache[2]).value = -this.IsDate(dbDouble.value, dbDouble2.value, dbDouble3.value, dbDouble4.value, dbBigInt.value);
            return (DbDouble)this.cache[2];
        }
        double d = 0.0;
        double d2 = 300.0;
        double d3 = 0.0;
        double d4 = 150.0;
        double d5 = Math.pow(1.0 + dbDouble.value, d4);
        int n = 0;
        if (dbBigInt.value != 1L) {
            d = (1.0 - dbDouble4.value * dbDouble.value / dbDouble2.value) / (1.0 + dbDouble3.value * dbDouble.value / dbDouble2.value);
            if (d > 0.0) {
                while (Math.pow(1.0 + dbDouble.value, d2) < d) {
                    d4 = ((d2 *= 2.0) + d3) / 2.0;
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                }
                while (Math.pow(1.0 + dbDouble.value, d4) - d > 1.0E-5 * d || Math.pow(1.0 + dbDouble.value, d4) - d < -1.0E-5 * d) {
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                    if (d5 > d) {
                        d2 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (d5 < d) {
                        d3 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (n++ <= 1000 && !(d3 > d2)) continue;
                }
                ((DbDouble)this.cache[2]).value = d4;
                this.cache[2].bNull = false;
            } else {
                ((DbDouble)this.cache[2]).value = 1.0E308;
                this.cache[2].bNull = false;
            }
        } else {
            d = (1.0 + dbDouble.value - dbDouble4.value * dbDouble.value / dbDouble2.value) / (1.0 + dbDouble.value + dbDouble3.value * dbDouble.value / dbDouble2.value);
            if (d > 0.0) {
                while (Math.pow(1.0 + dbDouble.value, d2) < d) {
                    d4 = ((d2 *= 2.0) + d3) / 2.0;
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                }
                while (Math.pow(1.0 + dbDouble.value, d4) - d > 1.0E-5 * d || Math.pow(1.0 + dbDouble.value, d4) - d < -1.0E-5 * d) {
                    d5 = Math.pow(1.0 + dbDouble.value, d4);
                    if (d5 > d) {
                        d2 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (d5 < d) {
                        d3 = d4;
                        d4 = (d2 + d3) / 2.0;
                        continue;
                    }
                    if (n++ <= 1000 && !(d3 > d2)) continue;
                }
                if (n >= 1000) {
                    ((DbDouble)this.cache[2]).value = -this.IsDate(dbDouble.value, dbDouble2.value, dbDouble3.value, dbDouble4.value, dbBigInt.value);
                }
                ((DbDouble)this.cache[2]).value = d4;
                this.cache[2].bNull = false;
            } else {
                ((DbDouble)this.cache[2]).value = 1.0E308;
                this.cache[2].bNull = false;
            }
        }
        return (DbDouble)this.cache[2];
    }

    private double ITALIAN(double d, double d2, double d3) {
        double d4 = -d3 / d2;
        if (d4 < 0.0) {
            return -1.0;
        }
        return Math.log(d4) / Math.log(1.0 + d);
    }

    private double IsDate(double d, double d2, double d3, double d4, long l) {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 300.0;
        double d8 = 150.0;
        double d9 = Math.pow(1.0 + d, d8);
        int n = 0;
        d2 *= -1.0;
        if (l != 1L) {
            d5 = (d9 - 1.0) * d2 / d + d3 + d9 * d4;
            while ((d5 > 0.1 || d5 < -0.1) && n++ <= 300) {
                if (d5 > 0.0) {
                    d6 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d5 < 0.0) {
                    d7 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d7 > d6) break;
                d9 = Math.pow(1.0 + d, d8);
                d5 = (d9 - 1.0) * d2 / d + d3 + d9 * d4;
            }
            long l2 = (long)((d8 + 0.005) * 100.0);
            d8 = (double)l2 / 100.0;
        } else if (l == 1L) {
            d5 = (d9 - 1.0) * d2 / d * (1.0 + d) + d3 + d9 * d4;
            while ((d5 > 0.1 || d5 < -0.1) && n++ <= 300) {
                if (d5 > 0.0) {
                    d6 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d5 < 0.0) {
                    d7 = d8;
                    d8 = (d6 + d7) / 2.0;
                } else if (d7 > d6) break;
                d9 = Math.pow(1.0 + d, d8);
                d5 = (d9 - 1.0) * d2 / d * (1.0 + d) + d3 + d9 * d4;
            }
            long l3 = (long)((d8 + 0.005) * 100.0);
            d8 = (double)l3 / 100.0;
        }
        return d8;
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, new DbDouble(0.0));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, new DbDouble(0.0));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, dbDouble3, new DbBigInt(0L));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, dbDouble4, new DbBigInt(0L));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2) {
        return this.Rate(dbBigInt, dbDouble, dbDouble2, dbDouble3, dbBigInt2, new DbDouble(0.1));
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt) {
        return this.Rate(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbBigInt, new DbDouble(0.1));
    }

    public DbDouble Rate(DbBigInt dbBigInt, DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbBigInt dbBigInt2, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble();
        dbDouble5.bNull = dbBigInt.bNull;
        dbDouble5.value = dbBigInt.value;
        return this.Rate(dbDouble5, dbDouble, dbDouble2, dbDouble3, dbBigInt2, dbDouble4);
    }

    public DbDouble Rate(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbBigInt dbBigInt, DbDouble dbDouble5) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbBigInt.bNull || dbDouble5.bNull) {
            this.cache[2].bNull = true;
        } else {
            DbDouble dbDouble6 = new DbDouble();
            dbDouble6 = dbBigInt.value != 1L ? this.IsDateTime(dbDouble.value, dbDouble3.value, dbDouble2.value, dbDouble4.value, dbDouble5.value) : this.IsTime(dbDouble.value, dbDouble3.value, dbDouble2.value, dbDouble4.value, dbDouble5.value);
            ((DbDouble)this.cache[2]).value = dbDouble6.value;
            ((DbDouble)this.cache[2]).bNull = dbDouble6.bNull;
        }
        return (DbDouble)this.cache[2];
    }

    private DbDouble IsDateTime(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5;
        double d7 = d5 * 2.0;
        double d8 = -2.01;
        double d9 = -2.0;
        double d10 = 0.0;
        int n = 0;
        DbDouble dbDouble = new DbDouble();
        if (d3 == 0.0 && (d2 != 0.0 || d4 != 0.0)) {
            dbDouble.bNull = true;
            return dbDouble;
        }
        if (d3 * d + (d2 + d4) == 0.0) {
            dbDouble.value = 0.0;
            dbDouble.bNull = false;
            return dbDouble;
        }
        while (d8 >= -2.01 && d8 <= 1.0) {
            if (((d2 + d3 / d8) * Math.pow(1.0 + d8, d) + d4 - d3 / d8) * ((d2 + d3 / d9) * Math.pow(1.0 + d9, d) + d4 - d3 / d9) < 0.0) {
                d10 = d8;
            }
            d8 += 0.005;
            d9 += 0.005;
        }
        d8 = d10;
        d7 = d10 + 0.01;
        d6 = (d8 + d7) / 2.0;
        if (d8 > -2.01 && d8 < -1.0) {
            while (d4 < d3 * 0.999999 / d6 || d4 > d3 * 1.000001 / d6) {
                ++n;
                if (d4 > d3 / d6) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
                break;
            }
        } else if (d8 < 0.0 && d8 >= -1.0) {
            while ((d2 + d3 / d6) * Math.pow(1.0 + d6, d) + d4 < d3 * 0.999999 / d6 || (d2 + d3 / d6) * Math.pow(1.0 + d6, d) + d4 > d3 * 1.000001 / d6) {
                ++n;
                if ((d3 / d6 + d2) * Math.pow(1.0 + d6, d) < d3 / d6 - d4) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
                break;
            }
        } else {
            while ((d2 + d3 / d6) * Math.pow(1.0 + d6, d) + d4 > d3 * 0.999999 / d6 || (d2 + d3 / d6) * Math.pow(1.0 + d6, d) + d4 < d3 * 1.000001 / d6) {
                ++n;
                if ((d3 / d6 + d2) * Math.pow(1.0 + d6, d) < d3 / d6 - d4) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
            }
        }
        dbDouble.value = d6;
        dbDouble.bNull = false;
        return dbDouble;
    }

    private DbDouble IsTime(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5;
        double d7 = d5 * 2.0;
        double d8 = -2.01;
        double d9 = -2.0;
        double d10 = 0.0;
        int n = 0;
        DbDouble dbDouble = new DbDouble();
        if (d3 == 0.0 && (d2 != 0.0 || d4 != 0.0)) {
            dbDouble.bNull = true;
            return dbDouble;
        }
        if (d3 * d + (d2 + d4) == 0.0) {
            dbDouble.value = 0.0;
            dbDouble.bNull = false;
            return dbDouble;
        }
        while (d8 >= -2.01 && d8 <= 1.0) {
            if (((d2 + d3 * (1.0 + d8) / d8) * Math.pow(1.0 + d8, d) + d4 - d3 * (1.0 + d8) / d8) * ((d2 + d3 * (1.0 + d9) / d9) * Math.pow(1.0 + d9, d) + d4 - d3 * (1.0 + d9) / d9) < 0.0) {
                d10 = d8;
            }
            d8 += 0.005;
            d9 += 0.005;
        }
        d8 = d10;
        d7 = d10 + 0.01;
        d6 = (d8 + d7) / 2.0;
        if (d8 > -2.01 && d8 < -1.0) {
            while (d4 < d3 * (1.0 + d6) * 0.999999 / d6 || d4 > d3 * (1.0 + d6) * 1.000001 / d6) {
                ++n;
                if (d4 > d3 / d6) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
                break;
            }
        } else if (d8 < 0.0 && d8 >= -1.0) {
            while ((d2 + d3 * (1.0 + d6) / d6) * Math.pow(1.0 + d6, d) + d4 < d3 * (1.0 + d6) * 0.999999 / d6 || (d2 + d3 * (1.0 + d6) / d6) * Math.pow(1.0 + d6, d) + d4 > d3 * (1.0 + d6) * 1.000001 / d6) {
                ++n;
                if ((d3 / d6 + d2) * Math.pow(1.0 + d6, d) < d3 / d6 - d4) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
                break;
            }
        } else {
            while ((d2 + d3 * (1.0 + d6) / d6) * Math.pow(1.0 + d6, d) + d4 > d3 * (1.0 + d6) * 0.999999 / d6 || (d2 + d3 * (1.0 + d6) / d6) * Math.pow(1.0 + d6, d) + d4 < d3 * (1.0 + d6) * 1.000001 / d6) {
                ++n;
                if ((d3 * (1.0 + d6) / d6 + d2) * Math.pow(1.0 + d6, d) < d3 * (1.0 + d6) / d6 - d4) {
                    d8 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 += 1.0E-5;
                    }
                } else {
                    d7 = d6;
                    if ((d6 = (d8 + d7) / 2.0) == 0.0) {
                        d6 -= 1.0E-5;
                    }
                }
                if (n != 1000) continue;
            }
        }
        dbDouble.value = d6;
        dbDouble.bNull = false;
        return dbDouble;
    }

    public DbDouble IRR(fIntArray fIntArray2) {
        return this.IRR(fIntArray2, new DbDouble(0.1));
    }

    public DbDouble IRR(fNumArray fNumArray2) {
        return this.IRR(fNumArray2, new DbDouble(0.1));
    }

    public DbDouble IRR(fNumArray fNumArray2, DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        DbDouble[] dbDoubleArray = new DbDouble[fNumArray2.value.length];
        for (int i = 0; i < fNumArray2.value.length; ++i) {
            dbDoubleArray[i] = (DbDouble)fNumArray2.value[i];
        }
        return this.JAPAN(dbDoubleArray, dbDouble);
    }

    public DbDouble IRR(fIntArray fIntArray2, DbDouble dbDouble) {
        if (dbDouble.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        DbDouble[] dbDoubleArray = new DbDouble[fIntArray2.value.length];
        for (int i = 0; i < fIntArray2.value.length; ++i) {
            dbDoubleArray[i] = new DbDouble();
            dbDoubleArray[i].bNull = ((DbBigInt)fIntArray2.value[i]).bNull;
            dbDoubleArray[i].value = ((DbBigInt)fIntArray2.value[i]).value;
        }
        return this.JAPAN(dbDoubleArray, dbDouble);
    }

    private DbDouble JAPAN(DbDouble[] dbDoubleArray, DbDouble dbDouble) {
        int n;
        int n2;
        for (n2 = 0; n2 < dbDoubleArray.length; ++n2) {
            if (!dbDoubleArray[n2].bNull) continue;
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        for (n2 = 1; n2 < dbDoubleArray.length && !(dbDoubleArray[0].value * dbDoubleArray[n2].value < 0.0); ++n2) {
        }
        if (n2 == dbDoubleArray.length) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = dbDouble.value;
        double d2 = 2.0 * dbDouble.value;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < dbDoubleArray.length; ++n) {
            d4 += dbDoubleArray[n].value * Math.pow(1.0 + d2, dbDoubleArray.length - n - 1);
        }
        if (d4 == 0.0) {
            ((DbDouble)this.cache[2]).value = 0.0;
            this.cache[2].bNull = false;
            return (DbDouble)this.cache[2];
        }
        while (d4 < 0.0 && dbDoubleArray[0].value > 0.0) {
            d3 = d;
            d = ((d2 *= 2.0) + d3) / 2.0;
            d4 = 0.0;
            for (n = 0; n < dbDoubleArray.length; ++n) {
                d4 += dbDoubleArray[n].value * Math.pow(1.0 + d2, dbDoubleArray.length - n - 1);
            }
        }
        while (d4 > 0.0 && dbDoubleArray[0].value < 0.0) {
            d3 = d;
            d = ((d2 *= 2.0) + d3) / 2.0;
            d4 = 0.0;
            for (n = 0; n < dbDoubleArray.length; ++n) {
                d4 += dbDoubleArray[n].value * Math.pow(1.0 + d2, dbDoubleArray.length - n - 1);
            }
        }
        d4 = 0.0;
        for (n = 0; n < dbDoubleArray.length; ++n) {
            d4 += dbDoubleArray[n].value * Math.pow(1.0 + d3, dbDoubleArray.length - n - 1);
        }
        while (d4 < 0.0 && dbDoubleArray[0].value < 0.0 || d4 > 0.0 && dbDoubleArray[0].value > 0.0) {
            if (d3 == 0.0) {
                d3 = -dbDouble.value;
                d2 = 0.0;
            } else {
                d3 *= 2.0;
                d2 = d;
            }
            d = (d2 + d3) / 2.0;
            d4 = 0.0;
            for (n = 0; n < dbDoubleArray.length; ++n) {
                d4 += dbDoubleArray[n].value * Math.pow(1.0 + d3, dbDoubleArray.length - n - 1);
            }
        }
        d4 = 0.0;
        for (n = 0; n < dbDoubleArray.length; ++n) {
            d4 += dbDoubleArray[n].value * Math.pow(1.0 + d, dbDoubleArray.length - n - 1);
        }
        n = 0;
        double d5 = Math.abs(d4 * 1.0E-5);
        while (d4 > d5 || d4 < -d5) {
            if (d4 < 0.0) {
                if (dbDoubleArray[0].value > 0.0) {
                    d3 = d;
                    d = (d2 + d3) / 2.0;
                } else if (dbDoubleArray[0].value < 0.0) {
                    d2 = d;
                    d = (d2 + d3) / 2.0;
                }
            } else if (d4 > 0.0) {
                if (dbDoubleArray[0].value < 0.0) {
                    d3 = d;
                    d = (d2 + d3) / 2.0;
                } else if (dbDoubleArray[0].value > 0.0) {
                    d2 = d;
                    d = (d2 + d3) / 2.0;
                }
            }
            if (++n > 1000) break;
            d4 = 0.0;
            for (int i = 0; i < dbDoubleArray.length; ++i) {
                d4 += dbDoubleArray[i].value * Math.pow(1.0 + d, dbDoubleArray.length - i - 1);
            }
        }
        ((DbDouble)this.cache[2]).value = d;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble MIRR(fIntArray fIntArray2, DbDouble dbDouble, DbDouble dbDouble2) {
        int n;
        if (dbDouble.bNull || dbDouble2.bNull) {
            return new DbDouble();
        }
        double[] dArray = new double[fIntArray2.value.length];
        for (n = 0; n < fIntArray2.value.length; ++n) {
            dArray[n] = ((DbBigInt)fIntArray2.value[n]).value;
        }
        for (n = 0; n < fIntArray2.value.length; ++n) {
            if (!((DbBigInt)fIntArray2.value[n]).bNull) continue;
            return new DbDouble();
        }
        return this.KOREA(dArray, dbDouble, dbDouble2);
    }

    public DbDouble MIRR(fNumArray fNumArray2, DbDouble dbDouble, DbDouble dbDouble2) {
        int n;
        if (dbDouble.bNull || dbDouble2.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double[] dArray = new double[fNumArray2.value.length];
        for (n = 0; n < fNumArray2.value.length; ++n) {
            dArray[n] = ((DbDouble)fNumArray2.value[n]).value;
        }
        for (n = 0; n < fNumArray2.value.length; ++n) {
            if (!((DbDouble)fNumArray2.value[n]).bNull) continue;
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        return this.KOREA(dArray, dbDouble, dbDouble2);
    }

    private DbDouble KOREA(double[] dArray, DbDouble dbDouble, DbDouble dbDouble2) {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < 0.0) {
                d3 += dArray[i] * Math.pow(1.0 + dbDouble.value, dArray.length - i - 1);
                continue;
            }
            d2 += dArray[i] * Math.pow(1.0 + dbDouble2.value, dArray.length - i - 1);
        }
        d3 /= Math.pow(1.0 + dbDouble.value, dArray.length);
        d2 /= Math.pow(1.0 + dbDouble2.value, dArray.length);
        ((DbDouble)this.cache[2]).value = d = Math.pow(-(d2 *= Math.pow(1.0 + dbDouble2.value, dArray.length)) / (d3 *= Math.pow(1.0 + dbDouble.value, 1.0)), 1.0 / (double)(dArray.length - 1)) - 1.0;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SLN(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        ((DbDouble)this.cache[2]).value = (dbDouble.value - dbDouble2.value) / dbDouble3.value;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SLN(DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        if (dbBigInt.bNull || dbBigInt2.bNull || dbBigInt3.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        ((DbDouble)this.cache[2]).value = ((double)dbBigInt.value - (double)dbBigInt2.value) / (double)dbBigInt3.value;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SLN(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt) {
        if (dbDouble.bNull || dbDouble2.bNull || dbBigInt.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        ((DbDouble)this.cache[2]).value = (dbDouble.value - dbDouble2.value) / (double)dbBigInt.value;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SYD(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = (dbDouble.value - dbDouble2.value) * (dbDouble3.value - dbDouble4.value + 1.0) * 2.0;
        ((DbDouble)this.cache[2]).value = d /= dbDouble3.value * (dbDouble3.value + 1.0);
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SYD(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        if (dbDouble.bNull || dbDouble2.bNull || dbBigInt.bNull || dbBigInt2.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = (dbDouble.value - dbDouble2.value) * (double)(dbBigInt.value - dbBigInt2.value + 1L) * 2.0;
        ((DbDouble)this.cache[2]).value = d /= (double)(dbBigInt.value * (dbBigInt.value + 1L));
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble SYD(DbNumber dbNumber, DbNumber dbNumber2, DbNumber dbNumber3, DbNumber dbNumber4) {
        if (dbNumber.bNull || dbNumber2.bNull || dbNumber3.bNull || dbNumber4.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d = (dbNumber.doubleValue() - dbNumber2.doubleValue()) * (dbNumber3.doubleValue() - dbNumber4.doubleValue() + 1.0) * 2.0;
        ((DbDouble)this.cache[2]).value = d /= dbNumber3.doubleValue() * (dbNumber3.doubleValue() + 1.0);
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2) {
        DbDouble dbDouble3 = new DbDouble(2.0);
        return this.DDB(dbDouble, dbDouble2, dbBigInt, dbBigInt2, dbDouble3);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4) {
        DbDouble dbDouble5 = new DbDouble(2.0);
        return this.DDB(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbDouble dbDouble3) {
        DbDouble dbDouble4 = new DbDouble();
        DbDouble dbDouble5 = new DbDouble();
        dbDouble4.bNull = dbBigInt.bNull;
        dbDouble4.value = dbBigInt.value;
        dbDouble5.bNull = dbBigInt2.bNull;
        dbDouble5.value = dbBigInt2.value;
        return this.DDB(dbDouble, dbDouble2, dbDouble4, dbDouble5, dbDouble3);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbBigInt dbBigInt, DbBigInt dbBigInt2, DbBigInt dbBigInt3) {
        DbDouble dbDouble3 = new DbDouble();
        DbDouble dbDouble4 = new DbDouble();
        DbDouble dbDouble5 = new DbDouble();
        dbDouble3.bNull = dbBigInt.bNull;
        dbDouble3.value = dbBigInt.value;
        dbDouble4.bNull = dbBigInt2.bNull;
        dbDouble4.value = dbBigInt2.value;
        dbDouble5.bNull = dbBigInt3.bNull;
        dbDouble5.value = dbBigInt3.value;
        return this.DDB(dbDouble, dbDouble2, dbDouble3, dbDouble4, dbDouble5);
    }

    public DbDouble DDB(DbDouble dbDouble, DbDouble dbDouble2, DbDouble dbDouble3, DbDouble dbDouble4, DbDouble dbDouble5) {
        double d;
        if (dbDouble.bNull || dbDouble2.bNull || dbDouble3.bNull || dbDouble4.bNull || dbDouble5.bNull) {
            this.cache[2].bNull = true;
            return (DbDouble)this.cache[2];
        }
        double d2 = d = dbDouble.value * dbDouble5.value / dbDouble3.value;
        int n = 1;
        while ((double)n < dbDouble4.value) {
            d = (dbDouble.value - d2) * dbDouble5.value / dbDouble3.value;
            d2 += d;
            ++n;
        }
        if (dbDouble3.value == dbDouble4.value && dbDouble.value - d2 - dbDouble2.value < 0.0) {
            d += dbDouble.value - d2 - dbDouble2.value;
        }
        d = (d + 0.005) * 100.0;
        d = (long)d;
        ((DbDouble)this.cache[2]).value = d /= 100.0;
        this.cache[2].bNull = false;
        return (DbDouble)this.cache[2];
    }

    private DbValue LOCAL_LANGUAGE(DbBigInt dbBigInt, fArray fArray2, int n) {
        DbValue[] dbValueArray = fArray2.value;
        this.cache[n].bNull = true;
        if (dbBigInt.bNull) {
            return this.cache[n];
        }
        if ((int)dbBigInt.value > dbValueArray.length || (int)dbBigInt.value < 0) {
            return this.cache[n];
        }
        DbValue dbValue = dbValueArray[(int)dbBigInt.value];
        this.cache[n].set(dbValue);
        return this.cache[n];
    }

    public DbBigInt choose(DbBigInt dbBigInt, fIntArray fIntArray2) {
        return (DbBigInt)this.LOCAL_LANGUAGE(dbBigInt, fIntArray2, 1);
    }

    public DbDouble choose(DbBigInt dbBigInt, fNumArray fNumArray2) {
        return (DbDouble)this.LOCAL_LANGUAGE(dbBigInt, fNumArray2, 2);
    }

    public fCurrency choose(DbBigInt dbBigInt, fCurArray fCurArray2) {
        return (fCurrency)this.LOCAL_LANGUAGE(dbBigInt, fCurArray2, 3);
    }

    public DbBit choose(DbBigInt dbBigInt, fBoolArray fBoolArray2) {
        return (DbBit)this.LOCAL_LANGUAGE(dbBigInt, fBoolArray2, 4);
    }

    public DbChar choose(DbBigInt dbBigInt, fStrArray fStrArray2) {
        return (DbChar)this.LOCAL_LANGUAGE(dbBigInt, fStrArray2, 5);
    }

    public DbDate choose(DbBigInt dbBigInt, fDateArray fDateArray2) {
        return (DbDate)this.LOCAL_LANGUAGE(dbBigInt, fDateArray2, 6);
    }

    public DbTime choose(DbBigInt dbBigInt, fTimeArray fTimeArray2) {
        return (DbTime)this.LOCAL_LANGUAGE(dbBigInt, fTimeArray2, 7);
    }

    public DbTimestamp choose(DbBigInt dbBigInt, fDateTimeArray fDateTimeArray2) {
        return (DbTimestamp)this.LOCAL_LANGUAGE(dbBigInt, fDateTimeArray2, 8);
    }

    public DbBinary choose(DbBigInt dbBigInt, fBinaryArray fBinaryArray2) {
        return (DbBinary)this.LOCAL_LANGUAGE(dbBigInt, fBinaryArray2, 9);
    }

    public fText choose(DbBigInt dbBigInt, fTextArray fTextArray2) {
        return (fText)this.LOCAL_LANGUAGE(dbBigInt, fTextArray2, 10);
    }

    public fImage choose(DbBigInt dbBigInt, fImageArray fImageArray2) {
        return (fImage)this.LOCAL_LANGUAGE(dbBigInt, fImageArray2, 11);
    }

    public DbValue Switch(fBoolArray fBoolArray2, fArray fArray2, int n) {
        int n2;
        DbValue[] dbValueArray = fBoolArray2.value;
        DbValue[] dbValueArray2 = fArray2.value;
        this.cache[n].bNull = true;
        if (dbValueArray.length != dbValueArray2.length) {
            return this.cache[n];
        }
        for (n2 = 0; n2 < dbValueArray.length; ++n2) {
            if (!((DbBit)dbValueArray[n2]).bNull) continue;
            return this.cache[n];
        }
        for (n2 = 0; n2 < dbValueArray.length; ++n2) {
            if (!((DbBit)dbValueArray[n2]).value) continue;
            this.cache[n].set(dbValueArray2[n2]);
            this.cache[n].bNull = false;
            return this.cache[n];
        }
        return this.cache[n];
    }

    public DbBigInt Switch(fBoolArray fBoolArray2, fIntArray fIntArray2) {
        return (DbBigInt)this.Switch(fBoolArray2, fIntArray2, 1);
    }

    public DbDouble Switch(fBoolArray fBoolArray2, fNumArray fNumArray2) {
        return (DbDouble)this.Switch(fBoolArray2, fNumArray2, 2);
    }

    public fCurrency Switch(fBoolArray fBoolArray2, fCurArray fCurArray2) {
        return (fCurrency)this.Switch(fBoolArray2, fCurArray2, 3);
    }

    public DbBit Switch(fBoolArray fBoolArray2, fBoolArray fBoolArray3) {
        return (DbBit)this.Switch(fBoolArray2, fBoolArray3, 4);
    }

    public DbChar Switch(fBoolArray fBoolArray2, fStrArray fStrArray2) {
        return (DbChar)this.Switch(fBoolArray2, fStrArray2, 5);
    }

    public DbDate Switch(fBoolArray fBoolArray2, fDateArray fDateArray2) {
        return (DbDate)this.Switch(fBoolArray2, fDateArray2, 6);
    }

    public DbTime Switch(fBoolArray fBoolArray2, fTimeArray fTimeArray2) {
        return (DbTime)this.Switch(fBoolArray2, fTimeArray2, 7);
    }

    public DbTimestamp Switch(fBoolArray fBoolArray2, fDateTimeArray fDateTimeArray2) {
        return (DbTimestamp)this.Switch(fBoolArray2, fDateTimeArray2, 8);
    }

    public DbBinary Switch(fBoolArray fBoolArray2, fBinaryArray fBinaryArray2) {
        return (DbBinary)this.Switch(fBoolArray2, fBinaryArray2, 9);
    }

    public fText Switch(fBoolArray fBoolArray2, fTextArray fTextArray2) {
        return (fText)this.Switch(fBoolArray2, fTextArray2, 10);
    }

    public fImage Switch(fBoolArray fBoolArray2, fImageArray fImageArray2) {
        return (fImage)this.Switch(fBoolArray2, fImageArray2, 11);
    }

    public DbBit xor(DbBit dbBit, DbBit dbBit2) {
        if (dbBit.bNull || dbBit2.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = dbBit.value && dbBit2.value ? false : dbBit.value || dbBit2.value;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbBit eqv(DbBit dbBit, DbBit dbBit2) {
        if (dbBit.bNull || dbBit2.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = dbBit.value && dbBit2.value ? true : !dbBit.value && !dbBit2.value;
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbBit isCountry(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[4].bNull = true;
        } else {
            Locale locale = Locale.getDefault();
            ((DbBit)this.cache[4]).value = locale.getCountry().equals(dbChar.value.trim());
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public DbSecurityContext getSecurityContext() {
        return this.javaFormula.securityContext;
    }

    public DbBit print(DbChar dbChar, DbValue dbValue) {
        return new DbBit(false);
    }

    public DbChar properCase(DbChar dbChar) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
        } else {
            boolean bl = true;
            String string = "";
            String string2 = dbChar.value;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (Character.isLetter(c)) {
                    if (bl) {
                        string = string + Character.toUpperCase(c);
                        bl = false;
                        continue;
                    }
                    string = string + Character.toLowerCase(c);
                    continue;
                }
                string = string + c;
                bl = true;
            }
            this.cache[5].bNull = false;
            ((DbChar)this.cache[5]).value = string;
        }
        return (DbChar)this.cache[5];
    }

    DbValue speckeyValChange(DbNumber dbNumber, DbNumber dbNumber2, SpecFormulaValueChange specFormulaValueChange, Record record, DbNumber dbNumber3) {
        boolean bl = specFormulaValueChange.isIncrease();
        int n = specFormulaValueChange.getTolerance();
        JRecord jRecord = (JRecord)record;
        int n2 = jRecord.getPosition() - 1;
        if (n2 < 1) {
            return dbNumber2;
        }
        boolean bl2 = false;
        if (dbNumber.compareTo(dbNumber3) == 0) {
            return dbNumber2;
        }
        if (dbNumber.bNull || dbNumber3.bNull) {
            bl2 = true;
        } else {
            switch (dbNumber.getSqlType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    long l = bl ? dbNumber.longValue() - dbNumber3.longValue() : dbNumber3.longValue() - dbNumber.longValue();
                    bl2 = l > (long)n;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    double d = bl ? dbNumber.doubleValue() - dbNumber3.doubleValue() : dbNumber3.doubleValue() - dbNumber.doubleValue();
                    bl2 = d > (double)n;
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = ((DbDecimal)dbNumber).get();
                    BigDecimal bigDecimal2 = ((DbDecimal)dbNumber3).get();
                    BigDecimal bigDecimal3 = bl ? bigDecimal.add(bigDecimal2.negate()) : bigDecimal2.add(bigDecimal.negate());
                    BigDecimal bigDecimal4 = new BigDecimal(n);
                    boolean bl3 = bl2 = bigDecimal3.compareTo(bigDecimal4) == 1;
                }
            }
        }
        if (bl2) {
            this.LONG_TIME(dbNumber2, dbNumber.getSqlType());
        }
        dbNumber3.set(dbNumber);
        return dbNumber2;
    }

    private void LONG_TIME(DbNumber dbNumber, int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                ((DbBigInt)dbNumber).set(dbNumber.longValue() + 1L);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                ((DbDouble)dbNumber).set(dbNumber.doubleValue() + 1.0);
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbNumber).set(new BigDecimal(dbNumber.doubleValue() + 1.0));
            }
        }
    }

    String specNameNum(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        String string = null;
        Number number = specFormulaNum.getInterval();
        if (dbNumber.isNull()) {
            string = specFormulaNum.isKeepNullGroup() ? specFormulaNum.getOtherGroupName() : "Others";
            return string;
        }
        switch (dbNumber.getSqlType()) {
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ((DbDecimal)dbNumber).get();
                BigDecimal bigDecimal2 = new BigDecimal(number.intValue());
                string = bigDecimal.multiply(bigDecimal2) + LONG_TIME + bigDecimal.add(new BigDecimal(1)).multiply(bigDecimal2);
                break;
            }
            case 7: {
                float f = dbNumber.floatValue();
                float f2 = number.floatValue();
                string = f * f2 + LONG_TIME + (f + 1.0f) * f2;
                break;
            }
            case 6: 
            case 8: {
                double d = dbNumber.doubleValue();
                double d2 = number.doubleValue();
                string = d * d2 + LONG_TIME + (d + 1.0) * d2;
                break;
            }
            case 5: {
                short s = dbNumber.shortValue();
                short s2 = number.shortValue();
                string = s * s2 + LONG_TIME + (s + 1) * s2;
                break;
            }
            case -6: {
                byte by = dbNumber.byteValue();
                byte by2 = number.byteValue();
                string = by * by2 + LONG_TIME + (by + 1) * by2;
                break;
            }
            case 4: {
                int n = dbNumber.intValue();
                int n2 = number.intValue();
                string = n * n2 + LONG_TIME + (n + 1) * n2;
                break;
            }
            case -5: {
                long l = dbNumber.longValue();
                long l2 = number.longValue();
                string = l * l2 + LONG_TIME + (l + 1L) * l2;
            }
        }
        return string;
    }

    DbValue specKeyNum(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbValue dbValue = null;
        if (dbNumber.isNull()) {
            return dbValue;
        }
        switch (dbNumber.getSqlType()) {
            case 2: 
            case 3: {
                dbValue = this.MRound((DbDecimal)dbNumber, specFormulaNum);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                dbValue = this.Minute(dbNumber, specFormulaNum);
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                dbValue = this.Month(dbNumber, specFormulaNum);
            }
        }
        return dbValue;
    }

    private DbDecimal MRound(DbDecimal dbDecimal, SpecFormulaNum specFormulaNum) {
        DbDecimal dbDecimal2 = new DbDecimal();
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        BigDecimal bigDecimal = dbDecimal.get();
        BigDecimal bigDecimal2 = new BigDecimal(number.intValue());
        BigDecimal bigDecimal3 = new BigDecimal(number2.intValue());
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = new BigDecimal(0);
        bigDecimal4 = bigDecimal.compareTo(bigDecimal5) == 1 || bigDecimal.compareTo(bigDecimal5) == 0 ? bigDecimal.divide(bigDecimal2, 0, 1).add(bigDecimal3) : bigDecimal.divide(bigDecimal2, 0, 1).add(new BigDecimal(-1)).add(bigDecimal3);
        dbDecimal2.set(bigDecimal4);
        return dbDecimal2;
    }

    private DbValue Minute(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbNumber dbNumber2 = null;
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        double d = dbNumber.doubleValue();
        double d2 = number.doubleValue();
        double d3 = number2.doubleValue();
        double d4 = 0.0;
        d4 = d >= 0.0 ? d / d2 + d3 : d / d2 - 1.0 + d3;
        d4 = Math.floor(d4);
        switch (dbNumber.getSqlType()) {
            case 7: {
                dbNumber2 = new DbReal();
                ((DbReal)dbNumber2).set((float)d4);
                break;
            }
            case 6: 
            case 8: {
                dbNumber2 = new DbDouble();
                ((DbDouble)dbNumber2).set(d4);
            }
        }
        return dbNumber2;
    }

    private DbValue Month(DbNumber dbNumber, SpecFormulaNum specFormulaNum) {
        DbNumber dbNumber2 = null;
        Number number = specFormulaNum.getInterval();
        Number number2 = specFormulaNum.getStartPoint();
        long l = dbNumber.longValue();
        long l2 = number.longValue();
        long l3 = number2.longValue();
        long l4 = 0L;
        l4 = l >= 0L ? l / l2 + l3 : l / l2 - 1L + l3;
        switch (dbNumber.getSqlType()) {
            case 5: {
                dbNumber2 = new DbSmallInt();
                ((DbSmallInt)dbNumber2).set((short)l4);
                break;
            }
            case -6: {
                dbNumber2 = new DbTinyInt();
                ((DbTinyInt)dbNumber2).set((byte)l4);
                break;
            }
            case 4: {
                dbNumber2 = new DbInteger();
                ((DbInteger)dbNumber2).set((int)l4);
                break;
            }
            case -5: {
                dbNumber2 = new DbBigInt();
                ((DbBigInt)dbNumber2).set(l4);
            }
        }
        return dbNumber2;
    }

    String specNameString(DbChar dbChar, SpecFormulaString specFormulaString) {
        String string = null;
        if (dbChar.isNull()) {
            string = specFormulaString.isKeepNullGroup() ? specFormulaString.getOtherGroupName() : "Others";
            return string;
        }
        string = dbChar.get();
        int n = specFormulaString.getConvertGroupName();
        switch (n) {
            case 2: {
                string = string.toUpperCase();
                break;
            }
            case 3: {
                string = string.toLowerCase();
            }
        }
        return string;
    }

    String specKeyString(DbChar dbChar, SpecFormulaString specFormulaString) {
        String string = null;
        if (dbChar.bNull) {
            return string;
        }
        int n = specFormulaString.getIntervalType();
        string = dbChar.get().trim();
        int n2 = string.length();
        int n3 = specFormulaString.getLength();
        char c = specFormulaString.getStuff();
        int n4 = 0;
        int n5 = 0;
        switch (n) {
            case 1: {
                n5 = n4 + n3;
                if (n5 > n2) {
                    for (int i = n5 - n2; i > 0; --i) {
                        string = string + c;
                    }
                    break;
                }
                string = string.substring(n4, n5);
                break;
            }
            case 2: {
                n4 = n2 - n3;
                if (n4 < 0) {
                    for (int i = n4; i < 0; ++i) {
                        string = c + string;
                    }
                    break;
                }
                string = string.substring(n4);
            }
        }
        return string;
    }

    public DbValue specKeyDateTime(DbDateTime dbDateTime, SpecFormulaDateTime specFormulaDateTime) {
        int n = dbDateTime instanceof DbDate ? 6 : (dbDateTime instanceof DbTime ? 7 : 8);
        TimeZone timeZone = TimeZone.getDefault();
        if (specFormulaDateTime.useZoneOffset()) {
            timeZone = specFormulaDateTime.getTimeZone();
        } else if (this.tz != null) {
            timeZone = this.tz;
        }
        TimeZone timeZone2 = this.gc.getTimeZone();
        this.gc.setTimeZone(timeZone);
        this.bgc.setTimeZone(timeZone);
        switch (specFormulaDateTime.getUnit()) {
            case 1: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(2, 0);
                this.gc.set(5, 1);
                int n2 = specFormulaDateTime.getInterval();
                if (n2 != 1) {
                    int n3 = this.NPer(this.gc);
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    int n4 = this.NPer(this.bgc);
                    int n5 = (n3 - n4) % n2;
                    if (n5 < 0) {
                        n5 += n2;
                    }
                    this.gc.add(1, -1 * n5);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 2: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(5, 1);
                int n6 = specFormulaDateTime.getInterval();
                if (n6 != 1) {
                    int n7 = this.NPer(this.gc);
                    int n8 = this.gc.get(2);
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    int n9 = this.NPer(this.bgc);
                    int n10 = this.bgc.get(2);
                    int n11 = ((n7 - n9) * 12 + (n8 - n10)) % n6;
                    if (n11 < 0) {
                        n11 += n6;
                    }
                    this.gc.add(2, -1 * n11);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 5: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n12 = specFormulaDateTime.getInterval();
                if (n12 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l2 = this.bgc.getTimeInMillis();
                    int n13 = (int)((l - l2) / 86400000L) % n12;
                    if (n13 < 0) {
                        n13 += n12;
                    }
                    this.gc.add(5, -1 * n13);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 10: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n14 = specFormulaDateTime.getInterval();
                if (n14 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l3 = this.bgc.getTimeInMillis();
                    int n15 = (int)((l - l3) / 3600000L) % n14;
                    if (n15 < 0) {
                        n15 += n14;
                    }
                    this.gc.add(11, -1 * n15);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 12: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                int n16 = specFormulaDateTime.getInterval();
                if (n16 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    long l4 = this.bgc.getTimeInMillis();
                    int n17 = (int)((l - l4) / 60000L) % n16;
                    if (n17 < 0) {
                        n17 += n16;
                    }
                    this.gc.add(12, -1 * n17);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 13: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(14, 0);
                int n18 = specFormulaDateTime.getInterval();
                if (n18 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(14, 0);
                    long l5 = this.bgc.getTimeInMillis();
                    int n19 = (int)((l - l5) / 1000L) % n18;
                    if (n19 < 0) {
                        n19 += n18;
                    }
                    this.gc.add(13, -1 * n19);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 20: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                if (this.gc.get(2) < 6) {
                    this.gc.set(2, 0);
                } else {
                    this.gc.set(2, 6);
                }
                this.gc.set(5, 1);
                int n20 = specFormulaDateTime.getInterval();
                if (n20 != 1) {
                    int n21 = this.NPer(this.gc);
                    int n22 = this.gc.get(2);
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    if (this.bgc.get(2) < 6) {
                        this.bgc.set(2, 0);
                    } else {
                        this.bgc.set(2, 6);
                    }
                    this.bgc.set(5, 1);
                    int n23 = this.NPer(this.bgc);
                    int n24 = this.bgc.get(2);
                    int n25 = ((n21 - n23) * 12 + (n22 - n24)) % n20;
                    if (n25 < 0) {
                        n25 += n20;
                    }
                    this.gc.add(2, -1 * n25);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 21: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                if (this.gc.get(5) < 16) {
                    this.gc.set(5, 1);
                } else {
                    this.gc.set(5, 16);
                }
                int n26 = specFormulaDateTime.getInterval();
                if (n26 != 1) {
                    int n27 = this.NPer(this.gc);
                    int n28 = this.gc.get(2);
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    if (this.bgc.get(5) < 16) {
                        this.bgc.set(5, 1);
                    } else {
                        this.bgc.set(5, 16);
                    }
                    int n29 = this.NPer(this.bgc);
                    int n30 = this.bgc.get(2);
                    int n31 = (n27 - n29) * 12 + (n28 - n30);
                    int n32 = this.gc.get(5) == this.bgc.get(5) ? 0 : (this.gc.get(5) > this.bgc.get(5) ? 1 : -1);
                    int n33 = (n31 * 2 + n32) % n26;
                    if (n33 < 0) {
                        n33 += n26;
                    }
                    this.gc.add(2, -1 * (n33 - n33 % 2));
                    if (n33 % 2 != 0) {
                        if (this.gc.get(5) > 1) {
                            this.bgc.set(5, 1);
                        } else {
                            this.gc.add(2, -1);
                            this.bgc.set(5, 16);
                        }
                    }
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 22: {
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(5, 1);
                if (this.gc.get(2) < 3) {
                    this.gc.set(2, 0);
                } else if (this.gc.get(2) < 6) {
                    this.gc.set(2, 3);
                } else if (this.gc.get(2) < 9) {
                    this.gc.set(2, 6);
                } else {
                    this.gc.set(2, 9);
                }
                int n34 = specFormulaDateTime.getInterval();
                if (n34 != 1) {
                    int n35 = this.NPer(this.gc);
                    int n36 = this.gc.get(2);
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    this.bgc.set(5, 1);
                    if (this.bgc.get(2) < 3) {
                        this.bgc.set(2, 0);
                    } else if (this.bgc.get(2) < 6) {
                        this.bgc.set(2, 3);
                    } else if (this.bgc.get(2) < 9) {
                        this.bgc.set(2, 6);
                    } else {
                        this.bgc.set(2, 9);
                    }
                    int n37 = this.NPer(this.bgc);
                    int n38 = this.bgc.get(2);
                    int n39 = ((n35 - n37) * 12 + (n36 - n38)) / 3 % n34;
                    if (n39 < 0) {
                        n39 += n34;
                    }
                    this.gc.add(2, -3 * n39);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            case 23: 
            case 24: {
                int n40 = specFormulaDateTime.getUnit() == 24 ? specFormulaDateTime.getInterval() : specFormulaDateTime.getInterval() * 2;
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                this.gc.set(11, 0);
                this.gc.set(12, 0);
                this.gc.set(13, 0);
                this.gc.set(14, 0);
                this.gc.set(7, this.gc.getFirstDayOfWeek());
                if (n40 != 1) {
                    long l = this.gc.getTimeInMillis();
                    this.bgc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.bgc.setTime(specFormulaDateTime.getBenchmarkPoint());
                    this.bgc.computeFields();
                    this.bgc.set(11, 0);
                    this.bgc.set(12, 0);
                    this.bgc.set(13, 0);
                    this.bgc.set(14, 0);
                    this.bgc.set(7, this.gc.getFirstDayOfWeek());
                    long l6 = this.bgc.getTimeInMillis();
                    int n41 = (int)((l - l6) / 604800000L % (long)n40);
                    if (n41 < 0) {
                        n41 += n40;
                    }
                    this.gc.add(3, -1 * n41);
                }
                ((DbDateTime)this.cache[n]).value = this.gc.getTimeInLong();
                this.cache[n].bNull = false;
                break;
            }
            default: {
                assert (false) : "unknown SpecFormulaDateTime time unit" + specFormulaDateTime.getUnit();
                this.gc.setTimeZone(timeZone2);
                return null;
            }
        }
        this.gc.setTimeZone(timeZone2);
        return this.cache[n];
    }

    private int NPer(MyCalendar myCalendar) {
        int n = myCalendar.get(1);
        if (myCalendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    public String specNameDateTime(DbDateTime dbDateTime, SpecFormulaDateTime specFormulaDateTime) {
        String string = null;
        if (dbDateTime.isNull()) {
            string = specFormulaDateTime.isKeepNullGroup() ? specFormulaDateTime.getOtherGroupName() : "Others";
            return string;
        }
        TimeZone timeZone = TimeZone.getDefault();
        if (specFormulaDateTime.useZoneOffset()) {
            timeZone = specFormulaDateTime.getTimeZone();
        } else if (this.tz != null) {
            timeZone = this.tz;
        }
        TimeZone timeZone2 = this.gc.getTimeZone();
        this.gc.setTimeZone(timeZone);
        switch (specFormulaDateTime.getUnit()) {
            case 1: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string2 = this.Quarter(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string2;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(1, n - 1);
                stringBuffer.append(this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 2: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string3 = this.Prev(this.gc) + "/" + this.Quarter(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string3;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n - 1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 5: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string4 = this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string4;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(5, n - 1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 10: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string5 = this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":00";
                    this.gc.setTimeZone(timeZone2);
                    return string5;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":00");
                stringBuffer.append('-');
                this.gc.add(11, n - 1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":00");
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 12: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string6 = this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string6;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc));
                stringBuffer.append('-');
                this.gc.add(12, n - 1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 13: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string7 = this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc) + ":" + this.PPmt(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string7;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc) + ":" + this.PPmt(this.gc));
                stringBuffer.append('-');
                this.gc.add(13, n - 1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc) + " " + this.Pmt(this.gc) + ":" + this.PV(this.gc) + ":" + this.PPmt(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 20: {
                int n = specFormulaDateTime.getInterval();
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n * 6);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 22: {
                int n = specFormulaDateTime.getInterval();
                if (n == 1) {
                    this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                    this.gc.setTime(dbDateTime.value);
                    this.gc.computeFields();
                    String string8 = this.Next(this.gc) + "," + this.Quarter(this.gc);
                    this.gc.setTimeZone(timeZone2);
                    return string8;
                }
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Next(this.gc) + "," + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n * 3);
                stringBuffer.append(this.Next(this.gc) + "," + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 21: {
                int n = specFormulaDateTime.getInterval();
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(2, n - n % 2);
                if (n % 2 != 0) {
                    if (this.gc.get(5) == 1) {
                        this.gc.set(5, 16);
                    } else {
                        this.gc.add(2, 1);
                        this.gc.set(5, 1);
                    }
                }
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
            case 23: 
            case 24: {
                int n = specFormulaDateTime.getUnit() == 24 ? specFormulaDateTime.getInterval() : specFormulaDateTime.getInterval() * 2;
                this.gc.setFirstDayOfWeek(specFormulaDateTime.getFirstDayOfWeek());
                this.gc.setTime(dbDateTime.value);
                this.gc.computeFields();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                stringBuffer.append('-');
                this.gc.add(3, n);
                this.gc.add(5, -1);
                stringBuffer.append(this.Prev(this.gc) + "/" + this.PopulationVariance(this.gc) + "/" + this.Quarter(this.gc));
                this.gc.setTimeZone(timeZone2);
                return stringBuffer.toString();
            }
        }
        assert (false) : "unknown SpecFormulaDateTime time unit" + specFormulaDateTime.getUnit();
        return null;
    }

    private String Next(MyCalendar myCalendar) {
        return String.valueOf(this.gc.get(2) / 3 + 1);
    }

    private String PPmt(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(13));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String PV(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(12));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Pmt(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(11));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String PopulationVariance(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(5));
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Prev(MyCalendar myCalendar) {
        String string = String.valueOf(this.gc.get(2) + 1);
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private String Quarter(MyCalendar myCalendar) {
        return String.valueOf(myCalendar.get(1)) + (myCalendar.get(0) == 0 ? " BC" : "");
    }

    public DbDate FirstDayOfWeek(DbDateTime dbDateTime) {
        return this.ForEachWeek(dbDateTime);
    }

    public DbDate FirstDayOfMonth(DbDateTime dbDateTime) {
        return this.ForEachMonth(dbDateTime);
    }

    public DbDate FirstDayOfYear(DbDateTime dbDateTime) {
        return this.ForEachYear(dbDateTime);
    }

    public DbDate FirstDayOfQuarter(DbDateTime dbDateTime) {
        return this.ForEachQuarter(dbDateTime);
    }

    public DbDate FirstSundayOfMonth(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            this.gc.set(5, 1);
            int n = this.gc.get(7);
            if (n != 1) {
                n = 7 - n + 1;
                this.gc.add(5, n);
            }
            ((DbDate)this.cache[6]).value = this.gc.getTimeInMillis();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbDate FirstSundayOfYear(DbDateTime dbDateTime) {
        if (dbDateTime.bNull) {
            this.cache[6].bNull = true;
        } else {
            this.gc.setTime(dbDateTime.value);
            this.gc.computeFields();
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
            this.gc.set(14, 0);
            this.gc.set(5, 1);
            this.gc.set(6, 1);
            int n = this.gc.get(7);
            if (n != 1) {
                n = 7 - n + 1;
                this.gc.add(5, n);
            }
            ((DbDate)this.cache[6]).value = this.gc.getTimeInMillis();
            this.cache[6].bNull = false;
        }
        return (DbDate)this.cache[6];
    }

    public DbBit isAll(fArray fArray2) {
        if (fArray2.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = fArray2.isAll();
            this.cache[4].bNull = false;
        }
        return (DbBit)this.cache[4];
    }

    public void setSelectedDate(java.util.Date date) {
        this.MRound = date;
    }

    public DbTimestamp selectedDate() {
        if (null != this.MRound) {
            ((DbTimestamp)this.cache[8]).value = this.MRound.getTime();
            this.cache[8].bNull = false;
            return (DbTimestamp)this.cache[8];
        }
        return this.CurrentDateTime();
    }

    public DbBit any(fBoolArray fBoolArray2) {
        if (fBoolArray2.bNull) {
            this.cache[4].bNull = true;
        } else {
            ((DbBit)this.cache[4]).value = false;
            if (fBoolArray2.value.length == 0) {
                this.cache[4].bNull = false;
            } else {
                for (int i = 0; i < fBoolArray2.value.length; ++i) {
                    if (fBoolArray2.value[i].bNull) continue;
                    this.cache[4].bNull = false;
                    if (!((DbBit)fBoolArray2.value[i]).value) continue;
                    ((DbBit)this.cache[4]).value = true;
                    break;
                }
            }
        }
        return (DbBit)this.cache[4];
    }

    public DbBit every(fBoolArray fBoolArray2) {
        if (fBoolArray2.bNull) {
            this.cache[4].bNull = true;
        } else {
            this.cache[4].bNull = false;
            if (fBoolArray2.value.length == 0) {
                ((DbBit)this.cache[4]).value = false;
            } else {
                ((DbBit)this.cache[4]).value = true;
                for (int i = 0; i < fBoolArray2.value.length; ++i) {
                    if (!fBoolArray2.value[i].bNull && ((DbBit)fBoolArray2.value[i]).value) continue;
                    ((DbBit)this.cache[4]).value = false;
                    break;
                }
            }
        }
        return (DbBit)this.cache[4];
    }

    private InformationContainer REPORT_NAME(int n) {
        InformationBusManager informationBusManager = this.javaFormula.getInformationBusManager();
        if (informationBusManager == null) {
            return null;
        }
        InformationBus informationBus = informationBusManager.getInformationBus(this.javaFormula.__sys__USERNAME.get());
        if (informationBus == null) {
            return null;
        }
        InformationContainer informationContainer = null;
        switch (n) {
            case 0: {
                informationContainer = informationBus.getGlobalInformationContainer();
                break;
            }
            case 1: {
                informationContainer = informationBus.getOrganizationInformationContainer();
                break;
            }
            case 2: {
                informationContainer = informationBus.getUserInformationContainer();
            }
        }
        return informationContainer;
    }

    private Object getInfo(int n, DbChar dbChar) {
        if (dbChar.bNull) {
            return null;
        }
        InformationContainer informationContainer = this.REPORT_NAME(n);
        if (informationContainer == null) {
            return null;
        }
        return informationContainer.getInfo(dbChar.value);
    }

    public DbChar getInfo(DbChar dbChar) {
        Object object = this.getInfo(0, dbChar);
        if (object != null) {
            ((DbChar)this.cache[5]).value = object.toString();
            this.cache[5].bNull = false;
        } else {
            this.cache[5].bNull = true;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar putInfo(DbChar dbChar, DbChar dbChar2) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(0)) != null) {
            informationContainer.putInfo(dbChar.value, (Serializable)((Object)dbChar2.value), InfoLifeCycleType.LONG_TIME, null);
        }
        return dbChar;
    }

    public DbChar removeInfo(DbChar dbChar) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(0)) != null) {
            informationContainer.removeInfo(dbChar.value);
        }
        return dbChar;
    }

    public DbChar getOrgInfo(DbChar dbChar) {
        Object object = this.getInfo(1, dbChar);
        if (object != null) {
            ((DbChar)this.cache[5]).value = object.toString();
            this.cache[5].bNull = false;
        } else {
            this.cache[5].bNull = true;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar putOrgInfo(DbChar dbChar, DbChar dbChar2) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(1)) != null) {
            informationContainer.putInfo(dbChar.value, (Serializable)((Object)dbChar2.value), InfoLifeCycleType.LONG_TIME, null);
        }
        return dbChar;
    }

    public DbChar removeOrgInfo(DbChar dbChar) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(1)) != null) {
            informationContainer.removeInfo(dbChar.value);
        }
        return dbChar;
    }

    public DbChar getUserInfo(DbChar dbChar) {
        Object object = this.getInfo(2, dbChar);
        if (object != null) {
            ((DbChar)this.cache[5]).value = object.toString();
            this.cache[5].bNull = false;
        } else {
            this.cache[5].bNull = true;
        }
        return (DbChar)this.cache[5];
    }

    public DbChar putUserInfo(DbChar dbChar, DbChar dbChar2) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(2)) != null) {
            informationContainer.putInfo(dbChar.value, (Serializable)((Object)dbChar2.value), InfoLifeCycleType.LONG_TIME, null);
        }
        return dbChar;
    }

    public DbChar removeUserInfo(DbChar dbChar) {
        InformationContainer informationContainer;
        if (!dbChar.bNull && (informationContainer = this.REPORT_NAME(2)) != null) {
            informationContainer.removeInfo(dbChar.value);
        }
        return dbChar;
    }

    public DbChar Translate(DbChar dbChar) {
        return null;
    }

    private String translate(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        JFieldValueNLSManager jFieldValueNLSManager = this.javaFormula.getJFieldValueNLSManager();
        if (jFieldValueNLSManager == null) {
            return string;
        }
        return jFieldValueNLSManager.getFieldBindNLSValue(string2, string);
    }

    public DbChar Translate(DbChar dbChar, DbChar dbChar2) {
        if (dbChar2.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        if (dbChar.bNull) {
            ((DbChar)this.cache[5]).set(dbChar2);
        } else {
            String string = this.translate(dbChar2.value, dbChar.value);
            if (string != null) {
                ((DbChar)this.cache[5]).value = string;
            } else {
                ((DbChar)this.cache[5]).set(dbChar2);
            }
        }
        this.cache[5].bNull = false;
        return (DbChar)this.cache[5];
    }

    private DbChar ROUND_MODEL_KEY(DbChar dbChar, DbChar dbChar2, boolean bl) {
        if (dbChar.bNull) {
            this.cache[5].bNull = true;
            return (DbChar)this.cache[5];
        }
        if (dbChar2.bNull) {
            ((DbChar)this.cache[5]).set(dbChar);
        } else {
            HashMap hashMap = null;
            hashMap = bl ? this.javaFormula.getParamDataMapping() : this.javaFormula.getFieldDataMapping();
            if (hashMap == null) {
                ((DbChar)this.cache[5]).set(dbChar);
            } else {
                String string = (String)hashMap.get(dbChar2.value.toUpperCase());
                if (string == null) {
                    ((DbChar)this.cache[5]).set(dbChar);
                } else {
                    String string2 = this.translate(dbChar.value, string);
                    if (string2 != null) {
                        ((DbChar)this.cache[5]).value = string2;
                    } else {
                        ((DbChar)this.cache[5]).set(dbChar);
                    }
                }
            }
        }
        this.cache[5].bNull = false;
        return (DbChar)this.cache[5];
    }

    public DbChar TranslateByFieldName(DbChar dbChar, DbChar dbChar2) {
        return this.ROUND_MODEL_KEY(dbChar, dbChar2, false);
    }

    public DbChar TranslateByParamName(DbChar dbChar, DbChar dbChar2) {
        return this.ROUND_MODEL_KEY(dbChar, dbChar2, true);
    }

    public DbChar TranslateByFieldName(DbChar dbChar, String string) {
        this.Next.set(string);
        return this.ROUND_MODEL_KEY(dbChar, this.Next, false);
    }

    public DbChar TranslateByParamName(DbChar dbChar, String string) {
        this.Next.set(string);
        return this.ROUND_MODEL_KEY(dbChar, this.Next, true);
    }

    static {
        Hour.put("1", "January");
        Hour.put("2", "February");
        Hour.put("3", "March");
        Hour.put("4", "April");
        Hour.put("5", "May");
        Hour.put("6", "June");
        Hour.put("7", "July");
        Hour.put("8", "August");
        Hour.put("9", "September");
        Hour.put("10", "October");
        Hour.put("11", "November");
        Hour.put("12", "December");
        IPmt = new Hashtable();
        IPmt.put("1", "Jan");
        IPmt.put("2", "Feb");
        IPmt.put("3", "Mar");
        IPmt.put("4", "Apr");
        IPmt.put("5", "May");
        IPmt.put("6", "Jun");
        IPmt.put("7", "Jul");
        IPmt.put("8", "Aug");
        IPmt.put("9", "Sep");
        IPmt.put("10", "Oct");
        IPmt.put("11", "Nov");
        IPmt.put("12", "Dec");
        weekdayToName = new Hashtable();
        weekdayToName.put("1", "Sunday");
        weekdayToName.put("2", "Monday");
        weekdayToName.put("3", "Tuesday");
        weekdayToName.put("4", "Wednesday");
        weekdayToName.put("5", "Thursday");
        weekdayToName.put("6", "Friday");
        weekdayToName.put("7", "Saturday");
        weekdayToAbbr = new Hashtable();
        weekdayToAbbr.put("1", "Sun");
        weekdayToAbbr.put("2", "Mon");
        weekdayToAbbr.put("3", "Tues");
        weekdayToAbbr.put("4", "Wed");
        weekdayToAbbr.put("5", "Thu");
        weekdayToAbbr.put("6", "Fri");
        weekdayToAbbr.put("7", "Sat");
        firstdayOfWeek = new Hashtable();
        firstdayOfWeek.put("JRUSESYSTEM", "0");
        firstdayOfWeek.put("JRSUNDAY", "1");
        firstdayOfWeek.put("JRMONDAY", "2");
        firstdayOfWeek.put("JRTUESDAY", "3");
        firstdayOfWeek.put("JRWEDNESDAY", "4");
        firstdayOfWeek.put("JRTHURSDAY", "5");
        firstdayOfWeek.put("JRFRIDAY", "6");
        firstdayOfWeek.put("JRSATURDAY", "7");
        dateFormats = new String[25];
        Functions.dateFormats[0] = "MMM. dd, yy";
        Functions.dateFormats[1] = "MMM dd, yy";
        Functions.dateFormats[2] = "MMM. dd,yy";
        Functions.dateFormats[3] = "MMM dd,yy";
        Functions.dateFormats[4] = "yy-MM-dd";
        Functions.dateFormats[5] = "yy/MM/dd";
        Functions.dateFormats[6] = "yy MM dd";
        Functions.dateFormats[7] = "MM/dd/yy";
        Functions.dateFormats[8] = "MM-dd-yy";
        Functions.dateFormats[9] = "MM dd yy";
        Functions.dateFormats[10] = "dd-MM-yy";
        Functions.dateFormats[11] = "dd/MM/yy";
        Functions.dateFormats[12] = "dd MM yy";
        Functions.dateFormats[13] = "yy-MM";
        Functions.dateFormats[14] = "yy/MM";
        Functions.dateFormats[15] = "yy MM";
        Functions.dateFormats[16] = "MM-dd";
        Functions.dateFormats[17] = "MM/dd";
        Functions.dateFormats[18] = "MM dd";
        Functions.dateFormats[19] = "dd-MM";
        Functions.dateFormats[20] = "dd/MM";
        Functions.dateFormats[21] = "dd MM";
        Functions.dateFormats[22] = "MM-yy";
        Functions.dateFormats[23] = "MM/yy";
        Functions.dateFormats[24] = "MM yy";
        timeFormats = new String[5];
        Functions.timeFormats[0] = "kk:mm:ss a";
        Functions.timeFormats[1] = "kk:mm:ss";
        Functions.timeFormats[2] = "kk:mm a";
        Functions.timeFormats[3] = "kk:mm";
        Functions.timeFormats[4] = "kk a";
        datetimeFormats = new String[52];
        Functions.datetimeFormats[0] = "MMM. d, yy kk:mm:ss a";
        Functions.datetimeFormats[1] = "MMM. d, yy kk:mm:ss";
        Functions.datetimeFormats[2] = "MMM. d, yy kk:mm a";
        Functions.datetimeFormats[3] = "MMM. d, yy kk:mm";
        Functions.datetimeFormats[4] = "MMM. d, yy kk a";
        Functions.datetimeFormats[5] = "MMM. d,yy kk:mm:ss a";
        Functions.datetimeFormats[6] = "MMM. d,yy kk:mm:ss";
        Functions.datetimeFormats[7] = "MMM. d,yy kk:mm a";
        Functions.datetimeFormats[8] = "MMM. d,yy kk:mm";
        Functions.datetimeFormats[9] = "MMM. d,yy kk a";
        Functions.datetimeFormats[10] = "MMM d, yy kk:mm:ss a";
        Functions.datetimeFormats[11] = "MMM d, yy kk:mm:ss";
        Functions.datetimeFormats[12] = "MMM d, yy kk:mm a";
        Functions.datetimeFormats[13] = "MMM d, yy kk:mm";
        Functions.datetimeFormats[14] = "MMM d, yy kk a";
        Functions.datetimeFormats[15] = "MMM d,yy kk:mm:ss a";
        Functions.datetimeFormats[16] = "MMM d,yy kk:mm:ss";
        Functions.datetimeFormats[17] = "MMM d,yy kk:mm a";
        Functions.datetimeFormats[18] = "MMM d,yy kk:mm";
        Functions.datetimeFormats[19] = "MMM d,yy kk a";
        Functions.datetimeFormats[20] = "yy-MM-dd kk:mm:ss a";
        Functions.datetimeFormats[21] = "yy-MM-dd kk:mm:ss";
        Functions.datetimeFormats[22] = "yy-MM-dd kk:mm a";
        Functions.datetimeFormats[23] = "yy-MM-dd kk:mm";
        Functions.datetimeFormats[24] = "yy-MM-dd kk a";
        Functions.datetimeFormats[25] = "yy/MM/dd kk:mm:ss a";
        Functions.datetimeFormats[26] = "yy/MM/dd kk:mm:ss";
        Functions.datetimeFormats[27] = "yy/MM/dd kk:mm a";
        Functions.datetimeFormats[28] = "yy/MM/dd kk:mm";
        Functions.datetimeFormats[29] = "yy/MM/dd kk a";
        Functions.datetimeFormats[30] = "yy MM dd kk:mm:ss a";
        Functions.datetimeFormats[31] = "yy MM dd kk:mm:ss";
        Functions.datetimeFormats[32] = "yy MM dd kk:mm a";
        Functions.datetimeFormats[33] = "yy MM dd kk:mm";
        Functions.datetimeFormats[34] = "yy MM dd kk a";
        Functions.datetimeFormats[35] = "yy-MM kk:mm:ss a";
        Functions.datetimeFormats[36] = "yy-MM kk:mm:ss";
        Functions.datetimeFormats[37] = "yy-MM kk:mm a";
        Functions.datetimeFormats[38] = "yy-MM kk:mm";
        Functions.datetimeFormats[39] = "yy-MM kk a";
        Functions.datetimeFormats[40] = "yy/MM kk:mm:ss a";
        Functions.datetimeFormats[41] = "yy/MM kk:mm:ss";
        Functions.datetimeFormats[42] = "yy/MM kk:mm a";
        Functions.datetimeFormats[43] = "yy/MM kk:mm";
        Functions.datetimeFormats[44] = "yy/MM kk a";
        Functions.datetimeFormats[45] = "yy MM kk:mm:ss a";
        Functions.datetimeFormats[46] = "yy MM kk:mm:ss";
        Functions.datetimeFormats[47] = "yy MM kk:mm a";
        Functions.datetimeFormats[48] = "yy MM kk:mm";
        Functions.datetimeFormats[49] = "yy MM kk a";
        Functions.datetimeFormats[50] = "yy-MM-dd kk:mm:ss.SSS";
        Functions.datetimeFormats[51] = "yy/MM/dd kk:mm:ss.SSS";
        IRR = new int[]{3, 2, 1, 0};
        ITALIAN = new String[]{"full", "LONG", "MEDIUM", "SHORT"};
        IsDate = new Locale[]{Locale.US, Locale.CHINA, Locale.FRANCE, Locale.GERMAN, Locale.ITALIAN, Locale.JAPAN, Locale.UK, Locale.CANADA, Locale.KOREA};
        IsDateTime = new Vector();
        IsTime = new Vector();
        JAPAN = new Vector();
        for (int n : IRR) {
            for (Locale locale : IsDate) {
                IsDateTime.add(DateFormat.getDateInstance(n, locale));
                IsTime.add(DateFormat.getTimeInstance(n, locale));
                for (int n2 : IRR) {
                    JAPAN.add(DateFormat.getDateTimeInstance(n2, n, locale));
                }
            }
        }
    }
}

