/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbArray;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetColumn;
import jet.controls.JetString;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.AggDesc;
import jet.formula.Aggregation;
import jet.formula.DataTypeDef;
import jet.formula.ExecutableJavaFormula;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.FormulatoJava;
import jet.formula.JavaFormula;
import jet.formula.SqlwNode;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.crossref.NameCollector;
import jet.formula.fArray;
import jet.formula.formula;
import jet.formula.syntaxtree.Symbol;
import jet.log.JRLogger;
import toolkit.db.gui.MappingSQLType;

public class JetRptFormula
extends JetColumn {
    public static final int NOGUI = -1;
    public static final int DETAIL = 1;
    public static final int BEFORGROUP = 2;
    public static final int AFTERGROUP = 3;
    public JetString name = new JetString(this, "Name");
    public JetString expr = new JetString(this, "Expression");
    public FormulaInfo formulainfo;
    public int GUIinfo = -1;
    public String expectGroup;
    public int pass = -1;
    FormulaContainer datasource = null;
    String brokegroup = null;
    boolean parsed = false;
    boolean parsing = false;
    FormulatoJava f2j;
    DbColDesc coldesc = null;
    public static String executingformula = null;
    public String expectedvalue = null;
    private static JRLogger FmlToSql = JRLogger.getLogger(JetRptFormula.class.getName());
    protected ExecutableJavaFormula ejf;
    NameCollector nc = null;
    protected boolean isDenied = false;
    public static final int NORMAL_MAP = 0;
    public static final int ME_MAP = 1;
    Hashtable[] nameMapping = new Hashtable[2];
    Hashtable[] aggDescMap = new Hashtable[2];

    public JetRptFormula() {
    }

    public JetRptFormula(String string, String string2, FormulaContainer formulaContainer, FormulaInfo formulaInfo) {
        this(string, string2, formulaContainer);
        this.formulainfo = formulaInfo;
    }

    public JetRptFormula(String string, String string2, FormulaContainer formulaContainer) {
        this.datasource = formulaContainer;
        this.name.set(string);
        this.expr.set(string2);
    }

    public void setExecutableJavaFormula(ExecutableJavaFormula executableJavaFormula) {
        this.ejf = executableJavaFormula;
    }

    public DbValue execConstFML(JavaFormula javaFormula) {
        JavaFormula javaFormula2 = javaFormula;
        if (javaFormula2.isJavaFormulaContainer()) {
            javaFormula2 = this.ejf;
        }
        try {
            javaFormula2.setCurrentExecutingFormula(this);
            DbValue dbValue = javaFormula2.schedule(this.formulainfo.callee);
            if (dbValue != null) {
                dbValue = (DbValue)dbValue.clone();
            }
            dbValue.setColDesc(this.getColDesc());
            return dbValue;
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
        }
    }

    public void exec(JavaFormula javaFormula) {
        DbValue dbValue;
        try {
            dbValue = javaFormula.getRecord().getCell(this.coldesc);
        }
        catch (Exception exception) {
            dbValue = javaFormula.getRecord().getCell(this.getName().toUpperCase());
            this.coldesc.setColIndex(dbValue.getColDesc().getColIndex());
        }
        try {
            javaFormula.setCurrentExecutingFormula(this);
            DbValue dbValue2 = javaFormula.schedule(this.formulainfo.callee);
            int n = this.formulainfo.formulatype.getDataType();
            if (DataTypeDef.isArray(n)) {
                fArray fArray2 = (fArray)dbValue2;
                if (dbValue2 == null || dbValue2.bNull) {
                    dbValue.setNull();
                } else {
                    Object object = fArray2.getArray(n);
                    int n2 = 0;
                    n2 = fArray2.value == null ? 0 : fArray2.value.length;
                    ((DbArray)dbValue).setValue(object, n2);
                }
            } else {
                dbValue.set(dbValue2);
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()), arithmeticException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()), indexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            throw numberFormatException;
        }
    }

    public DbValue execSpec(JavaFormula javaFormula) {
        DbValue dbValue;
        block5: {
            JavaFormula javaFormula2 = javaFormula;
            if (javaFormula2.isJavaFormulaContainer()) {
                javaFormula2 = this.ejf;
            }
            dbValue = null;
            try {
                javaFormula2.setCurrentExecutingFormula(this);
                dbValue = javaFormula2.schedule(this.formulainfo.callee);
            }
            catch (ArithmeticException arithmeticException) {
                throw new RuntimeException(JResource.getMessage("FML_36", (Object)this.getName()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(JResource.getMessage("FML_37", (Object)this.getName()));
            }
            catch (NumberFormatException numberFormatException) {
                if (!FmlToSql.isDebugEnabled()) break block5;
                FmlToSql.debug(numberFormatException.getMessage(), numberFormatException);
            }
        }
        return dbValue;
    }

    public VarsTable getGVarTable() {
        try {
            return this.datasource.getGVarTable();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public JetRptFormula getFormula(String string) throws Exception {
        return this.datasource.getFormula(string);
    }

    public String getRealDbFieldName(String string) {
        return this.formulainfo.getRealDbFieldName(string);
    }

    public FormulaInfo getFormulaInfo(FormulatoJava formulatoJava) throws FormulaSyntaxErrorException {
        if (this.formulainfo != null && this.formulainfo.parseOK) {
            return this.formulainfo;
        }
        this.parseFormula(formulatoJava);
        return this.formulainfo;
    }

    public SymbolInfo getParameterInfo(String string) {
        SymbolInfo symbolInfo = this.datasource.getParameterType(string);
        if (symbolInfo != null) {
            symbolInfo.setSymName(symbolInfo.getSymName().toUpperCase());
        }
        return symbolInfo;
    }

    public SymbolInfo getMeasureInfo(String string) {
        return this.datasource.getMeasure(string);
    }

    public SymbolInfo getDbFieldInfo(String string) throws Exception {
        DbColDesc dbColDesc = this.datasource.getDbSQLType(string);
        int n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency());
        if (dbColDesc.isArray()) {
            n = DataTypeDef.SqlToFml(dbColDesc.getSqlType(), dbColDesc.isCurrency()) + 11;
        }
        return new SymbolInfo(dbColDesc.getColName(), null, n, -1, 2, -1, false);
    }

    public Vector getRefDbFld() {
        return this.formulainfo.refDBfield;
    }

    public Vector getRefFormuFld() {
        return this.formulainfo.refFormula;
    }

    public Vector getRefParamFld() {
        return this.formulainfo.refParameter;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String string) {
        this.name.set(string);
    }

    public String getBrokeGroup() {
        return this.brokegroup;
    }

    public void setDataSource(FormulaContainer formulaContainer) {
        this.datasource = formulaContainer;
    }

    public FormulaContainer getDataSource() {
        return this.datasource;
    }

    public Vector getGroupByVector() {
        return this.formulainfo.GroupbyNames;
    }

    public Vector getFullGroup() {
        return this.formulainfo.GroupbyNames;
    }

    public DbColDesc getColDesc() {
        if (this.coldesc == null) {
            int n = this.formulainfo.formulatype.getDataType();
            int n2 = this.formulainfo.formulatype.getPrecise();
            int n3 = this.formulainfo.formulatype.getScale();
            if (n != 10 && n != 11 && n != 9) {
                int n4 = DataTypeDef.FmlToSql(n);
                int[] nArray = MappingSQLType.getColumnProperty(n4);
                n2 = nArray[0];
                n3 = nArray[2];
            }
            this.coldesc = DataTypeDef.toDbColDesc(n, n2, n3);
            this.coldesc.setColName(this.getName());
        }
        if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
            this.coldesc.sqlType = DataTypeDef.FmlToSql(this.formulainfo.formulatype.getDataType() - 11);
            this.coldesc.setArray(true);
        }
        DbColDesc dbColDesc = (DbColDesc)this.coldesc.clone();
        dbColDesc.setArray(this.coldesc.isArray());
        return dbColDesc;
    }

    public void setColDesc(DbColDesc dbColDesc) {
        dbColDesc.setColName(dbColDesc.getColName().toUpperCase());
        this.coldesc = (DbColDesc)dbColDesc.clone();
    }

    public void execMe(JavaFormula javaFormula) {
        block3: {
            try {
                javaFormula.setCurrentExecutingFormula(this);
                DbValue dbValue = javaFormula.schedule(this.formulainfo.callee);
                if (!dbValue.toString().equalsIgnoreCase(this.expectedvalue)) {
                    System.out.println("FORMULA " + this.getName() + " ERROR!!!  result=" + dbValue.toString() + "; expected=" + this.expectedvalue);
                }
            }
            catch (Exception exception) {
                if (!FmlToSql.isErrorEnabled()) break block3;
                FmlToSql.error("", exception);
            }
        }
    }

    public void setNameCollector(NameCollector nameCollector) {
        this.nc = nameCollector;
    }

    public void parseFormula(FormulatoJava formulatoJava) throws FormulaSyntaxErrorException {
        if (this.parsed) {
            return;
        }
        if (this.parsing) {
            String string = JResource.getMessage("FML_38", (Object)this.getName());
            throw new FormulaSyntaxErrorException(this.getName(), string);
        }
        this.f2j = formulatoJava;
        try {
            formula formula2 = new formula(this, formulatoJava);
            this.parsing = true;
            if (this.nc != null) {
                String string = new StringBuffer().append(this.expr.get()).toString();
                this.nc.startParse(string);
            }
            formula2.parse();
            if (this.nc != null) {
                this.nc.endParse(false);
            }
            this.parsed = true;
            this.parsing = false;
            this.f2j = null;
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            this.parsing = false;
            if (formulaSyntaxErrorException.onlyHasWarning()) {
                this.parsed = true;
            }
            this.f2j = null;
            if (this.nc != null) {
                this.nc.endParse(true);
            }
            throw formulaSyntaxErrorException;
        }
    }

    public String getExpression() {
        return this.expr.get();
    }

    public void setExpression(String string) {
        this.parsed = false;
        this.parsing = false;
        this.expr.set(string);
    }

    @Override
    public String getPrefix() {
        return "formula";
    }

    public boolean isGroupBy(String string) {
        return this.formulainfo.GroupbyNames.contains(string.toUpperCase());
    }

    public boolean isGroupBy() {
        return this.formulainfo.GroupbyNames.size() != 0;
    }

    public boolean isGlobal() {
        return this.formulainfo.isGlobal;
    }

    @Override
    public String getFullName(boolean bl) {
        return this.name.get();
    }

    public boolean isparsedOK() {
        if (this.formulainfo == null) {
            return false;
        }
        return this.formulainfo.parseOK;
    }

    public void setParseStatus(boolean bl) {
        this.parsed = bl;
        this.parsing = false;
    }

    public boolean isSumFormula() {
        return this.formulainfo.formulatype.IsSum();
    }

    public boolean isConstant() {
        return this.formulainfo.formulatype.getAttr() == 9;
    }

    public void setFormulaInfo(FormulaInfo formulaInfo) {
        this.formulainfo = formulaInfo;
    }

    public SqlwNode getSqlWhere() throws Exception {
        if (this.formulainfo.root == null) {
            throw new Exception("cannot be translated into sql statement");
        }
        return this.formulainfo.root;
    }

    public boolean equals(JetRptFormula jetRptFormula) {
        return this.getName().equals(jetRptFormula.getName());
    }

    public boolean useSysVars() {
        return this.formulainfo.isSysVar();
    }

    public boolean isNextPrev() {
        return this.formulainfo.isNextPrev();
    }

    public boolean isFunctionCalled(String string) {
        if (string != null) {
            Vector vector = this.formulainfo.getRefBuildInFunctions();
            for (Object e : vector) {
                if (!string.equalsIgnoreCase((String)e)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean usePageVars() {
        return this.formulainfo.isUsePageVar();
    }

    public boolean isNoRecordCalled() {
        return this.formulainfo.isNoRecordCalled();
    }

    public Symbol getSyntaxTree() {
        return this.formulainfo.getSyntaxTree();
    }

    public FormulaContainer getFormulaContainer() {
        return this.datasource;
    }

    public Vector getUDFPrototypes() {
        return this.formulainfo.getUDFPrototypes();
    }

    public Vector getImportInfo() {
        return this.formulainfo.getImportInfo();
    }

    public void deny() {
        this.isDenied = true;
    }

    public void setDenyList(HashSet hashSet) {
        Vector vector = this.formulainfo.refAggregation;
        for (int i = 0; i < vector.size(); ++i) {
            Aggregation aggregation = (Aggregation)vector.elementAt(i);
            aggregation.setDenyList(hashSet);
        }
    }

    public Vector getRefMeasure() {
        return this.formulainfo.refMeasure;
    }

    public boolean isRunningTotal() {
        for (int i = 0; i < this.formulainfo.refAggregation.size(); ++i) {
            Aggregation aggregation = (Aggregation)this.formulainfo.refAggregation.elementAt(i);
            if (!aggregation.isRunningTotal()) continue;
            return true;
        }
        return false;
    }

    protected void copyTo(JetRptFormula jetRptFormula) {
        jetRptFormula.formulainfo = (FormulaInfo)this.formulainfo.clone();
        jetRptFormula.nameMapping = this.nameMapping;
        jetRptFormula.coldesc = (DbColDesc)this.coldesc.clone();
        jetRptFormula.GUIinfo = this.GUIinfo;
        jetRptFormula.brokegroup = this.brokegroup;
    }

    public JetRptFormula clone() {
        JetRptFormula jetRptFormula = new JetRptFormula(this.name.get(), this.expr.get(), this.datasource);
        this.copyTo(jetRptFormula);
        return jetRptFormula;
    }

    public void resetAggDesc() {
        if (this.formulainfo != null) {
            if (this.formulainfo.aggdesc != null) {
                this.formulainfo.aggdesc.reset();
            }
            for (int i = 0; i < this.formulainfo.refAggregation.size(); ++i) {
                Aggregation aggregation = (Aggregation)this.formulainfo.refAggregation.elementAt(i);
                if (aggregation.getAggDesc() == null) continue;
                aggregation.getAggDesc().reset();
            }
        }
    }

    public void setNameMapping(int n, Hashtable hashtable) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid map type: " + n);
        }
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        this.nameMapping[n] = hashtable;
    }

    public String getDynamicName(int n, String string) {
        if (this.nameMapping[n] == null) {
            return string;
        }
        Hashtable hashtable = this.nameMapping[n];
        if (hashtable == null) {
            return null;
        }
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public void setAggDescMap(int n, Hashtable hashtable) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid map type: " + n);
        }
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        this.aggDescMap[n] = hashtable;
    }

    public AggDesc getDynamicAggDesc(int n, AggDesc aggDesc) {
        if (this.aggDescMap[n] == null) {
            return aggDesc;
        }
        Hashtable hashtable = this.aggDescMap[n];
        if (hashtable == null) {
            return aggDesc;
        }
        AggDesc aggDesc2 = (AggDesc)hashtable.get(aggDesc);
        if (aggDesc2 == null) {
            aggDesc2 = aggDesc;
        }
        return aggDesc2;
    }

    public String toString() {
        return this.getName() + "\n" + this.expr.get();
    }
}

